/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   LeaveStatesTrail.c
*
*   This file contains the minimum required functions for maintaining a States Trail
*   in a TARGET system.
*
*-------------------------------------------------------------------------
*/


#include "common.h"
#include "gdata.h"
#include "PrintTrail.h"
#include "profile.h"
#ifdef DEBUG_TRAIL
#include "LeaveStatesTrail.h"
/*^^^
*-------------------------------------------------------------------
*   Prototype:
*   void LeaveStatesTrail(int32 l_SymbolCount, int16 s_State, int16 s_NextState, int16 s_Delimitter);
*
*   Description:
*      This function, at state transitions, stores the current state, next state and count
*      to the gsa_StatesTrail buffer.
*
*   Arguments:
*      l_SymbolCound   -- current symbol count
*      s_State         -- current state
*      s_NextState      -- current next state
*      s_Delimitter   -- marker to place into trail
*
*   Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void LeaveStatesTrail(int32 l_SymbolCount, int16 s_State, int16 s_NextState, int16 s_Delimitter)
{


   DebugTrail1(4,DEBUG_TRAIL_STATES_ENABLE,0x0000, s_Delimitter, s_State, s_NextState, (int16)l_SymbolCount);

}

/*^^^
*-------------------------------------------------------------------
*   Prototype:
*   void LeaveSubStatesTrail(int32 l_SymbolCount, int16 s_State, int16 s_NextState, int16 s_Delimitter);
*
*   Description:
*      This function, at state transitions, stores the current substate, next substate and count
*      to the gsa_StatesTrail buffer.
*
*   Arguments:
*      l_SymbolCound   -- current symbol count
*      s_SubState      -- current substate
*      s_NextSubState   -- current next state
*      s_Delimitter   -- marker to place into trail
*
*   Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void LeaveSubStatesTrail(int32 l_SymbolCount, int16 s_SubState, int16 s_NextSubState, int16 s_Delimitter)
{
   if (gt_debugTrailControl.ft_RxStateTrigger)
   {
      DebugTrail1(4,DEBUG_TRAIL_SUBSTATES_ENABLE,0x0000, s_Delimitter, s_SubState, s_NextSubState, (int16)l_SymbolCount);
   }
}

/*^^^
*-------------------------------------------------------------------
*   Prototype:
*   void LeaveToneTrail(int32 l_SymbolCount, int16 s_State, int16 s_NextState, int16 s_Delimitter);
*
*   Description:
*      This function stores the rx tone buf for tones starting from gt_debugTrailControl.s_toneIndex to
*      gt_debugTrailControl.s_toneIndex + gt_debugTrailControl.s_numTones -1
*
*   Arguments:
*
*   Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void LeaveToneTrail(int32 l_SymbolCount, int16 s_toneIndex, int16 s_numTones)
{
   int16 i, j;

   if ((gt_debugTrailControl.s_CounterPeriod != -1) && (l_SymbolCount & gt_debugTrailControl.s_CounterPeriod))
   {
      return;
   }

   DebugTrail1(1, DEBUG_TRAIL_TONE_ENABLE, 0x0000, (int16)l_SymbolCount);
   for (i = 0; i < s_numTones; i++)
   {
      j = s_toneIndex + i;
      DebugTrail1(2, DEBUG_TRAIL_TONE_ENABLE, 0x0000, (int16)(gpsa_RxToneBuf[j*2]), (int16)(gpsa_RxToneBuf[j*2+1]));
   }
}

/*^^^
*-------------------------------------------------------------------
*   Prototype:
*   void LeaveMipsTrail(int16 s_Delimitter, int16 s_State, int16 s_SubState, int16 s_AlgHandlerState)
*
*   Description:
*   Called each frame from RxForeground, this function logs and clears
*   the MIPS information on each state, substate, or algorithm state transition.
*   The result is a profile of MIPS usage over time, with the time index
*   given in terms of the rx state machine events.
*
*   Arguments:
*
*   Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

#ifdef PROFILE_TASKS
void LeaveMipsTrail(int16 s_Delimitter, int16 s_State, int16 s_SubState, int16 s_AlgHandlerState)
{
   int16 i;

   //--------------------------------------------
   // MIPS Trail is collected on rx state or substate
   // change.
   // it is sometimes useful to also collect
   // data on alg state changes or after after a
   // fixed number of frames.  These secondary
   // conditions requre a compile change.
   //--------------------------------------------
   if (gt_debugTrailControl.ft_RxStateTrigger)
   {
      DebugTrail1(8,DEBUG_TRAIL_MIPS_ENABLE,0x0000,
                  s_Delimitter, gs_TxState, s_State, s_SubState,
                  //s_AlgHandlerState,
                  //gsa_MaxMIPSTxState[TX_QT_DONE_TC_END & 0x3F], gsa_MaxMIPSTxSubState[TX_QT_DONE_TC_END & 0x3F],
                  //gsa_MaxMIPSTxState[TX_QT_DONE_NTC_END & 0x3F], gsa_MaxMIPSTxSubState[TX_QT_DONE_NTC_END & 0x3F],
                  gsa_MaxMIPSCnt[TX_QT_DONE_TC_END & 0x3F], gsa_MaxMIPSCnt[TX_QT_DONE_NTC_END & 0x3F],
                  gsa_MaxMIPSCnt[RX_QT_DONE_TC_END & 0x3F], gsa_MaxMIPSCnt[RX_QT_DONE_NTC_END & 0x3F]);
   }

   for (i=0; i<NUM_OF_PROFILE_POINTS; i++)
   {
      gsa_MaxMIPSCnt[i]=0;
   }
}

#endif //#ifdef PROFILE_TASKS

/*^^^
*-------------------------------------------------------------------
*   Prototype:
*      void LeaveTimeStampTrail(int16 s_TimeLabelId, int16 l_TxTimer, int16 l_RxTimer)
*
*   Description:
*
*   Arguments:
*
*   Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/

#ifdef PROFILE_TASKS
void LeaveTimeStampTrail(int16 s_TimeLabelId, int16 l_TxTimer, int16 l_RxTimer)
{
   if (gt_debugTrailControl.ft_RxStateTrigger)
   {
      // Log DD Snr/Fdq state info into the Time Stamp Trail
      if (s_TimeLabelId == RX_SHOWTIME_QT_DONE_NTC_START)
      {
         DebugTrail1 (3,DEBUG_TRAIL_TIMESTAMP_ENABLE,0x0000,
                      (int16)(0xFF00 | RX_SHOWTIME_QT_DONE_DDSNRFDQ_STATES),(int16)(gs_DDSnrFdqState),((int16)(gs_DDSnrState)<< 8) | (int16)gs_DDFdqState);
      }
      else
      {
         DebugTrail1 (3,DEBUG_TRAIL_TIMESTAMP_ENABLE,0x0000,
                      0xFF00 | s_TimeLabelId, (int16)(l_TxTimer), (int16)(l_RxTimer));
      }
   }
}

#endif //#ifdef PROFILE_TASKS

#else //DEBUG_TRAIL
   /*Suppress compiler warning:
   *"A program must contain at least one external-declaration (X3.159-1989 p.82,L3)"
   *by adding a dummy function declaration
   */
   void DummyFunctionLeaveStatesTrail( void )
   {
   }
#endif //DEBUG_TRAIL
