/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   PGAHandler.c
 *
 *   This file contains the routine that handles the PGA computation.
 *
 *------------------------------------------------------------------------
 */
// ***********************************************************************************************************
// PGAHandler.c
//
// History
//
// 12/04/2013 Fuss: Solve link problems in vectoring on long loops
//            XDSLRTFW-793 RP-Synch not detected / Tone cluster not detected (due to "fast LOS" / Pilot-tone scaling)
//            Grep for  "XDSLRTFW-793: RP-Synch not detected / Tone cluster not detected"
//
//
// ************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "fifo.h"
#include "PGAHandler.h"
#include "vecpwr.h"
#include "PsdHandler.h"
#include "ConvertToDB.h"
#include "afe.h"
#include "V_STR_IOf.h"
#include "decimalgain.h"
#include "cmv.h"
#include "cmv_Data.h"
#include "TxPSDControl.h"
#include "vdsl_state.h"
#include "mul.h"
#include "V_STR_IIR_IOf.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "ft_memmap.h"
#include "LL_IOf.h"

#include "AFED_Functions.h"
#include "PsdHandler_HybTrn.h"

extern void SetPGA();
#ifdef VR9_PGA_CALIB_DEBUG
extern int16 gs_BPRxStateTrigger;
extern int16 gs_BPSubStateTrigger;
extern int16 gs_BPSubStateCntTrigger;
#endif //VR9_PGA_CALIB_DEBUG


#define EXTRA_WAIT_TIME              1
#define PGA_PLL_REFTONE_AVG_SYMBOLS  4

void PGAHandler(void)   //for VRX518 AFE
{
   int32 l_AvRxFreqPwrLin;
   int16 s_gain;

#ifdef VR9_BRINGUP_DBG
   if(gft_BypassPGATrain == TRUE)
   {
      gs_PgaHandlerState = PGA_DONE;
      return;
   }
#endif //#ifdef VR9_BRINGUP_DBG

   switch (gs_PgaHandlerState)
   {
      //==============================================================================
      // Initialize variables for PGA Training
      //==============================================================================
   case PGA_INIT:
      // Note: PGA_INIT is also called from PGA_CALC and PGA_WAIT.
      //       PGA_CALC - in case of PGA or PREFI clipping
      //       PGA_WAIT - in case of enabled Double PGA Training
      //       Therefore the guc_PgaState must be checked here!
      if (guc_PgaState == TRAINING_DONE)
      {
         if (gft_BypassRxAFE_HPF == TRUE)
         {
            gft_EnableDoublePGATrain = FALSE;   // if AFE Rx HP2 bypass then disable double train
         }
         else
         {
            gft_EnableDoublePGATrain = TRUE;
         }

         if(gft_EnableDoublePGATrain == TRUE)
         {
            if(gs_PgaHandlerRun == 0)
            {
               // AGC1 Training
               AddFunctionToFifo(gp_RxLoadingFunctionFifo, AFED_InitAFE_RegsPGA);
            }
            else // if( gs_PgaHandlerRun == 1)
            {
               // AGC2 Training
               AddFunctionToFifo(gp_RxLoadingFunctionFifo, AFED_RestoreAFE_RegsforAGC2);
            }
         }
         else
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, AFED_InitAFE_RegsPGA);
         }

         guc_PgaState = TRAINING_IN_PROGRESS;

         // Debug PGA info for Tracee!
         gs_RxVarGainDB_Dbg = gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB;

         // set the RX IIR filter unity
         // Note: gs_PgaHandlerRun is 0 for both PGA1 training as well as PGA1&2 combined training
         if(gs_PgaHandlerRun == 0)
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, UnityRxIIR);

            // set the decimation filter to unity
            // (note1: the bypass mode seems not work properly in HW.
            //  note2: the noise above the decimation filter cutoff frequency is relativly low
            //         so it's probably ok not to count for it)
//            AddFunctionToFifo(gp_RxLoadingFunctionFifo, UnityDecimFIR);

            // Set RxVarGain to 0dB
            gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB = 0;
            LoadRxVarGain();
         }

         gs_AlgHandlerCount = 0;

         //overflow check not required since PGA1 training start with -18dB, at this gain
         //overflow is not expected
         gs_PgaHandlerState = PGA_ACCURATE_TRAIN_START;
      }
      break;

   case PGA_ACCURATE_TRAIN_START:

      if (guc_PgaState == TRAINING_DONE)
      {
         // XDSLRTFW-3922 (Start_End)
         // Adding 1 additional symbol to settle the HW for RxVarGain, i.e. function LoadRxVarGain().
         if (gs_AlgHandlerCount < (gs_HwSettleTime + EXTRA_WAIT_TIME))
         {
            gs_AlgHandlerCount++;
         }
         else
         {
            gs_AlgHandlerCount = 0;

            // save original AlgLog2NumFramesToAccum
            gs_PsdAlgLog2NumFramesToAccum_Saved = gt_PsdConfig.s_AlgLog2NumFramesToAccum;

            // Initialize vars for PSD calculation
            gt_PsdConfig.s_AlgLog2NumFramesToAccum = gc_Log2NumFramesToAccumForPGA;

            gs_AlgHandlerState = PSD_INIT;
            // do not overwrite measured buffer (usually SNR buffer)
            // i.e., per-tone PSD will not be kept
            gt_PsdConfig.s_AlgCalcType = PSD_CALC_TYPE_NOMSRDBUFF;
            if (gft_PSD_CALC_TYPE_INITMSRDBUFF_AND_INC)
            {
               gt_PsdConfig.s_AlgCalcType = PSD_CALC_TYPE_INITMSRDBUFF_AND_INC;
            }
            gft_PSD_CALC_TYPE_INITMSRDBUFF_AND_INC = FALSE;

            gs_PgaHandlerState = PGA_CALC;
            // grab a new reference
            if ((gft_StartHybTrn == 1) && (gs_PgaHandlerRun == 1))
            {
               // XDSLRTFW-3280/XDSLRTFW-3835 - Start - PLL improvement / pilot tone selection improvement
               // Note: Normally the code is conflicting with FG fct. MultiPilotUpdate().
               //       But it is working, because the Pilot tone is not changing during the Pga- and HybridTrainingHandler() and
               //       the fct. MultiPilotUpdate() contains the following if-case in the state "PLL_AVG_IDLE":
               //       -  if (gt_PilotConfig.te_UsedPTArrayIdx != gt_PilotConfig.te_BestPTArrayIdx)
               //       Therefore it must be taken care that MultiPilotUpdate() stays in the IDLE state, i.e. in a kind of bypass.
               //       The only possible is to set the variable "gs_PLLAvgHandlerState" back to "PLL_AVG_IDLE" at the end of operation,
               //       because fct. ComputePLLRefAvg() is changing the variable "gs_PLLAvgHandlerState" to "PLL_AVG_DONE".
               //
               //       Due to gt_PilotConfig.ta_PilotTones[PilotIdx].ft_DeRotatePilot the gt_PilotConfig.ta_PilotTones[0].s_PilotTone_Re
               //       and gt_PilotConfig.ta_PilotTones[0].s_PilotTone_Imag cannot be used directly, i.e. always the fct. ComputePLLRefAvg()
               //       must be called.
               //       Also no "Data On pilot" is available the flag "ft_DeRotatePilot" can stay set, because constellation is
               //       is not changing during ChannelDiscovery and TransceiverTraining.
               {
                  gs_PLLAvgHandlerCnt = 0;
                  gla_AvgRefPilotToneReal[0] = 0;
                  gla_AvgRefPilotToneImag[0] = 0;
                  gla_AvgRefPilotToneReal[1] = 0;
                  gla_AvgRefPilotToneImag[1] = 0;
                  gla_AvgRefPilotToneReal[2] = 0;
                  gla_AvgRefPilotToneImag[2] = 0;

                  ComputePLLRefAvg(PT_ARRAY_IDX_0, &gsa_AvgRefPilotToneReal[PT_ARRAY_IDX_0], &gsa_AvgRefPilotToneImag[PT_ARRAY_IDX_0],PGA_PLL_REFTONE_AVG_SYMBOLS,2);
                  gs_PLLAvgHandlerCnt--;  //adjustment for multiple call of ComputePLLRefAvg in one symbol
                  ComputePLLRefAvg(PT_ARRAY_IDX_1, &gsa_AvgRefPilotToneReal[PT_ARRAY_IDX_1], &gsa_AvgRefPilotToneImag[PT_ARRAY_IDX_1],PGA_PLL_REFTONE_AVG_SYMBOLS,2);
                  gs_PLLAvgHandlerCnt--;  //adjustment for multiple call of ComputePLLRefAvg in one symbol
                  ComputePLLRefAvg(PT_ARRAY_IDX_2, &gsa_AvgRefPilotToneReal[PT_ARRAY_IDX_2], &gsa_AvgRefPilotToneImag[PT_ARRAY_IDX_2],PGA_PLL_REFTONE_AVG_SYMBOLS,2);
                  gs_PLLAvgHandlerState = PLL_AVG_IDLE; // This code is needed due to FG fct. MultiPilotUpdate(). See Note above!
               }

               gs_PgaHandlerState = PGA_RESET_PLL_REF;
            }
         }
      }
      break;

   case PGA_RESET_PLL_REF:
      {
         if (gs_PLLAvgHandlerCnt < (PGA_PLL_REFTONE_AVG_SYMBOLS+1))
         {
            // compute average for reference, as sometimes reference could be noisy
            ComputePLLRefAvg(PT_ARRAY_IDX_0, &gsa_AvgRefPilotToneReal[PT_ARRAY_IDX_0], &gsa_AvgRefPilotToneImag[PT_ARRAY_IDX_0],PGA_PLL_REFTONE_AVG_SYMBOLS,2);
            gs_PLLAvgHandlerCnt--;  //adjustment for multiple call of ComputePLLRefAvg in one symbol
            ComputePLLRefAvg(PT_ARRAY_IDX_1, &gsa_AvgRefPilotToneReal[PT_ARRAY_IDX_1], &gsa_AvgRefPilotToneImag[PT_ARRAY_IDX_1],PGA_PLL_REFTONE_AVG_SYMBOLS,2);
            gs_PLLAvgHandlerCnt--;  //adjustment for multiple call of ComputePLLRefAvg in one symbol
            ComputePLLRefAvg(PT_ARRAY_IDX_2, &gsa_AvgRefPilotToneReal[PT_ARRAY_IDX_2], &gsa_AvgRefPilotToneImag[PT_ARRAY_IDX_2],PGA_PLL_REFTONE_AVG_SYMBOLS,2);
            gs_PLLAvgHandlerState = PLL_AVG_IDLE;  // This code is needed due to FG fct. MultiPilotUpdate(). See Note above, at switch-case "PGA_ACCURATE_TRAIN_START"!
         }
         else
         {
            // Set new Pll RefTone for all 3 supported pilot tones
            ResetPllRefTone(PT_ARRAY_IDX_0, NULL, &gsa_AvgRefPilotToneReal[0], &gsa_AvgRefPilotToneImag[0], (int16)3);
            gft_EnablePLL = 1; // Turn on PLL
            // XDSLRTFW-3280/XDSLRTFW-3835 - End - PLL improvement / pilot tone selection improvement

            gs_PgaHandlerState = PGA_CALC;
         }
      }
      break;

      //==============================================================================
      // Calculate and set PGA by using PsdHandler() and BgSetPGA()
      //==============================================================================
   case PGA_CALC:

      if (gs_AlgHandlerState != PSD_CALC_DONE)
      {
         // Note: The PgaTraining for the best Hybrid + best CAP should be done
         //       with the normal PsdHandler().
         if (((gft_StartHybTrn==1) && (!(gs_HybTrFinishUp))) && (gt_PsdConfig.s_AlgLog2NumFramesToAccum==0) &&
               (!(gs_PgaTrainingDbg & TEST_HP2_CONFIG_PSD_HANDLER_SWITCH)))
         {
            //check that no averaging is done to use the code below
            PsdHandler_HybTrn();
         }
         else
         {
            PsdHandler();
         }
      }
      else
      {
         int16 s_GainPga_dB;                      // 16.0 format

         s_GainPga_dB = gsa_gain_pga_dB[gus_AFE_RxMode];

         if (gft_StartHybTrn==1)
         {
            gft_EnablePLL = 0;   // Turn off PLL
         }

         l_AvRxFreqPwrLin = gl_Pa;

         // Compute average Freq domain power
         gs_AvRxTimePwr = ConvertToDB(l_AvRxFreqPwrLin);

         // The average symobl energy (per sample) at the input of the ADC
         // All gains from AFE interface to FFT
         //s_gain = gs_RxFftGain_dB + gs_RxVarGainDB + gs_RxAdcAdjustGain_dB;
         s_gain = gt_DfeAfeGainSettings.s_Rx_FFT_Gain_Rms_dB + gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB + gt_DfeAfeGainSettings.s_Rx_Total_TdqToAfeInterface_Gain_dB + gsa_PgaCorrection;
         gs_AvRxTimePwr = gs_AvRxTimePwr - s_gain;

         // The power of the highest tone (per sample) at the input of the ADC
         gs_MaxRxTonePwr = gs_MaxRxTonePwr - s_gain;

         // Compute optimal PGA to maximize ADC dynamic range.
         {
            int16 s_PGA_margin;
            int16 s_PD;
            s_PD = PD_DB;
            if (gs_PgaHandlerRun == 0)
            {
               s_PGA_margin = gs_PGA_margin_AGC1;
            }
            else // if(gs_PgaHandlerRun == 1)
            {
               s_PGA_margin = gs_PGA_margin_AGC2;
//               if (s_PGA_margin < PGA_ANALOG_MARGIN_TO_AVOID_DIGITAL_CLIPPING)
//               {
//                  s_PGA_margin = PGA_ANALOG_MARGIN_TO_AVOID_DIGITAL_CLIPPING;
//               }
            }
            gs_PGA_required = s_PD - gs_AvRxTimePwr - s_PGA_margin;
            // This variable is used only for debugging.
            gs_PGA_required_Pre = gs_PGA_required;
         }

         guc_PgaState = TRAINING_IN_PROGRESS;

         if(gft_EnableDoublePGATrain == TRUE)
         {
            gs_AGC2_compensation =(gs_AGC2_Gain_Set << 8);
            // gs_PGA_required = PD_DB - gs_AvRxTimePwr - gs_PGA_margin + gs_AGC2_compensation;
            gs_PGA_required += gs_AGC2_compensation;

            if (gs_PgaHandlerRun == 0)
            {
               // gs_PGA_required = PD_DB - gs_AvRxTimePwr - gs_PGA_margin + gs_AGC2_compensation + 8dB;
               // The 8dB are for the consideration of the 1.5Vp to 0.6Vp between AGC1 output to ADC input!
               //gs_PGA_required = gs_PGA_required - PREFI_BYPASS_GAIN;
               gs_PGA_required = gs_PGA_required - (gsa_gain_prefi_dB[BYPASSED] << 8) + ((gs_AGC1_Gain_Set<<8) - gs_AGC1_margin);
               AFED_CalcAGC1(gs_PGA_required);

               if( (gs_PgaHandlerStopAtPga1Pga2 & 0x20) && (gs_RxState == gs_RxStateToStop) &&  ((gs_RxSubStateToStop == -1) || (gs_RxSubState == gs_RxSubStateToStop)) )
               {
                  gs_PgaHandlerState = PGA_DONE;
                  break;
               }

               if( (gs_PgaHandlerStopAtPga1Pga2 & 4) && (gs_RxState == gs_RxStateToStop) &&  ((gs_RxSubStateToStop == -1) || (gs_RxSubState == gs_RxSubStateToStop)) )
               {
                  Pause(0x7A04);
               }

               // If AGC1 gain required < -9dB, then use these special Hybrid Settings to provide another -9dB attenuation
               // before AGC1 block.
               if ((gs_PGA_required < (s_GainPga_dB<<8)) && (gft_StartHybTrn==1))
               {
                  // Update the Hybrid Buffer with special Hybrid settings & Load special Hyb settings
                  // Note: SetHybrid_VR9 is setting "guc_PgaState = TRAINING_DONE;"
                  AFED_UpdateHybridBuffer();
                  AddFunctionToFifo(gp_RxLoadingFunctionFifo, AFED_SetHybrid);
                  // XDSLRTFW-3668 (Start_End)
                  // Do a new PGA training with special Hybrid. This is done to avoid a very low PGA setting.
                  // Example: If the required PGA Setting is -10dB, then the PGA stays on -9 as configured with InitAFE_RegsPGA.
                  //          On top the additionally attenuation is added comming from the Special hybrid (around -11dB).
                  //          So the final PGA Setting (including "Special hybrid") is -20dB.
                  //          In this case, it would be better to use the Special hybrid (-11dB) and a PGA Setting of 1dB.
                  gs_PgaHandlerState = PGA_INIT;
                  break;
               }
            }
            else
            {
               AFED_CalcAGC2(gs_PGA_required);
               if( (gs_PgaHandlerStopAtPga1Pga2 & 8) && (gs_RxState == gs_RxStateToStop) &&  ((gs_RxSubStateToStop == -1) || (gs_RxSubState == gs_RxSubStateToStop)) )
               {
                  Pause(0x7A08);
               }


               // The code is needed for ACE-on and Prefi requires a gain < -16dB to avoid clipping at ADC input!
               // But clipping at ADC input due to lack of Prefi attenuation (min -16dB) should --- not --- be considered for
               //    - PGA before HybridHandler (-> "gl_HybTrSymcnt_start")
               //    - During best hybrid CAP search (-> "guc_EnableHybCapacitorSearch")
               //      Note: But it should be considered at final PGA training for "best hybrid + best cap" and also for
               //            PGA trainings after the Hybrid training.
               //            Since the variable "guc_EnableHybCapacitorSearch" stays set the additional variable must be used "gs_HybTrFinishUp".
               {
                  uint32 ul_HybTrStart;
                  int16 s_Force_PrefiAceMode;

                  s_Force_PrefiAceMode = TESTArray[TEST_DS_ACE];

                  ul_HybTrStart = (uint32)gl_HybTrSymcnt_start;
                  if (s_Force_PrefiAceMode & TEST_DS_ACE_PGA_DIS)
                  {
                     ul_HybTrStart = (uint32)FALSE;
                     gs_AGC2_Gain_Set = AFED_AGC2_MIN_PGA;
                     gs_PGA_set = ((gs_AGC1_Gain_Set + gs_AGC2_Gain_Set) << 8); //8.8 format
                  }
                  else if (s_Force_PrefiAceMode & TEST_DS_ACE_HYB_ONLY_EN)
                  {
                     // ACE step down logic only active for Hybrid training
                     // Note: First implementation (Changeset 8450)!
                     //       - ACE switch down only during the Hybrid training.
                     //       - If clipping was detected during PREFI training, a second PREFI training
                     //         was exectued with lowered ACE mode.
                     //       - For next hybrid the original ACE mode was restored.
                     ul_HybTrStart = (uint32)gft_StartHybTrn;
                  }

                  // Check, if prefi gain is not sufficient and clipping is expected!
                  // Note: Clipping should not be checked before the start of hybrid training.
                  //       Hlog and Qln should not be influenced!
                  if ((gs_AGC2_Gain_Set < AFED_AGC2_MIN_PGA) && (ul_HybTrStart > 0))
                  {
                     int16 s_AceSwitchDown, s_AceModePrev;

                     s_AceSwitchDown = FALSE;
                     if (s_Force_PrefiAceMode & TEST_DS_ACE_HYB_ONLY_EN)
                     {
                        s_AceSwitchDown = TRUE;
                     }
                     else if (s_Force_PrefiAceMode & TEST_DS_ACE_FINAL_DIS)
                     {
                        // Second implementation as the first one,  but not only for the Hybrid training, i.e.
                        // now also for PGAs after the Hybrid training (Changeset 8534).
                        // To test this previous implementation the CMV bit "TEST_DS_ACE_FINAL_DIS" was added.
                        // To be removed when implemenation/tests are settled!
                        if (!((guc_EnableHybCapacitorSearch & CHANGE_CAP_SEARCH_START) && (gs_HybTrFinishUp == 0)))
                        {
                           s_AceSwitchDown = TRUE;
                        }
                     }
                     else
                     {
                        // When Prefi requires a gain < -16dB for ACE on to avoid clipping at ADC input!
                        // But clipping at ADC input due to lack of Prefi attenuation (min -16dB) should -- not -- be considered for
                        // - PGA before HybridHandler (-> "gl_HybTrSymcnt_start")
                        // - During "hybrid"- and "best hybrid Cap"-search
                        //   Note: But it should be considered at final PGA training for "best hybrid + best cap" and also for
                        //         PGA trainings after the Hybrid training.
                        s_AceSwitchDown = gs_HybTrFinishUp;
                     }

                     // ACE clipping logic to switch the ACE mode down!
                     {
                        int16 s_MissingGain, s_AceMode;

                        // Calculate the missing gain.
                        // Note: Round up, i.e. do not consider small decimal numbers of 0.03125dB.
                        //       At this point is always smaller than (<) -16dB. Therefore the value
                        //       range is positive and integer, i.e. [0,1,..,N].
                        //       This change was discussed with Villach. Such small overshooting should be covered by
                        //       the 2dB Prefi margin and are most likely measurement tolerances.
                        s_MissingGain = (AFED_AGC2_MIN_PGA - ((gs_PGA_required + gs_AceSwitchDownRounding) >> 8));       // integer format, i.e. NO Q8.8

                        s_AceMode = gs_PrefiAceMode_Selected;
                        s_AceModePrev = s_AceMode;

                        if (s_MissingGain > 0)
                        {
                           // Do not switch ACE off, when it can be resolved by switching down PGA1 by one dB!
                           // Note: ACE brings around 3dB boost on high frequencies.
                           if ((gus_DebugControlVRX518 & PGA1_SWITCH_NO_ACE_SWITCH) && (s_AceMode < ACE_OFF) &&
                            (s_MissingGain <= 1) && (gs_AGC1_Gain_Set > AFED_AGC1_PGA_MINUS_6DB) && gl_HybTrSymcnt_end)
                           {
                              // Set new value for PGA1 (AGC1).
                              gs_AGC1_Gain_Set -= 1;
                              AddFunctionToFifo(gp_RxLoadingFunctionFifo, AFED_SetPga1);
                              // Set to min value to avoid exception!
                              gs_AGC2_Gain_Set = AFED_AGC2_MIN_PGA;
                              gs_PGA_set = ((gs_AGC1_Gain_Set + gs_AGC2_Gain_Set) << 8); //8.8 format
                              // Set out off range to pass if-case.
                              s_AceModePrev = ACE_MODE_MASK;
                           }
                           else
                           {
                              // Rough estimated ACE gain boost for 17A.
                              // ACE mode 0 to 1 -> 3.0dB
                              //          1 to 2 -> 4.0dB
                              //          2 to 3 -> 3.0dB   4dB 35b
                              //          3 to 4 -> disable
                              int16_t sa_AceGain[] = {(int16)-3, (int16)-4, (int16)-3, (int16)-30};
                              while ((s_MissingGain > 0) && (s_AceMode < ACE_OFF))
                              {
                                 s_MissingGain += sa_AceGain[s_AceMode];
                                 s_AceMode++;
                              }

                              // This code is a plain security code!
                              // Normally it is not needed.
                              if (s_AceMode > ACE_OFF)
                              {
                                 s_AceMode = ACE_OFF;
                              }
                           }
                        }
                        else
                        {
                           s_AceSwitchDown = FALSE;
                        }

                        // Note: This is needed to fillup the ACE array "gsa_AceModeforHybridSelected[gs_HybTrMaxIndex]"
                        //       during Hybrid training and for correct Tracee streaming below!
                        gs_PrefiAceMode_Selected = s_AceMode;
                     }

                     // Do not execute for CAP search, but at final PGA training "best hybrid + best cap".
                     // Further it should be considered for PGA trainings after Hybrid training.
                     if (s_AceSwitchDown)
                     {
                        // XDSLRTFW-3576, XDSLRTFW-3594
                        // Note: This fix is to avoid link holes, knowing that the fix implies a performance impact.
                        //       When the PGA1 gain is not sufficient too, then an "E_CODE_AFE_EXCEPTION" gets be triggered!
                        if ((gus_DebugControlVRX518 & PREFI_GAIN_OVERSHOOT_PGA1_SWITCH) &&
                            (s_AceModePrev == ACE_OFF) && (gs_AGC1_Gain_Set > s_GainPga_dB))
                        {
                           gs_AGC1_Gain_Set -= (AFED_AGC2_MIN_PGA - gs_AGC2_Gain_Set);        // 16.0 format
                           // Check HW constain for the range between -6dB and -9dB. Due to a single 3dB step
                           // the values -7 and -8dB are not possible and must be mapped to -9dB.
                           if ((gs_AGC1_Gain_Set < AFED_AGC1_PGA_MINUS_6DB) && (gs_AGC1_Gain_Set > s_GainPga_dB))
                           {
                              gs_AGC1_Gain_Set = s_GainPga_dB;
                           }
                           AddFunctionToFifo(gp_RxLoadingFunctionFifo, AFED_SetPga1);

                           // Set out off range to pass if-case.
                           s_AceModePrev = ACE_MODE_MASK;
                        }

                        // Debug PGA clipping info for Tracee!
                        {
                           DshHwConfEventPga_t tmpDshConf;

                           tmpDshConf.s_PgaHandlerRun = gs_PgaHandlerRun;
                           tmpDshConf.ft_StartHybTrn = gft_StartHybTrn;
                           tmpDshConf.uc_HybTrIndex = (uint8) gs_HybTrIndex;
                           tmpDshConf.s_AvRxTimePwr = gs_AvRxTimePwr;
                           tmpDshConf.s_MaxRxTonePwr = gs_MaxRxTonePwr;
                           tmpDshConf.s_PGA_required_Pre = gs_PGA_required_Pre;
                           tmpDshConf.s_PGA_required = gs_PGA_required;
                           tmpDshConf.s_AGC1_Gain_Set = gs_AGC1_Gain_Set;
                           tmpDshConf.s_AGC2_Gain_Set = gs_AGC2_Gain_Set;
                           tmpDshConf.s_RxVarGainDB = gs_RxVarGainDB_Dbg;
                           tmpDshConf.s_PrefiAceMode_Selected = gs_PrefiAceMode_Selected;

                           DSH_SendEvent(DSH_EVT_PGA_RECONFIGURE_VRX518,sizeof(DshHwConfEventPga_t),&tmpDshConf);
                        }

                        // XDSLRTFW-3583 : Wrong exception gets be triggered, when PREFI attenuation is not sufficient
                        // Details:
                        //    Do a new Prefi Training with reduced ACE mode only, when the ACE mode was swichted down.
                        //    When ACE
                        //         - is alread switched down to off or
                        //         - is by default off, as for long loops
                        //    and still clipping is available, then the "E_CODE_AFE_EXCEPTION" must be triggered.
                        //    Previously an endless-state change happened until "E_CODE_RX_STATE_TIMEOUT" gets be triggered.
                        //
                        //    Note: It is better to have a fail, instead of not known CRC problems in showtime.
                        if (gs_PrefiAceMode_Selected != s_AceModePrev)
                        {
                           // Do new Prefi training with reduced ACE mode or PGA gain.
                           // Note: For the ACE switch down the guc_PgaState must be set to "TRAINING_DONE".
                           //       Otherwise the check at PGA_INIT will fail and the link cannot come to showtime, i.e. stuck with E_CODE_TX_STATE_TIMEOUT.
                           if (s_AceModePrev != ACE_MODE_MASK)
                           {
                              guc_PgaState = TRAINING_DONE;
                           }
                           gs_PgaHandlerState = PGA_INIT;
                           break;
                        }
                     }
                     else
                     {
                        gs_AGC2_Gain_Set = AFED_AGC2_MIN_PGA;
                        gs_PGA_set = ((gs_AGC1_Gain_Set + gs_AGC2_Gain_Set) << 8); //8.8 format
                     }
                  }
               }
            }

            AddFunctionToFifo(gp_RxLoadingFunctionFifo, AFED_SetPga);
         }
         else
         {
            // Compute optimal PGA to maximize ADC dynamic range.
            //gs_PGA_required = PD_DB - gs_AvRxTimePwr + gs_PGA_set - gs_PGA_margin - gs_ADCGain;
            gs_PGA_required += gs_PGA_set;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)AFED_BgSingleStagePGASetting);
         }

         gs_AlgHandlerCount = 0;  // XDSLRTFW-3922(Start_End)
         gs_PgaHandlerState = PGA_WAIT;
      }
      break;

      //==============================================================================
      // Wait for PGA/ RX filter corner to settle
      //==============================================================================
   case PGA_WAIT:

      if (guc_PgaState == TRAINING_DONE)
      {
         // XDSLRTFW-793, XDSLRTFW-3922 (Start_End)
         // RxVarGain is not set, when the measurement in the HybridTrainingHandler takes place.
         // Therefore the first pilot tone value was wrong, which led to a wrong FastLoss threshold.
         // Adding 1 additional symbol to settle the HW resolves the problem, i.e. function LoadRxVarGain()
         // is called at gs_AlgHandlerCount == 0 instead of 1.
         if (gs_AlgHandlerCount == 0)
         {
            // Compute optimal RxVarGain
            // Background: This is done to scale the input signal to the FFT directly to the corrected range,
            //             so that no freq domain clipping will happen!
            //             1) Take into account the digital gain discrepancy between gs_PGA_required and gs_PGA_set, i.e. fractional part
            //                which cannot be configured into HW.
            //             2) Take the max (peak) tone power compared to average tone power into account.
            //                Note:
            //                   Both values must be tone power, i.e. average power must be divided by num tones (gs_RxLog2FftLength-1).
            //                   This is the case and done in fct. PsdCalc_HybTrn()
            if (gft_UnityRxVarGain)
            {
               gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB = 0;
            }
            else
            {
               // Change RxVarGain only at the end of PGA training
               if ((gft_EnableDoublePGATrain == FALSE) || (gs_PgaHandlerRun == 1))
               {
                  // Note: gs_PGA_set = gs_AGC1_Gain_Set + gs_AGC2_Gain_Set.
                  //       But gs_PGA_required contains only the gs_AGC2_Gain_Set!
                  if (gs_PgaHandlerRun == 1)
                  {
                     gs_PGA_required += (gs_AGC1_Gain_Set << 8); // Add PGA1 training gain
                  }

                  // XDSLRTFW-3897(Start)
                  if(gt_Reconf_Hybrid_Coeff.s_control & USE_RX_POWER_INSTEAD_OF_RX_AMPL_FOR_RXVARGAINCONFIG)
                  {
                     gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB = (gs_PGA_required - gs_PGA_set);
                  }
                  else
                  {
                     gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB = (gs_AvRxTimePwr - gs_MaxRxTonePwr) + (gs_PGA_required - gs_PGA_set);
                  }
                  // XDSLRTFW-3897(End)
               }
            }

            //Apply the RX vargain margin to avoid the frequency clipping
            gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB -= gs_RxVarGainMarginDB;
            LoadRxVarGain();
         }

         if (gs_AlgHandlerCount < (gs_HwSettleTime + EXTRA_WAIT_TIME))  // PGA settling time
         {
            gs_AlgHandlerCount++;
         }
         else
         {
            gs_AlgHandlerCount = 0;
            // restore original AlgLog2NumFramesToAccum
            gt_PsdConfig.s_AlgLog2NumFramesToAccum = gs_PsdAlgLog2NumFramesToAccum_Saved;

            if(gft_EnableDoublePGATrain == TRUE)
            {
               if(gs_PgaHandlerRun == 0)
               {
                  gs_PgaHandlerState = PGA_INIT;

                  if( (gs_PgaHandlerStopAtPga1Pga2 & 1) && (gs_RxState == gs_RxStateToStop) &&  ((gs_RxSubStateToStop == -1) || (gs_RxSubState == gs_RxSubStateToStop)) )
                  {
                     Pause(0x7A01);
                  }
                  gs_PgaHandlerRun = 1;
               }
               else
               {
                  gs_PgaHandlerState = PGA_DONE;
                  if( (gs_PgaHandlerStopAtPga1Pga2 & 2) && (gs_RxState == gs_RxStateToStop) &&  ((gs_RxSubStateToStop == -1) || (gs_RxSubState == gs_RxSubStateToStop)) )
                  {
                     Pause(0x7A02);
                  }
                  gs_PgaHandlerRun = 0;
               }
            }
            else
            {
               gs_PgaHandlerState = PGA_DONE;
            }

            //Restore RxIIR filter at the end of PGA2 training
            if(gs_PgaHandlerState == PGA_DONE)
            {
               AddFunctionToFifo(gp_RxLoadingFunctionFifo, RestoreRxIIR);
            }

         }
      } //if (guc_PgaState == TRAINING_DONE)
      break;

   default:
      break;

   } //switch
} //PGAHandler

void BgAdjustQlnForPga(void)
{
   int16 i;
   int16 s_temp;
   int16 *psa_SnrBuf;

   // Note: "gs_PGA_set_Qln" and "gs_RxVarGainDB_Qln" during Qln PSD computation
   // We also invert Qln PSD so that we can add this value to signal PSD to get SNR
   s_temp = (gs_PGA_set - gs_PGA_set_Qln) + (gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB - gs_RxVarGainDB_Qln)+ (gs_HybridGain - gs_HybridGain_Qln);

   psa_SnrBuf = gpsa_MeasuredSnrBuf;

   for (i = 0; i < gs_RxNumTones; i++)
   {
      *psa_SnrBuf = - (*psa_SnrBuf + s_temp);
      psa_SnrBuf++;
   }

   gs_RxBkgdProcessFlag = TRAINING_DONE;
}


/*
 *------------------------------------------------------------------------
 *
 *   InvDB calculates the invers of dB, means the linear value of dB for
 *   power
 *
 *   InvDB = 10^(dB/10)
 *
 *   The algorith changes the input variable from power of 10 to power of 2
 *   10^z = 2^(ln10/ln2)*z;  y = ln10 / ln2 * x
 *   The integer part of y ( n = int(y) ) is used to shift a 1 representing a power of 2
 *   The fractional part of y (x = floor(y) ) is used for a linear interpolation between two powers of 2
 *
 *   Hence InvDB = 10^(dB/10) is approximated by (2^n)*(1+x)
 *   The approximation error is < 0.5dB
 *------------------------------------------------------------------------
 */
#define con (849);   //  ln10/ln2 in Q8.8

void LoadRxVarGain()
{
   db_to_linear(gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB, &gs_RxVarGain, &gs_RxVarGainExp);

   // Exponent (gs_RxVarGainExp) should be >=-4 && <= 3.
   // If not, limit it while adjusting mantissa (gs_RxVarGain) appropriately
   if (gs_RxVarGainExp < -4)
   {
      gs_RxVarGain = gs_RxVarGain >> (-4-gs_RxVarGainExp);
      gs_RxVarGainExp = -4;
   }
   else if (gs_RxVarGainExp > 3)
   {
      gs_RxVarGain = 32767;
      gs_RxVarGainExp = 3;
      gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB = 18<<8;
   }

   AddFunctionToFifo(gp_RxLoadingFunctionFifo,SetRxVarGain);
}

// XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ComputePLLRefAvg
 *
 *  Prototype:  void ComputePLLRefAvg(PT_ArrIdx_te PilotIdx, int16 *ps_real, int16 *ps_imag, uint16 us_NumSymbolsAvg, uint16 us_Log2_NumSymbolsAvg)
 *
 *   This function averages over #us_NumSymbolsAvg symbols the pilot tone.
 *   NOTE: us_NumSymbolsAvg must be be a mutliple of 2
 *   Note: us_Log2_NumSymbolsAvg must be log 2 of us_NumSymbolsAvg
 *   The average gets be compute as reference, because sometimes reference could be noisy.
 *
 *  Input Arguments:   int16 *ps_real, i.e. &gsa_AvgRefPilotToneReal
 *                     int16 *ps_imag, i.e. &gsa_AvgRefPilotToneImag
 *                     uint16 us_NumSymbolsAvg, the number of symbols over which
 *
 *  Output Arguments:  int16 *ps_real, i.e. &gsa_AvgRefPilotToneReal
 *                     int16 *ps_imag, i.e. &gsa_AvgRefPilotToneImag
 *
 *   Return:
 *      None
 *
 *  Global Variables Used:
 *      gt_PilotConfig.ta_PilotTones[0].s_PilotTone_Re     -- (I)   real part of the pilot tone
 *      gt_PilotConfig.ta_PilotTones[0].s_PilotTone_Im      -- (I)   imag part of the pilot tone
 *      gla_AvgRefPilotToneReal -- (I/O) summed real part value of the 4 symbols
 *      gla_AvgRefPilotToneImag -- (I/O) summed imag part value of the 4 symbols
 *
 *  Notes:
 *      The function can only be used with following constrains:
 *         1) phases where the quadrant scrampler is operating in reset mode
 *         2) pilot tones which are even, i.e. gets not be modulated
 *      -> Common rule: The pilot tone must always lie in the same quadrant.
 *                      Therefore in case of DataOnPilot it must be rotated into the first quadrant!
 *
 *------------------------------------------------------------------------
 *^^^
 */
void ComputePLLRefAvg(PT_ArrIdx_te PilotIdx, int16 *ps_real, int16 *ps_imag, uint16 us_NumSymbolsAvg, uint16 us_Log2_NumSymbolsAvg)
{
   if (gs_PLLAvgHandlerCnt < us_NumSymbolsAvg)
   {
      if(gt_PilotConfig.ta_PilotTones[PilotIdx].ft_DeRotatePilot)
      {
         // The accumulation of the new pilot tone is done in the below way in order to get rid of a phase error,
         // which would point in the same direction for all constellation points.
         if ((gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Re > 0) && (gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Im > 0))     //  +/+
         {
            gla_AvgRefPilotToneReal[PilotIdx] +=   gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Re;
            gla_AvgRefPilotToneImag[PilotIdx] +=   gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Im;
         }
         else if((gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Re < 0) && (gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Im > 0)) //  -/+
         {
            gla_AvgRefPilotToneReal[PilotIdx] +=   gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Im;
            gla_AvgRefPilotToneImag[PilotIdx] += -(gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Re);
         }
         else if((gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Re > 0) && (gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Im < 0)) //  +/-
         {
            gla_AvgRefPilotToneReal[PilotIdx] += -(gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Im);
            gla_AvgRefPilotToneImag[PilotIdx] +=   gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Re;
         }
         else if((gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Re < 0) && (gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Im < 0)) //  -/-
         {
            gla_AvgRefPilotToneReal[PilotIdx] += -(gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Re);
            gla_AvgRefPilotToneImag[PilotIdx] += -(gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Im);
         }
      }
      else
      {
         gla_AvgRefPilotToneReal[PilotIdx] += gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Re;
         gla_AvgRefPilotToneImag[PilotIdx] += gt_PilotConfig.ta_PilotTones[PilotIdx].s_PilotTone_Im;
      }
   }
   else
   {
      *ps_real=(int16)(gla_AvgRefPilotToneReal[PilotIdx]>>us_Log2_NumSymbolsAvg);
      *ps_imag=(int16)(gla_AvgRefPilotToneImag[PilotIdx]>>us_Log2_NumSymbolsAvg);

      gs_PLLAvgHandlerState = PLL_AVG_DONE;
   }
   // XDSLRTFW-3835 (Start_End)
   gs_PLLAvgHandlerCnt++;
// XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement
}
