/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _CUSTOMERTASKS_H
#define _CUSTOMERTASKS_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             CustomerTasks.h
 * DESCRIPTION:      Header file for functions providing customer access to
 *                   foreground and background processing
 *
 **********************************************************************/

// Global flag for xTC selection
extern FlagT gft_AlphaeusSel;
extern uint8 gt_WatchdogTimerEnable;

// Flags for Aware <-> xTC signalisation in case of an OOS defect or failure
extern uint8 guca_Customer_g997_TCSync_Flag[NUM_DATA_PATHS];
extern uint8 guca_Customer_g997_OutOfSync_Failure_NE[NUM_DATA_PATHS];

/* Flags for Aware <-> xTC signalisation in case of a NCD or LCD failure */
extern uint8 guca_Customer_g997_NCD_Failure_NE[NUM_DATA_PATHS];
extern uint8 guca_Customer_g997_LCD_Failure_NE[NUM_DATA_PATHS];
extern uint8 guca_Customer_g997_NCD_Failure_FE[NUM_DATA_PATHS];
extern uint8 guca_Customer_g997_LCD_Failure_FE[NUM_DATA_PATHS];

//Function prototypes
extern void Customer_HwSetUp(void);
extern void CustomerTxForeground(void);
extern void CustomerRxForeground(void);
extern void InitCustomer_PowerUp(void);
extern void InitCustomer_PreHandshake(void);
extern void InitCustomer_PostHandshake(void);
extern void CustomerBgTaskManager(void);
extern void CustomerSetSwapEngineType(void);
extern void WatchdogTimerStart( void );
extern void WatchdogTimerStop(void);
extern void WatchdogTimerReset( void );
extern void CustomerClearTR1Counters(void);
extern void CustomerCopyTR1Counters(void);
extern void Customer_1sec_Task(void);

// valid states of state_CustBgCmvResponse
#define CUST_SLOW_CMV_IDLE                          0
#define CUST_SLOW_CMV_CREATE_AUTO_MSG               1
#define CUST_SLOW_CMV_SEND_AUTO_MSG                 2
#define CUST_SLOW_CMV_WAIT_FOR_AUTO_MSG_SENT        3

#endif /* _CUSTOMERTASKS_H */

