/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: LL_IOf.h
;
;   Header file for low-level core interface layer.
;
*****************************************************************************/

#ifndef _LL_IOF_H
#define _LL_IOF_H

#ifdef TARGET_HW_DEBUG_TRAIL
    #define HW_DEBUG_TRAIL_R30(value)           _core_write(value, 30)
    #define HW_DEBUG_TRAIL_R26(value)           _core_write(value, 26)
#else
    #define HW_DEBUG_TRAIL_R30(value)
    #define HW_DEBUG_TRAIL_R26(value)
#endif


    #include "alp_memmap.h"
    #include "zep_ilv_memmap.h"
   #include "qt_memmap.h"
   #include "qtp_memmap.h"
    #include "zep_memmap_cnfg.h"
   #include "str_memmap.h"

    #define ReadCoreReg(ul_addr, pul_data) *(pul_data) = *((volatile uint32*)((uint32)ul_addr))
   #define ReadPpeReg(ul_addr, pul_data) {\
                                 *(pul_data) = *((volatile uint32*)((uint32)ul_addr));\
                                 *((volatile uint32*)((uint32)V_OVERFLOW_ADDR));\
                              }

    #define WriteCoreReg(ul_addr, ul_data) *((volatile uint32*)((uint32)ul_addr)) = (ul_data)

   #define WritePpeReg(ul_addr, ul_data)  {\
                                 *((volatile uint32*)((uint32)ul_addr)) = (ul_data);\
                                 *((volatile uint32*)((uint32)V_OVERFLOW_ADDR));\
                                 }


    #define SetCoreReg(ul_addr, ul_mask) *((volatile uint32*)((uint32)ul_addr)) |= ul_mask
    #define ResetCoreReg(ul_addr, ul_mask) *((volatile uint32*)((uint32)ul_addr)) &= (~(ul_mask))

    #define GetDspReg(l_RegAddr) (*((volatile int32 *)l_RegAddr))
    #define SetDspReg(l_RegAddr, l_Value) *((volatile int32 *)l_RegAddr) = l_Value

   void ReadCoreBuf32(uint32 ul_addr, int16 *psa_words, uint16 us_num);
   void ReadCoreBuf32NoDMA(uint32 ul_addr, int16 *psa_words, uint16 us_num);
    void WriteCoreBuf32(uint32 ul_addr, int16 *psa_words, uint16 us_num);
    void WriteCoreBuf32NoDMA(uint32 ul_addr, int16 *psa_words, uint16 us_num);
    void FillCoreBuf32(uint32 ul_addr, int32 s_value, uint16 us_num);
    void ReadCoreBuf8(uint32 ul_addr, int8 *pca_word, uint16 us_num);
    void WriteCoreBuf8(uint32 ul_addr, int8 *pca_word, uint16 us_num);
        void EnterFailStates(uint32);
   #define mComputeHerculesOffsetAddress(ul_StartAddress, RealPart) { \
                                             (ul_StartAddress) = ((uint32)(RealPart)); \
   }

    #define GetBitAllocationTableAddress(uc_port)   (uint8*)(IRI_QT_RAM_INACTIVE_BAT_ADDR)
    #define GetGainScaleTableAddress(uc_port)       (uint16*)(IRI_QT_RAM_INACTIVE_GAIN_SCALE_ADDR)
   #define GetSFDQMantissaTableAddress(uc_port) (int16*)(IRI_QT_RAM_FDQ_MANT_ADDR)
   #define GetExtendedGainTableAddress(uc_port) (uint8*)(IRI_QT_RAM_INACTIVE_EGT_ADDR)
   #define GetToneReorderingTableAddress(uc_port)  (uint16*)(IRI_QT_RAM_INACTIVE_TOT_ADDR)
   #define GetActiveBGTNTableAddress(path, uc_port)(uint32*)(IRI_QT_RAM_ACTIVE_BGTN_ADDR)
   #define GetActiveEGTTableAddress(uc_port)    (uint8*)(IRI_QT_RAM_TX_ACTIVE_EGT_ADDR)
   #define GetSFDQExponentTableAddress(uc_port) (uint8*)(IRI_QT_RAM_FDQ_EXP_ADDR)

    #define GetMFDQFFMantissaTableAddress(uc_port) (int16*)((uint32)(IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_ADDR) )
    #define GetMFDQFBMantissaTableAddress(uc_port) (int16*)((uint32)(IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_ADDR) )
    #define GetMFDQFBExponentTableAddress(uc_port) (int32*)((uint32)(IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_ADDR) )

   #define ClearLpEndReg   _sr(0, 3)         // clear lp_end aux reg





#endif // _LL_IOF_H

