#ifndef _STATESTRAIL_H
#define _STATESTRAIL_H

/**********************************************************************
 *
 * Copyright (c), 1994-2005 Aware Inc. All Rights Reserved.
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             LeaveStatesTrail.h
 * DESCRIPTION:      Header file for functions used for logging trail file.
 *
 **********************************************************************/
#ifdef DEBUG_TRAIL
void LeaveStatesTrail(int32 l_SymbolCount, int16 s_State, int16 s_NextState, int16 s_Delimitter);
void LeaveGhsStatesTrail(int16 s_State, int16 s_NextState, int16 s_SymbolCnt, uint8 s_TxRxId, uint8 uc_MsgType);
void LeaveRxSOCTrail(uint8 uc_RxMsgCode, int16 s_RxMsgErrorCode, int16 s_MsgReceiveFlag);
void LeaveTxSOCTrail(uint8 uc_TxMsgCode);
void LeaveSubStatesTrail(int32 l_SymbolCount, int16 s_SubState, int16 s_NextSubState, int16 s_Delimitter);
void LeaveToneTrail(int32 l_SymbolCount, int16 s_toneIndex, int16 s_numTones);
void LeaveHDLCOctetTrail(uint16 us_Marker, uint8 uc_Octet1, uint8 uc_Octet2, int16 s_NumOctets);
void LeaveEOCOvhdMsgTrail(uint16 us_Marker, uint8 uc_Octet);
void LeaveMipsTrail(int16 s_Delimitter, int16 s_State, int16 s_SubState, int16 s_AlgHandlerState);
extern void LeaveTimeStampTrail(int16 s_TimeLabelId, int16 l_TxTimer, int16 l_RxTimer);
#else // DEBUG_TRAIL
/*Suppress compiler warning:
*"A program must contain at least one external-declaration (X3.159-1989 p.82,L3)"
*by adding a dummy function declaration
*/
void DummyFunctionLeaveGhsTrail( void )
{
}
#endif // DEBUG_TRAIL
#endif // _STATESTRAIL_H

