/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*  Aware DMT Technology. Proprietary and Confidential.
*
*  40 Middlesex Turnpike, Bedford, MA 01730-1413
*  Phone (781) 276 - 4000
*  Fax   (781) 276 - 4001
*
*  filename: afe.h
*
*-------------------------------------------------------------------------------
*/

#ifndef _AFE_H
#define _AFE_H

#include "typedef.h"

/****************************************************/
/* Function declarations */
/****************************************************/
void RwVDSLAfeCoreReg(uint32 ul_data, uint16 us_trigger);
void WriteVDSLAfe(uint16 us_addr, uint16 us_data);
uint16 ReadVDSLAfe(uint16 us_addr);

void BgSetPGA(void);
void BgSetNmsPGAMedley(void);
void InitializeAfeRegsForMode(void);
void CheckForAFERegAccess(void);

int16 SetAfeTxGain(int16 s_gain);

void SetTxRxAnalogFilterCorners(void);
void BgRaiseRxAnalogFilterCorner(void);
void BgRestoreRxAnalogFilterCorner(void);

void InitDefaultAFEDataInterface(void);
void ReconfigAFERegsForTraining(void);

void AfeCalibration(void);

/****************************************************/
/* General AFE constants */
/****************************************************/
#define NUM_VDSL_DI_LONGWORDS   (6)

#define AFE_REG_NO_OP  (0x0)   // AFE register no operation.
#define AFE_REG_RD_OP  (0x1)   // AFE register read operation.
#define AFE_REG_WR_OP  (0x2)   // AFE register write operation.
#define AUX_REG_RD_OP  (0x3)   // AUX register read operation.
#define AUX_REG_WR_OP  (0x4)   // AUX register write operation.

#define CONST_GAIN_2pow30_DB   (23119)    // 10*log10(2^30), in 8.8 format
#define GAIN_6_dB              (1541)     // 20*log10(2) = 6.0206 in 8.8 format.
#define GAIN_12_dB             (3083)     // 20*log10(4) in 8.8 format.

#define IFFT_IN_THRESH_DB_FOR_GAIN_6      (-25*256) // -25 dB in 8.8 format
#define IFFT_IN_THRESH_DB_FOR_GAIN_0      (-19*256) // -19 dB in 8.8 format
#define IFFT_IN_THRESH_DB_FOR_GAIN_NEG6   (-13*256) // -13 dB in 8.8 format
#define MAX_PERMISSIBLE_TXVGN_OUT_DB      (-16*256) // -16.0 dB in 8.8 format

// Percentage margin to include in setting TX and RX analog filter corners.
#define perc_gd_tx_AnlgFCorner   (20)
#define perc_gd_rx_AnlgFCorner   (0)

/****************************************************/
/* AFE specific stuff */
/****************************************************/

// Updated 2/1/2010 with constants in email from SK)
//   PEAK_DAC_DBV ;  ANLG_TX_FILTER_GAIN ; LD_TO_LINE_GAIN_DB values
//Updated the AFE related constants values for VRX518 platform (Palaksha,Christian F, Stefan K, Andreas H)

// Rx-gain: -25dB and -22dB to +21dB in 1dB steps (VDSL)
// PGA1:     -9dB and  -6dB to +21dB in 1dB steps (VDSL and ADSL)
// PGA2:              -16dB to   0dB in 1dB steps (VDSL)
#define MIN_PGA                     (-25*256)
#define PEAK_DAC_DBV                (-640)     //(-0x280)   // 0.75 V is -2.5 dBV,  8.8 format

#define MAX_TX_AFE_GAIN_SETTING_DB        (9*256)   //  9.0 dB in 8.8 format
#define MIN_TX_AFE_GAIN_SETTING_DB        (-10*256) // -10.0 dB in 8.8 format

#define RESOLN_TX_AFE_GAIN_SETTING_DB     (256)     // 1 dB steps

#define  TX_PSD_IMPLEMENTATION_MARGIN_0pt0_dB         (0)         // 0*256 = 0
#define  TX_PSD_IMPLEMENTATION_MARGIN_0pt5_dB         (-128)      //-0.5*256  to Boost TXPSD by 0.5dB
#define  TX_PSD_IMPLEMENTATION_MARGIN_0pt6_dB         (-153)      //-0.6*256  to Boost TXPSD by 0.6dB
#define  TX_PSD_IMPLEMENTATION_MARGIN_0pt7_dB         (-179)      //-0.7*256  to Boost TXPSD by 0.7dB
#define  TX_PSD_IMPLEMENTATION_MARGIN_0pt9_dB         (-230)      //-0.9*256  to Boost TXPSD by 0.9dB
#define  TX_PSD_IMPLEMENTATION_MARGIN_1pt0_dB         (-256)      //-1.0*256  to Boost TXPSD by 1.0dB

//Calculation: LD_TO_LINE_GAIN_DB_HYB_TYPE_1 = 18.5dB (LD) -0.9dB (LD input resistors) -6dB (termination) +6dB (transformer) = 17.6dB
//#define  LD_TO_LINE_GAIN_DB_HYB_TYPE_1  4264 //  16.65 * 2256 dB in 8.8 format.for VRX518 LIF module
//#define  LD_TO_LINE_GAIN_DB_HYB_TYPE_1       (4585)//ceil(17.9082*256)
#define  LD_TO_LINE_GAIN_DB_HYB_TYPE_1       (4539)//ceil(17.73*256)  17.73 @ Tone 872

// CPE hybrid types:
// Note: These defines are coming from MsgSpec, i.e. CMV: DSL 9 (ACK_HybridGet 0x0922)
#define VRX_HYB_TYPE_NONE           (0x0)  // No LIF module
#define VRX_HYB_TYPE_A              (0x1)  // Adaptive hybrid for Annex A
#define VRX_HYB_TYPE_B              (0x2)  // Adaptive hybrid for Annex B
#define VRX_HYB_TYPE_BJ             (0x3)  // Adaptive hybrid for Annex BJ
#define VRX_HYB_TYPE_ABJ            (0x4)  // Adaptive hybrid for Annex A,B,J

// RXPSD@line[dBm/Hz] = 10log(PTSPA) + 10log(1^2/(2^30)) - 10log(0.001*100) - log(4312.5 Hz)
//                    = PTSPA[dB]    + (-90.3 dB)        - (-10dB)          - (+36.347dB)
//                    = PTSPA[dB]    - 116.656dB
#define AFE_FIXED_GAIN_ABJ          (29864)  // 0x74A8 = 29864 -> 116.656dB in Q8.8 format

//----------------------------------------------------------------------------------------------


#endif // _AFE_H
