/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: codeswap.h
*
*   This is include file for codeswap.c.
*
*-------------------------------------------------------------------------------
*/

#include "vcpe_swap_index.h"

#ifndef _CODESWAP_H
#define _CODESWAP_H

#define DEFAULT_SRAM_IMAGE_OFFSET       0x0

// code swap timing control
#define SWAP_TIMING_OFF                   0
#define SWAP_TIMING_ON                    1

// Code swap wait length
#define MAX_SWAP_REQUESTS                 8                    // must be 2^n
#define MAX_SWAP_REQUESTS_MASK            (MAX_SWAP_REQUESTS - 1)
#define INVALID_CODESWAP_HANDLE           (MAX_SWAP_REQUESTS)
#define CODESWAP_NO_ACTION                (0xff)

// these are used by hw/codeswap engine to check for codeswap timeout.
#define MAX_SWAP_TIMING                 350
#define MAX_TRAIN_SWAP_TIMING           350
#define MAX_SHOW_SWAP_TIMING            350

#define CODESWAP_THRU_ME       0
#define CODESWAP_THRU_XDMA     1

#define RX_SWAP_CHECK          0
#define TX_SWAP_CHECK          1

#define HALF_BAR15_SIZE         (32*1024)
#define FULL_BAR15_SIZE         (64*1024)
#define DATA_MEMORY_BAR16_SIZE  (448*1024)      // XDSLRTFW-2853 (Start_End)

// these defines are used in codeswap switch statements inside state functions.
#define CODESWAP_DO_NOTHING         (0x00)
#define CODESWAP_LOAD(SwapPage)     (SwapPage+1)
#define CODESWAP_CHECK(SwapPage)   (MAX_SWAP_PAGES+SwapPage+1)

// codeswap status
// SWAP_HW_XXXX are hardware status.
// The rest are SW status
enum {SWAP_FREE_HANDLE = 0,
      SWAP_PENDING,               // 1
      SWAP_SUBMITTED,             // 2
      SWAP_HW_IDLE,               // 3
      SWAP_HW_QUEUED,             // 4
      SWAP_HW_ACTIVE,             // 5
      SWAP_HW_DONE,               // 6
      SWAP_HW_ERROR,              // 7
      SWAP_HW_DISABLED,           // 8
      SWAP_DONE,                  // 9
      SWAP_ERROR,                 // 10
      SWAP_TIMEOUT,               // 11
      SWAP_HANDLE_ERROR};         // 12

enum {MINIMUM_TIMING_MODE = 1, EXACT_TIMING_MODE, STATE_MODE, NEXT_STATE_MODE};

typedef struct {
    uint8 uc_SwapPageNum;           // ???
    uint8 uc_Status;            // Status of the request
    uint8 uc_Port;              // port number = 0, 1, 2, 3
    FlagT ft_SwapTimingOn;      // 1 - run codeswap engine with timing_on, else run with timing_off

    uint16 us_HwSwapDuration;
    uint16 us_FwSwapDuration;
    uint16 s_MaxSwapDuration;

    uint8  uc_LookUpTableIdx;    // Row index within the BAR15 lookup table
    uint8  uc_Dummy;             // For memory alignment
} SwapRequest_t;

//
// indices for gta_BAR15LookUpTable
enum {OFF_CHIP_MEDLEY_SNR = 0, OFF_CHIP_DISC_PSD_ECHOON, OFF_CHIP_DISC_PSD_ECHOOFF, OFF_CHIP_DISC_SNR, OFF_CHIP_PERIODIC1_SNR, OFF_CHIP_ERROR_VECTOR,OFF_CHIP_DEBUG_BUF, OFF_CHIP_MAILBOX, OFF_CHIP_HLOG_PERTONE, OFF_CHIP_QLN_PERTONE, NUM_OF_OFF_CHIP_BUFFERS};
enum {OFF_CHIP_SOURCE_INDEX = 0, OFF_CHIP_DEST_INDEX, OFF_CHIP_LENGTH_INDEX, OFF_CHIP_MAX_INDEX};

extern int32 gta_BAR15LookUpTable[NUM_OF_OFF_CHIP_BUFFERS][OFF_CHIP_MAX_INDEX];
extern uint8 guc_BAR15LookUpTableIdx;   // Used to separate request types within the lookup table
extern uint8 guc_OffChipRequestHandle;

extern int16 gs_AllowSaveDataToSram;

extern int32 __StartOfSramBAR14;
extern int32 __StartOfSramBAR15;
extern int32 __StartOfSramBAR16;
extern int32 __StartOfSramBAR17;
extern int32 __StartOfSramBAR18;
extern int32 __StartOfSramBAR19;


typedef struct {
    uint8 uc_ActiveTransferIndex;             // which queue item being served
    uint8 uc_HwStatus;
    uint8 uc_SwapEngineType;
    uint8 uc_CodeSwapEngineDisabled;
} SwapControl_t;

typedef struct {
    int32 l_SwapPageByteOffsetInSram;
    int32 l_DestinationAddress;
    int32 l_SwapPageSizeInLong;
    int32 l_FinalDestinationAddress;        // only used for Indirect Boot Pages
} SwapTable_t;



extern SwapTable_t __gta_SwapTable[];        // auto generated by setup_codeswap.pl


// Function declarations

void InitCodeSwap(void);
uint8 RequestSwap(uint8 uc_RequestPage);    // this function will request swap with SWAP_TIMING_ON
uint8 RequestSwap1(uint8 uc_RequestPage, uint8 uc_SwapTimingOn);
uint8 GetRequestStatus(uint8 uc_SwapHandle);
void FreeSwapHandle(uint8 *puc_SwapHandle);
uint8 PollForCodeSwapDone(uint8 uc_SwapPageNum, uint8 uc_PageHandle);
void RunCodeSwapEngine(void);
uint8 UpdateHwSwapStatus(void);
void SendCodeSwapRequest(void);
uint8 RequestSwapOffChip(uint8 uc_RequestPage, FlagT ft_SwapTimingOn, uint8 uc_LookUpTableIdx);
void LoadInitPages(void);
void LoadTrainPages(void);
void SendFastReadRequest(void);
FlagT CheckForFastReadDone(void);
void AddFastReadRequest(int32 l_Address, uint16 us_Size, uint16 us_RequestNum);

#endif // _CODESWAP_H

