/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _COSINE_H
#define _COSINE_H

/**********************************************************************
 *
 *
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             cosine.h
 * DESCRIPTION:      Header file for cosine.c
 *
 **********************************************************************/

#include "typedef.h"



#define F32_M_2PI                         0x40c90fdb  // 6.2831855
#define F32_360                           0x43b40000  // 360.0
#define F32_8192                          0x46000000  // 8192
#define F32_MINUS1                        0xbf800000  // -1
#define F32_32767                         0x46fffe00  // 32767.0
#define F32_PI_RADIANS_TIMES8192          0x46c90fdb  // 25735,928
#define F32_2PI_RADIANS_TIMES8192         0x47490fdb  // 51471,856
#define F32_PI_2_RADIANS_TIMES8192        0x46490fdb  // 12867.964
#define F32_MINUS_2PI_RADIANS_TIMES8192   0xc7490fdb  // -51471,856

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
int16 FastCosine(int16 s_phase);
int16 FastSine(int16 s_phase);
Float32 Modulo2PI(Float32 f_phase);
int16 RotateTone(int16 s_NumSamples, int16 s_ToneIdx, int16 *psa_Tone);

#endif /* _COSINE_H */

