/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: data_alloc.h
*
*   Header file for constants defined for sharing XY memory.
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// data_alloc.h
//
// History
//
// 10/07/2012 Vinjam: Created a data memory overlay segment to add data buffers in TWO_PORT_SHOW_ONLY section.
//                     Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//19/07/2013 Kannan: Changes to have 2 DM code swap pages for US ReTx micro code
//Grep for "XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx"
//21/10/2013 Varun : Memory optimization as a part of Amend2. Added TRAIN_ILV_DILV_TRAINING_ONLY data ovelay section
//                   Grep for XDSLRTFW-1287 Feature_US_VDSL2_ALL_UsReTxAmend2_MemoryOpt
//
// 29/10/2014 Anantha Ramu: Separate micro code pages added for Intra DTU Interleaving. The corresponding
//                          compiler pragmas for those pages added.
//                          Grep for "XDSLRTFW-1617"
// ************************************************************************************************************


#ifndef _DATA_ALLOC_H
#define _DATA_ALLOC_H


// the main difference between VDSL_50 and VDSL_62:
//  1. X_MEM/Y_MEM is 8K (VDSL_5) vs 4K (VDSL_62)
//  2. RX_TONE_BUF is in X_MEM(VDSL_50) vs in Y_MEM(VDSL_62)


// constants related to X and Y memory blocks
#define TOTAL_X_BLOCK_SIZE_LW             (1024) // 1K long word = 4K bytes
#define TOTAL_Y_BLOCK_SIZE_LW             (1024) // 1K long word = 4K bytes

// current shared memory size
#define SHARED_X_BLOCK_SIZE_LW            (1024)
#define SHARED_Y_BLOCK_SIZE_LW            (1024)

//==============================================================================
// X block partition during training (X_BLOCK_0)
// defined for the entire duration of GHS and training
//==============================================================================
#define RX_ACCUM_BUF0_SIZE_LW             (1024) // 1024x32 = 512x64 (512 tones)
#define RX_REP_BUF_SIZE_LW                (512) // 512x32 (512 tones)

#define RX_ACCUM_BUF0_OFFSET_LW           (0)
#define RX_REP_BUF_OFFSET_LW              (RX_ACCUM_BUF0_OFFSET_LW) // shared with RxAccumBuf

//==============================================================================
// Y block partition during training (Y_BLOCK_0)
// defined for the entire duration of GHS and training
//==============================================================================
#define RX_TONE_BUF_SIZE_LW               (512) // 512x32 (512 tones)
#define MFDQ_TONE_TABLE_SIZE_LW           (64)  // 64x32 (64 tones)

#define RX_TONE_BUF_OFFSET_LW             (0)
#define MFDQ_TONE_TABLE_OFFSET_LW         (RX_TONE_BUF_OFFSET_LW + RX_TONE_BUF_SIZE_LW)

//==============================================================================
// X block partition during showtime (X_BLOCK_1)
// defined for the entire duration of showtime
//==============================================================================

//Same as that in training

//==============================================================================
// Y block partition during showtime (Y_BLOCK_1)
// defined for the entire duration of showtime
//==============================================================================
#define RX_TONE_BUF_SIZE_LW_SHOW          (256) // 256x32 (256 tones), showtime RX tone buffer size
#define RX_SYNC_FRAME_SIZE_LW             (256) // 256x32 (256 tones), Mei???: we only used 16 tones now
#define HLOG_BUF_SIZE_LW                  (256) // 256x32 = 512x16 (512 tones)

#define RX_TONE_BUF_OFFSET_LW_SHOW        (0) //showtime RX tone buffer start address
#define RX_SYNC_FRAME_OFFSET_LW           (RX_TONE_BUF_OFFSET_LW_SHOW+RX_TONE_BUF_SIZE_LW_SHOW)
#define HLOG_BUF_OFFSET_LW                (RX_SYNC_FRAME_OFFSET_LW+RX_SYNC_FRAME_SIZE_LW)

//==============================================================================
// X block partition during MFDQ training (X_BLOCK_2)
// defined only for the duration of MFDQ training
//==============================================================================
#define MFDQ_FDQOUT_BUF_SIZE_LW           (68) // 68x2x16 (64+ tones)
#define MFDQ_DECOUT_BUF_SIZE_LW           (68) // 68x2x16 (64+ tones)
#define MFDQ_COV_MATRIX_SIZE_LW           (768) // 64x12x32 (64 tones)
#define MFDQ_COR_VECTOR_SIZE_LW           (384) // 64x6x32 (64 tones)

#define MFDQ_FDQOUT_BUF_OFFSET_LW         (0)
#define MFDQ_DECOUT_BUF_OFFSET_LW         (MFDQ_FDQOUT_BUF_OFFSET_LW+MFDQ_FDQOUT_BUF_SIZE_LW)
#define MFDQ_COV_MATRIX_OFFSET_LW         (MFDQ_DECOUT_BUF_OFFSET_LW+MFDQ_DECOUT_BUF_SIZE_LW)
#define MFDQ_COR_VECTOR_OFFSET_LW         (MFDQ_COV_MATRIX_OFFSET_LW+MFDQ_COV_MATRIX_SIZE_LW)

// followings are overlaid on top of gsa_pre_FDQ_coef[]
// not part of gla_SharedBuffer_X[]
#define MFDQ_SF_COEF_BUF_SIZE_SW          (128) // 64x2x16 (64 tones)
#define MFDQ_FF_COEF_BUF_SIZE_SW          (128) // 64x2x16 (64 tones)
#define MFDQ_FB_COEF_BUF_SIZE_SW          (128) // 64x2x16 (64 tones)
#define MFDQ_SFDQCOEF_BUF_SIZE_SW         (136) // 68x2x16 (64+ tones)
#define SHARED_FDQ_COEF_SIZE_SW           (520) // should be less than 2*NUM_CHANNELS_PER_GROUP

#define MFDQ_SF_COEF_BUF_OFFSET_SW        (0)
#define MFDQ_FF_COEF_BUF_OFFSET_SW        (MFDQ_SF_COEF_BUF_OFFSET_SW+MFDQ_SF_COEF_BUF_SIZE_SW)
#define MFDQ_FB_COEF_BUF_OFFSET_SW        (MFDQ_FF_COEF_BUF_OFFSET_SW+MFDQ_FF_COEF_BUF_SIZE_SW)
#define MFDQ_SFDQCOEF_BUF_OFFSET_SW       (MFDQ_FB_COEF_BUF_OFFSET_SW+MFDQ_FB_COEF_BUF_SIZE_SW)

// followings are overlaid on top of guca_pre_FDQ_exp[]
// not part of gla_SharedBuffer_X[]
#define MFDQ_SF_EXP_BUF_SIZE_B            (64) // 64x8 (64 tones)
#define MFDQ_FF_EXP_BUF_SIZE_B            (64) // 64x8 (64 tones)
#define MFDQ_FB_EXP_BUF_SIZE_B            (64) // 64x8 (64 tones)
#define MFDQ_SFDQEXP_BUF_SIZE_B           (68) // 68x8 (64+ tones)
#define SHARED_FDQ_EXP_SIZE_B             (260) // should be less than NUM_CHANNELS_PER_GROUP

#define MFDQ_SF_EXP_BUF_OFFSET_B          (0)
#define MFDQ_FF_EXP_BUF_OFFSET_B          (MFDQ_SF_EXP_BUF_OFFSET_B+MFDQ_SF_EXP_BUF_SIZE_B)
#define MFDQ_FB_EXP_BUF_OFFSET_B          (MFDQ_FF_EXP_BUF_OFFSET_B+MFDQ_FF_EXP_BUF_SIZE_B)
#define MFDQ_SFDQEXP_BUF_OFFSET_B         (MFDQ_FB_EXP_BUF_OFFSET_B+MFDQ_FB_EXP_BUF_SIZE_B)

#define DATA_X_RAM_BEGIN                        #pragma Data(DATA, ".X_RAM")
#define DATA_Y_RAM_BEGIN                        #pragma Data(DATA, ".Y_RAM")
#define  DATA_LOCAL_LD_ST_BEGIN                 #pragma Data(DATA, ".LOCAL_LD_ST")
#define  DATA_COMMON_LD_ST_BEGIN                #pragma Data(DATA, ".data")         // this is the same with BULK
#define DATA_ILVB_BEGIN                         #pragma Data(DATA, ".ILVB")
#define DATA_SELT_ILVB_BEGIN                    #pragma Data(DATA, ".SELT_ILVB")
#define DATA_SELT_BSS_ILVB_BEGIN                #pragma Data(DATA, ".SELT_BSS_ILVB")
#define DATA_DILVB_BEGIN                        #pragma Data(DATA, ".DILVB")
#define DATA_EXT_BULK_BEGIN                     #pragma Data(DATA, ".EXT_BULK")
#define DATA_AWRE_IBRAM_BEGIN                   #pragma Data(DATA, ".AWRE_IBRAM")
#define DATA_CUST_IBRAM_BEGIN                   #pragma Data(DATA, ".CUST_IBRAM")

#define DATA_SRC_COEFS_4KHZ_BEGIN               #pragma Data(DATA, ".SRC_COEFS_4KHZ")
#define DATA_SRC_COEFS_8KHZ_BEGIN               #pragma Data(DATA, ".SRC_COEFS_8KHZ")

#define DATA_SRC_COEFS_35B_RX_BEGIN             #pragma Data(DATA, ".SRC_COEFS_35B_RX")
#define DATA_SRC_COEFS_35B_TX_BEGIN             #pragma Data(DATA, ".SRC_COEFS_35B_TX")

#define DATA_HYB_COEFS_BEGIN                    #pragma Data(DATA, ".HYB_COEFS")
#define DATA_ONE_PORT_SNR_BUF_BEGIN             #pragma Data(DATA, ".ONE_PORT_SNR_BUF")

//XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start_End)
#define DATA_TWO_PORT_SHOW_ONLY_BEGIN           #pragma Data(DATA, ".TWO_PORT_SHOW_ONLY")

//Vectoring Buffer to collect 'Constell points' data, OLR data and ERB
#define DATA_ST_VECTORING_BUFFER_BEGIN          #pragma Data(DATA, ".ST_VECTORING_BUFFER")

//This buffer is used in R-P-Vector-2 state.
#define DATA_TRN_VECTORING_BUFFER_BEGIN         #pragma Data(DATA, ".TRN_VECTORING_BUFFER")

#define DATA_MAP_PERSISTENT_ADSL                #pragma Data(DATA,".PERSISTENT_RAM_ADSL")
#define DATA_MAP_PERSISTENT_VDSL                #pragma Data(DATA,".PERSISTENT_RAM_VDSL")
#define DATA_MAP_PERSISTENT_COMMON              #pragma Data(DATA,".PERSISTENT_RAM_COMMON")
//XDSLRTFW-2059 : New page added in image for USPSD compensation table
#define DATA_MAP_COMMON_COMP_TABLE              #pragma Data(DATA,".COMP_TABLE_V2")

#define DATA_TRAIN_DUMMY_SRC_COEFS_BEGIN        #pragma Data(DATA, ".TRAIN_DUMMY_SRC_COEFS")

//XDSLRTFW-1287 Feature_US_VDSL2_ALL_UsReTxAmend2_MemoryOpt (Start_End)
#define DATA_ILV_DILV_TRAINING_ONLY_BEGIN       #pragma Data(DATA, ".TRAIN_ILV_DILV_TRAINING_ONLY")


// these two pages will not be swapped/initialized by modem FW
#define DATA_PORTMODECONTROL_BEGIN              #pragma Data(DATA, ".PORTMODECONTROL_DATA")
#define DATA_LD_ST_MKERNEL_BEGIN                #pragma Data(DATA, ".LOCAL_LD_ST_MKERNEL")

#define DATA_XILVB_B4_SHOW_INIT_BEGIN           #pragma Data(DATA, ".XILVB_B4_SHOW_INIT")

//L2 Back Channel Buffer
#define DATA_MAP_SRAM_BAR14                     #pragma Data(DATA, ".SRAM_BAR14")

#define DATA_MAP_SRAM_BAR15                     #pragma Data(DATA, ".SRAM_BAR15")

   //XDSLRTFW-3255 (Start_End)
#define DATA_MAP_SRAM_BAR16                     #pragma Data(DATA, ".SRAM_BAR16")

#define DATA_MAP_SRAM_BAR17                     #pragma Data(DATA, ".SRAM_BAR17")
#define DATA_MAP_SRAM_BAR18                     #pragma Data(DATA, ".SRAM_BAR18")
#define DATA_MAP_SRAM_BAR19                     #pragma Data(DATA, ".SRAM_BAR19")
// LP0 pages
#define DATA_MAP_FCI_TX_LP0_UCODE               #pragma Data(DATA, ".TX_LP0_UCODE")
#define DATA_MAP_FCI_RX_LP0_UCODE               #pragma Data(DATA, ".RX_LP0_UCODE")

// LP1 pages overlaid with LP0 pages
#define DATA_MAP_FCI_TX_LP1_UCODE               #pragma Data(DATA, ".TX_LP1_UCODE")
#define DATA_MAP_FCI_RX_LP1_UCODE               #pragma Data(DATA, ".RX_LP1_UCODE")
//XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx(START)
// ReTX LP1 pages overlaid with LP1 pages
#define DATA_MAP_FCI_TX_LP0_RETX_UCODE          #pragma Data(DATA, ".TX_LP0_RETX_UCODE")

// ReTX LP1 pages overlaid with LP1 pages
#define DATA_MAP_FCI_TX_LP1_RETX_UCODE          #pragma Data(DATA, ".TX_LP1_RETX_UCODE")
//XDSLRTFW-1617 (Start_End)
#define DATA_MAP_FCI_TX_LP1_RETX_IDILV_UCODE    #pragma Data(DATA, ".TX_LP1_RETX_IDILV_UCODE")
//XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx(END)
// ReTX LP1 pages overlaid with LP0 pages
#define DATA_MAP_FCI_RX_LP1_RETX_UCODE          #pragma Data(DATA, ".RX_LP1_RETX_UCODE")
//XDSLRTFW-1617 (Start_End)
#define DATA_MAP_FCI_RX_LP1_RETX_IDILV_UCODE    #pragma Data(DATA, ".RX_LP1_RETX_IDILV_UCODE")

// PORT1 LP0 pages
#define DATA_MAP_FCI_TX_PORT1_LP0_UCODE         #pragma Data(DATA, ".TX_PORT1_LP0_UCODE")
#define DATA_MAP_FCI_RX_PORT1_LP0_UCODE         #pragma Data(DATA, ".RX_PORT1_LP0_UCODE")

// PORT1 LP1 pages overlaid with PORT1 LP0 pages
#define DATA_MAP_FCI_TX_PORT1_LP1_UCODE         #pragma Data(DATA, ".TX_PORT1_LP1_UCODE")
#define DATA_MAP_FCI_RX_PORT1_LP1_UCODE         #pragma Data(DATA, ".RX_PORT1_LP1_UCODE")

//XDSLRTFW-1979 (START) DM & PM Free up
//XDSLRTFW-3558 Move Data from DEC memory to Bulk memory

#define DATA_NOISE_MRGN_SEP_BEGIN               #pragma Data(DATA, ".NOISE_MARGIN_SEP_BUFFER")
#define DATA_DEBUG_TRACES_BUFFER_BEGIN          #pragma Data(DATA, ".DEBUG_TRACES_BUFFER")  // XDSLRTFW-2368 (Start_End)
//XDSLRTFW-1979 (END) DM & PM Free up

#define DATA_BULK_DATA2_BEGIN                   #pragma Data(DATA, ".BULK_DATA2_SECTION")
#define DATA_ZEPHYR_SECTION                     #pragma Data(DATA, ".ZEPHYR_SECTION")

#define DATA_MAP_END;                            #pragma Data()
#endif // _DATA_ALLOC_H
