/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _DSP_OP_H
#define _DSP_OP_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  dsp_op.h
;
;  Header file for functions in dsp_op.c
;
*****************************************************************************/

/**********************************************************************
 * CONSTANTS
 **********************************************************************/
#ifndef DSP_OP2_H
#define MAX_16 0x7fff
#endif
#define MIN_16 0x8000
#define MAX_32  0x7fffffff
#define MIN_32  0x80000000
#define Abs32(Var) ((Var) < 0 ? (uint32)-(Var) : ((uint32)Var))
#define Abs16(Var) ((Var) < 0 ? (uint16)-(Var) : ((uint16)Var))

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
extern int16 sature16(int32 L_var1);
extern int16 norm_l(int32 L_var1);
extern int16 div_s(int16 s_var1, int16 s_var2);
extern int16 div_l( int32  L_num, int16 s_den );
extern int16 Divide_16bit(int16 s_num_mant, int16 s_num_exp, int16 s_den_mant, int16 s_den_exp, int16 *ps_quot_mant, int16 *ps_quot_exp);
extern int16 Divide_32by16bit(int32 s_numer_mantissa, int16 s_numer_exponent,
               int16 s_denom_mantissa, int16 s_denom_exponent,
               int16 *ps_quot_mantissa, int16 *ps_quot_exponent
               );
extern void RightShiftAndRound32to16(int16 *psa_dest, int16 s_doffset,
                        int32 *pla_src, int16 s_soffset,
                        int16 s_nitems, int16 s_rshift);
extern int16 norm_16bit(int16 s_var1);
extern void NormAndDivideMantExp_32by16bit(int32 l_numer, int16 s_denom, int16 *ps_mant, int16 *ps_exp);
extern int32 NormAndDivide_32by16bit(int32 l_numer, int16 s_denom);
extern int32 NormAndDivide_32by16bit_with_rnd(int32 l_numer, int16 s_denom);
extern int16 floor16(int16 s_num, int16 s_den);
extern int32 floor32(int32 l_num, int16 s_den);
extern uint32 ceil32u(uint32 Num, uint16 Den); //XDSLRTFW-3189 (Start_End)
extern int16 ceil16(int16 s_num, int16 s_den);
extern int32 ceil32(int32 l_num, int16 s_den);

extern int16 mod16(int16 s_num, int16 s_den);
extern int16 sqrt32(int32 l_in);

extern uint32 BitRev(uint32 ul_In, int16 s_Nbits);

// functions defined in dsp_op_asm.s
extern int32 round(int32 L_var, int16 s_bit_position);
extern int32 l_add(int32 L_var1, int32 L_var2);

extern void _enable(void);
extern void _disable1(void);
extern void _enable1(void);

extern void disable1_save(uint32 *pul_stat);
extern void restore1_save(uint32 ul_stat);

#endif /* _DSP_OP_H */
