/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   AllocateBiGi.c
*
*   Allocate the required Bi / gi based on final Lp computed.
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "dsp_op.h"
#include "Bitload.h"
#include "Bitload_support.h"
#include "changebat.h"
#include "decimalgain.h"
#include "ChooseFineGains.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: FlagT AllocateBiGi(uint8 *puca_RxBat,int16 *psa_RxFineGains,
*                          int16 *ps_RxExtraBits, int32 l_TargetLp)
*
*   This function allocates BAT/GST given parameters.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*      SUCCEED/FAIL
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

FlagT AllocateBiGi(uint8 *puca_RxBat, int16 *psa_RxFineGains, int16 *ps_RxExtraBits, int32 l_TargetLp)
{

   int32 l_InitialSumBi;
   FlagT ft_BitloadOK;
   int32 l_delta_Lp;
   int32 l_dummy;
   uint16 us_BiGiModificationControlFlags;

   GetBatStats(puca_RxBat, (int16 *)(void *)&gus_Rx_Tcm_Num1bits, &gs_Tcm_Oh, &l_InitialSumBi);

   l_delta_Lp = (l_TargetLp + gs_Tcm_Oh) - l_InitialSumBi;

   if (l_delta_Lp <= 0)
   {
      // we need to trim bits to get the desired Lp

      // XDSLRTFW-4075 Optimize input arguments of Bitswap and SRA functions (Start)
      // Initialize us_BiGiModificationControlFlags bit fields for ChangeLpKeepMaxMargin() function
      // #define FT_STOP_AT_MARGIN_THRESHOLD                (0x0001)    // bit 0
      // #define FT_FORCE_EVEN_1_BIT                        (0x0002)    // bit 1
      // #define FT_ADD_FINE_GAIN_PLUS_DELTA_LP             (0x0004)    // bit 2
      // #define FT_FAST_UPSHIFT_SRA_MODE                   (0x0008)    // bit 3

      us_BiGiModificationControlFlags = FT_FORCE_EVEN_1_BIT; // XDSLRTFW-4075 Optimize input arguments of Bitswap and SRA functions (Start)

      ft_BitloadOK = ChangeLpKeepMaxMargin(puca_RxBat, psa_RxFineGains, l_delta_Lp,
                                           guca_RxSupportedToneSet, guca_RxBitswapToneSet, &l_dummy, us_BiGiModificationControlFlags);

      // XDSLRTFW-4075 Optimize input arguments of Bitswap and SRA functions (End)

      if((ft_BitloadOK == FAIL) && (gus_BitloadErrorCode == 0))
      {
         gus_BitloadErrorCode = BITLOAD_ERROR_TRIM_BITS;
      }

      return(ft_BitloadOK);
   }
   else
   {
      gus_BitloadErrorCode = BITLOAD_ERROR_UNEXPECTED_CASE2;
      return(FAIL);
   }
}
