/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   BgCalcProposedCeiling
*
*   This file contains the functions used to compute Compute proposed ceiling parameter for VDSL2 mode.
*
*-------------------------------------------------------------------------
*/
//*****************************************************************************
// BgCalcProposedCeiling.c
//
// History
//
// 30/06/2017  XDSLRTFW-3379 : VRx518 - DS ProposedCeilingOptimal clean-up
//*****************************************************************************

#include "common.h"
#include "gdata.h"
#include "dsp_op.h"
#include "mul.h"
#include "ConvertToDB.h"
#include "PGAHandler.h"
#include "GetTonePsd.h"
#include "BgCalcProposedCeiling.h"
#include "TxPSDControl.h"
#include "decimalgain.h"
#include "ghs.h"
#include "cmv.h"

#define DEBUG_CEILING
//#undef DEBUG_CEILING
//#define PROPOSED_CEILING_DS_DEBUG

int16 gs_CalCeilingMisc_dB = 0;
#if defined(PROPOSED_CEILING_DS_DEBUG)
int16 gs_TestCeilingAlgo = -1;
#endif // PROPOSED_CEILING_DS_DEBUG

/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: Compute proposed ceiling parameter for VDSL2 mode
 *
 *  Prototype: void BgCalcProposedCeiling(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *------------------------------------------------------------------------
 *^^^
 */
void BgCalcProposedCeiling(void)
{
   int16 *ps_proposedCeilOut;

   ps_proposedCeilOut = &gt_PwrConfigParam.s_Dn_ProposedPsdCeiling;

   if(gft_EnableProposedCeiling)
   {
      signed int i, j;

      /* Input and output arguments */
      int16 s_maxTxPsdIn;
      PSDDescriptorTable_t  *pt_PSDDescActIn;
      DsPSDDescriptorTable_t *pt_PSDDescMaxIn;

      /* Local Variables */
      int16 s_addPsd, s_addPsd_curr, s_addPsd_prev, s_MaxPsd, s_ActPsd;
      int16 s_mant, s_exp, s_lshifts, s_AvRxTimePwr;
      int32 l_acc, l_Pa;
      int16 s_target, s_ceil, s_ceil_prev; //s_ceil_adequate;
      int16 s_MaxAtpCeil, s_MaxAtpCeilLastTone, s_MaxAtp;
      int16 s_numofbins;

      int16 s_adc_ns, s_line_side_ns, s_G, s_G_i, s_G_prev, s_Line_sG, s_Line_sGNext, s_Adc_sG, s_Adc_sGNext;
      int32 l_temp, l_snr, l_numbits_acc, l_numbits_acc_max;
      int16 s_PGA_required_In_PropCeilCalc_best;
      int16 s_delta, s_SnrDeltaMaxBit;
      int16 s_shift_value, s_mask_value, s_sub_value, s_sub_interpo;

      int16 sa_RxBandLeftChannel[MAX_NUM_RX_BANDS];
      int16 sa_RxBandRightChannel[MAX_NUM_RX_BANDS];
      int16 s_NumOfRxBands;

      int16 s_DebugIdx;

      // Initialize Input/Ouput Arguments
      // Secure check!
      if(gt_PwrConfigParam.s_Dn_MaxNomPSD < STD_MAXNOMPSD_DS)
      {
         gt_PwrConfigParam.s_Dn_MaxNomPSD = STD_MAXNOMPSD_DS;
      }
      s_maxTxPsdIn = -gt_PwrConfigParam.s_Dn_MaxNomPSD;
      s_MaxAtp = gt_PwrConfigParam.s_Dn_MaxNomAggrPwr;
      pt_PSDDescMaxIn = &gt_MaxDsPSDDescriptorTable;
      pt_PSDDescActIn = (PSDDescriptorTable_t*)(void *)&gt_DsREFPSDDescriptorTable;


      // Generate Per Tone PSD wrt MaxNomPsd
      {
         for (i = 0; i < gs_RxNumTones; i++)
         {
            /* Adjust measured psd to account for a changed ceiling, for every tone in supported set */
            /* do not use outband tones because none of the vendors seem to specify outband psds correctly */
            if (IS_TONEFLAGSET(guca_RxSupportedToneSet, i))
            {
               gsa_PsdPerTone[i] = GetTonePsd(i, (PSDDescriptorTable_t *) (void *)pt_PSDDescMaxIn, gs_RxNumTones) + s_maxTxPsdIn; //   XDSLRTFW-3838
                                                                                       // gives tone Psd wrt MaxNomPsd absolute tone Psd
            }
         }

         {
            // Get the virtual noise PSD
            //Added Number of virtual noise break points check, as this code is also invoked even before
            //extracting the virtual noise break points
            if((gft_DSVirtualNoiseStatus) && (gt_DsREFPSDDescriptorTable.us_NumberOfTones > 0))
            {
//               int16 s_VirtNoisePsd;
//
               gft_EnableProposedCeilingOpt = FALSE;
//               // Get the virtual noise PSD in 0.5 dB steps
//               for (i = 0; i < gs_RxNumTones; i++)
//               {
//                  // Get the virtual noise PSD in 0.5 dB steps
//                  if (IS_TONEFLAGSET(guca_RxSupportedToneSet, i))
//                  {
//                     s_VirtNoisePsd = GetTonePsd(i, (PSDDescriptorTable_t*)(void *)&gt_DS_RefVirtNoiseLevel_VDSL2);
//
//                     // VN level should be between -40dBm/Hz and -140dBm/Hz
//                     // API defined VN PSD level as offset from 0dBm/Hz with step size of 0.5dB
//                     // s_VirtNoisePsd = [-80 to -280] => -40 to -140dBm/Hz
//                     s_VirtNoisePsd = ((s_VirtNoisePsd * 5) + 1400);
//                     gsa_PsdPerTone[i] -= s_VirtNoisePsd;
//                  }
//               }
            }
         }
      }

      // s_MaxAtpCeil returned in -10*(dBm/Hz) format
      // We will consider only ceilings which are no greater than the MAXATP ceiling
      {
         s_NumOfRxBands = gs_NumOfRxBands;
         for (i=0; i<s_NumOfRxBands; i++)
         {
            sa_RxBandLeftChannel[i] = gsa_RxBandLeftChannel[i];
            sa_RxBandRightChannel[i] = gsa_RxBandRightChannel[i];
         }

         s_MaxAtpCeil = CalcAtpCeil(s_MaxAtp,(int16) -s_maxTxPsdIn, (void*)pt_PSDDescMaxIn,
                                    s_NumOfRxBands,&sa_RxBandLeftChannel[0],&sa_RxBandRightChannel[0], gs_RxNumTones);//XDSLRTFW-3838


         LimitBandPlanToHighestTone(&sa_RxBandLeftChannel[0], &sa_RxBandRightChannel[0], &s_NumOfRxBands, gs_HighestAllowedRxTone);
         // "s_MaxAtpCeilLastTone" is the correct value to get an PSD increase over the loop length.
         // Note: For 8x, 12x and 17a this correct way cannot be used. Reason is that due to the high
         //       DS PSD the CO sees more TX echo in his receiver, which leads to an US drop.
         //       Therefore use the higher PSD only for US0 only and DS1 only loops.
         s_MaxAtpCeilLastTone = CalcAtpCeil(s_MaxAtp,(int16) -s_maxTxPsdIn, (void*)pt_PSDDescMaxIn,
                                            s_NumOfRxBands,&sa_RxBandLeftChannel[0],&sa_RxBandRightChannel[0], gs_RxNumTones);//XDSLRTFW-3838

         // Upto a crossover point the values of s_MaxAtpCeil and s_MaxAtpCeilLastTone are equal!
         if (s_MaxAtpCeil > s_MaxAtpCeilLastTone)
         {
//            gsa_Dn_MaxNomPSD[s_NumOfRxBands+1] = 0x0aaa;

            // Check if PSD is still below the Mask for the actual band!
            if ((gsa_Dn_MaxNomPSD[s_NumOfRxBands-1]-35) > s_MaxAtpCeilLastTone)
            {
//               gsa_Dn_MaxNomPSD[s_NumOfRxBands+2] = 0x0bbb;
               // When PSD is greater than the Mask, increase actual PSD, but stay 0.8dB below Mask.
               // Note: But the new PSD should not be lower as before!
               if ((gsa_Dn_MaxNomPSD[s_NumOfRxBands-1]-27) < s_MaxAtpCeil)
               {
                  s_MaxAtpCeil = gsa_Dn_MaxNomPSD[s_NumOfRxBands-1] - 27;
                  // If there is a further band check that the new PSD is below the template PSD
                  if ((s_NumOfRxBands >= 2) &&
                      (gsa_Dn_MaxNomPSD[s_NumOfRxBands-2] > s_MaxAtpCeil))
                  {
//                     gsa_Dn_MaxNomPSD[s_NumOfRxBands+3] = 0x0ccc;
                     s_MaxAtpCeil = gsa_Dn_MaxNomPSD[s_NumOfRxBands-2];
                  }
               }
            }
         }


         if ((gus_DebugControlVRX518 & CEILING_PER_LAST_TONE_EN) ||
              (gs_HighestAllowedRxTone < LAST_BIN_DS1) ||
              (gus_UseUS0OnlyCntrl & (TX_US0_ONLY_INDICATION|TX_US0_ONLY_INDICATION_GHS)))
         {
            s_MaxAtpCeil = s_MaxAtpCeilLastTone;
         }
      }

      s_addPsd_curr = -s_MaxAtpCeil - s_maxTxPsdIn;
      gs_ceil_adequate = -s_MaxAtpCeil;

      s_ceil_prev = 0;
      s_Line_sG = 0;
      s_Line_sGNext = 0;
      s_Adc_sG = 0;
      s_Adc_sGNext = 0;
      s_DebugIdx = 0;

      gsa_CeilingValues[s_DebugIdx++] = s_MaxAtpCeilLastTone;
      gsa_CeilingValues[s_DebugIdx++] = s_MaxAtpCeil;
      gsa_CeilingValues[s_DebugIdx++] = s_addPsd_curr;
//      gsa_CeilingValues[s_DebugIdx++] = gs_PGA_set;
      // s_delta = (-target Margin(0.1dB) - SNR for one bit (Q8.8)+ coding gain (Q4.4)),
      // Note: The gt_SnrMgnConfig.s_TARSNRMds is set in OSignature!
      //       FW modes and possible coding gain:
      //                                             | IDTUon  |   n/a    |      IDTUoff      |
      //                                             |         |          |ReTx/FAST|  INTLV  |
      // --------------------------------------------|------------------------------|---------|
      // IDTU-DS                                     |   ON    |     ON   |   OFF   |   OFF   |
      // s_R                                         |    8    |     16   |  4/RS   |    RS   |
      // --------------------------------------------|------------------------------|---------|
      //                                             |  8.0 dB |   8.5 dB |  7.5 dB |  8.0dB  |
      // --------------------------------------------|------------------------------|---------|
      // XDSLRTFW-3814
      // Note: The +1.5dB are considered for FG's at low and high SNR boundaries.
      //       Therefore the SNR range goes from 9.5dB to 56.2dB -> 0 to 46.7dB, which corresponds to Bit range from 1bit to 15bit.
      // Low boundary = s_delta:
      s_delta = ((-(gt_SnrMgnConfig.s_TARSNRMds<<8)/10) + (int16)(MAX_CODING_GAIN<<4) - (gsa_ConstellationSNR[1] - (int16)0x180));
      // Note: The SNR per constellation is not equally distributed, i.e. not every bit step is equal to 3dB.
      //       The SNR delta from 1bit to 15bit is not exact 14*3dB = 42dB. But it is 43.39dB in reality, i.e. ~3.1dB with
      //       11.31 dB =  1 bit and 54.70 dB = 15 bits.
      // High boundary = s_SnrDeltaMaxBit:
      s_SnrDeltaMaxBit = ((gsa_ConstellationSNR[gt_ModemConfig.s_DsMaxConstSize] + (int16)0x180) - (gsa_ConstellationSNR[1] - (int16)0x180));

      // DS rate is already decreasing, when the real MaxConstSize is considered!
      // This is a quick-fix! It looks like that there is a bug for 35B.
      {
         uint16 us_SwitchingThresh;

         us_SwitchingThresh = LATN_FOR_LIMIT_DS_MAX_BITS_HRT_5_0;
         if(gus_DebugControlVRX518 & ENA_KL0_BASED_SWITCHING)
         {
            us_SwitchingThresh = KL0_150M_PE04;
         }

         if ((gul_35bLiteConfig & EN_HRT_5_0_SCHEDULING_FOR_CASCADED_MODE) &&
            (TESTArray[TEST_Control4] & TEST_Control4_HRT_5_0_CapMaxDsBits14_35b_Bit9_Mask) &&
            (gus_SwitchingCriterionVal < us_SwitchingThresh))
         {
            s_SnrDeltaMaxBit = ((gsa_ConstellationSNR[15] + (int16)0x180) - (gsa_ConstellationSNR[1] - (int16)0x180));
         }
      }


      // Variable used if (gft_EnableProposedCeilingOpt == TRUE)
      l_numbits_acc = 0;
      l_numbits_acc_max = (int32)0x80000000;

      s_G_prev = -1;

      s_shift_value = SUBCAR_GROUP_SIZE_LOG2_8;
      s_mask_value = 0x7;
      s_sub_value = 4;
      s_sub_interpo = 15;
      if(gs_RxLog2FftLength == DS_LOG2_FFT_LENGTH_16384)
      {
         s_shift_value = SUBCAR_GROUP_SIZE_LOG2_16;
         s_mask_value = 0xf;
         s_sub_value = 8;
         s_sub_interpo = 31;
      }

      // Will not request a cutback of more than 40 dB from s_maxTxPsdIn.
      while(s_addPsd_curr>=(s_maxTxPsdIn))
      {
         // Initialize local vars
         l_Pa = 0; // Accumulated Power of tones

         // Current flat PSD ceiling being tested, in 10XdBm/Hz
         // s_ceil = MaxNomPsd + s_addPsd_curr = MaxAtpCeil for the first run
         s_ceil = s_maxTxPsdIn + s_addPsd_curr;
         for (i = 0; i < gs_RxNumTones; i++)
         {
            /* Adjust measured psd to account for a changed ceiling, for every tone in supported set */
            /* do not use outband tones because none of the vendors seem to specify outband psds correctly */
            if (IS_TONEFLAGSET(guca_RxSupportedToneSet, i))
            {
               // s_MaxPsd becomes the maximum permissible PSD in general at this tone, in 10XdBm/Hz.
               s_MaxPsd = gsa_PsdPerTone[i];               // gives absolute tone Psd

               // s_ActPsd is the far-end PSD being used for channel discovery.
               s_ActPsd = GetTonePsd(i, pt_PSDDescActIn, gs_RxNumTones);  //    XDSLRTFW-3838 gives tone Psd wrt MaxNomPsd
               s_ActPsd = s_ActPsd + s_maxTxPsdIn;         // absolute tone Psd

               // If this is not first pass through ceiling trials loop,
               // restore PSD buffer to its original setting as it was prior to the modification of previous pass.
               if (s_addPsd_curr != (-s_MaxAtpCeil - s_maxTxPsdIn))
               {
                  s_target = s_ceil_prev;
                  // target PSD is lower of s_MaxPsd and s_ceil
                  if (s_target>s_MaxPsd)
                  {
                     s_target = s_MaxPsd;
                  }

                  // Take difference between target PSD and far-end PSD, and add this to measured psd.
                  s_addPsd_prev = s_target-s_ActPsd;
                  gpsa_MeasuredSnrBuf[i] = gpsa_MeasuredSnrBuf[i] - (((int32) s_addPsd_prev)<<8)/10;
               }

               // Now make the PSD modification for this pass.
               // target PSD is lower of s_MaxPsd and s_ceil
               s_target = s_ceil;
               if (s_target>s_MaxPsd)
               {
                  s_target = s_MaxPsd;
               }

               // Take difference between target PSD and far-end PSD, and add this to measured psd.
               s_addPsd = s_target-s_ActPsd;
               gpsa_MeasuredSnrBuf[i] = gpsa_MeasuredSnrBuf[i] + (((int32) s_addPsd)<<8)/10;
            }   //if (IS_TONEFLAGSET(guca_RxSupportedToneSet, i))

            // accumulate the power of tones of the modified PSD and calculate the expected PGA
            // Note: Since db_to_linear() computes 10^(x/20), instead of 10^(x/10),
            //       so we need to scale input x up by the factor of 2 to get the desired result.
            //       With the shift it is possible to overflow.
            db_to_linear(gpsa_MeasuredSnrBuf[i], &s_mant, &s_exp);

            // Compute the tone power
            l_acc = s_mant*s_mant;            // compute mantissa^2
            s_exp = (s_exp << 1);             // compute exponent*2
            s_lshifts = norm_l(l_acc);        // normalize it
            l_acc = l_acc << s_lshifts;
            s_exp -= s_lshifts;               // and account for normailization in exponent

            // Accumulate averaged tone power in Q32.0 format
            s_exp -= gs_RxLog2FftLength;      // Average signal power
            s_exp -= 30;                      // Adjust exponent to convert from Q2.30 to Q32.0 format
            if (s_exp < 0)
            {
               if (s_exp < -31)
               {
                  s_exp = -31;
               }
               l_Pa += l_acc >> -s_exp;
            }
            else
            {
               if (s_exp > 31)
               {
                  s_exp = 31;
               }
               l_Pa += l_acc << s_exp;
            }

         }// for (i = 0; i < gs_RxNumTones; i++)

         // Compute average time domain power in dB
         s_AvRxTimePwr = ConvertToDB(l_Pa);
         // Account for RxVarGain.
         s_AvRxTimePwr -= (gt_DfeAfeGainSettings.s_Rx_FFT_Gain_Rms_dB + gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB + gt_DfeAfeGainSettings.s_Rx_Total_TdqToAfeInterface_Gain_dB + gsa_PgaCorrection);

         // Compute optimal PGA to maximize ADC dynamic range.
         gs_PGA_required_In_PropCeilCalc = PD_DB - s_AvRxTimePwr - gs_PGA_margin_AGC2 + gs_PGA_set+gt_PgaGainCorrectionDslPath.s_corr_gain_rxa_dB_out;

         //---------------------------------
         // First ceil down, so that it is low enough to permit a PGA setting above MIN_PGA.
         // Afterwards continue testing lower ceilings, and select the one that maximizes the
         // estimated data rate, based on the corresponding PGA setting, the received (ceiling-cutback) signal,
         // line-side noise and ADC PSDs.

#if defined(PROPOSED_CEILING_DS_DEBUG)
    if (gs_TestCeilingAlgo == (gsa_CeilingValues[2]-s_addPsd_curr))
    {
       break;
    }
#endif // PROPOSED_CEILING_DS_DEBUG

         // Optimize ceiling (beyond that adequate for pga) only if in 4 kHz frame rate mode and
         // ceiling optimization has not been disabled.
         if (gs_PGA_required_In_PropCeilCalc < MIN_PGA)
         {
            // Until signal power has been lowered sufficiently,
            // the best ceiling tried thus far is the present one (lowest one).
            gs_ceil_adequate = s_ceil;
            gs_ceil_best = s_ceil;
         }
         else // if (gs_PGA_required_In_PropCeilCalc >= MIN_PGA)
         {
            if (!gft_EnableProposedCeilingOpt)
            {
               gs_ceil_best = 0;
               // break of while-loop
               // Note: Max negative value, but correted by the -10, which can be subtracted later!
               s_addPsd_curr = -32758;
            }
            else
            {
               // First time after ceiling has cut down the signal so that AFE is not clipping, i.e. PGA>=MIN_PGA.
               // Record this ceiling value.
               if (l_numbits_acc_max == (int32)0x80000000)
               {
                  gs_ceil_adequate = s_ceil;
               }

               l_numbits_acc = 0;
               s_numofbins = 0;

               // Note: gt_DfeAfeGainSettings.s_Rx_FFT_Gain_Rms_dB should not be considered for PSD(f) to Line side transformation.
               //       The variable is only for PGAHandler(), i.e. Calculation of RMS frequency domain for PGA.
               gl_RxPathTotalGain = (int32)gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB +
                                   (int32)gs_PGA_required_In_PropCeilCalc +
                                   (int32)gs_HybridGain +
                                   (int32)gt_DfeAfeGainSettings.s_Rx_Total_TdqToAfeInterface_Gain_dB +
                                   (int32)gt_DfeAfeGainSettings.s_Rx_FFT_Gain_dBPerHz +
                                   gl_afe_fixed_gain +
                                   (int32)gt_DfeAfeGainSettings.s_RxPathTrafo_Gain_dB +
                                   (int32)gt_DfeAfeGainSettings.s_AfeLevelShiftDfe_Gain_dB +
                                   (int32)gt_PgaGainCorrectionDslPath.s_corr_gain_rxa_dB_out +
                                   (int32)gs_QlnHlogCorrection +
                                   (int32)gs_CalCeilingMisc_dB;


#if defined(PROPOSED_CEILING_DS_DEBUG)
               for (i = 0; i < gs_RxNumTones; i++)
               {
#else
               for (j=0; j<s_NumOfRxBands; j++)
               {
                  for (i=sa_RxBandLeftChannel[j]; i<=sa_RxBandRightChannel[j]; i++)
                  {
#endif // PROPOSED_CEILING_DS_DEBUG
                     if (IS_TONEFLAGSET(guca_RxSupportedToneSet, i))
                     {
                        // Get Line-side noise and ADC noise PSDs at this tone,
                        // via interpolation on guca_QLN and gsa_ADC_noise (gsa_MedleyTempFDQCoeffs used for this), respectively.
                        // Note guca_QLN[0],guca_QLN[1], ... and
                        // gsa_ADC_noise[0],gsa_ADC_noise[1], ...
                        // are noise psds centered at tones 3.5,11.5, ...

                        // Group index (which group of 8) for this tone
                        s_G = (i-s_sub_value)>>s_shift_value;
                        if (s_G<0)
                        {
                           s_G = 0;
                        }
                        if (s_G>=((gs_RxNumTones>>s_shift_value)-1))
                        {
                           s_G = (gs_RxNumTones>>s_shift_value)-2;
                        }
                        // Subindex with group of 8.
                        s_G_i = (i-s_sub_value) & s_mask_value; //(i-4)%8;

                        if (s_G != s_G_prev)
                        {
                           s_G_prev = s_G;

                           // Line-side noise
                           // Convert from QLN format back to dBm/Hz, then to a corresponding dB measurement at FFT output,
                           // accounting for dBm/Hz --> dB conversion and RX path gain including PGA, rxvargain.
                           // Note:
                           //    Ensure that the QLN is in the range of -150 to -23 dBm/Hz
                           //    - 8-bit unsigned integer n(k) shall be reported (0 to 254) and 255 for out of range.
                           //    - QLN = -23 - (n(k)/2) dBm/Hz gets calculated out of this value
                           //    -> n(k) = -(QLN + 23)*2
                           //    - granularity of 0.5dB
                           //
                           // s_line_side_ns =  ((-23*256) - (guca_QLN[s_G]<<7)) + gl_afe_fixed_gain + gs_HybridGain + gs_PGA_required_In_PropCeilCalc + gs_RxVarGainDB;
                           // s_adc_ns       = gpsa_MedleyTempFDQCoeffs[s_G+1] + gs_RxVarGainDB + (3<<8);
                           l_temp =  (int32)((-23*256) - (guca_QLN[s_G]<<7)) + gl_RxPathTotalGain;
                           // Limit to Q8.8 format
                           if (l_temp > (127<<8))
                           {
                              s_Line_sG = (int16) (127<<8);
                           }
                           else if (l_temp < (-127<<8))
                           {
                              s_Line_sG = (int16) (-127<<8);
                           }
                           else
                           {
                              s_Line_sG = (int16) l_temp;
                           }

                           l_temp = (int32)((-23*256) - (guca_QLN[s_G+1]<<7)) + gl_RxPathTotalGain;
                           if (l_temp > (127<<8))
                           {
                              s_Line_sGNext = (int16) (127<<8);
                           }
                           else if (l_temp < (-127<<8))
                           {
                              s_Line_sGNext = (int16) (-127<<8);
                           }
                           else
                           {
                              s_Line_sGNext = (int16) l_temp;
                           }

                           // ADC noise
                           // accounting for rxvargain, 3 dB for real^2+imag^2.
                           // gpsa_MedleyTempFDQCoeffs is holding the ADC noise PSD.
                           l_temp = gpsa_MedleyTempFDQCoeffs[s_G] + gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB + (3<<8);

                           if (l_temp > (127<<8))
                           {
                              s_Adc_sG = (int16) (127<<8);
                           }
                           else if (l_temp < (-127<<8))
                           {
                              s_Adc_sG = (int16) (-127<<8);
                           }
                           else
                           {
                              s_Adc_sG = (int16) l_temp;
                           }

                           // gpsa_MedleyTempFDQCoeffs is holding the ADC noise PSD.
                           l_temp = gpsa_MedleyTempFDQCoeffs[s_G+1] + gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB + (3<<8);

                           if (l_temp > (127<<8))
                           {
                              s_Adc_sGNext = (int16) (127<<8);
                           }
                           else if (l_temp < (-127<<8))
                           {
                              s_Adc_sGNext = (int16) (-127<<8);
                           }
                           else
                           {
                              s_Adc_sGNext = (int16) l_temp;
                           }
                        }

                        // Interpolate noise
                        {
                           int16 s_shift_value_local;

                           s_shift_value_local = (s_shift_value + 1);
                           // Interpolate Line noise
                           l_temp = ((((s_G_i<<1) +1)*s_Line_sGNext) + ((s_sub_interpo - (s_G_i<<1))*s_Line_sG));
                           s_line_side_ns = (int16) ((l_temp + (1<<s_shift_value)) >> s_shift_value_local);
                           // Interpolate ADC noise
                           l_temp = ((((s_G_i<<1) +1)*s_Adc_sGNext) + ((s_sub_interpo - (s_G_i<<1))*s_Adc_sGNext));
                           s_adc_ns = (int16) ((l_temp + (1<<s_shift_value)) >> s_shift_value_local);
#if defined(PROPOSED_CEILING_DS_DEBUG)
    gsa_SnrBuf_OnePortMode[i] = s_line_side_ns;
    gsa_ELE_Tmp[i] = s_adc_ns;
#endif // PROPOSED_CEILING_DS_DEBUG
                        }

                        // Get the sum of Line-side noise and ADC noise.
                        //   1) Normalize so, that largest of the two Noises is 0 dB for the sum.
                        //      Since larger noise belongs to 0 dB, it can be directly be used as linear 1.
                        //   2) Transform from dB to linear to sum up the ADC and Line-side noise.
                        //   3) Transform Noise sum to dB.
                        //   4) Undo normalization of point 1).
                        {
                           // Normalize so that largest of the two is 0 dB for the sum.
                           if (s_line_side_ns>s_adc_ns)
                           {
                              l_temp = (int32)(s_adc_ns - s_line_side_ns);
                           }
                           else
                           {
                              l_temp = (int32)(s_line_side_ns - s_adc_ns);
                           }

                           // Since db_to_linear() computes 10^(x/20), instead of 10^(x/10),
                           // so we need to scale input x up by the factor of 2 to get the desired result
                           l_temp <<= 1;
                           db_to_linear((int16)l_temp, &s_mant, &s_exp);
                           // Note: s_mant in 1.15 (Qm.n) format, i.e. 1+15 bit signed integer.
                           //       The range is =[-(2^{m-1}), 2^{m-1}-2^{-n}] = [-1, 0.999969482421875].
                           // The (1<<15) term represents the normalized larger noise (0 dB) for the sum.
                           if (s_exp<0)
                           {
                              l_temp = (1<<15) + (s_mant>>(-s_exp));
                           }
                           else
                           {
                              l_temp = (1<<15) + (s_mant<<s_exp);
                           }

                           // Back to dB
                           l_temp = (int32) ConvertToDB(l_temp);
                           // Since l_temp linear is in Q1.15 and ConvertToDB() assumes the input in Q32.0
                           // We need to adjust the result by -((10log(2^15))*256) = 11559.5518... = ~11560 in Q8.8 dB format
                           l_temp -= 11560;

                           // Undo normalization
                           if (s_line_side_ns > s_adc_ns)
                           {
                              l_temp += s_line_side_ns;
                           }
                           else
                           {
                              l_temp += s_adc_ns;
                           }
                        }

                        // SNR for the tone.
                        // Signal is that with current ceiling proposal and current gs_PGA_set.
                        // Need to reflect the PGA setting that would be possible with the ceiling proposal.
                        l_snr = (int32)gpsa_MeasuredSnrBuf[i] + (int32)(gs_PGA_required_In_PropCeilCalc-gs_PGA_set) - l_temp;

                        // Bitloading margin relative to 1bit in 24.8 format.
                        // Note:
                        //    - target Margin   (0.1dB)
                        //    - coding gain     (Q4.4)
                        //    - SNR for one bit (Q8.8) = 0x0B4F;  /*  11.31 dB =  1 bit  */
                        //    - 1.5dB = 384/256 (Q8.8), i.e. FG's at low boundary
                        // s_delta = (-(gt_SnrMgnConfig.s_TARSNRMds<<8)/10) + (int16)(MAX_CODING_GAIN<<4) - (gsa_ConstellationSNR[1] - (int16)0x180);
                        l_snr = (l_snr+s_delta);

                        if (l_snr >= 0)
                        {
                           // XDSLRTFW-3814
                           if (l_snr > s_SnrDeltaMaxBit)  // SNR for MaxBit, e.g. 15bit relative to 1bit (~ 14*"3.1dB per bit" = 43.4dB)
                           {
                              // Bitloading margin relative to 1bit for MaxBit, e.g. 15bit
                              l_snr = s_SnrDeltaMaxBit;
                           }
                           l_snr += (0x180);              // Add 1.5dB Q8.8 format.
                                                          // Note: This is needed, because SNR = 3dB belongs to 1 bit (1.5dB + 1.5dB from s_delta) and
                                                          //       later l_numbits_acc is calculated as "l_numbits_acc/3.1".
                           l_numbits_acc += l_snr;
                           s_numofbins++;                 // XDSLRTFW-1628
                        }

                     } //if (IS_TONEFLAGSET(guca_RxSupportedToneSet, i))
                  } //for (i = 0; i < gs_RxNumTones; i++)
               }

               gs_NumTones_CeilingOpt_ADC = s_numofbins;    // XDSLRTFW-1628

               // Approximate bits
               //   - Input:  24.8 format.
               //   - Output: 32.0 format
               l_numbits_acc = (l_numbits_acc/794);        // 794 -> 3.1dB Q8.8

               // if the ceiling reduction improved performance,
               //  then log best settings
               //  else stop search (further reductions will not help)
               if (l_numbits_acc > l_numbits_acc_max)
               {
                  l_numbits_acc_max = l_numbits_acc;
                  s_PGA_required_In_PropCeilCalc_best = gs_PGA_required_In_PropCeilCalc;
                  gs_ceil_best = s_ceil;

                  // XDSLRTFW-3379
                  {
                     gl_MaxBits_CeilingOpt_ADC = ((uint32)l_numbits_acc);
                  }
               }
               else
               {
                  // break of while-loop
                  // Note: Max negative value, but correted by the -10, which can be subtracted later!
                  s_addPsd_curr = -32758;
               }
            } //if (!gft_EnableProposedCeilingOpt)
         } // if (gs_PGA_required_In_PropCeilCalc < MIN_PGA)

         // Reduce the proposed Tx psd level by 1 dB and try again.
         s_ceil_prev = s_ceil;
         s_addPsd_curr -= 10;

         // Tracee debug info
         if (s_DebugIdx <= (NUM_CEILING_VALUES-(7+3)))
         {
            gsa_CeilingValues[s_DebugIdx++] = gs_PGA_required_In_PropCeilCalc;
            gsa_CeilingValues[s_DebugIdx++] = gs_ceil_adequate;
            gsa_CeilingValues[s_DebugIdx++] = s_ceil;
            gsa_CeilingValues[s_DebugIdx++] = (int16) (((uint32)l_numbits_acc));
            gsa_CeilingValues[s_DebugIdx++] = (int16) (((uint32)l_numbits_acc) >> 16);
            gsa_CeilingValues[s_DebugIdx++] = s_addPsd_curr;
            gsa_CeilingValues[s_DebugIdx++] = gs_NumTones_CeilingOpt_ADC;
         }
      } //while(s_addPsd_curr>=(-400))

      // Tracee debug info
      if (s_DebugIdx <= (NUM_CEILING_VALUES-(2+1)))
      {
         gsa_CeilingValues[NUM_CEILING_VALUES-3] = gs_ceil_adequate;
         gsa_CeilingValues[NUM_CEILING_VALUES-2] = gs_ceil_best;
      }

      if (gft_EnableProposedCeilingOpt)
      {
         *ps_proposedCeilOut = gs_ceil_best;
      }
      else
      {
         *ps_proposedCeilOut = gs_ceil_adequate;
      }

      if (*ps_proposedCeilOut == s_maxTxPsdIn)
      {
         *ps_proposedCeilOut = 0x1000;   // send special value indicating no limit under constraints of MaxNomPsd
      }
      else
      {
         *ps_proposedCeilOut = -(*ps_proposedCeilOut);   // convert from absolute psd level to attenuation wrt 0dB
      }

#if defined(PROPOSED_CEILING_DS_DEBUG)
    if (gs_TestCeilingAlgo == -1)
    {
#endif // PROPOSED_CEILING_DS_DEBUG
      // Restore PSD
     for (i = 0; i < gs_RxNumTones; i++)
     {
        /* Adjust measured psd to account for a changed ceiling, for every tone in supported set */
        /* do not use outband tones because none of the vendors seem to specify outband psds correctly */
        if (IS_TONEFLAGSET(guca_RxSupportedToneSet, i))
        {
           // s_MaxPsd becomes the maximum permissible PSD in general at this tone, in 10XdBm/Hz.
           s_MaxPsd = gsa_PsdPerTone[i];              // gives absolute tone Psd

           // s_ActPsd is the far-end PSD being used for channel discovery.
           s_ActPsd = GetTonePsd(i, pt_PSDDescActIn, gs_RxNumTones);  //XDSLRTFW-3838 gives tone Psd wrt MaxNomPsd
           s_ActPsd = s_ActPsd + s_maxTxPsdIn;         // absolute ton Psd

           // If this is not first pass through ceiling trials loop,
           // restore PSD buffer to its original setting as it was prior to the modification of previous pass.
           if (s_addPsd_curr != (-s_MaxAtpCeil - s_maxTxPsdIn))
           {
              s_target = s_ceil_prev;
              // target PSD is lower of s_MaxPsd and s_ceil
              if (s_target>s_MaxPsd)
              {
                 s_target = s_MaxPsd;
              }

              //Take difference between target PSD and far-end PSD, and add this to measured psd.
              s_addPsd_prev = s_target-s_ActPsd;
              gpsa_MeasuredSnrBuf[i] = gpsa_MeasuredSnrBuf[i] - (((int32) s_addPsd_prev)<<8)/10;
           }
        }
     }
#if defined(PROPOSED_CEILING_DS_DEBUG)
    }
#endif // PROPOSED_CEILING_DS_DEBUG
   }
   else
   {
      *ps_proposedCeilOut = 0x1000;
   }

   gs_ceil_adequate = *ps_proposedCeilOut;

   // Tracee debug info
   {
      gsa_CeilingValues[NUM_CEILING_VALUES-1] = *ps_proposedCeilOut;
      DSH_SendStream(DSH_PROPOSED_CEILING_DS,NUM_CEILING_VALUES*sizeof(int16),&gsa_CeilingValues[0]);
   }

   guc_PgaState = TRAINING_DONE;
}
