/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   BgComputeQln.c
*
*   This file contains the functions used to compute the QLN (Quiet Line Noise).
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "dsp_op.h"
#include "mul.h"
#include "ConvertToDB.h"
#include "decimalgain.h"


#include "noiseacc.h"
#include "psd_b.h"
#include "acc40.h"
#include <stdlib.h>
#include "TxPSDControl.h"
#include "sys_const.h"
#include "vdsl_const.h"
#include "PGAHandler.h"
#include "SharedFuncs.h"
#include "cmv.h"


void EstimateADC_LineSideNoise(void);

//int16 gs_StreamComp[4096];

#define HLOG_FLAG_OFF            (0)
#define QLN_NEGATIVE_128_DB      (210)

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : void BgComputeQln(void)
 *
 *  Prototype:  void BgComputeQln(void)
 *
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *   Return:
 *      None
 *
 *  Notes:      Background function to compute Qln
 *              !!QLN should be done always for all tones!!
 *
 *------------------------------------------------------------------------
 *^^^
 */
void BgComputeQln(void)
{
   uint8 uc_PSD;
   int16 i,k, s_G, s_near_tone_pow, s_max_psd_near;
   int16 s_mant, s_exp, s_psd_near_norm;
   int16 *psa_PSD;
   int32 l_temp;
   int32 l_acc_psd_near;
   int16 *psa_PsdIn;
   int16 s_step_size =0;

   gft_StrongNoiseDetected = 0;  // 1-> Strong noise detected, 0 -> Strong noise not detected
   gus_QlnLow = 0;
   gus_QlnHigh = 0;

   // XDSLRTFW-2686 (Start_End)
   // In case of 8K tones, QLN is calculated for every 8th tone, but QLN is needed for every 16 tone.
   // Note: This quick implementation is not fully standard conform.
   if(gs_RxLog2FftLength == DS_LOG2_FFT_LENGTH_16384)
   {
      s_step_size = 1;
   }

   //Estimate ADC and Line-side noise for computing the proposed ceiling.
   if(gft_EnableProposedCeilingOpt)
   {
      EstimateADC_LineSideNoise();
      DSH_SendStream(DSH_ADC_NOISE_PSD,512*sizeof(int16),(void*)gpsa_MedleyTempFDQCoeffs);
   }

   //Correct the RX PSD by removing the front end filters
   if(gft_EnableRxPathCorrection == TRUE)
   {
      psa_PsdIn = gpsa_MeasuredSnrBuf;
      psa_PSD = gsa_CommonMemoryBlock0;

      // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)

      // XDSLRTFW-976 : BUG_DS_ALL_ALL_QLN
      GenerateRxPathPsdCorrectionVector();
//      DSH_SendStream(DSH_RX_PATH_COMP_DB,gs_RxNumTones*sizeof(int16),(void*)gs_StreamComp);

      //Disable Hlog Flag
      ApplyRxPathPsdCorrection(psa_PsdIn, psa_PSD, HLOG_FLAG_OFF);
      // XDSLRTFW-976 : BUG_DS_ALL_ALL_QLN
      // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)
      DSH_SendStream(DSH_QLN_PSD_DB,gs_RxNumTones*sizeof(int16),(void*)gsa_CommonMemoryBlock0);
   }
   else
   {
      psa_PSD = gpsa_MeasuredSnrBuf;
   }

   // Note: gt_DfeAfeGainSettings.s_Rx_FFT_Gain_Rms_dB should not be considered for PSD(f) to Line side transformation.
   //       The variable is only for PGAHandler(), i.e. Calculation of RMS frequency domain for PGA.
   gl_RxPathTotalGain = (int32)gs_RxVarGainDB_Qln +
                       (int32)gs_PGA_set_Qln +
                       (int32)gs_HybridGain_Qln +
                       (int32)gt_DfeAfeGainSettings.s_Rx_Total_TdqToAfeInterface_Gain_dB +
                       (int32)gt_DfeAfeGainSettings.s_Rx_FFT_Gain_dBPerHz +
                       gl_afe_fixed_gain +
                       (int32)gt_DfeAfeGainSettings.s_RxPathTrafo_Gain_dB +
                       (int32)gt_DfeAfeGainSettings.s_AfeLevelShiftDfe_Gain_dB +
                       (int32)gt_PgaGainCorrectionDslPath.s_corr_gain_rxa_dB_out +
                       (int32)gs_QlnHlogCorrection;


   for (i = 0; i < gs_RxNumTones; i=i+8)
   {
      // Initialise for each group, i.e. to MIN signed value.
      s_max_psd_near = -32768;

      //Find the maximum PSD in this 8 tone group
      for (k = i; k < (8+i); k++)
      {
         s_near_tone_pow = psa_PSD[k];

         // Max near-end power, dB, 8.8 format
         if (s_near_tone_pow >= s_max_psd_near)
         {
            s_max_psd_near = s_near_tone_pow;
         }
      }

      // Get the normalizing value of PSD
      // Note the linear value of PSD is in Q19.13 format
      // Hence, we can't handle dB values greater than the
      // linear value (2^19 - 1) which corresponds to 57 dB
      s_psd_near_norm = s_max_psd_near - (int16) (57<<8);

      // Sum the PSD value over 8 subcarriers in a group
      l_acc_psd_near = 0;               // Clear the accumulated power
      for (k = i; k < (8+i); k++)
      {
         // Do the normalization wrd to max psd value
         s_near_tone_pow = psa_PSD[k] - s_psd_near_norm;

         if (s_near_tone_pow >= 0)
         {
            // Since db_to_linear() computes 10^(x/20), instead of 10^(x/10),
            // so we need to scale input x up by the factor of 2 to get the desired result
            s_near_tone_pow <<= 1;

            //Convert the dB to linear (i.e., compute 10^(Psd/20))
            db_to_linear(s_near_tone_pow, &s_mant, &s_exp);

            // Convert the mantissa from Q1.15 to Q23.9 format
            s_exp = s_exp - 6;

            l_temp = (int32)s_mant;

            if(s_exp > 0)
            {
               l_temp <<= s_exp;
            }
            else if(s_exp < 0)
            {
               l_temp = (l_temp + (1<<(s_exp-1))) >> s_exp;
            }

            // Accumulate the linear psd values in Q23.9 format
            // to keep the precision
            l_acc_psd_near +=l_temp;
         }
      } /* for ( k = i; k < (8+i); k++) */


      // Compute the group index
      s_G = i>>SUBCAR_GROUP_SIZE_LOG2_8;
      {
         // Compute the average of the linear value over 8 subcarriers
         l_acc_psd_near >>= SUBCAR_GROUP_SIZE_LOG2_8;

         // Convert back to log domain in Q8.8 format
         l_temp = ConvertToDB(l_acc_psd_near);

         // Since l_temp linear is in Q23.9 and ConvertToDB() assumes the input is Q32.0
         // we need to adjust the result by -10log(2^9)*256 = 6935 = 0x1B17 (Q8.8)
         l_temp += s_psd_near_norm - 0x1B17;
         l_temp -= gl_RxPathTotalGain;

         // Ensure that the QLN is in the range of -150 to -23 dBm/Hz
         // - 8-bit unsigned integer n(k) shall be reported
         // - QLN = -23 - (n(k)/2) dBm/Hz gets calculated out of this value
         // -> n(k) = -(QLN + 23)*2
         // - granularity of 0.5dB
         if (( l_temp >= (-150*256)) && ( l_temp <= (-23*256)))
         {
            // Consider:
            // - 23dB offset in Q8.8
            // - Round to a bigger negative QLN value, i.e. rounding for 0.5 granularity
            l_temp =  - (l_temp + (23*256) + (1<<6));

            // - multiply by 2, i.e. do one shift less during Q8.8 format consideration
            uc_PSD = (uint8)(l_temp >> 7) & 0xFF;

            // XDSLRTFW-4214: Low Noise (eg WHITE Noise) detection Algorithm (start)
            // QLN(Tone) = -23 - uc_PSD(Tone)/2
            // gus_QlnLow value increments if QLN(Tone) < -128 dB
            // otherwise gus_QlnHigh counter will be incremented.

            //TODO: for final release gus_QlnLow and gus_QlnHigh will be replaced by local variable
            if (uc_PSD >= QLN_NEGATIVE_128_DB)
               gus_QlnLow++;
            else
               gus_QlnHigh++;
            // XDSLRTFW-4214: Low Noise (eg WHITE Noise) detection Algorithm (End)

         }
         else
         {
            uc_PSD = (uint8)OUT_OF_RANGE_QLN;
         }
      }

      // Get the PSD value for messaging
      guca_QLN[s_G >> s_step_size] = uc_PSD;
      guca_QLN_tmp[s_G] = uc_PSD;
   } /* for ( i = 0; i < gs_RxNumTones; i=i+8) */

   // XDSLRTFW-4214: Low Noise (eg WHITE Noise) detection Algorithm
   // if more than 15% of QLN has more than -128 dB noise then strong noise detection is declared.
   // in other words if more than 85 % of QLN has less than -128 dB nose then low nose detection is declared (ie. gft_StrongNoiseDetected = 0)
   if ((gus_QlnLow*100 ) < (gus_QlnLow+gus_QlnHigh)*85 )
      gft_StrongNoiseDetected = 1;

   // XDSLRTFW-3344 (Start)
   for (i = 0; i < gs_RxNumTones; i++)
   {
      s_near_tone_pow = psa_PSD[i];

      l_temp = s_near_tone_pow;
      l_temp -= gl_RxPathTotalGain;

      // Ensure that the QLN is in the range of -150 to -23 dBm/Hz
      // - 8-bit unsigned integer n(k) shall be reported
      // - QLN = -23 - (n(k)/2) dBm/Hz gets calculated out of this value
      // -> n(k) = -(QLN + 23)*2
      // - granularity of 0.5dB
      if (( l_temp >= (-150*256)) && ( l_temp <= (-23*256)))
      {
         // Consider:
         // - 23dB offset in Q8.8
         // - Round to a bigger negative QLN value, i.e. rounding for 0.5 granularity
         l_temp =  - (l_temp + (23*256) + (1<<6));

         // - multiply by 2, i.e. do one shift less during Q8.8 format consideration
         uc_PSD = (uint8)(l_temp >> 7) & 0xFF;
      }
      else
      {
         uc_PSD = (uint8)OUT_OF_RANGE_QLN;
      }
      guca_QLN_PerTone_Internal[i] = uc_PSD;
   }
   DMAtoSDRAM_PerTone(QLN_PERTONE);
   // XDSLRTFW-3344 (End)

   DSH_SendStream(DSH_QLN,512,(void*)guca_QLN);
   guc_QlnCalcState = TRAINING_DONE;

}

void EstimateADC_LineSideNoise(void)
{
   int16 i, k, s_near_tone_pow;
   int16 s_mant, s_exp;
   int16 s_max_for_adc, s_max_for_line_side;
   int32 l_acc_psd_near,l_temp1, l_temp;


   // XDSLRTFW-2686 (Start_End)
   // In case of 8K tones, QLN is calculated for every 8th tone, but QLN is needed for every 16 tone.
   // Note: This quick implementation is not fully standard conform.
   int16 s_shift_value;

   s_shift_value = SUBCAR_GROUP_SIZE_LOG2_8;
   if(gs_RxLog2FftLength == DS_LOG2_FFT_LENGTH_16384)
   {
      s_shift_value = SUBCAR_GROUP_SIZE_LOG2_16;
   }

   //*******************************************************************************************
   // Estimate using a L-S fit, the PSDs of ADC noise and line-side noise, based on the QUIET state PSDs
   // measured with MAX_PGA (in gsa_SnrBuf) and MIN_PGA (in gsa_CommonMemoryBlock0).
   // In the neighborhood of a particular tone, the L-S equations for the PSD estimates are
   //      ADC = pl*a/(a-b) - ph*b/(a-b)
   //      Line-side noise = ph/(a-b) - pl/(a-b)
   // where ph is the mean measured psd (converted to linear) with setting MAX_PGA and
   // pl is the mean measured psd (converted to linear) with setting MIN_PGA. Here,
   // a=10^(MAX_PGA/10) and b = 10^(MIN_PGA/10).
   // We use the approximation (a-b) ~= a to arrive at the simplified equations
   //      ADC ~= pl - ph*b/a
   //      Line-side noise ~= ph/a - pl/a.
   //*******************************************************************************************

#define      ADJ_FOR_MEAN_QLN_DB               (2312)      //10*log10(8) in 8.8 dB format.
   // Estimate ADC and line-side noise PSDs only if ceiling optimization is enabled
   for ( i = 0; i < gs_RxNumTones; i=i+8)
   {
      // Determine the maximum element that will appear in the psd accumulations,
      // so that appropriate normalization can be used.
      // Note 3 dB subtracted from psd to account for real^2+imag^2 in psd calc.
      s_max_for_adc = (int16) 0X08000;
      s_max_for_line_side = (int16) 0X08000;

      for (k=i; k<i+8; k++)
      {
         //For ADC ~= pl - ph*b/a
         s_near_tone_pow = gsa_CommonMemoryBlock0[k] - (3<<8) - (int16) ADJ_FOR_MEAN_QLN_DB;
         if (s_near_tone_pow>s_max_for_adc)
         {
            s_max_for_adc = s_near_tone_pow;
         }
         s_near_tone_pow = gsa_SnrBuf[k] - (3<<8) - (int16) ADJ_FOR_MEAN_QLN_DB + (int16) MIN_PGA - gs_PGA_set_Qln;
         if (s_near_tone_pow>s_max_for_adc)
         {
            s_max_for_adc = s_near_tone_pow;
         }

         //For Line-side noise ~= ph/a - pl/a.
         s_near_tone_pow = gsa_CommonMemoryBlock0[k] - (3<<8) - (int16) ADJ_FOR_MEAN_QLN_DB - gs_PGA_set_Qln;
         if (s_near_tone_pow>s_max_for_line_side)
         {
            s_max_for_line_side= s_near_tone_pow;
         }
         s_near_tone_pow = gsa_SnrBuf[k] - (3<<8) - (int16) ADJ_FOR_MEAN_QLN_DB  - gs_PGA_set_Qln;
         if (s_near_tone_pow>s_max_for_line_side)
         {
            s_max_for_line_side = s_near_tone_pow;
         }
      } //for (k=i; k<i+8; k++)


      // Evaluate ADC ~= pl - ph*b/a
      // pl and ph are accumulations performed with normalization.
      // In the accumulations, we will sum 8 32b nonnegative numbers, and subtract 8 32b nonnegative numbers, so
      // we avoid overflow if the max number is (2^31-1)/8 which is > 2^27, which is > 81 dB > 63 dB.
      // Normalize for maximum of 63 dB, since the dB numbers get multiplied by 2 before being passed
      // to db_to_linear(), which requires input in range [-128,127).
      l_acc_psd_near = 0;
      for (k=i; k<i+8; k++)
      {
         // pl
         s_near_tone_pow = gsa_CommonMemoryBlock0[k] - (3<<8) - (int16) ADJ_FOR_MEAN_QLN_DB
                           - s_max_for_adc + (int16) (63<<8) ;
         // Multiply normalization result by 2 since db_to_linear calculates 10^(x/20) rather than 10^(x/10).
         s_near_tone_pow <<= 1;
         db_to_linear(s_near_tone_pow, &s_mant, &s_exp);
         //s_mant is in 1.15 format.
         if (s_exp>=15)
         {
            l_temp = ((int32)s_mant)<<(s_exp-15);
         }
         else
         {
            l_temp = ((int32)s_mant)>>(15-s_exp);
         }

         l_temp1 = l_temp;

         // - ph*b/a
         s_near_tone_pow = gsa_SnrBuf[k] - (3<<8) - (int16) ADJ_FOR_MEAN_QLN_DB + (int16) MIN_PGA - gs_PGA_set_Qln
                           - s_max_for_adc + (int16) (63<<8);
         s_near_tone_pow <<= 1;
         db_to_linear(s_near_tone_pow, &s_mant, &s_exp);
         if (s_exp>=15)
         {
            l_temp = ((int32)s_mant)<<(s_exp-15);
         }
         else
         {
            l_temp = ((int32)s_mant)>>(15-s_exp);
         }

         // Sometimes pl - ph*b/a turns out to be negative due to noisy measurement.
         // In that case, simply discard to avoid accumulating negative psds.
         // Otherwise, perform accumulation.
         if ((l_temp1-l_temp) > 0)
         {
            l_acc_psd_near += (l_temp1-l_temp);
         }


      }//for (k=i; k<i+8; k++)

      if (l_acc_psd_near<1)
      {
         l_acc_psd_near = 1;
      }
      s_near_tone_pow = ConvertToDB(l_acc_psd_near);
      // Remove normalization
      s_near_tone_pow += (s_max_for_adc - (int16) (63<<8));

      //gsa_CommonMemoryBlock0[RX_MAX_NUM_TONES+(i>>3)] = s_near_tone_pow;
      // gpsa_MedleyTempFDQCoeffs is holding the ADC noise PSD.
      gpsa_MedleyTempFDQCoeffs[i>>s_shift_value] = s_near_tone_pow;
      // Evaluate Line-side noise ~= ph/a - pl/a
      l_acc_psd_near = 0;
      for (k=i; k<i+8; k++)
      {
         // ph/a
         s_near_tone_pow = gsa_CommonMemoryBlock0[k] - (3<<8) - (int16) ADJ_FOR_MEAN_QLN_DB - gs_PGA_set_Qln
                           - s_max_for_line_side + (int16) (63<<8);
         s_near_tone_pow <<= 1;
         db_to_linear(s_near_tone_pow, &s_mant, &s_exp);
         if (s_exp>=15)
         {
            l_temp = ((int32)s_mant)<<(s_exp-15);
         }
         else
         {
            l_temp = ((int32)s_mant)>>(15-s_exp);
         }
         l_acc_psd_near += l_temp;

         //- pl/a
         s_near_tone_pow = gsa_SnrBuf[k] - (3<<8) - (int16) ADJ_FOR_MEAN_QLN_DB  - gs_PGA_set_Qln
                           - s_max_for_line_side + (int16) (63<<8);
         s_near_tone_pow <<= 1;
         db_to_linear(s_near_tone_pow, &s_mant, &s_exp);
         if (s_exp>=15)
         {
            l_temp = ((int32)s_mant)<<(s_exp-15);
         }
         else
         {
            l_temp = ((int32)s_mant)>>(15-s_exp);
         }
         l_acc_psd_near += l_temp;
      }//for (k=i; k<i+8; k++)

      if (l_acc_psd_near<1)
      {
         l_acc_psd_near = 1;
      }
      s_near_tone_pow = ConvertToDB(l_acc_psd_near);
      // Remove normalization
      s_near_tone_pow += (s_max_for_line_side - (int16) (63<<8));
      // For now, not storing line-side noise PSD estimate. Would like to have another array similar to
      // gsa_ADC_noise[] for this. Instead using guca_QLN[] for line-side noise estimate in BgComputeQln().
      //gsa_CommonMemoryBlock0[RX_MAX_NUM_TONES+(RX_MAX_NUM_TONES>>8)+(i>>3)] = s_near_tone_pow;

   }//for ( i = 0; i < gs_RxNumTones; i=i+8)

} //EstimateADC_LineSideNoise()

