/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: SelectPilot.c
*
*   This file contains functions to selects pilot tone index.
*
*-------------------------------------------------------------------------------
*/

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "mul.h"
#include "ConvertToDB.h"
#include "SelectPilot.h"

// XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
/*
*-------------------------------------------------------------------------------
*
*   Prototype: void BgSelectPilot(void)
*
*   This function selects the pilot tone based on PSD based SNR during R-O-TRAIN
*   without the knowledge of the band plan.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*      gt_PilotConfig.ta_PilotTones[0].s_PilotToneIdx: (O) pilot tone index
*
*-------------------------------------------------------------------------------
*/
void BgSelectPilot(void)
{
   int32 l_PilotMetric, la_PilotMetricArray[MAX_NUM_RX_BANDS];
   int16 i, s_band, sa_PilotToneIdxArray[MAX_NUM_RX_BANDS];
   int16 s_BandSize, s_Offset;
   int16 s_LeftChannel, s_RightChannel;

   s_band = 0;
   l_PilotMetric = 0;

   memset(sa_PilotToneIdxArray, (int16)(-1), sizeof(int16)*MAX_NUM_RX_BANDS);

   // try to select a single pilot tone based on estimated bandplan
   for (i=0; i<gs_NumOfRxBands; i++)
   {
      if (gt_PilotConfig.s_PilotToneControl & ADD_OFFSET_FROM_BANDEDGE)
      {
         // set the start tone index away from the band edge by minimum of predefined value and 1/4 of band size
         s_BandSize = gsa_RxBandRightChannel[i] - gsa_RxBandLeftChannel[i] + 1;
         s_Offset = MIN(gs_PilotSelectOffset, (s_BandSize >> 2));
      }
      else
      {
         s_Offset = 0;
      }

      s_LeftChannel = (int16)(gsa_RxBandLeftChannel[i]+s_Offset);
      s_RightChannel = (int16)(gsa_RxBandRightChannel[i]-s_Offset);

      // We need to make sure the pilot tone is not selected among the US Tssi tones.
      // Since BgSelectPilot is called before decoding O-SIGNATURE, we don't know yet the exact US0 tone usage (the CL message from CO does not contain this info).
      // Therefore, we just offset the pilot tone by 32 from the DS1 left edge, if in Ghs we negotiated any kind of US0.
      if ((gt_ProfileAct.ul_AnxAUS0PsdSelected & CNFG_V2_ANXA_US0_ALL_MASK) ||
            (gt_ProfileAct.us_AnxBUS0PsdSelected & CNFG_V2_ANXB_US0_ALL_MASK) ||
            (gt_ProfileAct.us_AnxCUS0PsdSelected & CNFG_V2_ANXC_US0_ALL_MASK))
      {
         if (s_LeftChannel < gsa_RxBandLeftChannel[0]+32)
         {
            s_LeftChannel = gsa_RxBandLeftChannel[0]+32;
         }
      }

      // Limit the maximum pilot tone index, since our PLL coefficients have not yet been verified for indexes > 4095
      if(s_RightChannel >= gs_MaxPilotToneIndex)
      {
         s_RightChannel = gs_MaxPilotToneIndex;
      }

      SelectPilotTone(gpsa_MeasuredSnrBuf, s_LeftChannel, s_RightChannel, &sa_PilotToneIdxArray[i], &la_PilotMetricArray[i]);

      // Store the band and metric info for the best pilot tone
      if (la_PilotMetricArray[i] > l_PilotMetric)
      {
         l_PilotMetric = la_PilotMetricArray[i];
         s_band = i;
      }
   }

   // Copy the tone index of the best pilot tone to pilot tone index 0
   gt_PilotConfig.ta_PilotTones[PT_ARRAY_IDX_0].s_PilotToneIdx = sa_PilotToneIdxArray[s_band];

   // if the first try failed, try again with blind search
   // select a single pilot tone given PSD based SNR
   // start tone of 20 and end tone of 3000 are chosen arbitrarily
   // since the bandplan is not yet known at this point
   if (gt_PilotConfig.ta_PilotTones[PT_ARRAY_IDX_0].s_PilotToneIdx == 0)
   {
      //XDSLRTFW-2387 (Start_End)
      SelectPilotTone(gpsa_MeasuredSnrBuf, 33, 3000, &gt_PilotConfig.ta_PilotTones[PT_ARRAY_IDX_0].s_PilotToneIdx, &l_PilotMetric);
   }
   //XDSLRTFW-2387 (start)
   // if above fn call covers if there is any bugs in BandPlan conveyed in GHS
   // If we still see failures then we cannot select pilot tone for threshold 15dB. So reduce it to 12 dB.
   // to avoid internal CPE failure.
   // Please not that this is initial pilot tone selection and none of the Rx algos are completed.
   // we do call "BgSelectMultiPilot" after Rx Algorithms and use 15dB as threshold.
   if (gt_PilotConfig.ta_PilotTones[PT_ARRAY_IDX_0].s_PilotToneIdx == 0)
   {
      guc_PilotSelectionFailure++;
      gft_ReducePilotThr = TRUE;
      SelectPilotTone(gpsa_MeasuredSnrBuf, 33, 3000, &gt_PilotConfig.ta_PilotTones[PT_ARRAY_IDX_0].s_PilotToneIdx, &l_PilotMetric);
      gft_ReducePilotThr = FALSE;
   }
   //XDSLRTFW-2387 (end)

   if(gsa_Optn2_AlgControl[1] & OPTN_UseForcedPilot)
   {
      gt_PilotConfig.ta_PilotTones[PT_ARRAY_IDX_0].s_PilotToneIdx = TESTArray[TEST_RxTestPilotTone];
      gt_PilotConfig.te_UsedPTArrayIdx = PT_ARRAY_IDX_0;
      gt_PilotConfig.te_BestPTArrayIdx = PT_ARRAY_IDX_0;
   }

   // save pilot tone index and other debug info
   gs_PilotToneIdx_Initial = gt_PilotConfig.ta_PilotTones[PT_ARRAY_IDX_0].s_PilotToneIdx;

   if(gt_PilotConfig.ta_PilotTones[PT_ARRAY_IDX_0].s_PilotToneIdx >= 2)
   {
      memcpy(&gsa_SnrOfPilotTone_Initial[0], &gpsa_MeasuredSnrBuf[gt_PilotConfig.ta_PilotTones[PT_ARRAY_IDX_0].s_PilotToneIdx-2], sizeof(int16)*5);
   }

   gt_PilotConfig.ta_PilotTones[PT_ARRAY_IDX_0].l_Metric = l_PilotMetric;

   gs_RxBkgdProcessFlag = TRAINING_DONE;
}

// XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement
