/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: Bitload.c
*
*   This file contains functions used in bitload.
*
*-------------------------------------------------------------------------------
*/

//************************************************************************************************************************
// 27/11/2014 Anantha Ramu: Coding gain changed for the case of Intra DTU interleaving.
//                          Grep for XDSLRTFW-1617
// 22/11/2017 Abu Rahman
//            XDSLRTFW-3556: VRx518 shows different method_0 attainable datarate than VR9(R7)
//            Introduced a CMV based option to select Method_0 framing based DS ATTNDR or
//            channel capacity based DS ATTNDR calculation algorithm.
//                Set CNFG 86 3 = 0 : to select frame based Method_0 ATTNDR algorithm or
//                Set CNFG 86 3 = 1 : to select channel capacity based Method_0 ATTNDR algorithm (VR9-R7 like)
//            Note that this switching works only with Method_0 configuration
//            SEARCH PATTERN: XDSLRTFW-3556
//*************************************************************************************************************************
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "Bitload_support.h"
#include "socmessage.h"
#include "CalcMedleySnrMargin.h"
#include "CalcMaxBits.h"
#include "decimalgain.h"
#include "cmv.h"
#include "bitload.h"
#include "Framing_VDSL2.h"
#include "nomatp.h"
#include "mul.h"
#include "ghs.h"
#include "dsp_op.h"
#include "SharedFuncs.h"

int16 gs_NumGetCodingGain;
int16 gs_CodingGain_dbg;


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void InitBitloading(void)
*
*   This function initializes parameters for bitloading.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void InitBitloading(void)
{
   int16 s_channel;
   int16 s_CurRxBand;
#ifdef FAST_PATH_CRC_WORKAROUND
   int16 s_bc;
   TPS_TC_BearerChanAct_t *pt_BearerChanAct;
#endif // FAST_PATH_CRC_WORKAROUND

   int16 s_ActTARSNRM;

   gus_BitloadErrorCode = BITLOAD_NO_ERROR;

   // XDSLRTFW-3751 (Start_End)
   ClearSetPilotTonesInSupportedSet((int16)CLEAR_TONES_SUPPORTED_SET);


   /*  Clear the bit allocation tables for all bands */
   for (s_CurRxBand = 0; s_CurRxBand < gs_NumOfRxBands; s_CurRxBand++)
   {

      for (s_channel = gsa_BitloadLeftChannel[s_CurRxBand]; s_channel <= gsa_BitloadRightChannel[s_CurRxBand]; s_channel++)
      {
         ghpuca_RxBat_Inactive[s_channel] = 0;
         ghpsa_RxFineGains_Inactive[s_channel] = 0;
      }
   }

   // clear a buffer to hold channel capacity per check byte
   memset(gla_MaxSumLp, 0, sizeof(int32)*MAX_NUM_CHECK_BYTE);

   //Compute the intial Medley NOMATP
   gft_BitloadOK = CalcInitNOMATP();

   //==========================================================================
   // set bitload input parameters for VDSL2
   //==========================================================================
   if (gus_ModemOperationMode_Status & MODEM_OPERATION_MODE_VDSL2)
   {
      if(gft_BitloadOK == FAIL)
      {
         return;
      }

      gt_BitloadParam.s_MaxR = gta_DsLatencyPath[INLV].s_MaxR;

      s_ActTARSNRM = gt_SnrMgnConfig.s_TARSNRMds;

      gs_RxMaxConstSize = gt_ModemConfig.s_DsMaxConstSize;
      gs_RxMinConstSize = gt_ModemConfig.s_DsMinConstSize;

      if (!(gt_NoiseMarginChange.s_NM_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_DELTA))
      {
         s_ActTARSNRM += gt_NoiseMarginChange.s_NM_Delta;
      }
      gt_BitloadParam.s_TarSnrMgn = ((s_ActTARSNRM<<8)+5)/10;


#ifdef FAST_PATH_CRC_WORKAROUND


      if (gta_DsBearerChanAct[BC0].s_TypeEnabled != TPS_TC_DISABLED)
      {
         s_bc = BC0;
      }
      else
      {
         s_bc = BC1;
      }
      pt_BearerChanAct = &(gta_DsBearerChanAct[s_bc]);

#endif // FAST_PATH_CRC_WORKAROUND
   }

   gs_MinTargetSnrMargin = gt_BitloadParam.s_TarSnrMgn;
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void BgInitBitloading(void)
*
*   This function initializes parameters for bitloading.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void BgInitBitloading(void)
{
   //Initializes bit allocaiton tables
   InitBitloading();

   //Obtain the frame rate in symbols/second
   gs_DataFrameRate = ComputeSymbolRate(gs_RxNumTones, gs_RxCELength);

   gs_RxBkgdProcessFlag = TRAINING_DONE;
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: FlagT BitloadFixedRate(int32 l_BitsPerSymbol)
*
*   This function allocates fixed # of bits and returns BAT/GST along with
*   minimum margin.
*
*   Input Arguments:
*      s_BytesPerSymbol: # total bytes per symbol
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*      SUCCEED/FAIL
*
*-------------------------------------------------------------------------------
*/

FlagT BitloadFixedRate(int32 l_BitsPerSymbol)
{
   int32 l_FixedSumLp;
   FlagT ft_BitloadOK;

   l_FixedSumLp = l_BitsPerSymbol;

   // add margin to target SNR
   OffsetSNRRequired(gt_BitloadParam.s_TarSnrMgn, gsa_SNRRequired);

   // obtain RS coding gain depending on R
   // JBK ??? - assume FAST path is not used
   gsa_TotalCodingGain[INLV] = GetCodingGain(gs_NumCheckByte, gft_RxTcmFlag);

   gpsa_MeasuredSnrBuf = gsa_SnrBuf;

   // reset the flag to add extra fine gain for forceeven1bit
   ft_BitloadOK = CalcMaxBits(ghpuca_RxBat_Inactive, ghpsa_RxFineGains_Inactive, &gs_RxExtraBits, &gs_RxAvFineGain, l_FixedSumLp, &gl_FinalSumLp);

   //Save the NOMATP before the SNR margin cut
   gs_PreMarginRedNOMATP_dBm = gs_NOMATP_dBm;

   //Compute the final SNR margin and NOMATP
   ComputeSNRM_NOMATP();

   return (ft_BitloadOK);
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ComputeSNRM_NOMATP(void)
*
*   This function computes the SNR margin and NOMATP
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ComputeSNRM_NOMATP(void)
{
   // compute average and minimum margin
   CalcMedleySnrMargin(1, &gs_MedleyAvgMargin, &gs_RxMinMargin, &gs_RxMinMarginTone);

   gt_LineStatusDS.s_SnrMargin = gs_MedleyAvgMargin;
   gs_MedleyMinMargin = gs_RxMinMargin;
   gs_MedleyMinMarginTone = gs_RxMinMarginTone;
   gs_MedleyAvgFineGain = gs_RxAvFineGain;

   //Compute the final NOMATP (after the SNR margin reduction)
   //used by the far-end transmitter
   CalcNOMATP(ghpsa_RxFineGains_Inactive);
}

/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*      void BgBitloadExplicitRate(void)
*
*   Description:      Computes the Bits/ gains/ toneordering table based on gt_rx_cnfig_v2
*
*   Input Arguments:
*
*   Returns:
*
*   Global Variables:
*-----------------------------------------------------------------------------
^^^*/

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ComputeMaxDataRate(void)
*
*   This function computes maximum (attainable) data rate.
*   It is an approximation since actual frame parameters are not computed.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*      gla_MaxSumLp (I): channel capacity per check byte
*      gs_DataFrameRate (I): data frame rate
*      gt_LineStatusDS.ul_AttainableDataRate (O): max data rate
*
*-------------------------------------------------------------------------------
*/

void ComputeMaxDataRate(void)
{
   int16 i, s_R;
   int32 l_NDR, l_temp;

   // find maximum channel capacity and corresponding check byte
   s_R = 0;
   l_NDR = 0;
   gul_ATTNDR_M0_ChCapacityBased = 0;

   for (i=0; i<MAX_NUM_CHECK_BYTE; i++)
   {
      s_R = i << 1;

      // since MaxSumLp has values only for R=0 and R=16,
      if (gla_MaxSumLp[i] > 0)
      {
         // compute the attainable NDR in bits/second
         // l_temp = l_MaxSumLp*gs_DataFrameRate;
         MULS32x16(l_temp, gla_MaxSumLp[i], gs_DataFrameRate);
         l_NDR = l_temp;

         // scale the maximum frame rate by (255-R)/255 = 1 - R/255 ~= 1 - R/256
         l_temp >>= 8;
         {
            int32 l_temp1;
            MULS32x16(l_temp1, l_temp, s_R);
            l_NDR -= l_temp1;
         }
         if ((uint32)l_NDR > gul_ATTNDR_M0_ChCapacityBased)
         {
            gul_ATTNDR_M0_ChCapacityBased = l_NDR;        //XDSLRTFW-3556
         }
      }
   }
   //XDSLRTFW-1298 : ATTNDR
   //If ReTx Mode, the Overhead LP0 is already negated from Max LP
   if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled != RETX_SELECTED)
   {
      gul_ATTNDR_M0_ChCapacityBased -= ((uint32)gt_FormFramingParamsInputs_v2.s_MinMsgOHR * 1000);      //XDSLRTFW-3556
   }
   //XDSLRTFW-1298 : ATTNDR fix
   //XDSLRTFW-1522 (Start)
   //XDSLRTFW-3556: VRx518 shows different method_0 attainable datarate than VR9(R7) (Start)
   if ( ((guc_attndr_method == ATTNDR_METHOD_0) &&
        (gt_DbgImprovedATTNDR.us_ATTNDR_MISC_CONFIGURATION == ATTNDR_ALGO_2_METHOD_0_CHANNEL_CAPACITY_BASED))
       ||(gsa_IndirectStat0[0] == STAT_LoopDiagMode)  )
   {
      // Initialize Method 0 Channel Capacity based ATTNDR for Showtime entry
      gt_LineStatusDS.ul_AttainableDataRate = gul_ATTNDR_M0_ChCapacityBased; // Channel capacity based ATTNDR both for IFEC and ReTx Modes (Training)
   }
   //XDSLRTFW-3556: VRx518 shows different method_0 attainable datarate than VR9(R7)(End)
   //XDSLRTFW-1522 (End)

}

/*^^^
*-----------------------------------------------------------------------------
*   Prototype:
*       void OffsetSNRRequired(int16 s_Margin, int16* psa_SNRRequired);
*
*   Description:
*       Adds a margin offset to gsa_ConstellationSNR[] and put it in
*       gsa_SNRRequired[].
*
*   Input Parameters:
*      s_Margin -- margin added to required SNR
*
*   Output Parameters:
*      psa_SNRRequired -- pointer to array of required SNR per tone
*
*   Returns:
*      none
*
*   Global variables:
*      gsa_ConstellationSNR[]   -- (I) Constellation SNR buffer
*-----------------------------------------------------------------------------
^^^*/
void OffsetSNRRequired(int16 s_Margin, int16* psa_SNRRequired)
{

   int16 i;

   for(i = 0; i <= RX_MAX_BITS_PER_TONE; i++)
   {
      psa_SNRRequired[i] = gsa_ConstellationSNR[i] + s_Margin;
   }
}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: int16 GetCodingGain(int16 s_R, FlagT ft_TcmFlag)
*
*   This function returns combined
*
*   Input Arguments:
*      s_R: # of check bytes
*      ft_TcmFlag: TCM on/off flag
*
*   Output Arguments:
*
*   Returns:
*      s_CodingGain: in Q8.8 format
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
int16 GetCodingGain(int16 s_R, FlagT ft_TcmFlag)
{
   int16 s_CodingGain, s_maxCodingGain;

   s_CodingGain = (int16)guca_RSCodingGain[(s_R >> 1)];

   if (gft_Intra_DTU_Ilv_DS == TRUE)
   {
      s_maxCodingGain = (s_R==16) ? MAX_CODING_GAIN_IDTU_R16 : MAX_CODING_GAIN_IDTU_R08;  //XDSLRTFW-3493(Start_End)
   }
   else if ((s_R==16) && (gft_RestrictDpTo1 == 0))
   {
      s_maxCodingGain = MAX_CODING_GAIN_INTLV;
   }
   else
   {
      s_maxCodingGain = MAX_CODING_GAIN;
   }

   // add the coding gain from TCM in Q4.4 format
   if (ft_TcmFlag)
   {
      s_CodingGain += TCM_CODING_GAIN;
      // set the upper limit to the maximum coding gain
      if (s_CodingGain > s_maxCodingGain)
      {
         s_CodingGain = s_maxCodingGain;
      }
   }

   gs_NumGetCodingGain++;
   gs_CodingGain_dbg = s_CodingGain;

   return(s_CodingGain << 4); // convert to Q8.8 format
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ComputeSumFGainLinSq(int16 s_FineGain_dB, uint16 *pus_ncloaded,
*      int32 *pl_SumFGainLinSq)
*
*   This function finds sum fine gain linear square, assuming all the tones
*   have the minimum finegain.
*
*   Input Arguments:
*      s_FineGain_dB -- the fine gain applied to all the tones
*      pus_ncloaded -- pointer to the number of loaded tones
*
*   Output Arguments:
*      pl_SumFGainLinSq -- pointer to the sum of linear gain square for all loaded tones
*                     which is Q23.9 format
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ComputeSumFGainLinSq(int16 s_FineGain_dB, uint16 *pus_ncloaded, int32 *pl_SumFGainLinSq)
{
   int32 l_SumFGainLinSq;
   int16 s_FGainLin;

   // preserve the 12 most significant bits as these are sent in R_params
   // s_FGgainLin is Q3.9 format
   s_FGainLin = (DecimalGain(s_FineGain_dB) + (int16)(1<<3)) >> 4;

   MULS16(l_SumFGainLinSq, s_FGainLin, s_FGainLin);

   MULS32xU16(*pl_SumFGainLinSq, l_SumFGainLinSq, *pus_ncloaded);
}
