/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   BitloadHandler.c
 *
 *   This file contains the routine that performs bitloading.
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "Bitload.h"
#include "BitloadHandler.h"
#include "Bitload_support.h"
#include "fifo.h"
#include "vdsl_xception.h"
#include "cmv.h"

extern int32 gl_ReTxFramingStart;

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : BitloadHandler
 *
 *  Description:  This function is used to perform bitloading.
 *
 *  Prototype:  void BitloadlingHandler(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Return:
 *
 *  Global Variables Used:
 *      gs_AlgHandlerState       - (I/O) state of bitloading state machine
 *
 *  Notes:
 *   Before BitloadHandler() is called for the first time, the following
 *  initialization needs to be performed:
 *
 *      1) gs_AlgHandlerState = BITLOAD_INIT;
 *
 *------------------------------------------------------------------------
 *^^^
 */

//*************************************************************************
//
// History
// 11/07/2017 Abu Rahman : XDSLRTFW-3554 DS datarate exceeds configured max datarate
//           - Enabled Min-Max Rate check for IKNS and CNXT DSLAMs
//           - Forced LP to the round(Multiple of 8) and then re-compute the rate for
//             IKNS and CNXT DSLAM
//           - Added debug variable to debug framing generation algorithm
//           Grep for XDSLRTFW-3554
//*************************************************************************


void BitloadHandler(void)
{
   int16 s_MaxSnrMargin;

   switch(gs_AlgHandlerState)
   {

      //==============================================================================
      // Initialize variables for bitloading state machine.
      //==============================================================================
   case BITLOAD_INIT:

      gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgInitBitloading);

      s_MaxSnrMargin = gt_SnrMgnConfig.s_MAXSNRMds;
      if(s_MaxSnrMargin != (int16)0xFFFF)
      {
         gs_ApplyMarginReduction = gs_MarginReductionEnableFlag;
      }
      else //MaxSnrMargin of 0xFFFF specifies no margin limit
      {
         gs_ApplyMarginReduction = 0;
      }

      gs_AlgHandlerState = BITLOAD_CALC;
      break;

      //==============================================================================
      // Perform actual bitloading.
      //==============================================================================
   case BITLOAD_CALC:

      if (gs_RxBkgdProcessFlag == TRAINING_DONE)
      {
         if (gft_BitloadOK == FAIL)
         {
            // XDSLRTFW-1958(Start)
            //EnterFailStates(E_CODE_BITLOAD_INIT_FAIL);
            guc_InitSuccessFailCode = INIT_CONFIG_ERROR;
            gul_StoreExceptionCode = E_CODE_BITLOAD_INIT_FAIL;
         }

         gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;

         gl_ReTxFramingStart = gl_RxSymbolCount;  //XDSLRTFW-1610 (START_END)

         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgBitloadAdaptiveRate_VDSL2);

         gs_AlgHandlerState = BITLOAD_CALC_WAIT;
      }

      break;

      //==============================================================================
      // Wait until background task is done
      //==============================================================================
   case BITLOAD_CALC_WAIT:
      if (gs_RxBkgdProcessFlag == TRAINING_DONE)
      {

         //XDSLRTFW-1610 (START_END)
         TESTArray[TEST_NUM_SYM_DS_RETX_FRAMING] = (uint16)gl_RxSymbolCount - gl_ReTxFramingStart;
         // save bitload error code since it can be overwritten in bit-swapping during showtime
         gus_MedleyBitloadErrorCode = gus_BitloadErrorCode;

         //XDSLRTFW-3554: DS datarate exceeds configured max (start)
         // changes were done to debug framing generation code in IFEC mode!
         if (gs_PauseControl == 0x100)
           Pause(gs_PauseControl);

         if (gs_EnableForcedFailState && ((gs_ForcedMaxRate_DS != -1) || (gs_ForcedMinRate_DS != -1) || (gs_ForcedMinINP_DS != -1)|| (gs_ForcedMaxDelay_DS != -1)))
         {
            EnterFailStates(E_CODE_FORCED_FAIL_AFTER_FRAMINIG_GENERATION);
         }
         //XDSLRTFW-3554: DS datarate exceeds configured max (End)
         if (gft_BitloadOK == FAIL)
         {
            // XDSLRTFW-1958(Start)
            // EnterFailStates(E_CODE_BITLOAD_ADAPTIVE_RATE_FAIL);
            guc_InitSuccessFailCode = INIT_CONFIG_NOT_FEASIBLE;
            gul_StoreExceptionCode = E_CODE_BITLOAD_ADAPTIVE_RATE_FAIL;
            // XDSLRTFW-1958(End)
            gs_AlgHandlerState = BITLOAD_DONE;
         }
         else
         {
            //Disable the margin reduction for the remaining operation
            //gs_ApplyMarginReduction = 0;

            gs_AlgHandlerState = BITLOAD_DONE;
            // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start)
            //XDSLRTFW-1522 (Start)
            if(gt_DbgImprovedATTNDR.us_DBG_ATTNDR_METHOD_FORCED != 0)
            {
               guc_attndr_method = (gt_DbgImprovedATTNDR.us_DBG_ATTNDR_METHOD_FORCED) & 0x3;
               gul_ATTNDR_max_delay_octets = (gt_DbgImprovedATTNDR.us_DBG_ATTNDR_MDO_FORCED_LO);
               gul_ATTNDR_max_delay_octets |= ((gt_DbgImprovedATTNDR.us_DBG_ATTNDR_MDO_FORCED_HI)<<16);
               //gul_ATTNDR_max_delay_octets = (gul_ATTNDR_max_delay_octets & 0xFFFFFF) >> 1;
            }

            // XDSLRTFW-2543 (Start_End)
            // The Basic method (METHOD 0)of ATTNDR computation to be used only during LOOP DIAGonstic MODE.
            // For ATTNDR computation in normal mode, we should use Framer.
            if (gsa_IndirectStat0[0] != STAT_LoopDiagMode)
            {
               AddFunctionToBkgdFifo((PtrToBkgdFunc)BgGenFramingATTNDR_VDSL2);
            }
            //XDSLRTFW-1522 (End)
            // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (End)
         }
      }
      break;

   } //switch(gs_AlgHandlerState)

}
