/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: CalcMaxBits.c
*
*   This file contains functions used in bitload.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "Bitload.h"
#include "Bitload_support.h"
#include "AllocateBiGi.h"
#include "QuickAverage.h"
#include "ChooseFineGains.h"
#include "nomatp.h"
#include "CheckMfdqToneSet.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: FlagT CalcMaxBits(uint8 *puca_RxBat,
*      int16 *psa_RxFineGains, int16 *ps_RxExtraBits,
*      int16 *ps_RxAvFineGain, int32 l_TargetLp, int32 *pl_FinalLp)
*
*   This function calculates the maximum number of bits the channel can support
*   for given channel SNRs and required SNRs.
*   It will use fine gains if gft_FineGainOn != 0
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*      maximum number of bits supported by channel
*
*   Global Variables:
*      gusa_ncloaded[] -- (O) the array containing the number of loaded tones for each band
*      gla_SumFGainLinSq[] -- (O) the array containing the sum of the linear gain square
*-------------------------------------------------------------------------------
*/

FlagT CalcMaxBits(uint8 *puca_RxBat, int16 *psa_RxFineGains, int16 *ps_RxExtraBits, int16 *ps_RxAvFineGain, int32 l_TargetLp, int32 *pl_FinalLp)
{
   int16 s_ch; // channel index
   int16 s_qc; // QAM constellation size
   int16 s_SNR;
   int32 l_MaxBits=0;
   int16 s_min_fine_gain;
   int16 s_CurRxBand;
   int32 l_InitialSumBi, l_TargetSumBi, l_FinalSumBi;
   FlagT ft_BitloadOK = FAIL;

#ifdef USE_MFDQ_HW_WORK_AROUND
   int16 k,s_is_anchor;
#endif

   if (gft_NewBitLoadFlag == 0)
   {
      goto _skip_InitBitLoading;
   }

   // reset the flag to add extra fine gain for forceeven1bit whenever
   // the new bitloading is performed
   gft_extrafinegainallocated = 0;

   l_MaxBits = 0;

   if (gft_FineGainOn)
   {
      s_min_fine_gain = gs_min_fine_gain;
   }
   else
   {
      s_min_fine_gain = 0;
   }

   for (s_CurRxBand = 0; s_CurRxBand < gs_NumOfRxBands; s_CurRxBand++)
   {
      //Clean counter
      gusa_ncloaded[s_CurRxBand] = 0;

      // !! Debug code to test maximum bits per tone per band, i.e. max constellation per band!!
      if (gsa_RxMaxConstSize[s_CurRxBand] > 0)
      {
         gs_RxMaxConstSize = gsa_RxMaxConstSize[s_CurRxBand];
      }

      /* Allocate max # bits to each channel */
      for (s_ch = gsa_BitloadLeftChannel[s_CurRxBand]; s_ch <= gsa_BitloadRightChannel[s_CurRxBand]; s_ch++)
      {

         /* clear bit allocation entry */
         puca_RxBat[s_ch] = 0;
         if (gft_FineGainOn)
         {
            psa_RxFineGains[s_ch] = 0;
         }

         // XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
         if((s_ch == gt_PilotConfig.ta_PilotTones[0].s_PilotToneIdx) ||
            (s_ch == gt_PilotConfig.ta_PilotTones[1].s_PilotToneIdx) ||
            (s_ch == gt_PilotConfig.ta_PilotTones[2].s_PilotToneIdx))
         {
            int16 tmp_PT_ArrayIdx = 0;
            if(s_ch == gt_PilotConfig.ta_PilotTones[1].s_PilotToneIdx)
            {
               tmp_PT_ArrayIdx = 1;
            }
            else if(s_ch == gt_PilotConfig.ta_PilotTones[2].s_PilotToneIdx)
            {
               tmp_PT_ArrayIdx = 2;
            }

            // if data-on-pilot is enabled, load 2 bits (if SNR allows) and skip the rest of the loop
            if(gt_PilotConfig.ta_PilotTones[tmp_PT_ArrayIdx].ft_DeRotatePilot)
            {
               // Add the lowest coding gain to the SNR of the pilot tone to be on the conservative side
               s_SNR = gpsa_MeasuredSnrBuf[s_ch] + gsa_TotalCodingGain[FAST];

               // With data-on-pilot enabled, try to enforce 2-bit loading, if not possible switch off de-rotation and load 0-bit
               if ( (s_SNR >= gsa_SNRRequired[2]) && (gs_RxMinConstSize <= 2))
               {
                  // Force a two-bit constellation on data-on-pilot pilot tones
                  // Workaround for issue with fix XDSLRTFW-3918:
                  // Robert: Now we load the 2 bits again here as it was before, the only change is below.

                  puca_RxBat[s_ch] = 2;
                  //Update the number of loaded tone for each band
                  gusa_ncloaded[s_CurRxBand]++;
                  l_MaxBits += 2;
               }
               else
               {
                  // If we don't have sufficient SNR for data-on-pilot, disable it on this pilot tone
                  // Fix for issue with XDSLRTFW-3918: Do not reset the derotate flag here.
                  //gt_PilotConfig.ta_PilotTones[tmp_PT_ArrayIdx].ft_DeRotatePilot = FALSE;
               }
            }

            // skip the normal bitloading procedure for pilot tones
            psa_RxFineGains[s_ch] = 0; // set 0dB fine gain for pilot tones
            continue;
         } // END if(pilot tone)
         // XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement


         // Add the coding gain to SNR
         s_SNR = AddCodingGainToSnr(s_ch, gpsa_MeasuredSnrBuf);

         // decrease fine gain to -infinity for the tones if there SNR is below a threshold
         // from being bitloadable (useful for nomATP )
         // and if the tone is NOT part of MFDQ/FDBK tones
         if ((s_SNR < gsa_SNRRequired[gs_RxMinConstSize] - SNR_THRESH_LOAD_MIN_BITS)
               && (CheckMfdqToneSet(s_ch) != TRUE))
         {
            psa_RxFineGains[s_ch] = NEG_INFINITY_DB;
            continue;
         }

         //set fine gain to min while loading tone
         s_SNR += s_min_fine_gain;

         if (s_SNR >= gsa_SNRRequired[gs_RxMinConstSize])
         {
            for (s_qc = gs_RxMaxConstSize; s_qc >= gs_RxMinConstSize; s_qc--)
            {
               if (s_SNR >= gsa_SNRRequired[s_qc])
               {
                  puca_RxBat[s_ch] = (uint8)s_qc;

                  //Update the number of loaded tone for each band
                  gusa_ncloaded[s_CurRxBand]++;

                  l_MaxBits += s_qc;

                  if (gft_FineGainOn)
                  {
                     psa_RxFineGains[s_ch] = s_min_fine_gain; // We use dB format for now
                  }

                  break; // break out of inner for-loop.
               } //if (s_SNR >= gsa_SNRRequired[s_qc])
            } //for (s_qc = gs_RxMaxConstSize; s_qc >= gs_RxMinConstSize; s_qc--)
         } //if (s_SNR >= gsa_SNRRequired[gs_RxMinConstSize])
      } //for (s_ch = gsa_BitloadLeftChannel[s_CurRxBand]; s_ch <= gsa_BitloadRightChannel[s_CurRxBand]; s_ch++)

   } //for (s_CurRxBand = 0; s_CurRxBand < gs_NumOfRxBands; s_CurRxBand++)

   //Compute the sum of the linear gain square for each band
   for (s_CurRxBand = 0; s_CurRxBand < gs_NumOfRxBands; s_CurRxBand++)
   {
      ComputeSumFGainLinSq(s_min_fine_gain, &gusa_ncloaded[s_CurRxBand], &gla_SumFGainLinSq[s_CurRxBand]);
   }

   //Compute the nominal aggregate transmit power (NOMATP)
   CalcNOMATP(psa_RxFineGains);

   //Always first allocate to the maximum channel capacity and then trim the bits
   gs_ChooseFgThresh = 25;   //start with (25/256) 0.097 dB
   if (gft_FineGainOn)
   {
      // adjust Fine Gain and add extra bits
      *ps_RxExtraBits = ChooseFineGains(puca_RxBat, psa_RxFineGains, 0x7FFFFFFF, 0,0); //XDSLRTFW-3807
   }
   else
   {
      // fine gains not enabled
      *ps_RxExtraBits = 0;
   }

   ft_BitloadOK = SUCCEED;

_skip_InitBitLoading:

   // Check if we are in adaptive rate or fixed rate scenario. Adaptive rate we
   // calculate the maximum number of bits which can be supported; while in fixed
   // rate scenario, we compute the BAT as much as required, this is based on
   // l_targetLp == 0x7FFFFFFF, implies rate adaptive mode

   if (l_TargetLp < 0x7FFFFFFF) // Fixed rate case
   {
      ft_BitloadOK = AllocateBiGi(puca_RxBat, psa_RxFineGains, ps_RxExtraBits, l_TargetLp);
      if(ft_BitloadOK == FAIL)
      {
         return(ft_BitloadOK);
      }
   }

   // Compute no. of channels having bits, and channels having one bit if tcm is enabled.
   GetBatStats(puca_RxBat, (int16 *)(void *)&gus_Rx_Tcm_Num1bits, &gs_Tcm_Oh, &l_InitialSumBi);

   // If the number of tones having one bit loaded is not even, then choose an arbitrary
   // tone with one bit, and set it to zero.  Then adjust the other parameters accordingly.
   // We choose the tone to kill from the end (as it is more easy to find a tone with one
   // bit in the higher tones than in the lower tones for good MedleySNRs.

   if ((gus_Rx_Tcm_Num1bits & 0x1) && (gft_RxTcmFlag == TRUE))
   {
      //Choose the tone from the end
      for (s_CurRxBand = gs_NumOfRxBands-1; s_CurRxBand >= 0; s_CurRxBand--)
      {
         for (s_ch = gsa_BitloadRightChannel[s_CurRxBand]; s_ch >= gsa_BitloadLeftChannel[s_CurRxBand]; s_ch--)
         {
            if (puca_RxBat[s_ch] == 1)
            {
               //Adjust the fine gain
               UpdateFGSumSqAndNOMATP(s_ch, psa_RxFineGains[s_ch], 0, &gla_SumFGainLinSq[s_CurRxBand], 1);

               puca_RxBat[s_ch] = 0;
               psa_RxFineGains[s_ch] = 0;
               gusa_ncloaded[s_CurRxBand]--;

               // One bit correction to the value of l_MaxBits.
               l_MaxBits--;
               gus_Rx_Tcm_Num1bits--;

               goto _end_of_outer_loop;
            }
         }
      }
   } // if (gus_Rx_Tcm_Num1bits & 0x1)

_end_of_outer_loop:

   //Update the final NOMATP in dBm (multiple of 0.1 dB) stored in gul_NOMATP_dBm
   CalcFinalNOMATP();

   //Perform the final check
   if(ft_BitloadOK == SUCCEED)
   {
      //Get the final sum of BAT and the number of TCM overhead bits
      GetBatStats(puca_RxBat,(int16 *)(void *) &gus_Rx_Tcm_Num1bits, &gs_Tcm_Oh, &l_FinalSumBi);

      *pl_FinalLp = l_FinalSumBi - gs_Tcm_Oh;

      if (l_TargetLp < 0x7FFFFFFF)
      {
         l_TargetSumBi = l_TargetLp + gs_Tcm_Oh;
      }
      else
      {
         l_TargetSumBi = l_MaxBits+*ps_RxExtraBits;
      }

      if (l_FinalSumBi != l_TargetSumBi)
      {
         gus_BitloadErrorCode = BITLOAD_ERROR_FINAL_CHECK;
         ft_BitloadOK = FAIL;
      }
      else if((gft_RxTcmFlag) && (gus_Rx_Tcm_Num1bits & 0x1))
      {
         gus_BitloadErrorCode = BITLOAD_ERROR_ODD_1BIT_TONES;
         ft_BitloadOK = FAIL;
      }
   }

   return (ft_BitloadOK);
}
