/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: CalcMaxIlvDilvSize.c
*
*   This file contains functions for interleaver partition.
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// CalcMaxIlvDilvSize.c
//
// History
//
// 21/01/2016 Palaksha XDSLRTFW-2546: No sync in VDSL field line Turkey- R7MR2,When CO sends field 8 ( max_delay_octet DS,0) in message
// O-PMS as  ZERO( MDO-Split configured as 0%) in Fast path mode.
// The root cause is FW bitloading Algorithm takes minimum of FE DILV size  and NE DILV size. In this case 0 will be taken as DILV size
// in bitloading algo.Bit loading uses  DILV size for calculating Max CW size, which will be zero and this results bitload algo fail.
// Solution includes fast path, when field 8 ( max_delay_octet DS,0) is zero, the consider max_delay_octet DS,0 = 512 bytes.
// grep for XDSLRTFW-2546
//
// ************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "mul.h"
#include "Zep_memmap_cnfg.h"


/*
*-------------------------------------------------------------------------------
*
*   Prototype: uint32 CalcMaxDsDilvSize(int16 s_lp)
*
*   This function computes the maximum deinterleaver size that CPE Bitload
*   algorithm can use for DS direction.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*      min(F,Y) if CPE has separate ILV/DILV buffers
*      min(F-G,Y) if CPE has a shared ILV/DILV buffer
*   where
*      F is maximum DS deinterleaver (CPE), gul_HW_DILV_MEM_SIZE
*      Y is maximum DS interleaver delay sent from CO to CPE, gla_MaxInlvDelay
*      G is actual CPE interleaver (or CO de-interleaver) size, ul_ilv_size
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

uint32 CalcMaxDsDilvSize(int16 s_lp)
{
   uint32 ul_NE_limit = 0, ul_FE_limit, ul_ilv_size=0, ul_dilv_size=0;

   // ul_NE_limit = F if NE has separate ILV/DILV
   if (gft_NE_IlvDilvMemType == SEPARATE_ILV)
   {
      ul_NE_limit = gul_HW_DILV_MEM_SIZE[s_lp];
   }
   // ul_NE_limit = F-G if NE has shared ILV/DILV
   else if (gft_NE_IlvDilvMemType == SHARED_ILV)
   {
      int16 s_D, s_I;

      s_D = gt_tx_config_v2.s_Dp[s_lp];
      s_I = gt_tx_config_v2.s_Ip[s_lp];

      //According to Josh, the interleaver buffer size used should be:
      //ILV_MEM = I*(D-M-1)/2 + I*EXT
      //where M = floor(D/I), EXT = 2 for TX and 1+q for RX
      //To be conservative, we set ILV_MEM = I*D/2 + I*EXT
      MULS16(ul_ilv_size, s_D, s_I);
      ul_ilv_size >>= 1;

      //Add I*EXT = I*2
      ul_ilv_size += (s_I<<1);
//XDSLRTFW-1707_30a_RTX_DsUs (Start)
#ifdef VECTORING_BUILD
      gs_rxILVBaseAddrOffset = 0;
#ifdef ILV_DBG_BUFFER
      //If IlvDbgBuffer Enabled
      if((gs_IlvDbgBufferControl & ILV_DBG_BUF_CNTRL_ENABLE_MASK) == TRUE)
      {
         //shift ILV/DILV start by debug buffer size (ILV/DILV gets reduced by debug buffer size)
         gs_rxILVBaseAddrOffset = ILV_DBG_BUFFER_SIZE;
      }
#endif //ILV_DBG_BUFFER
#else //VECTORING_BUILD

      gs_rxILVBaseAddrOffset = SHOWTIME_VECTOR_BUFFER_SIZE - ul_ilv_size;

      if (gs_rxILVBaseAddrOffset  < 0)
      {
         gs_rxILVBaseAddrOffset = 0;
      }
#endif
//XDSLRTFW-1707_30a_RTX_DsUs (End)
      // compute the available CPE deinterleaver memory size
      ul_NE_limit = gul_HW_DILV_MEM_SIZE[s_lp] - ul_ilv_size + gs_rxILVBaseAddrOffset;

      //Re-partition the HW interleaver and deinterleaver memory based on
      //actual use of interleaver memory as calculated above
      gul_HW_ILV_MEM_SIZE[s_lp] = ul_ilv_size;
      gul_HW_DILV_MEM_SIZE[s_lp] -= (gul_HW_ILV_MEM_SIZE[s_lp] + gs_rxILVBaseAddrOffset);

      //Reset the base address of the deinterleaver (keep the interleaver address unchange)
      gula_rxILVBaseAddr[s_lp] = gula_txILVBaseAddr[s_lp]+gul_HW_ILV_MEM_SIZE[s_lp] + gs_rxILVBaseAddrOffset;
   }

   // Bitloading algorithm interprets DILV memory requirement as D*I/2.
   // However, our current efficient deinterleaver needs more than D*I/2 bytes,
   //     DILV memory size = sum_i=0^(I-1) {FIFO length(i)}
   //     where FIFO length(i) = D - floor(D*i/I) + q - 1
   // which gives an upper bound of D*I/2 + D/2 + N.
   // We need to subtract this extra memory requirement, Dmax/2 + Nmax, from NE limit

   // (Note: in 6.2 HW, the following extra memory is about 2*255,
   //  we use the same estimate below which is greater than what is needed for 6.2
   //  to keep simplicity without violating the 6.2 requirement)

   ul_NE_limit -= (gt_FormFramingParamsInputs_v2.s_Dmax >> 1) + 256;

   // FE limit is set by maximum interleave delay parameter that CO sends to CPE
   ul_FE_limit = gla_MaxInlvDelay[s_lp] >> 1;

   //For known CO, the actual interleave memory size may be bigger than that required by the VDSL2 spec
   //so we should take advantage of it
   if(gft_FE_IlvDilvMemType != UNKNOWN_ILV)
   {
      if(gft_FE_IlvDilvMemType == SEPARATE_ILV)
      {
         ul_dilv_size = gul_FE_HW_ILV_MEM_SIZE;
      }
      else if(gft_FE_IlvDilvMemType == SHARED_ILV)
      {
         //ul_ilv_size is the estimated deinterleave memory size used by the far-end
         //modem for given D and I
         //To be conservative, we add 385 to the above number (which comes from Rev2 CO implementation)
         //Thus, we computed the FE ILV memory size limit as below:
         ul_dilv_size = gul_FE_HW_ILV_MEM_SIZE - (ul_ilv_size + 385);
      }

      if(ul_dilv_size > ul_FE_limit)
      {
         ul_FE_limit = ul_dilv_size;
      }

   } //if(gft_FE_IlvDilvMemType != UNKNOWN_ILV)

   //XDSLRTFW-2546 (Start)
   if ((gt_FormFramingParamsInputs_v2.s_MaxDelay == 1) && (ul_FE_limit == 0) )
   {
      ul_FE_limit = 512;
   }
   //XDSLRTFW-2546 (End)

   ul_dilv_size = MIN(ul_NE_limit, ul_FE_limit);

   return (ul_dilv_size);

} //CalcMaxDsDilvSize(void)


