/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2008 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: CalcShowtimeSnrMargin.c
*
*   This file contains functions to calculate Showtime SNR margin.
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// CalcShowtimeSnrMargin.c
//
// History
//
// 18/02/2013 Hanyu/Vinjam: Added code to update VDSL2 DS Attainable Net Data Rate (ATTNDRds) in Showtime.
//            grep for: XDSLRTFW-539 FEATURE_ALL_VDSL2_ATTNDR_Update
//
// 29/05/2013 Anantha Ramu: ATTNDR vales for ReTX was not proper. Modified code to populate initial ATTNDR(
//                          just before showtime) and updates for ATTNDR (in showtime).
//                          Grep for XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr
//
// 22/11/2017 Abu Rahman
//            XDSLRTFW-3556: VRx518 shows different method_0 attainable datarate than VR9(R7)
//            Introduced a CMV based option to select Method_0 framing based DS ATTNDR or
//            channel capacity based DS ATTNDR calculation algorithm.
//                Set CNFG 86 3 = 0 : to select frame based Method_0 ATTNDR algorithm or
//                Set CNFG 86 3 = 1 : to select channel capacity based Method_0 ATTNDR algorithm (VR9-R7 like)
//            Note that this switching works only with Method_0 configuration
//            SEARCH PATTERN: XDSLRTFW-3556
//
// ************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "QuickAverage.h"
#include "dsp_op.h"
#include "vdsl_state.h"
#include "ConvertToDB.h"
// XDSLRTFW-539 FEATURE_ALL_VDSL2_ATTNDR_Update (START_END)
#include "mul.h"
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr (Start)
int32 dbg_delta_l;
//int32 l_ReTxAttndrDeltaRate;
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr (End)

/*
*-------------------------------------------------------------------------------
*
*   Prototype: int16 CalcAvMarginInTenthOfdB(int32 l_TotalMargin, int16 s_NumTones)
*
*   This function computes the average margin by dividing the l_TotalMargin (q8.8)
*   by the number of tones s_NumTones.
*   Then it converts the result from q8.8 to 0.1 dB format
*
*-------------------------------------------------------------------------------
*/
static int16 CalcAvMarginInTenthOfdB(int32 l_TotalMargin, int16 s_NumTones)
{
   int32 l_margin;

   l_margin = (int32)QuickAverage(l_TotalMargin, s_NumTones);

   // round and change q8.8 format to 0.1 dB increments
   l_margin = ((l_margin * 10) + (1 << 7)) >> 8;

   return (int16)l_margin;
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void CalcShowtimeSnrMargin(FlagT ft_ApplyFG, int16 *ps_AvgMargin,
*      int16 *ps_MinMargin, int16 *ps_MinMarginTone)
*
*   This function computes the average and minimum SNR margin for the given SNRs
*   per tone and constellation size per tone.
*
*   Input Arguments:
*      ft_ApplyFG: 1 to apply FG in margin calculation (Medley)
*         assume FG in HW buffer is in dB format, 0 otherwise (Showtime)
*
*   Output Arguments:
*      ps_AvgMargin: pointer to average margin
*      ps_MinMargin: pointer to minimum margin
*      ps_MinMarginTone: pointer to tone index with minimum margin
*
*   Returns:
*
*   Global Variables:
*      gpsa_MeasuredSnrBuf -- (I) pointer to the input SNR buffer
*      ghpuca_RxBat_Inactive -- (I) pointer to the inactive RX BAT table
*      ghpsa_RxFineGains_Inactive -- (I) pointer to the inactive RX BAT table
*      gs_NumOfRxBands -- (I) the number of RX frequency bands
*      gsa_RxBandLeftChannel[] -- (I) an array of the RX left band edge frequency tone
*      gsa_RxBandRightChannel[] -- (I) an array of the RX right band edge frequency tone
*
*-------------------------------------------------------------------------------
*/
#define FECS_MINMARGIN (25)
void CalcShowtimeSnrMargin(FlagT ft_ApplyFG, int16 *ps_AvgMargin, int16 *ps_MinMargin, int16 *ps_MinMarginTone)
{
   int16 j, s_ch, s_qc, s_RxChannelsAllocated, s_RxChannelsAllocatedPerRxBand;
   int16 s_CodingGain, s_margin, s_MinMargin, s_MinMarginTone=0;
   int32 l_TotalMargin, l_TotalMarginPerRxBand;
   int32 l_SumFineGaindB;
   int16 s_FineGain;
   int32 l_Gain;
   //XDSLRTFW-2460 (Start_End)
   int16 s_MinMarginPerBand = DEFAULT_MAX_SNR_MARGIN*10; // in unit of 0.1 dB

   // XDSLRTFW-539 FEATURE_ALL_VDSL2_ATTNDR_Update (START)
   int32 l_SumShowtimeSNR, l_DeltaSum, l_BitsPerFrame;
   // XDSLRTFW-539 FEATURE_ALL_VDSL2_ATTNDR_Update (END)

   l_SumFineGaindB = 0;

   l_TotalMargin = 0;
   s_RxChannelsAllocated = 0;
   s_MinMargin = (int16)0x7FFF;


   // XDSLRTFW-539 FEATURE_ALL_VDSL2_ATTNDR_Update (START)
   l_SumShowtimeSNR = 0;
   // XDSLRTFW-539 FEATURE_ALL_VDSL2_ATTNDR_Update (END)

   for(j=0; j<gs_NumOfRxBands; j++)
   {
      l_TotalMarginPerRxBand = 0;
      s_RxChannelsAllocatedPerRxBand = 0;


      for(s_ch=gsa_RxBandLeftChannel[j]; s_ch<=gsa_RxBandRightChannel[j]; s_ch++)
      {
         s_qc= ghpuca_RxBat_Inactive[s_ch];

         if(s_qc == 0)
         {
            continue;
         }

         s_CodingGain = gsa_TotalCodingGain[INLV];

         if (s_ch <= gs_MaxToneForFast)
         {
            s_CodingGain = gsa_TotalCodingGain[FAST];
         }

         // Include extra SNR margin for lower bandedge tones having correlated noise.
         // gs_high_tone_for_extra_snrmargin is the upper tone of these bandedge tones.
         if (s_ch <= gs_high_tone_for_extra_snrmargin)
         {
            s_CodingGain = s_CodingGain - gs_extra_snrmargin_for_low_tones;
         }

         // add coding gain
         s_margin = gpsa_MeasuredSnrBuf[s_ch] + s_CodingGain - gsa_ConstellationSNR[s_qc];



         // apply fine gain
         if (ft_ApplyFG)
         {
            // Skip in case of 0dB fine gain
            if ((gft_dbg_ShowSnr == 0) && (ghpsa_RxFineGains_Inactive[s_ch] != 0x2000))
            {
               l_Gain = NormAndDivide_32by16bit(((int32)1<<30), ghpsa_RxFineGains_Inactive[s_ch]);

               //l_Gain is the linear gain in Q3.13
               l_Gain = round(l_Gain, 4);

               //Convert the linear fine gain to dB (Q8.8)
               s_FineGain = ConvertToDB(l_Gain);

               //Since the input to ConvertToDB Q3.13 format and
               //ConvertToDB computes 10log10(gain), but we need to compute 20*log10(gain)
               //so we need to adjust s_FineGain to get the desired dB (in Q8.8)
               s_FineGain = (s_FineGain<<1) - 0x4E44; // 0x4E44 = 20*log10(2^13) * 256

               s_margin += s_FineGain;
            }
         }

         if (s_margin < s_MinMargin)
         {
            s_MinMargin = s_margin;
            s_MinMarginTone = s_ch;
         }

         // compute the total margin per band
         l_TotalMarginPerRxBand += s_margin;
         s_RxChannelsAllocatedPerRxBand++;

         // compute the total margin
         l_TotalMargin += s_margin;
         s_RxChannelsAllocated++;

         // XDSLRTFW-539 FEATURE_ALL_VDSL2_ATTNDR_Update (START)
         l_SumShowtimeSNR += (gpsa_MeasuredSnrBuf[s_ch]>>8);  // dB in Q32.0 format to avoid overflow
         // XDSLRTFW-539 FEATURE_ALL_VDSL2_ATTNDR_Update (END)

         // compute the total fine gain
         l_SumFineGaindB += ghpsa_RxFineGains_Inactive[s_ch];

         // if SaveMarginPerToneflag is set, then overwrite SNR with margin information
         if (gft_SaveMarginPerTone)
         {
            gpsa_MeasuredSnrBuf[s_ch] = s_margin;
         }
         //XDSLRTFW-1784 (Showtime Margin Equalization - START)
         //XDSLRTFW-1784 (Showtime Margin Equalization - END)
      } //for()

      if (s_RxChannelsAllocatedPerRxBand == 0)
      {
         gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_SNRM = OUT_OF_RANGE_SNRM;
      }
      else
      {
         gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_SNRM = CalcAvMarginInTenthOfdB(l_TotalMarginPerRxBand, s_RxChannelsAllocatedPerRxBand);
      }

      //XDSLRTFW-1989 : FECs with Average Margin @ 2dB
      //Find the Min Per Band Margin
      if ( (gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_SNRM < s_MinMarginPerBand) &&
            (gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_SNRM != OUT_OF_RANGE_SNRM) )
         s_MinMarginPerBand = gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_SNRM;
      //XDSLRTFW-1989 : FECs with Average Margin @ 2dB
   }
   // Populate the number of RxBands.
   gt_AttenSnrMPerRxBand.us_NumberOfBands = (uint16)j;

   // compute the average margin
   if (s_RxChannelsAllocated == 0)
   {
      *ps_AvgMargin = OUT_OF_RANGE_SNRM;
   }
   else
   {
      *ps_AvgMargin = CalcAvMarginInTenthOfdB(l_TotalMargin, s_RxChannelsAllocated);
   }

   // compute the average fine gain
   gs_RxAvFineGain = QuickAverage(l_SumFineGaindB, s_RxChannelsAllocated);

   //XDSLRTFW-1989 Workaround for high number of FECs
   //On Short loops we see DS1 & DS2 difference is about 2dB
   // Which will affect the Margin test in case Customer looks at Average Margin
   if ( (s_MinMarginPerBand < FECS_MINMARGIN) &&
         (*ps_AvgMargin < gt_SnrMgnConfig.s_TARSNRMds) )
   {
      for(j=0; j<gs_NumOfRxBands; j++)
      {
         if (gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_SNRM != OUT_OF_RANGE_SNRM)
         {
            gt_AttenSnrMPerRxBand.t_AttenSnrM[j].s_SNRM = s_MinMarginPerBand;
         }
      }
      *ps_AvgMargin = s_MinMarginPerBand;
   }
   //XDSLRTFW-1989 : FECs with Average Margin @ 2dB
   //XDSLRTFW-1989 Workaround for high number of FECs
   // set the minimum margin
   *ps_MinMargin = s_MinMargin;
   *ps_MinMarginTone = s_MinMarginTone;

   // if SaveMarginPerTone flag is set, then disable the SNR calculation
   // to provide time for debug read of Margin per Tone
   if (gft_SaveMarginPerTone)
   {
      gft_EnableSnrUpdate = 0;
   }

// XDSLRTFW-539 FEATURE_ALL_VDSL2_ATTNDR_Update (START)
   l_DeltaSum = l_SumShowtimeSNR - gl_SumMedleySNR;  // dB in Q32.0 format
   //XDSLRTFW-1298 : ATTNDR fix
   // Do Not overwrite the Medley Stored SNR
   //gl_SumMedleySNR = l_SumShowtimeSNR; // save for next update
   gl_SumShowtimeSNR = l_SumShowtimeSNR; // save for next update

   // Convert Delta SNR into bits approximated by 3dB per bit
   l_BitsPerFrame = (int32) QuickAverage(l_DeltaSum, 3);



   // Multiplied by Symbol Rate to get Delta ATTNDRds in bits/second.
   MULS32x16(l_DeltaSum, l_BitsPerFrame, gs_DataFrameRate);
   //XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr (Start)
// XDSLRTFW-1298 : This part of Code is presently removed
// We now calculate ATTNDR taking Medley ATTNDR as Base for ReTx Also
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr (End)

   // Update ATTNDRds based on the SNR change between Showtime and Medley
   //l_BitsPerFrame = (int32) gt_LineStatusDS.ul_AttainableDataRate;
   //XDSLRTFW-1298 : ATTNDR fix
   //XDSLRTFW-1522 (Start_End)

   //XDSLRTFW-3556 : VRx518 shows different method_0 attainable datarate than VR9(R7) (Start)
   // gul_ATTNDR contains initial ATTNDR according to Method_0 Framing based or Method_1 or Method_2 algorithm
   // gul_ATTNDR_M0_ChCapacityBased contains initial ATTNDR according to Method_0 Channel capacity based algorithm

   if ( (guc_attndr_method == ATTNDR_METHOD_0) &&
        (gt_DbgImprovedATTNDR.us_ATTNDR_MISC_CONFIGURATION == ATTNDR_ALGO_2_METHOD_0_CHANNEL_CAPACITY_BASED) )
   {
      // Method_0 Channel Capacity based ATTNDR. This method is disabled by default
      gt_LineStatusDS.ul_AttainableDataRate = (uint32)((int32)gul_ATTNDR_M0_ChCapacityBased + l_DeltaSum );
   }
   else // ATTNDR according to Method_0 Framing based or Method_1 or Method_2 algorithm
   {
      gt_LineStatusDS.ul_AttainableDataRate = (uint32)((int32)gul_ATTNDR + l_DeltaSum );
   }
   //XDSLRTFW-3556 : VRx518 shows different method_0 attainable datarate than VR9(R7) (End)


// XDSLRTFW-539 FEATURE_ALL_VDSL2_ATTNDR_Update (END)

}
