/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: CheckMfdqToneSet.c
*
*   This file contains functions for MFDQ training & adaptation.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: int16 CheckMfdqToneSet(int16 s_ch)
*
*   This function checks if a given tone is a part of MFDQ/FDBK tone set.
*
*   Input Arguments:
*      s_ch: tone index
*
*   Output Arguments:
*
*   Returns:
*      TRUE/FALSE: TRUE if it is a part of MFDQ/FDBK tone set.
*
*   Global Variables:
*      gt_MfdqConfig -- (I) MFDQ config structure
*
*-------------------------------------------------------------------------------
*/

int16 CheckMfdqToneSet(int16 s_ch)
{
   int16 i;

   if (gft_EnableMfdq)
   {
      // if MFDQ is enabled, then gt_MfdqConfig.s_NumMfdqTones > 0
      if (s_ch > gt_MfdqConfig.psa_MfdqTones[gt_MfdqConfig.s_NumMfdqTones-1])
      {
         return (FALSE);
      }

      for (i=0; i<gt_MfdqConfig.s_NumMfdqTones; i++)
      {
         if ((s_ch == gt_MfdqConfig.psa_MfdqTones[i]) ||
               (s_ch == gt_MfdqConfig.psa_FbckTones[i]))
         {
            return (TRUE);
         }
      }
   }

   return (FALSE);
}
