/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ChooseFineGains.c
*
*   This file contains functions used in bitload.
*
*-------------------------------------------------------------------------------
*/
// ***********************************************************************************************************
// ChooseFineGains.c
//
// History
// 09/05/2018 Abu Rahman: XDSLRTFW-3807 Improve bitswap algorithm in VRX518 code
// Issue: After several 10th of thousands of DS bit swapping RMS FG per band tends to reach its maximum limit (2.5dB).
// Due to this DS bit swap stops. If this situation happens CPE does not trigger any DS bit swap even with the presence
// of RFI noise on DS band which could lead to link drop.
//
// Root Cause: Multiple reasons
// i.  After several thousand DS DS, RMS FG per band was not accurate any more. RMS FG  per band was calculated only
//     one time from inactive FG table and then always modified in FW where errors were accumulated and never corrected.
// ii. At every Bit swap initiation calculation RMS FG was modified. If BS decision algorithm decided to not trigger
//     any DS bitswap request then RMS FG was not reinitialized with correct value.
// iii.Due to above points RMS FG thresholds for FG allocation did not work at all and algorithm triggered DS bit swap
//     even actual RMS FG per bands were increasing.
//
// Solution:
// i.  Calculated RMS FG per band from inactive gain table every time before starting
//     BS algorithm in RxBitSwapDecision_VDSL2() function
// ii. Modified BS algorithm in a way that actual RMS FG (DS) always tries to be below
//     the initial RMS FG. This improvement makes sure that per tone DS FGs are evenly
//     distributed and around initial RMS FG.
// iii.If RMS FG go above the threshold then new algorithm tries to reduce FG across the tones in that band to mitigate the
//     RMS FG criteria.
//   Grep for XDSLRTFW-3807
//
// ***********************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "Bitload_support.h"
#include "decimalgain.h"
#include "mul.h"
#include "nomatp.h"
#include "vdsl_state.h"
#include "vdsl_const.h"

//XDSLRTFW-3807 Improve bitswap algorithm in VRX518 code(Start)
/*
*-------------------------------------------------------------------------------
*
*   Prototype: int16 ChooseFineGains(uint8 *puca_RxBat, int16 *psa_RxFineGains,
*                                   int32 l_maxLp, int16 s_Flag_NoBatCh,int16 s_NoAvgGainCheck)
*
*   This function finds the channels where we can apply the fine gains, and
*   performs extra bit allocation.
*   It also (optionally) check that the TX spectral mask is not violated.
*
*   Input Arguments:
*              puca_RxBat: DS BAT
*              psa_RxFineGains: DS Fine Gain
*              l_maxLp: Number of bits need to be added
*              s_Flag_NoBatCh - 0: FG and BAT both can be changed; 1:only FG can be changed but not BAT;
*              s_NoAvgGainCheck - 0: RMS FG is checked while changing FG; 1: RMS FG is not checked while changing FG
*
*   Output Arguments:
*              puca_RxBat: New DS BAT
*              psa_RxFineGains: New DS Fine Gain
*              gusa_ncloaded[] = number of loaded tone per band
               gla_SumFGainLinSq[] = Sum of FG linear square per band
*
*   Returns:
*      number of extra bits allocated by applying the fine gain
*
*   Global Variables:
*              gusa_ncloaded[] = number of loaded tone per band
*              gla_SumFGainLinSq[] = Sum of FG linear square per band
*              gs_ChooseFgThresh = Final FG threshold used in this function
*
*-------------------------------------------------------------------------------
*/

int16 ChooseFineGains(uint8 *puca_RxBat, int16 *psa_RxFineGains, int32 l_maxLp,int16 s_Flag_NoBatCh, int16 s_NoAvgGainCheck)
{
   int16 s_ch; // channel index
   int16 s_qc; // QAM constellation size
   int16 s_StepUp;
   int16 s_SNR;
   int16 s_ExtraBits, s_AdditionalSNRNeeded, s_ToneToAddTo;

   int16 s_FineGainToConsider;
   int32 l_SumFGainLinSq_toconsider, l_temp;
   int16 s_ncloaded, s_ncloaded_sav;
   int32 l_MaxSumFGainLinSq;
   int16 s_threshold, s_step;
   int16 s_CurRxBand;
   FlagT ft_flag, ft_NomAtpViolation;
   int16 sa_flag_rms_increase[MAX_NUM_RX_BANDS], s_NumSkipBands;
   uint8 *puca_Bat;
   uint32 ul_NOMATP_linear_lw_save, ul_NOMATP_linear_hw_save;

#ifdef BS_INSIDE_DEBUG
   int16 s_Margin;
#endif

   s_ExtraBits = 0;

   for (s_CurRxBand = 0; s_CurRxBand < gs_NumOfRxBands; s_CurRxBand++)
   {
      gusa_ncloaded[s_CurRxBand] = 0;
      puca_Bat = puca_RxBat + gsa_BitloadLeftChannel[s_CurRxBand];
      for (s_ch = gsa_BitloadLeftChannel[s_CurRxBand]; s_ch <= gsa_BitloadRightChannel[s_CurRxBand]; s_ch++)
      {
         if(*puca_Bat++ > 0)
         {
            gusa_ncloaded[s_CurRxBand]++;
         }
      }

      sa_flag_rms_increase[s_CurRxBand] = RMS_GAIN_INIT;
   }

   // start with a threshold small enough and go upto 5dB, to add bits using fine gain
   // increase the threshold in every iteration
   // every iteration add just enough bits which require fine gain to be less than the threshold

   //Mei?? we can start with a large step size and reduce it gradually
   s_threshold = gs_ChooseFgThresh;
   s_step = 20;      //20/256 = 0.078 dB

   //Count the number of bands in which no gain can be added
   s_NumSkipBands = 0;

   while (s_threshold < 5*256)
   {

      s_AdditionalSNRNeeded = 0x7fff; // BIG number

      // Find tone that requires the smallest increase in SNR in order to increase
      // the bitloading.
      for (s_CurRxBand = 0; s_CurRxBand < gs_NumOfRxBands; s_CurRxBand++)
      {
         //Skip the band which cannot be added by more gains
         if(sa_flag_rms_increase[s_CurRxBand] == RMS_GAIN_SKIP)
         {
            continue;
         }

         sa_flag_rms_increase[s_CurRxBand] = RMS_GAIN_INIT;

         s_ncloaded = gusa_ncloaded[s_CurRxBand];
         l_SumFGainLinSq_toconsider = gla_SumFGainLinSq[s_CurRxBand];

         // !! Debug code to test maximum bits per tone per band, i.e. max constellation per band!!
         if (gsa_RxMaxConstSize[s_CurRxBand] > 0)
         {
            gs_RxMaxConstSize = gsa_RxMaxConstSize[s_CurRxBand];
         }

         for (s_ch = gsa_BitloadLeftChannel[s_CurRxBand]; s_ch <= gsa_BitloadRightChannel[s_CurRxBand]; s_ch++)
         {

            // XDSLRTFW-3280 - Start/End - PLL improvement / pilot tone selection improvement
            if ((s_ch == gt_PilotConfig.ta_PilotTones[0].s_PilotToneIdx) ||
                (s_ch == gt_PilotConfig.ta_PilotTones[1].s_PilotToneIdx) ||
                (s_ch == gt_PilotConfig.ta_PilotTones[2].s_PilotToneIdx) )//XDSLRTFW-2302
            {
               continue;
            }

            s_qc = (int16)puca_RxBat[s_ch];

            if (s_qc == gs_RxMaxConstSize)
            {
               continue;
            }

            //s_Flag_NoBatCh means no BAT should be changed
            if ((s_Flag_NoBatCh == 1) && (s_qc < 2)) //Pui ??
            {
               continue;
            }

            if (psa_RxFineGains[s_ch] == NEG_INFINITY_DB)
            {
               continue;
            }

            // s_SNR adjusted with fine gain
            s_SNR = AddCodingGainToSnr(s_ch, gpsa_MeasuredSnrBuf);

#ifdef BS_INSIDE_DEBUG
            // Debug code start
            s_Margin = s_SNR;
            // For bi=0 tones, its fine gain either is negative infinity dB or 0dB, so ignore its fine gain here
            // avoid the possible overflow problem (for negative infinity) and also fine for 0db case.
            s_Margin += psa_RxFineGains[s_ch];
            // When subtracting bits and looking for the tone with the smallest margin, we use bi_delta = 0.
            s_Margin -= gsa_ConstellationSNR[s_qc];
            // Debug code end
#endif
            if (s_qc == 0)
            {
               s_StepUp = gs_RxMinConstSize;
               // If we load this tone we will start with min fine gain.
               s_SNR += gs_min_fine_gain;
            }
            else
            {
               s_StepUp = 1;
               s_SNR += psa_RxFineGains[s_ch];
            }

            // Additional FG need to load one exta bit
            s_AdditionalSNRNeeded = gsa_SNRRequired[s_qc + s_StepUp] - s_SNR;

            // possibility check of extra FG  for one addition bit
            if (s_qc == 0)
            {
               if (s_AdditionalSNRNeeded > (gs_max_fine_gain - gs_min_fine_gain))
               {
                  continue;
               }
            }
            else if (s_AdditionalSNRNeeded > (gs_max_fine_gain - psa_RxFineGains[s_ch]))
            {
               continue;
            }

            s_ToneToAddTo = s_ch;

            if (s_qc == 0)
            {
               //since s_qc has been updated in each iteration
               if (s_AdditionalSNRNeeded > s_threshold)
               {
                  continue;
               }
            }
            else
            {
               //The above code is incorrect
               // Abu : this code need to be checked carefully
               // s_SNR = AddCodingGainToSnr(s_ch, gpsa_MeasuredSnrBuf);
               // s_SNR += psa_RxFineGains[s_ch];
               // s_AdditionalSNRNeeded = gsa_SNRRequired[s_qc + s_StepUp] - s_SNR;
               if ((s_AdditionalSNRNeeded + psa_RxFineGains[s_ch] - gs_min_fine_gain) > s_threshold)
               {
                  continue;
               }
            }

            // compute linear gain and add to running sum of squares
            // Here we add the sum square as the fine gain which it would be if added and subtract the
            // previous entry from fine gain sum

            // for the tones which would get loaded for the first time
            s_ncloaded_sav = s_ncloaded;
            if (puca_RxBat[s_ToneToAddTo] == 0)
            {
               s_FineGainToConsider = gs_min_fine_gain;
               s_ncloaded++;
               ft_flag = 2;
            }
            else
            {
               s_FineGainToConsider = psa_RxFineGains[s_ToneToAddTo];
               ft_flag = 0;
            }

            //Adjust the NOMATP (save the current value)
            ul_NOMATP_linear_lw_save =  gul_NOMATP_linear_lw;
            ul_NOMATP_linear_hw_save =  gul_NOMATP_linear_hw;

            //save the current value
            l_temp = l_SumFGainLinSq_toconsider;
            UpdateFGSumSqAndNOMATP(s_ToneToAddTo, s_FineGainToConsider, (int16)(s_FineGainToConsider + s_AdditionalSNRNeeded), &l_SumFGainLinSq_toconsider, ft_flag);

            //Check if NOMATP < MAXNOMATP, if not, set ft_NomAtpViolation to 1
            ft_NomAtpViolation = 0;
            if (gus_ModemOperationMode_Status & MODEM_OPERATION_MODE_VDSL2)
            {
               if (gft_MAXNOMATP_Flag == TRUE) // this flag is disabled by BitSwapDecision_VDSL2 function
               {
                  ft_NomAtpViolation = CheckNOMATPLimit();
               }
            }

            if(gs_RxState != R_O_SHOWTIME_RX)
            {
               // l_sumFgainLinSq is in 6.18;
               // Check that (Sum (gi ^2)/ncloaded) < gs_fgain_adjust; if so add  fine gain to the tone;
               //else don't add the fine gain ( rms fine gain should be < 0 )
               s_FineGainToConsider = DecimalGain((int16)(gs_fgain_adjust<<1));
               MULS16(l_MaxSumFGainLinSq, s_FineGainToConsider ,s_ncloaded);
               l_MaxSumFGainLinSq = l_MaxSumFGainLinSq << 5;
            }
            else
            {
               //Due to memory limitation, we cannot update NOMATP during the bit-swap
               //so we cannot check the NOMATP violation.
               //Though sub-optimal, here we choose to limit the sum of gain square not
               //exceed that computed during the initialization
               //In this way, we also limit the NOMATP to some degree
               MULS32xU16(l_MaxSumFGainLinSq, gla_AvgFGainLinSqInit[s_CurRxBand], gusa_ncloaded[s_CurRxBand]);
            }

            if (((l_SumFGainLinSq_toconsider < l_MaxSumFGainLinSq) || s_NoAvgGainCheck) && (ft_NomAtpViolation == 0)) //XDSLRTFW-3807 Improve bitswap algorithm in VRX518 code
            {
#ifdef BS_INSIDE_DEBUG
               if(gs_RxState == R_O_SHOWTIME_RX)
               {
                  if (!(IS_TONEFLAGSET(guca_RxBitswapToneSet, s_ToneToAddTo)))
                  {
                     // log  tone idx, initial BAT, FG and Margin information of bitswapable tone
                     gsa_BSDebugBuf[gs_DSDebugBufCnt++] = s_ToneToAddTo;
                     gsa_BSDebugBuf[gs_DSDebugBufCnt++] = puca_RxBat[s_ToneToAddTo];
                     gsa_BSDebugBuf[gs_DSDebugBufCnt++] = s_Margin;
                     gsa_BSDebugBuf[gs_DSDebugBufCnt++] = psa_RxFineGains[s_ToneToAddTo];
                  }
               }
#endif
               //set it to 0 to indicate that it is possible to add more bit by increasing rms
               sa_flag_rms_increase[s_CurRxBand] = RMS_GAIN_ADD;

               // Increase fine gain and bitloading
               if (!s_Flag_NoBatCh)
               {
                  puca_RxBat[s_ToneToAddTo] += s_StepUp;
               }
               s_ExtraBits += s_StepUp;

               // If we're loading this tone for the first time, initially set fine gain to min.
               if (puca_RxBat[s_ToneToAddTo] == s_StepUp)
               {
                  psa_RxFineGains[s_ToneToAddTo] = gs_min_fine_gain;
               }

               psa_RxFineGains[s_ToneToAddTo] += s_AdditionalSNRNeeded;

               // if Trellis is on, be conservative here, assuming that in the end we may land with
               // odd 1 bit tones; and the fine gain on that tone may be -2.5dB
               // adjust that by taking care of Sum(gi^2); by adding gi_min ^2;

               if (gft_RxTcmFlag)
               {
                  s_FineGainToConsider = (DecimalGain(gs_min_fine_gain) + (int16)(1<<3)) >> 4;

                  MULS16(l_temp, s_FineGainToConsider, s_FineGainToConsider);

                  if (((l_SumFGainLinSq_toconsider + l_temp ) < l_MaxSumFGainLinSq )
                        && (gft_extrafinegainallocated < NUM_RESERVED_BITS))
                  {
                     l_SumFGainLinSq_toconsider += l_temp;
                     // set the flag to indicate that extra fine gain has been added
                     gft_extrafinegainallocated++;
                  }
               }


               SETTONEFLAG(guca_RxBitswapToneSet, s_ToneToAddTo);

               //Check if the maximum number of bits have been reached
               // if gs_RxMinConstSize > 1, s_ExtraBits can be greater than l_maxLp
               if (s_ExtraBits >= l_maxLp)
               {
                  gft_Flag_limitCause = REACH_MAX_BITS;
                  goto _return;
               }
            }
            else //if (l_SumFGainLinSq_toconsider > l_MaxSumFGainLinSq)
            {
               //none of the tone so far can be added by gain in this band
               if(sa_flag_rms_increase[s_CurRxBand] != RMS_GAIN_ADD)
               {
                  sa_flag_rms_increase[s_CurRxBand] = RMS_GAIN_NOT_ADD;
               }

               //restore the previous values
               l_SumFGainLinSq_toconsider = l_temp;
               s_ncloaded = s_ncloaded_sav;

               gul_NOMATP_linear_lw = ul_NOMATP_linear_lw_save;
               gul_NOMATP_linear_hw = ul_NOMATP_linear_hw_save;
            }

         } //for (s_ch = gsa_BitloadLeftChannel[s_CurRxBand]; s_ch <= gsa_BitloadRightChannel[s_CurRxBand];

         gusa_ncloaded[s_CurRxBand] = s_ncloaded;
         gla_SumFGainLinSq[s_CurRxBand] = l_SumFGainLinSq_toconsider;

         if(sa_flag_rms_increase[s_CurRxBand] == RMS_GAIN_NOT_ADD)
         {
            sa_flag_rms_increase[s_CurRxBand] = RMS_GAIN_SKIP;
            s_NumSkipBands++;
         }


      } //for (s_CurRxBand = 0; s_CurRxBand < gs_NumOfRxBands; s_CurRxBand++)

      //If no tone can be added by any bit at this threshold
      if (s_NumSkipBands == gs_NumOfRxBands)
      {
         gft_Flag_limitCause = REACH_RMS_LIMIT;
         break;
      }

      s_threshold = s_threshold + s_step;

   } // end of while loop

_return:
   //save the threshold for later use
   gs_ChooseFgThresh = s_threshold;

   return(s_ExtraBits);
}
//XDSLRTFW-3807 Improve bitswap algorithm in VRX518 code(End)
