/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *
 *   DetectDSSyncSymbolHandler.c
 *
 *   This file contains the routine that conducts DS Synch Symbol dtection for G.vector.
 *
 *------------------------------------------------------------------------
 */
// ***********************************************************************************************************
// DetectDSSyncSymbolHandler.c
//
// History
//
// 04/07/2013 Fuss: Nearly development status. Grep pattern only added here in the header
//            Grep pattern: XDSLCPEFW-1072_BUGFIX_VR9_VRX318_VECTORING_US_SYNC_SYMBOL_MODULATION_COUNTER"
// 20/05/2014 Fuss: Fix for "No sync with profile with DS1 only (Max freq in DS1 is 2.2MHz)
//            Grep for XDSLRTFW-1793
// ************************************************************************************************************
#include <string.h>
// "vdsl_compiler.h", "vdsl_const.h", "sys_const.h" are included in "common.h"
#include "common.h"
#include "gdata.h"
#include "fifo.h"
#include "accum32.h"
#include "states.h"
#include "DetectDSSync_Vector_Handler.h"
#include "mul.h"

//#ifdef MTK_VECTORING_SUPPORT

#include "vdsl_state.h"
#include "cmv.h"


uint8 guc_DetectOffset = 6;

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void DetectDSSync_Vector_Handler(void)
*
*   This function performs Detection of DS Synch Symbol position.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*          gsa_VecSSyncAlignIn[]
*          gsa_VecSSyncAlignOut[]
*          Format:
*               gsa_VecSSyncAlignIn                 gsa_VecSSyncAlignOut
*                    RxFrmCnt      (actual)             RxFrmCnt       (aligned)
*                    TxFrmCnt      (actual random)      TxFrmCnt       (aligned)       ChannelDiscovery
*                    --------                           --------                       ----------
*                    RxFrmCnt      (actual)
*                    TxFrmCnt      (actual)
*                    RxFrmCnt      (calculated)         RxFrmCnt       (aligned)
*                    TxFrmCnt      (calculated)         TxFrmCnt       (aligned)
*                    Indx_PilotSeq (calculated)         Indx_PilotSeq  (demodulated)   TransceiverTraining (start)
*                    --------                           --------                       ----------
*                    RxFrmCnt      (actual)
*                    TxFrmCnt      (actual)
*                    RxFrmCnt      (calculated)         RxFrmCnt       (aligned)
*                    TxFrmCnt      (calculated)         TxFrmCnt       (aligned)
*                    Indx_PilotSeq (calculated)         Indx_PilotSeq  (demodulated)   TransceiverTraining (end)
*                    --------                           --------                       ----------
*
*          Note: States were symbols have no CE (Periodic states) are destroying the
*                frame counter in vectoring, i.e. the alignment to the CO. Therefore
*                a full re-alignment or a frame counter correction is needed after such a phase.
*                This is now all reflected in the above mentioned array variables.
*-------------------------------------------------------------------------------
*/
void DetectDSSync_Vector_Handler(void)
{
   switch(gs_VectorHandlerState)
   {
      FlagT s_ToneType;

   case VECTOR_DEMODULATE_DS_SYNCSYMB_INIT:
      // Wait for RTV buffer 0 HW settings to take effect
      if (gs_AlgHandlerCount < gs_RTVxCfgLatency)
      {
         gs_AlgHandlerCount++;
      }
      else
      {
         // XDSLRTFW-1793 (Start_End) - whole else-path (removed)
         gs_AlgHandlerCount = 0;

         gs_AlgNumTonesToProcess = gs_RxNumChannelsForMsgDecode; //XDSLRTFW-2467

         gs_VectorHandlerState = VECTOR_DEMODULATE_DS_SYNCSYMB;
         gs_DSSyncPosition_cnt = 0;
      }
      break;

   case VECTOR_DEMODULATE_DS_SYNCSYMB:
      // Detect DS sync symbol position by demodulating 10n+9
      // look for 8 consecutive 1s

      // XDSLRTFW-1793 (Start_End)
      s_ToneType = DemodulateTone9(gpsa_RxToneBuf, gs_AlgNumTonesToProcess);

      if (s_ToneType == SEGUE)
      {
         gs_DSSyncPosition_cnt++;
      }
      else
      {
         gs_DSSyncPosition_cnt = 0;
      }

      if (gs_DSSyncPosition_cnt == 8)
      {
         // Table 10-2/G993.5 Field#5: Upstream sync symbol offset defines  the  time  offset  set  by
         // the VCE (expressed as a number of symbols) between the downstream sync symbol and the upstream
         // sync symbol. The field shall be represented as an integer in 2's complement representation with
         // valid range from -127 to +127, except 0, where negative offset indicates the upstream sync symbols
         // are delayed relatively to the downstream sync symbols.

         // update the TxFrmCnt based on the USSync Offset
         // This is assuming the RxFrmCnt is already aligned with CO SuperFrame
         // starts from Frame 0 --> 256 where 256 is Sync Frame

         // This code makes sure that there will be a fixed delta between Tx and Rx sync symbol
         // (RxQTRunAfterStall > gs_TxQTRunAfterStall) -> delta = 5
         // (RxQTRunAfterStall < gs_TxQTRunAfterStall) -> delta = 6
         // (RxQTRunAfterStall == gs_TxQTRunAfterStall) -> not measured tbd.
         if((gs_RxQTRunAfterStall == gs_TxQTRunAfterStall) &&
               (!(gul_35bLiteConfig & EN_CASCADED_MODE)))
         {
            // Next VectorHandler state
            gs_VectorHandlerState = VECTOR_DEMODULATE_DS_SYNCSYMB_INIT;
            // only for debugging
            gs_QTDebugCnt += 256;
         }
         else
         {
            // Store actual Vectoring Frame Counter
            // Note: It is also done in the fct. "VectoringReSyncFrameCntCalc()" after first full alignment.
            if(gs_VecIndx_PilotSeq_comp < 0)
            {
               gsa_VecSSyncAlignIn[(gs_VecSSyncAlignIdx & 0xf)] = gs_RxFrmCnt;
               gs_VecSSyncAlignIdx++;
               gsa_VecSSyncAlignIn[(gs_VecSSyncAlignIdx & 0xf)] = gs_TxFrmCnt;
            }

            VectoringReSyncFrameCntCalc();
            gs_VecSSyncAlignIdx--;

            if (!(gul_35bLiteConfig & EN_CASCADED_MODE))
            {
               gs_RxFrmCnt = guc_DetectOffset;       // Sync Symbol is numbered 256 Fig 10-6/G.993.5

               // default setting (gs_RxQTRunAfterStall > gs_TxQTRunAfterStall) -> delta = 5
               gc_VecDeltaRxTxSyncSym = 5;
               gs_TxFrmCnt = gs_RxFrmCnt + (int16)gc_VecUSSyncOffset+gc_VecDeltaRxTxSyncSym;
               if(gs_RxQTRunAfterStall < gs_TxQTRunAfterStall)
               {
                  // delta = 6
                  gc_VecDeltaRxTxSyncSym += 1;
                  gs_TxFrmCnt += 1;

                  // only for debugging
                  gs_QTDebugCnt++;
               }
            }
            else
            {
               if (gc_VecDeltaRxTxSyncSym)
               {
                  // Debug code to test the Rx/Tx sync symbol alignment!
                  gs_TxFrmCnt = guc_DetectOffset + (int16)gc_VecUSSyncOffset + gc_VecDeltaRxTxSyncSym;
               }
               else
               {
                  // Note: The first time the alignment must be set!
                  //       This is at the beginning of ChannelDiscovery, i.e. after the
                  //       O-Signature msg was received.
                  //       Later on the calculated values are used (VectoringReSyncFrameCntCalc()),
                  //       because the alignment will not change anymore (normally).
                  if (gs_RxState == R_O_SIGNATURE_RX)
                  {
                     gs_RxFrmCnt = guc_DetectOffset;       // Sync Symbol is numbered 256 Fig 10-6/G.993.5
                     gs_TxFrmCnt = gs_RxFrmCnt + (int16)gc_VecUSSyncOffset + 6;
                  }
               }
            }

            // Handle TxFrmCnt wrap-around
            // Note: Sync symbol offset with valid range from -127 to +127, except 0.
            if(gs_TxFrmCnt < 0)
            {
               gs_TxFrmCnt = 257 + gs_TxFrmCnt;
            }

            // Store out Rx/Tx Frame Counter, i.e. calculated or demodulated
            gsa_VecSSyncAlignOut[(gs_VecSSyncAlignIdx & 0xf)] = gs_RxFrmCnt;
            gs_VecSSyncAlignIdx++;
            gsa_VecSSyncAlignOut[(gs_VecSSyncAlignIdx & 0xf)] = gs_TxFrmCnt;
            gs_VecSSyncAlignIdx++;

            gl_USPilotSeqRaw = 0;

            // Next VectorHandler state
            gs_VectorHandlerState = VECTOR_DECODE_US_PILOTSEQ_RAW;
         }

         gs_AlgHandlerCount = 0;
      }
      /*
      else do we need to add a check for frame length ?
      I think a check exists at outer level , so we should not be required to further check it??
      */
      break;

   case VECTOR_DECODE_US_PILOTSEQ_RAW:
      if (gs_AlgHandlerCount < 20)
      {
         // XDSLRTFW-1793 (Start_End)
         s_ToneType = DemodulateTone9(gpsa_RxToneBuf, gs_AlgNumTonesToProcess);
         gl_USPilotSeqRaw = ((gl_USPilotSeqRaw << 1) | (s_ToneType & 0x1));
         gs_AlgHandlerCount++;
      }
      else // 20 Symbols = 10 bits of Pilot sequence index
      {
         gs_AlgHandlerCount = 0;
         gs_VectorHandlerState = VECTOR_DECODE_US_PILOTSEQINDX;
      }
      break;

   case VECTOR_DECODE_US_PILOTSEQINDX:
      // DetectDSSync_Vector_Handler function is called several times in training phase
      // to make sure that the US Sync symol is modulated in proper way (mandatory feature
      // for Vectoring).
      {
         FlagT ft_FalseDetection;

         ft_FalseDetection = FALSE;

         // decode US Pilot sequence marker from the row data
         {
            int16 i, s_idxbits, s_VecIndx_PilotSeq;
            int32 l_RawPilotSeq;

            s_VecIndx_PilotSeq = 0;
            l_RawPilotSeq = gl_USPilotSeqRaw;

            for (i=0; i<10; i++)
            {
               s_idxbits = (int16)((l_RawPilotSeq>>(2*i)) & 0x3);
               s_VecIndx_PilotSeq <<= 1;                  // always a zero is added

               // s_idxbits == 1 -> s_Pilotidx = 0;
               // s_idxbits == 2 -> s_Pilotidx = 1;
               // s_idxbits == 3 -> not defined (error);
               if(s_idxbits == 2)
               {
                  s_VecIndx_PilotSeq |= 1;
               }
               else if(s_idxbits == 3)
               {
                  ft_FalseDetection = TRUE;
               }
            }

            // Save gs_VecIndx_PilotSeq for comparison
            if(gs_VecIndx_PilotSeq_comp >= 0)
            {
               gs_VecIndx_PilotSeq_comp = gs_VecIndx_PilotSeq;
               gsa_VecSSyncAlignIn[(gs_VecSSyncAlignIdx & 0xf)] = gs_VecIndx_PilotSeq_comp;
            }
            // Set the new decoded PilotSeq index
            gs_VecIndx_PilotSeq = s_VecIndx_PilotSeq;
         }

         // US pilot sequence modulation counter gs_VecIndx_PilotSeq in our old implementation was not correct.
         // It works fine for positive sync symbol offset gc_VecUSSyncOffset and some small negative offset
         // but it gives non standard compliant result for larger negative offset. Due to a bug in our Avinax
         // code base (Short FW version 13.3.1, gus_fe_G994VendorSpecific = 0xD0C1), non standard compliant
         // US pilot sequence modulation works fine with  Avinax 13.3.1 code base.
         //
         // CPE has a proper solution now but at the same time, it makes sure that CPE code also work fine with
         // older CO implementation.
         if ((gul_fe_G994VendorID == IFX_VENDOR_ID) && (gus_fe_G994VendorSpecific == 0xD0C1)) // for legacy Avinax CO solution (non standard complient)
         {
            gs_VecIndx_PilotSeq++;
         }
         else if ((gc_VecUSSyncOffset > 0) || (gs_RxFrmCnt >= (gs_TxFrmCnt-gc_VecDeltaRxTxSyncSym))) // correct solution
         {
            gs_VecIndx_PilotSeq++;
         }
         // Modulo by gs_VecNPilotLength_US Table 10-2/G993.5 field#3
         if (gs_VecIndx_PilotSeq >= gs_VecNPilotLength_US)
         {
            gs_VecIndx_PilotSeq = 0;
         }

         // This code section checks the consistency of the US Pilot sequence marker during training
         // This condition is true from the second time of this function being called!
         // The value of gs_VecIndx_PilotSeq_comp is initialized to -1!
         if(gs_VecIndx_PilotSeq_comp >= 0)
         {
            // The below disabled code was only for vectoring bring up debugging
            //int16 s_diff;
            //s_diff = (gs_VecIndx_PilotSeq_comp - gs_VecIndx_PilotSeq);
            //if saved value and newly decoded value mismatch then call for exception handler
            //if(s_diff != 0)
            //{
            //   gs_Debug5 = s_diff ; // intentional code
            //}
            gsa_VecSSyncAlignOut[(gs_VecSSyncAlignIdx & 0xf)] = gs_VecIndx_PilotSeq;
            gs_VecSSyncAlignIdx++;
         }
         else
         {
            gs_VecIndx_PilotSeq_comp = 0;
         }


         if (ft_FalseDetection == TRUE)
         {
            gs_VectorHandlerState = VECTOR_DEMODULATE_DS_SYNCSYMB;
            gs_DSSyncPosition_cnt = 0;
         }
         else
         {
            gs_VectorHandlerState = VECTOR_DECODESYNCH_DONE;
         }
      }
      break;
   }
}

int16 DemodulateTone9(int16 *psa_RxToneBuf, int16 s_NumTones)
{
   int16 i,i2;
   int16 s_NumReverb, s_NumSegue;
   int16 s_real, s_imag;

   //Tone by Tone based detection algorithm
   s_NumReverb = 0;
   s_NumSegue = 0;
   for(i=9; i<s_NumTones; (i=i+10))
   {
      i2 = i<<1;
      s_real =psa_RxToneBuf[i2];
      s_imag = psa_RxToneBuf[i2+1];

      if((s_real > 0) && (s_imag > 0))
      {
         s_NumReverb++;
      }
      else if((s_real < 0) && (s_imag < 0))
      {
         s_NumSegue++;
      }
   }
//   {
//      int16 s_Threshold;
//      s_Threshold = (s_NumTones + 15) >> 4; // roughly 2/3 of s_NumTones
//   }

   if ((s_NumReverb > s_NumSegue))
   {
      return(REVERB);
   }
   else if ((s_NumSegue > s_NumReverb))
   {
      return(SEGUE);
   }
   else
   {
      return(NEITHER);
   }
}


void VectoringReSyncFrameCntCalc(void)
{
   if(gs_VecIndx_PilotSeq_comp >= 0)
   {
      int16 s_PeriodicLengthTx, s_PeriodicLengthRx;

      s_PeriodicLengthTx=0;
      s_PeriodicLengthRx=0;

      // Store actual Vectoring Frame Counter
      gsa_VecSSyncAlignIn[(gs_VecSSyncAlignIdx & 0xf)] = gs_RxFrmCnt;
      gs_VecSSyncAlignIdx++;
      gsa_VecSSyncAlignIn[(gs_VecSSyncAlignIdx & 0xf)] = gs_TxFrmCnt;

      // Correct frame counter by the additional symbol amount for
      // TX/RX state length without CE
      // Note:
      // Compute the length of this state, L, such that L*(2N) = K*(2N+CElength)
      // where N is the number of tones, and K is the number of symbols in the periodic state with CE
      // Solve L = K*(1+ m*N/32/2N) = K * (1+m/64) = K + m*(K>>6)
      //       MULS16(l_temp, gs_m, s_PeriodicLengthTx);
      // ------------------------------
// Vectoring Rx/Tx Sync symbol resync "R_O_ACK_RX"  - start/end
//      if ((gs_RxState == VDSL2_R_O_P_TRAINING_V1_RX) || (gs_RxState == VDSL2_R_O_ACK_RX))
      if (gs_RxState == VDSL2_R_O_P_TRAINING_V1_RX)
      {
         s_PeriodicLengthTx = (int16)(gl_TxFixedStateLength - VDSL2_P_PERIODIC1_TX_LENGTH);
         if (TESTArray[TEST_XDSLRTFW_CONFIG] & TEST_XDSLRTFW_CONFIG_VEC_RESYNC_CALC)
         {
            s_PeriodicLengthRx = (int16)(gl_RxFixedStateLength - VDSL2_P_PERIODIC1_TX_LENGTH);
         }
      }
      else if(gs_RxState == VDSL2_R_O_TA_UPDATE_RX)
      {
         // Duration of VTU-O-TEQ training, i.e. R-P-TEQ length of TX TEQ state
         if(gl_TxTeqLength > 0)
         {
            if(guc_RtReq_CoTeqLength > gt_DecMsg_O_Prm_VDSL2.uc_Duration_VTUO_TEQTraining)
            {
               s_PeriodicLengthTx = guc_RtReq_CoTeqLength;
            }
            else
            {
               s_PeriodicLengthTx = gt_DecMsg_O_Prm_VDSL2.uc_Duration_VTUO_TEQTraining;
            }

            s_PeriodicLengthTx = (gl_TxTeqLength - (s_PeriodicLengthTx<<6));
         }

         // Duration of VTU-R-TEQ training, i.e. O-P-TEQ length of RX TEQ state
         if(gl_RxTeqLength > 0)
         {
            if(guc_RtReq_TeqLength > gt_DecMsg_O_Prm_VDSL2.uc_Duration_VTUR_TEQTraining)
            {
               s_PeriodicLengthRx = guc_RtReq_TeqLength;
            }
            else
            {
               s_PeriodicLengthRx = gt_DecMsg_O_Prm_VDSL2.uc_Duration_VTUR_TEQTraining;
            }

            s_PeriodicLengthRx = (gl_RxTeqLength - (s_PeriodicLengthRx<<6));
         }

         // Duration of Periodic 2 state
         // Note: Duration of the O-P-PERIODIC2 and R-P-PERIODIC2 signals following TEQ
         //       and EC training, equal to the greater of the values requested by the
         //            VTU-O in Field #11 of O-PRM and
         //            VTU-R in Field #10 of R-PRM.
         //       From standard point gl_TxPeriodicLength and gl_RxPeriodicLength must be equal!
         //       But dependent of variable "gul_dbgMiscControl" (DISABLE_TX_PERIODIC_TRANSITION or
         //       DISABLE_RX_PERIODIC_TRANSITION) the correction can be different!
         if((gl_TxPeriodicLength > 0) && (gl_RxPeriodicLength > 0))
         {
            int16 s_duration_Periodic2;

            if(guc_RtReq_PeriodicLength > gt_DecMsg_O_Prm_VDSL2.uc_DurationPeriodicSignal)
            {
               s_duration_Periodic2 = guc_RtReq_PeriodicLength;
            }
            else
            {
               s_duration_Periodic2 = gt_DecMsg_O_Prm_VDSL2.uc_DurationPeriodicSignal;
            }

            s_PeriodicLengthTx += (gl_TxPeriodicLength - (s_duration_Periodic2<<6));
            s_PeriodicLengthRx += (gl_RxPeriodicLength - (s_duration_Periodic2<<6));
         }
      }

      // Correct RxFrmCnt
      if (s_PeriodicLengthRx > 0)
      {
         gs_RxFrmCnt = gs_RxFrmCnt - s_PeriodicLengthRx;
         while (gs_RxFrmCnt < 0)
         {
            gs_RxFrmCnt +=257;
         }
      }

      // Correct TxFrmCnt
      if (s_PeriodicLengthTx > 0)
      {
         gs_TxFrmCnt = gs_TxFrmCnt - s_PeriodicLengthTx;
         while (gs_TxFrmCnt < 0)
         {
            gs_TxFrmCnt +=257;
            gs_VecIndx_PilotSeq--;
         }
         if (gs_VecIndx_PilotSeq < 0)
         {
            gs_VecIndx_PilotSeq += gs_VecNPilotLength_US;
         }
      }

      // Store calculated Frame Counter
      gs_VecSSyncAlignIdx++;
      gsa_VecSSyncAlignIn[(gs_VecSSyncAlignIdx & 0xf)] = gs_RxFrmCnt;
      gs_VecSSyncAlignIdx++;
      gsa_VecSSyncAlignIn[(gs_VecSSyncAlignIdx & 0xf)] = gs_TxFrmCnt;
   }
}
//#endif


