/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   DetectSynch.c
*
*   This file contains function to detect O-P-SYNCHRO1, R-P-SYNCHRO1
*   O-P-SYNCHRO2, R-P-SYNCHRO2 symbols
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "HDLC.h"
#include "OTrainingTxF.h"
#include "ORTrainingRxF.h"
#include "SynchDetect.h"
#include "mul.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : DetectReverbSegue
 *
 *  Description:    Detects if the signal R-REVERB or R-SEGUE is present
 *  in the current symbol by examining a window containing N tones.
 *
 *  Prototype:  int16 DetectReverbSegue(int16 *psa_RxToneBuf, int16 s_NumTones)
 *
 *  Input Arguments:
 *      *psa_RxToneBuf - pointer to the input tone buffer
 *      s_NumTones - the number of tones in the buffer
 *
 *  Output Arguments:
 *
 *  Return:
 *      =  0, REVERB detected
 *      =  1, SEGUE detected
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */


int16 DetectReverbSegue(int16 *psa_RxToneBuf, int16 s_NumTones)
{
   int16 i;
   int16 s_NumReverb, s_NumSegue, s_Threshold;
   int16 s_real, s_imag;
   int32 l_temp;

   //Tone by Tone based detection algorithm
   s_NumReverb = 0;
   s_NumSegue = 0;
   for(i=0; i<s_NumTones; i++)
   {
      s_real = *psa_RxToneBuf++;
      s_imag = *psa_RxToneBuf++;
      if((s_real > 0) && (s_imag > 0))
      {
         s_NumReverb++;
      }
      else if((s_real < 0) && (s_imag < 0))
      {
         s_NumSegue++;
      }

   }

   if ((s_NumTones > 3) && !gft_StrictSynchroDetect)
   {
      MULS16(l_temp, 3, s_NumTones);
      s_Threshold = (l_temp + 3) >> 2; // roughly 3/4 of s_NumTones
   }
   else
   {
      s_Threshold = s_NumTones;
   }

   if (s_NumReverb >= s_Threshold)
   {
      return(REVERB);
   }
   else if (s_NumSegue >= s_Threshold)
   {
      return(SEGUE);
   }
   else
   {
      return(NEITHER);
   }

}

//Mei??? To be tested
/*
int16 DetectReverbSegue(int16 *psa_RxToneBuf, int16 s_NumTones)
{
   int16 i, i2;


   int16 s_NumReverb, s_NumSegue;
   int16 s_X, s_Y;

   //Tone by Tone based detection algorithm
   s_NumReverb = 0;
   s_NumSegue = 0;
   for(i=0; i<s_NumTones; i++)
   {
      i2 = i*2;

      s_X = psa_RxToneBuf[i2];
      s_Y = psa_RxToneBuf[i2+1];

      //Use y = -x line as the boundary to classify "REVERB" and "SEGUE"
      if(s_X >= 0)
      {
         if(-s_Y > s_X)
            s_NumSegue++;
         else
            s_NumReverb++;
      }
      else //if(s_X < 0)
      {
         if(-s_X < s_Y)
            s_NumReverb++;
         else
            s_NumSegue++;
      }
   }

   if(s_NumReverb == s_NumTones)
      return(REVERB);
   else if(s_NumSegue == s_NumTones)
      return(SEGUE);
   else
      return(NEITHER);

}
*/

