/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   DetectSynch.c
*
*   This file contains function to detect O-P-SYNCHRO1, R-P-SYNCHRO1
*   O-P-SYNCHRO2, R-P-SYNCHRO2 symbols
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "vdsl_state.h"
#include "HDLC.h"
#include "OTrainingTxF.h"
#include "ORTrainingRxF.h"
#include "SynchDetect.h"
#include "mul.h"

#define COMPLETE_SYNCHRO_SIGNAL_BIT_PATTERN 0x7C1F
#define FIRST_11_SYMBOLS_OF_SYNCHRO_SIGNAL_BIT_PATTERN 0x7C1

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : DetectSynch
 *
 *  Description:  This function detects O-P-SYNCHRO1, R-P-SYNCHRO1,
 *  O-P-SYNCHRO2, R-P-SYNCHRO2 signal where the first and last five symbols
 *  of this signal should have tones of all negative values, the middle five tones of positive values.
 *
 *  Prototype:  int16 DetectSynch(int16 *psa_RxToneBuf, int16 s_NumTones)
 *
 *  Input Arguments:
 *      psa_RxToneBuf - pointer to the input tone buffer
 *      s_NumTones - the number of tones to be used
 *
 *  Output Arguments:
 *
 *  Return:
 *      TRUE if synch signal is received, FALSE otherwise
 *
 *  Global Variables Used:
 *
 *
 *  Notes:
 *  History :
 *  24.05.2013 Abu : optimize OP-Synchro detection V4 (if sync-symbol interrupts OP-Synchro V4)
 *                    Grep for XDSLRTFW-958 BUGFIX_DS_VDSL2_VECTORING_O_P_SYNCHRO_V4
 *
 *------------------------------------------------------------------------
 */

int16 DetectSynch(int16 *psa_RxToneBuf, int16 s_NumTones)
{
   int16 s_tone_type;

   //Check if the tone buffer contains positive tones (REVERB)
   //or negative tones (SEGUE)
   s_tone_type = DetectReverbSegue(psa_RxToneBuf, s_NumTones);

#ifdef ILV_DBG_BUFFER
   if ((gs_RxState == R_O_SIGNATURE_RX) && (gs_RxSubState == 16) &&
       (gs_IlvDgbBufferContentSelector & ILVDBG_VEC_DEBUG_TRACE_OPSYNCHROV1))        // RxSubState == R_O_SIGNATURE_RX_O_P_SYNCHRO_V1
   {
      //#define NEITHER (-1) -->11
      //#define REVERB   (0)  -->00
      //#define SEGUE   (1)  -->01
      //   not used          -->10
      *gpsa_IlvDbgBuffer++ = s_tone_type;
      gs_IlvDbgBufferWriteIdx++;
      if (gs_IlvDbgBufferWriteIdx >= 768)
      {
         DSH_SendStream(OP_SYNCHROV1_TRACE,gs_IlvDbgBufferWriteIdx,&gsa_TrnVectoringBuffer[0]);
         gs_IlvDbgBufferWriteIdx = 0;
         gpsa_IlvDbgBuffer=&gsa_TrnVectoringBuffer[0];
      }
   }
#endif // ILV_DBG_BUFFER

   //XDSLRTFW-958 BUGFIX_DS_VDSL2_VECTORING_O_P_SYNCHRO_V4 (Start)
   // -> gs_RxSubState = 16 = R_O_SIGNATURE_RX_O_P_SYNCHRO_V1
   if ( ((gs_RxState == R_O_SIGNATURE_RX) && (gs_RxSubState == 16)) ||
         (gs_RxState == VDSL2_R_O_P_SYNCRO_V2_RX) ||
         (gs_RxState == VDSL2_R_O_P_SYNCHRO_V3_RX) ||
         (gs_RxState == VDSL2_R_0_P_VECTOR2_1_RX))
   {
      // Pattern based Synchro Detection algorithm
      // Synchro Signal is a composition of continous 5 SEGUE(1) + 5 REVERB(0) + 5 SEGUE(1) signals
      // If we store Syhchro signal in 1 bit pattern with SEGUE = 1 and REVERB = 0 then at the end of 15 symbol Synchro signal
      // we will receive 111110000011111 bits (0x7C1F)
      if(gs_RxFrmCnt == RX_DATA_SYMBOLS_PER_SUPERFRAME)
      {
         // At Sync Symbol Position in Vectoring mode CPE does not capture data for REVERB/SEGUE.  At this time if Synchro Signal
         // come, it can be ReVERB or REGUE.
         gus_SyncSymbolPattern1 = (gus_SyncSymbolPattern1 << 1)   + SEGUE;
         gus_SyncSymbolPattern2 = (gus_SyncSymbolPattern2 << 1)   + REVERB;
      }
      else if ((s_tone_type == SEGUE) || (s_tone_type == REVERB))
      {
         gus_SyncSymbolPattern1 = (gus_SyncSymbolPattern1 << 1)   + (uint16)(s_tone_type & 0x0001);
         gus_SyncSymbolPattern2 = (gus_SyncSymbolPattern2 << 1)   + (uint16)(s_tone_type & 0x0001);
      }
      else
      {
         // Synchro Signal is Continous 15 Symbol signal with 5 SEGUE + 5 REVERB + 5 SEGUE.
         // When CPE receives neighter REVERB nor SEGUE, this means previous signals were not Synchro
         gs_SynchSymbolDetectCnt = 0;

         gus_SyncSymbolPattern1 = 0;
         gus_SyncSymbolPattern2 = 0;

         return(FALSE);
      }


      gs_SynchSymbolDetectCnt++;

      if (((gus_SyncSymbolPattern1 & 0x7FF) == FIRST_11_SYMBOLS_OF_SYNCHRO_SIGNAL_BIT_PATTERN)||
            ((gus_SyncSymbolPattern2 & 0x7FF) == FIRST_11_SYMBOLS_OF_SYNCHRO_SIGNAL_BIT_PATTERN)   )
      {
         gs_SynchSymbolDetectCnt = 11;       // Set Synchro detection counter to 11, while first 11 Synchro signal is detected
      }

      if((gs_SynchSymbolDetectCnt == 15) &&
            (((gus_SyncSymbolPattern1 & 0x7FFF) == COMPLETE_SYNCHRO_SIGNAL_BIT_PATTERN) || ((gus_SyncSymbolPattern2 & 0x7FFF) == COMPLETE_SYNCHRO_SIGNAL_BIT_PATTERN)) )
      {

         gus_SyncSymbolPattern1 = 0;
         gus_SyncSymbolPattern2 = 0;

         if ((gs_RxState == R_O_SIGNATURE_RX) && (gs_RxSubState == 16)&& (gs_Debug8 != 0))
         {
            gs_Debug8 += 100;
            return(FALSE);
         }
         else
         {
            return(TRUE);
         }
      }
      else
      {
         return(FALSE);
      }
   } // XDSLRTFW-958 BUGFIX_DS_VDSL2_VECTORING_O_P_SYNCHRO_V4 (end)
   else //if (gs_RxState != VDSL2_R_0_P_VECTOR2_1_RX) // all other cases
   {
      //The first 5 symbols of P-SYNCHRO1 signal should be SEGUE symbol,
      //if not, reset the current symbol count
      if((gs_SynchSymbolDetectCnt < 5) && (s_tone_type != SEGUE))
      {
         gs_SynchSymbolDetectCnt = 0;
         return(FALSE);
      }
      //The middle 5 symbols of P-SYNCHRO1 signal should be REVERB symbol,
      //if not, reset the current symbol count
      else if((gs_SynchSymbolDetectCnt >= 5) && (gs_SynchSymbolDetectCnt < 10) && (s_tone_type != REVERB))
      {
         //If the previous 5 symbols are SEGUE (-,-), still keep this count to 5
         if(gs_SynchSymbolDetectCnt > 5)
         {
            gs_SynchSymbolDetectCnt = 0;
         }

         return(FALSE);
      }

      //The last 5 symbols of P-SYNCHRO1 signal should be SEGUE symbol,
      //if not, reset the current symbol count
      else if((gs_SynchSymbolDetectCnt >= 10) && (s_tone_type != SEGUE))
      {
         // If the far-end modem is an Ikanos CO then check only first 3 SEGUE symbols to
         // declare successful detection of Synchro1. For some reason CO5 sends the last
         // 2 SEGUE symbols incorrect most of the times. However, for the sake of simplicity,
         // this workaround is not qualified based on Ikanos CO5 and applied to all Ikanos based CO's

         if ((gft_dbgSkipLastTwoOPSynchro == 1) && (gs_RxState == VDSL2_R_O_P_SYNCHRO1_RX))
         {
            if(gs_SynchSymbolDetectCnt <= 12)
            {
               gs_SynchSymbolDetectCnt = 0;
               return(FALSE);
            }
         }
         else
         {
            gs_SynchSymbolDetectCnt = 0;
            return(FALSE);
         }
      }

      gs_SynchSymbolDetectCnt++;

      //  DSM_Vectoring_Debug:
      //  int16 s_SyncDetectConter;
      //   if (gs_RxState == VDSL2_R_O_P_SYNCHRO6_RX)
      //         s_SyncDetectConter = gs_Debug0;
      //   else
      //      s_SyncDetectConter = 15;
      //
      //  //Note: Initialize gs_Debug0
      //   if(gs_SynchSymbolDetectCnt == s_SyncDetectConter)

      if(gs_SynchSymbolDetectCnt == 15)
      {
         return(TRUE);
      }
      else
      {
         return(FALSE);
      }

   } // end if (gs_RxState != VDSL2_R_0_P_VECTOR2_1_RX)
}
