/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   File Name: FormTRT.c
;
;   This function generates the tone reordering table.
;
*****************************************************************************/
#include <string.h>
#include "vdsl_compiler.h"
#include "sys_const.h"
#include "gdata.h"
#include "vdsl_xception.h"
#include "decimalgain.h"
#include "dsp_op.h"
#include "ToneReorder.h"


/*****************************************************************************
;   Prototype: FlagT FormTRT(FlagT ft_direction)
;
;   This subroutine forms the RX tone reordering table which will be sent to
;   the remote modem by the PMD message.
;   (In the case of VDSL1, this rountine is also used to form the TX TRT).
;
;
;   Input Arguments:
;      ft_direction - indicate if this is for TX or RX direction.
;
;   Output Arguments:
;
;   Global Variables Used:
;      ghpuca_(Tx/Rx)Bat_Inactive      -- (I) pointer to the inactive bit allocation table
;      ghpuca_(Tx/Rx)ExtGains_Inactive -- (I) pointer to the inactive EGT (indicator of TX or RX)
;      gs_(Tx/Rx)NumTonesUsed          -- (I) number of TX/RX used tones
;      gs_NumOf(Tx/Rx)Bands            -- (I) number of TX/RX bands
;      gsa_(Tx/Rx)BandLeftChannel[]    -- (I) an array of TX/RX left band edges
;      gsa_(Tx/Rx)BandRightChannel[]   -- (I) an array of TX/RX right band edges
;      gft_(Tx/Rx)TcmFlag              -- (I) TX/RX TCM flag
;      gs_TxToneOrderType            -- (I) tone order type (NORMAL_TONE_ORDER or NO_TONE_ORDER)
;      gs_RxToneOrderType            -- (I) tone order type (NORMAL_TONE_ORDER or NO_TONE_ORDER)
;      ghpsa_(Tx/Rx)ToneOrder_Active   -- (O) pointer to the active TRT
;      gs_ToneReorderErrorCode         -- (O) ToneReorder error code
;****************************************************************************/

void WriteTRT(uint16 us_word, int16 *ps_start, int16 *ps_end, int16 *ps_band);
extern int16 gs_ilv_tone_order_parm_L_effective;

FlagT FormTRT(FlagT ft_direction)
{
   int16 i, j, k, s_ToneOrderType;
   int16 s_NumOfBands, *psa_BandLeftChannel, *psa_BandRightChannel;
   uint8 *puca_BAT, *puca_EGT;
   int16 *psa_TRT;
   int16 sa_count[RX_MAX_BITS_PER_TONE+1];
   int16 sa_idx[RX_MAX_BITS_PER_TONE+1];
   FlagT ft_TcmFlag;
   int16 s_TxNumTones;

#ifndef HW_TRT
   int16 s_first, s_second;
   TwelveBitsPair_t temp24;
   TwelveBitsPair_t nexttemp24;
   uint16 us_word;
   int16 s_start, s_end, s_band;
   uint8 uca_temp[6];
#endif

   int16 s_num_tones_loaded, s_index_nonbl, s_index_bl, s_group, s_index_in_group, s_addr;
   if (gs_RxNumTones > gs_TxNumTones)
      s_TxNumTones = gs_RxNumTones;
   else
      s_TxNumTones = gs_TxNumTones;

   if(ft_direction == RX)
   {
      ft_TcmFlag = gft_RxTcmFlag;
      s_NumOfBands = gs_NumOfRxBands;
      psa_BandLeftChannel = gsa_RxBandLeftChannel;
      psa_BandRightChannel = gsa_RxBandRightChannel;
      puca_BAT = ghpuca_RxBat_Inactive;
      puca_EGT = ghpuca_RxExtGains_Inactive;
      psa_TRT = &(ghpsa_RxToneOrder_Inactive[RX_NUM_OUT_BAND_ZERO_BIT_TONE]);
      s_ToneOrderType = gs_RxToneOrderType;
   }
   else
   {
      ft_TcmFlag = gft_TxTcmFlag;
      s_NumOfBands = gs_NumOfTxBands;
      psa_BandLeftChannel = gsa_TxBandLeftChannel;
      psa_BandRightChannel = gsa_TxBandRightChannel;
      puca_BAT = ghpuca_TxBat_Inactive;
      puca_EGT = ghpuca_TxExtGains_Inactive;

      psa_TRT = &(ghpsa_TxToneOrder_Inactive[s_TxNumTones - gs_TxNumTonesUsed]);

      s_ToneOrderType = gs_TxToneOrderType;
   }

   //Clear error code
   gs_ToneReorderErrorCode = E_CODE_TRT_NO_ERROR;

   //==========================================================================
   // count # of tones in each bit-assignment goup
   //==========================================================================
   // initialize tone counts
   memset(sa_count, 0, sizeof(int16)*(RX_MAX_BITS_PER_TONE+1));

   for (j=0; j<s_NumOfBands; j++)
   {
      for (i=psa_BandLeftChannel[j]; i<=psa_BandRightChannel[j]; i++)
      {
         // process RX tones for a given direction
         if ((puca_EGT[i] & MASK_BIT4) == (ft_direction<<4))
         {
            k = puca_BAT[i];
            sa_count[k]++;
         }
         else
         {
            if(ft_direction == RX)
            {
               gs_ToneReorderErrorCode = E_CODE_TRT_RXNUMTONE;
            }
            else
            {
               gs_ToneReorderErrorCode = E_CODE_TRT_TXNUMTONE;
            }
            return(FAIL);
         }
      }
   }

   //If the TCM is on, the number of 1-bit tones must be even
   if(ft_TcmFlag)
   {
      if(sa_count[1] & 1)
      {
         if(ft_direction == RX)
         {
            gs_ToneReorderErrorCode = E_CODE_TRT_RX_1BIT_TONES;
         }
         else
         {
            gs_ToneReorderErrorCode = E_CODE_TRT_TX_1BIT_TONES;
         }
         return(FAIL);
      }
   }

   //==========================================================================
   // fill in TRT
   //==========================================================================
   if(s_ToneOrderType == NORMAL_TONE_ORDER)
   {
      //Generate the TRT such that tones are ordered from the smallest to
      //largest constellation size

      //Find the beginning index of each constellation group
      sa_idx[0] = 0;
      for (k=1; k<=RX_MAX_BITS_PER_TONE; k++)
      {
         j = k-1;
         sa_idx[k] = sa_idx[j] + sa_count[j];
      }

      // Sort indices according to the constellation size
      for (j=0; j<s_NumOfBands; j++)
      {
         for (i=psa_BandLeftChannel[j]; i<=psa_BandRightChannel[j]; i++)
         {
            k = (int16)puca_BAT[i];
            psa_TRT[sa_idx[k]] = i;
            sa_idx[k]++;
         }
      }

   }
   else if (s_ToneOrderType == ILV_TONE_ORDER)
      // ILV_TONE_ORDER
      // Interleave tones in the TRT so that physically-adjacent tones are separated by gs_ilv_tone_order_parm_L
      // tones in the TRT.  Furthermore, consecutive tones in the TRT are separated by gs_ilv_tone_order_parm_K
      // tones in physical ordering, where
      // gs_ilv_tone_order_parm_K = ceiling(s_num_tones_loaded/gs_ilv_tone_order_parm_L).
      // Resultant table can be thought of as gs_ilv_tone_order_parm_K groups of gs_ilv_tone_order_parm_L tones.
   {
      //Will put 0-bitloaded tones at beginning of TRT, and interleave the rest.
      s_num_tones_loaded = 0;
      for (k=1; k<=RX_MAX_BITS_PER_TONE; k++)
      {
         s_num_tones_loaded += sa_count[k];
      }

      //K=ceil(N/L)
      gs_ilv_tone_order_parm_K = (s_num_tones_loaded + gs_ilv_tone_order_parm_L - 1)/gs_ilv_tone_order_parm_L;
      // if s_num_tones_loaded is not a multiple of gs_ilv_tone_order_parm_L, the last
      // gs_ilv_tone_order_num_empty_slots groups of tones will have gs_ilv_tone_order_parm_L-1 tones
      // instead of gs_ilv_tone_order_parm_L tones.
      gs_ilv_tone_order_num_empty_slots = gs_ilv_tone_order_parm_K*gs_ilv_tone_order_parm_L - s_num_tones_loaded;

      // If gs_ilv_tone_order_num_empty_slots is larger than the number of groups gs_ilv_tone_order_parm_K,
      // we have to reduce the number of tones per group gs_ilv_tone_order_parm_L.
      k = gs_ilv_tone_order_num_empty_slots/gs_ilv_tone_order_parm_K;
      gs_ilv_tone_order_parm_L_effective = gs_ilv_tone_order_parm_L - k;
      gs_ilv_tone_order_num_empty_slots = gs_ilv_tone_order_num_empty_slots % gs_ilv_tone_order_parm_K;

      s_index_nonbl = 0;
      s_index_bl = 0;
      for (j=0; j<s_NumOfBands; j++)
      {
         for (i=psa_BandLeftChannel[j]; i<=psa_BandRightChannel[j]; i++)
         {
            if (puca_BAT[i]==0)
            {
               psa_TRT[s_index_nonbl++] = i;
            }
            else
            {
               //(n mod k)L + floor(n/k)
               s_group =  s_index_bl % gs_ilv_tone_order_parm_K;
               s_index_in_group = s_index_bl / gs_ilv_tone_order_parm_K;
               s_addr = s_group*gs_ilv_tone_order_parm_L_effective + s_index_in_group;
               // adjust address downward if necessary, to account for any groups at the end
               // which have only gs_ilv_tone_order_parm_L_effective-1 tones.
               k = s_group - (gs_ilv_tone_order_parm_K-1) + (gs_ilv_tone_order_num_empty_slots-1);
               if (k<0)
               {
                  k=0;
               }
               s_addr = s_addr - k;
               s_addr = s_addr + sa_count[0];
               psa_TRT[s_addr] = i;
               s_index_bl ++;
            }// else
         }// for (i=
      }// for (j=
   }// else if

   else //NO_TONE_ORDER
   {
      // Generate the TRT according to its physical tone order
      k = 0;
      for (j=0; j<s_NumOfBands; j++)
      {
         for (i=psa_BandLeftChannel[j]; i<=psa_BandRightChannel[j]; i++)
         {
            psa_TRT[k++] = i;
         }
      }
   }
#ifndef HW_TRT
   // Save the RX TRT in the FDQ memory for later use
   if(ft_direction == RX)
   {
      // Find the correct offset to write to the FDQ array
      s_band = gs_TxTRT_write_band;
      s_start = gs_TxTRT_write_offset;

      // Save the read band ofset for Rx TRT for use in showtime
      gs_RxTRT_read_band = gs_TxTRT_write_band;
      gs_RxTRT_read_offset = gs_TxTRT_write_offset;

      s_end = (gsa_RxBandLeftChannel[s_band] << 1) - 1;
      if (s_end == -1)
      {
         s_end = s_end + 8192;
      }

      // NOTE: Number of tones is always even

      // Pack 2 tones of information ie. 3 bytes into a word
      for (j = 0; j<gs_RxNumTonesUsed; j = j+2)
      {
         // Encode two 12 bit values into 3 bytes message
         s_first = psa_TRT[j];
         s_second = psa_TRT[j+1];
         InitTwelveBitsPair(s_first, s_second, &temp24);

         j = j+2;

         // Clear the last values
         nexttemp24.uc_Byte0 =0;
         nexttemp24.uc_Byte1 =0;
         nexttemp24.uc_Byte2 =0;

         // Read next tone set
         if ( j < gs_RxNumTonesUsed)
         {
            s_first = psa_TRT[j];
            s_second = psa_TRT[j+1];
            InitTwelveBitsPair(s_first, s_second, &nexttemp24);

         }

         uca_temp[0] = temp24.uc_Byte0;
         uca_temp[1] = temp24.uc_Byte1;
         uca_temp[2] = temp24.uc_Byte2;

         uca_temp[3] = nexttemp24.uc_Byte0;
         uca_temp[4] = nexttemp24.uc_Byte1;
         uca_temp[5] = nexttemp24.uc_Byte2;

         for (i= 0; i < 6; i++)
         {
            // save the packed values in the FDQ memory
            us_word = (uca_temp[i++] << 8);
            us_word |= uca_temp[i];
            WriteTRT(us_word, &s_start, &s_end, &s_band);
         }

      }

      // Save for use later
      gs_RxTRT_write_band = s_band;
      gs_RxTRT_write_offset = s_start;

   } // if(ft_direction == RX)
#endif
   return(SUCCEED);

} //FormTRT()

void BgFormRxTRT(void)
{
   // Form the RX TRT table
   gft_ToneOrderOK = FormTRT(RX);

   //If FormTRT() is successful, do the following
   if(gft_ToneOrderOK != FAIL)
   {
      //Reorder the TRT generated above
      gft_ToneOrderOK = ReorderTRT_Rx();
   }

   gs_RxBkgdProcessFlag = TRAINING_DONE;
}
