/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   FrameAlignmentHandler.c
 *
 *   This file contains the routine that conducts frame alignment.
 *
 *------------------------------------------------------------------------
 */
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "FrameAlign.h"
#include "FrameAlignmentHandler.h"
#include "IRI_sync.h"
#include "fifo.h"
#include "sys_const.h"
#include "fdq.h"
#include "FdqHandler.h"
#include "accum32.h"
#include "SharedFuncs.h"
#include "IRI_Iof.h"
#include "cosine.h"
#include "states.h"
#include "vdsl_xception.h"
#include "ghs.h"
#include "mul.h"
#include "cmv.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void BgFrameAlignSelectBand(void)
*
*   This function selects start tone for frame alignment.
*   It assumes that gsa_SnrBuf contains either PSD, or SNR.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*      gsa_SnrBuf: (I) pointer to SNR/PSD buffer
*      gs_SelectBandStart: (O) start tone index
*      gs_NumFrameAlignClusters : (I/O) # of frame align clusters
*         (can be reduced here if there are not many tones with good SNR)
*
*-------------------------------------------------------------------------------
*/
#define START_MIN_SNR      (10*256)   //10 dB in Q8.8
#define END_MIN_SNR         (5*256)      //5 dB in Q8.8
#define STEP_SIZE_MIN_SNR   (2.5*256)   //2.5 dB in Q8.8

void BgFrameAlignSelectBand(void)
{
   int16 s_LogNumFrameAlignClusters, s_NumFrameAlignClusters, s_AvgSnr;
   int32 l_temp;


   gs_SelectBandStart = -1;
   s_LogNumFrameAlignClusters = LOG2_NUM_TONE_CLUSTERS_FRAME_ALIGN;
   gs_MinSnrThreshForFACluster = (int16)START_MIN_SNR;      //10 dB

   // Clear the pilot tones without data-on-pilot enabled from supported set to avoid bit-loading
   ClearSetPilotTonesInSupportedSet((int16)CLEAR_TONES_SUPPORTED_SET);

   // keep trying until we select the start tone index, or # of clusters is reduced to 1
   while ( gs_MinSnrThreshForFACluster >= (int16)END_MIN_SNR )
   {
      while ((gs_SelectBandStart == -1) && (s_LogNumFrameAlignClusters >= 0))
      {
         s_NumFrameAlignClusters = (int16)(1 << s_LogNumFrameAlignClusters);
         gs_SelectBandSize = (s_NumFrameAlignClusters+1)*NUM_CHANNELS_PER_CLUSTER;

         SelectBand(gsa_SnrBuf, gs_SelectBandSize, gs_MinSnrThreshForFACluster, &gs_SelectBandStart, &s_AvgSnr);
         s_LogNumFrameAlignClusters--;
      }

      if(gs_SelectBandStart == -1)
      {
         gs_MinSnrThreshForFACluster -= (int16)STEP_SIZE_MIN_SNR;
         s_LogNumFrameAlignClusters = LOG2_NUM_TONE_CLUSTERS_FRAME_ALIGN;
      }
      else
      {
         break;
      }
   }


   if(gs_SelectBandStart != -1)
   {
      gs_NumFrameAlignClusters = (int16)(1 << (s_LogNumFrameAlignClusters + 1));

      gs_SelectBandStart = (gs_SelectBandStart+9)/10;

      // get next multiple of 10 tone
      MULS16(l_temp, gs_SelectBandStart, (int16)10);
      gs_SelectBandStart = (int16)l_temp;
   }

   // Add back the pilot tone indexes
   ClearSetPilotTonesInSupportedSet((int16)SET_TONES_SUPPORTED_SET);

   gs_RxBkgdProcessFlag = TRAINING_DONE;
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void FrameAlignmentHandler(void)
*
*   This function performs frame alignment (compute offset and load it to HW).
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void FrameAlignmentHandler(void)
{
   static int16 s_IdleCnt;
   int16 s_MaxIteration;

   switch(gs_AlgHandlerState)
   {
   case FRAMEALIGNMENT_SELECT_TONES:

      gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
      // this function will select gs_SelectBandStart, gs_NumFrameAlignClusters
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgFrameAlignSelectBand);
      gs_AlgHandlerState = FRAMEALIGNMENT_SELECT_TONES_WAIT;
      break;

   case FRAMEALIGNMENT_SELECT_TONES_WAIT:

      if (gs_RxBkgdProcessFlag == TRAINING_DONE)
      {
         // check the result and enter fail state if no band was found
         if (gs_SelectBandStart == -1)
         {
            EnterFailStates(E_CODE_ZERO_TONE_CLUSTERS_FRAMEALIGNMENTHANDLER);
         }

         //Compute the number of the tones in the selected clusters
         {
            int32 l_Product;

            MULS16(l_Product, (int16)(gs_NumFrameAlignClusters+1), (int16)10);
            gs_NumOfTonesInBand = (int16)l_Product;
         }

         gs_RxToneOffset = gs_SelectBandStart;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, SetRxToneOffset);

         gs_LeftChannel  = gs_RxToneOffset;
         gs_RightChannel = gs_LeftChannel + gs_NumOfTonesInBand - 1;

         // Set flag to read FFT output
         gs_RtvSelect = FFT_OUTPUT;
         gs_AlgHandlerState = FRAMEALIGNMENT_INIT_0;

         // For VRx518 the RTV is twice, i.e. for 1024 tones.
         // Note: Normally RTV size should be considered!
         //       The code should also handle on the fly configured values for debuging!
         gs_NumChannelsPerGroup = gt_FrameAlignConfig.s_NumChannelsPerGroup;

         // debug start - code to trace frame alignment tones
//            if((gs_Debug1+10) < 4096)
//            {
//               gsa_TrnVectoringBuffer[gs_Debug1++] = gs_PGA_set;
//               gsa_TrnVectoringBuffer[gs_Debug1++] = gs_RxVarGainDB;
//               gsa_TrnVectoringBuffer[gs_Debug1++] = gs_RxToneOffset;
//               gsa_TrnVectoringBuffer[gs_Debug1++] = gs_NumOfTonesInBand;
//               gsa_TrnVectoringBuffer[gs_Debug1++] = (int16)0xAAAA;
//            }
         // debug end - code to trace frame alignment tones

      }
      break;
   case FRAMEALIGNMENT_INIT_0:
      // Set the number of symbols used for frame alignment.
      gs_AlgLog2NumFramesToAccum = gt_FrameAlignConfig.s_AlgLog2NumFramesToAccum;
      gs_AlgNumFramesToAccum = (1 << gs_AlgLog2NumFramesToAccum);

      // start frame alignment
      gs_MaxOffsetCount = 0;
      gs_CumulativeAlignmentOffset = 0;
      gs_FrameAlignIteration = 0;
      gs_AlgHandlerState = FRAMEALIGNMENT_INIT;
      break;

   case FRAMEALIGNMENT_INIT:

      // Clear RxAccumBuf for Frame alignment Accum
      // Note: The accumulation is done from 16bit to 32bit and
      //       every tone consists out of Real and Imag part.
      memset(gpla_RxAccumBuf, 0, (sizeof(int32)*(gs_NumOfTonesInBand<<1)));
      gft_FrameAlignRemoveOutliers = 0;

      // Transition to next substate
      gs_AlgHandlerCount = 0;
      gs_AlgHandlerState = FRAMEALIGNMENT_WAIT_FOR_HW_SET;
      break;

   case FRAMEALIGNMENT_WAIT_FOR_HW_SET:

      // Wait for RTV buffer 0 HW settings to take effect
      if (gs_AlgHandlerCount < gs_RTVxCfgLatency)
      {
         gs_AlgHandlerCount++;
      }
      else
      {
         // Transition to accumulation substate
         gs_AlgHandlerCount = 0;
         gs_AlgHandlerState = FRAMEALIGNMENT_ACCUM;
      }
      break;

   case FRAMEALIGNMENT_ACCUM:

      //==============================================================================
      // Average representative frames.
      //==============================================================================

      // DSM_Vectoring_Check:
      // Note: Since for ChannelDiscovery the FrameAlignHandler() fct. is also called
      //       before the DetectDSSync fct. the position of the DS snc symbol can vary
      //       at least one. To be on the save side 5 symbols were selected.
      //       (Working tests were done with (gs_RxFrmCnt > 80) &&(gs_RxFrmCnt < 200)))!!!
      if ((gft_DSVectoringEnabled == FALSE) || ((gs_RxFrmCnt > 80) &&(gs_RxFrmCnt < 200)))
      {
         // debug start - code to trace frame alignment tones
//            {
//               if((gs_Debug1+(gs_NumFrameAlignClusters*6)+1) < 4096)
//               {
//                  int16 *pToneBuf;
//                  int16 mf_i, mf_j = 0, mf_k;
//                  for (mf_k = 0; mf_k < gs_NumFrameAlignClusters; mf_k++)
//                  {
//                     mf_i = 2*(mf_k*10+10-(2-mf_j));
//                     pToneBuf = (gpsa_RxToneBuf+mf_i);
//                     gsa_TrnVectoringBuffer[gs_Debug1++] = *pToneBuf++;
//                     gsa_TrnVectoringBuffer[gs_Debug1++] = *pToneBuf++;
//                     gsa_TrnVectoringBuffer[gs_Debug1++] = *pToneBuf++;
//                     gsa_TrnVectoringBuffer[gs_Debug1++] = *pToneBuf++;
//                     gsa_TrnVectoringBuffer[gs_Debug1++] = *pToneBuf++;
//                     gsa_TrnVectoringBuffer[gs_Debug1++] = *pToneBuf;
//                  }
//                  if((gs_RxState == 20) && (gs_RxSubState == 13))
//                  {
//                     gsa_TrnVectoringBuffer[gs_Debug1++] = (int16)0xBBBB;
//                  }
//                  if((gs_RxState == 78) && (gs_RxSubState == 4))
//                  {
//                     gsa_TrnVectoringBuffer[gs_Debug1++] = (int16)0xCCCC;
//                  }
//               }
//
//               if((gs_RxState == 20) && (gs_RxSubState == 13))
//               {
//                  if(gs_PauseControl == 0x98)
//                     Pause(gs_PauseControl);
//               }
//               if((gs_RxState == 78) && (gs_RxSubState == 4))
//               {
//                  if(gs_PauseControl == 0x99)
//                     Pause(gs_PauseControl);
//               }
//            }
         // debug end - code to trace frame alignment tones

         Accum16to32(gpla_RxAccumBuf, 0, gpsa_RxToneBuf, 0, (int16)(gs_NumOfTonesInBand<<1));
         gs_AlgHandlerCount++;
      }

      if (gs_AlgHandlerCount == gs_AlgNumFramesToAccum)
      {
         // Compute average of the accumulated frames in background
         guc_FdqTrainingState = TRAINING_IN_PROGRESS;

         // Re-use BgAvgFDQAccumulation for frame alignment accumulation:
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgAvgFDQAccumulation);
         gs_AlgHandlerState = FRAMEALIGNMENT_CALCSYNC;
      }
      break;

   case FRAMEALIGNMENT_CALCSYNC:

      if (guc_FdqTrainingState == TRAINING_DONE)
      {

         if (gs_FrameAlignIteration >= gs_MaxOffsetCount+2)
         {
            gft_FrameAlignRemoveOutliers = 1;
         }

         guc_FrameAlignmentState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgRxFrameSync);
         gs_AlgHandlerState = FRAMEALIGNMENT_SET;
      }
      break;

   case FRAMEALIGNMENT_SET:

      if (guc_FrameAlignmentState == TRAINING_DONE)
      {
         // ANXQ_SUPPORT - For AnxQ only even values can be transmitted in the SOC messages!
         if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
         {
            gs_AlignmentOffset &= (0xFFFE);
         }

         if (gs_AlignmentOffset >  gt_FrameAlignConfig.s_MaxAlignmentOffset)
         {
            gs_AlignmentOffset =  gt_FrameAlignConfig.s_MaxAlignmentOffset;
            gs_MaxOffsetCount++;
         }
         else if (gs_AlignmentOffset < -gt_FrameAlignConfig.s_MaxAlignmentOffset)
         {
            gs_AlignmentOffset = -gt_FrameAlignConfig.s_MaxAlignmentOffset;
            gs_MaxOffsetCount++;
         }

         // Save gs_AlignmentOffset in array to be able to check for convergence or for debug purposes:
         gsa_FrameAlignOffsets[gs_FrameAlignIteration] = gs_AlignmentOffset;

         gs_CumulativeAlignmentOffset += gs_AlignmentOffset;

         // Increment iteration count.
         gs_FrameAlignIteration++;

         gs_RxFrameAlignRemain = 0;

         AddFunctionToFifo(gp_RxLoadingFunctionFifo, AdjustAlignment);
         gft_EnablePLL = 0; // Turn off PLL
         s_IdleCnt = 0;
         gs_AlgHandlerState = FRAMEALIGNMENT_RESET;
      }
      break;

   case FRAMEALIGNMENT_RESET:
      int16 sa_tempPllRefTone[2];

      //For the 6.2 HW, it is not allowed to make a strymon frame less than FFT size
      //so it may take more than one frame to do frame adjustment if gs_AlignmentOffset is greater than
      //CE Length. Note the variable gs_RxFrameAlignRemain stores the remaining adjustment
      //after each call to AdjustAlignment()
      if(gs_RxFrameAlignRemain != 0)
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, AdjustAlignment);
         break;
      }

      s_IdleCnt++;
      if (s_IdleCnt==1)
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ResetRxAlign);
      }
      if (s_IdleCnt==4)
      {
         // XDSLRTFW-3280 - Start - PLL improvement / pilot tone selection improvement
         gft_EnablePLL = 1; // Turn on PLL
         // grab a new reference for 1st and 2nd iterations
         // (not counting iterations with maximum alignment offset)
         if (gs_FrameAlignIteration <= gs_MaxOffsetCount+2)
         {
            // Set new Pll RefTone for all 3 supported pilot tones.
            ResetPllRefTone(PT_ARRAY_IDX_0, &gt_PilotConfig, NULL, NULL, (int16)3 );
         }
         else
         {
            // Adjust PLL reference of 1st pilot tone
            sa_tempPllRefTone[0] = gt_PilotConfig.ta_PilotTones[0].s_PllRefTone_Re;
            sa_tempPllRefTone[1] = gt_PilotConfig.ta_PilotTones[0].s_PllRefTone_Im;
            RotateTone(gs_AlignmentOffset, gt_PilotConfig.ta_PilotTones[0].s_PilotToneIdx, &sa_tempPllRefTone[0]);
            gt_PilotConfig.ta_PilotTones[0].s_PllRefTone_Re = sa_tempPllRefTone[0];
            gt_PilotConfig.ta_PilotTones[0].s_PllRefTone_Im = sa_tempPllRefTone[1];

            // Adjust PLL reference of 2nd pilot tone
            sa_tempPllRefTone[0] = gt_PilotConfig.ta_PilotTones[1].s_PllRefTone_Re;
            sa_tempPllRefTone[1] = gt_PilotConfig.ta_PilotTones[1].s_PllRefTone_Im;
            RotateTone(gs_AlignmentOffset, gt_PilotConfig.ta_PilotTones[1].s_PilotToneIdx, &sa_tempPllRefTone[0]);
            gt_PilotConfig.ta_PilotTones[1].s_PllRefTone_Re = sa_tempPllRefTone[0];
            gt_PilotConfig.ta_PilotTones[1].s_PllRefTone_Im = sa_tempPllRefTone[1];

            // Adjust PLL reference of 3rd pilot tone
            sa_tempPllRefTone[0] = gt_PilotConfig.ta_PilotTones[2].s_PllRefTone_Re;
            sa_tempPllRefTone[1] = gt_PilotConfig.ta_PilotTones[2].s_PllRefTone_Im;
            RotateTone(gs_AlignmentOffset, gt_PilotConfig.ta_PilotTones[2].s_PilotToneIdx, &sa_tempPllRefTone[0]);
            gt_PilotConfig.ta_PilotTones[2].s_PllRefTone_Re = sa_tempPllRefTone[0];
            gt_PilotConfig.ta_PilotTones[2].s_PllRefTone_Im = sa_tempPllRefTone[1];
         }
         // XDSLRTFW-3280 - End - PLL improvement / pilot tone selection improvement

         s_IdleCnt = 0;
         gs_AlgHandlerState = FRAMEALIGNMENT_PLL_RELOCK;

      }
      break;

   case FRAMEALIGNMENT_PLL_RELOCK:
      s_IdleCnt++;
      if (s_IdleCnt == gs_NumFramesPLLRelock)
      {
         s_IdleCnt = 0;
         s_MaxIteration = gt_FrameAlignConfig.s_MinNumIterations + gs_MaxOffsetCount;
         if (s_MaxIteration > gt_FrameAlignConfig.s_MaxNumIterations)
         {
            s_MaxIteration = gt_FrameAlignConfig.s_MaxNumIterations;
         }
         if (gs_FrameAlignIteration == s_MaxIteration)
         {
            gs_AlgHandlerState = FRAMEALIGNMENT_DONE;
            gs_NumChannelsPerGroup = gs_NumChannelsPerGroupSave;
         }
         else
         {
            gs_AlgHandlerState = FRAMEALIGNMENT_INIT;
         }
      }
      break;
   }


   /* =============================================== */
   /* State machine to request swap page            */
   /* =============================================== */
   switch(guc_RxSwapActivity)
   {
   case CODESWAP_LOAD(VDSL_ALGHD_1_V2_PM_SWAPPAGE):
      if ((guc_PrimPageHandle = RequestSwap(VDSL_ALGHD_1_V2_PM_SWAPPAGE)) != INVALID_CODESWAP_HANDLE)
      {
         guc_RxSwapActivity = CODESWAP_CHECK(VDSL_ALGHD_1_V2_PM_SWAPPAGE);
      }
      break;

   case CODESWAP_CHECK(VDSL_ALGHD_1_V2_PM_SWAPPAGE):
      if (PollForCodeSwapDone(VDSL_ALGHD_1_V2_PM_SWAPPAGE, guc_PrimPageHandle) == SWAP_DONE)
      {
         guc_RxSwapActivity = CODESWAP_DO_NOTHING;
      }
      break;

   }


}
