/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   GetTonePsd.c
*
*   This file contains the functions used to compute per tone psd level.
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "dsp_op.h"
#include "mul.h"
#include "ConvertToDB.h"
#include "decimalgain.h"
#include "SharedFuncs.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: Compute psd level "wrt MaxNomPsd "of i/p tone index given
 *               PSD descriptor table
 *
 *  Prototype: void GetTonePsd(void)
 *
 *  Input Arguments:
 *      s_toneIdxIn           -  I/P Tone Index
 *      pt_PSDDescIn          -  I/P PSD Descriptor Table
 *      s_NumOfTones_RxOrTx   -  Number of RX or TX tones; Typical Values:4096 or 8192
 *
 *  Output Arguments: none
 *
 *  Return: PSD level of tone wrt MaxNomPsd
 *
 *------------------------------------------------------------------------
 *^^^
 */
int16 GetTonePsd(int16 s_toneIdxIn, PSDDescriptorTable_t *pt_PSDDescIn,int16 s_NumOfTones_RxOrTx) //   XDSLRTFW-3838
{
   int16 i, s_NumBrkpts, s_attenLevel;
   int16 s_leftBrkptToneIdx, s_leftBrkptAttenLevel, s_rightBrkptToneIdx, s_rightBrkptAttenLevel;
   PSDRecord_t *pt_PSDRec;
   int16 s_maxToneIndex;

   s_maxToneIndex = s_NumOfTones_RxOrTx-1;
   s_NumBrkpts = pt_PSDDescIn->us_NumberOfTones;
   pt_PSDRec = &(pt_PSDDescIn->ut_PSDRecord[0]);

   // Note: When the tone index is greater than the last BrkptToneIdx then
   //        i = s_NumBrkpts = pt_PSDDescIn->us_NumberOfTones!
   //       For this tone index (frequency) higher than last breakpoint a flat extension of log_PSD
   //       must be done.
   for (i=0; i < s_NumBrkpts; i++)
   {
      if (pt_PSDRec[i].us_IndexOfTone >= s_toneIdxIn)
      {
         break;
      }
   }

   /* Get the adjacent breakpoints given breakpoint index */
   GetAdjacentBreakpts(i, s_NumBrkpts, pt_PSDRec, 0, s_maxToneIndex,
                       &s_leftBrkptToneIdx, &s_leftBrkptAttenLevel, &s_rightBrkptToneIdx, &s_rightBrkptAttenLevel);


   /* Compute attenuation level given tone index and adjacent breakpoints */
   s_attenLevel = CalcAttenLevel(s_toneIdxIn, s_leftBrkptToneIdx, s_leftBrkptAttenLevel,
                                 s_rightBrkptToneIdx, s_rightBrkptAttenLevel);

   return(-s_attenLevel);
}
