/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   InterpolatePSDUtil_tssi.c
 *
 *   This file contains a version of InterpolatePSDUtil() which
 *   generates log_Tssi breakpoints (in pt_PSDDescOut_PreTxPathAtten) in addition to the
 *   actual TX PSD breakpoints (in pt_PSDDescOut_PostTxPathAtten).
 *   The log_Tssi breakpoints are based on the TX path filter attenuation (in pt_PSDDescIn_UsTxAtten),
 *   and the tx mask (in pt_PSDDescIn), after applying the ceiling s_MinAtten to the mask.
 *   If NULL is passed for pt_PSDDescIn_UsTxAtten, the tx path is assumed to have no attenuation.
 *   The values generated for ghpuca_TxExtGains_Inactive[] correspond to log_Tssi.
 *
 *-------------------------------------------------------------------------
 */

#include <stdlib.h>
#include "common.h"
#include "gdata.h"
#include "cmv_data.h"
#include "sys_const.h"
#include "dsp_op.h"
#include "TxPSDControl.h"
#include "IRI_Iof.h"
#include "LL_IOf.h"
#include "V_STR_IOf.h"
#include "afe.h"
#include "Snr_b.h"
#include "ConvertToDB.h"
#include "decimalgain.h"
#include "mul.h"
#include <memory.h>
#include "SharedFuncs.h"
#include "fifo.h"
#include "GetTonePsd.h"
#include "vdsl_const.h"


void InterpolatePSDUtil_tssi(int16 s_MaxNumBrkpts,
                             PSDDescriptorTable_t *pt_PSDDescIn,
                             PSDDescriptorTable_t *pt_PSDDescIn_UsTxAtten,
                             int16 s_MinAtten_in,
                             int16 *ps_min_atten_dB,
                             PSDDescriptorTable_t *pt_PSDDescOut)

{

   int16 i, j, s_NumBrkpts, s_temp;
   int16 s_attenLevel=0, s_leftToneIdx, s_leftToneAttenLevel, s_rightToneIdx, s_rightToneAttenLevel;
   int16 s_maxPsdLeftToneAttenLevel, s_maxPsdRightToneAttenLevel;
   int16 s_addBrkptToneIdx, s_addBrkptAttenLevel=0;
   int16 s_attenLevel_previous,s_addBrkptAttenLevel_previous=0;
   PSDDescriptorTable_t t_PSDDescInExpanded;
   PSDDescriptorTable_t *pt_PSDDescInExpanded;
   int16 s_MinAtten = s_MinAtten_in;

   /* Initialize minimum attenuation */
   *ps_min_atten_dB = 0x7fff;   // High value

   // Copy pt_PSDDescIn into an expanded set of breakpoints, t_PSDDescInExpanded.
   t_PSDDescInExpanded.us_NumberOfTones = pt_PSDDescIn->us_NumberOfTones;
   for (i=0; i<t_PSDDescInExpanded.us_NumberOfTones; i++)
   {
      t_PSDDescInExpanded.ut_PSDRecord[i].us_IndexOfTone = pt_PSDDescIn->ut_PSDRecord[i].us_IndexOfTone;
      t_PSDDescInExpanded.ut_PSDRecord[i].s_PSDLevelOfTone = pt_PSDDescIn->ut_PSDRecord[i].s_PSDLevelOfTone;
   }

   pt_PSDDescInExpanded = &t_PSDDescInExpanded;

   // If we need to incorporate US TX filter attenuation,
   // add breakpoints in pt_PSDDescInExpanded, corresponding to the breakpoint frequencies of pt_PSDDescIn_UsTxAtten.
   // The PSD levels are those interpolated from pt_PSDDescInExpanded.

   s_NumBrkpts = pt_PSDDescInExpanded->us_NumberOfTones;
   for (i=0; i<pt_PSDDescIn_UsTxAtten->us_NumberOfTones; i++)
   {
      // Determine the TX Mask level, at breakpoint i in the TX path attenuation table.
      // GetTonePsd() actually returns a gain, from the stored attenuations.
      s_temp = GetTonePsd(pt_PSDDescIn_UsTxAtten->ut_PSDRecord[i].us_IndexOfTone, (PSDDescriptorTable_t*)pt_PSDDescInExpanded, gs_TxNumTones);//XDSLRTFW-3838
      pt_PSDDescInExpanded->ut_PSDRecord[s_NumBrkpts+i].us_IndexOfTone = pt_PSDDescIn_UsTxAtten->ut_PSDRecord[i].us_IndexOfTone;
      pt_PSDDescInExpanded->ut_PSDRecord[s_NumBrkpts+i].s_PSDLevelOfTone = -s_temp;
   }
   pt_PSDDescInExpanded->us_NumberOfTones += pt_PSDDescIn_UsTxAtten->us_NumberOfTones;

   // Sort breakpoints by frequency
   quick_PSDsort(pt_PSDDescInExpanded, 0, (int16) (pt_PSDDescInExpanded->us_NumberOfTones -1));

   // Eliminate any repeated frequencies
   s_temp = -1;
   i=0;
   while (i<pt_PSDDescInExpanded->us_NumberOfTones)
   {
      if (pt_PSDDescInExpanded->ut_PSDRecord[i].us_IndexOfTone == s_temp)
      {
         for (j=i; j<(pt_PSDDescInExpanded->us_NumberOfTones -1); j++)
         {
            pt_PSDDescInExpanded->ut_PSDRecord[j].us_IndexOfTone =
               pt_PSDDescInExpanded->ut_PSDRecord[j+1].us_IndexOfTone;
            pt_PSDDescInExpanded->ut_PSDRecord[j].s_PSDLevelOfTone =
               pt_PSDDescInExpanded->ut_PSDRecord[j+1].s_PSDLevelOfTone;
         } // for (j=
         pt_PSDDescInExpanded->ut_PSDRecord[pt_PSDDescInExpanded->us_NumberOfTones -1].us_IndexOfTone = 0;
         pt_PSDDescInExpanded->ut_PSDRecord[pt_PSDDescInExpanded->us_NumberOfTones -1].s_PSDLevelOfTone = 0;
         pt_PSDDescInExpanded->us_NumberOfTones = pt_PSDDescInExpanded->us_NumberOfTones-1;
      } //if
      else
      {
         s_temp = pt_PSDDescInExpanded->ut_PSDRecord[i].us_IndexOfTone;
         i++;
      } //else
   } //while

   s_NumBrkpts = pt_PSDDescInExpanded->us_NumberOfTones;

   for (i=0; i <= s_NumBrkpts; i++)
   {

      /* Get the adjacent breakpoints given breakpoint index */
      GetAdjacentBreakpts(i, s_NumBrkpts, &pt_PSDDescInExpanded->ut_PSDRecord[0], 0, (int16)(gs_TxNumTones-1),
                          &s_leftToneIdx, &s_leftToneAttenLevel, &s_rightToneIdx, &s_rightToneAttenLevel);

      /* Keep a copy of the max psd attenuations for adjacent breakpoint indexs' */
      s_maxPsdLeftToneAttenLevel = s_leftToneAttenLevel;
      s_maxPsdRightToneAttenLevel = s_rightToneAttenLevel;

      /* Get the actual psd attenuations for adjacent breakpoint indexs' with upbo */
      if (gt_TxPsdControl.pt_RefPsdDescIn)
      {
         s_leftToneAttenLevel = GetUPBOAttenLevel(s_leftToneIdx, s_leftToneAttenLevel);
         s_rightToneAttenLevel = GetUPBOAttenLevel(s_rightToneIdx, s_rightToneAttenLevel);
      }

      // Refer the Attenuation level to before the TX path attenuation.  GetTonePsd() returns a gain.
      s_leftToneAttenLevel += GetTonePsd(s_leftToneIdx, pt_PSDDescIn_UsTxAtten, gs_TxNumTones);//XDSLRTFW-3838
      s_rightToneAttenLevel += GetTonePsd(s_rightToneIdx, pt_PSDDescIn_UsTxAtten, gs_TxNumTones);//XDSLRTFW-3838

      //Start interpolation
      s_addBrkptToneIdx = -1;
      for (j=s_leftToneIdx; j < s_rightToneIdx; j++)
      {
         /* Compute attenuation level given tone index and adjacent breakpoints */
         s_attenLevel = CalcAttenLevel(j, s_leftToneIdx, s_maxPsdLeftToneAttenLevel, s_rightToneIdx, s_maxPsdRightToneAttenLevel);

         /* Get the actual psd attenuations for given tone index with upbo */
         if (gt_TxPsdControl.pt_RefPsdDescIn)
         {
            s_attenLevel = GetUPBOAttenLevel(j, s_attenLevel);
         }
         // Refer the Attenuation level to before the TX path attenuation.  GetTonePsd() returns a gain.
         s_attenLevel += GetTonePsd(j, pt_PSDDescIn_UsTxAtten, gs_TxNumTones);//XDSLRTFW-3838

         //Put additional limit to the US0 band
         s_MinAtten = s_MinAtten_in;

         if (s_attenLevel < s_MinAtten)
         {
            s_attenLevel = s_MinAtten;
         }

         s_attenLevel_previous = s_attenLevel;

         /* If we need to add a breakpoint because of PSD limit  */
         /* get the inflexion point @ which we need to add a brkpt   */
         if (s_addBrkptToneIdx == -1)
         {
            /* Implies decrease in attenuation slope, check for attenuation level going below the limit */
            if ((s_leftToneAttenLevel > s_MinAtten && s_rightToneAttenLevel < s_MinAtten && s_attenLevel <= s_MinAtten) ||
                  /* Implies increase in attenuation slope, check for attenuation level going above the limit */
                  (s_leftToneAttenLevel < s_MinAtten && s_rightToneAttenLevel > s_MinAtten && s_attenLevel >= s_MinAtten))
            {
               s_addBrkptToneIdx = j;
               s_addBrkptAttenLevel = s_attenLevel;

               if (s_addBrkptAttenLevel < s_MinAtten)
               {
                  s_addBrkptAttenLevel = s_MinAtten;
               }

               // Record previous tone's level, we need to add a breakpoint for it also.
               // Otherwise, to the left of s_addBrkptToneIdx the set of breakpoints will imply
               // linear interpolation to the capped level of s_addBrkptAttenLevel, whereas the
               // the tx fine gains are linearly interpolated to the uncapped level.
               s_addBrkptAttenLevel_previous = s_attenLevel_previous;
            }
         }

         // Limit the interpoloated attenuation level to minimum value specified


         if (*(ghpuca_TxExtGains_Inactive+j) & 0x10)
         {

            // Keep track of the smallest attenuation (which is relative to maxnompsd).
            // We will subsequently adjust maxnompsd accordingly.
            if (s_attenLevel < *ps_min_atten_dB)
            {
               *ps_min_atten_dB = s_attenLevel;
            }

         } //if (*(ghpuca_TxExtGains_Inactive+j) == 0x10)

      } //for(j=


      /* copy breakpoint from pt_PSDRecIn to pt_PSDDescOut */
      if (i != 0)
      {

         //Put additional limit to the US0 band
         s_MinAtten = s_MinAtten_in;

         // If the only crossing of s_MinAtten for this existing pair of breakpoints
         // occurs at s_rightToneIdx, we need to generate a breakpoint at
         // tone s_rightToneIdx-1.

         if (((s_leftToneAttenLevel > s_MinAtten && s_rightToneAttenLevel < s_MinAtten ) ||
               (s_leftToneAttenLevel < s_MinAtten && s_rightToneAttenLevel > s_MinAtten ) )
               && (s_addBrkptToneIdx == -1) && ((s_rightToneIdx-1)!=s_leftToneIdx) )
         {
            AddPsdBrkpt((int16) (s_rightToneIdx-1), s_attenLevel, pt_PSDDescOut, s_MaxNumBrkpts);
         }

         //Put additional limit to the US0 band
         s_MinAtten = s_MinAtten_in;

         if (s_leftToneAttenLevel < s_MinAtten)
         {
            s_leftToneAttenLevel = s_MinAtten;
         }

         AddPsdBrkpt(s_leftToneIdx, s_leftToneAttenLevel, pt_PSDDescOut, s_MaxNumBrkpts);

      }
      /* add additional breakpoint to pt_PSDDescOut if required */
      if (s_addBrkptToneIdx != -1)
      {
         if ((s_addBrkptToneIdx-1)!=s_leftToneIdx)
         {
            AddPsdBrkpt((int16) (s_addBrkptToneIdx-1), s_addBrkptAttenLevel_previous, pt_PSDDescOut, s_MaxNumBrkpts);
         }

         AddPsdBrkpt(s_addBrkptToneIdx, s_addBrkptAttenLevel, pt_PSDDescOut, s_MaxNumBrkpts);
      }
   }//for(i=


   //Remove redudant breakpoints
   CleanUpPsdBrkpt(s_MaxNumBrkpts, pt_PSDDescOut);

   // Sort the PSD Descriptor table so that the Masks are in ascending order
   quick_PSDsort(pt_PSDDescOut, 0, (int16)(pt_PSDDescOut->us_NumberOfTones-1));

}

