/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   LoadTransmitGains.c
*
*   This file contains functions to allow the modem to set PSD Masks.
*
*-------------------------------------------------------------------------
*/

#include <stdlib.h>
#include "common.h"
#include "gdata.h"
#include "cmv_data.h"
#include "sys_const.h"
#include "dsp_op.h"
#include "TxPSDControl.h"
#include "afe.h"
#include "Snr_b.h"
#include "ConvertToDB.h"
#include "decimalgain.h"
#include "mul.h"
#include <memory.h>
#include "SharedFuncs.h"
#include "fifo.h"
#include "GetTonePsd.h"
#include "vdsl_state.h"
#include "IRI_Iof.h"
#include "LL_IOf.h"
#include "V_STR_IOf.h"
#include "V_STR_IIR_IOf.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : LoadAfeTransmitGains
 *
 *  Description:
 *
 *      This function loads the AFE with result of SetTransmitGains().
 *
 *  Prototype:
 *      void LoadAfeTransmitGains(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Return:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
#ifdef INCLUDE_CACHE_FUNCTIONS

void LoadAfeTransmitGains(void)
{
#ifndef TARGET_HW_TEST

   //make the AFE write for TX AFE gain setting.

   AFED_SetAfeTxGain((int16)(gs_tx_afe_gain_setting_dB>>8));

#endif // TARGET_HW_TEST

   gs_TxBkgdProcessFlag = TRAINING_DONE;

}
#endif  // INCLUDE_CACHE_FUNCTIONS


#ifdef INCLUDE_NON_CACHE_FUNCTIONS

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : LoadTransmitGains
 *
 *  Description:
 *
 *      This function loads HW based on the task layer settings determined in SetTransmitGains, for
 *      Fine Gains, etc table, IFFT scales, TXvargin, AFE TX gain, conditional parr enable.
 *
 *  Prototype:
 *      void LoadTransmitGains(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Return:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void LoadTransmitGains(void)
{
   switch (guc_LoadTransmitGainsState)
   {
   case LTG_LOAD_IRIDIA:
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, LoadIridiaTransmitGains);
      guc_LoadTransmitGainsState = LTG_LOAD_AFE_BKGRND;
      break;

   case LTG_LOAD_AFE_BKGRND:
      gs_TxBkgdProcessFlag = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)LoadAfeTransmitGains);
      guc_LoadTransmitGainsState = LTG_LOAD_STRYMON;
      break;

   case LTG_LOAD_STRYMON:
      if (gs_TxBkgdProcessFlag == TRAINING_DONE)
      {
         if (!(gul_dbgSnifferControl & SNIFFER_TX_DISABLE_VARGAIN))
         {
            AddFunctionToFifo(gp_TxLoadingFunctionFifo, SetTxVarGain);
         }
         guc_LoadTransmitGainsState = LTG_LOAD_AFE_DONE;
      }
      break;

   case LTG_LOAD_AFE_DONE:
      //Tell the Task that called LoadTransmitGains() that we are done.
      guc_LoadTransmitGainsState = LTG_LOAD_DONE;
      break;
   }
}
#endif // INCLUDE_NON_CACHE_FUNCTIONS
