/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: MfdqHandler.c
*
*   This file contains functions to calculate or update MFDQ coefficients.
*
*-------------------------------------------------------------------------------
*/

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "fifo.h"
#include "IRI_Iof.h"
#include "IRI_IOf_mfdq.h"
#include "MfdqHandler.h"
#include "MfdqHandler_b.h"
#include "MfdqSupport.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void MfdqHandler(void)
*
*   This function trains multi-tap FDQ (MFDQ) coefficients.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void MfdqHandler(void)
{
   int16 s_NumFramesToAccum;

   switch (gt_MfdqConfig.s_AlgHandlerState)
   {

   case MFDQ_TRAIN_INIT:

      // disable RTV read through GetRxTones()
      gft_EnableGetRxTones = FALSE;

      // determine MFDQ tones and associated feedback tones
      // initialize all other variables used in MfdqHandler()
      guc_MfdqTrainingState = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgInitMfdqVars);
      gt_MfdqConfig.s_AlgHandlerState = MFDQ_TRAIN_INIT_WAIT;
      break;

   case MFDQ_TRAIN_INIT_WAIT:

      if (guc_MfdqTrainingState == TRAINING_DONE)
      {
         // if MFDQ tone selection is unsuccessful, skip MFDQ training
         if (gt_MfdqConfig.s_ErrorCode & MFDQ_ABORT_MASK)
         {
            gt_MfdqConfig.s_AlgHandlerState = MFDQ_TRAIN_DONE;
            break;
         }

         // read and save SFDQ coefficients
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ReadSfdqCoef);

         // prepare HW for MfdqHandler()
         // set up RTV buffers to collect SFDQ and decision output
         // initialize MFDQ tone table, etc
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, SetUpHwForMfdqHandler);

         // set tone offset to be stored in RTV0 and RTV1 buffers
         gs_RxToneOffset = gt_MfdqConfig.s_ReadToneStart;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, SetRxToneOffset);

         // skip one frame to take effect on tone offset setting
         gs_AlgHandlerCount = 1;
         gt_MfdqConfig.s_AlgHandlerState = MFDQ_TRAIN_READ_HW;
      }
      break;

   case MFDQ_TRAIN_READ_HW:

      if (gs_AlgHandlerCount < gs_RTVxCfgLatency)
      {
         gs_AlgHandlerCount++;
      }
      else
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, GetRxDataForMfdqHandler);
         gs_AlgHandlerCount = 0;
         gt_MfdqConfig.s_AlgHandlerState = MFDQ_TRAIN_ACCUM;
#ifdef DEBUG_MFDQ
         LogMfdqCoef(0); // before MFDQ
#endif // DEBUG_MFDQ
      }
      break;

   case MFDQ_TRAIN_ACCUM:

      // calculate each element of covariance matrix and correlation vector
      // and accumulate over multiple frames
      guc_MfdqTrainingState = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgAccumCovarMatrix);
      gt_MfdqConfig.s_AlgHandlerState = MFDQ_TRAIN_ACCUM_WAIT;
#ifdef DEBUG_MFDQ
      LogMfdqInputData(gs_AlgHandlerCount);
#endif // DEBUG_MFDQ
      break;

   case MFDQ_TRAIN_ACCUM_WAIT:

      if (guc_MfdqTrainingState == TRAINING_DONE)
      {
         gs_AlgHandlerCount++;
         s_NumFramesToAccum = 1 << gt_MfdqConfig.s_AlgLog2NumFramesToAccum;
         if (gs_AlgHandlerCount < s_NumFramesToAccum)
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, GetRxDataForMfdqHandler);
            gt_MfdqConfig.s_AlgHandlerState = MFDQ_TRAIN_ACCUM;
         }
         else
         {
            gt_MfdqConfig.s_AlgHandlerState = MFDQ_TRAIN_CALC_MFDQ;
         }
      }
      break;

   case MFDQ_TRAIN_CALC_MFDQ:

      guc_MfdqTrainingState = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgCalcMfdqCoef);
      gt_MfdqConfig.s_AlgHandlerState = MFDQ_TRAIN_LOAD_MFDQ;
#ifdef DEBUG_MFDQ
      LogMfdqAccumData();
#endif // DEBUG_MFDQ
      break;

   case MFDQ_TRAIN_LOAD_MFDQ:

      if (guc_MfdqTrainingState == TRAINING_DONE)
      {

         // write MFDQ coefficients and enable MFDQ
         // unless there are unrecoverable error occurred
         if (gt_MfdqConfig.s_ErrorCode & MFDQ_ABORT_MASK)
         {
            gft_EnableMfdq = 0;
         }
         else
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, WriteMfdqCoef);
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableMfdq);
         }


         // enable RTV read through GetRxTones()
         gft_EnableGetRxTones = TRUE;

         gt_MfdqConfig.s_AlgHandlerState = MFDQ_TRAIN_DONE;
#ifdef DEBUG_MFDQ
         LogMfdqCoef(1); // after MFDQ
#endif // DEBUG_MFDQ
      }
      break;
   }
}
