/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: MfdqSupport.c
*
*   This file contains support functions used in MfdqHandler(), and also shared
*   by other routines.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "dsp_op.h"

#ifdef DEBUG_MFDQ
#include <stdio.h>
#include <math.h>
#include "ieee_flt.h"
int16 gs_LogMfdqTone;
#endif // DEBUG_MFDQ

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void AdjustMfdqExponent(void)
*
*   This function adjusts SFDQ (Si) and feedforward (Ak) coefficients to share
*   the same exponent.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void AdjustMfdqExponent(void)
{
   int16 i, j;
   int16 s_ff_exp, s_sf_exp, s_diff_exp;

   for (i=0; i<gt_MfdqConfig.s_NumMfdqTones; i++)
   {
      j = i << 1;
      s_ff_exp = (int16)gt_MfdqConfig.puca_ff_exp[i];
      s_sf_exp = (int16)gt_MfdqConfig.puca_sf_exp[i];
      if (s_ff_exp != s_sf_exp)
      {
         s_diff_exp = s_sf_exp - s_ff_exp;
         if (s_diff_exp > 0)
         {
            gt_MfdqConfig.psa_ff_coef[j] = round((int32)gt_MfdqConfig.psa_ff_coef[j], s_diff_exp);
            gt_MfdqConfig.psa_ff_coef[j+1] = round((int32)gt_MfdqConfig.psa_ff_coef[j+1], s_diff_exp);
            gt_MfdqConfig.puca_ff_exp[i] = (uint8)s_sf_exp;
         }
         else
         {
            s_diff_exp = -s_diff_exp;
            gt_MfdqConfig.psa_sf_coef[j] = round((int32)gt_MfdqConfig.psa_sf_coef[j], s_diff_exp);
            gt_MfdqConfig.psa_sf_coef[j+1] = round((int32)gt_MfdqConfig.psa_sf_coef[j+1], s_diff_exp);
            gt_MfdqConfig.puca_sf_exp[i] = (uint8)s_ff_exp;
         }
      }
   }
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void SaveSfdqCoef(void)
*
*   This function copies SFDQ coefficients read from HW to MFDQ coefficient
*   buffer for MFDQ calculation. Note that SFDQ coefficients are not part of
*   MFDQ coefficient buffers.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void SaveSfdqCoef(void)
{
   int16 i, j, s_idx, s_idx2;

   for (i=0; i<gt_MfdqConfig.s_NumMfdqTones; i++)
   {
      j = i << 1;
      s_idx = gt_MfdqConfig.psa_MfdqTones[i] - gt_MfdqConfig.s_ReadToneStart;
      s_idx2 = s_idx << 1;
      gt_MfdqConfig.psa_sf_coef[j] = gt_MfdqConfig.psa_SfdqCoef[s_idx2];
      gt_MfdqConfig.psa_sf_coef[j+1] = gt_MfdqConfig.psa_SfdqCoef[s_idx2+1];
      gt_MfdqConfig.puca_sf_exp[i] = gt_MfdqConfig.puca_SfdqExp[s_idx];
   }
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void UpdateSfdqCoef(void)
*
*   This function updates SFDQ coefficient arrays ready to be written to HW.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void UpdateSfdqCoef(void)
{
   int16 i, j, s_idx, s_idx2;

   for (i=0; i<gt_MfdqConfig.s_NumMfdqTones; i++)
   {
      j = i << 1;
      s_idx = gt_MfdqConfig.psa_MfdqTones[i] - gt_MfdqConfig.s_ReadToneStart;
      s_idx2 = s_idx << 1;
      gt_MfdqConfig.psa_SfdqCoef[s_idx2] = gt_MfdqConfig.psa_sf_coef[j];
      gt_MfdqConfig.psa_SfdqCoef[s_idx2+1] = gt_MfdqConfig.psa_sf_coef[j+1];
      gt_MfdqConfig.puca_SfdqExp[s_idx] = gt_MfdqConfig.puca_sf_exp[i];
   }
}

#ifdef DEBUG_MFDQ

void LogMfdqCoef(int16 s_count)
{
   int16 s_idx, s_idx2, i, j;
   FILE *fptr;

   // log tone of interest
   if (s_count == 0)
   {
      fptr = fopen("mfdq_coef_cpe.txt","w");
      gs_LogMfdqTone = gt_MfdqConfig.psa_MfdqTones[0];
      s_idx = gs_LogMfdqTone - gt_MfdqConfig.psa_MfdqTones[0];
      s_idx = gt_MfdqConfig.psa_MfdqTones[s_idx] - gt_MfdqConfig.s_ReadToneStart;
      s_idx2 = s_idx << 1;
      fprintf(fptr, "%d\t%d\t%d\t", gt_MfdqConfig.psa_SfdqCoef[s_idx2], gt_MfdqConfig.psa_SfdqCoef[s_idx2+1], gt_MfdqConfig.puca_SfdqExp[s_idx]);
      fprintf(fptr, "%d\t%d\t%d\t", 0, 0, 0);
      fprintf(fptr, "%d\t%d\t%d\t", 0, 0, 0);
      fprintf(fptr, "\n");
   }
   else
   {
      fptr = fopen("mfdq_coef_cpe.txt","a");
      s_idx = gs_LogMfdqTone - gt_MfdqConfig.psa_MfdqTones[0];
      s_idx2 = s_idx << 1;
      fprintf(fptr, "%d\t%d\t%d\t", gt_MfdqConfig.psa_sf_coef[s_idx2], gt_MfdqConfig.psa_sf_coef[s_idx2+1], gt_MfdqConfig.puca_sf_exp[s_idx]);
      fprintf(fptr, "%d\t%d\t%d\t", gt_MfdqConfig.psa_ff_coef[s_idx2], gt_MfdqConfig.psa_ff_coef[s_idx2+1], gt_MfdqConfig.puca_ff_exp[s_idx]);
      fprintf(fptr, "%d\t%d\t%d\t", gt_MfdqConfig.psa_fb_coef[s_idx2], gt_MfdqConfig.psa_fb_coef[s_idx2+1], gt_MfdqConfig.puca_fb_exp[s_idx]);
      fprintf(fptr, "\n");
   }
   fclose(fptr);

   // log entire MFDQ tones
   if (s_count == 0)
   {
      fptr = fopen("mfdq_coef_all_cpe.txt","w");
      fprintf(fptr, "Before MFDQ Training\n");
      for (i=0; i<gt_MfdqConfig.s_NumMfdqTones; i++)
      {
         s_idx = gt_MfdqConfig.psa_MfdqTones[i] - gt_MfdqConfig.s_ReadToneStart;
         s_idx2 = s_idx << 1;
         fprintf(fptr, "Mfdq %d:, Fbck %d:\t", gt_MfdqConfig.psa_MfdqTones[i], gt_MfdqConfig.psa_FbckTones[i]);
         fprintf(fptr, "%d\t%d\t%d\t", gt_MfdqConfig.psa_SfdqCoef[s_idx2], gt_MfdqConfig.psa_SfdqCoef[s_idx2+1], gt_MfdqConfig.puca_SfdqExp[s_idx]);
         fprintf(fptr, "%d\t%d\t%d\t", 0, 0, gt_MfdqConfig.puca_SfdqExp[s_idx]);
         fprintf(fptr, "%d\t%d\t%d\t", 0, 0, 0);
         fprintf(fptr, "\n");
      }
   }
   else
   {
      fptr = fopen("mfdq_coef_all_cpe.txt","a");
      fprintf(fptr, "\n");
      fprintf(fptr, "After MFDQ Training (Error Code: 0x%04hx)\n", gt_MfdqConfig.s_ErrorCode);
      for (i=0; i<gt_MfdqConfig.s_NumMfdqTones; i++)
      {
         j = i << 1;
         fprintf(fptr, "Mfdq %d:, Fbck %d:\t", gt_MfdqConfig.psa_MfdqTones[i], gt_MfdqConfig.psa_FbckTones[i]);
         fprintf(fptr, "%d\t%d\t%d\t", gt_MfdqConfig.psa_sf_coef[j], gt_MfdqConfig.psa_sf_coef[j+1], gt_MfdqConfig.puca_sf_exp[i]);
         fprintf(fptr, "%d\t%d\t%d\t", gt_MfdqConfig.psa_ff_coef[j], gt_MfdqConfig.psa_ff_coef[j+1], gt_MfdqConfig.puca_ff_exp[i]);
         fprintf(fptr, "%d\t%d\t%d\t", gt_MfdqConfig.psa_fb_coef[j], gt_MfdqConfig.psa_fb_coef[j+1], gt_MfdqConfig.puca_fb_exp[i]);
         fprintf(fptr, "\n");
      }
   }
   fclose(fptr);
}

void LogMfdqInputData(int16 s_count)
{
   int16 s_idx, s_mt_idx, s_ft_idx;
   int16 s_mt_r_idx, s_mt_i_idx, s_ft_r_idx, s_ft_i_idx;
   int16 sa_Yi[2], sa_Yk[2], sa_Di[2], sa_Dk[2];
   int16 sa_Ci[2], s_Ci_exp, sa_Ck[2], s_Ck_exp;
   FILE *fptr;

   if (s_count == 0)
   {
      fptr = fopen("mfdq_input_cpe.txt","w");
   }
   else
   {
      fptr = fopen("mfdq_input_cpe.txt","a");
   }

   s_idx = gs_LogMfdqTone - gt_MfdqConfig.psa_MfdqTones[0];

   s_mt_idx = gt_MfdqConfig.psa_MfdqTones[s_idx] - gt_MfdqConfig.s_ReadToneStart;
   s_ft_idx = gt_MfdqConfig.psa_FbckTones[s_idx] - gt_MfdqConfig.s_ReadToneStart;

   s_mt_r_idx = s_mt_idx << 1;
   s_mt_i_idx = s_mt_r_idx + 1;
   s_ft_r_idx = s_ft_idx << 1;
   s_ft_i_idx = s_ft_r_idx + 1;

   sa_Yi[0] = gt_MfdqConfig.psa_FdqOutput[s_mt_r_idx]; // Yi real
   sa_Yi[1] = gt_MfdqConfig.psa_FdqOutput[s_mt_i_idx]; // Yi imag
   sa_Di[0] = gt_MfdqConfig.psa_DecOutput[s_mt_r_idx]; // Di real
   sa_Di[1] = gt_MfdqConfig.psa_DecOutput[s_mt_i_idx]; // Di imag
   sa_Yk[0] = gt_MfdqConfig.psa_FdqOutput[s_ft_r_idx]; // Yk real
   sa_Yk[1] = gt_MfdqConfig.psa_FdqOutput[s_ft_i_idx]; // Yk imag
   sa_Dk[0] = gt_MfdqConfig.psa_DecOutput[s_ft_r_idx]; // Dk real
   sa_Dk[1] = gt_MfdqConfig.psa_DecOutput[s_ft_i_idx]; // Dk imag

   sa_Ci[0] = gt_MfdqConfig.psa_SfdqCoef[s_mt_r_idx]; // Ci real
   sa_Ci[1] = gt_MfdqConfig.psa_SfdqCoef[s_mt_i_idx]; // Ci imag
   s_Ci_exp = gt_MfdqConfig.puca_SfdqExp[s_mt_idx]; // Ci exponent
   sa_Ck[0] = gt_MfdqConfig.psa_SfdqCoef[s_ft_r_idx]; // Ck real
   sa_Ck[1] = gt_MfdqConfig.psa_SfdqCoef[s_ft_i_idx]; // Ck imag
   s_Ck_exp = gt_MfdqConfig.puca_SfdqExp[s_ft_idx]; // Ck exponent

   fprintf(fptr, "%d\t%d\t", sa_Yi[0], sa_Yi[1]);
   fprintf(fptr, "%d\t%d\t", sa_Di[0], sa_Di[1]);
   fprintf(fptr, "%d\t%d\t", sa_Yk[0], sa_Yk[1]);
   fprintf(fptr, "%d\t%d\t", sa_Dk[0], sa_Dk[1]);
   fprintf(fptr, "%d\t%d\t%d\t", sa_Ci[0], sa_Ci[1], s_Ci_exp);
   fprintf(fptr, "%d\t%d\t%d\t", sa_Ck[0], sa_Ck[1], s_Ck_exp);
   fprintf(fptr, "\n");

   fclose(fptr);
}

void LogMfdqAccumData(void)
{
   int16 i, s_idx;
   FILE *fptr;

   s_idx = gs_LogMfdqTone - gt_MfdqConfig.psa_MfdqTones[0];

   fptr = fopen("mfdq_accum_cpe.txt","w");

   for (i=0; i<MFDQ_COV_MATRIX_SIZE; i++)
   {
      fprintf(fptr, "%ld\n", gt_MfdqConfig.pla_CovMatrix[s_idx*MFDQ_COV_MATRIX_SIZE+i]);
   }

   for (i=0; i<MFDQ_COR_VECTOR_SIZE; i++)
   {
      fprintf(fptr, "%ld\n", gt_MfdqConfig.pla_CorVector[s_idx*MFDQ_COR_VECTOR_SIZE+i]);
   }

   fclose(fptr);
}

double Float32toDouble(FloatG f_in)
{
   double d_out;
#ifdef FLOAT_IN_SW
   int32 l_temp;
   int16 s_exp;

   if ((f_in == 0x00000000) || (f_in == 0x80000000))
   {
      return (double)0;
   }

   l_temp = f_in & MASK23LOW;
   l_temp += HIDDEN_BIT;

   s_exp = f_in >> EXP32SHIFT_LOW;
   s_exp &= MASK8LOW;
   s_exp = EXPONENT_BIAS - s_exp + EXP32SHIFT_LOW;

   if (f_in & NEG32)
   {
      l_temp = -l_temp;
   }

   if (s_exp > 0)
   {
      d_out = (double)l_temp / pow(2,s_exp);
   }
   else
   {
      d_out = (double)l_temp * pow(2,-s_exp);
   }
#else
   d_out = (double)f_in;
#endif
   return (d_out);
}

#endif // DEBUG_MFDQ
