/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   PsdAnalysis.c
 *
 *   Background functions for computing PSD.
 *
 *------------------------------------------------------------------------
 */
// ***********************************************************************************************************
// PsdAnalysis.c
//
// History
// 11/08/2014 Fuss: calibration of BJ Hybrid and oPOTS config
//            Grep for XDSLRTFW-1898
// 11/08/2014 Fuss: VDSL DS1: not corrected DS Hlog in ADSL2+ when strong DPBO is applied against BRCM CO
//            Grep for XDSLRTFW-1926
// 27/08/2014 Fuss: No-Connect when BT-bit is set and CO indicate US0 only
//            Grep for XDSLRTFW-1975
// 04/12/2014 Fuss: VDSL DS1: not corrected DS Hlog when strong DPBO is applied against Huawei BRCM CO- R7
//            Grep for XDSLRTFW-2082
// 2/2/2015 Palaksha: VDSL DS Hlog is using always sub-sampling of 8(not according to the standard)
//                                   Solution is to have sub-sampling of VDSL HLOG to be based subcarrier group size "G"
//                  G = pow2 (T/512),   pow2(x)  takes  the  nearest  power  of  2  greater than or equal to
//                                       x  and  T  is  the highest  sub-carrier  index  of  the  transmitter  SUPPORTEDCARRIERS set
//         Grep for XDSLRTFW-2135
//
// 14/09/2017 Hanyu: Merged IOP fixes against EVLT-F/CNXT in A8D profile
//   1. IOP adjustment to reduce estimated KL0 from loop length ~2800ft to ~3800ft to connect to showtime.
//   2. Switched to US0 band if KL0 is greater than 25.8dB (~3700ft) to fix the no sync issue.
//      Grep for XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_NoSync3200ft
//
//   3. Added 0.6dB to final KL0 to reduce UPBO and boost US power by ~0.5dB to get comparable US data rate with BRCM CPE.
//      Grep for XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_USdatarate
//
// 14/09/2017 Hanyu: Merged Boosted US0 & US1 Tx power to get high US data rate.
//      Grep for XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_USdatarate
//
// 27/11/2017 Stefan: Upstream performance dip on short loops (KPN)
//            - kl0 measurments with calibrated setup showed that our looplength estimation is
//              resulting in too high kl0 estimations
//            - add BRCM-like PSD boost on short loops (for UPBO and non-UPBO configurations)
//      Grep for XDSLRTFW-3212 : Upstream performance dip on short loops
//
// 02/03/2018 Sriram Shastry : VRX518 VDSL2 Wrong values for LATN & SATN
// The LATN in Band 3 LATN[2] shows sometimes the reseved value 127.1 & SATN in Band 3 SATN[2] show sometimes a much too high valuein short loops
// This is  due to overflow in calculating the  LATN and  SATN.
// All Psds are normalized to "57dB"
// Linear interpretation of 57dB is: round(10^(57/10)) = 501187
// Highest supported value is 2^31
// In 17MHz we use max 4096 tones. So the highest accumulated value could be: 4096 * 501187 = 2.05e9, which is a little bit lower than 2^31
// In 35Mhz we use max 8196 tones. So the highest accumulated value could be: 8192 * 501187 = 4.11e9, which is a little bit higher than 2^31
// Solution:
// Psds are normalized to "57dB".Power log2(round(10^(54/10)) * 8192) = 30.9384.
// Search for  XDSLRTFW-3673
//
// 19/01/2018 Hanyu Liu: Added code for US data rate improvement against EVLT-K and Vinax CO's with non-35B profiles at CTL/AT&T
//            Excluded XDSLRTFW-1181/1182 for all CO except IFX in non-vectoring mode to improve US data rate at short loops and reduce DS run to run variation.
//            Search for  XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_K_BRCM_USdatarate
//                        XDSLRTFW-735 IOP_A_US_VDSL2_VINAX_USdatarate
//
// 08/06/2018 Hanyu Liu: XDSLRTFW-3833 Reuse XDSLRTFW-3212 code structure of TEST_TX_PSD_CONTROL to fine tune PSD boost for the following:
//            1. Applied TEST_TX_PSD_CONTROL_CTL_MODE (1dBm/Hz boost US1/US2) on all loops against all DSLAMs/COs in all VDSL2 profiles for CTL or AT_T CMV.
//            2. US1 PSD boost additional 0.5dBm/Hz on 3kft and longer loops to improved US data rates against all DSLAMs/COs in all VDSL2 profiles for CTL or AT_T CMV.
//            Seearch for XDSLRTFW-3833
//
//14/12/2018 Sriram Shastry :XDSLRTFW-4052 : Low upstream data rates in 30a profile
// Improvement for Kl0 alogorithm estimation for  30a profile
// - Control option to use AELEM for reporting KL0
// - Control option to set  Kl0 in RMSG1
// - Control option to set AELEM method instead of  KL0 method
// - Control option to Enable/disble psdpreprocessing (inter polation) 
// - Initialize AELEM structure (gt_AELEM_UPBOInfo) 
//  Grep for XDSLRTFW-4052
// ************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "noiseacc.h"
#include "ConvertToDB.h"
#include "psd_b.h"
#include "dsp_op.h"
#include "acc40.h"
#include <stdlib.h>
#include "TxPSDControl.h"
#include "sys_const.h"
#include "vdsl_const.h"
#include "decimalgain.h"
#include "PGAHandler.h"
#include "SharedFuncs.h"
#include "GetTonePsd.h"
#include "cmv.h"
#include "ghs.h"
#include "afe.h"
#include "vdsl_xception.h"
#include "IRI_Iof.h"
#include <string.h>

void ComputeHlog(void);
void PsdPreProc_kl0_bridgetaps(int16 *psa_Psd,int16 j_start, int16 s_band_indx);
// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (START)
void SearchBestBinRFIBand(int16 *psa_Psd, int16 *start_bin, int16 *end_bin, int16 *ext_bin, int16 *ext_flag,
                          int16 s_rfiband_indx, int16 s_band_idx, int16 window_len);
void InterpolateRFIBands(int16 *psa_Psd, int16 startTone, int16 endTone, int16 extTone, int16 extFlag);
void PreProcRFIBands(int16 *psa_Psd);
void ComputeKl0DS1(void);
void ComputeELE(void);
// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (END)

//extern int16 gs_StreamComp[4096];

// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START_END)
void GenerateSqrtF();

//Disable Spl code 30a Comp table handling
FlagT gft_Ena_30MHzCompTableModify = 0; //XDSLRTFW-4052 XDSLRTFW-4064 

/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: Background function to analyze PSD
 *
 *  Prototype: void BgPsdAnalysis(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *------------------------------------------------------------------------
 *^^^
 */
void BgPsdAnalysis(void)
{
   PsdAnalysis();
   // XDSLRTFW-3344 (Start)
   if (gft_Swap_HLog_QLN_Offchip == TRUE)
   {
      DMAtoSDRAM_PerTone(HLOG_PERTONE);
   }
   // XDSLRTFW-3344 (End)
   guc_PsdCalcState = TRAINING_DONE;
}

/********************************************************************************************
;       Subroutine Name: PsdAnalysis
;
;       Description:
;
;               Used to calculate the signal and line attenuation parameters based on
;               TX and RX Psds.
;               Also used CPE side to estimate the electrical line length, kl0, based on the RX PSD.
:               Makes use a LS fit of the captured PSD, to the attenuation equation kl0*sqrt(f_MHz).
;
;       Prototype:
;               void PsdAnalysis(void)
;
;       Input Arguments:
;
;       Output Arguments:
;
;       Return Value:
;               none
;
;       Global Variables:
;               none
;
;****************************************************************************/

#define US0_CORRECTION  (30)   // Note: this value is tuned based on HYB_AD1_138_17
#define HLOG_FLAG_ON     (1)

void PsdAnalysis(void)
{
   /* Input and output arguments */
   int16 s_RxMaxNomPsd;
   /* Local Variables */
   int16 i, s_band_indx;
   int32 l_temp1;
   int32 l_near_tone_pow=0;
   int16 s_pass;
   int32 l_far_tone_pow;
   // +1 because we use this same array to compute aggregate LATN/SATN across all the bands
   int16 sa_max_psd_far_satn[MAX_NUM_RX_BANDS+1], sa_psd_far_satn_norm[MAX_NUM_RX_BANDS+1];
   int16 sa_max_psd_near_satn[MAX_NUM_RX_BANDS+1], sa_psd_near_satn_norm[MAX_NUM_RX_BANDS+1];
   int32 la_acc_psd_far_satn[MAX_NUM_RX_BANDS+1],la_acc_psd_near_satn[MAX_NUM_RX_BANDS+1];
   int32 la_max_ch_gain_tone_latn[MAX_NUM_RX_BANDS+1], la_acc_ch_gain_tone_latn[MAX_NUM_RX_BANDS+1], la_ch_gain_tone_latn_norm[MAX_NUM_RX_BANDS+1];
   int32 l_ch_gain_tone;
   int32 sa_tone_count_latn[MAX_NUM_RX_BANDS+1];
   int32 sa_tone_count_satn[MAX_NUM_RX_BANDS+1];
   int16 s_temp1=0;
   int16 j_start;
   int16 s_psd, *psa_Psd;

   // XDSLRTFW-3935 Wrong HLOG reporting in DPBO range
   // Read the FDQ coefficients
   ReadFdqMant(&gt_ChDisc_Fdq.sa_FdqMantissa[0], 0, NUM_OF_TONES_FDQ_BASED_HLOG);
   ReadFdqExp(&gt_ChDisc_Fdq.uca_FdqExponent[0], 0, NUM_OF_TONES_FDQ_BASED_HLOG);

   //---------------------------------------------------
   // initialize input parameter structure
   //---------------------------------------------------
   s_RxMaxNomPsd = gt_PwrConfigParam.s_Dn_MaxNomPSD;
   psa_Psd = gpsa_MeasuredSnrBuf;

   //Compute the total RX path gain
   // Note: gt_DfeAfeGainSettings.s_Rx_FFT_Gain_Rms_dB should not be considered for PSD(f) to Line side transformation.
   //       The variable is only for PGAHandler(), i.e. Calculation of RMS frequency domain for PGA.
   gl_RxPathTotalGain = (int32)gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB +
                       (int32)gs_PGA_set +
                       (int32)gs_HybridGain +
                       (int32)gt_DfeAfeGainSettings.s_Rx_Total_TdqToAfeInterface_Gain_dB +
                       (int32)gt_DfeAfeGainSettings.s_Rx_FFT_Gain_dBPerHz +
                       gl_afe_fixed_gain +
                       (int32)gt_DfeAfeGainSettings.s_RxPathTrafo_Gain_dB +
                       (int32)gt_DfeAfeGainSettings.s_AfeLevelShiftDfe_Gain_dB +
                       (int32)gt_PgaGainCorrectionDslPath.s_corr_gain_rxa_dB_out +
                       (int32)gs_QlnHlogCorrection;


   // Correct the RX PSD by removing the front end filters
   // XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (START)
   // Undo Shaping info, So that the RFI Interpolation can be good
   // XDSLRTFW-976 : BUG_DS_ALL_ALL_QLN
   // Enable Hlog Flag
   ApplyRxPathPsdCorrection(psa_Psd, psa_Psd, HLOG_FLAG_ON);
   // XDSLRTFW-976 : BUG_DS_ALL_ALL_QLN


   // Pre Proc RFI Bands
   gs_RFIBand = 0;
   if(gs_NumOfRFIBands > 0)
   {
      // XDSLRTFW-1499
      // PreProcRFIBands(psa_Psd);
      PreProcRFIBands(gsa_PsdAnalysis_out);
   }

   //Call Detecting BT Cases : interpolate BT Cases
   gs_Kl0PreProcDone = 0;
   for (s_band_indx = 0; s_band_indx < gs_NumOfRxBands; s_band_indx++)
   {
      j_start = gsa_RxBandLeftChannel[s_band_indx]+(1 >> gs_frame_rate_is_8khz);
      PsdPreProc_kl0_bridgetaps(psa_Psd,j_start,s_band_indx);
   }

   /* ***********************************************************************************************************   */
   /* Evaluate Signal attenuation per band (SATN-pb) and Line attenuation per band (LATN-pb), which are         */
   /* ratios of received power to transmit power, per band.                                          */
   /* Will make use of recieved Rx PSD decriptor tables in messages to get the TX power.  To get RX power, will   */
   /* make use of the measured RX PSD in gpsa_MeasuredSnrBuf, with normalization to account for PGA setting,      */
   /* rxvargain setting, fft_gain, and subchannel bandwidth (frame rate).                                 */
   /* ************************************************************************************************************   */
   if (gs_get_satn_latn == 1)
   {
      //------------------------------------------------------------------------------------------
      // We interpolate TX PSD breakpoints.  Each tone is put into a band, and the PSD at that
      // tone is interpolated from the breakpoints.  We make one pass to find the max psd per band
      // then a second to accumulate the linear-psd per band, normalized by max psd per band.
      // The normalization forces max psd into the 32b power acc to be 57 dB
      // (as in the rx power calculation above). Finish with denormalization and conversion to
      // total power per band gla_far_signal_power[], in dBm, 8.8 format.
      // These far-end tx power calculations are based on pt_PSDDesc.
      // We make corresponding calculations for the near-end RX power based on gpsa_MeasuredSnrBuf,
      // though the interpolation part is not necessary and is not performed for gpsa_MeasuredSnrBuf.
      // Ratios of the TX/RX power per tone are also calculated for use in generating
      // the Line attenuation (LATn) parameter.
      //------------------------------------------------------------------------------------------

      // Initialize arrays.
      for (i=0; i<(MAX_NUM_RX_BANDS+1); i++)
      {
         sa_max_psd_far_satn[i] = (-128) << 8;
         la_acc_psd_far_satn[i] = 0;
         sa_psd_far_satn_norm[i] = 0;

         sa_max_psd_near_satn[i] = (-128) << 8;
         la_acc_psd_near_satn[i] = 0;
         sa_psd_near_satn_norm[i] = 0;

         la_max_ch_gain_tone_latn[i] = (-128) << 24;
         la_acc_ch_gain_tone_latn[i] = 0;
         la_ch_gain_tone_latn_norm[i] = 0;

         sa_tone_count_latn[i] = 0;
         sa_tone_count_satn[i] = 0;
      }

      // pass 0 is to find max psd per band,
      // pass 1 is to accumulate power after normalization with regard to max psd.
      for( s_pass=0; s_pass<2; s_pass++)
      {
         for (s_band_indx = 0; s_band_indx < gs_NumOfRxBands; s_band_indx++)
         {
            for (i = gsa_RxBandLeftChannel[s_band_indx]; i <= gsa_RxBandRightChannel[s_band_indx]; i++)
            {
               // XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (START)
               // We consider in-band active RX tones only.
               if (IS_TONEFLAGSET(guca_RxSupportedToneSet_Aelem, i))
               {
                  // Near-end tone power: dB, format 8.8
                  // XDSLRTFW-1499
                  l_near_tone_pow = gsa_PsdAnalysis_out[i];

                  // Get the psd level wrt MaxNomPsd
                  // Get absolute psd level
                  s_psd = -s_RxMaxNomPsd;
                  // Far-end tone power: dBm/Hz, format 8.8
                  l_far_tone_pow = (int16) ((s_psd<<8)/10);

                  // Channel gain: dB, format 24.8
                  l_ch_gain_tone = (l_near_tone_pow - l_far_tone_pow);

                  // Channel gain: dB, format 24.8
                  if(s_pass == 1)
                  {
                     gsa_PsdAnalysis_out[i] = l_ch_gain_tone - gl_RxPathTotalGain;

                  }

                  //Temp- Convert to format 9.7
                  l_far_tone_pow = (l_far_tone_pow>>1);

                  // If first pass, update max tx and rx psd in this band, max channel gain.
                  if (s_pass==0)
                  {
                     sa_tone_count_latn[gs_NumOfRxBands]++;
                     sa_tone_count_latn[s_band_indx]++;

                     // Max far-end power, dBm/Hz, 9.7 format
                     if (l_far_tone_pow > sa_max_psd_far_satn[s_band_indx])
                     {
                        sa_max_psd_far_satn[s_band_indx] = l_far_tone_pow;
                        sa_psd_far_satn_norm[s_band_indx] = sa_max_psd_far_satn[s_band_indx] - (int16) (NORMALIZATION_VAL_LATN_SATN<<7);  // XDSLRTFW-3673 (Start_End)
                        if (l_far_tone_pow > sa_max_psd_far_satn[gs_NumOfRxBands])
                        {
                           sa_max_psd_far_satn[gs_NumOfRxBands] = l_far_tone_pow;
                           sa_psd_far_satn_norm[gs_NumOfRxBands] = sa_max_psd_far_satn[gs_NumOfRxBands] - (int16) (NORMALIZATION_VAL_LATN_SATN<<7); // XDSLRTFW-3673 (Start_End)
                        }
                     }
                     // Max near-end power, dB, 8.8 format
                     if (l_near_tone_pow > sa_max_psd_near_satn[s_band_indx])
                     {
                        sa_max_psd_near_satn[s_band_indx] = l_near_tone_pow;
                        sa_psd_near_satn_norm[s_band_indx] = sa_max_psd_near_satn[s_band_indx] - (int16) (NORMALIZATION_VAL_LATN_SATN<<8); // XDSLRTFW-3673 (Start_End)
                        if (l_near_tone_pow > sa_max_psd_near_satn[gs_NumOfRxBands])
                        {
                           sa_max_psd_near_satn[gs_NumOfRxBands] = l_near_tone_pow;
                           sa_psd_near_satn_norm[gs_NumOfRxBands] = sa_max_psd_near_satn[gs_NumOfRxBands] - (int16) (NORMALIZATION_VAL_LATN_SATN<<8);  // XDSLRTFW-3673 (Start_End)
                        }
                     }
                     // Max channel gain, dB, 24.8 format
                     if (l_ch_gain_tone > la_max_ch_gain_tone_latn[s_band_indx])
                     {
                        la_max_ch_gain_tone_latn[s_band_indx] = l_ch_gain_tone;
                        la_ch_gain_tone_latn_norm[s_band_indx] = la_max_ch_gain_tone_latn[s_band_indx] - (int32) (NORMALIZATION_VAL_LATN_SATN<<8);  // XDSLRTFW-3673 (Start_End)
                        if (l_ch_gain_tone > la_max_ch_gain_tone_latn[gs_NumOfRxBands])
                        {
                           la_max_ch_gain_tone_latn[gs_NumOfRxBands] = l_ch_gain_tone;
                           la_ch_gain_tone_latn_norm[gs_NumOfRxBands] = la_max_ch_gain_tone_latn[gs_NumOfRxBands] - (int32) (NORMALIZATION_VAL_LATN_SATN<<8);   // XDSLRTFW-3673 (Start_End)
                        }
                     }
                  }
                  // If second pass, normalize psd according to max psd for this band,
                  // and update accumulation of power.
                  else
                  {

                     if ((gft_UseNewSATNCalc == FALSE) ||
                           ((gft_UseNewSATNCalc == TRUE) && IS_TONEFLAGSET(guca_RxSupportedToneSet_temp, i)))
                     {
                        sa_tone_count_satn[gs_NumOfRxBands]++;
                        sa_tone_count_satn[s_band_indx]++;

                        /////////////////////////////////////////
                        // Calculations for Far-end (TX) power
                        /////////////////////////////////////////
                        // normalization to peak of 57 dB (9.7 format) before accumulating
                        la_acc_psd_far_satn[s_band_indx] += accum_power((l_far_tone_pow - sa_psd_far_satn_norm[s_band_indx]), 7);
                        la_acc_psd_far_satn[gs_NumOfRxBands] += accum_power((l_far_tone_pow - sa_psd_far_satn_norm[gs_NumOfRxBands]), 7);

                        /////////////////////////////////////////
                        // Calculations for Near-end (RX) power
                        /////////////////////////////////////////
                        // normalization to peak of 57 dB (8.8 format) before accumulating
                        la_acc_psd_near_satn[s_band_indx] += accum_power((l_near_tone_pow - sa_psd_near_satn_norm[s_band_indx]), 8);
                        la_acc_psd_near_satn[gs_NumOfRxBands] += accum_power((l_near_tone_pow - sa_psd_near_satn_norm[gs_NumOfRxBands]), 8);
                     }

                     /////////////////////////////////////////
                     // Calculations for tone attenuation (LATN)
                     /////////////////////////////////////////
                     // normalization to peak of 57 dB (24.8 format) before accumulating
                     la_acc_ch_gain_tone_latn[s_band_indx] += accum_power((l_ch_gain_tone - la_ch_gain_tone_latn_norm[s_band_indx]), 8);
                     la_acc_ch_gain_tone_latn[gs_NumOfRxBands] += accum_power((l_ch_gain_tone - la_ch_gain_tone_latn_norm[gs_NumOfRxBands]), 8);


                  } // if (s_pass==0) ... else ...
               }   // if (IS_TONEFLAGSET(guca_RxSupportedToneSet, i))
               else
                  // Channel gain: dB, format 24.8
               {
                  gsa_PsdAnalysis_out[i] = OUT_OF_RANGE_HLOG;
               }
// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (END)
            }   // for (i...)
         }   // for (s_band_indx...)
      }//   for( s_pass=0; s_pass<2; s_pass)

      //------------------------------------------------------------------------------------------
      // Convert the accumulated linear-psds into powers (dBm) per band, and accumulated
      // linear-channel gains per band to dB. gsa_satn_pb[] and gsa_latn_pb[] are set
      // to corresponding values.
      //------------------------------------------------------------------------------------------
      for (s_band_indx=0; s_band_indx<(gs_NumOfRxBands+1); s_band_indx++)
      {
         gla_far_signal_power[s_band_indx] = (-128)<<8;
         gla_near_signal_power[s_band_indx] = (-128)<<8;
         gsa_satn_pb[s_band_indx] = OUT_OF_RANGE_SATN; //0<<8;
         gla_latn_pb[s_band_indx] = OUT_OF_RANGE_LATN; //0<<8;

         if (sa_tone_count_satn[s_band_indx]!=0)
         {
            /////////////////////////////////////////
            // Calculations for Far-end (TX) power
            /////////////////////////////////////////

            //int16 ConvertToDB(int32 l_xin) takes Positive 32.0 input, produces 8.8 output
            gla_far_signal_power[s_band_indx] = ConvertToDB(la_acc_psd_far_satn[s_band_indx]);
            //Recall sa_psd_far_satn_norm is in 9.7 format, convert to 8.8.
            gla_far_signal_power[s_band_indx] += (sa_psd_far_satn_norm[s_band_indx]<<1);
            if (gs_frame_rate_is_8khz == 1)
            {
               gla_far_signal_power[s_band_indx] += VAL_binw8_in_dBHZ_8p8;
            }
            else
            {
               gla_far_signal_power[s_band_indx] += VAL_binw4_in_dBHZ_8p8;
            }

            /////////////////////////////////////////
            // Calculations for Near-end (RX) power
            /////////////////////////////////////////

            //int16 ConvertToDB(int32 l_xin) takes Positive 32.0 input, produces 8.8 output
            gla_near_signal_power[s_band_indx] = ConvertToDB(la_acc_psd_near_satn[s_band_indx]);
            gla_near_signal_power[s_band_indx] += sa_psd_near_satn_norm[s_band_indx];
            gla_near_signal_power[s_band_indx] -= gl_RxPathTotalGain;

            // Total power per band is left in gla_near_signal_power[], dBm, 8.8 format.
            if (gs_frame_rate_is_8khz == 1)
            {
               gla_near_signal_power[s_band_indx] += VAL_binw8_in_dBHZ_8p8;
            }
            else
            {
               gla_near_signal_power[s_band_indx] += VAL_binw4_in_dBHZ_8p8;
            }

            /////////////////////////////////////////
            // Signal attenuation per band is difference in dBm between far-end tx
            // and near-end rx powers, dBm, format 8.8.
            /////////////////////////////////////////

            gsa_satn_pb[s_band_indx] = gla_far_signal_power[s_band_indx] - gla_near_signal_power[s_band_indx];

            gsa_satn_pb[s_band_indx] -= gsa_IOP_LATN_Kl0[s_band_indx+1];

            /////////////////////////////////////////
            // Convert to the 10-bit unsigned standard-specified representation,
            // having 0.1 dB resolution, and range 0 - 102.2 dB.
            // Positive out of range values are converted to 102.3 dB (1023)
            // Negative values are set to 0.1 dB
            /////////////////////////////////////////
            l_temp1 = (int16) (((int32)10*gsa_satn_pb[s_band_indx])>>8);

            if (l_temp1 <= 0)
            {
               l_temp1 = 1;
            }
            if (l_temp1 > 1022)
            {
               l_temp1 = OUT_OF_RANGE_SATN;
            }

         }//   if (sa_tone_count_satn[sa_band_indx]!=0)
         else
         {
            l_temp1 = OUT_OF_RANGE_SATN;
         }

         if(s_band_indx == gs_NumOfRxBands)
         {
            gt_LineStatusDS.us_SignalAttenuation = l_temp1;
         }
         else
         {
            gt_AttenSnrMPerRxBand.t_AttenSnrM[s_band_indx].s_SATN = l_temp1;
         }

         if (sa_tone_count_latn[s_band_indx]!=0)
         {
            /////////////////////////////////////////
            // Calculations for Channel attenuation (LATN)
            /////////////////////////////////////////

            // Convert to an average. Is in dB, 24.8 format
            la_acc_ch_gain_tone_latn[s_band_indx] = la_acc_ch_gain_tone_latn[s_band_indx]
                                                    / sa_tone_count_latn[s_band_indx];

            // We first calculate Channel gain in gla_latn_pb[],
            // then convert to attenuation at end by negation.
            //int16 ConvertToDB(int32 l_xin) takes Positive 32.0 input, produces 8.8 output
            gla_latn_pb[s_band_indx] = ConvertToDB(la_acc_ch_gain_tone_latn[s_band_indx]);
            //Norm is in 24.8 format
            gla_latn_pb[s_band_indx] += la_ch_gain_tone_latn_norm[s_band_indx];
            // Now subtract the scaling for the TX power, and add the scaling for the RX power.
            // With cancellation of the VAL_binw8/4_in_dBHZ_8p8 bandwidth terms, this amounts
            // to just adding the RX power scalings.

            gla_latn_pb[s_band_indx] -= gl_RxPathTotalGain;

            // Convert from gain to attenuation.
            gla_latn_pb[s_band_indx] = -gla_latn_pb[s_band_indx];

            gla_latn_pb[s_band_indx] -= gsa_IOP_LATN_Kl0[s_band_indx+1];

            /////////////////////////////////////////
            // Convert to the 10-bit unsigned standard-specified representation,
            // having 0.1 dB resolution, and range 0 - 102.2 dB.
            // Positive out of range values are converted to 102.3 dB (1023)
            // Negative values are set to 0.1 dB (1)
            /////////////////////////////////////////
            l_temp1 = (int16) (((int32)10*gla_latn_pb[s_band_indx])>>8);

            if (l_temp1 <= 0)
            {
               l_temp1 = 1;
            }
            if (l_temp1 > 1022)
            {
               l_temp1 = OUT_OF_RANGE_LATN;
            }

         }//   if (sa_tone_count_latn[sa_band_indx]!=0)
         else
         {
            l_temp1 = OUT_OF_RANGE_LATN;
         }

         if(s_band_indx == gs_NumOfRxBands)
         {
            gt_LineStatusDS.us_LoopAttenuation = l_temp1;
         }
         else
         {
            gt_AttenSnrMPerRxBand.t_AttenSnrM[s_band_indx].s_LATN = l_temp1;
         }

      }// for (s_band_indx=0; s_band_indx<gs_NumOfRxBands; s_band_indx++)

   } //End of if (gs_get_satn_latn==1)

   {
      // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)
      //Kl0 Single Band Compute
      ComputeKl0DS1();
      // I'm reluctant to encapsulate this in ELE support, because we will use up the available symbols
      // -> symbol placeholder in case no ELE is requested
      //This function call Single Band KL0 (Old Method) Calculation also
      // XDSLRTFW-926 : ALL_ALL_VDSL2_ALL_MIPS_DELT
      // Disable AELEM computation if not enabled while in Loop Diag
      if ( (gul_OperationModeStatus_VDSL2 & (V2_ELE_METHOD1 << 24)) ||
            (!(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)) )
      {
         ComputeELE();
      }
      // XDSLRTFW-926 : ALL_ALL_VDSL2_ALL_MIPS_DELT
      // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)
      //XDSLRTFW-2379 (start)
      // If we cannot estimate KL0 from AELEM and number of tones available
      // are less than or eq 32 with  "gs_GuardBinKl0 as 50 we may not have calculated KL0 at all",
      //then reduce gs_GuardBinKl0.
      if ((gt_Kl0ElectricalLength.s_kl0_estimate == KL0_MAX_VALUE)
            &&(gs_KL0_tone_count <= NUM_CHANNELS_KL0_ESTIMATION)
         )
      {
         gs_GuardBinKl0 = 1;
         ComputeKl0DS1();
      }
      //XDSLRTFW-2379 (end)
   }
   // Compute Hlog value for VDSL2 mode

   //This Function now calculates the PerBin Hlog also
   ComputeHlog();

}//PsdAnalysis

// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (START)
#define BAND_DS1 (0)
void ComputeKl0DS1(void)
{
   int32 l_temp1, l_near_tone_pow;
   int16 s_temp1,s_temp1_exp,j;
   int16 s_val_invsqrt_binw_12p4;
   int16 j_start, j_end, s_tone_count, s_denom_mant, s_denom_exp, s_numer_exp;
   int16 s_acc_psd_mant, s_acc_ti_mant, s_acc_sqrt_ti_mant, s_acc_psd_sqrt_ti_mant, s_numer_mant, s_val_invsqrt_binw_mant;
   int16 s_acc_psd_exp, s_acc_ti_exp, s_acc_sqrt_ti_exp, s_acc_psd_sqrt_ti_exp, s_val_invsqrt_binw_exp;
   int32 l_acc_psd;
   int32 l_numer, l_denom, l_acc_ti, l_acc_sqrt_ti, l_acc_psd_sqrt_ti;
   int32 l_kl0_estimate;
   int16 s_BpIdx;
   uint16 us_platform;
   //Reuse XDSLRTFW-3212 code to fine tune PSD boost
   int16  s_PSDboost_US0;
   int16  s_PSDboost_US1;
   int16  s_PSDboost_US2;

   /**************************************************************************************************************
      For CPE, estimate the loop electrical length, kl0, which is used later if UPBO is enabled.
      Line attenuation is modeled there as kl0*sqrt(f), where f is in MHz.
      The LS estimate for kl0 is the ratio

      invsqrt(binw) * ( sum(p)*sum(sqrt(ti)) - N*sum(p*sqrt(ti)) )
      -----------------------------------------------------------
                  ( N*sum(ti) - sum(sqrt(ti)).^2 )

      where p is psd in dB, ti is the vector of tone indices, N is the number of tones used in the estimate,
      and binw is the tone-spacing, in MHz.
   ***************************************************************************************************************/
   if (gs_get_estimate_kl0 == 1)
   {
      s_BpIdx = 0;
      s_tone_count = 0;
      l_acc_psd = 0;
      l_acc_ti = 0;
      l_acc_sqrt_ti = 0;
      l_acc_psd_sqrt_ti = 0;


      j_start = gsa_RxBandLeftChannel[BAND_DS1] + (gs_GuardBinKl0 >> gs_frame_rate_is_8khz);
      j_end = gsa_RxBandRightChannel[BAND_DS1] - (gs_GuardBinKl0 >> gs_frame_rate_is_8khz);
      //XDSLRTFW-1388 (End)
      //XDSLRTFW-1448
      //Fix for Carrier Mask No Connect
      //While the Start and End of DS1 is 33 to 150, due to Guard Band Logic
      //The number of tones for KL0 processing got below 50 bins
      if( (j_end-j_start) < (gs_GuardBinKl0 >> gs_frame_rate_is_8khz))
      {
         j_start = gsa_RxBandLeftChannel[BAND_DS1];
         j_end = gsa_RxBandRightChannel[BAND_DS1];
      }
      //XDSLRTFW-1448

      ///////////////////////////////////////////////////////////////////
      // Evaluate the accs and maccs appearing in the individual terms
      // of the numerator and denominator in the expression for kl0
      //////////////////////////////////////////////////////////////////
      l_acc_psd = 0;
      // Perform kl0 estimate only on the lowest band, use tones only above j_start
      // Note: if the number of bands used changes, may also need to change function
      //       PsdPreProc_kl0_bridgetaps
      for (j = j_start; j <= j_end; j++)
      {
         // Use tones only with sufficient SNR and all pilot tones which might have been excluded from supported set
         if (IS_TONEFLAGSET(guca_RxSupportedToneSet_temp,j))
         {
            // <= 2^12
            s_tone_count++;

            //l_near_tone_pow = (gsa_ELE_Tmp[j] << 8)/10;
            l_near_tone_pow = gsa_PsdAnalysis_out[j];
            //l_near_tone_pow -= gl_RxPathTotalGain;

            // format 24.8, <=2^7*2^8*2^12
            l_acc_psd += l_near_tone_pow;
            // format 32.0, <= 2^24
            l_acc_ti += j;
            // format 8.8, <= 2^6*2^8
            s_temp1 = sqrt32(j<<16);
            // format 24.8,  <= 2^18*2^8
            l_acc_sqrt_ti += (int32) s_temp1;
            // format of product is 8.8 X 8.8 = 16.16
            // Shift down to 26.6 for the accumulation, which then is <= 2^7*2^18*2^6
            l_acc_psd_sqrt_ti += ((s_temp1 * l_near_tone_pow + (1<<9))>>10);
         }
      }
// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (END)

      // If the psd is not decreasing, we don't bother evaluating the estimate of
      // kl0, and set the estimate equal to 0 below.  Do the same, if there are
      // less than 32 tones with sufficient snr.
      //XDSLRTFW-2379 (Start)
      if(gs_GuardBinKl0 == KL0_START_BIN)
      {
         gs_KL0_tone_count = s_tone_count;
      }
      //XDSLRTFW-2379 (End)
      if ((j_start != -1) && (s_tone_count > NUM_CHANNELS_KL0_ESTIMATION))
      {
         ///////////////////////////////////////////////////////////////////
         // Get floating point versions of the individual terms.
         //////////////////////////////////////////////////////////////////

         // l_acc_psd, which is 24.8
         get_float_representation(l_acc_psd,&s_acc_psd_mant,&s_acc_psd_exp);
         s_acc_psd_exp -= 8;

         // l_acc_ti, which is 32.0
         get_float_representation(l_acc_ti,&s_acc_ti_mant,&s_acc_ti_exp);

         // l_acc_sqrt_ti, which is 24.8
         get_float_representation(l_acc_sqrt_ti,&s_acc_sqrt_ti_mant,&s_acc_sqrt_ti_exp);
         s_acc_sqrt_ti_exp -= 8;

         // l_acc_psd_sqrt_ti, which is 26.6
         get_float_representation(l_acc_psd_sqrt_ti,&s_acc_psd_sqrt_ti_mant,&s_acc_psd_sqrt_ti_exp);
         s_acc_psd_sqrt_ti_exp -= 6;

         //////////////////////////////////////////////////////
         // Evaluate the denominator in the expression for kl0, using manual floating point.
         //////////////////////////////////////////////////////
         // N*l_acc_ti - l_acc_sqrt_ti^2
         float_macc(s_tone_count,0,s_acc_ti_mant,s_acc_ti_exp,
                    (int16) (-s_acc_sqrt_ti_mant),s_acc_sqrt_ti_exp,s_acc_sqrt_ti_mant,s_acc_sqrt_ti_exp,
                    &l_denom,&s_denom_exp);

         // Denominator needs to be short for later divide, so convert it to float,
         // updating s_denom_exp, appropriately.
         get_float_representation(l_denom,&s_denom_mant,&s_temp1_exp);
         s_denom_exp += s_temp1_exp;

         //////////////////////////////////////////////////////
         // Evaluate the numerator in the expression for kl0, using manual floating point.
         //////////////////////////////////////////////////////

         // l_acc_psd*l_acc_sqrt_ti - l_acc_psd_sqrt_ti*N
         float_macc(s_acc_psd_mant,s_acc_psd_exp,s_acc_sqrt_ti_mant,s_acc_sqrt_ti_exp,
                    (int16)(-s_tone_count),0,s_acc_psd_sqrt_ti_mant,s_acc_psd_sqrt_ti_exp,
                    &l_numer,&s_numer_exp);

         // l_numer needs to be short for the below multiply by s_val_invsqrt_binw_12p4, so convert it to float,
         // updating s_numer_exp, appropriately.
         // Record sign bit

         get_float_representation(l_numer,&s_numer_mant,&s_temp1_exp);
         s_numer_exp += s_temp1_exp;

         // This will multiply the above s_numer.
         if (gs_frame_rate_is_8khz == 1)
         {
            s_val_invsqrt_binw_12p4 = VAL_invsqrt_binw8_in_sqrtMHZ_12p4;
         }
         else
         {
            s_val_invsqrt_binw_12p4 = VAL_invsqrt_binw4_in_sqrtMHZ_12p4;
         }

         // Put it in float format
         get_float_representation((int32)(s_val_invsqrt_binw_12p4),&s_val_invsqrt_binw_mant,&s_temp1_exp);
         s_val_invsqrt_binw_exp = -4 + s_temp1_exp;

         // s_val_invsqrt_binw_12p4*(l_acc_psd*l_acc_sqrt_ti - l_acc_psd_sqrt_ti*N)
         l_numer = s_val_invsqrt_binw_mant*s_numer_mant;
         s_numer_exp += s_val_invsqrt_binw_exp;

         // Ensure that l_numer is small enough so that the 32by16 divide
         // that will follow is less than 2^15, and won't overflow a 16b result
         // (in case the divide result requires this).
         l_numer = (l_numer+1)>>1;
         s_numer_exp += 1;

         /////////////////////////////////////////////////////////////////////
         // Evaluate the ratio numerator/denominator in the expression for kl0
         /////////////////////////////////////////////////////////////////////

         // Assume 32b by 16b divide gives 32b
         l_temp1 = l_numer/s_denom_mant;
         if ((s_numer_exp-s_denom_exp+4)>0)
         {
            l_temp1 = l_temp1 << (s_numer_exp-s_denom_exp+4);
         }
         else
         {
            l_temp1 = (l_temp1 + (1<<(-(s_numer_exp-s_denom_exp+4)-1)))>> (-(s_numer_exp-s_denom_exp+4));
         }

         // KL0 for switching must be independent of any fix manipulation.
         // XDSLRTFW-3761 (Start_End)
         if (gus_DebugControlVRX518 & ENA_KL0_BASED_SWITCHING)
         {
            int16 s_Kl0EstimLocal;

            s_Kl0EstimLocal = (int16) ((l_temp1*10)>>4);

            // Empirical correction
            if (s_Kl0EstimLocal >= 200)
            {
               l_kl0_estimate = ((int32)(s_Kl0EstimLocal-200)) * 92;
               s_Kl0EstimLocal = 200 + (int16)((l_kl0_estimate+5)/100);
            }
            if (s_Kl0EstimLocal >= 350)
            {
               l_kl0_estimate = ((int32)(s_Kl0EstimLocal-350)) * 110;
               s_Kl0EstimLocal = 350 + (int16)((l_kl0_estimate+5)/100);
            }
            if (s_Kl0EstimLocal >= 500)
            {
               l_kl0_estimate = ((int32)(s_Kl0EstimLocal-500)) * 130;
               s_Kl0EstimLocal = 500 + (int16)((l_kl0_estimate+5)/100);
            }

            //By Standard, we need to Cap the KL0 Min value to be 1.8dB
            if(s_Kl0EstimLocal < 18)
            {
               s_Kl0EstimLocal = 18;
            }

            gus_SwitchingCriterionVal = (uint16)s_Kl0EstimLocal;
         }

         // Save electrical length in 0.1 dB format
         // XDSLRTFW-3212 : Upstream performance dip on short loops (Start)
         //--------------------------------------------------------------------------------
         // 2017/11/27: kl0 measurments with calibrated setup showed that our looplength estimation is
         //             resulting in too high kl0 estimations
         // ||                || Theory      ||        BRCM CPE  || VRx518   ||
         // || Looplength [m] || PE04 [dB]   || floored to 0.5B  || 35b mode ||
         // ||            0   ||        0.0   |             0.5   |     1.8   |
         // ||           50   ||        1.2   |             1.5   |     2.3   |
         // ||          100   ||        2.5   |             3.0   |     3.6   |
         // ||          150   ||        3.7   |             3.5   |     5.0   |
         // ||          200   ||        5.0   |             5.0   |     6.3   |
         // ||          250   ||        6.2   |             6.0   |     7.6   |
         //--------------------------------------------------------------------------------
         // Too high kl0 estimations result in too high US-PSDs if UPBO is enabled
         // In this case the US datarate does not show a flat rate in Rate vs. Reach loopreach tests
         // if the UPBO parameters (a/b) are matching the cable parameters
         // Workaround for (e.g.) KPN:
         // Decrease the looplength estimation by 10% (Option 2)
         // Option 1 (default):  ((l_temp1*10)>>4)
         // Option 2:            ((l_temp1*10)>>4) * 90%   (reduce calculated kl0 by 10 percent)
         // Option 3:            ((l_temp1*10)>>4) * 80%   (reduce calculated kl0 by 20 percent)
         // This code needs to be replaced by a proper looplength estimation
         if      (TESTArray[TEST_TX_PSD_CONTROL] & TEST_TX_PSD_CONTROL_REDUCE_KL0_BY_20_PERC)
         {
            gt_Kl0ElectricalLength.s_kl0_estimate = (int16) ((l_temp1* 8)>>4);
         }
         else if (TESTArray[TEST_TX_PSD_CONTROL] & TEST_TX_PSD_CONTROL_REDUCE_KL0_BY_10_PERC)
         {
            gt_Kl0ElectricalLength.s_kl0_estimate = (int16) ((l_temp1* 9)>>4);
         }
         else
         {
            gt_Kl0ElectricalLength.s_kl0_estimate = (int16) ((l_temp1*10)>>4);
         }
         // XDSLRTFW-3212 : Upstream performance dip on short loops (End)

         //Value to offset the computed Electrical length (in 0.1 dB format)
         // gt_Kl0ElectricalLength.s_kl0_estimate += gs_kl0_offset;
         // Empirical correction
         if (gt_Kl0ElectricalLength.s_kl0_estimate >= 200)
         {
            l_kl0_estimate = ((int32)(gt_Kl0ElectricalLength.s_kl0_estimate-200)) * 92;
            gt_Kl0ElectricalLength.s_kl0_estimate = 200 + (int16)((l_kl0_estimate+5)/100);
         }

         if (gt_Kl0ElectricalLength.s_kl0_estimate >= 350)
         {
            l_kl0_estimate = ((int32)(gt_Kl0ElectricalLength.s_kl0_estimate-350)) * 110;
            gt_Kl0ElectricalLength.s_kl0_estimate = 350 + (int16)((l_kl0_estimate+5)/100);
         }

         if (gt_Kl0ElectricalLength.s_kl0_estimate >= 500)
         {
            l_kl0_estimate = ((int32)(gt_Kl0ElectricalLength.s_kl0_estimate-500)) * 130;
            gt_Kl0ElectricalLength.s_kl0_estimate = 500 + (int16)((l_kl0_estimate+5)/100);
         }

         //XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_NoSync3200ft IOP_A_US_VDSL2_EVLT_F_CNXT_USdatarate (START)
         if ( (gft_EVLT_IOPtuning) &&
            (gt_ProfileAct.us_ProfileSelected & (CNFG_V2_PROFILE_8D_MASK | CNFG_V2_PROFILE_8A_MASK)) )
         {
            // empirical IOP adjustment to reduce estimated KL0 to connect from 2950ft to 3900ft
            if (gt_Kl0ElectricalLength.s_kl0_estimate >= 495)
            {
               //Empirical IOP adjustment for KL0 to improve US performance on loops >= 6400ft (kl0 >= 495)
               gsa_IOP_LATN_Kl0[0] = 10; //Reduce estimated KL0
            }
            else if (gt_Kl0ElectricalLength.s_kl0_estimate >= 330)
            {
               //Empirical IOP adjustment for KL0 to improve US performance on loops >= 4100ft (kl0 >= 330)
               gsa_IOP_LATN_Kl0[0] = 10; //Reduce estimated KL0
            }
            else if (gt_Kl0ElectricalLength.s_kl0_estimate >= 313)
            {
               //Empirical IOP adjustment for KL0 to improve US performance on loops >= 3800ft (kl0 >= 313)
               gsa_IOP_LATN_Kl0[0] = 90; //Reduce estimated KL0
            }
            else if (gt_Kl0ElectricalLength.s_kl0_estimate >= 280)
            {
               //Empirical IOP adjustment for KL0 to improve US performance on loops >= 3350ft (kl0 >= 280)
               gsa_IOP_LATN_Kl0[0] = 60; //Reduce estimated KL0
            }
            else if (gt_Kl0ElectricalLength.s_kl0_estimate >= 250)
            {
               //Empirical IOP adjustment for KL0 to improve US performance on loops >= 3000ft (kl0 >= 250)
               gsa_IOP_LATN_Kl0[0] = 30; //Reduce estimated KL0
            }
            else
            {
               gsa_IOP_LATN_Kl0[0] = 0;
            }
         }
         //XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_NoSync3200ft IOP_A_US_VDSL2_EVLT_F_CNXT_USdatarate (END)

      // XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_K_BRCM_USdatarate (START)
      // XDSLRTFW-735 IOP_A_US_VDSL2_VINAX_USdatarate (START)
      if ( (!(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)) &&
            ((gt_Dsl_Operator_Select.us_Operator_Select == AT_T) || (gt_Dsl_Operator_Select.us_Operator_Select == CTL)) )
        {
         //XDSLRTFW-3833 Reuse XDSLRTFW-3212 code to fine tune PSD boost  (START)
         //Adjust PSD boost on top of TEST_TX_PSD_CONTROL_CTL_MODE (PSDboost_US1=PSDboost_US2=1dBm/Hz; PSDboost_US0=0)
         s_PSDboost_US0  =  0;  // 0dBm/Hz boost
         s_PSDboost_US1  =  0; // 0+1dBm/Hz boost
         s_PSDboost_US2  =  0; // 0+1dBm/Hz boost

         if (gt_Kl0ElectricalLength.s_kl0_estimate >= 250)
          {
             //XDSLRTFW-3833 Empirical IOP adjustment for PSD boost US1 by 1.5dBm/Hz to improve US performance on loops >= 3000ft (kl0 >= 250)
             //Reuse XDSLRTFW-3212 code to fine tune PSD boost
             s_PSDboost_US1  =  5;   //Additional 0.5dBm/Hz US1 boost on top of TEST_TX_PSD_CONTROL_CTL_MODE: total US1 boost 1.5dBm/Hz
          }

          gt_TxPsdControl.s_US_PSD_Boost_0dB1[0] += s_PSDboost_US0;
          gt_TxPsdControl.s_US_PSD_Boost_0dB1[1] += s_PSDboost_US1;
          gt_TxPsdControl.s_US_PSD_Boost_0dB1[2] += s_PSDboost_US2;
         //XDSLRTFW-3833 Reuse XDSLRTFW-3212 code to fine tune PSD boost  (END)

        }
        // XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_K_BRCM_USdatarate (END)
        // XDSLRTFW-735 IOP_A_US_VDSL2_VINAX_USdatarate (END)

         gt_Kl0ElectricalLength.s_kl0_estimate -= gsa_IOP_LATN_Kl0[0];

         //XDSLRTFW- 2335(Start)
         //Workaround to match 30a KL0 to 17aKL0. This code to be removed after proper
         //30a calibration table is computed.
         if (gs_frame_rate_is_8khz == TRUE)
         {
            gt_Kl0ElectricalLength.s_kl0_estimate += 9; //+0.9db
         }

         //Boost kl0 for short-loop with bridge tap loop to match that produced by BRCM modem
         if((gft_EnableKl0Boost) && (gs_Kl0PreProcDone))
         {
            //for loop length, boost kl0 by 1 dB
            // Even though this fix is required, we have to backoff this due to Rate Dip
            if(gt_Kl0ElectricalLength.s_kl0_estimate < 140)
            {
               gt_Kl0ElectricalLength.s_kl0_estimate += gs_kl0_BoostAmount;
            }
         }

         // The valid range of values is from 0 dB to 128 dB with a 0.1 dB step
         if (gt_Kl0ElectricalLength.s_kl0_estimate < KL0_MIN_VALUE)
         {
            gt_Kl0ElectricalLength.s_kl0_estimate = KL0_MIN_VALUE;
         }
         else if (gt_Kl0ElectricalLength.s_kl0_estimate > KL0_MAX_VALUE)
         {
            gt_Kl0ElectricalLength.s_kl0_estimate = KL0_MAX_VALUE;
         }
      } //if (s_stopped)
      else
      {
         gt_Kl0ElectricalLength.s_kl0_estimate = KL0_MAX_VALUE;
         // XDSLRTFW-3761 (Start_End)
         if (gus_DebugControlVRX518 & ENA_KL0_BASED_SWITCHING)
         {
            gus_SwitchingCriterionVal = (uint16)KL0_MAX_VALUE;
         }
      }

      //XDSLRTFW-1521
      //For Avinax Platform do not want to have the cap of 1.8dB
      //As Avinax already would add 0.5dB for each value sent by VR9
      us_platform = (gus_fe_G994VendorSpecific >> 12) & 0x000F;
      if( (gul_fe_G994VendorID != IFX_VENDOR_ID) ||
            ((gul_fe_G994VendorID == IFX_VENDOR_ID) && (us_platform != AVINAX_PLATFORM)) )
      {
         //By Standard, we need to Cap the KL0 Min value to be 1.8dB
         if(gt_Kl0ElectricalLength.s_kl0_estimate < 18)
         {
            gt_Kl0ElectricalLength.s_kl0_estimate = 18;
         }
      }

      // XDSLRTFW-3212 : Upstream performance dip on short loops
      // Debug option to force the kl0 estimation
      // Option 1 (default): Disable forcing by setting gt_TxPsdControl.s_Force_kl0_estimate to "0"
      // Option 2:           Enable  forcing by setting gt_TxPsdControl.s_Force_kl0_estimate to the
      //                     desired kl0 (e.g. set to "84" to force a kl0 of 8.4dB
      if (gt_TxPsdControl.s_Force_kl0_estimate > 0)
      {
         gt_Kl0ElectricalLength.s_kl0_estimate = gt_TxPsdControl.s_Force_kl0_estimate;
      }

   } // END of if (gs_get_estimate_kl0 == 1)
} //ComputeKl0DS1

int32 accum_power(int32 l_tone_pow, int16 s_precision)
{
   int16 k,s_which_decade;
   int32 l_temp1, l_numer;
   uint16 us_linear_out;

   l_temp1 = 0;

   // If normalized psd is negative, it is small enough to ignore,
   // and we don't include it in the accumulated power.
   if (l_tone_pow>=0)
   {
      // Additional normalization to bring magnitude close to 0
      // to have adequate precision for conversion from log to linear.
      s_which_decade = (l_tone_pow>>s_precision)/10;
      l_tone_pow -= ((10*s_which_decade)<<s_precision);

      // ConvertLogToLinear expects 7.9 input produces 3.13 output with
      // output = 10^(-input/20), aside from scaling.  We want 10^(-input/10),
      // so do another <<1 going in.
      l_tone_pow <<= ((9-s_precision)+1);
      ConvertLogToLinear(&us_linear_out , (int16)l_tone_pow);

      // Need to invert this to get from 10^(-input/10) to 10^(input/10).
      // Incorporate 3.13 format of us_linear_out.  To also undo the second normalization
      // (s_which_decade), unity in the numerator is
      // (1<<13) * 10^(s_which_decade)
      l_numer = 1<<13;
      for (k=1; k<=s_which_decade; k++)
      {
         l_numer *= 10;
      }

      // inversion
      l_temp1 = l_numer/us_linear_out;

   } // if (s_far_tone_pow>=0)

   return (l_temp1);
}

void get_float_representation(int32 l_fixed, int16* mantissa, int16* exponent)
{
   int32 l_temp1, l_temp2;

   // l_fixed, which is 32.0
   // Record sign bit
   l_temp2 = 0x80000000 & l_fixed;
   l_temp1 = l_fixed<<1;
   *exponent = 16;
   while ( ((((int32)(0x80000000)) & l_temp1) == l_temp2) && (*exponent != (-16)) )
   {
      l_temp1 <<= 1;
      *exponent += (-1);
   }
   if (*exponent <= 0)
   {
      *mantissa = (int16) (l_fixed<<(-*exponent));
   }
   else
   {
      *mantissa = (int16) ((l_fixed+(1<<(*exponent-1)))>>*exponent);
   }
}

void float_macc(int16 s_mant_a_1,int16 s_exp_a_1,int16 s_mant_a_2,int16 s_exp_a_2,
                int16 s_mant_b_1,int16 s_exp_b_1,int16 s_mant_b_2,int16 s_exp_b_2,
                int32* l_mant_result, int16* s_exp_result)
{
   int32 l_temp1, l_temp2;
   int16 s_temp1_exp, s_temp2_exp;

   l_temp1 = (int32) (s_mant_a_1*s_mant_a_2);
   s_temp1_exp = s_exp_a_1+s_exp_a_2;

   l_temp2 = (int32) (s_mant_b_1*s_mant_b_2);
   s_temp2_exp = s_exp_b_1+s_exp_b_2;

   if (s_temp1_exp > s_temp2_exp)
   {
      *l_mant_result = l_temp1 + ( (l_temp2 + (1<<(s_temp1_exp-s_temp2_exp-1))) >> (s_temp1_exp-s_temp2_exp) );
      *s_exp_result = s_temp1_exp;
   }
   else if (s_temp2_exp > s_temp1_exp)
   {
      *l_mant_result = ( (l_temp1 + (1<<(s_temp2_exp-s_temp1_exp-1))) >> (s_temp2_exp-s_temp1_exp) ) + l_temp2;
      *s_exp_result = s_temp2_exp;
   }
   else
   {
      *l_mant_result = l_temp1 + l_temp2;
      *s_exp_result = s_temp1_exp;
   }
}

// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)
void ComputeELE(void)
{
   {
      int16 s_RxMaxNomPsd;
      s_RxMaxNomPsd = gt_PwrConfigParam.s_Dn_MaxNomPSD;
      uint16 i, j, k, n, MinIndex;
      //Coding rule: RXTHRSHUS = (-100 + RxThreshUs) dBm/Hz \n
      int16 LocalRxThreshDs = (int16)(-100 + gt_AELEM_UPBOInfo.s_RxThreshDs);
      uint16 NoOfTones, NoOfActTonesInPercentile=0;
      int16 s_temp1;
      int16 tmp;
      uint16 Start, Stop;
      int16 ELE, MinELE=0;
      uint16 ELEIndex = 0;
      uint16 NumBands = gs_NumOfRxBands;
      uint16 HlogIndex = 0;
      uint16 HighestTone;
      int32 l_NearTonePow, Temp, HlogPrev; // Hold values in Q8.8
      int16 GroupSize;    //(int16)(1 << ptTphStatics->Log2CarrierGroupSizeRxDisc);
      int32 l_RxTotalGain;
      int16 *psa_Psd;
      psa_Psd = gpsa_MeasuredSnrBuf;

      GroupSize = 1;

      // Note: gt_DfeAfeGainSettings.s_Rx_FFT_Gain_Rms_dB should not be considered for PSD(f) to Line side transformation.
      //       The variable is only for PGAHandler(), i.e. Calculation of RMS frequency domain for PGA.
      l_RxTotalGain =  (int32)gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB;          // ptTphStatics->RxVarGainDb;
      l_RxTotalGain += (int32)gs_PGA_set;                                       // ptTphStatics->PgaSet;
      l_RxTotalGain += (int32)gs_HybridGain;                                    // ptTphStatics->HybridGain;
      l_RxTotalGain += (int32)gt_DfeAfeGainSettings.s_Rx_Total_TdqToAfeInterface_Gain_dB;
      l_RxTotalGain += (int32)gt_DfeAfeGainSettings.s_Rx_FFT_Gain_dBPerHz;      // ptTphStatics->RxFftGainDb;
      l_RxTotalGain += gl_afe_fixed_gain;                                // ptTphStatics->AfeFixedGain;
      l_RxTotalGain += (int32)gt_DfeAfeGainSettings.s_RxPathTrafo_Gain_dB;
      l_RxTotalGain += (int32)gt_DfeAfeGainSettings.s_AfeLevelShiftDfe_Gain_dB;
      l_RxTotalGain += (int32)gt_PgaGainCorrectionDslPath.s_corr_gain_rxa_dB_out;
      l_RxTotalGain += (int32)gs_QlnHlogCorrection;


      // If a band's LATN is higher than 70 dB ( 70*256 in Q8.8), then all tones
      // in or after this band will be assigned OUT_OF_RANGE value for Hlog.
      // @todo - Maria: Check this, on the CO we have this clause on the CPE not. Why?
//        HighestTone = gsa_RxBandRightChannel[gs_NumOfRxBands-1];
//        for (i=1; i<gs_NumOfRxBands; i++)
//        {
//            if (ptTphStatics->ptXsmHostMessages->tAckLineStatusPerBandUsGet.LineStatusPbUs[i].LatnPb > 17920)
//            {
//                HighestTone = gsa_RxBandRightChannel[i-1];
//            }
//        }

      HlogPrev = (OUT_OF_RANGE_HLOG<<8);

      // DS bands are counted from band 1:
      n = 0;
      k = 0;          // start from band1 (band0 doesn't exist) band1 indexed with 0

      // f1 is not a specific parameter for AELEM. This parameter refers to the
      // lower frequency of the DS1 band. It can be found in the standard where
      // the PSD masks are defined: see AnnexB Table B.1 (p312) directly below
      // the tables are the frequencies defined, also see AnnexA (p301) FigureA.1
      // Maria: i beleive, we actually talk here about f1 = gsa_RxBandLeftChannel[0]
      // and we don't need to do anything special, since the ELE would anyway calculated
      // over used tones only


      while( k != gs_NumOfRxBands )
      {

         HlogPrev = (OUT_OF_RANGE_HLOG<<8);
         ELEIndex = 0;
         // k is index of UPBO band
         Start  = gsa_RxBandLeftChannel[k];
         Stop = gsa_RxBandRightChannel[k];
         for (i=Start; i<=Stop; i=(uint16)(i+GroupSize))
         {
            // Compute sqrt(f), f in Hz
            //s_temp1 = sqrt32((int32)i*(43125<<gs_frame_rate_is_8khz)/10);
            //s_temp1 = gsa_ELE_Tmp[i];
// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (START)
            s_temp1 = sqrt32((int32)i*(43125<<gs_frame_rate_is_8khz)/10);
// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (END)
            // multiply with 1000: we calculated the freq in Hz and not in MHz (10^6Hz)
            // But the standard suggests MHz, so we would need to devide the square root by 10^3
            // instead we multiply LOSS (-Hlog) function with 1000
            // consider that Hlog is in 8.8 but we want it in 0.1dB -> multiply by 10, shift 8
            // in the end we need to multiply Hlog with 10000 and shift down 8

            //-----------------------------
            // Check for valid in-band tone
            //-----------------------------
            if (!IS_TONEFLAGSET(guca_RxSupportedToneSet_temp,i))
            {
               Temp = (OUT_OF_RANGE_HLOG<<8);
               HlogPrev = (OUT_OF_RANGE_HLOG<<8);

               // multiply LOSS with 10000
               //ELE = (int16)(((1000*3071)/s_temp1));    // LOSS = special 307.1dB
               ELE = 1281;     // use special value 128.1 which indicates that no valid measurement can be done
            }
            else
            {
// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (START)
               // Input from the Hlog Calculated earlier
               Temp = gsa_PsdAnalysis_out[i];
// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (END)

               HlogPrev = Temp;

               // ----------------------------------------------
               // upper limit for Hlog: 6dB
               // ----------------------------------------------
               if (Temp > (6*256))
               {
                  Temp = (int16)(6*256);
               }

               // ----------------------------------------------
               // convert Hlog to final representation (10 bits)
               // ----------------------------------------------
               if (Temp < (-80*256))
               {
                  // Although the standard allows value as low as -96 dB, in our calculation
                  // anything below -80 dB is generally unreliable and the corresponding tone
                  // is usually not bit loaded. Therefore we use -80 as the lower threshold.
                  Temp = (OUT_OF_RANGE_HLOG<<8);
                  HighestTone = (uint16)i;

                  // multiply LOSS with 10000
                  //ELE = (int16)(((1000*3071)/s_temp1));    // LOSS = special 307.1dB
                  ELE = 1281;     // use special value 128.1 which indicates that no valid measurement can be done
               }
               else
               {
                  //-----------------------------
                  // Get the near end psd
                  //-----------------------------
                  l_NearTonePow = (int32)psa_Psd[i];
                  l_NearTonePow -= l_RxTotalGain;

                  // multiply LOSS(-Hlog) with 10000 and shift down 8
                  ELE = (int16)((((-10000*(Temp))/s_temp1) + 0x80) >>8);
                  if(l_NearTonePow < (((LocalRxThreshDs<<8) - l_RxTotalGain)))
                  {
                     // multiply LOSS with 10000
                     ELE = (int16)(((1000*3071)/s_temp1));    // LOSS = special 307.1dB
                  }
               }
            }

            if(ELE > 1281)
            {
               ELE = 1281;     // limit to special value 128.1dB
            }
            gsa_ELE_Tmp[ELEIndex++]= ELE;
         }

// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (START)
         // Discard the lowest value from minELE - generally seen very small ELE for the initial few tones!
         if (gt_AELEM_UPBOInfo.us_UpboElmt == 0)
         {
            // UPBOELEMT values expressed as 4-bits unsigned integer in percent
            // The only valid value of UPBOELEMT is 10. Other values are reserved for future use.
            gt_AELEM_UPBOInfo.us_UpboElmt = 10;    // XDSLRTFW-4052(Start_End)
         }
// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (END)
         // Percentile
         // search for UPBOELMT percent from the lowest values we got and discard those. What is the lowest value we have after that:
         // 1. how many values we have in this band total:
         NoOfTones = (uint16)(Stop - Start + 1);     // this is 100%
         NoOfTones = (uint16)((uint16)(NoOfTones*(gt_AELEM_UPBOInfo.us_UpboElmt))/100);

         MinIndex = ELEIndex;
         for(j = 0; j<(uint16)(NoOfTones+1); j++)
         {
            MinELE = KL0_MAX_VALUE;
            NoOfActTonesInPercentile = 0;
            for(i = 0; i<ELEIndex; i++)
            {
               tmp = gsa_ELE_Tmp[i];

               // any ELE value which is greater then 1280 has to be excluded from the search
               if((tmp < MinELE) && (tmp<=KL0_MAX_VALUE) && (tmp > KL0_MIN_VALUE))
               {
                  // search for the minimun
                  MinELE = tmp;
                  MinIndex = i;
                  NoOfActTonesInPercentile++;
               }
            }
            // MinELE contains minimum, set it to max
            gsa_ELE_Tmp[MinIndex] = 0x7FFF;
         }

         if(NoOfActTonesInPercentile == 0)
         {
            // G.997.1 (7.5.1.23.4) defines: "The value ranges from 0 to 128dB in steps of 0.1dB,
            // with special value 204.7 which indicates that estimate is greater than 128dB.
            // We should mark this somehow, when we had no useable data to calculate ELE/kl0
            // We should report this somehow.
            MinELE = KL0_OUT_OF_RANGE;
         }
         // MinELE is the value we were looking for
         if(MinELE < 0)
         {
            MinELE = 0; // never report negative values, they are difficult to explain.
         }
         gt_AELEM_UPBOInfo.usa_Kl0EstimRPb[n++] = (uint16)MinELE;

         k++;

      }
      guc_ELEDsBands = (uint8)n;
      gus_ELEDsMin = KL0_MAX_VALUE;
      for(i = 0; i< guc_ELEDsBands; i++)
      {
         if(gt_AELEM_UPBOInfo.usa_Kl0EstimRPb[i]<gus_ELEDsMin)
         {
            gus_ELEDsMin = gt_AELEM_UPBOInfo.usa_Kl0EstimRPb[i];
         }
      }
      // Assume that you had a previous run and all values were populated because there were 4 bands
      for(i = guc_ELEDsBands; i< 4; i++)
      {
         gt_AELEM_UPBOInfo.usa_Kl0EstimRPb[i] = KL0_UNUSED_BAND;
      }

      // XDSLRTFW-1325 : US Rate not matching R4.3
      // XDSLRTFW-1975 (Start_End)
      // KL0 issue : A Possible solution
      // Use the ELE calculated per band for BT with CAL profiles DPBO
      if(gt_CustomerIopBits.us_ECI & ECI_KL0_WORKAROUND)
      {
         //For ECI use AELEM DS2 for KL0 due to noise constraint
         if(gt_AELEM_UPBOInfo.usa_Kl0EstimRPb[1] < KL0_OUT_OF_RANGE)
         {
            if(gt_Kl0ElectricalLength.s_kl0_estimate < gt_AELEM_UPBOInfo.usa_Kl0EstimRPb[1])
            {
               gt_Kl0ElectricalLength.s_kl0_estimate = gt_AELEM_UPBOInfo.usa_Kl0EstimRPb[1];
            }
         }
         else if(gt_AELEM_UPBOInfo.usa_Kl0EstimRPb[0] < KL0_OUT_OF_RANGE)
         {
            if(gt_Kl0ElectricalLength.s_kl0_estimate < gt_AELEM_UPBOInfo.usa_Kl0EstimRPb[0])
            {
               gt_Kl0ElectricalLength.s_kl0_estimate = gt_AELEM_UPBOInfo.usa_Kl0EstimRPb[0];
            }
         }
      }
      //XDSLRTFW-2268
      //In a case where KL0 algorithm has less than 32 tones
      //for calculation we see estimated KL0 = 128
      //Use ELE Min if KL0 DS1 doesn't have valid value
      if(gt_Kl0ElectricalLength.s_kl0_estimate == 1280)
      {
         if( gus_ELEDsMin != 1280)
         {
            gt_Kl0ElectricalLength.s_kl0_estimate = gus_ELEDsMin;
         }
         else
         {
            gs_E_CODE_KL0_THRESHOLD_FAIL_count++;
         }
      }
 
       // XDSLRTFW-4052(Start)
       // In 30MHz mode kl0 estimation is always done according to ELE-M1 (the alternative method)instead of using the slope
       // ELE-M0 (the default method using the slope based Aware-algorithm) does not work for DPBO and bridge-tap loops
       // in 30MHz mode
       // TBD:
       // Use also for 8/12/17 and 35b profiles the ELE-M1 mode instead of slope-algo. 
      if(gus_kl0_estimation_method == ELE_M1_METHOD_PERCENTILE_ALGO)
      {
         gt_Kl0ElectricalLength.s_kl0_estimate = gus_ELEDsMin;
      }     
      // XDSLRTFW-4052(End)
      //In case of Bridge Tap Case, select ELEmin as Kl0
//        if(gs_Kl0PreProcDone & 0x1)
//        {
//            gt_Kl0ElectricalLength.s_kl0_estimate = gus_ELEDsMin;
//        }
   }
}
// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : void ComputeHlog(void)
 *
 *  Prototype:  void ComputeHlog(void)
 *
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *      Return:
 *      None
 *
 *  Notes: Background function to compute Hlog
 *
 *------------------------------------------------------------------------
 *^^^
 */
void ComputeHlog(void)
{
   uint8 *puca_RxSupportedToneSet;
   FlagT ft_ValidTone = TRUE;
   int16 i, k=0, s_Hlog;
   int16 s_psd, s_G=0;
   int16 s_RxMaxNomPsd;
   int16 *psa_Psd;
   int16 s_RxNumTones_Hlog, s_Log2CarrierGroupSizeRx_Disc_Hlog;
   int16 s_step_size =0;
   int32 l_far_tone_pow, l_near_tone_pow;
   int32 l_temp;


   //---------------------------------------------------
   // initialize input parameter structure
   //---------------------------------------------------
   psa_Psd = gpsa_MeasuredSnrBuf;

   // Note: gt_DfeAfeGainSettings.s_Rx_FFT_Gain_Rms_dB should not be considered for PSD(f) to Line side transformation.
   //       The variable is only for PGAHandler(), i.e. Calculation of RMS frequency domain for PGA.
   gl_RxPathTotalGain = (int32)gt_DfeAfeGainSettings.s_Rx_VGWin_Gain_dB +
                       (int32)gs_PGA_set +
                       (int32)gs_HybridGain +
                       (int32)gt_DfeAfeGainSettings.s_Rx_Total_TdqToAfeInterface_Gain_dB +
                       (int32)gt_DfeAfeGainSettings.s_Rx_FFT_Gain_dBPerHz +
                       gl_afe_fixed_gain +
                       (int32)gt_DfeAfeGainSettings.s_RxPathTrafo_Gain_dB +
                       (int32)gt_DfeAfeGainSettings.s_AfeLevelShiftDfe_Gain_dB +
                       (int32)gt_PgaGainCorrectionDslPath.s_corr_gain_rxa_dB_out+
                       (int32)gs_QlnHlogCorrection;

   s_RxMaxNomPsd = gt_PwrConfigParam.s_Dn_MaxNomPSD;


   //XDSLRTFW-2135 (Start)
   s_RxNumTones_Hlog = (512 << gs_Log2CarrierGroupSizeRx_Disc);

   // In case of 8K tones, HLOG is calculated for every 8th tone and but we need HLOG in for every 16 tone
   if ( gs_Log2CarrierGroupSizeRx_Disc == 4)
   {
      s_Log2CarrierGroupSizeRx_Disc_Hlog = SUBCAR_GROUP_SIZE_LOG2_8;
      s_step_size = 1; //we need HLOG in for every 16 tone
   }
   else
   {
      s_Log2CarrierGroupSizeRx_Disc_Hlog = gs_Log2CarrierGroupSizeRx_Disc;
   }

   if (gs_Log2CarrierGroupSizeRx_Disc > 0)
   {
      s_Log2CarrierGroupSizeRx_Disc_Hlog = (1 << s_Log2CarrierGroupSizeRx_Disc_Hlog) - 1;
   }
   // XDSLRTFW-2135 (End)
   for (i = 0; i < s_RxNumTones_Hlog; i++)
   {
      // Check if a valid in-band tone
      // XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (START)
      // XDSLRTFW-2082 (Start_End)
      //Take care of Bins with lower SNRs
      puca_RxSupportedToneSet = guca_RxSupportedToneSet;
      if (!IS_TONEFLAGSET(puca_RxSupportedToneSet,i))
      {
         s_Hlog = (int16)OUT_OF_RANGE_HLOG;
      }
      else
      {
         // XDSLRTFW-3935 irrespective of bridge tap detection. Use FDQ based PSD equivalent to calculate HLOG
         if(i<(NUM_OF_TONES_FDQ_BASED_HLOG-1))
         {
            // only consider even tones of our FDQ based power calculation,
            // since we see an issue with odd tones related to FDQ training. Once FDQ is corrected we don't need this code
            if(i%2==0)
            {
               l_temp = gsa_PsdAnalysis_out[i];
            }
            else
            {
               l_temp = gsa_PsdAnalysis_out[i+1];
            }
         }
         else
         {
            l_temp = gsa_PsdAnalysis_out[i];

            //XDSLRTFW-1461 and 1449
            //Use the PSD Buffer for HLOG instead of Processed BUffer
            //as we have detected Bridge Taps
            //0x7 indicated BT detected in one of the 3 bands.
            //Each bit position is for BT in DS1 to DS3
            if(gs_Kl0PreProcDone & 0x7)
            {
               /////////////////////////
               // Get the near end psd
               /////////////////////////
               l_near_tone_pow = psa_Psd[i];
               l_near_tone_pow -= gl_RxPathTotalGain;

               /////////////////////////
               // Get the far end psd
               /////////////////////////
               //s_psd = GetTonePsd(i, pt_PSDDesc,S-NumTonesRxTx);

               // Get absolute psd level
               //s_psd += -s_RxMaxNomPsd;

               s_psd = -s_RxMaxNomPsd;
               // Far-end tone power: dBm/Hz, format 8.8
               l_far_tone_pow = ((s_psd<<8)/10);

               // Channel gain: dB, format 8.8
               l_temp = (l_near_tone_pow - l_far_tone_pow);

            }//(gs_Kl0PreProcDone & 0x7)
         }


         // XDSLRTFW-1461 and 1449
         // XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (END)
         // Ensure that the Hlog is in the range of -96 to 6 dBm/Hz
         if (( l_temp >= (-96*256)) && ( l_temp <= (6* 256)))
         {
            s_Hlog = (int16)(l_temp >> 3);                     //preshift by 3 bits to avoid overflow
            s_Hlog = (int16)(10*((6*32) - s_Hlog) + (0x1<<4));
            s_Hlog = s_Hlog >> 5 ;
         }
         else
         {
            s_Hlog = (int16)OUT_OF_RANGE_HLOG;
         }
      }

      // XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (START)
      gsa_PsdAnalysis_out[i] = (s_Hlog & 0x03FF);

      // Compute the group index
      // XDSLRTFW-1926 (Start_End) / XDSLRTFW-2082 (Start_End)
      if ( ( (i+1) & s_Log2CarrierGroupSizeRx_Disc_Hlog) == 0 ) //XDSLRTFW-2135 (Start_End)
      {
         int16 s_LowAverage=0, s_HighAverage=0, s_ThreshAverage;

         //Take care of Bins with lower SNRs
         if ((gsa_Cnfg_Misc[0] & CNFG_Misc_HlogReportStdVsCustm) &&
               ((guca_RxSupportedToneSet_temp[s_G] & 0xFF) == 0))
         {
            unsigned int LoopIdx;
            for (LoopIdx = i-7; LoopIdx < i; LoopIdx++)
            {
               gsa_PsdAnalysis_out[LoopIdx] = (int16)OUT_OF_RANGE_HLOG;
               puca_RxSupportedToneSet = guca_RxSupportedToneSet_temp;
            }
         }

         // Get the 10 bit HLog value for messaging
         // do averaging of the current and previous 7 tones, if they are part of the supported set
         if (i > 6)
         {
            s_LowAverage = (gsa_PsdAnalysis_out[i-7] + gsa_PsdAnalysis_out[i-6] +
                            gsa_PsdAnalysis_out[i-5] + gsa_PsdAnalysis_out[i-4]) >> 2;
            s_HighAverage = (gsa_PsdAnalysis_out[i-3] + gsa_PsdAnalysis_out[i-2] +
                             gsa_PsdAnalysis_out[i-1] + gsa_PsdAnalysis_out[i]) >> 2;
            s_ThreshAverage = (s_LowAverage - s_HighAverage);

            // Check if average is in the 3dB range
            if((s_ThreshAverage <= 30) && (s_ThreshAverage >= -30))
            {
               s_Hlog = ((s_LowAverage + s_HighAverage) >> 1);
            }
            else
            {
               // Take current HLog value
               s_Hlog = (s_Hlog & 0x03FF);              // gsa_PsdAnalysis_out[i]
            }
         }

         // Check if the tone is in the supported set (DS band), i.e. check band boundary in case of leaving the US band.
         if ( (i > 6) && ((puca_RxSupportedToneSet[s_G] & 0x01) == 0) )
         {
            if ((puca_RxSupportedToneSet[s_G] & 0xF0) == 0xF0)
            {
               // Take averaged HLog value, i.e. out of 4 values.
               s_Hlog = s_HighAverage;
            }
            else
            {
               // Take current HLog value
               s_Hlog = gsa_PsdAnalysis_out[i];
            }
         }
         // Check if the tone is in the supported set (DS band), i.e. check band boundary in case of entering the US band.
         if ( (i > 6) &&  ((puca_RxSupportedToneSet[s_G] & 0x80) == 0) )
         {
            if ((puca_RxSupportedToneSet[s_G] & 0x0F) == 0x0F)
            {
               // Take averaged HLog value, i.e. out of 4 values.
               s_Hlog = s_LowAverage;
            }
            else
            {
               // Take HLog value
               s_Hlog = gsa_PsdAnalysis_out[i-7];
            }
         }
         gsa_RxHlog[s_G >> s_step_size] =  s_Hlog;
         s_G++;
      }
   } // (i = 0; i < s_RxNumTones_Hlog; i++)

   // XDSLRTFW-3344 (Start_End)
   memcpy(gsa_RxHLog_PerTone_Internal, gsa_PsdAnalysis_out, (gs_RxNumTones<<1));

   //Store the near-end (NE) HLOG measurement time
   gt_ChannelMeasurement_NE.us_HlogMT = (1<<gt_PsdConfig.s_AlgLog2NumFramesToAccum);

// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (START)
   if(i > gsa_RxBandRightChannel[k])
   {
      k++;
   }
// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (END)

   // XDSLRTFW-3344 (Start)
   DMAtoSDRAM_PerTone(HLOG_PERTONE);
// XDSLRTFW-3344 (End)

} //CompHlog()


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : void ApplyRxPathPsdCorrection(int16 *psa_PsdIn, int16 *psa_PsdOut)
 *
 *
 *  Since the PSD computed using the FFT output contains the AFE and strymon spectral shaping
 *  This function applies the RX path PSD correction to the PSD to remove the spectral shaping.
 *
 *  Input Arguments:
 *              psa_PsdIn -- pointer to the uncorrected input PSD
 *
 *  Output Arguments:
 *              psa_PsdOut -- pointer to the corrected output PSD
 *      Return:
 *      None
 *
 *  Notes: Background function to compute Hlog
 *
 *------------------------------------------------------------------------
 *^^^
 */
// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)

void GenerateRxPathPsdCorrectionVector(void)
{
   RxPathGainPSDDescriptorTable_t *pt_RxPathGainPSDDescriptorTable=NULL;
   int16 s_BpIdx, i;
   int16 s_leftToneIdx, s_leftToneAttenLevel, s_rightToneIdx, s_rightToneAttenLevel;
   int16 s_RxPathAtten;

   uint16 ia,ib,ic;
   uint16 us_sizeA, us_sizeB, us_sizeC;

   {
      if(gs_RxLog2FftLength == DS_LOG2_FFT_LENGTH_16384)
      {
         // 35B
         if(TESTArray[TEST_Control3] & TEST_Control3_Ena_A21OldLifHyb)
         {
            pt_RxPathGainPSDDescriptorTable = &gt_RxPathGainPSDDescriptorTable_VRX518_HYB_ABJ_35M_A21;
         }
         else
         {
            pt_RxPathGainPSDDescriptorTable = &gt_RxPathGainPSDDescriptorTable_VRX518_HYB_ABJ_35M;
         }
      }
      else
      {
         if(TESTArray[TEST_Control3] & TEST_Control3_Ena_A21OldLifHyb)
         {
            pt_RxPathGainPSDDescriptorTable = &gt_RxPathGainPSDDescriptorTable_VRX518_HYB_ABJ_8M_A21;
         }
         else
         {
            pt_RxPathGainPSDDescriptorTable = &gt_RxPathGainPSDDescriptorTable_VRX518_HYB_ABJ_17M;
         }
         //pt_RxPathGainPSDDescriptorTable = &gt_RxPathGainPSDDescriptorTable_VR9_HYB_A_17M;
         // XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (END)
         // XDSLRTFW-402_VR9_VRX318_VDSL2_30MhzKl0Issue (START)
         if(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK)
         {
            // XDSLRTFW-402: In 30MHz mode kl0 is always reported as 0dB
            // XDSLRTFW-505: 30A DUPBO case , No connect at 450mts and poor US rates.
            pt_RxPathGainPSDDescriptorTable = &gt_RxPathGainPSDDescriptorTable_VRX518_NewHYB_ABJ_Dfe17Src35Afe35_30M;
         }
         // XDSLRTFW-402_VR9_VRX318_VDSL2_30MhzKl0Issue (END)
      }
   }

   //XDSLRTFW-2260 (Start)
   // Generating Combined tone index (start)
   // This module combines two gain compensation tables in a way that there would not be any duplicate breakpoints.
   // It uses linier interpolation to generate intermediate points if needed.
   // For example A and B are the two gain table and C is output table
   // Tone index of C = superset tone index of {A,B}
   // Gain values of C  = Linear interpolated combined gain of relevant tone index from {A,B}

   {  // don't remove this bracket

      if (gt_DsPsdCompensationTable.us_NumberOfTones)
      {
         FlagT ft_FailStateFlag = 0;

         // there must not be any duplicate ecremental order tone index in the compensation function
         for (i = 1 ; i <gt_DsPsdCompensationTable.us_NumberOfTones; i++)
         {
            if (gt_DsPsdCompensationTable.ut_PSDRecord[i-1].us_IndexOfTone >= gt_DsPsdCompensationTable.ut_PSDRecord[i].us_IndexOfTone)
            {
               ft_FailStateFlag = 1;
            }
         }
         if (ft_FailStateFlag)
         {
            EnterFailStates(E_CODE_RX_EXTERNAL_PSD_COMPENSATIOM_CONFIGURATION);
         }
      }

      // initialization
      ia = 0;
      ib = 0;
      ic = 0;

      us_sizeA = pt_RxPathGainPSDDescriptorTable->us_NumberOfTones;
      us_sizeB = gt_DsPsdCompensationTable.us_NumberOfTones;
      us_sizeC = us_sizeA+us_sizeB;

      while((ia < us_sizeA) && (ib < us_sizeB))
      {
         if (pt_RxPathGainPSDDescriptorTable->ut_PSDRecord[ia].us_IndexOfTone ==  gt_DsPsdCompensationTable.ut_PSDRecord[ib].us_IndexOfTone)
         {
            // avoid duplication, copy only one tone index in case of duplication in output table
            gt_DsPSDCompensationTableCombined.ut_PSDRecord[ic++].us_IndexOfTone = pt_RxPathGainPSDDescriptorTable->ut_PSDRecord[ia].us_IndexOfTone;
            ia++;
            ib++;
         }
         else if (pt_RxPathGainPSDDescriptorTable->ut_PSDRecord[ia].us_IndexOfTone < gt_DsPsdCompensationTable.ut_PSDRecord[ib].us_IndexOfTone)
         {
            gt_DsPSDCompensationTableCombined.ut_PSDRecord[ic++].us_IndexOfTone = pt_RxPathGainPSDDescriptorTable->ut_PSDRecord[ia].us_IndexOfTone;
            ia++;
         }
         else // A[ia] > B[ib]
         {
            gt_DsPSDCompensationTableCombined.ut_PSDRecord[ic++].us_IndexOfTone = gt_DsPsdCompensationTable.ut_PSDRecord[ib].us_IndexOfTone;
            ib++;
         }
      }

      if (ia >= us_sizeA)
      {
         while(ib <us_sizeB)
         {
            gt_DsPSDCompensationTableCombined.ut_PSDRecord[ic++].us_IndexOfTone = gt_DsPsdCompensationTable.ut_PSDRecord[ib++].us_IndexOfTone;;
         }
      }
      if (ib >= us_sizeB )
      {
         while (ia < us_sizeA)
         {
            gt_DsPSDCompensationTableCombined.ut_PSDRecord[ic++].us_IndexOfTone = pt_RxPathGainPSDDescriptorTable->ut_PSDRecord[ia++].us_IndexOfTone;;
         }
      }
      // Generating Combined tone index (end)

      gt_DsPSDCompensationTableCombined.us_NumberOfTones = ic; // finnal number of brakpoints
      //******************************************************************************************/

      // Find combined PSD compensation value
      // Calculate  PSD compensation from pt_RxPathGainPSDDescriptorTable
      for (ic = 0; ic <gt_DsPSDCompensationTableCombined.us_NumberOfTones; ic++)
      {
         int16 s_ToneIdx;
         int16 s_attenLevel;

         s_ToneIdx= gt_DsPSDCompensationTableCombined.ut_PSDRecord[ic].us_IndexOfTone;

         // calculate PSD compensation value from pt_RxPathGainPSDDescriptorTable
         {  // don't remove this bracket
            PSDRecord_t *pt_PSDRec;
            pt_PSDRec = &(pt_RxPathGainPSDDescriptorTable->ut_PSDRecord[0]);

            /* Identify the PSDRecord_t[] band within which the tone lies */
            for (i=0; i < pt_RxPathGainPSDDescriptorTable->us_NumberOfTones; i++)
            {
               if (pt_RxPathGainPSDDescriptorTable->ut_PSDRecord[i].us_IndexOfTone >= s_ToneIdx)
               {
                  break;
               }
            }
            /* Get the adjacent breakpoints given breakpoint index */
            GetAdjacentBreakpts(i, pt_RxPathGainPSDDescriptorTable->us_NumberOfTones, pt_PSDRec, 0, (int16)(gs_RxNumTones-1),
                                &s_leftToneIdx, &s_leftToneAttenLevel, &s_rightToneIdx, &s_rightToneAttenLevel);

            /* Compute attenuation level given tone index and adjacent breakpoints */
            s_attenLevel = CalcAttenLevel(gt_DsPSDCompensationTableCombined.ut_PSDRecord[ic].us_IndexOfTone, s_leftToneIdx, s_leftToneAttenLevel, s_rightToneIdx, s_rightToneAttenLevel);
         }

         // calculate PSD compensation value from gt_DsPsdCompensationTable
         if(gt_DsPsdCompensationTable.us_NumberOfTones > 0)
         {
            PSDCompRecord_t *pt_PSDRec;
            pt_PSDRec = &(gt_DsPsdCompensationTable.ut_PSDRecord[0]);


            /* Identify the PSDRecord_t[] band within which the tone lies */
            for (i=0; i < gt_DsPsdCompensationTable.us_NumberOfTones; i++)
            {
               if (gt_DsPsdCompensationTable.ut_PSDRecord[i].us_IndexOfTone >= s_ToneIdx)
               {
                  break;
               }
            }
            /* Get the adjacent breakpoints given breakpoint index */
            GetAdjacentBreakpts2(i, gt_DsPsdCompensationTable.us_NumberOfTones, pt_PSDRec, 0, (int16)(gs_RxNumTones-1),
                                 &s_leftToneIdx, &s_leftToneAttenLevel, &s_rightToneIdx, &s_rightToneAttenLevel);

            // Input PSD data (CNFG 87) is value*10 format. the data is converted to 8.8 format. To do so data has to multiply by 25.6.
            // Due to Fixed point HW architechture the value is multiplied by 26 which leads small error!
            s_leftToneAttenLevel = s_leftToneAttenLevel*26;
            s_rightToneAttenLevel = s_rightToneAttenLevel*26;

            /* Compute attenuation level given tone index and adjacent breakpoints */
            s_attenLevel += CalcAttenLevel(gt_DsPSDCompensationTableCombined.ut_PSDRecord[ic].us_IndexOfTone, s_leftToneIdx, s_leftToneAttenLevel, s_rightToneIdx, s_rightToneAttenLevel);
         }
         gt_DsPSDCompensationTableCombined.ut_PSDRecord[ic].s_PSDLevelOfTone = s_attenLevel; // final combined gain in dB 8.8 format
      }
   }

   if ( (gs_frame_rate_is_8khz) && (gft_Ena_30MHzCompTableModify))  //XDSLRTFW-4052 XDSLRTFW-4064
   {
      //Combined compensation table uses 4.3125KHz Tone spacing
      //In 30M mode, this portion of the code convert 4.3125 tone spacing to 8.625Khz tone spacing ie. Multiply tone index by 0.5
      //  To do so, if tone numbers are getting duplicated then increase the tone index by one.
      gt_DsPSDCompensationTableCombined.ut_PSDRecord[0].us_IndexOfTone = gt_DsPSDCompensationTableCombined.ut_PSDRecord[0].us_IndexOfTone >> gs_frame_rate_is_8khz;

      for (ic = 1 ; ic < gt_DsPSDCompensationTableCombined.us_NumberOfTones; ic++ )
      {
         gt_DsPSDCompensationTableCombined.ut_PSDRecord[ic].us_IndexOfTone = (gt_DsPSDCompensationTableCombined.ut_PSDRecord[ic].us_IndexOfTone) >> gs_frame_rate_is_8khz;
         if (gt_DsPSDCompensationTableCombined.ut_PSDRecord[ic].us_IndexOfTone <= gt_DsPSDCompensationTableCombined.ut_PSDRecord[ic-1].us_IndexOfTone )
         {
            gt_DsPSDCompensationTableCombined.ut_PSDRecord[ic].us_IndexOfTone = gt_DsPSDCompensationTableCombined.ut_PSDRecord[ic-1].us_IndexOfTone +1;
         }
      }
   }
   //XDSLRTFW-2260 (End)


   s_BpIdx = 0;
   for (i = 0; i < gs_RxNumTones; i++)
   {
      //XDSLRTFW-2260 (Start)
      /* Get the adjacent breakpoints given breakpoint index */
      {  // don't remove this bracket
         // XDSLRTFW-2340
         // Get the breakpoints adjacent to the current tone
         PSDCompRecord_t *pt_PSDRec;
         pt_PSDRec = &(gt_DsPSDCompensationTableCombined.ut_PSDRecord[0]);

         /* Identify the PSDRecord_t[] band within which the tone lies */
         for (s_BpIdx=0; s_BpIdx < gt_DsPSDCompensationTableCombined.us_NumberOfTones; s_BpIdx++)
         {
            if (gt_DsPSDCompensationTableCombined.ut_PSDRecord[s_BpIdx].us_IndexOfTone >= i)
            {
               break;
            }
         }
         GetAdjacentBreakpts2(s_BpIdx, gt_DsPSDCompensationTableCombined.us_NumberOfTones, pt_PSDRec, 0, (int16)(gs_RxNumTones-1),
                              &s_leftToneIdx, &s_leftToneAttenLevel, &s_rightToneIdx, &s_rightToneAttenLevel);
      }
      //XDSLRTFW-2260 (End)

      // Compute RX path gain (dB Q8.8 format) by interpolating between adjacent breakpoints
      // Reuse the PSD interpolation routine
      s_RxPathAtten = CalcAttenLevel(i, s_leftToneIdx, s_leftToneAttenLevel, s_rightToneIdx, s_rightToneAttenLevel);

      // Remove RX path shaping from the measured PSD
      gsa_ELE_Tmp[i] = s_RxPathAtten;
      //gs_StreamComp[i] = s_RxPathAtten;

   } //for (i = 0; i < gs_RxNumTones; i++)
}
// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)

void ApplyRxPathPsdCorrection(int16 *psa_PsdIn, int16 *psa_PsdOut, int16 hlogFlag)
{
   // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)
   int8 c_fdq_exp;
   int16 i;
   int16 s_tmp_fdq_db;
   int32 l_fdq_re,l_fdq_im;
   int32 tmp_fdq;

   for (i = 0; i < gs_RxNumTones; i++)
   {
      // XDSLRTFW-3935 Wrong Hlog reporting
      // Calculate an equivalent of the receive PSD based on the FDQ coefficients
      if ( (hlogFlag == TRUE) && (i < NUM_OF_TONES_FDQ_BASED_HLOG) )
      {
         // FdqPSD[i] = -20*log10(abs(fdq[i]))     abs(fdq[i]) = (re[i]^2+im[i]^2)^-(1/2)
         // FdqPSD[i] = -10*log10(re[i]^2+im[i]^2)-2*exp[i]*10*log10(2)
         l_fdq_re = gt_ChDisc_Fdq.sa_FdqMantissa[i<<1];
         l_fdq_im = gt_ChDisc_Fdq.sa_FdqMantissa[(i<<1)+1];
         c_fdq_exp = gt_ChDisc_Fdq.uca_FdqExponent[i];

         // calc re^2+im^2
         // Q1.15 * Q1.15 = Q2.30
         l_fdq_re = (l_fdq_re * l_fdq_re);
         l_fdq_im = (l_fdq_im * l_fdq_im);
         tmp_fdq=(l_fdq_re+l_fdq_im);

         // calc 10*log10(abs(fdq))
         s_tmp_fdq_db = ConvertToDB(tmp_fdq);
         //                   adjust by 90 due to Q32.0 -> Q2.30
         s_tmp_fdq_db = -(s_tmp_fdq_db-(90<<8)+((2*c_fdq_exp*3)<<8));
         // compensate the factor of 8192 between fdq signal and receive signal representation (2^13) i.e. 81dB
         // 0.5dB is correction factor of multiple simplifications e.g. 3dB instead of 3.0103
         s_tmp_fdq_db += 20864; //(81<<8 + 0.5<<8);

         psa_PsdOut[i]=  s_tmp_fdq_db;
         // XDSLRTFW-3935 End
      }
      else
      {
         psa_PsdOut[i] = psa_PsdIn[i];
      }

      if (!gft_DisableCompensationTable)
      {
         psa_PsdOut[i] += gsa_ELE_Tmp[i];
      }
   } //for (i = 0; i < gs_RxNumTones; i++)

   if(hlogFlag)
   {
      int16 s_psd;
      PSDDescriptorTable_t *pt_PSDDesc;

      pt_PSDDesc = (PSDDescriptorTable_t*)(void *)&gt_DsREFPSDDescriptorTable;

      for (i = 0; i < gs_RxNumTones; i++)
      {
         // XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (START)
         // We consider in-band active RX tones only.
         if (!IS_TONEFLAGSET(guca_RxSupportedToneSet_Aelem,i))
         {
            continue;
         }
         // XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (END)

         // Get the psd level wrt MaxNomPsd (the tx psd)
         s_psd = GetTonePsd(i, pt_PSDDesc, gs_RxNumTones);//XDSLRTFW-3838



         // Subtract this psd level from measured RX psd to remove effect of shaping
         // (Note the real psd value is MaxNomPsd - psd.
         // the channel loss = TX_PSD(f) - RX_PSD(f) = (MaxNomPsd - psd_tx) - (MaxNomPsd - psd_rx)
         // psd_rx - psd_tx, where psd_rx = t_PsdAnalysisInput.psa_Psd, and psd_tx = s_psd computed above.)
         psa_PsdOut[i] -= ((s_psd<<8)/10);

         // XDSLRTFW-1461 and 1449
         // Compensated PSD also copy to Psd Analysis Buffer for processing Bridge Taps
         gsa_PsdAnalysis_out[i] = psa_PsdOut[i];

      } //for (i = 0; i < gs_RxNumTones; i++)
   }

} //ApplyRxPathPsdCorrection()
// XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)




/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: To improve kl0 estimate when bridge taps present, detect
 *               whether psd has nulls. If nulls are found, replace the
 *               lowest band's psd with a piece-wise linear fit to its
 *               local maxima.  Essentially attempts to fill
 *               in the nulls created by the bridge taps.
 *               If psd is monotonic (no nulls), don't replace it.
 *
 *  Prototype: void PsdPreProc_kl0_bridgetaps(int16 *psa_Psd,int16 j_start)
 *
 *  Input Arguments:
 *              int16 *psa_Psd: pointer to psd data
 *              int16 j_start:  first tone used in kl0 estimation
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *------------------------------------------------------------------------
 *^^^
 */

#define NMAX            (6)
#define NWINDOW_WIDTH  (10)            //averaging window width
#define NMIN_WIN_VALS   (4)            //min #psd points within window that are in
//supportedset for kl0 to use the average
#define INFLECTION_THRESH (int16)(1.5*256)      //min delta to declare the maxima/minima occures
#define LAST_POINT_INFLECTION_THRESH (int16)(0.2*256)   //threshold for declaring the last minima
#define TURNING_POINT_THRESH (2<<8)      //threshold for declare the turning point
#define NULL_WIN_THRESH (1)            //number of consecutive empty windows (NWINDOW_WIDTH wide)
//to declare min when next window with NMIN_WIN_VALS is detected
//#define KL0_DBG_BLD


#ifdef KL0_DBG_BLD
int16 sa_psdmax[NMAX+1];      //array to hold local maxima of psd points
int16 sa_tonemax[NMAX+1];     //array to hold indices of the local maxima
int16 sa_psdmin[NMAX+1];      //array to hold local maxima of psd points
int16 sa_tonemin[NMAX+1];     //array to hold indices of the local maxima
int16 s_indmax = 0;           //number of maxima found
int16 s_indmin = 0;           //number of minima found

int16 *gpsa_Psd_before = (int16 *)(0x60000);
int16 *gpsa_Psd_after  = (int16 *)(0x62000);
uint8 *gpuca_RxSupportedToneSet_temp = (uint8 *)(0x64000);



#endif //#ifdef KL0_DBG_BLD

void PsdPreProc_kl0_bridgetaps(int16 *psa_Psd,int16 j_start, int16 s_band_indx)
{

#ifndef KL0_DBG_BLD
   int16 sa_psdmax[NMAX+1];      //array to hold local maxima of psd points
   int16 sa_tonemax[NMAX+1];     //array to hold indices of the local maxima
   int16 sa_psdmin[NMAX+1];      //array to hold local maxima of psd points
   int16 sa_tonemin[NMAX+1];     //array to hold indices of the local maxima
   int16 s_indmax = 0;           //number of maxima found
   int16 s_indmin = 0;           //number of minima found
#endif //#ifndef KL0_DBG_BLD

   int16 s_emptywin_count = 0;       //null window counter

   int32 l_acc_psd;
   int32 l_psd_ref = 0;
   int32 l_psd_ref1 = 0;
   int32 l_psd_pre = -1;
   int16 s_index_psd_ref=0, s_numval_in_window;
   int16 s_index_psd_ref1=0;
   int16 s_max_or_min_found = 0;
   int16 s_max_or_min_search = 0;    //0=looking for max; 1=looking for min

   int16 s_psd_slope;
   int16 s_psd_PreSlope = 0x7FFF;
   int16 s_psd_MaxSlopeChange = 0;

   int16 s_last_max_or_min_found = 0;
   int16 s_index_psd_last_point=0;

   int16 i,istart,j,jmin,jmax;
   int16 s_intercept;
   int32 l_slope;

#ifdef KL0_DBG_BLD
//save PSD before preprocessing
   memcpy(gpsa_Psd_before, psa_Psd, (4096*2));
   memcpy(gpuca_RxSupportedToneSet_temp, guca_RxSupportedToneSet_temp, 512);
#endif

   //search for up to NMAX maxima and minima using a stepping window of width NWINDOW_WIDTH and
   //requiring a change of INFLECTION_THRESH to declare an inflection point (NWINDOW_WIDTH and
   //INFLECTION_THRESH "average" out minor transitions and some unused bins)
   i = j_start;
   while ( (i <= (gsa_RxBandRightChannel[s_band_indx]-NWINDOW_WIDTH)) && (s_indmax<NMAX) && (s_indmin<NMAX) )
   {
      while ((i <= (gsa_RxBandRightChannel[s_band_indx]-NWINDOW_WIDTH)) && (s_max_or_min_found == 0))
      {
         l_acc_psd = 0;
         s_numval_in_window = 0;
         istart=i;
         for (j=istart; j<(istart+NWINDOW_WIDTH); j++)
         {
            if (IS_TONEFLAGSET(guca_RxSupportedToneSet_temp,j))
            {
               l_acc_psd += psa_Psd[j];
               s_numval_in_window++;
            }
         }

         if(s_numval_in_window > 0)
         {
            l_acc_psd = l_acc_psd/s_numval_in_window;
         }
         else
         {
            l_acc_psd = 0;
         }

         if (s_numval_in_window>NMIN_WIN_VALS)
         {
            //To handle case where all the points that would have indicated
            //a null were not used because the SNRs were too low to include in
            //guca_RxSupportedToneSet_temp:  if we had a large dropout just
            //before the current window-qualified value, make this value the
            //current reference and switch to looking for a max
            if (s_emptywin_count >= NULL_WIN_THRESH)
            {
               if(s_max_or_min_search == 1)
               {
                  l_psd_ref = 0;
                  s_index_psd_ref = i - (s_emptywin_count*NWINDOW_WIDTH)/2;

                  sa_tonemin[s_indmin] = s_index_psd_ref;
                  sa_psdmin[s_indmin] = l_psd_ref;
                  s_indmin++;

                  //Next one to search for maxima
                  s_max_or_min_search = 0;
               }

               s_emptywin_count = 0;

               //Reset other variables due to this break
               l_psd_pre = -1;
               s_last_max_or_min_found = 0;
               s_psd_MaxSlopeChange = 0;
               s_psd_PreSlope = 0x7FFF;

            } //if ((s_emptywin_count > 0)

            if (s_max_or_min_search == 0)          //if looking for max
            {
               if (l_acc_psd > l_psd_ref)
               {
                  l_psd_ref = l_acc_psd;
                  s_index_psd_ref = i + NWINDOW_WIDTH;
                  if(psa_Psd[i] > psa_Psd[s_index_psd_ref])
                  {
                     s_index_psd_ref = i;
                  }
               }

               //Declare a maxima is found if the current PSD decreased from its peak
               //by the specified amount (INFLECTION_THRESH)
               if((l_psd_ref - l_acc_psd) > INFLECTION_THRESH)
               {
                  s_max_or_min_found = 1;
               }

               //if the maxima occurs at the band end, it may not show as much decline as it is in
               //the middle of the band so we choose a different threshold for band edge peak detection
               else if((l_psd_ref - l_acc_psd) > LAST_POINT_INFLECTION_THRESH)
               {
                  s_last_max_or_min_found = 1;
                  s_index_psd_last_point = i + NWINDOW_WIDTH;
               }
            }
            else                                 //else we are looking for a min
            {
               if (l_acc_psd < l_psd_ref)
               {
                  l_psd_ref = l_acc_psd;
                  s_index_psd_ref = i + NWINDOW_WIDTH/2;
                  if(psa_Psd[i] < psa_Psd[s_index_psd_ref])
                  {
                     s_index_psd_ref = i;
                  }
               }
               else
               {
                  //Declare a minima is found if the current PSD increased from its valley
                  //by the specified amount (INFLECTION_THRESH)
                  if((l_acc_psd - l_psd_ref) > INFLECTION_THRESH)
                  {
                     s_max_or_min_found = 1;
                  }

                  //if the minima occurs at the end, it may not show as much increase as it is in
                  //the middle of the band so we choose a different threshold for band edge valley detection
                  else if((l_acc_psd - l_psd_ref) > LAST_POINT_INFLECTION_THRESH)
                  {
                     s_last_max_or_min_found = -1;
                     s_index_psd_last_point = i + NWINDOW_WIDTH/2;
                  }
               }

               //Check if there is a valley at the band end by looking for the turning point
               if (l_psd_pre > 0)
               {
                  s_psd_slope = l_psd_pre - l_acc_psd;

                  //Compute the sleep change
                  if(s_psd_PreSlope != 0x7FFF)
                  {
                     jmax = s_psd_slope - s_psd_PreSlope;

                     //Store the point where the biggest slope change occurs
                     if(jmax > s_psd_MaxSlopeChange)
                     {
                        s_psd_MaxSlopeChange = jmax;

                        l_psd_ref1 = l_acc_psd;
                        s_index_psd_ref1 = i + NWINDOW_WIDTH/2;
                     }
                  }

                  //Update the previous slope
                  s_psd_PreSlope = s_psd_slope;
               }
            } //if (s_max_or_min_search == 0) else
         } //if (s_numval_in_window>NMIN_WIN_VALS)
         else
         {
            s_emptywin_count++;
         }

         i += NWINDOW_WIDTH;
         l_psd_pre = l_acc_psd;

      } //while ((i <= gsa_RxBandRightChannel[0]) && (s_max_or_min_found==0))


      if (s_max_or_min_found == 1)
      {
         if (s_max_or_min_search == 0)          //if looking for max
         {
            sa_tonemax[s_indmax] = s_index_psd_ref;
            sa_psdmax[s_indmax] = l_psd_ref;
            s_indmax++;
         }
         else                                 //else we were looking for a min
         {
            sa_tonemin[s_indmin] = s_index_psd_ref;
            sa_psdmin[s_indmin] = l_psd_ref;
            s_indmin++;
         }

         // toggle to search for the other type of extrema
         s_max_or_min_search = (s_max_or_min_search+1) & 0x1;
         s_max_or_min_found = 0;

         l_psd_pre = -1;
         s_last_max_or_min_found = 0;
         s_psd_MaxSlopeChange = 0;
         s_psd_PreSlope = 0x7FFF;

      } //if (s_max_or_min_found)

   } //while ( (i <= (gsa_RxBandRightChannel[0]-NWINDOW_WIDTH)) && (s_indmax<NMAX) && (s_indmin<NMAX) )


   //Decide if there is a maxima at the end
   if((s_max_or_min_search == 0) && (s_indmin > 0))
   {

      if((s_last_max_or_min_found == 1) && (s_index_psd_last_point >= s_index_psd_ref))
      {
         sa_tonemax[s_indmax] = s_index_psd_ref;
         sa_psdmax[s_indmax] = l_psd_ref;
         s_indmax++;
      }
   } //if((s_max_or_min_search == 0) && (s_indmin > 0))

   //Decide if there is a minima at the end
   if((s_max_or_min_search == 1) && (s_indmax > 0))
   {
      if((s_last_max_or_min_found == -1) && (s_index_psd_last_point >= s_index_psd_ref))
      {
         sa_tonemin[s_indmin] = s_index_psd_ref;
         sa_psdmin[s_indmin] = l_psd_ref;
         s_indmin++;
      }
      //If the slope change is greater than the threshold, also declare it as a notch
      else if(s_psd_MaxSlopeChange > TURNING_POINT_THRESH)
      {
         sa_tonemin[s_indmin] = s_index_psd_ref1;
         sa_psdmin[s_indmin] = l_psd_ref1;
         s_indmin++;
      }

   } //if((s_max_or_min_search == 1) && (s_indmax > 0))

   // replace the psd only if at least one minimum was found
   // (if no minima found, then psd was monotonic -- no modification will be applied)
   if (s_indmin > 0)
   {
      //If the last point is a maxima, find another minima to perform extrapolation
      if(sa_tonemax[s_indmax-1] > sa_tonemin[s_indmin-1])
      {
         //Find the last valid tone group
         i = gsa_RxBandRightChannel[s_band_indx]-NWINDOW_WIDTH;
         s_index_psd_ref = 0;
         while(i > (sa_tonemax[s_indmax-1]+NWINDOW_WIDTH))
         {
            l_acc_psd = 0;
            s_numval_in_window = 0;
            istart=i;
            for (j=istart; j<(istart+NWINDOW_WIDTH); j++)
            {
               if (IS_TONEFLAGSET(guca_RxSupportedToneSet_temp,j))
               {
                  s_numval_in_window++;
                  l_acc_psd += psa_Psd[j];
               }
            }

            if (s_numval_in_window>NMIN_WIN_VALS)
            {
               l_psd_ref = l_acc_psd/s_numval_in_window;
               s_index_psd_ref = i;
               break;
            }

            i -= NWINDOW_WIDTH;
         }

         //If the PSD of the last point is 3 dB below its previous maxima
         //then add the last point to the minima list
         if((s_index_psd_ref > 0) && ((sa_psdmax[s_indmax-1] - l_psd_ref) > (3<<8)))
         {
            sa_tonemin[s_indmin] = s_index_psd_ref;
            sa_psdmin[s_indmin] = l_psd_ref;
            s_indmin++;
         }
      } //if(sa_tonemax[s_indmax-1] > sa_tonemin[s_indmin-1])


      //If the last point is a minima
      //we want to find another maxima from the last maxima to the last minima
      //so we can perform extrapolation
      if(sa_tonemax[s_indmax-1] < sa_tonemin[s_indmin-1])
      {
         //Decide the range to search if the last one is minima
         jmin = sa_tonemax[s_indmax-1] + NWINDOW_WIDTH;
         jmax = sa_tonemin[s_indmin-1] - NWINDOW_WIDTH;

         //Find the turning point by searching for the maximum change of the slope
         l_psd_ref = 0;
         l_psd_pre = -1;

         s_psd_PreSlope = 0x7FFF;
         s_psd_MaxSlopeChange = 0;

         i = jmin;
         while ( (i < jmax) && (IS_TONEFLAGSET(guca_RxSupportedToneSet_temp,i)))
         {
            l_acc_psd = 0;
            s_numval_in_window = 0;
            istart=i;

            for (j=istart; j<(istart+NWINDOW_WIDTH); j++)
            {
               l_acc_psd += psa_Psd[j];
               s_numval_in_window++;
            }

            if (s_numval_in_window>NMIN_WIN_VALS)
            {
               l_acc_psd = l_acc_psd/s_numval_in_window;
            }
            else
            {
               l_acc_psd = 0;
            }

            if(l_psd_pre > 0)
            {
               //Compute the slope (between two adjancent tones)
               s_psd_slope = l_psd_pre - l_acc_psd;

               //Compute the slope change between two adjacent tones
               if(s_psd_PreSlope != 0x7FFF)
               {
                  j = s_psd_slope - s_psd_PreSlope;
                  if(j > s_psd_MaxSlopeChange)
                  {
                     s_psd_MaxSlopeChange = j;
                     s_index_psd_ref = i;
                  }
               }

               s_psd_PreSlope = s_psd_slope;
            }

            l_psd_pre = l_acc_psd;
            i += NWINDOW_WIDTH;
         } //while ( (i < jmax) &&

         //Pick the search start point
         if(s_psd_MaxSlopeChange > TURNING_POINT_THRESH)
         {
            i = jmin + ((s_index_psd_ref - jmin)>>1);
         }
         else
         {
            i = jmin + ((jmax - jmin)>>1);
         }

         //Find the highest value between jmin and jmax
         l_psd_ref = 0;
         while ( (i < jmax) && (IS_TONEFLAGSET(guca_RxSupportedToneSet_temp,i)))
         {
            l_acc_psd = 0;
            s_numval_in_window = 0;
            istart=i;

            for (j=istart; j<(istart+NWINDOW_WIDTH); j++)
            {
               l_acc_psd += psa_Psd[j];
               s_numval_in_window++;
            }

            if (s_numval_in_window>NMIN_WIN_VALS)
            {
               l_acc_psd = l_acc_psd/s_numval_in_window;

               if(l_acc_psd > l_psd_ref)
               {
                  l_psd_ref = l_acc_psd;
                  s_index_psd_ref = i + NWINDOW_WIDTH;
               }

            }
            i += NWINDOW_WIDTH;
         }

         if(l_psd_ref > 0)
         {
            sa_tonemax[s_indmax] = s_index_psd_ref;
            sa_psdmax[s_indmax] = l_psd_ref;
            s_indmax++;
         }

      } //if(s_indmax == 1)
      // Disable the code ,
      if((s_indmax > 1)&& (gft_Enable_psdpreproc_kl0 == TRUE))        // XDSLRTFW-4052(Start_End)
      {
         gs_Kl0PreProcDone |= (1 << s_band_indx);

         // create an output psd modification from the piecewise linear segments
         for (i=0; i<(s_indmax-1); i++)
         {

            //generate s_slope in units of 1/128 (2**7); close to 100
            l_slope = ((sa_psdmax[i+1]-sa_psdmax[i])<<7)/(sa_tonemax[i+1]-sa_tonemax[i]);
            s_intercept = sa_psdmax[i] - ((l_slope*sa_tonemax[i])>>7);
            jmin = sa_tonemax[i];
            jmax = sa_tonemax[i+1];

            if (jmax==sa_tonemax[s_indmax-1])
            {
               jmax = gsa_RxBandRightChannel[s_band_indx];
            }
            for (j=jmin; j <=jmax; j++)
            {
               //XDSLRTFW-1461 and 1449
               //Do not disturb the PSD Buffer
               //For HLOG, in case of Bridge Taps, we use PSD Buffer
               //psa_Psd[j] = ((j*l_slope)>>7) + s_intercept;
               gsa_PsdAnalysis_out[j] = ((j*l_slope)>>7) + s_intercept;
               //XDSLRTFW-1461 and 1449
            }
         }

      } //if(s_indmax > 1)
      // XDSLRTFW-4052(Start)

   } //if (s_indmin > 0)


#ifdef KL0_DBG_BLD
//save PSD after preprocessing
   memcpy(gpsa_Psd_after, psa_Psd, (4096*2));
#endif

}
// XDSLRTFW-481_VR9_VRX318_VDSL2_Kl0AccuracyIssue (START)
void InterpolateRFIBands(int16 *psa_Psd, int16 startTone, int16 endTone, int16 extTone, int16 extFlag)
{
   int16 j,jmin,jmax;
   int16 s_intercept, i=0, toneMax1, toneMax2;
   int32 l_slope;

   switch(extFlag)
   {
      //Starting tones of RFI band blacked out
   case 1:
      toneMax1 = endTone;
      toneMax2 = extTone;
      break;

      //End tones of RFI band blacked out
   case 2:
      toneMax1 = startTone;
      toneMax2 = extTone;
      break;

      //Regular case
   default:
      toneMax1 = startTone;
      toneMax2 = endTone;
      break;
   }
   if( (IS_TONEFLAGSET(guca_RxSupportedToneSet_temp,toneMax1)) &&
         (IS_TONEFLAGSET(guca_RxSupportedToneSet_temp,toneMax2)) )
   {
      //generate s_slope in units of 1/128 (2**7); close to 100
      l_slope = ((psa_Psd[toneMax2]-psa_Psd[toneMax1])<<7)/(toneMax2 - toneMax1);
      s_intercept = psa_Psd[toneMax1] - ((l_slope*toneMax1)>>7);

      jmin = startTone;
      jmax = endTone;
      for (j=jmin; j <=jmax; j++)
      {
         psa_Psd[j] = ((j*l_slope)>>7) + s_intercept;
      }
   }
}

void SearchBestBinRFIBand(int16 *psa_Psd, int16 *start_bin,
                          int16 *end_bin, int16 *ext_bin, int16 *ext_flag,
                          int16 s_rfiband_indx, int16 s_band_idx, int16 window_len)
{
   int16 i;
   int16 rfiLeftBin = gsa_RFIBandLeftChannel[s_rfiband_indx];
   int16 rfiRightBin = gsa_RFIBandRightChannel[s_rfiband_indx];
   int16 snrBest, ext;

   *start_bin = rfiLeftBin - window_len;
   *end_bin = rfiRightBin + window_len;
   *ext_bin = rfiRightBin + window_len*2;

   //Identify Cornor cases
   //Check if the Start Bin Identified less than Band Start
   if(*start_bin < gsa_RxBandLeftChannel[s_band_idx])
   {
      *start_bin = gsa_RxBandLeftChannel[s_band_idx] + window_len;
      *ext_flag = 1;
   }
   //Check if the End Bin Identified greater than Band end
   if(*end_bin > gsa_RxBandRightChannel[s_band_idx])
   {
      *end_bin = gsa_RxBandRightChannel[s_band_idx] - window_len;
      *ext_flag = 2;
   }

   //Best SNR Bin Search  between RFI Start Bin and 30 Bins(Window) Lower
   snrBest = psa_Psd[rfiLeftBin];
   for (i=rfiLeftBin; i>=(rfiLeftBin - window_len); i--)
   {
      if(psa_Psd[i] > snrBest)
      {
         snrBest = psa_Psd[i];
         *start_bin = i;
      }
   }
   //XDSLRTFW-1206 : BUG_DS_ALL_ALL_DTAG_RFI
   //Make sure before interpolation the selected bin is part of Good SNR bins
   //If not negate by 1
   if(!IS_TONEFLAGSET(guca_RxSupportedToneSet_temp,*start_bin))
   {
      *start_bin -= 1;
   }

   //Best SNR Bin Search between RFI End Bin and 30 Bins(Window) Higher
   snrBest = psa_Psd[rfiRightBin];
   for (i=rfiRightBin; i<=(rfiRightBin + window_len); i++)
   {
      if(psa_Psd[i] > snrBest)
      {
         snrBest = psa_Psd[i];
         *end_bin = i;
      }
   }
   //XDSLRTFW-1206 : BUG_DS_ALL_ALL_DTAG_RFI
   //Make sure before interpolation the selected bin is part of Good SNR bins
   //If not add 1
   if(!IS_TONEFLAGSET(guca_RxSupportedToneSet_temp,*end_bin))
   {
      *end_bin += 1;
   }

   //In case RFI Band blackouts all the initial tones of the Band
   // Select another tone extended from the end tone for interpolation
   if(*ext_flag == 1)
   {
      //*start_bin = gsa_RxBandLeftChannel[s_band_idx];
      *start_bin = gsa_RxBandLeftChannel[s_band_idx];
      ext = *end_bin + 5;

      *ext_bin = ext;
      snrBest = psa_Psd[ext];
      for (i=ext; i<=(ext + window_len); i++)
      {
         if(psa_Psd[i] > snrBest)
         {
            snrBest = psa_Psd[i];
            *ext_bin = i;
         }
      }
   }
   //In case RFI Band blackouts all the end tones of the Band
   //Select another tone extended from the start tone for interpolation
   else if(*ext_flag == 2)
   {
      *end_bin = gsa_RxBandRightChannel[s_band_idx];
      ext = *start_bin - 5;
      *ext_bin = ext;
      snrBest = psa_Psd[ext];
      for (i=ext; i>=(ext - window_len); i--)
      {
         if(psa_Psd[i] > snrBest)
         {
            snrBest = psa_Psd[i];
            *ext_bin = i;
         }
      }
   }
}

void PreProcRFIBands(int16 *psa_Psd)
{
   int16 start_bin, end_bin, ext_bin, window_len = 30, ext_flag;
   int16 s_band_indx, s_rfiband_indx;

   for (s_band_indx = 0; s_band_indx < gs_NumOfRxBands; s_band_indx++)
   {
      for (s_rfiband_indx = 0; s_rfiband_indx < gs_NumOfRFIBands; s_rfiband_indx++)
      {
         if ( (gsa_RFIBandRightChannel[s_rfiband_indx] <= gsa_RxBandRightChannel[s_band_indx]) &&
               (gsa_RFIBandLeftChannel[s_rfiband_indx] >= (gsa_RxBandLeftChannel[s_band_indx]-10)) )
         {
            gs_RFIBand = gs_RFIBand | (1 << s_band_indx);
         }
         else if ( (gsa_RFIBandRightChannel[s_rfiband_indx] <= gsa_RxBandRightChannel[s_band_indx]) &&
                   (gsa_RFIBandRightChannel[s_rfiband_indx] > (gsa_RxBandLeftChannel[s_band_indx])) )
         {
            gs_RFIBand = gs_RFIBand | (1 << s_band_indx);
         }
         ext_flag = 0;
         //Search for Bins to interpolate
         SearchBestBinRFIBand(psa_Psd, &start_bin, &end_bin, &ext_bin, &ext_flag,
                              s_rfiband_indx, s_band_indx, window_len);

         //Interpolate between two best bins on either end of RFI Band
         InterpolateRFIBands(psa_Psd, start_bin, end_bin, ext_bin, ext_flag);
      }
   }
}//PreProcRFIBands
//XDSLRTFW-980 DTAG_Schutzprofil (end)

// XDSLRTFW-3344 (Start)
void DMAtoSDRAM_PerTone(uint8 uc_Page)
{
   if (PollForCodeSwapDone(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, guc_OffChipRequestHandle) == SWAP_DONE)
   {
      if (uc_Page == HLOG_PERTONE)
      {
         gta_BAR15LookUpTable[OFF_CHIP_HLOG_PERTONE][OFF_CHIP_SOURCE_INDEX] = (int32)&gsa_RxHLog_PerTone_Internal;
         gta_BAR15LookUpTable[OFF_CHIP_HLOG_PERTONE][OFF_CHIP_DEST_INDEX] = (int32)&gsa_RxHLog_PerTone;
         gta_BAR15LookUpTable[OFF_CHIP_HLOG_PERTONE][OFF_CHIP_LENGTH_INDEX] = gs_RxNumTones << 1;

         FreeSwapHandle(&guc_OffChipRequestHandle);
         guc_OffChipRequestHandle = RequestSwapOffChip(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, SWAP_TIMING_OFF,OFF_CHIP_HLOG_PERTONE);
         gft_Swap_HLog_QLN_Offchip = FALSE;
      }
      else if (uc_Page == QLN_PERTONE)
      {
         gta_BAR15LookUpTable[OFF_CHIP_QLN_PERTONE][OFF_CHIP_SOURCE_INDEX] = (int32)&guca_QLN_PerTone_Internal;
         gta_BAR15LookUpTable[OFF_CHIP_QLN_PERTONE][OFF_CHIP_DEST_INDEX] = (int32)&guca_QLN_PerTone;
         gta_BAR15LookUpTable[OFF_CHIP_QLN_PERTONE][OFF_CHIP_LENGTH_INDEX] = gs_RxNumTones;

         FreeSwapHandle(&guc_OffChipRequestHandle);
         guc_OffChipRequestHandle = RequestSwapOffChip(VDSL_WRITE_DATA_TO_SRAM_DM_SWAPPAGE, SWAP_TIMING_OFF,OFF_CHIP_QLN_PERTONE);
         gft_Swap_HLog_QLN_Offchip = FALSE;
      }
   }
   else
   {
      gft_Swap_HLog_QLN_Offchip = TRUE;
   }
}
// XDSLRTFW-3344 (End)
