/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   PsdHandler.c
 *
 *   This file contains the routine that calculates Psd.
 *
 *------------------------------------------------------------------------
 */

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "psdhandler.h"
#include "psd_b.h"
#include "psd_b_hybtrn.h"
#include "fifo.h"
#include "noiseacc.h"
#include "IRI_Iof.h"
#include "dsp_op.h"
#include "ConvertToDB.h"
#include "PsdHandler_HybTrn.h"
#include "cmv.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : PsdHandler
 *
 *  Description:
 *
 *      This function is used to calculate the Psd of the received signal.
 *   It uses the NoiseAcc function, which typically is used to calculate the
 *  avg Squared error signal.  In this case, the received signal, rather than
 *   an error signal, is fed into NoiseAcc.  The result is an avg signal power,
 *   rather than an average error squared.
 *
 *   The PSD is calculated over all (gt_PsdConfig.s_LastChannel-1) tones.
 *
 *  Prototype:  void PsdHandler(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Return:
 *
 *  Global Variables Used:
 *      gs_AlgHandlerState       - (I/O) state of PSD calculation state machine
 *      gpla_RxAccumBuf[]      - (I/O) accumulated frames
 *
 *  Notes:
 *   Before PsdHandler() is called for the first time, the following initialization
 *  needs to be performed:
 *
 *      1) gs_AlgHandlerState = PSD_SETUP.
 *      2) gs_AlgNumFramesToAccum, gs_AlgLog2NumFramesToAccum must be set up
 *
 *------------------------------------------------------------------------
 *^^^
 */

void PsdHandler_HybTrn(void)
{
   switch(gs_AlgHandlerState)
   {
      //==============================================================================
      // initialize variables for PSD calculation
      //==============================================================================
   case PSD_INIT:

      gs_MaxRxTonePwr = (int16)(-100*256);
      gl_LinMaxRxTonePwr = 0x80000000; //Initialise to the minimum value
      gl_Pa  = 0;

      // Set RTV flag to read FFT output
      gs_RtvSelectLastFrame = RTV_NOTYPE;
      gs_RtvSelect = FFT_OUTPUT;

      gs_NumChannelsPerGroup = gt_PsdConfig.s_NumChannelsPerGroup;

      // Set start tone for PSD calculation
      // (default is 0-gs_RxNumTones)
      gs_LeftChannel = gt_PsdConfig.s_FirstChannel;
      gs_AlgHandlerState = PSD_SETUP;

      break;

      //==============================================================================
      // set up variables for PSD calculation in each group
      //==============================================================================
   case PSD_SETUP:

      gs_RightChannel = gs_LeftChannel + gs_NumChannelsPerGroup - 1;

      // Set RX tone offset to the start tone from which the HW should do the processing, i.e. RTV buffer 0.
      gs_RxToneOffset = gs_LeftChannel;
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, SetRxToneOffset);
      gs_AlgHandlerCount = 0;

      // Transition to accumulation substate
      gs_AlgHandlerState = PSD_WAIT_FOR_HW_SET;

      break;

      //==============================================================================
      // Wait for RTV buffer 0 HW settings to take effect
      //==============================================================================
   case PSD_WAIT_FOR_HW_SET:

      if(gs_AlgHandlerCount < gs_RTVxCfgLatency)
      {
         gs_AlgHandlerCount++;
      }
      else
      {

         // Prohibit copying Iridia buffer to gpsa_RxToneBuf.
         gft_EnableGetRxTones = FALSE;

//         if (gs_LeftChannel == 0)
         if ((gs_LeftChannel == 0) && (gs_PgaTrainingDbg & TEST_HP2_CONFIG_DC_TO_ZERO))
         {
            gpsa_RxToneBuf[0] = 0;
            gpsa_RxToneBuf[1] = 0;
         }
         // Calculate the PSD in background
         guc_PsdCalcState = TRAINING_IN_PROGRESS;

         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgPsdCalc_HybTrn);


//      if(gs_PauseControl == (0xC0 | gs_PgaHandlerRun))
//         Pause(gs_PauseControl);

         gs_AlgHandlerState = PSD_NEXT_TONEGROUP;
      }

      break;

      //==============================================================================
      // Update for next tonegroup (or goto finish)
      //==============================================================================
   case PSD_NEXT_TONEGROUP:
      if (guc_PsdCalcState == TRAINING_DONE)
      {
         // Enable back to copying Iridia buffer to gpsa_RxToneBuf.
         gft_EnableGetRxTones = TRUE;

         //If all the tones in this symbol has been processed
         if(gs_RightChannel == (gt_PsdConfig.s_LastChannel-1))
         {
            // restore the initial setting
            gs_RtvSelect = FFT_OUTPUT;
            gs_RtvSelectLastFrame = RTV_NOTYPE;

            gs_NumChannelsPerGroup = gs_NumChannelsPerGroupSave;

            gs_MaxRxTonePwr = sature16((int32)ConvertToDB(gl_LinMaxRxTonePwr));
            gs_AlgHandlerState = PSD_CALC_DONE;
         }
         //Continue to process the remaining tones
         else
         {
            gs_LeftChannel = gs_LeftChannel + gs_NumChannelsPerGroup;
            gs_AlgHandlerState = PSD_SETUP;
         }
      }
      break;
   }
}


