/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   QuickAverage.c
*
*   Subroutines for manipulating Bat and fine gains for g.992.3/g.992.5.
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "dsp_op.h"


/*^^^
*-------------------------------------------------------------------
*
*  int16 QuickAverage(int32 l_numerator, int16 s_denominator);
*
*   Description:
*      In bitloading there is a need to compute the average margin
*      (8.8 format) across all the subchannels. The total margin is
*      divided by the number of allocated channels. Returns the quotient in 8.8 format.
*
*   Input Arguments:
*      l_numerator -- total margin (in Q24.8)
*      l_denominator -- number of channels (in Q16.0)
*
*   Return:
*      quotient of l_numerator divided by denominator.
*
*-------------------------------------------------------------------
*^^^
*/

int16 QuickAverage(int32 l_numerator, int16 s_denominator)
{
   int16 s_exp1, s_exp2, r, s_quo_sign;
   int16 s_quot_mantissa, s_quot_exponent;

   /* Convert numerator, denominator to positive numbers if needed */
   if(l_numerator < 0)
   {
      s_quo_sign = (int16)0xffff;
      l_numerator = -l_numerator;
   }
   else
   {
      s_quo_sign = 0;   // 0x0000 indicates quotient >= 0, 0xffff indicates quo < 0.
   }

   if(s_denominator < 0)
   {
      s_quo_sign = ~s_quo_sign;
      s_denominator = -s_denominator;
   }

   /* Normalize the numerator */
   s_exp1 = -norm_l(l_numerator);
   l_numerator <<= -s_exp1;

   /* Normalize the denominator */
   s_exp2 = -norm_16bit(s_denominator);
   s_denominator <<= -s_exp2;


   r = Divide_32by16bit(l_numerator ,  s_exp1,
                        s_denominator, s_exp2,
                        &s_quot_mantissa, &s_quot_exponent
                       );

   if (r != 0)
   {
      return (0);
   }

   // We want the quotient to have the same exponent as the
   // numerator (zero), so adjust the mantissa to achieve this.

   s_quot_mantissa >>= -s_quot_exponent;   // Will check sign of s_quot_exponent below

   if (s_quot_exponent > 0)
      // Can't leftshift the normalized mantissa, so just saturate
   {
      s_quot_mantissa = 0x7fff;
   }

   /* Account for signs of numerator and denominator */
   if(s_quo_sign)
   {
      s_quot_mantissa = -s_quot_mantissa;
   }

   return(s_quot_mantissa);
}


