/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   File Name: ReorderTRT.c
;
;   This file contains the functions to reorder the TRT table for HW to use.
*****************************************************************************/
//#include <string.h>
#include "vdsl_compiler.h"
#include "sys_const.h"
#include "gdata.h"
#include "vdsl_xception.h"
#include "ToneReorder.h"
#include "LL_IOf.h"
#include "mul.h"
#include "cmv_Data.h"

#ifdef HW_TRT
#include "Bitload_support.h"
#endif

uint16 ReadTRT(int16 *ps_start, int16 *ps_end, int16 *ps_band);
void Unpack_TRT(FlagT ft_direction, int16 *psa_outbuf, int16 *ps_Num0bitTones, int16 *ps_Num1bitTones);
void ReorderTones(FlagT ft_direction, int16 *psa_toneorderTCM,int16 *psa_toneorderTCM_1bits, int16 *psa_toneorderTCM_above1bits);


void CalcBatStats(FlagT ft_direction, int16 *ps_Num0bitTones, int16 *ps_Num1bitTones, int32 *pl_SumBat)
{
   int16 s_NumOfBands;
   int16 *psa_BandLeftChannel;
   int16 *psa_BandRightChannel;
   int16 s_CurrentBand, s_LeftChannel, s_RightChannel, i;
   uint8 *puca_Bat;
   uint8 uc_bat;
   int16 s_Num0bitTones, s_Num1bitTones, s_numGT1BitTones;
   int32 l_SumBat;
   int16 s_TxNumTones;
   if (gs_RxNumTones > gs_TxNumTones)
      s_TxNumTones = gs_RxNumTones;
   else
      s_TxNumTones = gs_TxNumTones;

   if(ft_direction == TX)
   {
      s_NumOfBands = gs_NumOfTxBands;
      psa_BandLeftChannel = gsa_TxBandLeftChannel;
      psa_BandRightChannel = gsa_TxBandRightChannel;
      puca_Bat = ghpuca_TxBat_Inactive;
   }
   else //if(ft_direction == RX)
   {
      s_NumOfBands = gs_NumOfRxBands;
      psa_BandLeftChannel = gsa_RxBandLeftChannel;
      psa_BandRightChannel = gsa_RxBandRightChannel;
      puca_Bat = ghpuca_RxBat_Inactive;
   }

   s_Num0bitTones = s_Num1bitTones = s_numGT1BitTones = 0;
   l_SumBat = 0;

   for(s_CurrentBand = 0; s_CurrentBand < s_NumOfBands; s_CurrentBand++)
   {
      s_LeftChannel  = psa_BandLeftChannel[s_CurrentBand];
      s_RightChannel = psa_BandRightChannel[s_CurrentBand];

      for(i = s_LeftChannel; i <= s_RightChannel; i++)
      {
         uc_bat = puca_Bat[i];
         if(uc_bat == 0)
         {
            s_Num0bitTones++;
         }
         else if(uc_bat == 1)
         {
            s_Num1bitTones++;
         }

         else
         {
            s_numGT1BitTones++;
         }

         l_SumBat += uc_bat;
      }
   }

   *ps_Num0bitTones = s_Num0bitTones;
   *ps_Num1bitTones = s_Num1bitTones;
   *pl_SumBat = l_SumBat;

   //Set the parameters to configure HW
   {
      int16 s_tcm_2DSymbols, s_tcmMinZeroTones;

      gs_Tblcpy_Num0bit[ft_direction] = s_Num0bitTones;
      if(ft_direction == RX)
      {
         gs_Tblcpy_Num0bit[ft_direction] += RX_NUM_OUT_BAND_ZERO_BIT_TONE;
      }

      gs_Tblcpy_NumGT1bit[ft_direction] = s_numGT1BitTones;

      if(ft_direction == TX)
      {
         if(gft_TxTcmFlag)
         {
            //Subtract the tone added in the previous call to this function
            gs_TxNumTonesUsed -= gs_unpairedBatZeroTone[TX];
            gs_unpairedBatZeroTone[TX] = 0;

            s_tcm_2DSymbols =  s_numGT1BitTones + (s_Num1bitTones>>1);
            s_tcmMinZeroTones = (s_tcm_2DSymbols & 1);
            gs_unpairedBatZeroTone[ft_direction] = 1 & ( s_Num0bitTones ^ s_tcmMinZeroTones );

            //In the case of number of TCM tones are not even,
            //we skip the first zero tone in the TRT table
            if(gs_unpairedBatZeroTone[TX])
            {

               gs_Tblcpy_Num0bit[TX]++;
               gs_TxNumTonesUsed++;
               i = s_TxNumTones - gs_TxNumTonesUsed;


               //Note that RX TOT already use the tone 0 and 1
               //here, we need to use a different tone as the extra 0-bit tone
               //(must set it to be TX tone, and also make sure fine gain of 0)

               ghpsa_TxToneOrder_Inactive[i] = TX_OUT_BAND_ZERO_BIT_TONE;
               ghpuca_TxExtGains_Inactive[TX_OUT_BAND_ZERO_BIT_TONE] |= 0x10;
               ghpsa_TxFineGains_Inactive[TX_OUT_BAND_ZERO_BIT_TONE] = 0;
               //ghpuca_TxBat_Inactive[TX_OUT_BAND_ZERO_BIT_TONE] = 0;
            } //if(gs_unpairedBatZeroTone[TX])
         } //if(gft_TxTcmFlag)
      } //if(ft_direction == TX)
   }

} //GetBatStats()

/*****************************************************************************
;   Prototype: FlagT ReorderTRT_Rx(void)
;
;   This subroutine reorders the input TRT table such that all the 0-bit tones
;   are placed at the beginning, and all 1-bit tones at the end and the other
;   tones are inbetween according to the order of the input TRT.
;   For the RX TRT, additional care is taken to ensure that valid SNR calculation
;   can be performed for all in-band tones.
;
;   Input Arguments:
;      ft_direction -- indicate if this is for TX or RX direction
;
;   Output Arguments:
;
;   Global Variables Used:
;      ghpuca_(Tx/Rx)Bat_Inactive      -- (I) pointer to the inactive bit allocation table
;      gs_(Tx/Rx)NumTonesUsed          -- (I) number of TX/RX used tones
;      gft_(Tx/Rx)TcmFlag              -- (I) TX/RX TCM flag
;      ghpsa_(Tx/Rx)ToneOrder_Active   -- (I) pointer to the active TRT
;      ghpsa_(Tx/Rx)ToneOrder_Inactive -- (O) pointer to the active TRT
;      gs_ToneReorderErrorCode         -- (O) ToneReorder error code
;      gus_(Tx/Rx)_Tcm_Num1bits        -- (O) number of 1-bit tones
;      gus_Rx_1Bit_Index               -- (O) index of the first 1-bit tone in TRT
;      gs_RxMinTone                    -- (O) MIN_RX_TONE to process
;      gs_RxMaxTone                    -- (O) MAX_RX_TONE to process
;****************************************************************************/
FlagT ReorderTRT_Rx(void)
{
   int16 s_NumTones;
   int16 s_NumLoadedTones, s_NumTcmTones;
   int16 *psa_outbuf;
   int16 *psa_OutTRT;
   int16 s_Num0bitTones;
   int16 s_Num1bitTones;
   int32 l_SumBat;

#ifndef HW_TRT
   int16 *psa_toneorderTCM, *psa_toneorderTCM_1bits, *psa_toneorderTCM_above1bits;
   int16 i,j,s_tone;
#endif

   //Set the input parameters based on the direction
   s_NumTones = gs_RxNumTonesUsed;

   psa_OutTRT = &(ghpsa_RxToneOrder_Inactive[0]);
   psa_outbuf = psa_OutTRT;

   if(gft_RxTcmFlag == FALSE)
   {
      *psa_outbuf++ = RX_OUT_BAND_ZERO_BIT_TONE_1;
      *psa_outbuf++ = RX_OUT_BAND_ZERO_BIT_TONE_2;

      gs_RxMinTone = RX_NUM_OUT_BAND_ZERO_BIT_TONE;
      gs_RxMaxTone = gs_RxMinTone+s_NumTones-1;

      //HW requires the total number of tones between MIN_RX_TONE and MAX_RX_TONE be even
      if (s_NumTones & 0x1)
      {
         gs_RxMinTone--;
      }

      //HW don't care
      gus_Rx_Tcm_Num1bits = 0;
      gus_Rx_1Bit_Index = 0;
   } //if(gft_RxTcmFlag == FALSE)

   ///////////////////////////////////////////////////////////////////////////////////
   // Unpack the saved TRT from FDQ mem and update the count of 0-bit and 1-bit ones
   ///////////////////////////////////////////////////////////////////////////////////

   // If TCM is on, update the count of 0-bit and 1-bit tones
#ifndef HW_TRT
   Unpack_TRT(RX, psa_outbuf, &s_Num0bitTones, &s_Num1bitTones);
#endif

   CalcBatStats(RX, &s_Num0bitTones, &s_Num1bitTones, &l_SumBat);

   //Update line rate
   MULU16(t_DSRateInfo.ul_LineRate, l_SumBat, gs_DataFrameRate);

   ////////////////////////////////////////////////////////////////////
   //If TCM is on
   ////////////////////////////////////////////////////////////////////
   if(gft_RxTcmFlag)
   {
      //Compute the number of loaded tones (i.e., non 0-bit tones)
      s_NumLoadedTones = s_NumTones - s_Num0bitTones;

      //Number of 1-bit tone must be even for the case of TCM on
      if(s_Num1bitTones & 1)
      {
         gs_ToneReorderErrorCode = E_CODE_TRT_RX_1BIT_TONES;
         return(FAIL);
      }

      //==========================================================================
      // Determine starting index of TRT
      //==========================================================================
      // for RX path: reserve first two TRT indices for out-band 0-bit tones (tone 0, tone 1)
      // (1) to ensure TRT starts with 0-bit tone in case all in-band tones are loaded
      // (2) to compute SNR for all in-band tones including unloaded tones
      // (SNR is not calculated correctly for the in-band 0-bit tone if it is paired with the first nonzero-bit tone in TCM mode)
      // for TX path: no need to reserve out-band 0-bit tone even though all tones are loaded
      // since zero-bit unused tones precede TX TRT
      psa_OutTRT[RX_NUM_OUT_BAND_ZERO_BIT_TONE-2] = RX_OUT_BAND_ZERO_BIT_TONE_1; //tone 0
      psa_OutTRT[RX_NUM_OUT_BAND_ZERO_BIT_TONE-1] = RX_OUT_BAND_ZERO_BIT_TONE_2; //tone 1

      gus_Rx_Tcm_Num1bits = s_Num1bitTones;
      gus_Rx_1Bit_Index = RX_NUM_OUT_BAND_ZERO_BIT_TONE + s_NumTones - s_Num1bitTones;

      //============================================================================
      //Move all 0-bit tones to the beginning of the table,
      //and all 1-bit tones to the end of table
      //============================================================================
#ifndef HW_TRT
      psa_toneorderTCM = psa_OutTRT + RX_NUM_OUT_BAND_ZERO_BIT_TONE;
      psa_toneorderTCM_1bits = (psa_toneorderTCM + s_NumTones - s_Num1bitTones);
      psa_toneorderTCM_above1bits = (psa_toneorderTCM + s_Num0bitTones);

      ReorderTones(RX, psa_toneorderTCM,psa_toneorderTCM_1bits, psa_toneorderTCM_above1bits);
#endif

      //==========================================================================
      // determine RX_MIN_TONE and RX_MAX_TONE
      // include 0-bit tones for SNR calculation for all in-band tones
      //==========================================================================
      gs_RxMinTone = RX_NUM_OUT_BAND_ZERO_BIT_TONE;
      gs_RxMaxTone = gs_RxMinTone + s_NumTones - 1;

      //Set the index to the index of the first non-0 bit tone
      gs_RxMinTone += s_Num0bitTones;

      //Compute the number of TCM contributed tones
      s_NumTcmTones = s_NumLoadedTones - (s_Num1bitTones>>1);

      //If the number of TCM contributed tones is odd, reduce MIN_TX_TONE by 1
      if(s_NumTcmTones & 1)
      {
         gs_RxMinTone--;

         //reshuffle 0-bit tones if the number of TCM tones is odd as explained below:
         // put two out-band 0-bit tones to the start and the end of 0-bit tone group
         // since these tones won't be part of SNR calculation
         // (1) the first 0-bit tone can be excluded from MIN-MAX tone range depending on
         // the number of in-band 0-bit tones
         // (2) the last 0-bit tone may generate bad SNR in Trellis mode if it is paired
         // with the first non-zero bit tone in Trellis decoding

#ifndef HW_TRT
         j = RX_NUM_OUT_BAND_ZERO_BIT_TONE-1;
         s_tone = psa_OutTRT[j];

         for(i=0; i<s_Num0bitTones; i++)
         {
            psa_OutTRT[j] = psa_OutTRT[j+1];
            j++;
         }
         psa_OutTRT[j] = s_tone;
#endif
      }

      // include all 0-bit tones so that SNR calculation works on these tones
      if (gs_RxMinTone & 0x1)
      {
         gs_RxMinTone = 1;
      }
      else
      {
         gs_RxMinTone = 0;
      }

   } //if(ft_TcmFlag == 1)

   // Fill TRT with unused tones

   return(SUCCEED);
}

/*****************************************************************************
;   Prototype: FlagT ReorderTRT_Tx(void)
;
;   This subroutine reorders the input Tx TRT table stored in FDQ memory
;   such that all the 0-bit tones are placed at the beginning, and all 1-bit
;   tones at the end and the other tones are inbetween according to the order of the input TRT.
;
;   Input Arguments:
;
;   Output Arguments:
;
;   Global Variables Used:
;      ghpuca_(Tx)Bat_Inactive      -- (I) pointer to the inactive bit allocation table
;      gs_(Tx)NumTonesUsed          -- (I) number of TX/RX used tones
;      gft_(Tx)TcmFlag              -- (I) TX/RX TCM flag
;      ghpsa_(Tx)ToneOrder_Active   -- (I) pointer to the active TRT
;      ghpsa_(Tx)ToneOrder_Inactive -- (O) pointer to the active TRT
;      gs_ToneReorderErrorCode         -- (O) ToneReorder error code
;      gus_(Tx)_Tcm_Num1bits        -- (O) number of 1-bit tones
;****************************************************************************/
FlagT ReorderTRT_Tx(void)
{
   int16 s_NumTones;
   int16 s_Num0bitTones;
   int16 s_Num1bitTones;
   int32 l_SumBat;
   int16 s_TxNumTones;

   if (gs_RxNumTones > gs_TxNumTones)
      s_TxNumTones = gs_RxNumTones;
   else
      s_TxNumTones = gs_TxNumTones;

#ifndef HW_TRT
   int16 *psa_outbuf, *psa_OutTRT;
   int16 *psa_toneorderTCM, *psa_toneorderTCM_1bits, *psa_toneorderTCM_above1bits;

   psa_OutTRT = &(ghpsa_TxToneOrder_Inactive[s_TxNumTones - gs_TxNumTonesUsed]);
   psa_outbuf = psa_OutTRT;

   ////////////////////////////////////////////////////////////////////
   //If the TCM is off, the input and output TRT table should be same
   ////////////////////////////////////////////////////////////////////
   // Unpack the TRT saved in FDQ memory to the inactive TRT table
   Unpack_TRT(TX, psa_outbuf, &s_Num0bitTones, &s_Num1bitTones);
#endif //#ifndef HW_TRT

   CalcBatStats(TX, &s_Num0bitTones, &s_Num1bitTones, &l_SumBat);

   MULS32x16(t_USRateInfo.ul_LineRate, l_SumBat, gs_DataFrameRate);


   gus_Tx_Tcm_Num1bits = 0;
   s_NumTones = gs_TxNumTonesUsed;

   ////////////////////////////////////////////////////////////////////
   //If TCM is on
   ////////////////////////////////////////////////////////////////////
   if(gft_TxTcmFlag)
   {

      //Number of 1-bit tone must be even for the case of TCM on
      if(s_Num1bitTones & 1)
      {
         gs_ToneReorderErrorCode = E_CODE_TRT_TX_1BIT_TONES;
         return(FAIL);
      }

      gus_Tx_Tcm_Num1bits = s_Num1bitTones;

      //============================================================================
      //Move all 0-bit tones to the beginning of the table,
      //and all 1-bit tones to the end of table
      //============================================================================
#ifndef HW_TRT
      psa_toneorderTCM = psa_OutTRT;

      psa_toneorderTCM_1bits = (psa_toneorderTCM + s_NumTones - s_Num1bitTones);
      psa_toneorderTCM_above1bits = (psa_toneorderTCM + s_Num0bitTones);

      ReorderTones(TX, psa_toneorderTCM,psa_toneorderTCM_1bits, psa_toneorderTCM_above1bits);
#endif
   } //if(ft_TcmFlag == 1)

   return(SUCCEED);
} //ReorderTRT_Tx


/**********************************************************************************
;   Prototype: FlagT FillUnusedToneInTrt(void)
;
;   This function fills unused tones in TRT. Assume that all unused tones are
;   configured as RX tones (i.e., in direction bit in EGT).
;
;   Input Arguments:
;
;   Output Arguments:
;
;   Returns:
;      SUCCESS/FAIL
;
;   Global Variables:
;
;      ghpuca_RxExtGains_Inactive -- (I) pointer to the inactive EGT (indicator of TX or RX)
;      gs_RxNumTonesUsed          -- (I) number of in-band RX tones
;      gs_TxNumTonesUsed          -- (I) number of in-band TX tones
;      gs_NumOf(Tx/Rx)Bands       -- (I) number of TX/RX bands
;      gsa_RxBandLeftChannel[]    -- (I) an array of RX left band edges
;      gsa_RxBandRightChannel[]   -- (I) an array of RX right band edges
;      ghpsa_RxToneOrder_Inactive -- (O) pointer to the inactive TRT
;      gs_ToneReorderErrorCode      -- (O) ToneReorder error code
*************************************************************************************/

#ifndef HW_TRT

/**********************************************************************************
;   Prototype: uint16 ReadTRT(int16 *ps_start, int16 *ps_end, int16 *ps_band)
;
;   This function is used to retrieve the original TRT information (both TX and RX) from memory.
;   It is used in conjunction with the WriteTRT function (see below).
;
;   Input Arguments:
;      *ps_start            -   pointer to variable containing current destination address of data
;      *ps_end               -   pointer to variable containing  last address within this block
;      *ps_band            -   pointer to variable containing current FDQ band.  This band
;                           is the FDQ block above current destination block for the TRT storage.
;
;   Output Arguments:
;      *ps_start            -   updated to next destination address for storage
;      *ps_end               -   updated to next end address if new block is started
;      *ps_band            -   updated to next band if new block is started. ;
;
;   Global Variables:
;      gsa_RxBandLeftChannel   -   used to find unused FDQ memory
;      gsa_RxBandRightChannel   -   used to find unused FDQ memory
;      gs_NumOfRxBands         -   used to find unused FDQ memory
;
**********************************************************************************/

#define READ_FDQ_MEM      (0)
#define READ_FRAMEBUFFER   (1)


uint16 ReadTRT(int16 *ps_start, int16 *ps_end, int16 *ps_band)
{
   uint16 us_tone;
   int16 *psa_inbuf;

   switch (gs_TRT_readstate)
   {
   case READ_FDQ_MEM:

      psa_inbuf = ghpsa_SFDQMantissa;

      if ((*ps_start > *ps_end) && (*ps_end != 8191))
      {
         // update the start of next storage area based on the
         // right (upper) edge of the current *ps_band variable.
         *ps_start = (gsa_RxBandRightChannel[*ps_band] + 1) << 1;

         // update the band variable.
         *ps_band = *ps_band + 1;

         // if the *ps_band > gs_NumOfRxBands, then
         // we've reached the point above the last band.
         // in this case, the *ps_end should be set to 8191, the
         // last value in the 8192 FDQ memory.
         if (*ps_band >= gs_NumOfRxBands)
         {
            *ps_end = 8191;
         }
         // otherise, the *ps_end is set to one location before
         // the next set of FDQ variables.
         else
         {
            *ps_end = (gsa_RxBandLeftChannel[*ps_band] << 1) - 1;
         }


      }

      if (*ps_start == 8191)
      {
         // For next read, switch to use the frame buffer
         gs_TRT_readstate = READ_FRAMEBUFFER;

      }

      break;

   case READ_FRAMEBUFFER:
      psa_inbuf = ghpsa_txframebuffer;

      if (*ps_start == 8192)
      {
         *ps_start = 1;
         *ps_end = 831;      // Size of frame buffer is 832 words
      }

      break;

   }

   // read from the FDQ array the TRT table
   // applying the proper offset
   us_tone = *(psa_inbuf + *ps_start);

   (*ps_start)++;
   return(us_tone);
} //ReadTRT(int16 *ps_start, int16 *ps_end, int16 *ps_band)

/**********************************************************************************
;   Prototype: void WriteTRT(uint16 us_word, int16 *ps_start, int16 *ps_end, int16 *ps_band)
;
;   This function is used to store the original TRT information (both TX and RX) into available memory.
;   The original TRT information is needed in addtion to the inactive and active HW TRT tables,
;   thus there are actually three TRT tables maintained.
;
;   The Active TRT table is used by the hardware.
;   The Inactive TRT table is updated in background during the Bit Swap calculations. The
;   Inactive is copied to the Active TRT at the actual bit swap time.
;   TRT updates during Bit Swap are necessary when the number of 0 bit or 1 bit constellations
;   change.  The more general TRT information is exchanged in the VDSL2 messaging and does
;   not change during Bit Swaps.
;
;   The third TRT table, containing the original data, is required in order to update
;   the 0 and 1 bit constellation ordering during a Bit Swap.
;
;   Since the TRT tables are large, it is difficult to find storage.  This function is used
;   to take advantage of the unused FDQ coefficient memory and Frame Buffer memory available
;   in some systems.  More specifically, this function assumes that the FDQ coefficient memory
;   is available for all 4096 tones.  However, only the coefficients associated with the RX
;   bands are used.  Thus this function stores the TRT data into the unused FDQ coefficient
;   memory.  If additional space is required beyond what is available in the FDQ memory, then
;   the Frame Buffer (if available) or other buffers are required.
;
;   The unused FDQ memory is determined using gsa_RxBandLeft(Right)Channel[] arrays along with
;   the gs_NumOfRxBands value.
;
;   Input Arguments:
;      us_word               -   TRT data to store
;      *ps_start            -   pointer to variable containing current destination address for storage
;      *ps_end               -   pointer to variable containing  last address within this block
;      *ps_band            -   pointer to variable containing current FDQ band.  This band
;                           is the FDQ block above current destination block for the TRT storage.
;
;   Output Arguments:
;      *ps_start            -   updated to next destination address for storage
;      *ps_end               -   updated to next end address if new block is started
;      *ps_band            -   updated to next band if new block is started. ;
;
;   Global Variables:
;      gsa_RxBandLeftChannel   -   used to find unused FDQ memory
;      gsa_RxBandRightChannel   -   used to find unused FDQ memory
;      gs_NumOfRxBands         -   used to find unused FDQ memory
;

**********************************************************************************/
void WriteTRT(uint16 us_word, int16 *ps_start, int16 *ps_end, int16 *ps_band)
{
   int16 *psa_outbuf;

   if ((*ps_start > *ps_end) && (*ps_start <= 8191))
   {
      // Point to the next unused band
      // the *ps_band variable refers to the Rx band
      // ABOVE the region being used for storage of the TRT.
      // for example, *ps_band is updated to 2 at the point
      // at which the TRT variables start getting stored in the
      // region between 1 and 2.

      // update the start of next storage area based on the
      // right (upper) edge of the cuurent *ps_band variable.
      *ps_start = (gsa_RxBandRightChannel[*ps_band] + 1) << 1;

      // update the band variable.
      *ps_band = *ps_band + 1;

      // if the *ps_band > gs_NumOfRxBands, then
      // we've reached the point above the last band.
      // in this case, the *ps_end should be set to 8191, the
      // last value in the 8192 FDQ memory.
      if (*ps_band >= gs_NumOfRxBands)
      {
         *ps_end = 8191;
      }
      // otherise, the *ps_end is set to one location before
      // the next set of FDQ variables start.
      else
      {
         *ps_end = (gsa_RxBandLeftChannel[*ps_band] << 1) - 1;
      }


   }
   else if (*ps_start == 8192)
   {
      gft_use_framebuffer = TRUE;

      *ps_start = 1;
      *ps_end = 831;      // Size of frame buffer is 832 words
   }

   // Get the memory address to save the TRT
   if (!gft_use_framebuffer)
   {
      psa_outbuf = ghpsa_SFDQMantissa;
   }
   else
   {
      psa_outbuf = ghpsa_txframebuffer;
   }

   psa_outbuf[(*ps_start)++] = us_word;

} //WriteTRT(uint16 us_word, int16 *ps_start, int16 *ps_end, int16 *ps_band)



/**********************************************************************************
;   Prototype: void Unpack_TRT(FlagT ft_direction, int16 *psa_outbuf, int16 *ps_Num0bitTones, int16 *ps_Num1bitTones)
;
;   This function unpacks the TRT saved in the FDQ memory and also updates the count of 0-bit
;   and 1-bit tones
;   Input Arguments:
;
;   Output Arguments:
;

;
;   Global Variables:
**********************************************************************************/


void Unpack_TRT(FlagT ft_direction, int16 *psa_outbuf, int16 *ps_Num0bitTones, int16 *ps_Num1bitTones)
{
   FlagT ft_TcmFlag;
   uint8 *puca_BAT;
   int16 i, j,k, s_bat, s_tone;
   int16 s_band, s_start, s_end;
   uint16 us_word, us_word2;
   int16 s_NumTones;

   *ps_Num0bitTones = 0;
   *ps_Num1bitTones = 0;

   if (ft_direction == TX)
   {
      puca_BAT = ghpuca_TxBat_Inactive;
      ft_TcmFlag = gft_TxTcmFlag;
      s_NumTones = gs_TxNumTonesUsed;

      // Find the correct offset to read from the FDQ array
      s_band = gs_TxTRT_read_band;
      s_start = gs_TxTRT_read_offset;

   }
   else if(ft_direction == RX)
   {
      puca_BAT = ghpuca_RxBat_Inactive;
      ft_TcmFlag = gft_RxTcmFlag;
      s_NumTones = gs_RxNumTonesUsed;

      // Find the correct offset to read from the FDQ array
      s_band = gs_RxTRT_read_band;
      s_start = gs_RxTRT_read_offset;
   }

   gs_TRT_readstate = 0;
   s_end = (gsa_RxBandLeftChannel[s_band] << 1) - 1;
   if (s_end == -1)
   {
      s_end = s_end + 8192;
   }

   // Copy the input TRT to the output TRT, unpack the data
   for(i=0; i<s_NumTones; i=i+2)
   {
      // Process 2 words at a time to get
      // atleast 1 tone worth of information
      us_word = ReadTRT(&s_start, &s_end, &s_band);

      // Block writing to the HW for odd number of tones
      if ((i+1) < s_NumTones)
      {
         psa_outbuf[i+1] = (us_word >> 4) & 0x0FFF;
      }

      us_word2 = ReadTRT(&s_start, &s_end, &s_band);
      psa_outbuf[i] = (us_word2 >> 8) | ((us_word << 8) & 0xF00);

      // increment on reading 2 tones
      i = i+2;

      // Read 2 tones
      k = i;

      if (i<s_NumTones)
      {
         // Read the third word to get complete information for 4 tones
         us_word = ReadTRT(&s_start, &s_end, &s_band);

         if ((i+1) < s_NumTones)
         {
            psa_outbuf[i+1] = ((us_word2 << 4) & 0xFF0) | ((us_word >> 12) & 0xF);
         }

         psa_outbuf[i] = us_word & 0xFFF;

         // Read 4 tones
         k = i + 2;

      }

      // handle the case when #tones is odd
      if (k > s_NumTones)
      {
         k--;
      }

      if(ft_TcmFlag)
      {
         // Update the count of 0-bit and 1-bit tones based on the four tones
         // read from the TRT table
         for ( j = (i-2); j < k; j++)
         {
            s_tone = psa_outbuf[j];

            s_bat = *(puca_BAT+s_tone);

            if(s_bat == 0)
            {
               (*ps_Num0bitTones)++;
            }
            else if(s_bat == 1)
            {
               (*ps_Num1bitTones)++;
            }
         }

      }


   }

} //Unpack_TRT(FlagT ft_direction, int16 *psa_outbuf, int16 *ps_Num0bitTones, int16 *ps_Num1bitTones)

/**********************************************************************************
;   Prototype:
;   void ReorderTones(FlagT ft_direction, int16 *psa_toneorderTCM,int16 *psa_toneorderTCM_1bits, int16 *psa_toneorderTCM_above1bits)

;
;   This function reorder the tones for trellis on case
;
;   Input Arguments:
;
;   Output Arguments:
;

;
;   Global Variables:
**********************************************************************************/

void ReorderTones(FlagT ft_direction, int16 *psa_toneorderTCM,int16 *psa_toneorderTCM_1bits, int16 *psa_toneorderTCM_above1bits)
{
   uint8 *puca_BAT;
   uint16 us_word, us_word2;
   uint16 usa_tone[4];
   int16 i, j, k, s_NumTones;
   int16 s_bat, s_tone;
   int16 s_start, s_end, s_band;

   if (ft_direction == TX)
   {
      s_NumTones = gs_TxNumTonesUsed;
      puca_BAT = ghpuca_TxBat_Inactive;

      // Find the correct offset to read from the FDQ array
      s_band = gs_TxTRT_read_band;
      s_start = gs_TxTRT_read_offset;
   }
   else if (ft_direction == RX)
   {
      s_NumTones = gs_RxNumTonesUsed;
      puca_BAT = ghpuca_RxBat_Inactive;

      // Find the correct offset to read from the FDQ array
      s_band = gs_RxTRT_read_band;
      s_start = gs_RxTRT_read_offset;

   }

   s_end = (gsa_RxBandLeftChannel[s_band] << 1) - 1;
   if (s_end == -1)
   {
      s_end = s_end + 8192;
   }

   gs_TRT_readstate = 0;

   for (i = 0; i < s_NumTones; i = i+2)
   {
      // Process 3 words at a time to get
      // 4 tones worth of information
      us_word = ReadTRT(&s_start, &s_end, &s_band);

      usa_tone[1] = (us_word >> 4) & 0x0FFF;

      us_word2 = ReadTRT(&s_start, &s_end, &s_band);
      usa_tone[0] = (us_word2 >> 8) | ((us_word << 8) & 0xF00);

      i = i+2;
      k = 2;

      // handle the case when #tones is odd
      if (i > s_NumTones)
      {
         k--;
      }

      if (i < s_NumTones)
      {
         k = 4;
         us_word = ReadTRT(&s_start, &s_end, &s_band);

         usa_tone[3] = ((us_word2 << 4) & 0xFF0) | ((us_word >> 12) & 0xF);
         usa_tone[2] = us_word & 0xFFF;

         // handle the case when #tones is odd
         if ((i+2) > s_NumTones)
         {
            k--;
         }

      }


      for ( j = 0; j < k; j++)
      {
         s_tone = usa_tone[j];
         s_bat = *(puca_BAT+s_tone);

         if (s_bat == 0)
         {
            *psa_toneorderTCM++ = s_tone;
         }
         else if (s_bat == 1)
         {
            *psa_toneorderTCM_1bits++ = s_tone;
         }
         else
         {
            *psa_toneorderTCM_above1bits++ = s_tone;
         }
      }
   }

} //ReorderTones(FlagT ft_direction,

#endif //#ifndef HW_TRT
