/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: SelectRxBandLimit.c
*
*   This file contains functions to selects pilot tone index.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "mul.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void SelectRxBandLimit(int16 *psa_SnrBuf, int16 *ps_HighestTone,
*                                     int16 *ps_LowestTone)
*
*   This function selects the highest and lowest RX tone indices which has
*   the reasonable SNR.
*
*   Input Arguments:
*      psa_SnrBuf - pointer to the SNR buffer
*      s_WindowSize - size of the window to compute the average SNR
*
*   Output Arguments:
*      ps_HighestTone - pointer to the highest tone index
*      ps_LowestTone - pointer to the lowest tone index
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void SelectRxBandLimit(int16 *psa_SnrBuf, int16 *ps_HighestTone, int16 *ps_LowestTone)
{
   signed int i, s_ch, s_BandStart;

   int32 l_Metric, l_MinBandMetric, l_MinBandMetricStart;
   FlagT ft_FirstTime;
   FlagT ft_CheckAtBandStartDone;

   // set the default values for highest and lowest tones
   *ps_HighestTone = gsa_RxBandRightChannel[gs_NumOfRxBands-1];
   *ps_LowestTone = gsa_RxBandLeftChannel[0];

   //l_MinBandMetric = s_WindowSize * SNR_THRESH_FOR_HIGHEST_TONE;
//   MULS16(l_MinBandMetric, s_WindowSize, (int16)SNR_THRESH_FOR_HIGHEST_TONE);
   l_MinBandMetric = gs_MIN_BAND_METRIC;
   l_MinBandMetricStart = gs_MIN_BAND_METRIC_START;

   ft_FirstTime = 1;                                       // It is not allowed to put this into the loop!

   for (i=0; i<gs_NumOfRxBands; i++)
   {
      // Reset all semaphores for a new band , i.e. start fresh.
      l_Metric = 0;
      ft_CheckAtBandStartDone = 0;

      s_BandStart = gsa_RxBandLeftChannel[i];
      if(i>0)
      {
         s_BandStart += 100;   // Skip the fst 100 tones of the upper bands since this tones are effected by
                               // the echo of the tx band below and since timing advance seems not to be
                               // stable it would give unstable decisions.
      }

      // Loop over all tones of the actual Rx band
      for (s_ch=s_BandStart; s_ch<=gsa_RxBandRightChannel[i]; s_ch++)
      {
         if (!IS_TONEFLAGSET(guca_RxSupportedToneSet, s_ch))
         {
            // Reset the sliding window
            s_BandStart = s_ch + 1;
            l_Metric = 0;
         }
         else
         {
            l_Metric += psa_SnrBuf[s_ch];

            // Accumulate the SNR first for a number of "WINDOW_SIZE" tones.
            // When the "l_Metric" contains the "WINDOW_SIZE" SNR then the evaluation per tone will start.
            // The sliding window algorithm is comparing for every new tone against the "WINDOW_SIZE" threshold.
            // Therefore the SNR of first tone (s_BandStart) gets be removed and new tone (s_ch ) gets be added.
            if(((s_ch-s_BandStart)+1) >= WINDOW_SIZE)
            {
               // Do this only for the second and higher bands.
               // Check the first number of tones of a band, if they don't have reasonable SNR
               // set highest tone to last tone of previous band.
               // Note: Previous implementation was to switch off the full band
               //              -> gsa_RxBandRightChannel[i] = gsa_RxBandLeftChannel[i];
               //       But this fix was not ok, because the complete band would be switch off, also
               //       when SNR is again above threshold on higher tones in the band.
               if ((i > 0) && (ft_CheckAtBandStartDone == 0))
               {
                  if (l_Metric < l_MinBandMetricStart)
                  {
                     // It's better to switch a band completely off instead
                     // of having some 1 bit tones remaining.
                     if (ft_FirstTime == 1)
                     {
                        // Set the Highest RX tone
                        *ps_HighestTone = gsa_RxBandRightChannel[i-1];

                        // Make sure the pilot tone is not cutoff
                        // XDSLRTFW-3280 - Start / End - PLL improvement / pilot tone selection improvement
                        if (*ps_HighestTone < gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotToneIdx+20)
                        {
                           *ps_HighestTone = gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotToneIdx+20;
                           // check if it is over the band edge
                           if (*ps_HighestTone > gsa_RxBandRightChannel[i])
                           {
                              *ps_HighestTone = gsa_RxBandRightChannel[i];
                           }
                        }

                        // Reset the sliding window
                        // Note: It is not allowed to run directly into the else path of if-case "if (l_Metric < l_MinBandMetric)".
                        //       This cannot be the case because "l_Metric" has a single value and "l_MinBandMetric"
                        //       is the sum of "WINDOW_SIZE" values! It is needed to start the metric from zero (see
                        //       l_Metric -= psa_SnrBuf[s_BandStart]; at the end).
                        //       "s_BandStart" gets be incremented at the end, therefore no "+1".
                        s_BandStart = s_ch;
                        l_Metric = psa_SnrBuf[s_BandStart];
                        l_MinBandMetric = l_MinBandMetricStart;      // stay on higher metric

                        // Don't run into the if-case again
                        ft_FirstTime = 0;
                     }
                  }

                  ft_CheckAtBandStartDone = 1;
               }

               if (l_Metric < l_MinBandMetric)
               {
                  if (ft_FirstTime == 1)
                  {
                     // Set the Highest RX tone
                     *ps_HighestTone = s_ch;              // Use the actual processed tone, i.e. end of sliding window

                     // make sure the pilot tone is not cutoff
                     // XDSLRTFW-3280 - Start / End - PLL improvement / pilot tone selection improvement
                     if (*ps_HighestTone < gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotToneIdx+20)
                     {
                        *ps_HighestTone = gt_PilotConfig.ta_PilotTones[gt_PilotConfig.te_UsedPTArrayIdx].s_PilotToneIdx+20;
                        // check if it is over the band edge
                        if (*ps_HighestTone > gsa_RxBandRightChannel[i])
                        {
                           *ps_HighestTone = gsa_RxBandRightChannel[i];
                        }
                     }
                     ft_FirstTime = 0;
                  }
               }
               // if metric goes up again, renew the search
               else
               {
// Note: In case "l_Metric < l_MinBandMetric" is fulfilled by a single hit, it should not bring directly the band back!
// Is this given?
                  ft_FirstTime = 1;
                  *ps_HighestTone = gsa_RxBandRightChannel[gs_NumOfRxBands-1];
                  l_MinBandMetric = gs_MIN_BAND_METRIC;
               }

               l_Metric -= psa_SnrBuf[s_BandStart];
               s_BandStart++;
            }
         }
      }
   }

}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void BgSelectRxBandLimit(void)
*
*   This function is a BG task to select RX band limit.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*      gpsa_MeasuredSnrBuf (I): pointer to SNR buffer
*      gs_HighestAllowedRxTone (O): pointer to highest RX tone index
*      gs_LowestAllowedRxTone (O): pointer to lowest RX tone index
*
*-------------------------------------------------------------------------------
*/
void BgSelectRxBandLimit(void)
{
//   SelectRxBandLimit(gpsa_MeasuredSnrBuf, 10, &gs_HighestAllowedRxTone, &gs_LowestAllowedRxTone);
   SelectRxBandLimit(gpsa_MeasuredSnrBuf, &gs_HighestAllowedRxTone, &gs_LowestAllowedRxTone);

   if(gt_DbgAllowedToneInfo.s_HighestAllowedRxTone > 0)
   {
      gs_HighestAllowedRxTone = gt_DbgAllowedToneInfo.s_HighestAllowedRxTone;
   }

   if(gt_DbgAllowedToneInfo.s_LowestAllowedRxTone > 0)
   {
      gs_LowestAllowedRxTone = gt_DbgAllowedToneInfo.s_LowestAllowedRxTone;
   }

   gs_RxBkgdProcessFlag = TRAINING_DONE;
}
