/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   SnrHandler.c
 *
 *   This file contains the routine that calculates SNR.
 *
 *------------------------------------------------------------------------
 */

// ***********************************************************************************************************
//SnrHandler.c
//
//History 
//
//10/01/2019 Sriram shastry : XDSLRTFW-4078 -Low US rate on mid-range and long loops if DS supported set includes tone 8191
//    Issue reported from Adtran Lab.Low US rate on mid-range and long loops if DS supported set includes tone 8191
//    SNR of tone 8191 cannot be measured properly ,maybe beause of a HW limitaion.
//    Solution:Overwrite SNR of tone 8191 with Special value OUT_OF_RANGE_SNR_PER_TONE after finishing the SNR measurements
//    Search  for XDSLRTFW-4078
//***********************************************************************************************************
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "snrhandler.h"
#include "str_memmap.h"
#include "V_STR_IOf.h"
#include "snr_b.h"
#include "fifo.h"
#include "noiseacc.h"
#include "IRI_Iof.h"
#include "show_iof.h"
#include "fdq.h"
#include "LL_IOf.h"
#include "DSLEngin.h"
#include "cmv.h"
#include "FdqHandler.h"

extern void EnableNPRWrite(void);


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : SnrHandler
 *
 *  Description:  This function is used to calculate the Snr.
 *
 *  Prototype:  void SnrHandler(int16 s_NumFramesToAccum)
 *
 *  Input Arguments:
 *      s_NumFramesToAccum      -- Number of received frame to accumulate
 *
 *  Output Arguments:
 *
 *  Return:
 *
 *  Global Variables Used:
 *      gs_AlgHandlerState       - (I/O) state of SNR calculation state machine
 *      gpla_RxAccumBuf[]      - (I/O) accumulated frames
 *
 *  Notes:
 *   Before SnrHandler() is called for the first time, the following initialization
 *  needs to be performed:
 *
 *      1) gs_AlgHandlerState = SNR_SETUP.
 *      2) gs_AlgNumFramesToAccum, gs_AlgLog2NumFramesToAccum, gs_LeftChannel
 *         and gs_RightChannel need also be set up properly.
 *
 *------------------------------------------------------------------------
 *^^^
 */
void BgSnrInit(void)
{
   // Clear SNR buffer if this is the first time
   if (gs_LeftChannel == gsa_RxBandLeftChannel[0])
   {
      memset(gpsa_MeasuredSnrBuf, 0, sizeof(int16)*(gs_RxNumTones));
   }

#ifndef HW_SNR_FDQ
   // Clear the accumbuf for next set of accumulation
   memset(gpla_RxAccumBuf, 0, sizeof(int32)*gt_SnrConfig.s_NumChannelsPerGroup);
#endif

   gs_RxBkgdProcessFlag = TRAINING_DONE;
}

void BgSnrMedleyRestoreFdq(void)
{
   // Restores original FDQ here
   memcpy(guca_pre_FDQ_exp, gpuca_MedleyTempFDQExps, sizeof(int8)*(gs_RightChannel-gs_LeftChannel+1));
   memcpy(gsa_pre_FDQ_coef, gpsa_MedleyTempFDQCoeffs, sizeof(int16)*2*(gs_RightChannel-gs_LeftChannel+1));

   gs_RxBkgdProcessFlag = TRAINING_DONE;
}

void SnrHandler(void)
{
   switch(gs_AlgHandlerState)
   {
      //==============================================================================
      // initialize variables for SNR calculation
      //==============================================================================
   case SNR_INIT:

      // set flag to read error output + accumulation
      gs_RtvSelect = ERROR_OUTPUT | HW_ACCUM_POW;
      //Disable GetRxTone() for HW error accumulation
      gft_EnableGetRxTones = FALSE;

      // For VRx518 the RTV is twice, i.e. for 1024 tones.
      gs_NumChannelsPerGroup = gt_SnrConfig.s_NumChannelsPerGroup;
      gpla_RxAccumBuf = gpla_SnrAccuBuf;

      gs_AlgLog2NumFramesToAccum = gt_SnrConfig.s_AlgLog2NumFramesToAccum;
      gs_AlgNumFramesToAccum = (1 << gs_AlgLog2NumFramesToAccum);
      gft_ApplyConstGain = 0;

      gs_CurrentRxBand = 0;
      gs_LeftChannel = gsa_RxBandLeftChannel[gs_CurrentRxBand];

      gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgSnrInit);
      gs_ToneGroupIdx = 0; //XDSLRTFW-3823
      gs_AlgHandlerState = SNR_SETUP;
      break;

      //==============================================================================
      // set up variables for SNR calculation in each group
      //==============================================================================
   case SNR_SETUP:

      if (gs_RxBkgdProcessFlag == TRAINING_DONE)
      {
         gs_RightChannel = gs_LeftChannel + gs_NumChannelsPerGroup - 1;
         if(gs_RightChannel > gsa_RxBandRightChannel[gs_CurrentRxBand])
         {
            gs_RightChannel = gsa_RxBandRightChannel[gs_CurrentRxBand];
         }

         gs_AlgNumTonesToProcess = gs_RightChannel - gs_LeftChannel + 1;

         // Set RX tone offset to the start tone from which the HW should do the processing, i.e. RTV buffer 0.
         gs_RxToneOffset = gs_LeftChannel;
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, SetRxToneOffset);

         // Transition to accumulation substate
         gs_AlgHandlerCount = 0;
         gs_AlgHandlerState = SNR_WAIT_FOR_HW_SET;
      }
      break;

      //==============================================================================
      // Wait for RTV buffer 0 HW settings to take effect
      //==============================================================================
   case SNR_WAIT_FOR_HW_SET:

      if (gs_AlgHandlerCount < gs_RTVxCfgLatency)
      {
         gs_AlgHandlerCount++;
      }
      else
      {
         if (gt_SnrFrameAlignConfig.s_AlgHandlerState == SNR_BASED_FRAME_ALIGN_CALC_SNR)
         {
            gs_AlgHandlerState = SNR_MEDLEY_SAVE_FDQ;
            // Clear counter
            gs_AlgHandlerCount = 0;
         }
         else
         {
            int16 s_UpperBound;

            // XDSLRTFW-1111
            // Remove Tone9 marker for vectoring before Medley, i.e. for ChannelDiscovery and TransceiverTraining!
            // Note: For multiple joining line scenarios, i.e. all lines are training at the same time, the SNR on tone 10n+9 was always bad.
            //       But all other tones showed a kind of noise free SNR. Reason is that all lines are synchronized in vectoring
            //       and are sending a constant pattern (i.e. IDLE-flags on odd tones and 00-constelation on even tones) + the PRBS in reset mode.
            //       Therefore the xtalk leads to a positive superposition.
            //       On tone 10n+9 this is not the case for CO's starting with different idx in the pilot-sequences. This idx is modulated in the
            //       symbols 256 to 26 symbols of a superframe and seen as real xtalk.
            //       Therefore these symbols must be excluded during accumulation for SNR and FDQ, i.e. usable symbols are 26 < sym_idx < 256.
            //
            //       A full accumulation period must fit into the usable symbol window:
            //       => 26 < sym_idx < 256-sym_accum
            //       => 27 <= sym_idx <= 255-sym_accum
            //
            //       To be on the save side a guard of 1 additional symbol was selected, i.e. on upper- and lower-bound side.
            //       => 27 < sym_idx < 255-sym_accum
            //       => 28 <= sym_idx <= 254-sym_accum
            //
            //       Due to "Reset of the Noise Accumulator Buffer and trigger the SNR in hardware" the guard symbol
            //       on lower-bound is implictly given, but on upper-bound one additional symbol must be considered!
            //       => 27 <= sym_idx < 254-sym_accum
            //
            // The if-case "(gs_RxMedleyStateFlag == FALSE)" is intended security code.
            // The flag "EN_CHDIS_SKIP_TONE9_MARKER_SYM_FDQSNR" is set and reset only correct for vectoring.
            // But the code is common for better testing with non-vectoring.
            // Even when the flag "EN_CHDIS_SKIP_TONE9_MARKER_SYM_FDQSNR" is wrongly set in gs_MedleyFrameSynchEnableFlag for non-vectoring
            // it will not lead to any fault behavior or timing penalty during medley.
            // Note: In case of low code memory, the if-case can be removed, when the functionality is not usable for non-vectoring.
            s_UpperBound = (RX_DATA_SYMBOLS_PER_SUPERFRAME-1-1) - gs_AlgNumFramesToAccum;

            if ((!(gs_MedleyFrameSynchEnableFlag & EN_CHDIS_SKIP_TONE9_MARKER_SYM_SNR)) ||
                ((((gs_RxFrmCnt >= 27) && (gs_RxFrmCnt < s_UpperBound))) && (gs_RxMedleyStateFlag == FALSE)))
            {
               // Transition to accumulation substate
               gs_AlgHandlerState = SNR_ACCUM;
               // Clear counter
               gs_AlgHandlerCount = 0;
            }
         }
      }
      break;


   case SNR_MEDLEY_SAVE_FDQ:
      // Read FDQ coeffs from HW
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, ReadFDQ);
      gs_AlgHandlerState = SNR_MEDLEY_ROTATE_FDQ;
      break;

   case SNR_MEDLEY_ROTATE_FDQ:
      // XDSLRTFW-2409 / XDSLRTFW-2489 BEGIN
      // Before we start the SNR based Frame alignment handler we need to make sure that we use the RX Windowing length that is used in showtime
      // Broadcom uses a short TX Cyclic Prefix of 256 (compared to 440 of Avinx). In order to not apply Rx Windowing on ISI disturbed
      // Cyclic Prefix values we needed to shorten the RX windowing coefficients during training. Now before SNR based Frame alignment handling
      // we need to restore the original RX windowing size again.
      // If Rx windowing length has been reduced during CD, restore it now
      if((gft_ReduceChDiscoveryRxWindowLength == TRUE) && (gs_DbgRxWindowLength == 0))
      {
         // gs_RxWindowLength has been reduced by a factor of 2 in cnfg_taks_postGhs.c for BRCM COs. Restore original value again.
         gs_RxWindowLength = (gs_RxWindowLength<<1);
         gft_ReduceChDiscoveryRxWindowLength = FALSE;
         WriteWindowingCoefficients(RX,gs_RxWindowLength);
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, InsertRxCE);
      }
      //Note: 2016/10/17 AH: My understanding is that we need a bigger step size for 35B (high sampling rate) to have the same search window
      //      as in 17A profile. But the increased step size leads to no connects. Hence commenting out code section and keep it as reminder.
      //if (gs_RxWindowLength == RX_WINDOW_LENGTH_8K_FFT)
      //{
      //   // in case of 8K FFT we need to double the step size of the frame alignment algorithm due to higher sample rate
      //   gt_SnrFrameAlignConfig.s_MedleyAlignOffsetStep = FRAME_REALIGNMENT_STEP_8K_FFT_IFFT;
      //}
      // XDSLRTFW-2409 / XDSLRTFW-2489 END

      // Rotates FDQ here
      guc_RotateFDQState = TRAINING_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgMedleyRotateFDQ);
      gs_AlgHandlerState = SNR_MEDLEY_LOAD_ROTATED_FDQ;
      break;


   case SNR_MEDLEY_LOAD_ROTATED_FDQ:
      // Loads rotated FDQ here
      if (guc_RotateFDQState == TRAINING_DONE)
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, LoadFDQ);
         gs_AlgHandlerState = SNR_MEDLEY_WAIT_FOR_HW_SET;
      }
      break;


   case SNR_MEDLEY_WAIT_FOR_HW_SET:
      if (gs_AlgHandlerCount < gs_RTVxCfgLatency)
      {
         gs_AlgHandlerCount++;
      }
      else
      {
         // Clear counter
         gs_AlgHandlerCount = 0;
         // Transition directly to accumulation substate
         gs_AlgHandlerState = SNR_ACCUM;
      }
      break;

      //==============================================================================
      // Accum representative frame for SNR calculation
      //==============================================================================
   case SNR_ACCUM:
      /* HW Based SNR */
      if (gs_AlgHandlerCount == 0 )
      {
         // Reset the Noise Accumulator Buffer and trigger the SNR in hardware
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, ResetNoisePowerBuffer);
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableNPRWrite);
      }
      else if (gs_AlgHandlerCount == gs_AlgNumFramesToAccum)
      {
//         if(gs_RightChannel == 0xfff)
//         {
//            if(gs_PauseControl == 0x95)
//               Pause(gs_PauseControl);
//         }
         // Queue TC task to disable any writing to NPR buffer
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, DisableNPRWrite);
      }
      else if (gs_AlgHandlerCount == (gs_AlgNumFramesToAccum + 1))
      {
//         if(gs_RightChannel == 0xfff)
//         {
//            if(gs_PauseControl == 0x96)
//               Pause(gs_PauseControl);
//         }

         // queue background task to calculate SNR
         guc_SnrCalcState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgSnrCalc);

         if (gft_RestoreOrigFdq == TRUE)
         {
            gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgSnrMedleyRestoreFdq);
            gs_AlgHandlerState = SNR_MEDLEY_RESTORE_FDQ;
         }
         else
         {
            // Transition directly to process next tone group
            gs_AlgHandlerState = SNR_NEXT_TONEGROUP;
         }
      }
      gs_AlgHandlerCount++;
      break;


   case SNR_MEDLEY_RESTORE_FDQ:

      if ((guc_SnrCalcState == TRAINING_DONE) && (gs_RxBkgdProcessFlag == TRAINING_DONE))
      {
         AddFunctionToFifo(gp_RxLoadingFunctionFifo, LoadFDQ);
         gs_AlgHandlerState = SNR_NEXT_TONEGROUP;
      }
      break;


   case SNR_NEXT_TONEGROUP:
      if (guc_SnrCalcState == TRAINING_DONE)
      {
         //If all the tones in this symbol has been processed
         if(gs_RightChannel == gsa_RxBandRightChannel[gs_NumOfRxBands-1])
         {
            gs_AlgHandlerState = SNR_CALC_DONE;

               // XDSLRTFW-4078 (Start)
               // All tones have been processed
               // SNR measurement of tone 8191 does not work
               // => SNR for tone 8191 should be set to a special value indicating for meaningless SNR (Q8.8)
               if (gs_RightChannel == 8191)
               {
                  // Snr is currently stored in buffer gpsa_MeasuredSnrBuf
                  // SnrCalc(pla_NoisePower, gpsa_MeasuredSnrBuf+gs_LeftChannel, gs_LeftChannel, gs_RightChannel);
                  int16 *psa_snr;
                  psa_snr = gpsa_MeasuredSnrBuf;
                  psa_snr[8191] = (int16)OUT_OF_RANGE_SNR_PER_TONE;
               }
               // XDSLRTFW-4078(End)
            // For VRx518 the RTV is twice, i.e. for 1024 tones.
            // Note: Normally RTV size should be considered!
            gpla_RxAccumBuf = &gla_SharedBuffer_X[RX_ACCUM_BUF0_OFFSET_LW];
            gs_NumChannelsPerGroup = gs_NumChannelsPerGroupSave;

            // switch RTV0 setting back to SFDQ output
            gs_RtvSelect = SFDQ_OUTPUT;
            gs_RtvSelectLastFrame = RTV_NOTYPE;

            //enable it before exit
            gft_EnableGetRxTones = TRUE;
         }
         //Continue to process the remaining tones
         else
         {
            if(gs_RightChannel < gsa_RxBandRightChannel[gs_CurrentRxBand])
            {
               gs_LeftChannel = gs_RightChannel+1;
            }
            else
            {
               gs_CurrentRxBand++;
               gs_LeftChannel = gsa_RxBandLeftChannel[gs_CurrentRxBand];
            }

//            gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
//            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgSnrInit);

            //Switch RTV0 to recevie error tone
            //We are doing this simply for reruning "gs_RtvSelect = ERROR_OUTPUT | HW_ACCUM_POW;"
//            gs_RtvSelect = ERROR_OUTPUT;

            gs_AlgHandlerState = SNR_SETUP;
         }
      }
      break;
   }
}

