/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ConvertLogToLinear.c
*
*   This file contains a function to convert log to linear.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"


/*******************************************************************
// For CPE, the following is used to switch back and forth the tssi
// tone fine gains between ghpsa_TxFineGains_Inactive and the
// temporary storage location gsa_MfdqTones[] and gsa_FbckTones[].
// Tssi tones are those from 1 to just below U0 and 32 tone tones
// just above U0.  At most Switch_TxFineGains_Tssi<<1 of these
// will be switched.
*******************************************************************/

void Switch_TxFineGains_Tssi()
{

   int16 s_temp, i, j;
   int16 *ps_gain;

   //If the number of tones prior to the first tone of US0 is
   //greater than gsa_MfdqTones[] size, we cannot apply tssi
   //(This is only for safy check and will probably never happen)

   if(gsa_TxBandLeftChannel[0] > (MAX_MFDQ_TONES*2))
   {
      return;
   }

   i = 0;
   ps_gain = ghpsa_TxFineGains_Inactive+1;
   for (j=1; j< gsa_TxBandLeftChannel[0]; j++)
   {
      s_temp = gsa_MfdqTones[i];
      gsa_MfdqTones[i++] = *ps_gain;
      *ps_gain++ = s_temp;
   }

   ps_gain = ghpsa_TxFineGains_Inactive + gsa_TxBandRightChannel[0]+1;

   for (j=gsa_TxBandRightChannel[0]+1; j<= gsa_TxBandRightChannel[0]+32; j++)
   {
      if(i < (MAX_MFDQ_TONES*2))
      {
         s_temp = gsa_MfdqTones[i];
         gsa_MfdqTones[i++] = *ps_gain;
         *ps_gain++ = s_temp;
      }
   }

}

