/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2008 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   TxPSDCOntrol.c
*
*   This file contains functions to allow the modem to set PSD Masks.
*
*-------------------------------------------------------------------------
*/
// ***********************************************************************************************************
// TxPSDCOntrol.c
//
// History
//
// 20/08/2018: Sriram Shastry : XDSLRTFW-232-Coding/decoding of US- and DS-tssi in O-PRM and R-PRM not correct
// 1. Performance optimization is done up to now only for US0 oPOTS configuration (US0-spectrum: tone 6-32)
// 2. If US oPOTS is used we force the out-of-band TSSI values for the CO TDQ training phase to: ...
// Lower OOB tone Idx (0,4 are shaped with 6.0dB dB TxATTEN ) and  Upper OOB tone idx (36 =-0.0 dB &
// tone idx 54 = -62.0 dB) TxATTEN is applied).
// 3. All other modes still use the old code
// Grep for XDSLRTFW-232
//
// 10/10/2018 Abu Rahman
// XDSLRTFW-3990:  TR115A: sync losses in AA12a and AA17a due to tx path clipping
// On top of Tx PSD compensation, FW uses different Tx PSD boost to meet the customer requirement (see XDSLRTFW-3212, XDSLRTFW-3742,XDSLRTFW-3833).
// These boosts are frequency or band dependent so that conventionally these are done in frequency domain. These boosts could lead
// overflow in IFFT block which can cause US CRC as well as DS CRC. To minimize the risk of IFFT block overflow, shift this extra
// Tx PSD boost in time domain (i.e. IFFT scaling, Tx vargain, AFE gain etc.) and boost the frequency domain part in negative direction ( i.e. reduction).
//
// Example behavior if the power is reduced in frequency domain by 1 dB and  increased in time domain in same amount
// Prio 1: IFFT-gain may increase by 6 dB if FD power reduction allows one more step
//         (in this case we would expect that tx-vargain is reduced by 5 dB)
// Prio 2: if increase of IFFT gain is NOT possible, tx-vargain should increase by 1 dB
// Prio 3: if increase of tx-vargain is NOT possible, afe-gain should increase by 1 dB
// Search for XDSLRTFW-3990
//
// 09/04/2019 Stefan Krause
// XDSLRTFW-4150: RubyTech Issue
//    VRx518 cannot decode Vinax Rev1.3 based US PSD breakpoints anymore after adding code changes
//    for XDSLRTFW-3728.  As VRx518 FW needs (at least one) out-of-band breakpoint following the
//    last US band the interpolation loop needs to be triggered (s_NumBrkpts+1) times.
//    (The last run could be skipped if CO-PSD contains already an out-of-band breakpoint)
//    Search for XDSLRTFW-4150
//
// ***********************************************************************************************************

#include <stdlib.h>
#include "common.h"
#include "gdata.h"
#include "cmv_data.h"
#include "sys_const.h"
#include "dsp_op.h"
#include "TxPSDControl.h"
#include "IRI_Iof.h"
#include "LL_IOf.h"
#include "V_STR_IOf.h"
#include "afe.h"
#include "Snr_b.h"
#include "ConvertToDB.h"
#include "decimalgain.h"
#include "mul.h"
#include <memory.h>
#include "SharedFuncs.h"
#include "fifo.h"
#include "GetTonePsd.h"
#include "vdsl_const.h"
#include "cmv.h"
#include "vdsl_state.h"
#include "vdsl_xception.h"

#define VARGAIN_ADJUST_2DB  (-2)

// Debug code for ExpandPSDDesc: Use a global pointer to read from local stack memory.
//PSDDescriptorTable_t *gpt_ExpandPSDDescIn;
// Decide TRIM 1 Setting based on the Last Used Bin
# define END_BIN_US1 (812)
# define END_BIN_US2 (1600)
# define END_BIN_US3 (3250)

//XDSLRTFW-3495 Start
//XDSLRTFW-3580: US0 Tx PSD Passband adjustments Start
#define DFE_TX_VARGAIN_OFFSET_US0_POTS_17M      (-333+946-205)//-1.3dB removed from Comptable offset and POFI+Trafo has a gain of -3.692159dB to be considered part of TX VAR GAIN
#define AFE_POFI_GAIN_US0_POTS_17M              (0x0700) //us0_only_A_poco7dB

#define DFE_TX_VARGAIN_OFFSET_US0_ISDN_17M      (-435+522-205)//-1.7dB removed from Comptable offset and POFI+Trafo has a gain of -2.038815dB to be considered part of TX VAR GAIN
#define AFE_POFI_GAIN_US0_ISDN_17M              (0x0800) //us0_only_B_poco8dB

#define DFE_TX_VARGAIN_OFFSET_US0_ANNEXM_17M    (-435+254-154)//-1.7dB removed from Comptable offset and POFI+Trafo has a gain of -0.989986dB to be considered part of TX VAR GAIN
#define AFE_POFI_GAIN_US0_ANNEXM_17M            (0x0600) //us0_only_M_poco6dB

#define DFE_TX_VARGAIN_OFFSET_US0_EU128_17M     (-435+106-77)//-1.7dB removed from Comptable offset and POFI+Trafo has a gain of -0.413754dB to be considered part of TX VAR GAIN
#define AFE_POFI_GAIN_US0_EU128_17M             (0x0200) //us0_only_EU128_poco2dB
//XDSLRTFW-3495 End
//XDSLRTFW-3570 Start
#define DFE_TX_VARGAIN_OFFSET_US0_POTS_35M      (-435+807-256)//-1.7dB removed from Comptable offset and POFI+Trafo has a gain of -3.152389dB to be considered part of TX VAR GAIN
#define AFE_POFI_GAIN_US0_POTS_35M              (0x0600) //us0_only_A_poco_6dB

#define DFE_TX_VARGAIN_OFFSET_US0_ISDN_35M      (-435+357-256)//-1.7dB removed from Comptable offset and POFI+Trafo has a gain of -1.391032dB to be considered part of TX VAR GAIN
#define AFE_POFI_GAIN_US0_ISDN_35M              (0x0600) //us0_only_B_poco_6dB

#define DFE_TX_VARGAIN_OFFSET_US0_ANNEXM_35M    (-435+356-256)//-1.7dB removed from Comptable offset and POFI+Trafo has a gain of -1.390406dB to be considered part of TX VAR GAIN
#define AFE_POFI_GAIN_US0_ANNEXM_35M            (0x0600) //us0_only_M_poco_6dB
//XDSLRTFW-3580: US0 Tx PSD Passband adjustments End
//XDSLRTFW-3570 End
#ifdef PSD_TEST
FlagT gft_EnablePsdTestCode = 0;
void TestPSD(void)
{
   if(gft_EnablePsdTestCode)
   {
      gs_TxNumTones = 2;
      gsa_TxBandLeftChannel[0] = 10;
      gsa_TxBandLeftChannel[1] = 882;
      gsa_TxBandRightChannel[0] = 31;
      gsa_TxBandRightChannel[1] = 1193;

      gt_TxPsdControl.s_MaxNomPsdIn = 380;

      gt_TxPsdControl.pt_MaxPsdDescIn->us_NumberOfTones = 17;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[0].us_IndexOfTone = 1;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[0].s_PSDLevelOfTone = 550;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[1].us_IndexOfTone = 2;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[1].s_PSDLevelOfTone = 335;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[2].us_IndexOfTone = 3;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[2].s_PSDLevelOfTone = 210;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[3].us_IndexOfTone = 4;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[3].s_PSDLevelOfTone = 120;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[4].us_IndexOfTone = 5;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[4].s_PSDLevelOfTone = 50;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[5].us_IndexOfTone = 6;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[5].s_PSDLevelOfTone = 0;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[6].us_IndexOfTone = 31;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[6].s_PSDLevelOfTone = 0;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[7].us_IndexOfTone = 32;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[7].s_PSDLevelOfTone = 0;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[8].us_IndexOfTone = 40;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[8].s_PSDLevelOfTone = 225;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[9].us_IndexOfTone = 48;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[9].s_PSDLevelOfTone = 415;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[10].us_IndexOfTone = 56;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[10].s_PSDLevelOfTone = 575;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[11].us_IndexOfTone = 62;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[11].s_PSDLevelOfTone = 590;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[12].us_IndexOfTone = 63;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[12].s_PSDLevelOfTone = 820;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[13].us_IndexOfTone = 881;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[13].s_PSDLevelOfTone = 820;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[14].us_IndexOfTone = 882;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[14].s_PSDLevelOfTone = 145;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[15].us_IndexOfTone = 1193;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[15].s_PSDLevelOfTone = 145;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[16].us_IndexOfTone = 1194;
      gt_TxPsdControl.pt_MaxPsdDescIn->ut_PSDRecord[16].s_PSDLevelOfTone = 820;
   }
} //void TestPSD(void)
#endif //#ifdef PSD_TEST

//XDSLRTFW-2059 (START)
/*^^^
*------------------------------------------------------------------------
*
*  Name : SelectPofiPocoCutoffFreq

*
*   Prototype:
*       int16 SelectPofiPocoCutoffFreq(void)
*
*   Abstract:
*      This function determines the POFIPOCO cutoff frequency in VDSL AFE mode based on
*      highest US loaded tone index.
*
*   Output Parameter: POFIPOCO cutoff frequency in MHz
*
*   Global Variables: gs_HighestLoadedTxTone, gsa_TxBandRightChannel, gt_DecMsg_O_Update_VDSL2, gs_frame_rate_is_8khz
*
*-----------------------------------------------------------------------------
^^^*/



int16 SelectPofiPocoCutoffFreq(void)
{
   int16  s_max_fc_MHz = 0;

   // initialize POFIPOCO cutoff frequency ( need to be aligned with Kai and Stefan in case 30M profile and when only US0 is used!!!!!!!!!!!!
   if (gs_frame_rate_is_8khz==0)
      s_max_fc_MHz = 28;
   else
      s_max_fc_MHz = 28;

   if (!gt_DecMsg_O_Update_VDSL2.us_HighestAllowed_US_Tone )
   {
      gs_HighestLoadedTxTone = gsa_TxBandRightChannel[gs_NumOfTxBands-1];
   }
   else
   {
      gs_HighestLoadedTxTone = gt_DecMsg_O_Update_VDSL2.us_HighestAllowed_US_Tone;
   }


   if (gs_frame_rate_is_8khz==0)
   {
      if(gs_HighestLoadedTxTone < END_BIN_US1) // US0 only
      {
         s_max_fc_MHz =  28;   //Select 5MHz
      }
   }
   return (s_max_fc_MHz);

}
//XDSLRTFW-2059 (END)



void CleanUpPsdBrkpt(int16 s_MaxNumBrkpts, PSDDescriptorTable_t *pt_PSDDescOut)
{
   int16 i, s_NumBrkpts, s_LastIdx;
   int16 s_LastLevel, s_CurrLevel, s_NextLevel;

   s_NumBrkpts = pt_PSDDescOut->us_NumberOfTones;
   if (s_NumBrkpts > 0)
   {
      s_LastIdx = 1;
   }
   else
   {
      s_LastIdx = 0;
   }

   // remove redundancy in PSD breakpoint structure
   for (i=1; i<s_NumBrkpts; i++)
   {
      s_LastLevel = pt_PSDDescOut->ut_PSDRecord[s_LastIdx-1].s_PSDLevelOfTone;
      s_CurrLevel = pt_PSDDescOut->ut_PSDRecord[i].s_PSDLevelOfTone;
      if (i < s_NumBrkpts-1)
      {
         s_NextLevel = pt_PSDDescOut->ut_PSDRecord[i+1].s_PSDLevelOfTone;
      }
      else
      {
         s_NextLevel = s_CurrLevel-1;   // always add last breakpoint
      }

      if ((s_LastLevel == s_CurrLevel) && (s_CurrLevel == s_NextLevel))
      {
         continue;
      }

      pt_PSDDescOut->ut_PSDRecord[s_LastIdx].us_IndexOfTone = pt_PSDDescOut->ut_PSDRecord[i].us_IndexOfTone;
      pt_PSDDescOut->ut_PSDRecord[s_LastIdx].s_PSDLevelOfTone = pt_PSDDescOut->ut_PSDRecord[i].s_PSDLevelOfTone;
      //pt_PSDDescOut->ut_PSDRecord[s_LastIdx].us_InSupportedSet = pt_PSDDescOut->ut_PSDRecord[i].us_InSupportedSet;
      s_LastIdx++;
   }

   pt_PSDDescOut->us_NumberOfTones = s_LastIdx;

   // cleaned up the rest of structure
   memset(&pt_PSDDescOut->ut_PSDRecord[s_LastIdx], 0, (int16)(sizeof(PSDRecord_t)*(s_MaxNumBrkpts-s_LastIdx)));
}
//XDSLRTFW-2323 (start)
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ExpandDupEntries
 *
 *  Description:
 *
 *    This function clean up theinput PSD break point table and Increase the tone index value by 1
 *    at the band edges if tone is repeated

 *
 *  Prototype:
 *    void ExpandDupEntries(PSDDescriptorTable_t *pt_PSDDescIn, PSDDescriptorTable_t *pt_ExpandPSDDescIn)
 *
 *  Input Arguments:
 *    pt_PSDDescIn -- pointer to the input PSD breakpoint table
 *
 *  Output Arguments:
 *    pt_ExpandPSDDescIn -- pointer to the output extended PSD breakpoint table
 *
 *  Return:
 *
 *  Global Variables Used:
 *
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void ExpandDupEntries(PSDDescriptorTable_t *pt_PSDDescIn, PSDDescriptorTable_t *pt_ExpandPSDDescIn)
{
   int16 i, s_temp,s_NumBrkpts;
   int16 s_LastLevel, s_CurrLevel;
   int16 s_LastIdx,s_CurrIdx;

   // copy input PSD descriptor table to the larger size PSD descriptor variable
   memset(pt_ExpandPSDDescIn, 0, sizeof(PSDDescriptorTable_t));

   s_temp = 3*pt_PSDDescIn->us_NumberOfTones + 1;
   memcpy(pt_ExpandPSDDescIn, pt_PSDDescIn, sizeof(int16)*s_temp);

   //s_NumBrkpts = pt_ExpandPSDDescIn->us_NumberOfTones;
   CleanUpPsdBrkpt(MAX_NUM_PSD_POINTS, pt_ExpandPSDDescIn);
   //if(( gs_TxState == VDSL2_R_PRM_TX) && (gs_dbg_level & 0x0020)  )
   //{   gft_PauseOff = FALSE;Pause(0x0B2B);}

   //after clean up
   s_NumBrkpts = pt_ExpandPSDDescIn->us_NumberOfTones;
   for (i = 1; i < s_NumBrkpts; i++)
   {
      s_LastIdx = pt_ExpandPSDDescIn->ut_PSDRecord[i-1].us_IndexOfTone;
      s_LastLevel = pt_ExpandPSDDescIn->ut_PSDRecord[i-1].s_PSDLevelOfTone;
      s_CurrIdx = pt_ExpandPSDDescIn->ut_PSDRecord[i].us_IndexOfTone;
      s_CurrLevel = pt_ExpandPSDDescIn->ut_PSDRecord[i].s_PSDLevelOfTone;

      if((s_CurrIdx == s_LastIdx) && (s_LastLevel != s_CurrLevel))
      {
         pt_ExpandPSDDescIn->ut_PSDRecord[i].us_IndexOfTone = s_CurrIdx+1;
      }
   }
}
//XDSLRTFW-2323 (end)
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ExpandPsdTable
 *
 *  Description:
 *
 *      This function expands the input PSD break point table to the larger one to include those breakpoints
 *  corresponding to the band edges.
 *
 *  Prototype:
 *      void ExpandPsdTable(PSDDescriptorTable_t *pt_PSDDescIn, PSDDescriptorTable_t *pt_ExpandPSDDescIn)
 *
 *  Input Arguments:
 *      pt_PSDDescIn -- pointer to the input PSD breakpoint table
 *
 *  Output Arguments:
 *      pt_ExpandPSDDescIn -- pointer to the output extended PSD breakpoint table
 *
 *  Return:
 *
 *  Global Variables Used:
 *      gsa_TxBandLeftChannel[] -- (I) an array of left band edges
 *      gsa_TxBandRightChannel[] -- (I) an array of right band edges
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void ExpandPsdTable(PSDDescriptorTable_t *pt_PSDDescIn, PSDDescriptorTable_t *pt_ExpandPSDDescIn)
{
   int16 i, j, l, k, x, s_temp;
   int16 s_NumBrkpts, s_attenLevel;
   PSDRecord_t *pt_PSDRecIn;

   // copy input PSD descriptor table to the larger size PSD descriptor variable
   memset(pt_ExpandPSDDescIn, 0, sizeof(PSDDescriptorTable_t));
//   s_temp = 3*pt_PSDDescIn->us_NumberOfTones + 1;
//   memcpy(pt_ExpandPSDDescIn, pt_PSDDescIn, sizeof(int16)*s_temp);
   s_temp = ((sizeof(PSDRecord_t) * pt_PSDDescIn->us_NumberOfTones) + sizeof(int16));
   memcpy(pt_ExpandPSDDescIn, pt_PSDDescIn, s_temp);

   s_NumBrkpts = pt_ExpandPSDDescIn->us_NumberOfTones;
   pt_PSDRecIn = &(pt_ExpandPSDDescIn->ut_PSDRecord[0]);

   // insert breakpoints at band edge if the PSD descriptor does not already have them
   s_temp = 0;
   for (i=0; i<gs_NumOfTxBands; i++)
   {
      for (l=0; l<2; l++)
      {
         if (l == 0)
         {
            j = gsa_TxBandLeftChannel[i];
         }
         else
         {
            j = gsa_TxBandRightChannel[i];
         }

         x = 0;
         for (k=0; k<s_NumBrkpts; k++)
         {
            if (j == pt_PSDRecIn[k].us_IndexOfTone)
            {
               x = 1;
               break;
            }
         }
         if (x == 0)
         {
            s_attenLevel = GetTonePsd(j, pt_ExpandPSDDescIn, gs_TxNumTones);//XDSLRTFW-3838
            AddPsdBrkpt(j, (int16)(-s_attenLevel), pt_ExpandPSDDescIn, MAX_NUM_PSD_POINTS);
            s_NumBrkpts++;
            s_temp++;
         }
      }
   }
   if (s_temp > 0)
   {
      quick_PSDsort(pt_ExpandPSDDescIn, 0, (int16)(s_NumBrkpts-1));
   }


} //void ExpandPsdTable()


void InterpolatePSDUtil(int16 s_MaxNumBrkpts, PSDDescriptorTable_t *pt_PSDDescIn, int16 s_MinAtten_in, int16 *ps_min_atten_dB, PSDDescriptorTable_t *pt_PSDDescOut)
{
   int16 i, j;

   int16 s_attenLevel=0, s_leftToneIdx, s_leftToneAttenLevel, s_rightToneIdx, s_rightToneAttenLevel, s_temp;
   int16 s_maxPsdLeftToneAttenLevel, s_maxPsdRightToneAttenLevel;
   int16 s_addBrkptToneIdx, s_addBrkptAttenLevel=0, s_NumBrkpts;
   PSDRecord_t *pt_PSDRecIn, *pt_PSDRecOut;
   int16 s_attenLevel_previous=0,s_addBrkptAttenLevel_previous=0;
   int16 s_MinAtten = s_MinAtten_in;

   PSDDescriptorTable_t *pt_ExpandPSDDescIn;

   pt_ExpandPSDDescIn = pt_PSDDescIn;

   s_NumBrkpts = pt_ExpandPSDDescIn->us_NumberOfTones;
   pt_PSDRecIn = &(pt_ExpandPSDDescIn->ut_PSDRecord[0]);

   /* Initialize */
   pt_PSDRecOut = &(pt_PSDDescOut->ut_PSDRecord[0]);
   *ps_min_atten_dB = 0x7fff;   // High value

   // XDSLRTFW-4150 RubyTech Issue
   // VRx518 cannot decode Vinax Rev1.3 based US PSD breakpoints anymore after adding codechanges for XDSLRTFW-3728
   // As VRx158 FW needs (at least one) out-of-band breakpoint following the last US band the interpolation loop
   // needs to be triggered (s_NumBrkpts+1) times.
   // (The last run could be skipped if CO-PSD contains already an out-of-band breakpoint)

   // (remove: XDSLRTFW-3728)
   for (i=0; i <= s_NumBrkpts; i++)
   {
      //XDSLRTFW-477 PERF_DS_ALL_ALL_TX_BAND_SWITCH (Start)
      //When a change in TxBand Is requested, change the way we generate the Breakpoints
      if( (pt_PSDRecIn[i].us_IndexOfTone < gs_PrevFirstToneLastBand) ||
            (gs_ChangeTxBand == 0) || (gul_fe_G994VendorID == IFX_VENDOR_ID))
         //XDSLRTFW-477 PERF_DS_ALL_ALL_TX_BAND_SWITCH (End)
      {
         /* Get the adjacent breakpoints given breakpoint index */
         GetAdjacentBreakpts(i, s_NumBrkpts, pt_PSDRecIn, 0, (int16)(gs_TxNumTones-1),
                             &s_leftToneIdx, &s_leftToneAttenLevel, &s_rightToneIdx, &s_rightToneAttenLevel);

         /* Keep a copy of the max psd attenuations for adjacent breakpoint indexs' */
         s_maxPsdLeftToneAttenLevel = s_leftToneAttenLevel;
         s_maxPsdRightToneAttenLevel = s_rightToneAttenLevel;

         /* Get the actual psd attenuations for adjacent breakpoint indexs' with upbo */
         if (gt_TxPsdControl.pt_RefPsdDescIn)
         {
            s_leftToneAttenLevel = GetUPBOAttenLevel(s_leftToneIdx, s_leftToneAttenLevel);
            s_rightToneAttenLevel = GetUPBOAttenLevel(s_rightToneIdx, s_rightToneAttenLevel);
         }

         //Start interpolation
         s_addBrkptToneIdx = -1;
         for (j=s_leftToneIdx; j < s_rightToneIdx; j++)
         {
            /* Compute attenuation level given tone index and adjacent breakpoints */
            s_attenLevel = CalcAttenLevel(j, s_leftToneIdx, s_maxPsdLeftToneAttenLevel, s_rightToneIdx, s_maxPsdRightToneAttenLevel);

            /* Get the actual psd attenuations for given tone index with upbo */
            if (gt_TxPsdControl.pt_RefPsdDescIn)
            {
               s_attenLevel = GetUPBOAttenLevel(j, s_attenLevel);
            }


            //Put additional limit to the US bands
            s_MinAtten = s_MinAtten_in;

            /* If we need to add a breakpoint because of PSD limit  */
            /* get the inflexion point @ which we need to add a brkpt   */
            if (s_addBrkptToneIdx == -1)
            {
               /* Implies decrease in attenuation slope, check for attenuation level going below the limit */
               if ((s_leftToneAttenLevel > s_MinAtten && s_rightToneAttenLevel < s_MinAtten && s_attenLevel <= s_MinAtten) ||
                     /* Implies increase in attenuation slope, check for attenuation level going above the limit */
                     (s_leftToneAttenLevel < s_MinAtten && s_rightToneAttenLevel > s_MinAtten && s_attenLevel >= s_MinAtten))
               {
                  // Limit the interpoloated attenuation level to minimum value specified
                  if (s_attenLevel < s_MinAtten)
                  {
                     s_attenLevel = s_MinAtten;
                  }

                  s_addBrkptToneIdx = j;
                  s_addBrkptAttenLevel = s_attenLevel;
                  // Record previous tone's level, we need to add a breakpoint for it also.
                  // Otherwise, to the left of s_addBrkptToneIdx the set of breakpoints will imply
                  // linear interpolation to the capped level of s_addBrkptAttenLevel, whereas the
                  // the tx fine gains are linearly interpolated to the uncapped level.
                  s_addBrkptAttenLevel_previous = s_attenLevel_previous;
               }
            }

            // Limit the interpoloated attenuation level to minimum value specified
            if (s_attenLevel < s_MinAtten)
            {
               s_attenLevel = s_MinAtten;
            }

            s_attenLevel_previous = s_attenLevel;

            if (*(ghpuca_TxExtGains_Inactive+j) & 0x10)
            {
               // Keep track of the smallest attenuation (which is relative to maxnompsd).
               // We will subsequently adjust maxnompsd accordingly.
               if (s_attenLevel < *ps_min_atten_dB)
               {
                  *ps_min_atten_dB = s_attenLevel;
               }

            } //if (*(ghpuca_TxExtGains_Inactive+j) == 0x10)

         } //for (j=s_leftToneIdx; j < s_rightToneIdx; j++)

         /* copy breakpoint from pt_PSDRecIn to pt_PSDRecOut */
         if (i != 0)
         {

            //Put additional limit to the US0 band
            s_MinAtten = s_MinAtten_in;

            s_temp = MAX(s_leftToneAttenLevel, s_MinAtten);
            AddPsdBrkpt(s_leftToneIdx, s_temp, pt_PSDDescOut, s_MaxNumBrkpts);

            // If the only crossing of s_MinAtten for this existing pair of breakpoints
            // occurs at s_rightToneIdx, we need to generate a breakpoint at
            // tone s_rightToneIdx-1.

            //Put additional limit to the US0 band
            s_MinAtten = s_MinAtten_in;

            if (((s_leftToneAttenLevel > s_MinAtten && s_rightToneAttenLevel < s_MinAtten ) ||
                  (s_leftToneAttenLevel < s_MinAtten && s_rightToneAttenLevel > s_MinAtten ) )
                  && (s_addBrkptToneIdx == -1) && ((s_rightToneIdx-1)!=s_leftToneIdx) )
            {
               AddPsdBrkpt((int16) (s_rightToneIdx-1), s_attenLevel, pt_PSDDescOut, s_MaxNumBrkpts);

            }

         }
         /* add additional breakpoint to pt_PSDDescOut if required */
         if (s_addBrkptToneIdx != -1)
         {
            if ((s_addBrkptToneIdx-1)!=s_leftToneIdx)
            {
               AddPsdBrkpt((int16) (s_addBrkptToneIdx-1), s_addBrkptAttenLevel_previous, pt_PSDDescOut, s_MaxNumBrkpts);
            }

            AddPsdBrkpt(s_addBrkptToneIdx, s_addBrkptAttenLevel, pt_PSDDescOut, s_MaxNumBrkpts);
         }
      } //If (Check for Number of Bands)
   }//for(i=

   //Remove redudant breakpoints
   CleanUpPsdBrkpt(s_MaxNumBrkpts, pt_PSDDescOut);

   // Sort the PSD Descriptor table so that the Masks are in ascending order
   quick_PSDsort(pt_PSDDescOut, 0, (int16)(pt_PSDDescOut->us_NumberOfTones-1));
}

/*^^^
*------------------------------------------------------------------------
*
*  Name : InterpolatePSDValues
*
*   Prototype:
*       void InterpolatePSDValues(PSDDescriptorTable_t *pt_ExpandPSDDescIn)
*
*   Abstract:
*      This function defines the PSD Mask to be applied based on the breakpoints
*      specified in the global pt_TxMaxPSDDesc.  For the CPE, if UPBO has been specified,
*      the mask is also dependent on the target CORX PSD pt_TxRefPSDDesc, and the
*      estimated line electrical length (kl0).  The upstream MaxNomPSD may
*      also be modified here, if in UPBO mode.
*
*      PSD values are represented in logarithmic scale as a 7 bit unsigned value
*      in -0.5 dB steps ranging from 0 to -63 dB.
*
*      The PSD values for all subcarriers are interpolated from samples of frequency
*      breakpoints and the log of the PSD^2 values.
*
*      The interpolation follows 3 rules:
*
*      1. Flat extension to low frequencies from lowest frequency breakpoint
*      2. Flat extension to high frequencies from highest frequency breakpoint
*      3. For a given frequency which falls in between two consecutive
*         breakpoints A and B, interpolate as follows:
*
*         for A < i < B,
*         PSD(i) = PSD(A) + slope * (i - A)
*         where     slope = (PSD(B) - PSD(A)) / (B - A);
*
*      Interpolated log PSD values are then converted to a linear scale.
*
*   Input Parameters:
*
*   Global Variables: gt_PSDDescriptorTable
*
*-----------------------------------------------------------------------------
^^^*/
void InterpolatePSDValues(PSDDescriptorTable_t *pt_ExpandPSDDescIn)
{
   int16 i, j, s_MinAtten;

   UsRawTssiPSDDescriptorTable_t *pt_UsTxAttenPSDDescriptorTable;

   /* Initializations */
   //Clear TX bit in EGT table
   for(i=0; i<gs_TxNumTones; i++)
   {
      *(ghpuca_TxExtGains_Inactive+i) &= ~0x10;
   }
   // Identify the Tx tones first and set the direction bit
   //   in the ExtGain table (EGT)
   for(i=0; i<gs_NumOfTxBands; i++)
   {
      for (j = gsa_TxBandLeftChannel[i]; j <= gsa_TxBandRightChannel[i]; j++)
      {
         // Set EGT direction bit to Tx
         *(ghpuca_TxExtGains_Inactive+j) = 0x10;
         // Set GST values to unity, 0 dB
         *(ghpsa_TxFineGains_Inactive+j) = 0x000;
      }
   }

   // Clear Actual Psd Out
   memset(gt_TxPsdControl.pt_ActPsdDescOut, 0, sizeof(UsPSDDescriptorTable_t));

   if (gs_interp_psd_with_tssi==1)
   {
      // Temporarily activate TSSI tones surrounding band 0, so that they
      // will have appropriate fine gains settings for use in tdq training.

      for (j=1; j< gsa_TxBandLeftChannel[0]; j++)
      {
         *(ghpuca_TxExtGains_Inactive+j) |= 0x10;
      }

      for (j=gsa_TxBandRightChannel[0]+1; j<= gsa_TxBandRightChannel[0]+32; j++)
      {
         *(ghpuca_TxExtGains_Inactive+j) |= 0x10;
      }

      // Save existing ghpsa_TxFineGains_Inactive settings for tssi tones.
      Switch_TxFineGains_Tssi();
   }

   // Get minimum level of attenuation wrt MaxNomPsd, given the psd celing
   if (gt_TxPsdControl.s_PsdCeilingUsed > gt_TxPsdControl.s_MaxNomPsdIn)
   {
      s_MinAtten = gt_TxPsdControl.s_PsdCeilingUsed - gt_TxPsdControl.s_MaxNomPsdIn;
   }
   else
   {
      s_MinAtten = 0;
   }


#ifdef PSD_TEST
   if(gft_EnablePsdTestCode)
   {
      gs_interp_psd_with_tssi = 1;
      gsa_Optn4_FilterControl[OPTN_4_IDX1_FILTER_CTRL] = OPTN_Tx_Filter_Enable;
      gs_TxIIRFilterSelect = OPTN_POTS_Filter_Select;
      //gft_DisallowInbandTssi = FALSE;

      s_MinAtten = 145;
   }
#endif //PSD_TEST


   /*****************************************************
   // Interpolate Tx PSDs to get shaping to be applied
   // as attenuations relative to MaxNomPsd.  This will
   // fill ghpsa_TxFineGains_Inactive[], as well as generate
   // the TX set of PSD (with ceiling) breakpoints gt_TxPsdControl.pt_ActPsdDescOut
   // For CPE, we also generate a log_tssi set of breakpoints in gt_UsTSSIPSDDescriptorTable.
   *****************************************************/
   InterpolatePSDUtil(MAX_NUM_US_PSD_POINTS,
                      pt_ExpandPSDDescIn,
                      s_MinAtten,
                      &gs_min_atten_dB,
                      gt_TxPsdControl.pt_ActPsdDescOut);


   if (gs_interp_psd_with_tssi==1)
   {
      if ( gsa_Optn4_FilterControl[OPTN_4_IDX1_FILTER_CTRL] & OPTN_Tx_Filter_Enable )
      {
         if ( (gs_TxIIRFilterSelect == OPTN_POTS_Filter_Select) || (gs_TxIIRFilterSelect == OPTN_POTS_LP_Filter_Select) ||
            (gs_TxIIRFilterSelect == OPTN_35B_POTS_LP_Filter_Select) ) //XDSLRTFW-3361
         {
            pt_UsTxAttenPSDDescriptorTable = &gt_UsTxAttenPSDDescriptorTable_POTS;
            gula_DebugVarsPalak[2] = ((gs_TxIIRFilterSelect << 16) | 0x1212);
         }
         else if ( (gs_TxIIRFilterSelect == OPTN_ISDN_Filter_Select) || (gs_TxIIRFilterSelect == OPTN_ISDN_LP_Filter_Select) ||
            (gs_TxIIRFilterSelect == OPTN_35B_ISDN_LP_Filter_Select) )
         {
            pt_UsTxAttenPSDDescriptorTable = &gt_UsTxAttenPSDDescriptorTable_ISDN;
            gula_DebugVarsPalak[3] = ((gs_TxIIRFilterSelect << 16) | 0x1213);
         }
         else    // which is OPTN_BYPASS_Filter_Select = -1
         {
            pt_UsTxAttenPSDDescriptorTable = &gt_UsTxAttenPSDDescriptorTable_Transparent;
            gula_DebugVarsPalak[4] = ((gs_TxIIRFilterSelect << 16) | 0x1214);
         }
      }
      else
      {
         pt_UsTxAttenPSDDescriptorTable = NULL;
      }


      if(pt_UsTxAttenPSDDescriptorTable != NULL)
      {

         //If the inband spectral shaping is not allowed, set the PSD attenuation about the first US tone to 0
         if(gft_DisallowInbandTssi == TRUE)
         {
            extern UsRawTssiPSDDescriptorTable_t gt_UsTxAttenPSDDescriptorTable_new;
            PSDRecord_t *pt_PSDRecord;
            int16 s_ToneIdx, s_PsdLevel, s_NumBrks;

            //Copy the TX attenuation PSD to a separate structure (preserving the original value)
            memcpy(&gt_UsTxAttenPSDDescriptorTable_new, pt_UsTxAttenPSDDescriptorTable, sizeof(UsRawTssiPSDDescriptorTable_t));

            pt_UsTxAttenPSDDescriptorTable = &gt_UsTxAttenPSDDescriptorTable_new;

            pt_PSDRecord = &(pt_UsTxAttenPSDDescriptorTable->ut_PSDRecord[0]);

            s_NumBrks = pt_UsTxAttenPSDDescriptorTable->us_NumberOfTones;
            for(j=0; j<s_NumBrks; j++)
            {
               s_ToneIdx = pt_PSDRecord[j].us_IndexOfTone;
               s_PsdLevel = pt_PSDRecord[j].s_PSDLevelOfTone;

               if(s_ToneIdx >= gsa_TxBandLeftChannel[0])
               {
                  pt_PSDRecord[j].us_IndexOfTone = gsa_TxBandLeftChannel[0];
                  pt_PSDRecord[j].s_PSDLevelOfTone = 0;
                  j++;

                  pt_UsTxAttenPSDDescriptorTable->us_NumberOfTones = j;

                  //zero out all remaining tones
                  while(j<s_NumBrks)
                  {
                     pt_PSDRecord[j].us_IndexOfTone = 0;
                     pt_PSDRecord[j].s_PSDLevelOfTone = 0;
                     j++;
                  }

                  break;
               }
            } //for(j=0; j<s_NumBrks; j++)
         } //if(gft_DisallowInbandTssi == TRUE)

         InterpolatePSDUtil_tssi(MAX_NUM_US_TSSI_PSD_POINTS,
                                 pt_ExpandPSDDescIn,
                                 (PSDDescriptorTable_t*)(void *)pt_UsTxAttenPSDDescriptorTable,
                                 s_MinAtten,
                                 &gs_min_atten_dB,
                                 (PSDDescriptorTable_t*)&gt_UsTSSIPSDDescriptorTable); //gt_UsTSSIPSDDescriptorTable
      }
      else
      {
         //Copy non TSSI PSD to the TSSI PSD for sending out as the message
         memcpy(&gt_UsTSSIPSDDescriptorTable, gt_TxPsdControl.pt_ActPsdDescOut, sizeof(UsPSDDescriptorTable_t));

      } //if(pt_UsTxAttenPSDDescriptorTable != NULL)

   } //if (gs_interp_psd_with_tssi==1)


   //XDSLRTFW-2260 (Start)
   if (gt_UsPsdCompensationTable.us_NumberOfTones)
   {

      FlagT ft_FailStateFlag = 0;

      // there must not be any duplicate ecremental order tone index in the compensation function
      for (i = 1 ; i <gt_UsPsdCompensationTable.us_NumberOfTones; i++)
      {
         if (gt_UsPsdCompensationTable.ut_PSDRecord[i-1].us_IndexOfTone >= gt_UsPsdCompensationTable.ut_PSDRecord[i].us_IndexOfTone)
         {
            ft_FailStateFlag = 1;
         }
      }
      if (ft_FailStateFlag)
      {
         EnterFailStates(E_CODE_TX_EXTERNAL_PSD_COMPENSATIOM_CONFIGURATION);
      }
   }
   //XDSLRTFW-2260 (End)




   /*****************************************************
   // Go back throught the tones, and adjust the levels based on the
   // adjustment we will make to MaxNomPSD, and convert the levels to
   // multiplicative gains.We also record the new MaxNomPSD.
   *****************************************************/
   gt_TxPsdControl.s_MaxNomPsdOut = gt_TxPsdControl.s_MaxNomPsdIn + gs_min_atten_dB;
   for (i=0; i < gs_TxNumTones; i++)
   {
      if ( *(ghpuca_TxExtGains_Inactive+i) & 0x10)
      {

         PSDDescriptorTable_t *pt_ActPsdDesc;

         if (gs_interp_psd_with_tssi==1)
         {
            // XDSLRTFW-232(Start)
            // Performance optimization:Performance improves on long (US0 only), low/no noise loops by up to 64 kbps
            // 1. Performance optimization is done up to now only for US0 oPOTS configuration (US0-spectrum: tone 6-32)
            // 2. If US oPOTS is used we force the out-of-band TSSI values for the CO TDQ training phase to: ...
            // Lower OOB tone Idx (0,4 are shaped with -6.0dB dB TxATTEN ) and  Upper OOB tone idx (36 =-0.0 dB &
            // tone idx 54 = -62.0 dB) TxATTEN is applied.
            // 3. All other modes still use the old code

            if((gs_TxIIRFilterSelect  == OPTN_POTS_LP_Filter_Select)&& ((TESTArray[TEST_JIRA2257_CONFIG] & TEST_ENABLE_TXTSSI_SHAPE) == TEST_ENABLE_TXTSSI_SHAPE))
            {
               /* flip between the two settings */
               pt_ActPsdDesc = (PSDDescriptorTable_t *)&gt_Shape_UsTSSIPSDDescriptorTable; /*  PSD shaped from Tone 0-6 &  32 -64*/
               // pt_ActPsdDesc = (PSDDescriptorTable_t *)&gt_DBG_UsTSSIPSDDescriptorTable; /* flat PSD shape Tone 0-6 & 32 to 64, user-debug*/
            }
            else
            {
               pt_ActPsdDesc = (PSDDescriptorTable_t *)&gt_UsTSSIPSDDescriptorTable;
            }
            // XDSLRTFW-232(End)

         }
         else
         {
            pt_ActPsdDesc = gt_TxPsdControl.pt_ActPsdDescOut;
         }

         ghpsa_TxFineGains_Inactive[i] = ComputeLinearPSD(i, pt_ActPsdDesc);

      }
   }

   // Don't transmit if tone is a blackout carrier
   if((gus_ModemOperationMode_Status & MODEM_OPERATION_MODE_VDSL2) & (gus_VdslStatusFlag & BITMAP_TX_APPLY_BLACKOUT))
   {
      for(i=0; i<gs_NumOfUsBlackoutBands; i++)
      {
         for (j = gsa_UsBlackoutBandLeftChannel[i]; j <= gsa_UsBlackoutBandRightChannel[i]; j++)
         {
            // Check direction bit == TX
            if (*(ghpuca_TxExtGains_Inactive+j) & 0x10)
            {
               *(ghpsa_TxFineGains_Inactive+j) = 0x0;
            }
         }
      }
   }

   if (gs_interp_psd_with_tssi==1)
   {
      // Deactivate TSSI tones surrounding band 0, so they will not be used
      // during nonTDQ states.

      for (j=1; j< gsa_TxBandLeftChannel[0]; j++)
      {
         *(ghpuca_TxExtGains_Inactive+j) &= ~0x10;
      }

      for (j=gsa_TxBandRightChannel[0]+1; j<= gsa_TxBandRightChannel[0]+32; j++)
      {
         *(ghpuca_TxExtGains_Inactive+j) &= ~0x10;
      }

      // Restore original ghpsa_TxFineGains_Inactive settings for tssi tones,
      // and save the just calculated ones.
      Switch_TxFineGains_Tssi();

      //gs_interp_psd_with_tssi = 0;

   } //if (gs_interp_psd_with_tssi==1)

}

//XDSLRTFW-2059 (START)
void ReConfigTSSI_FG()
{

   gt_TxPsdControl.s_MaxNomPsdOut = gt_TxPsdControl.s_MaxNomPsdIn + gs_min_atten_dB;
   for (int16 i=0; i < gs_TxNumTones; i++)
   {
      if ( *(ghpuca_TxExtGains_Inactive+i) & 0x10)
      {

         PSDDescriptorTable_t *pt_ActPsdDesc;

         if (gs_interp_psd_with_tssi==1)
         {
            pt_ActPsdDesc = (PSDDescriptorTable_t *)&gt_UsTSSIPSDDescriptorTable;
         }
         else
         {
            pt_ActPsdDesc = gt_TxPsdControl.pt_ActPsdDescOut;
         }

         ghpsa_TxFineGains_Inactive[i] = ComputeLinearPSD(i, pt_ActPsdDesc);

      }
   }
}
//XDSLRTFW-2059 (END)





/*^^^
*----------------------------------------------------------------------------------------
*
*  Name : ConfigIfftScales
*
*   Prototype:
*      void ConfigIfftScales(void)
*
*   Abstract:
*      The function determines appropriate settings for the IFFT scalebacks, based on fine gains,
*      and writes these settings to HW.
*      The corresponding gain through the IFFT is calculated and left in the globals
*      gs_TxIfftGain_pow2, gs_TxIfftGain_sqrt2.  The signal level at the txvargain input is calculated
*      and left in the global gs_TxVarGainIn_dB
*
*
*   Input Parameters:
*
*   Global Variables:
*   gs_TxLog2IfftLength, gs_NumOfTxBands,gsa_TxBandLeftChannel,gsa_TxBandRightChannel, ghpsa_TxFineGains_Inactive
*   gs_TxIfftGain_dB, gs_TxVarGainIn_dB
*
*----------------------------------------------------------------------------------------
^^^*/

void ConfigIfftScales(void)
{
   uint32 ul_acc;
   int16 i, j, s_scl, s_rshift;

   //Accumulate an average ms gain for the IFFT fine gains.
   ul_acc = 0;


   s_scl = 5;   //scale the accumulator value up to improve the precision (without causing the overflow)
   s_rshift = (gs_TxLog2IfftLength-1-s_scl);
   for(i=0; i<gs_NumOfTxBands; i++)
   {
      for (j = gsa_TxBandLeftChannel[i]; j <= gsa_TxBandRightChannel[i]; j++)
      {
         // ghpsa_TxFineGains_Inactive[] is 3.13, with value of 0x2000 for unity fine gain
         // the range of fine gain is from 0.1888 (-14.5 dB) to 1.33 (+2.5dB), so the maximum value
         // in ghpsa_TxFineGains_Inactive[] is 0x2000*1.33 = 0x2A8F
         // maximum number of tones in average is 2^(gs_TxLog2IfftLength-1),
         // so max acc is 2^(13+13+gs_TxLog2IfftLength-1 - scl), where products are shifted
         // up scl bits to improve the precision.
         ul_acc += (((int32)ghpsa_TxFineGains_Inactive[j]) * ((int32)ghpsa_TxFineGains_Inactive[j]) >> s_rshift);
      }
   }

   //Scale so the average is in 6.26 format.
   ul_acc >>= s_scl;

   //Calculate the average signal level at the ifft input.
   //This will be used as a basis for ifft scaleback settings.
   //ConvertToDB treats input as 32.0, whereas ul_acc is in 6.26,
   //so adjust output down by 10*log10(2^26)=2*10*log10(2^13), in 8.8 format (which is output format).
   gs_avg_ifft_in_dB = ConvertToDB(ul_acc) - (int16) (CONST_GAIN_8192_DB<<1);            //Avg fine gains


   //gs_avg_ifft_in_dB += ConvertToDB(TX_NEG165DBM*TX_NEG165DBM) - CONST_GAIN_2pow30_DB;      //QAM costellation level
   gs_avg_ifft_in_dB += TX_NEG165DBM_DB - CONST_GAIN_2pow30_DB;

   // Determine the IFFT scaleback settings, with pretwiddle set for scaleback 1.
   // Butterfly scalebacks will be set for 12, 6, or 0 dB gain, giving total gains of
   // 6, 0, or -6 dB, including the pretwiddle scaleback loss of 6 dB.
   // The benefit from deactivating additional scalebacks would be neglible.
   // IFFT scaleback reg [31:0] format is [1:0] for pretwiddle, [3:2], ..., [13:12] for ifft stages 0, ..., 5.

   if (gs_avg_ifft_in_dB <= IFFT_IN_THRESH_DB_FOR_GAIN_6)
   {
      gs_TxIfftGain_dB = (int16) GAIN_6_dB;   // 2 unscaled butterflies, plus gain .5 pretwiddle scaleback
   }
   else if (gs_avg_ifft_in_dB <= IFFT_IN_THRESH_DB_FOR_GAIN_0)
   {
      gs_TxIfftGain_dB = 0;   // 1 unscaled butterflies, plus gain .5 pretwiddle scaleback
   }
   else
   {
      if (gft_EnableIfftScalesFix == TRUE)
      {
         if (gs_avg_ifft_in_dB <= IFFT_IN_THRESH_DB_FOR_GAIN_NEG6)
         {
            gs_TxIfftGain_dB = (int16) -GAIN_6_dB;   // 0 unscaled butterflies, plus gain .5 pretwiddle scaleback
         }
         else
         {
            gs_TxIfftGain_dB = (int16) -GAIN_12_dB;   // 1 butterfly scaled by 0.25, 5 butterflies scaled by 0.5, plus gain .5 pretwiddle scaleback
         }
      }
      else
      {
         gs_TxIfftGain_dB = (int16) -GAIN_6_dB;   // 0 unscaled butterflies, plus gain .5 pretwiddle scaleback
      }
   }

   // Force TxIFFT Gain
   // Debug code to be able to force the TxIIFT gain
   // Option 1 (default): disable forcing by setting
   // if (gt_TxPsdControl.s_Force_TxIfftGain_dB == 6)
   //    gs_TxIfftGain_dB = GAIN_6_dB;
   // else if (gt_TxPsdControl.s_Force_TxIfftGain_dB == 1)
   //    gs_TxIfftGain_dB = 0;
   // else if (gt_TxPsdControl.s_Force_TxIfftGain_dB == -6)
   //    gs_TxIfftGain_dB = (-GAIN_6_dB);
   // else if (gt_TxPsdControl.s_Force_TxIfftGain_dB == -12)
   //    gs_TxIfftGain_dB = (-GAIN_12_dB);


   // set the IFFT scalings depending on the IFFT gain
   if (gs_TxIfftGain_dB == (GAIN_6_dB) )
      gul_ifft_scales_cntl_word = 0x00001541;
   else if (gs_TxIfftGain_dB == 0 )
      gul_ifft_scales_cntl_word = 0x00001551;
   else if (gs_TxIfftGain_dB == (-GAIN_6_dB) )
      gul_ifft_scales_cntl_word = 0x00001555;
   else if (gs_TxIfftGain_dB == (-GAIN_12_dB) )
      gul_ifft_scales_cntl_word = 0x0000155D;

   //for 6.2 HW, the IFFT of 2048 tones is achieved by using 5 radix-4 and 1 radix-2
   //It is noted that radix-2 stage adds 3 dB gain and radix-4 stage adds 6 dB gain
   //Applying scaling of 0.5 is equivalent to add -6 dB scale
   //Thus if we always apply 0.5 for stage 6 where radix-2 is used,
   //then we should subtract 3 dB from the previous calculation where the radix-4 was assumed for stage 6.
   if (((gs_TxLog2IfftLength-1)&0x1)==1)
   {
      gs_TxIfftGain_dB -= (int16) (GAIN_6_dB>>1);
   }

   //Calculate signal level at txvargain input, to be available for later txvargain setting calculations.
   gs_TxVarGainIn_dB = gs_avg_ifft_in_dB + gs_TxIfftGain_dB;

}

/*^^^
*----------------------------------------------------------------------------------------
*
*  Name : ConfigTxVarGain
*
*   Prototype:
*      void ConfigTxVarGain(void)
*
*   Abstract:
*      The function determines appropriate settings for digital time-domain tx path gain txvargain, and
*      analog TX path gain, and writes these settings to HW.  The calculations are based on the equation below,
*      followed by the imposition of gain limits, quantization, and keeping PARR sufficiently small.
*
*      Assuming 0 dB digital TX filter passband gain, we have
*      line_psd_dBm_Hz = 10*log10( TX_NEG165DBM^2 * 2^(2*gs_TxIfftGain_pow2)*2^gs_TxIfftGain_sqrt2*
*                           gs_TxVarGain^2 * 2^(2*gs_TxVarGainExp) * ...
*                           V_pk_dac^2 * (1000/100) * anlg_tx_filter_gain^2 * afe_tx_gn^2 * ld2lin_gain^2 / ...
*                           (gs_TxNumTones*bin_width_hz) ) - gs_tx_iir_atten_dB
*
*      Note that the IFFT fine gains effectively adjust the target
*      line_psd_dBm_Hz, so they can be ignored in the above equation.
*      For the most recent model, ld2lin_gain=10^(22.5/20)=13.34,
*      [ld2lin_gain may be somewhat different in band0 than elsewhere.  That could be accomodated by adjusting
*      the fine gains to make up the difference, and calculating the avg ifft input power for band 0 separately,
*      so that extra/less line gain can be applied there during the below calculation of gs_tx_power_dBm_line.  No
*      adjustment would be needed for the txvargain and AFE TX gain setting calculations however.]
*      Setting line_psd_dBm_Hz = - gt_PwrConfigParam.s_Dn/Up_MaxNomPSD/10, and solving for
*      gs_TxVarGain*2^(gs_TxVarGainExp)*tx_afe_gain_gn^2, we determine the composite gain required to be at mask,
*      at the line.  This gain will be distributed between txvargain and AFE TX gain, depending on signal levels,
*      gain limits, and quantization.
*
*   Input Parameters:
*
*   Global Variables:
*   gt_PwrConfigParam, gs_TxNumTones,
*   gs_TxVarGainIn_dB, gs_TxVarGain_dB, gs_TxVarGain, gs_TxVarGainExp, gs_TxVarGain_Inadequacy_dB
*   gs_tx_afe_gain_setting_dB, gs_tx_afe_gain_inadequacy_dB
*   gs_TxIfftGain_dB
*   gs_tx_power_dBm_line
*   gs_tx_iir_atten_dB
*----------------------------------------------------------------------------------------
^^^*/

void ConfigTxVarGain(int16 s_TxNomPsd)
{
   int32 l_acc_dB, l_tmp;
   int16 s_pass;
   int16 s_DfeTxVGOffset = 0;

   gs_tx_afe_trim1_gain_dB =  0; // Intialize this to 0dB first
   //gs_max_fc_MHz           = 33; // Initialize to max Frequency used (40MHz), default settings for all modes if
   // supported settings are: 5 (5MHz), 10 (10MHz), 20 (20MHz), 33 (33MHz), 40 (40MHz)

   // We need to reset gs_MAX_PERMISSIBLE_TXVGN_OUT_DB to the default value here, since this routine
   // is executed multiple times during training and we make delta adjustments to gs_MAX_PERMISSIBLE_TXVGN_OUT_DB
   if (gft_EnableTxVarGainFix == TRUE)
   {
      gs_MAX_PERMISSIBLE_TXVGN_OUT_DB = (int16)MAX_PERMISSIBLE_TXVGN_OUT_DB - (int16)0x0100 - gs_TxVarGain_margin; // -17dB in Q8.8
   }
   else
   {
      gs_MAX_PERMISSIBLE_TXVGN_OUT_DB = (int16)MAX_PERMISSIBLE_TXVGN_OUT_DB - gs_TxVarGain_margin ; // -16dB in Q8.8
   }

   for (s_pass=1; s_pass<=2; s_pass++)
   {
      // Initialize l_acc_dB to target line PSD in dBm/Hz, 8.8 format,
      // then add/subtract various TX PATH gains and PSD calculation parameters,
      // according to the equation in the abstract.

      // Example:
      //                         |                      | l_acc_dB |
      // +s_TxNomPsd             |         -74.0 dBm/Hz |    -74.0 |
      // -(TX_NEG165-CONST_G)    |           8.5 dB     |    -65.5 |
      // -TxIFFTGain             |           6.0 dBm/Hz |    -59.5 |
      // +gs_tx_iir_atten_dB     |           0.0        |          | NOT USED ANYMORE !!!
      // -PEAK_DAC_DBV           |           2.5 dB     |    -57.0 |
      // -10<<8                  |         -10.0 dB     |    -67.0 |
      // -gl_ld_line_gain_db     |         -16.7 dB     |    -83.7 |
      // +10*log10(4096)         |          36.0 dB     |    -47.7 |
      // +10*log10(4312)         |          36.3 dB     |    -11.4 |
      //
      // here is l_acc now the desired TotalGain of TxVarGain + POFI-POCO gain
      // which is needed to bring a tone with FG = 0dB to NomPSD level on the line

      l_acc_dB = ((-(int32) (s_TxNomPsd))<<8)/10;

      // Note that the function int16 ConvertToDB(int32 l_xin)  is used with Q32.0 input, providing Q8.8 output.
      // So, if a 1.15 X 1.15 = 2.30 input is passed to ConvertToDB, we need to subtract CONST_GAIN_2pow30_DB
      // from result to put in 8.8 dB format.

      //l_acc_dB -= (int32) ConvertToDB(TX_NEG165DBM*TX_NEG165DBM) - CONST_GAIN_2pow30_DB; //Ifft input level (0 dB fine gains)
      l_acc_dB -= (int32)TX_NEG165DBM_DB - CONST_GAIN_2pow30_DB;

      //Note IFFT fine gains are effectively an adjustment to MaxNomPSD, and can be ignored here.
      l_acc_dB -= (int32) gs_TxIfftGain_dB;            //Gain through IFFT.
      l_acc_dB += (int32) gs_tx_iir_atten_dB;            //TX IIR attenuation (at DC).
      l_acc_dB -= (int32) PEAK_DAC_DBV;               //Peak DAC voltage
      l_acc_dB -= (int32) 10<<8;                     //conversion from V^2 to mW (=milli watts = watt/1000), format 8.8
      l_acc_dB -= (int32) gl_ld_line_gain_db;            //LD2line gain
      l_acc_dB += (int32) ConvertToDB(gs_TxNumTones);      //IFFT size in tones
      //Implementation Margin 0.7dB is desired; But we saw US0 violate by 0.9dB and US1/2/3 by 0.2dB; So flat reduce by 0.2dB an US0 by 0.7dB
      l_acc_dB -= (int32) TX_PSD_IMPLEMENTATION_MARGIN_0pt5_dB;

      l_acc_dB += (int32) gt_TxPsdControl.s_US_PSD_Boost_TimeDomain; //XDSLRTFW-3990: include time domain frequency independent boost component

      l_acc_dB -= (int32) gs_tx_psd_offset_dB_dbg;

      if (gs_frame_rate_is_8khz==1)
      {
         l_tmp = 8625;
      }
      else
      {
         l_tmp = 4312;
      }

      l_acc_dB += (int32) ConvertToDB(l_tmp);         //Tone spacing, in Hz


      // l_acc_dB is now the composite gain needed in the TX path to be at mask at line.
      // Will put as much of this gain as possible in txvargain.  The rest goes in gs_tx_afe_gain_setting_dB,
      // under the limit and quantization constraints [-18:1:6] of gs_tx_afe_gain_setting_dB.

      // gt_GainCalibration.s_TxGain allows manual fine tuning:
      l_acc_dB += (gt_GainCalibration.s_TxGain << 8)/10;


      // Examples:
      // MAX_TXVARGAIN_dB :  18dB
      // l_acc_dB         : -11dB
      // gs_         | gs_         | MAX_PERMISSIBLE_ | gs_                  | gs_                 |          | gs_       |
      // avg_ifft_in | TxVarGainIn | TXVGN_OUT        | TxVarGain_Inadequacy | tx_afe_gain_setting |          | TxVarGain |
      // _dB         | _dB         | _DB              | _dB                  | _dB[0]              |      [1] | _dB       |
      //    -16.7 dB |    -22.7 dB |         -16.0 dB |               0.0 dB |            -17.7 dB | -10.0 dB |   -1.0 dB |


      //      -16 dB |      -22 dB |            -16dB |                 0 dB |
      //      -16 dB |      -33 dB |            -16dB |                 0 dB |
      //      -16 dB |      -35 dB |            -16dB |                 1 dB |

      // Desired TxVarGain setting is (MAX_PERMISSIBLE_TXVGN_OUT_DB - gs_TxVarGainIn_dB).
      // Max HW setting is 7fff*2^3 = 18 dB.  Check if this is less than desired.
      // Note that gs_TxVarGainIn_dB has the effect of the IFFT fine gains incorporated.
      if ((gs_MAX_PERMISSIBLE_TXVGN_OUT_DB - gs_TxVarGainIn_dB) >= MAX_TXVARGAIN_dB)
         //Note that nonzero inadequacy does not result in submask PSD at line unless
         //gs_tx_afe_gain_inadequacy_dB calculated below is also nonzero.
      {
         gs_TxVarGain_Inadequacy_dB = (int16) gs_MAX_PERMISSIBLE_TXVGN_OUT_DB - gs_TxVarGainIn_dB - (int16) MAX_TXVARGAIN_dB;
      }
      else
      {
         gs_TxVarGain_Inadequacy_dB = 0;
      }


      // Desired tx_afe_gain setting
      gs_tx_afe_gain_setting_dB = l_acc_dB - (gs_MAX_PERMISSIBLE_TXVGN_OUT_DB - gs_TxVarGainIn_dB - gs_TxVarGain_Inadequacy_dB);      // format: 8.8dB

      if (gs_tx_afe_gain_setting_dB >= MAX_TX_AFE_GAIN_SETTING_DB)
      {
         //TX AFE has insufficient gain. We will be below mask at line.
         gs_tx_afe_gain_inadequacy_dB = gs_tx_afe_gain_setting_dB - (int16) MAX_TX_AFE_GAIN_SETTING_DB;
         gs_tx_afe_gain_setting_dB = MAX_TX_AFE_GAIN_SETTING_DB;   // format: 8.8dB
         gs_TxVarGain_dB = gs_MAX_PERMISSIBLE_TXVGN_OUT_DB - gs_TxVarGainIn_dB - gs_TxVarGain_Inadequacy_dB;
      }
      else
      {
         //TX AFE has sufficient gain.  We will be at mask, at line.
         gs_tx_afe_gain_inadequacy_dB = 0;
         // Apply remaining in AFE Gain
         if (gs_tx_afe_gain_setting_dB <= MIN_TX_AFE_GAIN_SETTING_DB)
         {
            gs_tx_afe_gain_setting_dB = MIN_TX_AFE_GAIN_SETTING_DB;
         }
         else
         {
            // Take ceiling here for gs_tx_afe_gain_setting_dB, to ensure that digital levels
            // determined below by gs_TxVarGain_dB adjustment are sufficiently small.
            //(the following code is equivalent to compute ceil(gs_tx_afe_gain_setting_dB) in 1 dB step (256 in 8.8 format)

            gs_tx_afe_gain_setting_dB = MAX_TX_AFE_GAIN_SETTING_DB - gs_tx_afe_gain_setting_dB;
            gs_tx_afe_gain_setting_dB = gs_tx_afe_gain_setting_dB / ((int16) RESOLN_TX_AFE_GAIN_SETTING_DB);
            gs_tx_afe_gain_setting_dB = MAX_TX_AFE_GAIN_SETTING_DB - (gs_tx_afe_gain_setting_dB *
                                        ((int16) RESOLN_TX_AFE_GAIN_SETTING_DB));
         }

         // gs_tx_afe_gain_setting_dB can only have increased, so in the below calculation,
         // s_TxVarGain_dB is less than (MAX_PERMISSIBLE_TXVGN_OUT_DB - gs_TxVarGainIn_dB - gs_TxVarGain_Inadequacy_dB),
         // and so is implementable in HW.
         gs_TxVarGain_dB = l_acc_dB - gs_tx_afe_gain_setting_dB;
      }
      //XDSLRTFW-3495 Start
      // Swapping AFE and DFE gains for US0 case
      //For example we are using TXIIR filter for POFI gain of 7 dB. Say FW calculates DFE Variable Gain = 15 dB and AFE Pofi Gain = -1dB(Total = 14dB).
      //Redistribute the gains as DFE Variable Gain = 15-8= 7dB and AFE Pofi Gain = -1+8 = 7dB(Total = 14 dB). Since TXIIR filter for particular profile is desined
      // based POFI fc and gain companesation.PFO Freq response will change if Fc and gain changes. So it is required for 518 that we should configure the POFI
      // for the fc and gain for which filter si designed
      //US0 case, normally TxNomPSD will be high, so DAC quantization noise may not be high though DFE Variable gain is reduced
      {
         int16 s_gaindiff = 0;
         int16 s_AfeGainNew = 0;
         FlagT ft_SwapGains = TRUE;

         if (gs_TxIIRFilterSelect == OPTN_POTS_LP_Filter_Select)
         {
            s_DfeTxVGOffset = (int16) DFE_TX_VARGAIN_OFFSET_US0_POTS_17M;
            s_AfeGainNew = AFE_POFI_GAIN_US0_POTS_17M;
         }
         else if (gs_TxIIRFilterSelect == OPTN_ISDN_LP_Filter_Select)
         {
            s_DfeTxVGOffset = (int16) DFE_TX_VARGAIN_OFFSET_US0_ISDN_17M;
            s_AfeGainNew = (int16) AFE_POFI_GAIN_US0_ISDN_17M;
         }
         else if (gs_TxIIRFilterSelect == OPTN_POTS_DOUBLE_LP_Filter_Select)
         {
            s_DfeTxVGOffset = (int16) DFE_TX_VARGAIN_OFFSET_US0_ANNEXM_17M;
            s_AfeGainNew =(int16) AFE_POFI_GAIN_US0_ANNEXM_17M;
         }
         else if (gs_TxIIRFilterSelect == OPTN_POTS_QUAD_LP_Filter_Select)
         {
            s_DfeTxVGOffset = (int16) DFE_TX_VARGAIN_OFFSET_US0_EU128_17M;
            s_AfeGainNew = (int16) AFE_POFI_GAIN_US0_EU128_17M;
         }
         else if (gs_TxIIRFilterSelect == OPTN_35B_POTS_LP_Filter_Select) //XDSLRTFW-3570 Start
         {
            s_DfeTxVGOffset = (int16) DFE_TX_VARGAIN_OFFSET_US0_POTS_35M;
            s_AfeGainNew = AFE_POFI_GAIN_US0_POTS_35M;
         }
         else if (gs_TxIIRFilterSelect == OPTN_35B_ISDN_LP_Filter_Select)
         {
            s_DfeTxVGOffset = (int16) DFE_TX_VARGAIN_OFFSET_US0_ISDN_35M;
            s_AfeGainNew = (int16) AFE_POFI_GAIN_US0_ISDN_35M;
         }
         else if (gs_TxIIRFilterSelect == OPTN_35B_POTS_DOUBLE_LP_Filter_Select)
         {
            s_DfeTxVGOffset = (int16) DFE_TX_VARGAIN_OFFSET_US0_ANNEXM_35M;
            s_AfeGainNew =(int16) AFE_POFI_GAIN_US0_ANNEXM_35M;
         } //XDSLRTFW-3570 End
         else
         {
            ft_SwapGains = FALSE;
         }

         if (ft_SwapGains == TRUE) //Swap gains only in case of US0 only filters
         {
            s_gaindiff = gs_tx_afe_gain_setting_dB - s_AfeGainNew;//Diff of New and present afe gains
            gs_tx_afe_gain_setting_dB = s_AfeGainNew;
            gs_TxVarGain_dB = gs_TxVarGain_dB + s_gaindiff + s_DfeTxVGOffset;
         }
      }
   //XDSLRTFW-3495 End
      //Convert gs_TxVarGain_dB to a linear multiplicative gain.
      db_to_linear(gs_TxVarGain_dB, &gs_TxVarGain, &gs_TxVarGainExp);
      // Exponent (gs_TxVarGainExp) should be >=-4 && <= 3.
      // If not, limit it while adjusting mantissa (gs_TxVarGain) appropriately
      if (gs_TxVarGainExp < MIN_TXVARGAIN_EXP)
      {
         gs_TxVarGain = gs_TxVarGain >> (MIN_TXVARGAIN_EXP - gs_TxVarGainExp);
         gs_TxVarGainExp = MIN_TXVARGAIN_EXP;
      }
      else if (gs_TxVarGainExp > MAX_TXVARGAIN_EXP)
      {
         gs_TxVarGain = 32767;
         gs_TxVarGainExp = MAX_TXVARGAIN_EXP;
      }

      //Determine the total power at the line
      l_acc_dB  = (int32) gs_TxVarGainIn_dB;
      l_acc_dB += (int32) (gs_TxVarGain_dB-s_DfeTxVGOffset);
      l_acc_dB -= (int32) gs_tx_iir_atten_dB;                     //TX IIR attenuation (at DC).
      l_acc_dB += (int32) PEAK_DAC_DBV;                           //Peak DAC voltage
      l_acc_dB += (int32) 10<<8;                                  //conversion from V^2 to mW (=1000 watts), format 8.8
      l_acc_dB += (int32) gl_ld_line_gain_db;                     //LD2line gain
      l_acc_dB += (int32) gs_tx_afe_gain_setting_dB;              //TX AFE gain
      l_acc_dB += (int32) TX_PSD_IMPLEMENTATION_MARGIN_0pt5_dB;   //Implementation Margin

      // XDSLRTFW-3990:  TR115A: sync losses in AA12a and AA17a due to tx path clipping (Start)
      // Remove boosted power from gs_tx_power_dBm_line (which is used in TxActATP) calculation since
      // this boost is not communicate to CO.
      // ToDo: Please note that Frequency domain Tx PSD compensation is considered in gs_tx_power_dBm_line calculation.
      //       To make TxActATP standard compliant power increased by compensation function need to be removed.
      l_acc_dB -= (int32)gt_TxPsdControl.s_US_PSD_Boost_TimeDomain;
      //// XDSLRTFW-3990:  TR115A: sync losses in AA12a and AA17a due to tx path clipping(End)

      l_acc_dB += (int32) gs_tx_psd_offset_dB_dbg;
      gs_tx_power_dBm_line = (int16) l_acc_dB;


      break;
   }

}



/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ChooseUsCeiling
 *
 *  Description:
 *
 *      This function computes the new US ceiling based on the US PSD mask and UPBO PSD restriction.
 *      The purpose of it is to limit the US ceiling so that the difference between US0 and the other
 *      USx bands (x = 1 to NumTxBands-1) is moderate to avoid clipping on the CO side.
 *
 *  Prototype:
 *      void ChooseUsCeiling(int16 *ps_PsdCeilingUsed, PSDDescriptorTable_t *pt_ExpandPSDDescIn)
 *
 *  Input Arguments:
 *      ps_PsdCeilingUsed  -- pointer to the input US ceiling
 *      pt_ExpandPSDDescIn -- pointer to the extended US PSD mask table
 *
 *  Output Arguments:
 *      ps_PsdCeilingUsed -- pointer to the output US ceiling
 *
 *  Return:
 *
 *  Global Variables Used:
 *      gft_UPBO_is_enabled                   -- (I) flag to indicate if the UPBO is enabled or not
 *      gft_US0BandUsed                       -- (I) flag to indicate if the US0 is used or not
 *      gt_Kl0ElectricalLength.s_kl0_estimate -- (I) the estimated kl0 by CPE
 *      gs_NumOfTxBands                       -- (I) the number of TX (US) bands
 *      gsa_TxBandLeftChannel[]               -- (I) an array of left band edges
 *      gt_TxPsdControl.s_MaxNomPsdIn         -- (I) the maximum US PSD level
 *      gs_Kl0Threshold_LimitUsCeiling        -- (I) the kl0 value under which the US ceiling limit is applied
 *      gs_DeltaUsPsdCeilValue                -- (I) the allowed PSD difference between US0 and US1
 *      gs_AppliedUpboCeiling                 -- (O) if >= 0, this is the computed ceiling limit.
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void ChooseUsCeiling(int16 *ps_PsdCeilingUsed, PSDDescriptorTable_t *pt_ExpandPSDDescIn)
{
   int16 i, s_attenLevel=0;
   PSDRecord_t *pt_PSDRecIn;
   int16 sa_attenLevelarry[MAX_NUM_TX_BANDS];
   int16 j;
   FlagT ft_FlagTocheckActualPower=0;

   // Limit the maximum difference between the PSD level of US0 and USx to avoid
   // CO side clipping at short loops
   if ((gft_US0BandUsed)                        //US0 exists
         && (gt_Kl0ElectricalLength.s_kl0_estimate < gs_Kl0Threshold_LimitUsCeiling)      //short loop where kl0 of 9.5 dB is about 1000ft
         && (gs_NumOfTxBands > 1))                     //at least 2 bands
   {
      //Find the PSD attenuaion from the PSD mask at the left band edge of US1
      pt_PSDRecIn = &(pt_ExpandPSDDescIn->ut_PSDRecord[0]);

      for (j=0; j<gs_NumOfTxBands; j++)
      {
         sa_attenLevelarry[j] = -1;
         for(i = 0; i<pt_ExpandPSDDescIn->us_NumberOfTones; i++)
         {
            if(gsa_TxBandLeftChannel[j+1] == pt_PSDRecIn[i].us_IndexOfTone)
            {
               sa_attenLevelarry[j] = pt_PSDRecIn[i].s_PSDLevelOfTone;
               ft_FlagTocheckActualPower = 1;
               break;
            }
         }
      }//j


      if(ft_FlagTocheckActualPower)
      {
         for (j=0; j<gs_NumOfTxBands; j++)
         {
            if (sa_attenLevelarry[j] != -1)
            {
               // Get the actual psd attenuations with upbo (also limited by the mask)
               // for the left tone edge of US1 band
               if(gft_UPBO_is_enabled == TRUE)
               {
                  sa_attenLevelarry[j] = GetUPBOAttenLevel(gsa_TxBandLeftChannel[j+1], sa_attenLevelarry[j]);
               }

               // Compute the absolute PSD level
               sa_attenLevelarry[j] += gt_TxPsdControl.s_MaxNomPsdIn;

               // Set the ceiling to be above the max USx PSD by a predefined amount
               sa_attenLevelarry[j] -= gs_DeltaUsPsdCeilValue;
               s_attenLevel = sa_attenLevelarry[j];
            }
         }

         for (j=0; j<gs_NumOfTxBands; j++)
         {
            // pick the min attenuation value, i.e. the max PSD value.
            if ((sa_attenLevelarry[j] < s_attenLevel) && (sa_attenLevelarry[j] != -1))
            {
               s_attenLevel = sa_attenLevelarry[j];
            }
         }

         //Choose the initial US PSD ceiling to be limited by the above level
         gs_AppliedUpboCeiling = -1;
         //XDSLRTFW-2040: Check for UPBO Min Values and enable only US0
         if( (s_attenLevel > *ps_PsdCeilingUsed) && (gft_USx_Disable == 0) ) //snv
         {
            *ps_PsdCeilingUsed = s_attenLevel;

            //Record the applied UPBO ceiling
            gs_AppliedUpboCeiling = s_attenLevel;
         }
      }
      else
      {
         //Enter Fail state
      }

   } //if(gft_UPBO_is_enabled == TRUE)
} //void ChooseUsCeiling(int16 *ps_PsdCeilingUsed)

//XDSLRTFW-2059 (Start)
/*^^^
*------------------------------------------------------------------------
*
*  Name : SelectPSDCompensationFunction

*
*   Prototype:
*       void SelectPSDCompensationFunction(FlagT ft_EnableMaximumCompensation
*
*   Abstract:
*      This function determines the PSD compensation in dB required to fulfill
*      the REFPSD based on selected Tx IIR filter, POFIPOCO cutoff frequency,
*      POFIPCOC Trim1 gain (Extra gain) and POFIPOCO gain setting.
*
*   Output Parameter: Output of this function stored in gt_PSDCompData structure.
*
*   Input:
*   ft_EnableMaximumCompensation
*
*   Input Global Variables:
*   gs_max_fc_MHz
*   gs_tx_afe_trim1_gain_dB
*   gs_tx_afe_gain_setting_dB
*   gt_PSDCompData.us_TxIIRFilter
*   gt_PSDCompDescriptorTable
*   gsa_TxBandRightChannel / gs_NumOfTxBands / gft_UseUS0Only
*
*   Output Global Variables:
*   gt_PSDCompData.us_PofiPocoCutOffFreq
*   gt_PSDCompData.s_PofiExtraGain
*   gt_PSDCompData.s_PofiGain
*   gt_PSDCompData.us_FilterCompIdx
*   gt_PSDCompData.t_PSDCompTable
*   gt_PSDCompData.us_NumberOfCompBreakPoint
*
*-----------------------------------------------------------------------------
^^^*/

void SelectPSDCompensationFunction(FlagT ft_EnableMaximumCompensation )
{
   int16 s_FilterIndex = 0;
   int16 s_FreqDependentOffest = 0;
   uint8 uc_CompTablePageHandle;
   PSDCompDescriptorTable_t *pDEST;

   // Is gs_max_fc_MHz still supported?
   // It is always set to 28MHz
   // but the variable initialization says:
   // int16 gs_max_fc_MHz = 28;    // format: 16.0MHz, supported settings are: 5 (5MHz), 10 (10MHz), 20 (20MHz), 33 (33MHz), 40 (40MHz)
   gt_PSDCompData.us_PofiPocoCutOffFreq = gs_max_fc_MHz;
   gt_PSDCompData.s_PofiExtraGain       = gs_tx_afe_trim1_gain_dB;
   gt_PSDCompData.s_PofiGain            = gs_tx_afe_gain_setting_dB>>8;
   //gt_PSDCompData.t_PSDCompTable = (PSDCompDescriptorTable_t){7,928,-4,1160,-4,2087,-6,2551,-7,2783,-8,3131,-9,3250,-10};


   // Do we still need this section?
   // If not: remove gs_max_fc_MHz / s_FreqDependentOffest
   switch(gs_max_fc_MHz)
   {
   case 5:
      s_FreqDependentOffest = 0;
      break;

   case 28:
      s_FreqDependentOffest = 0;
      break;
   }

   // #define OPTN_BYPASS_Filter_Select                  0x0000
   // #define OPTN_POTS_Filter_Select                    0x0001
   // #define OPTN_POTS_DOUBLE_Filter_Select             0x0002
   // #define OPTN_ISDN_Filter_Select                    0x0003
   // #define OPTN_35B_VDSL_Filter_Select                0x0004
   // #define OPTN_35B_VDSL_POTS_DOUBLE_Filter_Select    0x0005
   // #define OPTN_35B_VDSL_ISDN_Filter_Select           0x0006
   // #define OPTN_POTS_LP_Filter_Select                 0x0007
   // #define OPTN_ISDN_LP_Filter_Select                 0x0008
   // #define OPTN_POTS_DOUBLE_LP_Filter_Select          0x0009
   // #define OPTN_POTS_QUAD_LP_Filter_Select            0x000A
   // #define OPTN_35B_POTS_LP_Filter_Select             0x000B
   // #define OPTN_35B_ISDN_LP_Filter_Select             0x000C
   // #define OPTN_35B_POTS_DOUBLE_LP_Filter_Select      0x000D
   // #define OPTN_35B_POTS_QUAD_LP_Filter_Select        0x000E

   // if US0 only
   if ( gt_PSDCompData.us_TxIIRFilter >= OPTN_POTS_LP_Filter_Select) //For US0 only Tx IIR filters
   {
      // t_PSDCompData.us_TxIIRFilter          | gt_PSDCompData.us_FilterCompIdx
      // --------------------------------------+----------------------------------
      //OPTN_POTS_LP_Filter_Select                 0x0007   //140
      //OPTN_ISDN_LP_Filter_Select                 0x0008   //141
      //OPTN_POTS_DOUBLE_LP_Filter_Select          0x0009   //142
      //OPTN_POTS_QUAD_LP_Filter_Select            0x000A   //143
      //OPTN_35B_POTS_LP_Filter_Select             0x000B   //144
      //OPTN_35B_ISDN_LP_Filter_Select             0x000C   //145
      //OPTN_35B_POTS_DOUBLE_LP_Filter_Select      0x000D   //146
      //OPTN_35B_POTS_QUAD_LP_Filter_Select        0x000E   //147
      gt_PSDCompData.us_FilterCompIdx = (TX_PSD_COMPENSATION_TABLE_SIZE-OPTN_35B_POTS_QUAD_LP_Filter_Select-1)+gt_PSDCompData.us_TxIIRFilter;
   }
   else
   {
      if (ft_EnableMaximumCompensation)
      {
         // t_PSDCompData.us_TxIIRFilter                  | gt_PSDCompData.us_FilterCompIdx
         // --------------------------------------        +----------------------------------
         // OPTN_BYPASS_Filter_Select                 (0) |  19
         // OPTN_POTS_Filter_Select                   (1) |  39
         // OPTN_POTS_DOUBLE_Filter_Select            (2) |  59
         // OPTN_ISDN_Filter_Select                   (3) |  79
         // OPTN_35B_VDSL_Filter_Select               (4) |  99
         // OPTN_35B_VDSL_POTS_DOUBLE_Filter_Select   (5) | 119
         // OPTN_35B_VDSL_ISDN_Filter_Select          (6) | 139
         gt_PSDCompData.us_FilterCompIdx = gt_PSDCompData.us_TxIIRFilter*20 + s_FreqDependentOffest +19;
      }
      else
      {
         // #define MAX_TX_AFE_GAIN_SETTING_DB          (9*256)   //   9.0 dB in 8.8 format
         // #define MIN_TX_AFE_GAIN_SETTING_DB        (-10*256)   // -10.0 dB in 8.8 format

         if (gs_tx_afe_gain_setting_dB <= 0 )
         {
            // The code does NOT work for gt_PSDCompData.us_TxIIRFilter > OPTN_POTS_LP_Filter_Select
            // Comment: If we know that we never reach this point if US0 filters are used
            //          we can (probably) also remove the US0 settings for ft_EnableMaximumCompensation == TRUE

            //              | gt_PSDCompData.us_FilterCompIdx
            // gs_tx_afe_gain_setting_dB                     |   0 |  -1 |  -2 | ... | -10
            // --------------------------------------        +-----+-----+-----+-----+-----
            // OPTN_BYPASS_Filter_Select                 (0) |   0 |   1 |   2 | ... |  10
            // OPTN_POTS_Filter_Select                   (1) |  20 |  21 |  22 | ... |  30
            // OPTN_POTS_DOUBLE_Filter_Select            (2) |  40 |  41 |  42 | ... |  50
            // OPTN_ISDN_Filter_Select                   (3) |  60 |  61 |  62 | ... |  70
            // OPTN_35B_VDSL_Filter_Select               (4) |  80 |  81 |  82 | ... |  90
            // OPTN_35B_VDSL_POTS_DOUBLE_Filter_Select   (5) | 100 | 101 | 102 | ... | 110
            // OPTN_35B_VDSL_ISDN_Filter_Select          (6) | 120 | 121 | 122 | ... | 130
            // OPTN_POTS_LP_Filter_Select                (7) | 140 | 140 | 140 | ... | 140   => All US0 Filter have 0dB Compensation as these filters are pre-compensated ones
            // OPTN_ISDN_LP_Filter_Select                (8) | 141 | 141 | 141 | ... | 141   => All US0 Filter have 0dB Compensation as these filters are pre-compensated ones
            // OPTN_POTS_DOUBLE_LP_Filter_Select         (9) | 142 | 142 | 142 | ... | 142   => All US0 Filter have 0dB Compensation as these filters are pre-compensated ones
            // OPTN_POTS_QUAD_LP_Filter_Select          (10) | 143 | 143 | 143 | ... | 143   => All US0 Filter have 0dB Compensation as these filters are pre-compensated ones
            // OPTN_35B_POTS_LP_Filter_Select           (11) | 144 | 144 | 144 | ... | 144   => All US0 Filter have 0dB Compensation as these filters are pre-compensated ones
            // OPTN_35B_ISDN_LP_Filter_Select           (12) | 145 | 145 | 145 | ... | 145   => All US0 Filter have 0dB Compensation as these filters are pre-compensated ones
            // OPTN_35B_POTS_DOUBLE_LP_Filter_Select    (13) | 146 | 146 | 146 | ... | 146   => All US0 Filter have 0dB Compensation as these filters are pre-compensated ones

            gt_PSDCompData.us_FilterCompIdx = gt_PSDCompData.us_TxIIRFilter*20 + s_FreqDependentOffest - (gs_tx_afe_gain_setting_dB>>8);
         }
         else
         {
            // Assumption !!! : code works if gs_tx_afe_gain_setting_dB is always a multiple of 1dB
            //                  the code does not work for fractional gs_tx_afe_gain_setting_dB

            // The code does NOT work for gt_PSDCompData.us_TxIIRFilter > OPTN_POTS_LP_Filter_Select

            //              | gt_PSDCompData.us_FilterCompIdx
            // gs_tx_afe_gain_setting_dB                     |   0 |  -1 |  -2 | ... | -10
            // --------------------------------------        +-----+-----+-----+-----+-----
            // OPTN_BYPASS_Filter_Select                 (0) |   0 |   1 |   2 | ... |  10
            // OPTN_POTS_Filter_Select                   (1) |  20 |  21 |  22 | ... |  30
            // OPTN_POTS_DOUBLE_Filter_Select            (2) |  40 |  41 |  42 | ... |  50
            // OPTN_ISDN_Filter_Select                   (3) |  60 |  61 |  62 | ... |  70
            // OPTN_35B_VDSL_Filter_Select               (4) |  80 |  81 |  82 | ... |  90
            // OPTN_35B_VDSL_POTS_DOUBLE_Filter_Select   (5) | 100 | 101 | 102 | ... | 110
            // OPTN_35B_VDSL_ISDN_Filter_Select          (6) | 120 | 121 | 122 | ... | 130
            // OPTN_POTS_LP_Filter_Select                (7) | 140 | 140 | 140 | ... | 140   => All US0 Filter have 0dB Compensation as these filters are pre-compensated ones
            // OPTN_ISDN_LP_Filter_Select                (8) | 141 | 141 | 141 | ... | 141   => All US0 Filter have 0dB Compensation as these filters are pre-compensated ones
            // OPTN_POTS_DOUBLE_LP_Filter_Select         (9) | 142 | 142 | 142 | ... | 142   => All US0 Filter have 0dB Compensation as these filters are pre-compensated ones
            // OPTN_POTS_QUAD_LP_Filter_Select          (10) | 143 | 143 | 143 | ... | 143   => All US0 Filter have 0dB Compensation as these filters are pre-compensated ones
            // OPTN_35B_POTS_LP_Filter_Select           (11) | 144 | 144 | 144 | ... | 144   => All US0 Filter have 0dB Compensation as these filters are pre-compensated ones
            // OPTN_35B_ISDN_LP_Filter_Select           (12) | 145 | 145 | 145 | ... | 145   => All US0 Filter have 0dB Compensation as these filters are pre-compensated ones
            // OPTN_35B_POTS_DOUBLE_LP_Filter_Select    (13) | 146 | 146 | 146 | ... | 146   => All US0 Filter have 0dB Compensation as these filters are pre-compensated ones

            gt_PSDCompData.us_FilterCompIdx = gt_PSDCompData.us_TxIIRFilter*20 + s_FreqDependentOffest +10 + (gs_tx_afe_gain_setting_dB>>8);
         }
      }
   }

   pDEST = &gt_PSDCompData.t_PSDCompTable;

   gul_CompTableSourceAddrsOffset = (uint32)(gt_PSDCompData.us_FilterCompIdx*(sizeof (PSDCompDescriptorTable_t)));
   gul_CompTableDestinationAddrs = (uint32)(pDEST);
   // !!!! Note !!!! Very Important !!!!
   // The size of the table/structure should always be multiple of 4 bytes, if not DMA from
   // SDRAM will fail.
   gul_CompTableSize = (uint32)(sizeof(PSDCompDescriptorTable_t));

   // read gt_PSDCompDescriptorTable
   // RISK:    all code-swap/data-swap function shall be in FG tasks
   //          but this function is a background function
   //          The behavior of the code is not predictable
   //          if the RequestSwap / PollForCodeSwapDone / FreeSwapHandle gets interrupted
   //          and global variables like "gt_SwapRequestQueue" are reconfigured by TC/FG tasks
   while ((uc_CompTablePageHandle = RequestSwap(VDSL_COMP_TABLE_V2_DM_SWAPPAGE)) == INVALID_CODESWAP_HANDLE)
   {
      // Why do we need to wait for 1ms?
      // if request is free it should be ok to continue immediately
      // (1ms is here not correct as we are in a BG process. 288000 background cycles is not identical to "wait for 1 ms")
      wait_ms(1);
   }
   while (PollForCodeSwapDone(VDSL_COMP_TABLE_V2_DM_SWAPPAGE, uc_CompTablePageHandle) != SWAP_DONE)
   {
      // Why do we need to wait for 1ms?
      // if request is free it should be ok to continue immediately
      // (1ms is here not correct as we are in a BG process. 288000 background cycles is not identical to "wait for 1 ms")
      wait_ms(1);
   }
   FreeSwapHandle(&uc_CompTablePageHandle);

   gt_PSDCompData.us_NumberOfCompBreakPoint = 9;

   // XDSLRTFW-2534 (Start)
   if (TESTArray[TEST_TX_PSD_CONTROL] & TEST_TX_PSD_CONTROL_COMPENSATION)
   {
      gt_PSDCompData.us_NumberOfCompBreakPoint = 0;
   }
   //XDSLRTFW-2534 (End)

}
//XDSLRTFW-2059 (End)



/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : SetTransmitGains
 *
 *  Description:
 *
 *      This function programs the inactive EGT and GST tables based on the
 *   Band Descriptor and PSD Descriptor blocks.
 *
 *  Prototype:
 *      void SetTransmitGains(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Return:
 *
 *  Global Variables Used:
 *      gs_NumOfTxBands -- (I) no. of TX frequency bands
 *      gsa_TxBandLeftChannel -- (I) an array of left band edges
 *      gsa_TxBandRightChannel -- (I) an array of right band edges
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void SetTransmitGains(void)
{
   FlagT ft_EnableMaximumCompensation;
   PSDDescriptorTable_t t_RemoveDupPSDDescIn; //XDSLRTFW-2323 (Start_End)
   PSDDescriptorTable_t t_ExpandPSDDescIn;

// Debug code for ExpandPSDDesc: Use a global pointer to read from local stack memory.
//   gpt_ExpandPSDDescIn = &t_ExpandPSDDescIn;

#ifdef PSD_TEST
   TestPSD();
#endif



   //Select POFIPOCO cutoff frequency
   // SelectPofiPocoCutoffFreq sets gs_max_fc_MHz always to 28MHz.
   // This is not correct
   // gs_max_fc_MHz should either contain a correct value or needs to be removed
   gs_max_fc_MHz= SelectPofiPocoCutoffFreq();

   // At this point function does not know what should be the real POFIPOCO gain setting.
   // To avoid overflow on later stage, IFFT TSSI is programmed with maximum PSD boost (compensation) according to
   // selected Tx IIR filter and POFI cutoff frequency.

   ft_EnableMaximumCompensation = 1;
   SelectPSDCompensationFunction(ft_EnableMaximumCompensation);


   //XDSLRTFW-2323 (Start)
   //Cleanup duplicate PSD breakpoint entries
   ExpandDupEntries(gt_TxPsdControl.pt_MaxPsdDescIn, &t_RemoveDupPSDDescIn);

   //Expand the input PSD descriptor table to the larger size PSD descriptor table
   //to add the breakpoints for all the band edges
   ExpandPsdTable(&t_RemoveDupPSDDescIn, &t_ExpandPSDDescIn);
   //XDSLRTFW-2323 (End)


   // Calculate and record the PSD Ceiling that corresponds to maxnomATP.
   gt_TxPsdControl.s_MaxAtpCeil = CalcAtpCeil(gt_TxPsdControl.s_MaxAtp, gt_TxPsdControl.s_MaxNomPsdIn,
                                  (void *)gt_TxPsdControl.pt_MaxPsdDescIn,gs_NumOfTxBands,
                                  gsa_TxBandLeftChannel,gsa_TxBandRightChannel, gs_TxNumTones);

   // Determine the "lower" of the two ceilings, and use it subsequently.
   if (gt_TxPsdControl.s_MaxAtpCeil>gt_TxPsdControl.s_PsdCeiling)
   {
      gt_TxPsdControl.s_PsdCeilingUsed = gt_TxPsdControl.s_MaxAtpCeil;
   }
   else
   {
      gt_TxPsdControl.s_PsdCeilingUsed = gt_TxPsdControl.s_PsdCeiling;
   }

   // XDSLRTFW-2819 (Start End)
   // Note: Only US0 is ceiled, when only positive values are allowed, i.e. fct. ChooseUsCeiling()
   //       selects a ceil value according to max PSD of USx bands (with x = 1 to (x = 1 to NumTxBands-1)).
   //       With the new approach to allow now also negative value, the effect of ceiling can also be tested for the USx bands (with x = 1 to y).
//   if(gs_DeltaUsPsdCeilValue >= 0)
   if(gs_DeltaUsPsdCeilValue != (int16)DISABLE_US0_CEILING)
   {
      // Limit the maximum difference between the PSD level of US0 and the other US bands to avoid
      // CO side clipping at short loops
      ChooseUsCeiling(&gt_TxPsdControl.s_PsdCeilingUsed, &t_ExpandPSDDescIn);
   }

   // Configure Finegains for PSD Shaping
   InterpolatePSDValues(&t_ExpandPSDDescIn);


   // Determine IFFT scale settings, based on ghpsa_TxFineGains_Inactive
   ConfigIfftScales();

   // Determine txvargain and TX AFE gain settings, based on ghpsa_TxFineGains_Inactive and ifft scales,
   // and PSD target.
   ConfigTxVarGain(gt_TxPsdControl.s_MaxNomPsdOut+ gs_MaxNomPsdOut_Dbg); //VRX518AFE_CHECK Useful to reduce/increase TX PSD relatively


   // At this point POFIPOCO gain setting is known. FW selects the compensation function according to
   // Tx IIR filter POFO coutoff frequency, POFI trim1 extr gain and POFI gain.
   ft_EnableMaximumCompensation = 0;
   SelectPSDCompensationFunction(ft_EnableMaximumCompensation);

   // if ((!gft_UseUS0Only)||((gs_Debug6 & 2) == 0))
   //{
   ReConfigTSSI_FG();
   //    gs_Debug7 = 1;
   // }

   //Tell the Background Task that called SetTransmitGain() that we are done.
   guc_SetTransmitGainsState = TRAINING_DONE;
}



