/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   UPBO.c
*
*   This file contains UPBO related functions (CPE only).
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "TxPSDControl.h"
#include "SharedFuncs.h"
#include "dsp_op.h"
#include "ConvertToDB.h"
#include "ghs.h"

/*^^^
*------------------------------------------------------------------------
*
*  Name : GetUPBOab
*
*   Prototype:
*       FlagT GetUPBOab(int16 s_toneIdxIn, int16 *ps_aOut, int16 *ps_bOut, int16 *ps_BandIndex);
*
*   Abstract:
*
*   Input Parameters:
*
*   Global Variables:
*
*-----------------------------------------------------------------------------
^^^*/
/*******************************************************************
// For CPE, the following is the case of UPBO required.
// Get a and b parameters for i/p tone index if UPBO is to be applied
// for this tone
*******************************************************************/
FlagT GetUPBOab(int16 s_toneIdxIn, int16 *ps_aOut, int16 *ps_bOut, int16 *ps_BandIndex)
{
   int16 k, i = -1;
   FlagT ft_return = FALSE;

//   if (*(ghpuca_TxExtGains_Inactive+s_toneIdxIn) == 0x10)
   if ((s_toneIdxIn >= gsa_TxBandLeftChannelOSignature[0]) && (s_toneIdxIn <= gsa_TxBandRightChannelOSignature[gs_NumOfTxBandsOSignature-1]))
   {
      UPBOPSDDescriptorTable_t *pt_UPBOPSDDesc;
      UPBOPSDRecord_t *pt_UPBOPSDRec;

      pt_UPBOPSDDesc = (UPBOPSDDescriptorTable_t*)(gt_TxPsdControl.pt_RefPsdDescIn);
      pt_UPBOPSDRec = &(pt_UPBOPSDDesc->ut_UPBOPSDRecord[0]);

      /* Identify the US Band within which the tone lies */
      for (k = 0; k < gs_NumOfTxBandsOSignature; k++)
      {
         if ((s_toneIdxIn >= gsa_TxBandLeftChannelOSignature[k]) && (s_toneIdxIn <= gsa_TxBandRightChannelOSignature[k]))
         {
            i = k;
            break;
         }
      }
      if (i == -1)
      {
         return FALSE;
      }

      /* If US0 band enabled, decrement the index into UPBOPSDRecord_t[] */
      if (gft_US0BandUsedInCD)
      {
         i--;
      }

      *ps_BandIndex = i;

      // UPBO shall not be applied to US0 band
      if (!gft_US0BandUsedInCD || (s_toneIdxIn > gsa_TxBandRightChannelOSignature[0]))
      {
         //a = 40.00 dbBm/Hz and b = 0 implies no UPBO applied for this US band
         if (!(pt_UPBOPSDRec[i].s_a == 4000 && pt_UPBOPSDRec[i].s_b == 0))
         {
            /* Get a and b parameters for given tone index in 0.01 dB format */
            *ps_aOut = pt_UPBOPSDRec[i].s_a - (gt_PwrConfigParam.s_Up_MaxNomPSD*10);   // wrt maxnompsd
            *ps_bOut = pt_UPBOPSDRec[i].s_b;

            ft_return = TRUE;
         }
      }
   }

   return(ft_return);
}

/*^^^
*------------------------------------------------------------------------
*
*  Name : GetUPBOAttenLevel
*
*   Prototype:
*       int16 GetUPBOAttenLevel(int16 s_toneIdxIn, int16 s_attenLevelIn);
*
*   Abstract:
*
*   Input Parameters:
*
*   Global Variables:
*
*-----------------------------------------------------------------------------
^^^*/
/*******************************************************************
// For CPE, the following is the case of UPBO required.
// We will interpolate US Ref PSD, and adjust this by the estimated
// line loss, to get a TX PSD.
*******************************************************************/
int16 GetUPBOAttenLevel(int16 s_toneIdxIn, int16 s_attenLevelIn)
{
   int16 s_a, s_b, s_band, s_attenLevelOut = s_attenLevelIn;
   int16 kl0Local = gt_TxPsdControl.s_kl0In;

   // If UPBO is to be applied on this tone, get a and b parameters for this tone/band
   // VDSL1: a= US Ref PSD @ tone index j, b = 0
   // VDSL2: a= US Ref PSD @ left band edge of tone index j, b = scaling factor
   if (GetUPBOab(s_toneIdxIn, &s_a, &s_b, &s_band))
   {
      int16 s_temp1, s_upboAttenLevel;
      int32 l_temp1, s_kl0;
      int32 l_EqFextUPBOTerm = 0;
      // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (START)
      if(gt_AELEM_UPBOInfo.us_AeleMode != 0)
      {
         // in gt_AELEM_UPBOInfo.us_AeleMode == 0 we do what we did so far
         // in gt_AELEM_UPBOInfo.us_AeleMode == 1 we use ELEDS (minimum of what we measure over DS bands)
         // gus_ELEDsMin is available at the same time sa kl0 would be
         // in gt_AELEM_UPBOInfo.us_AeleMode == 2 we use ELE per band (received from CO calculated over US bands)
         kl0Local = gt_TxPsdControl.usa_Kl0EstimOPb[s_band];
         // in gt_AELEM_UPBOInfo.us_AeleMode == 3 we use the min between CO and CPE measured kl0 available after O-UPDATE
      }
      // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support (END)

      // ----- Reference PSD UPBO method: -----
      // Compute upbo attenuation: a + b*sqrt(f) - LOSS(kl0,f) where LOSS(kl0,f) = kl0*sqrt(f)
      // i.e: a - (kl0 - b)*sqrt(f), f is in Mhz
      // i.e: a - (kl0 - b)*sqrt(f)/1000, f is in Hz

      // Compute sqrt(f)
      s_temp1 = sqrt32((int32)s_toneIdxIn*(43125<<gs_frame_rate_is_8khz)/10);
      // Compute (kl0-b)*sqrt(f)
      // If the estimated value of kl0 is smaller than 1.8, the modem shall
      // be allowed to perform power back-off as if kl0 were equal to 1.8.
      if (kl0Local < 18)
      {
         s_kl0 = 180;
      }
      else
      {
         s_kl0 = kl0Local*10;
      }

      l_temp1 = (s_kl0 - s_b)*s_temp1/1000;

      // Compute a - (kl0-b)*sqrt(f)
      l_temp1 = (int32)s_a - l_temp1;

      // ----- Equalized FEXT UPBO method: -----
      // Subtract one additional term from Ref PSD UPBO attenuation:
      // a + b*sqrt(f) - LOSS(kl0,f) - equalization_term
      // if 1.8 <= kl0 <= kl0_REF,
      //   equalization_term = 10*log10(kl0_REF/kl0)
      //                     = 10*log10(kl0_REF) - 10*log10(kl0)
      // if kl0 < 1.8,
      //   equalization_term = 10*log10(kl0_REF/1.8)
      // if kl0 >= kl0_REF,
      //   equalization_term = 0
      if (gul_OperationModeStatus_VDSL2 & V2_EQ_FEXT_UPBO)
      {
         s_temp1 = gt_UPBOPSDDescriptorTable.usa_kl0_REF[s_band];

         if (s_temp1 > 0)
         {
            if (kl0Local < 18)
            {
               l_EqFextUPBOTerm = ConvertToDB(s_temp1) - ConvertToDB(18);

            }
            else if (kl0Local <= s_temp1)
            {
               l_EqFextUPBOTerm = ConvertToDB(s_temp1) - ConvertToDB(kl0Local);
            }

            // l_EqFextUPBOTerm is in Q8.8, whereas l_temp1 is in 0.01dB
            l_temp1 -= ((l_EqFextUPBOTerm*100 + (1<<7))>>8);
         }
      } //if (gul_OperationModeStatus_VDSL2 & V2_EQ_FEXT_UPBO)

      // Convert to 0.1 dB format and cap this to be in the range of 16 bit integer
      l_temp1 = l_temp1/10;
      if (l_temp1 > 32767)
      {
         l_temp1 = 32767;
      }
      else if (l_temp1 < -32768)
      {
         l_temp1 = -32768;
      }
      s_upboAttenLevel = (int16) l_temp1;

      // If UPBO attenuation is more than that for MaxPSD, use it
      if (s_upboAttenLevel > s_attenLevelIn)
      {
         s_attenLevelOut = s_upboAttenLevel;
      }
   }

   return(s_attenLevelOut);
}

