/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   psd_b.c
 *
 *   Background functions for computing PSD.
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "noiseacc.h"
#include "ConvertToDB.h"
#include "psd_b.h"
#include "dsp_op.h"
#include "acc40.h"
#include "PsdHandler.h"
#include "IRI_Iof.h"
#include <stdlib.h>

#include "PGAHandler.h"
#include "cmv.h"

extern TxToneFlags guca_TxSupportedToneSet;
/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: Background function to calculate PSD
 *
 *  Prototype: void BgPsdCalc(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *------------------------------------------------------------------------
 *^^^
 */
void BgPsdCalc(void)
{
   int32 *pla_SignalPower;

#ifdef HW_SNR_FDQ
   //Read out the accumulated signal power
   ReadAccumulatedNoise();
#endif
   // DC has to be removed for PGA (AGC1) training, because otherwise the PGA gets be limited by the DC.
   // Note: The DC is generated by the PGA (AGC1) themselves.
   if((gs_PgaHandlerState != PGA_DONE) && (gl_HybTrSymcnt_start > 0))
   {
      if (((gs_PgaHandlerRun == 0) && (gs_LeftChannel == 0))&& (gs_PgaTrainingDbg & TEST_HP2_CONFIG_DC_TO_ZERO))
      {
         gpla_RxAccumBuf[0] = 0;
         gpla_RxAccumBuf[1] = 0;
      }
   }

   // convert 48 bits accumulated value to 32 bits;
   pla_SignalPower = gpla_RxAccumBuf; // Overwrite input buffer with 32-bit output.
   RoundNoiseAccum(gpla_RxAccumBuf, pla_SignalPower, gs_LeftChannel,
                   gs_RightChannel, gs_AlgLog2NumFramesToAccum);

   pla_SignalPower = gpla_RxAccumBuf;

   //PsdCalc(pla_SignalPower, gpsa_AlgMsrdBuffer, 0, (int16)(gs_RightChannel-gs_LeftChannel));
   PsdCalc(pla_SignalPower, gpsa_AlgMsrdBuffer, gs_LeftChannel, gs_RightChannel);
   guc_PsdCalcState = TRAINING_DONE;
}

/********************************************************************************************
;   Subroutine Name: PsdCalc
;
;   Description:
;      This routine computes the PSD for each channel in [s_first_chan, s_last_chan] in the
;      following equation:
;
;      PSD = 10*log10(tone_power)
;
;      The implementation is done in the fixed-point algorithmetic and final PSD
;      is expressed in Q8.8 format
;
;   Prototype:
;      void PsdCalc(int32 *pla_SignalPower, int16 *psa_psd, int16 s_first_chan, int16 s_last_chan);
;
;   Input Arguments:
;      s_first_chan -- first channel
;      s_last_chan -- last channel
;      pla_SignalPower -- pointer to accumulators for storing average signal power
;
;   Output Arguments:
;      psa_psd -- pointer to an array of PSD values (in dB)
;
;   Return Value:
;      none
;
;   Global Variables:
;      none
;
;****************************************************************************/
void PsdCalc(int32 *pla_SignalPower, int16 *psa_psd, int16 s_first_chan, int16 s_last_chan)
{
   int16 i, s_ch, s_Psd;
   int32 l_Acc, l_SignalPower;
   int32 l_PaL, l_PaH;
   int16 TxLastTone;

   /* ============================================================================= */
   /* Compute PSD for each channel i */
   /* ============================================================================= */
   l_PaL = 0;
   l_PaH = 0;

   TxLastTone = gsa_TxBandRightChannelOSignature[gs_NumOfTxBandsOSignature-1];

   for (s_ch=s_first_chan; s_ch<=s_last_chan; s_ch++)
   {
      i = s_ch - s_first_chan;
      l_SignalPower  = pla_SignalPower[i];


      if (gs_Pga_XtakNoiseScale)
      {
         // Note: It is not working, if the CO limit the US band already in O-Signature.
         if ((s_ch <= TxLastTone) && (IS_TONEFLAGSET(guca_TxSupportedToneSet, s_ch)))
         {
            if (!(l_SignalPower & (1<<30)))
            {
               l_SignalPower <<= 1;
//               gula_DebugVarsPalak[10] += (1);

               if ((!(l_SignalPower & (1<<30))) && (gs_Pga_XtakNoiseScale > 1))
               {
                  l_SignalPower <<= 1;
//                  gula_DebugVarsPalak[10] += (1 << 16);
               }
            }
         }
      }

      // Also compute the total signal power
      l_PaL += l_SignalPower & 0x0000FFFF;
      l_PaH += (l_SignalPower >> 16) & 0x0000FFFF;

      // If noise power is 0, increment to 1 to avoid getting an "infinite" PSD.
      if (l_SignalPower == 0)
      {
         l_SignalPower = 1;
      }

      // Keep track of maximum received psd
      if ((l_SignalPower > gl_LinMaxRxTonePwr) && (s_ch != 0))
      {
         gl_LinMaxRxTonePwr = l_SignalPower;
      }

      if(gt_PsdConfig.s_AlgCalcType != PSD_CALC_TYPE_NOMSRDBUFF)
      {
         /* ================================================================================ */
         /* compute 10*log10(pla_SignalPower[i]), in Q24.8 format */
         /* ================================================================================ */
         l_Acc = (int32)ConvertToDB(l_SignalPower);

         /* Saturate the result and represent PSD in Q8.8 format */
         s_Psd = sature16(l_Acc);

         /* Accumulate result in psd buffer */
         // Note: The psd buffer is initialized dependent of "gt_PsdConfig.s_AlgCalcType"
         //       E.g. PSD_CALC_TYPE_INITMSRDBUFF_AND_INC - Initialize msrd o/p buffer to 0
         if (psa_psd)
         {
            psa_psd[i] += s_Psd;
         }
      }
   }

   // compute the average signal power; divide by total # of tones in a frame
   // This gives the correct power level
   gl_Pa  += round_acc40(l_PaH, l_PaL, (int16)(gs_RxLog2FftLength-1));

   // Revert the above change to make the PGA higher (though this may not be a good way to do it)
   // gl_Pa  += round_acc40(l_PaH, l_PaL, gs_RxLog2FftLength);
}


