/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   psd_b.c
 *
 *   Background functions for computing PSD.
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "noiseacc.h"
#include "ConvertToDB.h"
#include "psd_b.h"
#include "dsp_op.h"
#include "acc40.h"
#include "PsdHandler.h"
#include "IRI_Iof.h"
#include <stdlib.h>



/********************************************************************************************
;   Subroutine Name: PsdCalc
;
;   Description:
;      This routine computes the PSD for each channel in [s_first_chan, s_last_chan] in the
;      following equation:
;
;      PSD = 10*log10(tone_power)
;
;      The implementation is done in the fixed-point algorithmetic and final PSD
;      is expressed in Q8.8 format
;
;   Prototype:
;      void PsdCalc_HybTrn(int16 *psa_input_buf, int16 s_first_chan, int16 s_last_chan)
;
;   Input Arguments:
;      s_first_chan -- first channel
;      s_last_chan -- last channel
;      pla_SignalPower -- pointer to accumulators for storing average signal power
;
;   Output Arguments:
;      psa_psd -- pointer to an array of PSD values (in dB)
;
;   Return Value:
;      none
;
;   Global Variables:
;      none
;
;****************************************************************************/

void PsdCalc_HybTrn(int16 *psa_input_buf, int16 s_first_chan, int16 s_last_chan)
{
   int16 i, s_ch;
   int32 l_SignalPower;
   int32 l_PaL, l_PaH;

   /* ============================================================================= */
   /* Compute SNR for each channel i */
   /* ============================================================================= */
   l_PaL = 0;
   l_PaH = 0;
   for (s_ch=s_first_chan; s_ch<=s_last_chan; s_ch++)
   {

      i = s_ch - s_first_chan;
      l_SignalPower  = psa_input_buf[2*i] * psa_input_buf[2*i] + psa_input_buf[(2*i)+1]*psa_input_buf[(2*i)+1] ;

      // Also compute the total signal power
      l_PaL += l_SignalPower & 0x0000FFFF;
      l_PaH += (l_SignalPower >> 16) & 0x0000FFFF;


      // If noise power is 0, increment to 1 to avoid getting an "infinite" SNR.
      if (l_SignalPower == 0)
      {
         l_SignalPower = 1;
      }

      // Keep track of maximum received psd
      if ((l_SignalPower > gl_LinMaxRxTonePwr) && (s_ch != 0))
      {
         gl_LinMaxRxTonePwr = l_SignalPower;
      }

   }


   // compute the average signal power; divide by total # of tones in a frame
   // This gives the correct power level
   gl_Pa  += round_acc40(l_PaH, l_PaL, (int16)(gs_RxLog2FftLength-1));

   // Revert the above change to make the PGA higher (though this may not be a good way to do it)
   // gl_Pa  += round_acc40(l_PaH, l_PaL, gs_RxLog2FftLength);

}

void BgPsdCalc_HybTrn()
{
   PsdCalc_HybTrn(gpsa_RxToneBuf, gs_LeftChannel, gs_RightChannel);
   guc_PsdCalcState = TRAINING_DONE;
}
