/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: quick_PSDsort.c
*
*   This file contains a function to sort PSD Descriptor table.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"

/*^^^
*------------------------------------------------------------------------
*
*  Name : quick_PSDsort
*
*   Prototype:
*       void quick_PSDsort(PSDDescriptorTable_t* UnsortedList, int16 left , int16 right )
*
*   Abstract:
*      This function sorts the PSD Descriptor table that is handed to it.
*      The sorted table is placed back in the same PSD Descriptor table to save memory.
*
*      The recursive algorithm consists of four steps :
*      1. If there are one or less elements in the array to be sorted, return immediately.
*      2. Pick an element in the array to serve as a "pivot" point.
*         (Usually the left-most element in the array is used.)
*      3. Split the array into two parts - one with elements larger than the pivot and
*         the other with elements smaller than the pivot.
*      4. Recursively repeat the algorithm for both halves of the original array.
*
*      If very large number of sorts are to be done, this algorithm quickly gobbles up
*      stack because it is recursive.
*
*      The order of complexity of this algorithm is n * Ln(n).
*
*   Input Parameters:
*      Parameter Unsorted is a pointer to structure of the type PSDDescriptor Table.
*      When called initially the variable "left" is called with 0.
*      When called initially the variable "right" is called with (Number of Break points -1).
*
*   Global Variables: gt_PSDDescriptorTable
*
*   Note: Initially the first parameter was of type PSDDescriptorTable_t but to suppress/remove
*         a warning it has been changed to type void. And suitable changes are made in the function and
*         wherever it is being employed.

*-----------------------------------------------------------------------------
^^^*/

void quick_PSDsort(PSDDescriptorTable_t* UnsortedList, int16 left, int16 right)
{
   //Recursive function; needs to be called once only
   int16 pivot,pivot_Level, l_hold, r_hold,s_temp;
   int16 gus_NumOfBrkpts = UnsortedList->us_NumberOfTones;

   l_hold = left;
   r_hold = right;
   pivot = UnsortedList->ut_PSDRecord[left].us_IndexOfTone;
   pivot_Level = UnsortedList->ut_PSDRecord[left].s_PSDLevelOfTone;
   //pivot_InSupportedSet = UnsortedList->ut_PSDRecord[left].us_InSupportedSet;
   while (left < right)
   {
      while ((UnsortedList->ut_PSDRecord[right].us_IndexOfTone >= pivot) && (left < right))
      {
         right--;
      }
      if (left != right)
      {
         UnsortedList->ut_PSDRecord[left].us_IndexOfTone = UnsortedList->ut_PSDRecord[right].us_IndexOfTone;
         //UnsortedList->ut_PSDRecord[left].us_InSupportedSet = UnsortedList->ut_PSDRecord[right].us_InSupportedSet;
         UnsortedList->ut_PSDRecord[left].s_PSDLevelOfTone = UnsortedList->ut_PSDRecord[right].s_PSDLevelOfTone;
         left++;
      }
      while ((UnsortedList->ut_PSDRecord[left].us_IndexOfTone <= pivot) && (left < right))
      {
         left++;
      }
      if (left != right)
      {
         UnsortedList->ut_PSDRecord[right].us_IndexOfTone = UnsortedList->ut_PSDRecord[left].us_IndexOfTone;
         //UnsortedList->ut_PSDRecord[right].us_InSupportedSet = UnsortedList->ut_PSDRecord[left].us_InSupportedSet;
         UnsortedList->ut_PSDRecord[right].s_PSDLevelOfTone = UnsortedList->ut_PSDRecord[left].s_PSDLevelOfTone;
         right--;
      }
   }
   UnsortedList->ut_PSDRecord[left].us_IndexOfTone = pivot;
   //UnsortedList->ut_PSDRecord[left].us_InSupportedSet = pivot_InSupportedSet;
   UnsortedList->ut_PSDRecord[left].s_PSDLevelOfTone = pivot_Level;
   pivot = left;
   left = l_hold;
   right = r_hold;
   if (left < pivot)
   {
      s_temp = pivot-1;
      quick_PSDsort(UnsortedList, left, s_temp);
   }
   if (right > pivot)
   {
      s_temp = pivot+1;
      quick_PSDsort(UnsortedList, s_temp, right);
   }
}
