/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*****************************************************************************
;
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   TDQ_INIT.c
;
;   Routine to perform time-domain equalization (TDQ) initialization.
;   This function will be called from the C_R_REVERB1 state of the training
;   phase of initialization.
;
;   This version implements the reduced matrix computation.
;
;****************************************************************************/

/*****************************************************************************
;   Subroutine Name: TdqInit(int16* psa_SignalIn)
;
;   This routine calculates the coefficients of the following TDQ filter:
;
;      y[n] = sum_{i=1}^{CPlen}(b_i y[n-i]) + sum_{j=1}^{TDQlen}(a_j x[n])
;   where y[n] are outputs of the filter (desired response) and
;   x[n] are the inputs to the filter (output of channel)
;
;   Written in vector form:
;
;   [X|Y] * [a|b]' = z, where
;
;   z is a vector of y[l] values at times n, n-1, n-2,...
;   X is a matrix whos rows, of dimension TDQlen, contain x[l] values starting at
;      l = n, for row 1; n-1, for row 2, etc.
;   Y is a matrix whos rows, of dimension CPlen, contain y[l] values starting at
;      l = n-1, for row 1; n-2, for row 2, etc.
;   a and b are the vectors of filter coefficients, a_i and b_j
;   Since the input signal (reverb) is periodic, all of the above values can be
;   filled in using the contents of a single buffer.
;
;   Premultiplying the above by [X Y]', we get
;   [X'X X'Y  * [a = [X'z
;    Y'X Y'Y]    b]   Y'z]
;
;   For the TDQ, we will only be obtaining the a values. To do this, we can premultiply
;   the above by:
;   [I -X'Y*inv(Y'Y)
;    0          I       ], where I is the identity matrix.  This results in an upper and
;   lower vector equation.  One to solve for a and one for b.  Taking the upper one for a, we get
;
;   [X'X - X'Y*inv(Y'Y)*Y'X] * [a] = [X'z - X'Y*inv(Y'Y)*Y'z].
;
;   If L is the Cholesky decomposition of inv(Y'Y), then inv(Y'Y) = LL' and the above becomes
;
;   [X'X - (X'YL)(L'Y'X)] * [a] = [X'z - (X'YL)(L'Y'z)] (**)
;   or Aa = c,
;   where c is defined in (**).
;
;   Equation (**) will be used to solve for the coefficients, a.  Since y[n] are desired outputs, we
;   will use the known replica vector to supply these values; hence, the following
;   terms can be stored in memory, if desired.
;      L, L'Y'z, YL, L'Y'
;   For this implementation, L is provided and all other quantities are computed.
;
;   Note also that the matrix X is created from a circular buffer.  As a result, the
;   autocorrelation matrix X'X is Toeplitz in nature.  Given this, only one row of X'X will need
;   to be computed and the rest can easily be filled out.  In addition, more computational savings
;   are gained by only computing the minimum needed unique cross-correlations Rxy[-CPLen]...Rxy[TDQLen-1],
;   which are used to efficiently compute L'Y'X and also contain the needed subset X'z.
;
;   Since the matrix A is symmetric, only the lower triangular portion plus
;   the diagonal is required for the Cholesky.  This will fill a special vector, R, only
;   containing the mandatory number of values.  In addition, to complete the decomposition
;   and backsubstitution, c' will be appended to the bottom of A and placed in R.
;
;   If a null is detected in the frequency response of the coeffcients, then order reduction
;   must be performed.  We define the following vector:
;         e = [0 0 0 ... 0 1]
;   to reduce the order by 1.
;   Then,
;         s = inv(A) * e;
;         lambda = (e' * a) / (e' * s)
;   The new coefficients will be:
;         a_reduced = a - (lambda * s);
;
;   Prototype:
;      void TdqInit(int16* psa_SignalIn)
;
;
;   Input Arguments:   psa_SignalIn - received input signal (x)
;
;   Output Arguments:   none
;
;   Return Value:      none
;
;   Global Variables Used:   gpsa_tdq_h[]       (output) filter coeffcients
;                     gfa_TdqLt[]       (input) transpose of L matrix
;                     gft_TdqInitFlag[]   (output) completion flag
;                     gs_tdq_h_exp      (output) right shift amount for filter
;
;   Notes: The floating point emulation with fixed point operations
;   does not require any external floating point libraries from the compiler.
;   Note, FLOAT_IN_SW must be defined in CONST.H -- native float routines
;   have been removed.  GEMINAX_FPA implementation uses hardware blocks for add/sub/mpy
;   operations.
;
;****************************************************************************/

#include "common.h"
#include "gdata.h"
#include "ieee_flt.h"
#include "tdq_init.h"
#include "matrix.h"
#include "ConvertToDB.h"

