/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: Bitload_VDSL2.c
*
*   This file contains functions for VDSL2 Bitloading.
*
*   Change 25/05/2012 : VENKATESH S N
*   XDSLRTFW-464 : DS_MARGIN_LOWER_TO_BRCM_DISTRIBUTE_FINEGAIN
*   Issue: DS Margin lower than BRCM for Fixed/Capped Rate cases
*   Cause: Fine Gains are 2.5dB lower, RMS GI is Approx -2.5dB
*   Fix: Distribute the Fine Gains to be around 0dB RMS GI
*        This fix is applicable in general to all profiles/Vendors
*        if the FINE GAIN flag is ON
*   Change: Distribute Fine gain function is called at the end of
*           BitLoading to change the fine gains considering the total
*           Average Fine Gain
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// Bitload_VDSL2.c
//
// History
//
// 19/07/2013 Kannan: Changes to set the Tx Data pump setup
//           Grep for XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx
//
// 21/10/2013 Kannan: If US ReTx is enabled minimum memory required would be around 26K bytes to support 50Mbps(US)
//                    on LP1. This is required to support Amendment 2 + Vectoring + US ReTx + SRA.
//
// 04/02/2014 Varun : Removed US memory reseravation(23K) to cater for more DS datarate when US ReTX is in use
//                     Grep for XDSLRTFW-1540
//
// 29/10/2014 Anantha Ramu: Intra DTU Interleaving uses two Interleavers in ping-pong fashion.
//                          Base addresses of ILV0,ILV1 are ReTXQueue_BaseAddress computed.
//                          Grep for "XDSLRTFW-1617"
//
// 21/05/2015 Palaksha/Vinay GR: XDSLRTFW-2368 : Enable Debug Traces in VRx318
//            Debug trace feature is enabled for VRX318 platform all modes except
//            when RTXds or RTXus or both enabled in 30a, Debug trace will be captured
//            only till Training (Untill ROP_SYNCHR6) and in showtime this will be diabled
//            Grep for "XDSLRTFW-2368"
//
// 26/11/2015 Anantha Ramu: Added modifications for SRA with US Intra DTU Interleaving.
//                          Grep for "XDSLRTFW-2341".
//
// 10/12/2015 Vinay: Added to code to use the Framer for compuation of ATTNDR using the Method 0 apart from
//                   DELT mode.
//                   Grep for "XDSLRTF-2543"
//
// 11/02/2016 Vinay: Added code to prevent the overwriting of the base address of Rx ILV (gula_rxILVBaseAddr").
//                   Copied the value to a local variable before executing the function "GetFramingParamsInput".
//                   Grep for XDSLRTFW-2585
//
// 10/10/2018 Sriram Shastry : VDSL,errors in datapath after a SRA downshift
//                   It  has been observed during SRA calculated de-interleaver memory  size in training is exceeded
// in show-time. Re-computation framing parameter i.e. Lp (Np) gets changed,it can result in higher dilv memory size
// than computed during training phase[gul_RtxQBaseAddr = gula_rxILVBaseAddr[LP1] + ul_dilv_size].As a result of
// memory corruption packet drops is seen in Traffic test.
// Grep for XDSLRTFW-3948
// ************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "Bitload.h"
#include "Bitload_support.h"
#include "CalcMaxBits.h"
#include "mul.h"
#include "ghs.h"
#include "GenFramingParams_VDSL2.h"
#include "cmv.h"
#include "CalcMaxIlvDilvSize.h"
#include "Framing_VDSL2.h"
//XDSLRTFW-464 : DS_MARGIN_LOWER_TO_BRCM_DISTRIBUTE_FINEGAIN
#include "BitswapDecision_VDSL2.h"

#include "zep_memmap_cnfg.h"
#ifdef ENABLE_RETX_US_DEBUG1
uint32 gul_dilvsize_DsRetxLp1;
#endif

//XDSLRTFW-1522 (Start_End)
extern uint32 gul_Store_HW_DILV_MEM_SIZE[];
/*
*-------------------------------------------------------------------------------
*
*  Prototype: FlagT CalcChannelCapacity(int16 s_R, int32 *pl_MaxSumLp)
*
*  This function calculates channel capacity given a value of check byte.
*
*  Input Arguments:
*     s_R: # of check bytes per codeword
*
*  Output Arguments:
*     pl_MaxSumLp: pointer to max # of bits supported (per symbol)
*
*  Returns:
*     SUCCEED/FAIL:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

FlagT CalcChannelCapacity(int16 s_R, int32 *pl_MaxSumLp)
{
   FlagT ft_BitloadOK;

   gsa_TotalCodingGain[INLV] = GetCodingGain(s_R, gft_RxTcmFlag);

   gpsa_MeasuredSnrBuf = gsa_SnrBuf;

   gft_NewBitLoadFlag = 1;

   ft_BitloadOK = CalcMaxBits(ghpuca_RxBat_Inactive, ghpsa_RxFineGains_Inactive, &gs_RxExtraBits, &gs_RxAvFineGain, 0x7FFFFFFF, pl_MaxSumLp);

   return (ft_BitloadOK);
}

// XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start)
//XDSLRTFW-1522 (Start)
void BgGenFramingATTNDR_VDSL2(void)
{
   uint16 us_Rp;
   FlagT ft_BitloadOK = FALSE;
   uint16 us_temp;   // XDSLRTFW-2543 (Start_End)

   // Modified the following variables (gul_Store_DILV_MEM_SIZE and gul_Store_HW_DILV_MEM_SIZE)from global to local
   // to free up some space.
   uint32 ul_Store_DILV_MEM_SIZE;
   uint32 ul_Store_HW_DILV_MEM_SIZE[NUM_DATA_PATHS];
   uint32 ula_Store_rxILVBaseAddr[NUM_DATA_PATHS]; // XDSLRTFW-2585

   // perform the framing parameter selection
   //Set the input parameters to the FormVDSL2FramingParams()

   // In normal operation, the SNR is based on the framing calculation.
   // Therefore, during initialization the rate calculation has to be done twice:
   // 1.   For the actual framing with the configured max net data rate (MaxRate).
   // 2.   For ATTNDR calculation with  Max net data rate = unlimited = assume maximum possible
   // value AND consider all conditions of the selected ATTNDR_METHOD as listed in Table 1 in Attndr_Concept_v1.pdf
   // The second run of the framing generation (not doing the full bitloading) in which the max rate
   // constraints are removed.

   if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled != RETX_SELECTED)
   {  //IFEC Mode
      gft_CalcAttndr = TRUE;

      // Store/Save DILV variables
      ul_Store_DILV_MEM_SIZE = gul_DILV_MEM_SIZE;
      ul_Store_HW_DILV_MEM_SIZE[LP0] = gul_HW_DILV_MEM_SIZE[LP0];
      ul_Store_HW_DILV_MEM_SIZE[LP1] = gul_HW_DILV_MEM_SIZE[LP1];
      // XDSLRTFW-2585 (Start)
      ula_Store_rxILVBaseAddr[LP0] = gula_rxILVBaseAddr[LP0];
      ula_Store_rxILVBaseAddr[LP1] = gula_rxILVBaseAddr[LP1];
      // XDSLRTFW-2585 (End)

      GetFramingParamsInput();
      // XDSLRTFW-2543(Start_End)
      // When the framer is called for Method 0, we should not consider the ATTNDR_MDOSPLIT
      if (guc_attndr_method != ATTNDR_METHOD_0)
      {
         gul_DILV_MEM_SIZE = (gul_ATTNDR_max_delay_octets & 0xFFFFFF) >> 1;
      }

      // XDSLRTFW-2543 (Start_End)
      // The Max rate of structure "gt_FormFramingParamsInputs_v2" , the input for Framer gets overwritten during the ATTNDR computation
      // to an value 0x7FFF. To prevent the overwriting, we are storing the value in a temporary variable and then restoring that value
      // back to the structure
      us_temp = gt_FormFramingParamsInputs_v2.us_MaxRate;
      ft_BitloadOK = FormVDSL2FramingParams(&gt_FormFramingParamsInputs_v2, &gt_rx_config_v2_Attndr);
      gt_FormFramingParamsInputs_v2.us_MaxRate = us_temp;   // Restored the value of Max rate to the initial value i.e, before calling the ATTNDR function

      // Re-Store DILV variables
      gul_DILV_MEM_SIZE = ul_Store_DILV_MEM_SIZE;
      gul_HW_DILV_MEM_SIZE[LP0] = ul_Store_HW_DILV_MEM_SIZE[LP0];
      gul_HW_DILV_MEM_SIZE[LP1] = ul_Store_HW_DILV_MEM_SIZE[LP1];
      // XDSLRTFW-2585 (Start)
      gula_rxILVBaseAddr[LP0] = ula_Store_rxILVBaseAddr[LP0];
      gula_rxILVBaseAddr[LP1] = ula_Store_rxILVBaseAddr[LP1];
      // XDSLRTFW-2585 (End)

      gft_CalcAttndr = FALSE;
   }
   else
   {  //ReTx Mode
      gft_CalcAttndr = TRUE;

      ul_Store_HW_DILV_MEM_SIZE[LP1] = (uint32)gla_MaxInlvDelay[LP1];
      if (guc_attndr_method != ATTNDR_METHOD_0)
      {
         gla_MaxInlvDelay[LP1] = (int32)gul_ATTNDR_max_delay_octets;
      }

      //XDSLRTFW-2590 (Start)
      us_Rp = 4;
      if(gft_Intra_DTU_Ilv_DS == TRUE)
      {
         us_Rp = guc_DS_ReTx_iDTU_R;  //XDSLRTFW-3493(Start_End)
      }
      //XDSLRTFW-2590 (End)
      //XDSLRTFW-3493(Start)
      if (TESTArray[TEST_Control4] & TEST_Control4_Enhanced_ReTx_Framing_Bit10_Mask)
      {
         ft_BitloadOK = RtxFramingVdsl_V3(gla_MaxSumLp[(us_Rp>>1)], &gt_rx_config_v2_Attndr);
         // Added debug capability for framing parameters of the ATTNDR calculation
         DSH_SendStream(DSH_DS_FRAMER,sizeof(VDSL2Config_t),&gt_rx_config_v2_Attndr);
      }
      else
      {
         ft_BitloadOK = RtxFramingVdsl_V1(gla_MaxSumLp[(us_Rp>>1)], &gt_rx_config_v2_Attndr);
      }
      //XDSLRTFW-3493(End)
      gla_MaxInlvDelay[LP1] = (int32)ul_Store_HW_DILV_MEM_SIZE[LP1];
      gft_CalcAttndr = FALSE;
   }

   if (ft_BitloadOK == FAIL)
   {
      gs_RxBkgdProcessFlag = TRAINING_DONE;
      gft_ATTNDR_FrameGenFail = TRUE;
      gl_FramingGenErrCode |= E_CODE_ATTNDR_CALC_FAIL;
   }

}
//XDSLRTFW-1522 (End)
// XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (End)
/*
*-------------------------------------------------------------------------------
*
*  Prototype: void BgBitloadAdaptiveRate_VDSL2(void)
*
*  This function performs VDSL2 Bitloading.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*     gft_BitloadOK (O): SUCCEED/FAIL
*     gl_MaxSumLpSupported (O): max # of bits supported (per symbol)
*
*-------------------------------------------------------------------------------
*/

void BgBitloadAdaptiveRate_VDSL2(void)
{
   int32 l_FinalLp;

   int16 s_D, s_I;
   uint32 ul_ilv_size, ul_dilv_size, ul_TotalMem_size;

   // add margin to target SNR
   OffsetSNRRequired(gt_BitloadParam.s_TarSnrMgn, gsa_SNRRequired);

   //Set the input parameters to the FormVDSL2FramingParams()
   GetFramingParamsInput();

   if ((gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED) || (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE))
   {
      s_D = gt_tx_config_v2.s_Dp[LP0];
      s_I = gt_tx_config_v2.s_Ip[LP0];

      //According to Josh, the interleaver buffer size used should be:
      //ILV_MEM = I*(D-M-1)/2 + I*EXT
      //where M = floor(D/I), EXT = 2 for TX and 1+q for RX
      //To be conservative, we set ILV_MEM = I*D/2 + I*EXT
      MULS16(ul_ilv_size, s_D, s_I);
      ul_ilv_size >>= 1;

      //Add I*EXT = I*2
      ul_ilv_size += (s_I<<1);

      gul_HW_ILV_MEM_SIZE[LP0] = ul_ilv_size;
//XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx(START)
      if(gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
      {
         gt_ReTXParams.us_US_ReTx_DtuSize = gt_ReTXParams.us_OPMS_UsCodeWordPerDtu_Q * gt_tx_config_v2.s_Nfecp[LP1];
         //gul_HW_ILV_MEM_SIZE[LP1] = MAX(ZEP_ILV_US_RETX_LP1_BLOCK_SIZE, gt_ReTXParams.us_OPMS_UsQtx * gt_ReTXParams.us_US_ReTx_DtuSize); // US_Qtx * US_DTU_SIZE
         //XDSLRTFW-1540(START_END)
         //XDSLRTFW-3189 (Start)
         //US ReTx queue memory allocation include US "RS" overhead byte, because VR9/VRX318 implementation
         //stores "R" bytes as well in the US ReTx queue.
         gul_HW_ILV_MEM_SIZE[LP1] = MAX(((gla_MaxInlvDelayUs[LP1]>>1) + gs_MemSize_UsReTx_Qtx_Overhead_R),
         (gt_ReTXParams.us_OPMS_UsQtx *  gt_ReTXParams.us_OPMS_UsCodeWordPerDtu_Q * gt_tx_config_v2.s_Nfecp[LP1])); // US_Qtx * US_DTU_SIZE
         gul_HW_ILV_MEM_SIZE[LP1] = (gul_HW_ILV_MEM_SIZE[LP1] + 3) & 0xFFFFFFFC;
         //XDSLRTFW-3189 (End)
      }
      else
      {
         gul_HW_ILV_MEM_SIZE[LP1] = 512;             // Leave 512 bytes for US LP1/RRC for now
      }
//XDSLRTFW-1707_30a_RTX_DsUs (Start)
#ifdef VECTORING_BUILD
      gs_rxILVBaseAddrOffset = 0;
#else

      gs_rxILVBaseAddrOffset = SHOWTIME_VECTOR_BUFFER_SIZE - (ul_ilv_size + gul_HW_ILV_MEM_SIZE[LP1]);

      if (gs_rxILVBaseAddrOffset  < 0)
      {
         gs_rxILVBaseAddrOffset = 0;
      }
#endif
//XDSLRTFW-1707_30a_RTX_DsUs (End)
      //Re-partition the HW interleaver and deinterleaver memory based on
      //actual use of interleaver memory as calculated above

      //Init. the base address of interleave/deinterleaver buffer
      gula_txILVBaseAddr[LP0] = ZEP_RAM_ILV_DLIV_BASE;
#ifdef ILV_DBG_BUFFER
      //If IlvDbgBuffer Enabled
      if((gs_IlvDbgBufferControl & ILV_DBG_BUF_CNTRL_ENABLE_MASK) == TRUE)
      {
         //shift ILV/DILV start by debug buffer size (ILV/DILV gets reduced by debug buffer size)
         gula_txILVBaseAddr[LP0] += ILV_DBG_BUFFER_SIZE;
      }
#endif
      gula_txILVBaseAddr[LP1] = gula_txILVBaseAddr[LP0] + ul_ilv_size;

      //XDSLRTFW-1617 (Start)
      //Reset the base address of the deinterleaver (keep the interleaver address unchange)
      gula_rxILVBaseAddr[LP0] = gula_txILVBaseAddr[LP1] + gul_HW_ILV_MEM_SIZE[LP1]+gs_rxILVBaseAddrOffset;
      if(gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
      {
         if(guc_ReTx_US_D > 1) //US Intra DTU interleaving active
         {
            uint32 ul_ilvSize,ul_temp; //ul_addr,ul_RegBaseAddr;

            ul_ilvSize = gus_MaxDTUSizeUS_iDTU;  //XDSLRTFW-3189 (Start_End)
            //ul_RegBaseAddr = ZEP_PRAM_TX_LP1_START_ADDR;
            //ul_addr = ul_RegBaseAddr + ZT_ILV_BASE0_OFFSET;
            ul_temp = gula_txILVBaseAddr[LP1];
            ul_temp = (ul_temp + 3) & 0xFFFFFFFC;

            //Allocate memory for 2 DTU's
            //XDSLRTFW-3189 (Start_End)
            ul_temp += (ul_ilvSize << 1); //Extra 1K more is not required, since we have taken care the worst case US DTU size including R
            ul_temp = (ul_temp + 3) & 0xFFFFFFFC;

            gt_ReTXParams.ul_US_ReTXQueue_BaseAddress = ul_temp;
            gul_HW_ILV_MEM_SIZE[LP1] += (ul_temp - gula_txILVBaseAddr[LP1]); //Add memory required for US IDTU processing

            gul_HW_ILV_MEM_SIZE[LP1] = (gul_HW_ILV_MEM_SIZE[LP1] + 3) & 0xFFFFFFFC;
            gula_rxILVBaseAddr[LP0]  =  gula_txILVBaseAddr[LP1] + gul_HW_ILV_MEM_SIZE[LP1];
            //XDSLRTFW-2590 (End)
         }
         else
         {
            //Reset the base address of the deinterleaver (keep the interleaver address unchange)
            gt_ReTXParams.ul_US_ReTXQueue_BaseAddress = gula_txILVBaseAddr[LP1];
         }
      }
      //XDSLRTFW-1617 (End)


      // compute the available CPE deinterleaver memory size ( LP0 + LP1 shared)

      // XDSLRTFW-2368 (Start)
      if (gs_frame_rate_is_8khz) //DebugBufferTrace
      {
         if ( (TESTArray[TEST_Control3] & TEST_Control3_Test28_Bit7Mask_DISDEBUGTRACE) && (gus_ReTxOptionsEnabled & (CPE_DS_US_RETX_CAPABLE|CPE_DS_RETX_CAPABLE)))
         {
            ul_TotalMem_size = ZEP_ILV_DILV_BLOCK_SIZE_30A_NODEBUGTRACE;
         }
         else
         {
            ul_TotalMem_size = ZEP_ILV_DILV_BLOCK_SIZE_30A;
         }
      }
      else
      {
         ul_TotalMem_size = ZEP_ILV_DILV_BLOCK_SIZE;
      }
#ifdef ILV_DBG_BUFFER
      //If IlvDbgBuffer Enabled
      if((gs_IlvDbgBufferControl & ILV_DBG_BUF_CNTRL_ENABLE_MASK) == TRUE)
      {
         ul_TotalMem_size = ZEP_ILV_DILV_BLOCK_SIZE-ILV_DBG_BUFFER_SIZE;
      }
#endif
      // XDSLRTFW-2368 (End)

      //30a_DSRTX Debug
#ifdef ENABLE_RETX_US_DEBUG1
      gula_PalakDebug[3] = ul_TotalMem_size;
#endif
      gul_HW_DILV_MEM_SIZE[LP0] = ul_TotalMem_size - (ul_ilv_size + gul_HW_ILV_MEM_SIZE[LP1] + gs_rxILVBaseAddrOffset);
   }
//XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx(END)


   if (!(CNTLArray[CNTL_ModemControl] & CNTL_ExplicitRate))
   {

      if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
      {
         // Force the overhead only path to be LP0 in retransmission enabled case
         gt_rx_TPS_Map.s_IBITSlp = LP0;

         // perform the framing parameter selection for retransmission mode
         gft_BitloadOK = FormVDSL2FramingParamsRetx(&gt_FormFramingParamsInputs_v2, &gt_rx_config_v2);
         DSH_SendStream(DSH_DS_FRAMER,sizeof(VDSL2Config_t),&gt_rx_config_v2);
      }
      else
      {
         // perform the framing parameter selection
         // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start_End)
         gft_CalcAttndr = FALSE;
         gft_BitloadOK = FormVDSL2FramingParams(&gt_FormFramingParamsInputs_v2, &gt_rx_config_v2);
      }

      if (gft_BitloadOK == FAIL)
      {
         gs_RxBkgdProcessFlag = TRAINING_DONE;
         return;
      }

   }


   if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
   {
      s_D = gt_rx_config_v2.s_Dp[LP0];
      s_I = gt_rx_config_v2.s_Ip[LP0];

      //According to Josh, the interleaver buffer size used should be:
      //ILV_MEM = I*(D-M-1)/2 + I*EXT
      //where M = floor(D/I), EXT = 2 for TX and 1+q for RX
      //To be conservative, we set ILV_MEM = I*D/2 + I*EXT
      MULS16(ul_dilv_size, s_D, s_I);
      ul_dilv_size >>= 1;

      //Add I*EXT = I*2
      ul_dilv_size += (s_I<<1);

      // Compute the total DILV memory available for LP1 path by subtracting the memory used by the LP0
      // path
      gul_HW_DILV_MEM_SIZE[LP1] = gul_HW_DILV_MEM_SIZE[LP0] - ul_dilv_size;
      gula_rxILVBaseAddr[LP1] = gula_rxILVBaseAddr[LP0] + ul_dilv_size;

       // XDSLRTFW-3948(Start)
       // s_D = gt_rx_config_v2.s_Dp[LP1];
       // s_I = gt_rx_config_v2.s_Ip[LP1];

       // //According to Josh, the interleaver buffer size used should be:
       // //ILV_MEM = I*(D-M-1)/2 + I*EXT
       // //where M = floor(D/I), EXT = 2 for TX and 1+q for RX
       // //To be conservative, we set ILV_MEM = I*D/2 + I*EXT
       // MULS16(ul_dilv_size, s_D, s_I);
       // ul_dilv_size >>= 1;

       // //Add I*EXT = I*2
       // ul_dilv_size += (s_I<<1);


      //  ReTx -Memory organization for  both Training and Showtime
      //  RTX memory is  re-calculated  during showtime [OLR:SRA],which might differ
      //  from computed during training phase.
      //  Dilv_Size = I*D/2 + I*EXT
      // Before-Fix-Implementation
      // |                        | Start-Address        | Buffer-Size   |
      // |ReTx-Buffer-addr        |  Decimal |       Hex |         Bytes | Comment
      // +------------------------+----------+-----------+---------------+--------------------------
      // |gula_txILVBaseAddr[LP0] |   327680 |  0x50000  | 0x0050   [80] |
      // |gula_txILVBaseAddr[LP1] |   327760 |  0x50050  | 0x25cc [9676] |
      // |gula_rxILVBaseAddr[LP0] |   337436 |  0x5261C  | 0x0050   [80] |
      // |gula_rxILVBaseAddr[LP1] |   337516 |  0x5266C  | 0x258   [600] | DeInterleaver MemSize = (Ip*Dp)/2+(Ip*2)
      // |gul_RtxQBaseAddr        |   338116 |  0x528C4  |               | Beginning of this memory address gets overwritten,
      // |                        |          |           |               |   if DILV Mem size increases in show time (due to SRA)


      // for Framing Nfecp = 255,Dp =1,
      // dilv-size = (255*1)/2+(255*2) 637.5000
      // Memory corruption is seen at the address 0x4D288 [DS ReTx Memory region]

      // After-Fix-Implementation
      // |                        | Start-Address        | Buffer-Size   |
      // |ReTx-Buffer-addr        |  Decimal |       Hex |         Bytes | Comment
      // +------------------------+----------+-----------+---------------+--------------------------
      // |gula_txILVBaseAddr[LP0] |   327680 |  0x50000  | 0x0050   [80] |
      // |gula_txILVBaseAddr[LP1] |   327760 |  0x50050  | 0x25cc [9676] |
      // |gula_rxILVBaseAddr[LP0] |   337436 |  0x5261C  | 0x0050   [80] |
      // |gula_rxILVBaseAddr[LP1] |   337516 |  0x5266C  | 0x400  [1024] | Fix value which is > max DILV MemSize of (Ip*Dp)/2+(Ip*2)
      // |gul_RtxQBaseAddr        |   338540 |  0x52A6C  |               |

      // Max dilv size from framing computation would be floor(637.5) = 637 bytes
      // The defines which are currently used in our code assume a max size of this buffer of 1024 bytes
      // To be backwards compatible we reserve here now also 387 bytes more than required (1024 instead of 637 bytes)

      ul_dilv_size = DS_RETX_LP1_PROCESSING;



   #ifdef ENABLE_RETX_US_DEBUG1
      gul_dilvsize_DsRetxLp1 = ul_dilv_size;
   #endif

      //gul_RtxQBaseAddr provides the base address for DTUs in re-ordering buffer.
      //SID, TS and DTU status (Good/Bad) is directly written by microcode in the
      //first four bytes of each DTU. FW code uses a "uint32 pointer" to access SID,
      //TS and DTU status data. Additionally ADMA (for DTUs forwarded to TPS-TC layer)
      //requires that source and destination address to be aligned to 32 bit boundary.
      //Hence aligning the DTU base address to 32 bit boundary.
      gul_RtxQBaseAddr = ((gula_rxILVBaseAddr[LP1] + ul_dilv_size + 3) & 0xFFFFFFFC);
      // XDSLRTFW-3948(End)
   }


   // compute the VDSL2 derived framing parameters
   if (!(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG) && (gs_DbgFramingDisableFlag == 0))
   {
      Compute_VDSL2Framing(&gt_rx_config_v2, &gt_rx_TPS_Map, &gs_PMDFramesPerRxIBStructure);

   }

   l_FinalLp = (int32)(gt_rx_config_v2.ul_Lp[LP0] + gt_rx_config_v2.ul_Lp[LP1]);
//Feature_DS_VDSL2_ALL_UsReTx XDSLRTFW-1077 Rx RRC word (Start)
//Restore the count of 24 RRC bits which was taken out.
   if (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
   {
      l_FinalLp += US_RRC_BITS;
   }
//Feature_DS_VDSL2_ALL_UsReTx XDSLRTFW-1077 Rx RRC word (End)

   if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED)
   {
      //XDSLRTFW-2590 (Start)
      //Set number of RS checkbytes
      gs_NumCheckByte = 4;
      if(gft_Intra_DTU_Ilv_DS == TRUE)
      {
         gs_NumCheckByte = guc_DS_ReTx_iDTU_R; //XDSLRTFW-3493(Start_End)
      }
      //XDSLRTFW-2590 (End)
   }
   else
   {
      //Set number of RS checkbytes
      gs_NumCheckByte = gt_rx_config_v2.s_Rp[LP0];
   }

   // Recompute channel capacity with the final value of check byte
   // for non-retx mode. It is not needed for retx adaptive rate mode as R is fixed to 4.
   // However, we still need to do this for explicit rate configuration
   if ((gt_ReTXParams.uc_OMSG1_DsReTxEnabled != RETX_SELECTED) || (CNTLArray[CNTL_ModemControl] & CNTL_ExplicitRate))
   {

      gft_BitloadOK = CalcChannelCapacity(gs_NumCheckByte, &gl_MaxSumLpSupported);

      if (gft_BitloadOK == FAIL)
      {
         gs_RxBkgdProcessFlag = TRAINING_DONE;
         return;
      }
   }

   //Perform the fixed bit allocation based on the required bits

   //Set the flag to 1 to indicate to do bitload based on the existing BAT
   gft_NewBitLoadFlag = 0;
   gft_BitloadOK = BitloadFixedRate(l_FinalLp);
//XDSLRTFW-464 : DS_MARGIN_LOWER_TO_BRCM_DISTRIBUTE_FINEGAIN (Start)
   //================== TTNet Issue : XDSLRTFW-464==================
   //Increase the fine gains of affected tones with the constraint of
   //not violating the fine gain restriction
   //This is to distribute the fine gains around 0dB RMS GI
   if(gft_FineGainOn)
   {
      DistributeFineGainsForShowtime(ghpuca_RxBat_Inactive, ghpsa_RxFineGains_Inactive, gpsa_MeasuredSnrBuf, guca_RxSupportedToneSet);
   }
//XDSLRTFW-464 : DS_MARGIN_LOWER_TO_BRCM_DISTRIBUTE_FINEGAIN (End)

   //XDSLRTFW-1298 : ATTNDR FIX for ReTx
   //Allow the function to be called. We have updated the gla_MaxSumLp for ReTx
   // compute maximum (attainable) data rate
   //#ifdef ENABLE_RETX_DS
   // Skip this computaiton for VDSL retx mode for now
   //    if (gt_ReTXParams.uc_OMSG1_DsReTxEnabled != RETX_SELECTED)
   //#endif
   //XDSLRTFW-1527 : ATTNDR in ReTx Mode
   ComputeMaxDataRate();
   //XDSLRTFW-1298 : ATTNDR FIX for ReTx


   //XDSLRTFW-1456
   //Restore the original MinMsgOHR requirement(should be 16kbps) such that
   //Downshift SRA will not be limited by too small actual MsgOHR.
   gt_FormFramingParamsInputs_v2.s_MinMsgOHR = gs_MinMsgOHR_save;

   gs_RxBkgdProcessFlag = TRAINING_DONE;
}


