/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: BitswapHandler_VDSL2.c
*
*   This file contains functions to handler bitswapping in showtime.
*
*-------------------------------------------------------------------------------
*/

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "eoc.h"
#include "cmv.h"
#include "fifo.h"
#include "IRI_Iof.h"
#include "dsp_op.h"
#include "BitswapHandler.h"
#include "BitswapDecision_VDSL2.h"
#include "show_iof.h"


extern void CalcBgtChecksum(void);
extern void TriggerEventLp(void);
extern void TriggerEventOlrHandler(void);

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void RxBitswapHandler_VDSL2(void)
*
*  This function is the state machine function to perform the RX bit-swap.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*     gt_RxOLRPMVars.uc_rxOLRPMState - (I/O) OLR state
*     guc_BitSwapState - (I/O) state of the bit-swap handler
*     gft_RxBitSwapFlag - (I/O) indicator of bit-swap successful or not
*     guca_RxBitswapToneSet[] - (O) array to indicate which tones where bit-swap applies
*     gus_RxBitSwapStatus - (I/O) status of certain bit swap related operation
*     gs_RxBkgdProcessFlag - (I/O) RX back ground processing flag
*     gft_EnableFdqUpdate - (O) FDQ update enable/disable flag
*     gft_EnableFdqUpdate - (O) SNR update enable/disable flag
*     gt_OlrPm_TxOvhdMsgInfoInput - (O) OLR/PM message structure
*     gt_RxOLRPMVars - (O) OLR/PM state machine structure
*-------------------------------------------------------------------------------
*/

void RxBitswapHandler_VDSL2(void)
{

   static int16 s_RxBitSwapHandlerCnt;
   int32 l_ret;

   switch (guc_BitSwapState)
   {
   case BITSWAP_INIT:

      //gs_BsFrmCnt=gs_RxPMDFrameCount;
      // If the modem is not in L0 State, or if the bit-swap and SRA is disabled
      //XDSLRTFW-2550 (Start)
      if((gt_RxOLRPMVars.uc_rxOLRPMState != L0_STEADY_STATE) ||
         ((!(TESTArray[TEST_ReconfigControl] & TEST_ForceBitswap)) &&
          (gft_EnableRxBitSwap == FALSE) && (gft_EnableRxAutoSRA == FALSE))
        )
      //XDSLRTFW-2550 (End)
      {
         //record error code and error status in OLR cmv
         //STATArray[STAT_OLRError_DS] |= REQ_NOT_IN_L0_STATE;
         //STATArray[STAT_OLRStatus_DS] |= STAT_OLRPM_ABORTED;
         guc_BitSwapState = BITSWAP_DONE;
      }
      else
      {
         //***************************************************************************//
         //BS-S-1.   Copy active BAT-FG to Inactive BAT-FG(Start)                     //
         //***************************************************************************//
         // XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
         guc_SRAState = SRA_INIT;   //Initialize SRA state
         // XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

         gft_RxBitSwapFlag = FALSE;

         //Set up pointer for showtime SNR buffer
         gpsa_MeasuredSnrBuf = gsa_SnrBuf;

         // Clear the bitswap tone set for use later
         memset(guca_RxBitswapToneSet, 0, (gs_RxNumTones>>3));

         //Copy the active bit/gain/EGT table to the inactive ones if they are not same
         //(Note: the inactive tables may be contaminated in the previous
         // unsuccessful bit-swap attemps).
         if(gus_RxBitSwapStatus & RX_BITSWAP_BGT_MISMATCH)
         {
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, CopyRxBGT_ActiveToInactive);
         }

         s_RxBitSwapHandlerCnt = 0;
         guc_BitSwapState = BITSWAP_GAIN_CONVERSION;
         //****************************************************************************//
         //BS-S-1(End)                                                                 //
         //****************************************************************************//

      }

      break;

   case BITSWAP_GAIN_CONVERSION:
      //**********************************************************************************************************//
      //BS-S-2.   Read FG from inactive FG table and convert it from 3.13 linear to 8.8 dB format and store it in //
      //Inactive FG Table (done in RxBitswapHandler_VDSL2())                                                      //
      //BS-S-3.   Compute RMS FG per band inside BS-S-2 in form of Sum of fine gain linear square in              //
      //gla_SumFGainLinSq[] variable(Start)                                                                       //
      //**********************************************************************************************************//
      //**************************This section is common for both BS and SRA**************************************//

      //If the RX fine gain has not been converted to dB format,
      //call the background function to convert the inverse of linear fine gain
      //the fine gain in dB
      s_RxBitSwapHandlerCnt++;
      if(s_RxBitSwapHandlerCnt == 2)
      {
         //Convert the 1/gain to the gain in dB
         gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)RxBitSwapGainConversion_VDSL2);

         guc_BitSwapState = BITSWAP_GAIN_CONVERSION_WAIT;
      }

      break;
      //*********************************************************************************************************//
      //BS-S-2 & BS-S-3 (End)                                                                                    //
      //*********************************************************************************************************//
   case BITSWAP_GAIN_CONVERSION_WAIT:

      //Wait until the gain conversion is completed, go to the next substate
      if(gs_RxBkgdProcessFlag == TRAINING_DONE)
      {
         //Set the bit to indicate that inactive BGT does not match to the active BGT (need to reload)
         gus_RxBitSwapStatus |= RX_BITSWAP_BGT_MISMATCH;

         guc_BitSwapState = BITSWAP_DECISION;
      }

      break;

   case BITSWAP_DECISION:

      //XDSLRTFW-2550 (Start)
      //Call background function to make the bitswap decision
      {
         PtrToFunc p_Function = (PtrToFunc)NULL;

         if (gft_EnableRxBitSwap == TRUE)
         {
            p_Function = (PtrToBkgdFunc)BgRxBitSwapDecision_VDSL2;
         }
         // XDSLRTFW-3254 (Start)
         else if (gft_CapableRxAutoSRA == TRUE)
         {
            gft_SRA_FAIL = FALSE;
         }
         // XDSLRTFW-3254 (End)

         //Perform bit swap test
         if(TESTArray[TEST_ReconfigControl] & TEST_ForceBitswap)
         {
            p_Function = (PtrToBkgdFunc)RxBitSwapDecisionForTest_VDSL2;
         }
         //XDSLRTFW-1379 [Start]
         else if(gft_EnableRxAutoSRA && (gft_USRAInitiate || gft_DSRAInitiate)&& (gft_BlockSRA == FALSE) && (gft_SRA_FAIL == FALSE))
         {
            p_Function = (PtrToBkgdFunc)RxSRADecision_VDSL2;
         }
         else if(TESTArray[TEST_ReconfigControl] & TEST_TestOLR)
         {
            p_Function = (PtrToBkgdFunc)RxSRADecisionForTest_VDSL2;
         }

         if (p_Function != (PtrToFunc)NULL)
         {
            gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
            AddFunctionToBkgdFifo(p_Function);
         }
      }
      //XDSLRTFW-2550 (End)

      //Skip the SRA_WAIT state if SRA is disabled
      if(!gft_EnableRxAutoSRA || !(gft_USRAInitiate || gft_DSRAInitiate) || gft_BlockSRA || gft_SRA_FAIL)
      {
         //XDSLRTFW-1379 [End]
         guc_BitSwapState = BITSWAP_DECISION_WAIT;
      }
      else
         guc_BitSwapState = SRA_DECISION_WAIT;

      break;

   case SRA_DECISION_WAIT:

      //Wait in this state until previous SRA state is completed
      if(gs_RxBkgdProcessFlag == TRAINING_DONE)
      {
         //Move to next state only if SRA decision is done,
         //else go back to BITSWAP_DECISION
         if(guc_SRAState != SRA_DONE)
            guc_BitSwapState = BITSWAP_DECISION;
         else
            guc_BitSwapState = BITSWAP_DECISION_WAIT;
      }
      // XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]

      break;

   case BITSWAP_DECISION_WAIT:

      //Wait the background process to finish
      if(gs_RxBkgdProcessFlag == TRAINING_DONE)
      {
         if(gft_RxBitSwapFlag == TRUE)
         {

            //Reload the active RX fine gain table to inactive table
            //since we do not want to convert those gains which are not changed by bit-swap
            //In the 6.2 HW, we cannot copy BGT separately
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, CopyRxBGT_ActiveToInactive);

            s_RxBitSwapHandlerCnt = 0;
            guc_BitSwapState = BITSWAP_RELOAD_GAINS_WAIT;

         }
         else
         {
            // Undo the local changes done to the SW bat to ensure the SNR computation
            // is fine. SNR computation assumes that inactive BAT matches the active BAt table
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, CopyRxBGT_ActiveToInactive);

            guc_BitSwapState = BITSWAP_DONE;
         }
      }

      break;

   case BITSWAP_RELOAD_GAINS_WAIT:

      s_RxBitSwapHandlerCnt++;
      if(s_RxBitSwapHandlerCnt == 2)
      {
         //Call background function to change the gains that have been affected by
         //the bit-swap decision logic
         gs_RxBkgdProcessFlag = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)ChangeRxGainsForBitSwap);

         guc_BitSwapState = BITSWAP_CHANGE_GAIN_WAIT;
      }
      break;

   case BITSWAP_CHANGE_GAIN_WAIT:

      if(gs_RxBkgdProcessFlag == TRAINING_DONE)
      {
         // Disable FDQ adaptation for the time being until bitswap happens
         gft_EnableFdqUpdate = FALSE;
         gft_EnableSnrUpdate = FALSE;

         // set OLR msg type
         if (gt_rx_config_v2.ul_Reconfig_Lp[gs_data_path] == gt_rx_config_v2.ul_Lp[gs_data_path])
         {
            gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type = BITSWAP_REQ;
         }
         else
         {
            // XDSLRTFW-1031_OLR Type-5 request for DS-SRA in DS-ReTx mode (START)
            if ((gt_ReTXParams.t_ReTXConfigCMV.uc_G_Inp_Amend1_Support) && (gt_ReTXParams.uc_OPMS_G_Inp_Amend1_Support & 0x1)
                  && (gt_ReTXParams.uc_OMSG1_DsReTxEnabled == RETX_SELECTED))
            {
               // When SRA and retransmission are simultaneously enabled, the modems use OLR Request Type 5
               // to initiate an SRA request. These OLR commands replace the OLR Request Type 3 (SRA)
               // when retransmission is enabled.
               gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type = SRA_RETX_REQ;

               //XDSLRTFW-1393 (Start_End)
               gft_Start_DTU_Stoppage_Detection = TRUE;
            }
            else
               // XDSLRTFW-1031_OLR Type-5 request for DS-SRA in DS-ReTx mode (END)
            {
               gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type = SRA_REQ;
            }
         }
         gt_OlrPm_TxOvhdMsgInfoInput.uc_message_designator = RECONFIG_CMD_DESIG;
         gt_OlrPm_TxOvhdMsgInfoInput.uc_Source = AUTO_CMD_SOURCE;

         guc_BitSwapState = BITSWAP_REQUEST;
      }
      break;

   case BITSWAP_REQUEST:

      // If queue request was unsuccessful, remain in same state and try again next frame.
      l_ret = TxEocSendRequest(0, gt_OlrPm_TxOvhdMsgInfoInput);

      if (l_ret == EOC_QUEUE_ADDED)
      {
         gt_RxOLRPMVars.uc_rxOLRPMState = (uint8)OLR_RECV_SYNC_INDICATOR;
         // XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
         gt_RxOLRPMVars.s_ReconfigSymCnt = BITSWAP_RECONFIG_SYMBOL;
         // Set event to reconfigure Lp for SRA request
         if (gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type == SRA_REQ)
         {
            gt_RxOLRPMVars.s_rxOLRPMEvent = RECONFIG_Lp;
            gt_RxOLRPMVars.s_ReconfigSymCnt = SRA_RECONFIG_SYMBOL;
         }
         // XDSLRTFW-1032_New_framing_for_SRA_in_DS-ReTx_mode (START)
         else if (gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type == SRA_RETX_REQ)
         {
            gt_RxOLRPMVars.s_rxOLRPMEvent = RECONFIG_Lp;
            // The transmitter/receiver aligned change of framing is applied in the
            // 10th DMT data symbol after an inverted DMT sync symbol
            gt_RxOLRPMVars.s_ReconfigSymCnt = BITSWAP_RECONFIG_SYMBOL;
         }
         // XDSLRTFW-1032_New_framing_for_SRA_in_DS-ReTx_mode (END)
         //Go to the bitswap wait state when the last request
         // is added successfully to the queue
         guc_BitSwapState = BITSWAP_STEADY_STATE_WAIT;
      }
      break;

   case BITSWAP_STEADY_STATE_WAIT:
      // Go to the bitswap done state only when steady state is reached
      if(gt_RxOLRPMVars.uc_rxOLRPMState == L0_STEADY_STATE)
      {
         guc_BitSwapState = BITSWAP_DONE;

         if((gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type == SRA_REQ)
               || (gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type == SRA_RETX_REQ)) // XDSLRTFW-1032_New_framing_for_SRA_in_DS-ReTx_mode
         {
            // Check if more bits need to be added/cut to attain the desired margin
            if(gl_SRATotalLp_DeltaCnt < gl_SRATotalLp_Delta)
            {
               // Limit number of SRA iterations before returning to SNRFDQ handler
               // current implementation allows 10 SRAs before a new SNR FDQ update
               if(gs_NoOfDsSraAfterSnrUpdate >= MAX_NO_OF_SRA_UPDATE_AFTER_SNRFDQ_UPDATE)
               {
                  // Terminate the current SRA task and go to update SNR
                  // and re-compute the new delta lp desired based on the measured margin
                  gl_SRATotalLp_DeltaCnt = 0;
                  gl_SRATotalLp_Delta = 0;
                  gs_NoOfDsSraAfterSnrUpdate = 0;
               }
               else
               {
                  // Go on performing a new SRA
                  guc_BitSwapState = BITSWAP_INIT;
               }
            }
            else
            {
               // Current SRA task done
               // Clear the SRA related global variables
               gft_DSRAInitiate = FALSE;
               gft_USRAInitiate = FALSE;
               //gft_SNRUpdated_PostSRA = FALSE;
               gs_DTIME_Count = 0;
               gs_UTIME_Count = 0;
               gl_SRATotalLp_DeltaCnt = 0;
               gl_SRATotalLp_Delta = 0;
               gs_NoOfDsSraAfterSnrUpdate = 0;
            }
         }
         else // if bitswap request processed or SOS request processed
            // XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]
            // Go back to SNR/ FDQ updates
         {
            // Go to the bitswap done state when the last request
            // is added successfully to the queue
            if(TESTArray[TEST_ReconfigControl] & TEST_AbandonSRA )
               gft_BlockSRA = FALSE;
         }

#ifdef DEBUG_TRACES
         // Write OLR Event into debug buffer
//            TriggerEventLp();
         TriggerEventOlrHandler();
         AddFunctionToBkgdFifo((PtrToBkgdFunc)CalcBgtChecksum);
#endif
      }
      break;
   } //switch
}

//#endif
