/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   BitSynchHandler_VDSL2.c
 *
 *   This file contains the routine that searchs for the beginning symbol
 *   of each five consecutive symbol group representing 1 bit in the VDSL2
 *   loop diagnostic mode.
 *
 *------------------------------------------------------------------------
 */

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "ByteSynchHandler_VDSL2.h"
#include "ModulateSocMessages.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void BitSynchHandler(void)
*
*   This functions is used in the VDSL2 loop diagnostice mode.
*   In the diagnostic mode, each bit in SOC message is represented in five consecutive
*   symbols which have tones modulated by either all (++) or (--) phase
*   This function searchs for the beginning symbol of each five consecutive symbol group.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ByteSynchHandler(void)
{

   static int16 s_NumOfRevHDLCFlags;

   switch(gs_AlgHandlerState)
   {

   case BYTE_SYNCH_INIT:

      gs_AlgHandlerState = BYTE_SYNCH_WAIT;

      break;

      //--------------------------------------------------
      //Initialization
      //--------------------------------------------------
   case BYTE_SYNCH_WAIT:

      //Initialize the per-bit based symbol count for the next symbol
      gs_SymCntPerBit = (gl_RxSymbolCount-gl_RxBitStartSym)%gus_NumSymbolsPerBit;

      //Go to the next substate at the beginning of a new bit
      if(gs_SymCntPerBit == (gus_NumSymbolsPerBit-1))
      {
         //Set this variable to 8 so the next symbol will start with a new bit
         gs_RxNumSocBitPerByte = 8;

         s_NumOfRevHDLCFlags = 0;

         gs_AlgHandlerState = BYTE_SYNCH_DECODE_SYMBOL;
      }

      break;

   case BYTE_SYNCH_DECODE_SYMBOL:

      //Demodulate the symbol to get the bit information
      DemodSocMsgForDiagMode();

      //If a whole byte is received and if it is HDLC flag
      //declare the byte synchronization is done
      if((gs_RxNumSocBitPerByte == 8) && (guc_RxSocByte == 0x7E))
      {
         //Update the number of HDLC flags received
         s_NumOfRevHDLCFlags++;

         //To increase the decoding reliability, the minimum number
         //of HDLC flags must be received before declare the byte alignment
         //is achieved
         if(s_NumOfRevHDLCFlags == 4)
         {
            //set this flag so DemodSocMsgForDiagMode() will be run in RxStateFunc()
            gft_RxSocMsgDemodFlag = ENABLE_LD_DEMOD_SOC_MSG;
            gs_AlgHandlerState = BYTE_SYNCH_DONE;
         }
      }
      //continue to receive the next bit
      else if(gs_RxNumSocBitPerByte == 8)
      {
         //Reset the HDLC flag
         s_NumOfRevHDLCFlags = 0;

         //Shift 1 bit out
         guc_RxSocByte >>= 1;

         //Reduce the bit count by 1
         gs_RxNumSocBitPerByte--;
      }

      break;

   } //switch(gs_AlgHandlerState)

}

