/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2010 Lantiq. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: FramingGenLP0.c
*
*   This file contains VDSL2 retransmision framing generation
*   for ROC-style calculation for VDSL2 RTX OHC in LP0
*
*-------------------------------------------------------------------------------
*/
//************************************************************************************************************************
// 29/10/2013 Anantha Ramu: Modifications done to calculate ATTNDR with attndr_method set to 0(default),1 & 2 as per
//                          Amd 2 of G.998.4. The attndr_method is decided by CO MIB, and conveyed to CPE in O-TPS.
//                          CPE also indicates capability to calculate ATTNDR with methods 1 & 2 in R-MSG2
//                         (Field: ATTNDR method capability). In methods 1 & 2 the configured INPs used for calculation
//                          are conveyed to CO through overhead test parameters response along with ATTNDR value.
//                          Grep for: XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR
//
// 27/11/2014 Anantha Ramu: RS check bytes changed for the case of Intra DTU interleaving.
//                          Grep for XDSLRTFW-1617
//
// 26/11/2015 Anantha Ramu: Added modifications for SRA with US Intra DTU Interleaving.
//                          Grep for "XDSLRTFW-2341".
//*************************************************************************************************************************
#include "common.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "typedef.h"
#include "gdata.h"
#include "cmv.h"  //XDSLRTFW-3493(Start_End)
#include "GenFramingParams_VDSL2.h"


#include "Bitload.h"

#define INP_ROC_MAX         (8)


/*^^^
*-------------------------------------------------------------------------------------------------
*
*   Prototype:
*       FlagT FormVDSL2FramingParamsRetx(VDSL2FramingParamsInputs_t *pt_Input, VDSL2Config_t *pt_Output)
*
*   Abstract:
*       This function implements the optimal ADSL2 rate generation algorithm.  This algorithm
*       takes as input measured SNR values along with parameter restrictions (e.g. Min-INP,
*       Min/Max-Delay, Min/Max-Data Rate, & Min/Max-Msg-Overhead Rate) and outputs
*       the framing configuration (i.e. Lp, Bpn, Mp, Dp, Rp, Tp, Gp, Fp) that the
*       receiver will use.
*
*       Reference Matlab code:
*          VDSL2Framing.m
*
*   Input Parameters:
*       pt_Input      -- pointer to the input structure "VDSL2FramingParamsInputs_t"
*
*   Output Parameter:
*       pt_Output     -- pointer to the output structure "VDSL2Config_t"
*
*   Return:
*       SUCCEED       -- indicate we can generate a set of valid framing parameters
*       FAIL          -- indicate we cannot generate valid set of framing parameters
*
*   Global Variables:
*       gsa_log2Tbl   -- use to perform division by Mp
*       gs_VDSL2FrameParamGenStatus -- Bit-field register to indicate the error
*                                      code/status from FormVDSL2FramingParams()
*
*--------------------------------------------------------------------------------------------------
^^^*/
FlagT FormVDSL2FramingParamsRetx(VDSL2FramingParamsInputs_t *pt_Input, VDSL2Config_t *pt_Output)
{
   FlagT ft_BitloadOK;
   uint32 ul_LpAvailable;
   uint16 us_Rp = 4;
   //XDSLRTFW-1617 (Start)
//XDSLRTFW-2162 (Start - End)
   if(gft_Intra_DTU_Ilv_DS == TRUE)
   {
      us_Rp = guc_DS_ReTx_iDTU_R;  //XDSLRTFW-3493(Start_End)
   }
   //XDSLRTFW-1617 (End)
   gl_FramingGenErrCode = 0;

#ifndef STANDALONE_TEST
   // Perform dual latency bitloading assuming a conservative coding gain with Rp = 4 for
   // both latency paths for now
   ft_BitloadOK = CalcChannelCapacity((int16)us_Rp, &gl_MaxSumLpSupported);
#endif

   //////////////////////////////////////////////////////
   // Perform framing generation for LP0 ovhd only path
   //////////////////////////////////////////////////////
   ft_BitloadOK = RtxFramingVdsl_V1_OhcCalc(pt_Output);

   if(!ft_BitloadOK)
   {
      gl_FramingGenErrCode |= E_CODE_OHC_FRAMING_GEN_FAIL;
      return(ft_BitloadOK);
   }

   ul_LpAvailable = (uint32)(gl_MaxSumLpSupported - pt_Output->ul_Lp[LP0]); // reduction by bits for LP0
//Feature_DS_VDSL2_ALL_UsReTx XDSLRTFW-1077 Rx RRC word (Start)
   if (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
   {
      ul_LpAvailable -= US_RRC_BITS;
   }
   //Feature_DS_VDSL2_ALL_UsReTx XDSLRTFW-1077 Rx RRC word   (End)
   //XDSLRTFW-1298 : ATTNDR Fix for ReTx
   //XDSLRTFW-1527 : ATTNDR in ReTx Mode
   // Used for ATTNDR Calculation
   // save channel capacity given a value of check byte
   gla_MaxSumLp[(us_Rp>>1)] = (int32)ul_LpAvailable;
   //XDSLRTFW-1298 : ATTNDR Fix for ReTx

   //////////////////////////////////////////////
   // Perform framing generation for LP1 path
   //////////////////////////////////////////////
   //XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(Start)
   //XDSLRTFW-1522 (Start)
   gft_CalcAttndr = FALSE;
   //XDSLRTFW-3493(Start)
   if (TESTArray[TEST_Control4] & TEST_Control4_Enhanced_ReTx_Framing_Bit10_Mask)
   {
      ft_BitloadOK = RtxFramingVdsl_V3(ul_LpAvailable, pt_Output);
   }
   else
   {
      ft_BitloadOK = RtxFramingVdsl_V1(ul_LpAvailable, pt_Output);
   }
   //XDSLRTFW-3493(End)
   //XDSLRTFW-1522 (End)

//XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(End)

   if(!ft_BitloadOK)
   {
      gl_FramingGenErrCode |= E_CODE_RETX_FRAMING_GEN_FAIL;
   }

   return(ft_BitloadOK);
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: FlagT RtxFramingVdsl_V1_OhcCalc(VDSL2Config_t *pt_Output)
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*    Get the highest possible effective net data rate (also called throughput) in case of retransmission
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
FlagT RtxFramingVdsl_V1_OhcCalc(VDSL2Config_t *pt_Output)
{
   FlagT ft_retVal = FALSE;
   int16 s_path = LP0;
   int16 i, k,CWspreadedMax, INPmax;
   int16 DELAY, INPmin, MSG_min_local, CWspreaded, delay_octet;
   int16 PER, D, G, T, N, M;
   int32 l_Lp, l_L0_opt;
   int16 PERB, SEQ, INP;
   int16 OR, MSG, fdmt;
   uint32 ul_temp;

   int16 s_F0_opt, s_N0_opt, s_R0_opt,s_B0_opt, s_D0_opt, s_G0_opt, s_T0_opt, s_M0_opt;
   int32 l_NE_limit, max_delay_octet;

   VDSL2FramingParamsInputs_t *pt_FramingParamsInputs;

#ifndef STANDALONE_TEST
   l_NE_limit = (gul_HW_DILV_MEM_SIZE[LP0] << 1);

   // Take the minimum of the near end and the far end limit
   max_delay_octet = MIN(l_NE_limit, gla_MaxInlvDelay[LP0]);
#else
   max_delay_octet = max_delay_octetDS0;
#endif

   //Set the pointer to the framin parameter input structure
   pt_FramingParamsInputs = &gt_FormFramingParamsInputs_v2;

   s_N0_opt = 0;
   s_G0_opt = 0;
   s_T0_opt = 0;
   s_M0_opt = 0;
   l_L0_opt = 0;
   s_D0_opt = 0;
   s_B0_opt = 0; // Ovhd only path
   s_R0_opt = 16; // Fix Rp = 16 for ROC channel
   s_F0_opt = 1;


   // It shall be taken into account the constraint as mentioned in A.1.2 that the LP0 FEC codeword spreaded
   // by interleaving at delta interface in DMT data symbols must not exceed the 120 Hz REIN period in DMT data
   // symbols (otherwise the spreaded codeword could be corrupted by two REIN impulses and the FEC INP wouldn't
   // be sufficient anymore).

   // The spreaded codeword in bytes is N+(N-1)*(D-1) = N+N*D-D-N+1 = D*(N-1)+1, so in DMT data symbols (D*(N-1)+1)*8/L.
   // The REIN period in DMT data symbols is floor(Trein/Tdmt)-1 and the "-1" takes into account that a sync symbol
   // can be within the REIN period, so you get in profile 30a floor(8.333/0.125)-1 = 65 and in all other VDSL2 profiles
   // floor(8.333/0.250)-1 = 32.

   // In case of 30a profile
   if (gs_frame_rate_is_8khz)
   {
      fdmt = 8;
      CWspreadedMax = 65;
      INPmax=2*14;
   }
   else
   {
      fdmt = 4;
      CWspreadedMax = 32;
      INPmax=2*8;
   }

   // Required INP for the OHC depends only on configured INP REIN but not
   // on INP SHINE according to C.1.2/G.998.4 INPMIN-ROC = max(INPMIN_REIN, 2).
   INPmin = MAX(2,(gt_ReTXParams.t_ReTXConfigCMV.us_OTPS_INP_min_REIN&0x1F));

   // The valid range of achievable INP on the ROC path is from 0 to 8 symbols
   if (INPmin > INP_ROC_MAX)
   {
      INPmin = INP_ROC_MAX;
   }

   // Make sure that MSGmin >= 16 Kbps
   MSG_min_local = MAX(pt_FramingParamsInputs->s_MinMsgOHR,16);

   for (l_Lp=8; l_Lp <= 128; l_Lp = l_Lp+8)
   {
      // Vlaid range of D for ROC is 1 to 20
      for (D=1; D<=20; D++)
      {
         for (i=0; i < 6; i++)
         {
            G = GTM[i*3];
            T = GTM[i*3 + 1];
            M = GTM[i*3 + 2];

            // Nfec = Mp * Gp/Tp as Bpn = 0 for overhead only path
            N = (M * ceil16(G,T)) + s_R0_opt;

            // For overhead only path TDRp <= 256 Kbps
            // Hence we have
            // PERBp = (Tp * Nfecp / Mp) * ( 17000 * Lp * fs * Mp)/(7880 * Tp * Nfecp)
            //       = (Tp * Nfecp / Mp) * ( 17000 * Lp * 256 * Mp)/(7880 * 257 * fdmt* Tp * Nfecp)

            k = T/M;

            PERB = (1700 * l_Lp * fdmt * 256 )/ (788 * k * 257 * N);
            PERB = k * N * PERB;
            if (PERB <= 0)
            {
               continue;
            }

            // Ensure that S <= 64
            if ((l_Lp << 3) < N)
            {
               continue;
            }

            // ORp = (Gp * Mp* Lp* fs) / (N*Tp) expressed in Q12.4
            OR =  ((l_Lp * fdmt * M * G) << 12)/ (T * N * 257);

            // SEQp = (Gp * PERBp * Mp)/ (Tp * Nfecp);
            SEQ = (G * PERB * M )/ ( T * N);

            // Account for Q12.4 format for ORp
            MSG = OR * (SEQ-6)/ (SEQ << 4); // 16 <= MSG <= 256

            if ((MSG < MSG_min_local) || (MSG > 256))
            {
               continue;
            }

            PER = (PERB * 257 )/ (l_Lp * fdmt * 32); // 15 <= PER <= 20

            if (PER > 20) //|| (PER < 15))
            {
               continue;
            }

            // Fix R = 16 for ROC
            INP = (D << 6)/l_Lp; // INP>=2 and INP>=INP_min_rein

            if ((INP < INPmin) || (INP > INPmax))
            {
               continue;
            }

            // Assume q = 1.
            // Hence Delay = (8 * (N - 1) * (D - 1))/ ( Lp * fs)
            ul_temp = (257 * (D-1) * ( N - 1));

            DELAY = ceil32(ul_temp, (int16)(l_Lp * fdmt * 32)); // DELAY<=8

            CWspreaded = 8 * ( D*(N-1) + 1)/l_Lp; // CWspreaded<=65 in profile 30a, CWspreaded<=32 in all other profiles

            // Max delay octet = (I - 1) * (D -1)
            // For q=1, we have
            // Max delay octet = (N - 1) * (D -1)
            delay_octet = (D-1) * (N - 1);

            // Check if it satisfies all the constraints
            if ((DELAY <= 8) && (CheckCoPrime(D, N)== 1) && (CWspreaded <= CWspreadedMax))
            {
               // Save the combination which involves the least memory usage
               // while satisfying all the requied constraints
               if (delay_octet < max_delay_octet)
               {
                  ft_retVal = TRUE;

                  s_G0_opt = G;
                  s_T0_opt = T;
                  s_M0_opt = M;
                  l_L0_opt = l_Lp;
                  s_D0_opt = D;
                  s_N0_opt = N;

                  gl_delay_octet_LP0 = delay_octet;

                  // Limit the max value for hte next search to minimise the memory usage
                  max_delay_octet = delay_octet;

               } // end of if

            } //if ((DELAY <= 8) && (coprimecheck(D, N)== 1))

         }   // for (k=0; k < 6; k++)

      } // for (D=1; D<=20; D++)

   } // for (L=8; L<= 128;L= L+8)

   // Save the basic framing parameters
   pt_Output->s_Rp[s_path] = s_R0_opt;
   pt_Output->s_Mp[s_path] = s_M0_opt;
   pt_Output->s_Dp[s_path] = s_D0_opt;
   pt_Output->s_Tp[s_path] = s_T0_opt;
   pt_Output->s_Gp[s_path] = s_G0_opt;
   pt_Output->s_Fp[s_path] = s_F0_opt;
   pt_Output->ul_Lp[s_path] = l_L0_opt;

   pt_Output->s_Ip[s_path] = s_N0_opt;

   return(ft_retVal);
}

