/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2010 Lantiq. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: FramingGenLP1.c
*
*   This file contains VDSL2 retransmision framing generation
*   for the retransmission path LP1
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// FramingGenLP1.c
//
// History
//
// 24/12/2012 Ram: ETR_max was being ignored in FW during computation of ETR.
//                 SE has clarified that the current framer algo optimizes ETRu towards NDR_max
//                 when CIPolicy = 0. CIPolicy = 1 is reserved by G.998.4 spec.
//                 Grep for 'XDSLRTFW-409: BugFix_DS_VDSL2_ALL_ETR_Max_Ignored_By_FW'
//
// 29/05/2013 Anantha Ramu: ATTNDR vales for ReTX was not proper. Modified code to populate initial ATTNDR(
//                          just before showtime) and updates for ATTNDR (in showtime).
//                          Grep for XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr
//
//  10/09/2013 Sooraj: Added framing changes to support DS-SRA with ReTx
//                 Grep for XDSLRTFW-1063: SRAds_Support_with_DS_ReTx
//
// 18/10/2013 Palaksha: Addded fix for Data memory corruption when both US/DS ReTx are enabled. The isse is
//                  seen at short loops where DS/US rate are higher and memory reqt for US and DS Retx buffer is more
//                  The fix includes considering only available memory (After allocating for US ReTx buffer)
//                  while deciding DS ReTx QTX value
//            Grep for XDSLRTFW-1329 BugFix_USDS_VDSL2_ALL_UsDsReTxMemCorruptHighDsUsRate
//
// 23/10/2013 Ram/Palaksha: 1. NDR (to be reported in CMV RATE 1) for ReTx mode is computed using equation provided in
//                    Table 9-2 in G.998.4 (G.Inp) standard. Modified the scaling factor while computing ETR
//                    to improve accuracy (as compared to Matlab/Scilab implementation).
//                    Grep for XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx
//
//                 2. Added code to compute 'delay_act_RTX' as specified in sec 11.2.5 of G.998.4 (G.Inp) standard.
//                    delay_act_RTX = round(Tdtu*Tdmt), where
//                    Tdtu = Q*8*NFEC/LSYMB; Tdmt = 0.25 if VDSL2 profile 8/12/17; Tdmt = 0.125 if VDSL2 profile 30
//                    Grep for XDSLRTFW-1227: BugFix_DS_VDSL2_ALL_ReTX_Delay
//
//                 3. Reporting ReTx Actual Delay in Steps of 0.01ms
//                  Grep for XDSLRTFW-744 Enh_All_VDSL2_All_IntlvDelayIn1By100ms
//
//                 4. Min value of Qrx is set to "Qtx+7" to handle Q-Full condition and to achieve Zero packet loss.
//                    Grep for XDSLRTFW-1209: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode
//
// 18/10/2013 Ram: 1. Added fix for JIRA XDSLRTFW-1323.
//                 Issue: ST Link drop seen in KPN test case (Loop length: 1500m, Noise: -120 dBm/Hz
//                        White Noise) even before SHINE/REIN noise is applied
//                 Fix: Array guca_DTU_Qstat[] (used for checking Q-Full condition) is allocated
//                      to support QRx of max QRETX_TRANS_TABLE_SIZE (64*3=192). However, QRx selected
//                      (QRx = 237) was greater than QRETX_TRANS_TABLE_SIZE. This lead to wrong Q-Full
//                      detection (due to memory access beyond the allocated size of array
//                      guca_DTU_Qstat[]) and finally we end up with lots of un-corrected DTUs and
//                      Link drops due to ESE. Fixed the issue by limiting QRx to "Max_QTx * 3",
//                      where in Max_QTx = 63 (as per Table A.6 of G.998.4 standard).
//                  Grep for XDSLRTFW-1323: BugFix_DS_VDSL2_ALL_STLinkDrop_KPNTestCase
//
// 28/10/2013 Ram: To avoid buffer overwrite (in QRx queue) while handing QFull condition with higher NDR
//                 (Say for NDR > 80-85Mbps) we need min QRx=QTx+12. To achieve this we are reducing Qtxmax by 3.
//                 This will lead to lower NDR that can be achieved. This should be treated as temporary solution.
//                 We have to redesign QRx queue handling mechanism to avoid buffer overwrite with lower QRx size.
//                 Once this is done, we can bring back Qtxmax to original value.
//                 Grep for XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR
//
// 29/10/2013 Anantha Ramu: Modifications done to calculate ATTNDR with attndr_method set to 0(default),1 & 2 as per
//                          Amd 2 of G.998.4. The attndr_method is decided by CO MIB, and conveyed to CPE in O-TPS.
//                          CPE also indicates capability to calculate ATTNDR with methods 1 & 2 in R-MSG2
//                         (Field: ATTNDR method capability). In methods 1 & 2 the configured INPs used for calculation
//                          are conveyed to CO through overhead test parameters response along with ATTNDR value.
//                          Grep for: XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR
// 12/11/2013 Kannan:
//                  Possible Max DTU size for profile 17a and above is 3072 Bytes
//                  For Qrx computation, we add +3 DTU's by comparing Qtx, adding +3 was exceeding the
//                  DS ReTx Queue memory size.
//                  In order avoid memory corruption, 3 DTU's space is subtracted from the available memory
//                  for DS LP1 framing. With this change we can add 3 DTU's space for Qrx, i.e Qrx = Qtx + 3.
//                  Grep for XDSLRTFW-1363 DSReTx_DS_Rate_Degration_by_10%
//
// 13/11/2013 Kannan:
//                  9K of "MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX" can be used effectively for DS ReTx Qrx
//                  Grep for XDSLRTFW-1363 DSReTx_DS_Rate_Degration_by_10%
//
// 05/12/2013 Ram: At max we can reserve only 6K of memory (for ensuring min QTx = QTx+12) to meet Amnd-2
//                 requirementes. A loop reach test was carried out (from 0M to 1000M) after reserving 6K memory,
//                 "QRx - QTx" achieved in all loop lengths was found to be > 12.
//                 Grep for "XDSLRTFW-1417"
//
// 12/02/2014 Anantha Ramu: Actual delay calculation modified so that now there are no underflows.
//                          Grep for "XDSLRTFW-1548"
// 10/03/2014 Kannan: Ds ReTx Framing search loop is optimized in such a way that searching of Lp value from
//                    Top down approach in stead of bottom up approach to get max data rate quickly.
//                    In limited data rate cases, net_max is limited and Lp available
//                    also get limited. REIN + SHINE case without optimization, DS ReTx framing took 13795 sym
//                    with optimization it took around 3577 symbols, i.e we can save around 10,000 symbols
//                    , i.e 2.5 secs (4000 symbols/sec).
//                    "ceil" library function is removed, instead added by "denominator-1" and divided
//                    by denominator. For Eg y = ceil(x/N) is implemented by y = (x + N-1)/N
//                    Grep for "XDSLRTFW-1610"
//
// 15/10/2014 Kannan: Fix to improve DS data rate due to DS framing limitation,
//                    i.e HQV table max index search is incresed from 31 to 37 for profiles other than 30a.
//                    This is mainly required for lower US and higher DS rate configurations,
//                    For Eg 10/140 Mpbs (US/DS)
//                    Grep for "XDSLRTFW-1816"
//
// 29/10/2014 Anantha Ramu: Computation for ReTx DS D added to support Intra DTU Interleaving.
//                          Grep for "XDSLRTFW-1617"
//
// 26/11/2015 Anantha Ramu: Added modifications for SRA with DS Intra DTU Interleaving.
//                          Grep for "XDSLRTFW-2162".
//
// 10/12/2015 Vinay: Added code to fix the issue of Line not reaching showtime when the Memory split (MDO SPLIT)
//                   is less than 30% in ReTx mode. This is also the fix for issue "XDSLRTFW-2398".
//                   Grep for "XDSLRTFW-2511"
//
// 21/01/2016 Vinay: The variable "net_max" is getting overwritten after making changes based on equation provided by Dietmar.
//                   Added new variable to prevent overwriting.
//                   Grep for "XDSLRTFW-2554"
//
// 11/02/2016 Vinay: Added a condition to use the new Lp limits in case of ATTNDR Method using Framer when memory split is
//                   less than 30%.
//                   Grep for XDSLRTFW-2586
//
// 21/9/2016 Sriram shastry  : NBN / VR9 DS performance is 100,871Mbps, expected is 103Mbps. vectoring+US&DS Retx
//       Internal 1-symbol HRTrx reduction in case of [RTX + G.Vector] operation for all  CO.
//    The test cases Vect=off with internal memory split show that the operator should not rely on a good internal split decision.
//    The internal split is not well-balanced for the wished service rates.
//    According to 998.4: + 1 sym can be ignored for vectoring+ 1 DTU (processing needs to wait for the last bit of each DTU)(+ 1 symbol because  of US/DS sync symbol alignment)
//    According to equation 1 of 9.5.1/G.998.4, it can be checked that the minimum required Qtx calculated by this equation (with the communicated HRT values and with the selected
//    framing parameters Q, NFEC1, L1) results to a required number of RTX buffer bytes Qtx*Q*H which exceeds the selected physical buffer size of MAXDELAYOCTETds/2 according to
//    D1.1/G.998.4 and would lead to a violation. It doesn't lead to a violation if the mentioned equation 1 doesn't take into account the extra +1 symbol
//      Added  debug code to  simulate  FW Internal Rein like disturber
//    1-symbol reduction in Qtx,min calculation:
//    It can be seen as a gap compensation. If only the ACK related gap occurs in the drawn triangle from start of Tack until end of Tret then
//    the +1 symbol in the Qtx,min calculation has to be taken into account. But if both gaps, the ACK related gap as well as the TX related gap,
//    occur within this triangle then these gaps are compensating each other w.r.t. Qtx,min demand and its not needed to take into account the
//    +1 symbol in the Qtx,min calculation.
//    If both gaps occur in the triangle, two cases can be distinguished SSdsOffset >= 0 (SSds comes after SSus) and SSds <= 0 (Ssus comes after SSds).
//    For SSdsOffset >= 0, the ds gap must be located within Tret, the right triangle part. For SSdsOffset <= 0, the ds gap must be located within Tack,
//    the left triangle part.
//    If both transceivers have no DTU specific HRT contribution (HRT_RX_D=0, HRT_TX_D=0) then the only DTU specific contribution in the total roundtrip
//    is the DTU transmission time itself which is already considered extra in the Qtx,min equation (not included in the HRTs, outside Tack/Tret) and
//    shown in the drawings before the triangle.
//    So from the figures it could be derived:
//    No +1 symbol in the Qtx,min calculation needed if  -HRT_RX <= SSdsOffset <= HRT_TX
//    But w.r.t. the mentioned uncertainty in which HRTs the PMD associated transmission times are included the range should be reduced by a symbol, i.e.
//    No +1 symbol in the Qtx,min calculation needed if  -HRT_RX+1 <= SSdsOffset <= HRT_TX-1
//      CMV Description : TEST 52 0 "Value"  can be used to over write, Internal HRT Rx Symb used in RTX  Framing generation.
//       Default setting : Disable [ TEST 52 0 0]
//    Grep for : XDSLRTFW-2858
//
// 28/04/2016 Vinay: No connects were observed when Memory split was less than 60%. This was due to the work around done for the issue
//                   XDSLRTFW-2254, where we select the new Lp range (based on Dietmar's equation) only if the memory split is less than 30%.
//                   This was due to a calculation bug where the rounding off was an error which later got corrected.
//             Grep for XDSLRTFW-3174
// 08/06/2017 Sriram Shastry:  Max data rate slightly  violated [ NDR > Max_NDR]. Added a additional 15ppm (Fixed point err) while computing NDR.
//                             Grep for XDSLRTFW-2709
//
// 22/11/2017 Abu Rahman
//            XDSLRTFW-3556: VRx518 shows different method_0 attainable datarate than VR9(R7)
//            Introduced a CMV based option to select Method_0 framing based DS ATTNDR or
//            channel capacity based DS ATTNDR calculation algorithm.
//                Set CNFG 86 3 = 0 : to select frame based Method_0 ATTNDR algorithm or
//                Set CNFG 86 3 = 1 : to select channel capacity based Method_0 ATTNDR algorithm (VR9-R7 like)
//            Note that this switching works only with Method_0 configuration
//            SEARCH PATTERN: XDSLRTFW-3556
// 15/12/2017 Kannan:
//            DS SRA was not triggered at 150m with iDTU in 35B mode due to mismatch of ReTx framer generated
//            output "Lp" and ReTx framer input "LpAvailable".
//            Grep for "XDSLRTFW-3562"
//
// 09/04/2019 Stefan Krause:
//            XDSLRTFW-4155 : ADTRAN CO drops right before reaching showtime
//            DSLAM verifies whether the final DS-NDR lower/equal to the configured maxNDR
//            Even a small violation (1-4 kbps) will result in fail of the NDR check resulting in a linkdrop
//            Quick-fix:      Reduce the (internal) threshold for the framing generation DS-NDR-check by 8kbps if link is not a "fixed-rate"
//                            "Fixed-rate" detection algorithm:
//                            If the delta between min and max NDR is < 64kbps we mark the link as a "fixed rate link"
//            Grep for "XDSLRTFW-4155"
//
// ************************************************************************************************************

#include "common.h"
#include <stdlib.h>
#include "typedef.h"
#include "gdata.h"
#include "mul.h"
#include "bitload.h"
#include "cmv.h"
#include "cmv_Data.h"
#include "dsp_op.h"
#include "vdsl_state.h"
//XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR (Start_End)
#include "zep_memmap_cnfg.h"
#include "LL_IOf.h"
#include "ppe_memmap.h"

extern ReTX_ShowtimeParams_t gt_ReTxShowtimeParams;
//extern uint32 gul_dbg_ul_LpAvailable_In  ;
//extern uint32 gul_dbg_ul_LpAvailable_New ;
//extern uint32 gul_dbg_ul_LpAvailable;// = ul_LpAvailable;
//extern uint32 gul_dbg_ul_LpMax1     ;//  = ul_LpMax1;
//extern uint32 gul_dbg_ul_LpMax2     ;//  = ul_LpMax2;
//extern uint32 gul_dbg_ul_LpMax3     ;//  = ul_LpMax3;
//extern uint32 gul_dbg_ul_LpMax4     ;//  = ul_LpMax4;
//extern uint32 gul_dbg_LpMax         ;//  = ul_LpMax;


//XDSLRTFW-1522 (Start)
#define MAX_ATTNDR_INP_ACT_SHINE (2047)  //See sec C.1.3.2 G.998.4 - Amd-2
#define MAX_ATTNDR_INP_ACT_REIN  (255)   //See sec C.1.3.2 G.998.4 - Amd-2
//XDSLRTFW-1522 (End)

//XDSLRTFW-2942 (Start)
#define PPE_INPUT_MAX_DEFAULT                   (12*1024) // Input buffer size at the PPE
#define PPE_INPUT_MAX_4KHZ                      (PPE_INPUT_MAX_DEFAULT)
#define PPE_INPUT_MAX_8KHZ                      (PPE_INPUT_MAX_4KHZ >> 1)

//XDSLRTFW-3493(Start)
// 704 = 2.75 * 256; (expressed in Q8.8 format)
// 755 = 2.95 * 256; (expressed in Q8.8 format)
#define SQMIN_35B_VRX518_CONSTRAINED            (755)
//XDSLRTFW-2942 (End)
#define SQMIN_NO_35B                            (512) //Q8.8 min 1/2 for 17a, 12, 8 & 30Mhz and 1/2.95 for 35B
#define SQMAX_DTU_SIZE_IN_SYMBOLS               (4)

#define SQMIN_NON_35B_x100_IN_BITS              (1600) //(2*100*8)=1600, SQmin is 1/2 for 17a, 12, 8 & 30Mhz
#define SQMIN_35B_x100_IN_BITS                  (2360) //(2.95*100*8) = 2360, SQmin is 35B for 1/2.95

void Sort_HQV_Table(uint16 us_imax);
uint32 GetNewLpWithCodingGain_iDTU(uint8 R, uint8 Q, uint32 ul_LpAvailable);
//XDSLRTFW-3493(End)

//XDSLRTFW-3493(Start)
FlagT RtxFramingVdsl_V3(uint32 ul_LpAvailable, VDSL2Config_t *pt_Output)
{
   // Indicate no solution found
   FlagT ft_retVal = FALSE;
   FlagT ia_rein_flag;
   //XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(Start)
   FlagT ft_attndr_calc = FALSE;
   //XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(End)

   uint32 ul_Lp, ul_LpMax, ul_LpMin, ul_LpminLimit, ul_LpmaxLimit;
   //uint32 ul_LpAvailableNetMax;  // XDSLRTFW-2511

   int16 inp_calc, cc=0;
   //XDSLRTFW-1522 (Start_End)
   uint16 us_ActShineInp, us_ActReinInp;
   int16 MinDataSymbolsRein, MaxDataSymbolsRein, MinDataSymbolsDelaymax;
   int16 Mp,SpMax,SpMaxLog2,Rp,Dp,Hp, Np, Qp,Vp, Np_Qp;
   int16 imax,imin=0;
   //int16 s_min1,s_min2,s_min3,s_min4, s_hqv_index_Min;
   int16 RTmem, Roundtrip;
   int16 i, RtInDTUs, Qtxmin, Qtxmax,Nrtx=0, Qtx,INP,NRET, idx;
   int16 NretQtxFound, NRETmax, NRETmin;
   int16 A, k_min, k_max;
   int16 DtuSize, s_CO, d_CO, d_CPE, s_CPE;
   int16 s_fs, s_temp;
   //int16 s_OHFactor;
   int16 Trein=0, s_Target_INP=0, INP_min, s_Trein_fdmt;
   int16 s_R1_opt=0, s_N1_opt=0, s_D1_opt=0, s_M1_opt=0, s_Q_opt=0, s_V_opt=0, s_Qtx_opt=0;
   uint32 ul_L1_opt=1;
   int32 l_ndr_eff_opt = 0;
   int16 SpMinInvers;
   int16 INP_min_rein, CIP, SHINEratio;

   int16 s_path = LP1;
   int16 s_D,s_I;
   int16 ComputedQrx, CapableQrx;

   //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (Start_End)
   //uint32 TRELLISratio, REINratio, RTXOH;
   uint32 ul_temp1;


   int16 fdmt;

   //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (Start_End)
   int32 l_max_ndr_eff_kbps, l_max_ndr_Q28x4_kbps, l_net_max_kbps, ndr_eff_, ndr_; // Q28.4 format
   //int32  ndr_fraction_; // Q28.4 format
   int32 max_delay_octet, l_NE_limit, l_Trein_fdmt;
   int32 RTmemMax;
   int32 l_ETR_min_kbps, l_ETR_max_kbps;

   /* XDSLRTFW-2709 */
   int32 l_net_max_Qf28x4_kbps,l_ETR_min_Qf28x4_kbps;
   /* XDSLRTFW-2709*/
   uint32 ul_dilv_size;
   //XDSLRTFW-634 : BUG_DS_ALL_ALL_ReTxThroughput (Start_End)
   uint16 us_platform;


   ReTX_Params_t *pt_ReTXParams;
   VDSL2FramingParamsInputs_t *pt_FramingParamsInputs;
   int16 s_MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX;
   uint32 ul_tmp;
   //XDSLRTFW-1617 (Start)
   uint8 uc_DS_ReTx_Max_D_CO_support;
   uint8 *uca_hqv_table;
   //XDSLRTFW-1617 (End)
   uint16 us_MaxDTUSizeDS;  //XDSLRTFW-3189
   uint16 us_PPE_INPUT_MAX;
   uint32 ul_addr, ul_data;

   int16  s_StartIndex;
   uint16 us_INP_min_rein_factor = 0;
   uint16 us_n_dtus = 0;
   uint16 us_Qp_Hp = 0;
   uint32 ul_LpMax1 = 0;
   uint32 ul_LpMax2 = 0;
   uint32 ul_LpMax3 = 0;
   uint32 ul_LpMax4 = 0;
   uint32 ul_LpMin1 = 0;
   uint32 ul_LpMin2 = 0;
   uint32 ul_LpMin3 = 0;
   uint32 ul_LpMin4 = 0;
   uint32 ul_Num_11 = 0;
   uint32 ul_Num_12 = 0;
   uint32 ul_Num_13 = 0;
   uint32 ul_Num_15 = 0;
   uint32 ul_Num_1 = 0;
   uint32 ul_Den_11 = 0;
   uint32 ul_Den_12 = 0;
   uint32 ul_Den_13 = 0;
   uint32 ul_Den_14 = 0;
   uint32 ul_Den_15 = 0;
   uint32 ul_Den_1 = 0;
   uint32 ul_ndr_eff_max_1;
   uint32 ul_ReinOH;
   uint32 ul_ShineOH;
   int32 l_ndr_eff_max;
   uint32 ul_ReinOH_IM = 0;

   uint16 us_SQmin = SQMIN_NON_35B_x100_IN_BITS; //x100 in Bits 1/2 for 17a, 12, 8 & 30Mhz and for 35B 1/2.95
   uint16 us_SQmax = SQMAX_DTU_SIZE_IN_SYMBOLS; // QSmax or SQmax will be for 4 DMT symbols

   //XDSLRTFW-3402 (START)
   uint32 ul_DtuPayloadSize;
   uint32 ul_PaddingBytes;
   //XDSLRTFW-3402 (END)

   //XDSLRTFW-1522 (Start_End)
   ReTx_ComputeInp_Params_t t_ComputeInp_Params;

   pt_ReTXParams = &gt_ReTXParams;

   //Set the pointer to the framin parameter input structure
   pt_FramingParamsInputs = &gt_FormFramingParamsInputs_v2;

   // Get the retx framing inputs
   SpMinInvers = pt_ReTXParams->uc_OMSG1_Ds1overSMax;
   // Convert to Kbps
   l_ETR_min_kbps = (pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_ETR_min << 3);
   l_ETR_max_kbps = (pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_ETR_max << 3);
   l_net_max_kbps = (pt_FramingParamsInputs->us_MaxRate << 3);

   // XDSLRTFW-4155 : ADTRAN CO drops right before reaching showtime
   //                 DSLAM verifies whether the final DS-NDR lower/equal to the configured maxNDR
   //                 Even a small violation (1-4 kbps) will result in fail of the NDR check resulting in a linkdrop
   //
   // Quick-fix:      Reduce the (internal) threshold for the framing generation DS-NDR-check by 8kbps if link is not a "fixed-rate"
   //                 "Fixed-rate" detection algorithm:
   //                 If the delta between min and max NDR is < 64kbps we mark the link as a "fixed rate link"
   if (     ((l_ETR_max_kbps - l_ETR_min_kbps) >= 64)
         && ((l_net_max_kbps - l_ETR_min_kbps) >= 64) )
   {
      l_net_max_kbps = l_net_max_kbps - 8;               // reduce max NDR by 8kbps
      l_ETR_max_kbps = l_ETR_max_kbps - 8;               // reduce max ETR by 8kbps
   }

   SHINEratio = pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_SHINE_ratio;
   CIP = pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_CI_policy;

   //XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(Start)
   //As per G.998.4 Amd 2, for ATTNDR methods 1 & 2, channel initialisation policy
   //should be zero and max rates should not limited.

   //XDSLRTFW-1522 (Start_End)
   if(gft_CalcAttndr == TRUE)
   {
      CIP = 0;
      l_ETR_max_kbps = 0x7ffffff;  // set to max (shifted by 4 bit during following 28x4 bit format conversion)
      l_ETR_min_kbps = 0x0000001;  // set to 1kbps as XDSLRTFW-2709 fix reduced ETR min by 1kbps
      l_net_max_kbps = 0x7ffffff;  // set to max (shifted by 4 bit during following 28x4 bit format conversion)
   }
   // XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR (End)

   // XDSLRTFW-2709 (Start)
   // net_max_28_4_kbps => netmax in [kbps] in Q.28.4 format
   // reduce netmax by 0.25kbps (as max error of our NDR calculation can be ~0.2kbps)
   // ETR_min_Qf28x4_kbps => ETRmin in [kbps] in Q.28.4 format
   // reduce ETR_min_Qf28x4_kbps by 1.0kbps (as max error of our ndr_eff_ calculation can be ~1.0kbps)
   //    1.0   kbps in Q28.4: 0x0010
   //    0.5   kbps in Q28.4: 0x0008
   //    0.25  kbps in Q28.4: 0x0004
   //    0.125 kbps in Q28.4: 0x0002

   l_ETR_min_Qf28x4_kbps = l_ETR_min_kbps<<4;
   l_ETR_min_Qf28x4_kbps = l_ETR_min_Qf28x4_kbps - 16;
   l_net_max_Qf28x4_kbps = l_net_max_kbps<<4;
   l_net_max_Qf28x4_kbps = l_net_max_Qf28x4_kbps - 4;
   // XDSLRTFW-2709 (End)

   {
      uint16 us_Temp;

      us_Temp = pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_INP_min_REIN;

      ia_rein_flag = ((us_Temp & 0x0080) != 0);
      INP_min_rein = us_Temp & 0x1F;
   }
   INP_min = pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_INP_min;

#ifndef STANDALONE_TEST

   s_D = gt_rx_config_v2.s_Dp[LP0];
   s_I = gt_rx_config_v2.s_Ip[LP0];

   //According to Josh, the interleaver buffer size used should be:
   //ILV_MEM = I*(D-M-1)/2 + I*EXT
   //where M = floor(D/I), EXT = 2 for TX and 1+q for RX
   //To be conservative, we set ILV_MEM = I*D/2 + I*EXT
   MULS16(ul_dilv_size, s_D, s_I);
   ul_dilv_size >>= 1;

   //Add I*EXT = I*2
   ul_dilv_size += (s_I<<1);

   // Compute the total DILV memory available for LP1 path by subtracting the memory used by the LP0
   // path

   // Compute the DILV memory available to serve as the retransmission queue
   // after leaving 1K memory(DS_RETX_LP1_PROCESSING) for LP1 path processing. Note that D=1 for LP1 path
   // hence, with max codeword size of 255, the max memory used can be 2.5*255 ~= 638 bytes

   s_MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX = gs_MemSize_DsReTx_MinDtus_ReqOverQtx; //XDSLRTFW-3189 (Start_End)

   //XDSLRTFW-2590 (Start)
   if(gft_Intra_DTU_Ilv_DS == TRUE)
   {
      //XDSLRTFW-3189 (Start)
      us_MaxDTUSizeDS = gus_MaxDTUSizeDS_iDTU;
      l_NE_limit = gul_HW_DILV_MEM_SIZE[LP0] - ul_dilv_size - (us_MaxDTUSizeDS << 1) - (s_MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX);
      //XDSLRTFW-3189 (End)
   }
   else
   {
      l_NE_limit = gul_HW_DILV_MEM_SIZE[LP0] - ul_dilv_size - DS_RETX_LP1_PROCESSING - (s_MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX);
   }
   //XDSLRTFW-2590 (End)

   //XDSLRTFW-1707_30a_RTX_DsUs (End)
   // O-PMS:
   // Field #8 "max_delay_octetDS,0" is a 3-byte field that specifies the maximum value of delay_octetDS,0
   // (defined in clause 6.2.8), specified in bytes as an unsigned integer.
   // Field #9 "max_delay_octetDS,1" is a 3-byte field that specifies the maximum value of delay_octetDS,1
   // (defined in clause 6.2.8), specified in bytes as an unsigned integer. If the value of this field is set to
   // the special value 0xFFFFFF, the Field #8 (max_delay_octetDS,0) specifies the maximum value of
   // (delay_octetDS,0 + delay_octetDS,1) and the VTU-R shall autonomously partition the number of
   // octets between both downstream latency paths. The value 0xFFFFFF is not allowed if the VTU
   // intends to use interleaver reconfiguration in the downstream direction.
   // Take the minimum of the near end and the far end limit
   if (gla_MaxInlvDelay[LP1] != 0xFFFFFF)
   {
      max_delay_octet = gla_MaxInlvDelay[LP1];
   }
   else
   {
      max_delay_octet = gla_MaxInlvDelay[LP0] - gl_delay_octet_LP0;
   }

   // Compute the memory available for LP1 path to serve as retransmission queue
   RTmemMax = MIN(l_NE_limit, (max_delay_octet >> 1));
#else
   RTmemMax = max_delay_octetDS1;
#endif

   //XDSLRTFW-1522 (Start_End)
   gul_RTmemMax = RTmemMax;

   // Universal ReTx Framing for Latency Path LP1 with ReTx
   // T1 is 0 for FramingType = 1, 2, or 3.
   // G1 is 0 for FramingType = 1, 2, or 3.
   // M1 is 1 for FramingType = 1, 2, or 3.
   // R1 are 0, 2, 4, 8, 10, 12, 14 or 16.
   // Sp may be a non-integer, and shall not exceed 64.
   // Q is any integer from 1 to 16 if the associated Recommendation is ITU-T G.992.3 or ITU-T G.992.5.
   //   Furthermore, valid configurations of Q shall be such that 0.5 <= Q*S1 <= 4 in L0 state.

   // H=Mp*(Bp+1)=Np-Rp;
   // Rp=4;  // Used for Error detection, i.e. 32bit CRC! No coding gain win.
   // Dp=1 without interleaving
   // 8x,12x,17a and 30a:
   //      0.5 <= Q*Sp <=4, DTU size in symbols
   // 35b:
   //      0.3 <= Q*Sp <=4, DTU size in symbols
   //
   // Q*(Bp+1)-2-V is number of TPS-TC bytes per DTU
   // V=0:15; // optional stuff bytes
   // modulo((Q*(Bp+1)-2-V),65)=0 & (Q*(Bp+1)-2-V)>0 has to be fulfilled for alignment
   // net data rate NDR[kbit/s] = fs*ul_Lp*(1-Rp/Np-(2+V)/Q/Np)) with fs=8*256/257 in profile 30a and fs=4*256/257 in all other profiles
   // throughput, eff. net data rate NDReff = NDR*(1-REINratio)*(1-SHINEratio)*(1-TRELLISratio); LossFactor depends on average distance of Trellis bursts and configured INP_min_rein

   // Inputs from VTU-O during Initialization
   // RTmemMax; max. number of octets for transmitter's RTX queue
   // INP_min; min. INP in number of destroyed DMT symbols due to noise impulse (SHINE/PEIN)
   // INP_min_rein; min. REIN INP in number of destroyed DMT symbols due to single REIN impulse
   // ia_rein_flag; flag=0 for 100-Hz-REIN and flag=1 for 120-Hz-REIN
   // SHINEratio; average loss ratio due to SHINE in multiple of 0.1 %
   // s_CO; d_CO; // half roundtrip (s symbols + d DTUs) of CO side
   // SpMinInvers; // 1/SpMin for latency path 1 connected with bearer channel 0
   // ifx_co_flag; // if IFX CO device is detected by CPE in HS CPE shall set this flag to one, else to 0
   // adsl2p_flag; // shall be set to 1 by CPE if mode select has been done for ADSL2 in HS and if PMS-TC C-MSG1 octet 2 most significant bit is one, else 0
   // l_ETR_min_kbps; // min. throughput, here called NDReff, in kbit/s
   // l_net_max_kbps; // max net data rate in kbit/s
   // l_ETR_max_kbps; // max. ETR in kbit/s with ETR = min(NDReff, ETR_max), only really relevant if CIP=1 then it means NDReff<=ETR_max
   // CIP; // channel optimization policy, 0 is optimization for throughput, 0 is default if not got in C-MSG1
   // delay_max; // max. excess delay in ms caused by retransmission
   // eftr_thresh; // threshold for throughput supervision in showtime, not relevant for framing parameter generation

   // Internal VTU-R Inputs; to be configurable at ATU-R side
   // s_CPE; d_CPE; // half roundtrip (s symbols + d DTUs) of CPE side

   if (CIP==1)
   {
      // Adjust the limits for the special case
      if ((l_ETR_max_kbps - l_ETR_min_kbps) < 8)
      {
         l_ETR_max_kbps = l_ETR_min_kbps+8;
      }
   }


   inp_calc=1; // 1 actual INP calculation included, 0 not included; default has to be 1 for the FW release

   //XDSLRTFW-1522 (Start_End)
   us_ActShineInp = 0;
   us_ActReinInp = 0;

   // Internal ATU-R Inputs; after SNR measurements
   // ul_LpAvailable; // number of bits which can be loaded under consideration of ReTx coding gain
   // ul_LpDelta; // evaluated ul_Lp range is from LpAvailable-ul_LpDelta to LpAvailable
   // ia_trellis and ReTxCodingGain shall be configurable for debug purpose; the max. trellis overhead part has been fixed to 10^-4 in table 9-2/G.998.4 and therefore these parameters are don't care now
   //XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(Start)

   //XDSLRTFW-1522 (Start_End)
   if ((gft_CalcAttndr == TRUE) &&  (guc_attndr_method == ATTNDR_METHOD_2))
   {
      INP_min = 0;
      INP_min_rein = 0;
   }
   //XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(End)


   //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (Start_End)
   //TRELLISratio = 13; // expressed in Q1.17

   if ((INP_min == 0) && (INP_min_rein == 0))
   {
      cc=0;   // config with no SHINE, no REIN
   }

   else if ((INP_min > 0) && (INP_min_rein == 0))
   {
      cc=1;   // config with SHINE only
   }

   else if ((INP_min > 0) && (INP_min_rein>0))
   {
      cc=2;   // config with SHINE and REIN
   }

   else if ((INP_min==0) && (INP_min_rein>0))
   {
      cc=3;   // config with REIN only
   }

   if (cc == 0)
   {
      inp_calc = 0;
   }

   // Rx Half-Roundtrip delay, i.e. byte [00ddssss]
   // s_CO; d_CO; // half roundtrip (s symbols + d DTUs) of CO side
   s_CPE = (pt_ReTXParams->uc_RMSG2_CpeRxHalfRoundTripDelays & 0xF);
   d_CPE = (pt_ReTXParams->uc_RMSG2_CpeRxHalfRoundTripDelays >> 4) & 0x3;

   s_CO = pt_ReTXParams->uc_OMSG1_DsHalfRoundTripInSyms;
   d_CO = pt_ReTXParams->uc_OMSG1_DsHalfRoundTripInDTUS;

   /* XDSLRTFW-2858 */
   /*  New proposal for downstream performance improvement in G.Vector mode: Reduce CPE-Rx-HRT-delay by 1-Symb.

   if ((SSdsOffset <= HRT_TX_S-1) & (SSdsOffset >= -HRT_RX_S+1))
      then execute framing generation with HRT_RX_S=HRT_RX_S-1;
   else
      execute framing generation with HRT_RX_S =  HRT_RX_S;
   end;
   */

   /* (SSdsOffset <= HRT_TX_S-1) & (SSdsOffset >= -HRT_RX_S+1) */
   if ((gc_VecUSSyncOffset <= s_CO-1) && (gc_VecUSSyncOffset >= -s_CPE+1) && (gft_DSVectoringEnabled == TRUE))
   {
      s_CPE = (pt_ReTXParams->uc_RMSG2_CpeRxHalfRoundTripDelays & 0xF) -1;
   }

   /* cmv approach/ fall-back */
   if (gs_CpeRxHalfRoundTripDelays_ForcedInFraming > 0)              //if (TESTArray[TEST_DS_RETX_HRT])
   {
      s_CPE = (gs_CpeRxHalfRoundTripDelays_ForcedInFraming & 0xF);      //s_CPE = TESTArray[TEST_DS_RETX_HRT];
   }
   /* XDSLRTFW-2858 */

   // In case of 30a profile
   if (gs_frame_rate_is_8khz)
   {
      fdmt = 8;

      // Roundtrip delay in symbols is double due to higher frame
      // rate in case of 30a profile
      s_CO =  s_CO << 1;
      s_CPE = s_CPE << 1; // DMT symbol time in ms for VDSL2 profile 30a

      //XDSLRTFW-1707_30a_RTX_DsUs  (Start)
      //In 30a mode DTU values to be taken as is
      //d_CO =  d_CO << 1;
      //d_CPE = d_CPE << 1;

      //Order of processing of Rx latency paths.
      //    000               1, 0, 2  (the default value)
      //    001               1, 2, 0
      //    010               0, 1, 2
      //    011               0, 2, 1
      //    100               2, 0, 1
      //    101               2, 1, 0
      //XDSLRTFW-1707_30a_RTX_DsUs  (End)
   }
   else
   {
      fdmt = 4;
   }
   gt_ReTXParams.uc_CpeRxHalfRoundTripDelays_UsedInFraming = s_CPE;     /* XDSLRTFW-2858 */

   //XDSLRTFW-1610 (START)
   // Convert to Q10.6 format
   // Note: Normally gt_FormFramingParamsInputs_v2.s_fs should be used , which
   //       considers the "m"-value, i.e. CE.
   // !!!In this formula the fix value m=5 is used!!
   s_fs = (fdmt * 256 * 64)/257;  // = (fdmt << 14)/257;


   //30a_DSRTX Debug
#ifdef ENABLE_RETX_US_DEBUG1
   gula_PalakDebug[1]= RTmemMax;
   gula_PalakDebug[2]= l_NE_limit;
   gusa_ReTxDebugBuf[0] = s_CPE;
   gusa_ReTxDebugBuf[1] = d_CPE;
   gusa_ReTxDebugBuf[2] = s_CO;
   gusa_ReTxDebugBuf[3] = d_CO;
#endif

   // REIN noise has a repetition rate of twice the AC power frequency (100 or 120 Hz).
   if (ia_rein_flag == 0)
   {
      // 50 Hz frequeny
      // Expressed in Q8.8 format
      //Trein = (20 << 7);   // 20 * 128 = 2560 REIN period in ms
      Trein = 2560;
   }
   else if (ia_rein_flag == 1)
   {
      // 60 Hz frequency
      // Expressed in Q8.8 format
      //Trein = (50 << 7) / 3;   // REIN period in ms
      Trein = 2133;   // (50 * 128)/3 = 6400/3 = 2133.33 REIN period in ms
   }

   s_Trein_fdmt = Trein * fdmt;
   l_Trein_fdmt = (int32)(s_Trein_fdmt << 8);

   // MinDataSymbolsRein = floor(Trein/Tdmt) - ceil(Trein/Tsync)
   //                    = floor(Trein * fdmt) - ceil((Trein * fdmt)/257)
   //MinDataSymbolsRein = Trein * fdmt - ceil16((int16)(Trein * fdmt), 257);      // min. integer number of DMT data symbols witin a REIN period
   MinDataSymbolsRein = (s_Trein_fdmt - ((s_Trein_fdmt + 256)/257));      // min. integer number of DMT data symbols witin a REIN period


   // MaxDataSymbolsRein = (Trein/Tdmt) - floor(Trein/Tsync)
   //                    = (Trein * fdmt) - floor((Trein * fdmt)/257)
   //                    = ((Trein * fdmt)*256)/257
   //MaxDataSymbolsRein = ceil32((Trein * fdmt) << 8, 257);            // average fractional number of DMT data symbols in REIN period

   MaxDataSymbolsRein = (l_Trein_fdmt + 256)/257;            // average fractional number of DMT data symbols in REIN period
   //XDSLRTFW-1610 (END)

   MinDataSymbolsDelaymax = ((pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_DelayMax * fdmt) << 8) / 257;   // min. number of DMT data symbols within delay_max // floor16 was missing in V7

   //(-floor(1/(INP_min_rein+1))+1)
   us_INP_min_rein_factor = (-(1/(INP_min_rein+1))+1);

//   if (CIP == 1)
//   {
//      // Assume worst case RTxOF of 0.25
//      // Lp max <= l_ETR_max_kbps * Nfecp/((Nfecp - Rp)*(1 - RtOH)* fs)
//      ul_temp1 = (l_ETR_max_kbps * 384) / (s_fs << 2);
//
//   }
//   else
//   {
//      // Lp cap due to max data rate cap l_net_max_kbps, 1.10 results from (67+4)/65
//      // 1.10 expressed in Q8.8 equals 281
//      // Lp max <= NRDp * Nfecp/((Nfecp - Rp)*fs)
//      ul_temp1 = (l_net_max_kbps * 281) / (s_fs << 2);
//
//   }
//   //XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(Start)
//   //XDSLRTFW-1522 (Start)
//   if (gft_CalcAttndr == FALSE)
//   {
//      if(ul_LpAvailable > ul_temp1)
//      {
//         ul_LpAvailable = ul_temp1;
//      }
//   }
   //XDSLRTFW-1522 (End)
   //XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(End)

   // Max DTU size equals 4 symbols, i.e. Q*Spmax <= 4.
   // Therefore is Spmax = 4 for min Q value of 1.
   // SpMax = MIN(32*Mp,64); Note: (32*Mp) is comming from ADSL2.
   // SpMax = MIN(Mp << 5,64);
   SpMax = 4;
   SpMaxLog2 = 2;
   Dp=1;
   Mp=1;                   // M1 is 1 for FramingType = 1, 2, or 3.
   Rp=4;
   uc_DS_ReTx_Max_D_CO_support=0;
   // HQV table varible initialisation
   {
      // XDSLRTFW-1617 (Start)
      // XDSLRTFW-2162 (Start - End)
      uca_hqv_table = guca_HQV;
      imax = HQV_NUM_ROW;

      if(gft_Intra_DTU_Ilv_DS == TRUE)
      {
         //Rp=16;
         Rp = guc_DS_ReTx_iDTU_R;
         uca_hqv_table = guca_HQV_IDILV;
         imax = HQV_IDILV_NUM_ROW;

         uc_DS_ReTx_Max_D_CO_support = (guc_DS_ReTx_Max_D_CO_support & 0x7f);
         //Use new special HQV table if CO supports "D -> only powers of 2"
         if (guc_DS_ReTx_Max_D_CO_support & 0x80)
         {
            uca_hqv_table = guca_HQV_IDILV_Pow2;
            imax = HQV_IDILV_POW2_NUM_ROW;
         }
      }
      // XDSLRTFW-1617 (End)

      // Limit the HQV table for 30a, 17a, 12x and 8x profiles.
      if (gt_ProfileAct.us_ProfileSelected & (CNFG_V2_PROFILE_17A_MASK|CNFG_V2_PROFILE_12xALL_MASK|CNFG_V2_PROFILE_8xALL_MASK))
      {
         // Note: XDSLRTFW-1816 (start_end) Changed HQV table Max Idx from 31 to 37 to have DS rate upto 150Mbps.
         //       Now it was changed from 37 to 47 to have rates upto 190Mbps. This is also needed for 35BLite.
         imax = MAX_HQV_IDX_DS_PROFILE_8_12_17_WITHOUT_IDTU;  //XDSLRTFW-3189 (Start_End)

         //XDSLRTFW-3020 (Start)
         //Zephyr MIPS is not sufficient to run Q=16 in a DTU when DS intra DTU interleaving is enabled.
         //Hence restricted the max entry of HQV table size to 29. i.e support only Q = 8.
         if (gft_Intra_DTU_Ilv_DS == TRUE)
         {
            imax = MAX_HQV_IDX_DS_PROFILE_8_12_17_WITH_IDTU;  //XDSLRTFW-3189 (Start_End)
         }
         //XDSLRTFW-3020 (End)
      }
      else if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK)
      {
         // XDSLRTFW-1707_30a_RTX_DsUs (Start_End)
         // For 30a profile, more combinations of H, Q, V possible.
         imax = MAX_HQV_IDX_DS_PROFILE_30a_WITHOUT_IDTU;      //XDSLRTFW-3189 (Start_End) // 26 to have rates upto 200Mbps
      } else if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
      {
         //XDSLRTFW-3322 (Start)
         imax = MAX_HQV_IDX_DS_PROFILE_35b_WITHOUT_IDTU;
         if (gft_Intra_DTU_Ilv_DS == TRUE)
         {
           imax = MAX_HQV_IDX_DS_PROFILE_35b_WITH_IDTU_R16;
           if (Rp == 8)
            imax = MAX_HQV_IDX_DS_PROFILE_35b_WITH_IDTU_R08;
           else if (Rp == 10)
              imax = MAX_HQV_IDX_DS_PROFILE_35b_WITH_IDTU_R10;
           else if (Rp == 12)
              imax = MAX_HQV_IDX_DS_PROFILE_35b_WITH_IDTU_R12;
           else if (Rp == 14)
              imax = MAX_HQV_IDX_DS_PROFILE_35b_WITH_IDTU_R14;

           //if (Rp>4 && Rp<16)   H_Q_V(59,:)=[240.    16.    3.    59.        3840.]; end;
           //if (Rp>4 && Rp<12)
           //H_Q_V(15,:)=[245.    4.    3.    15.        980.];
           //H_Q_V(30,:)=[244.    8.    0.    30.        1952.];
           //H_Q_V(60,:)=[244.    16.   2.    60.        3904.];
           //end;
           //if (Rp>4 && Rp<8)   H_Q_V(61,:)=[248.    16.    1.    61.        3968.]; end;
           //end;
           //H=H_Q_V(i,1); Q=H_Q_V(i,2); V=H_Q_V(i,3); R=Rp;
         if ((Rp > 4) && (Rp < 12))
         {
              idx = 15 * 3;
              uca_hqv_table[idx]     = 245; //Hp
              uca_hqv_table[idx + 1] = 4;   //Qp
              uca_hqv_table[idx + 2] = 3;   //Vp

              idx = 30 * 3;
              uca_hqv_table[idx]     = 244; //Hp
              uca_hqv_table[idx + 1] = 8;   //Qp
              uca_hqv_table[idx + 2] = 0;   //Vp

              idx = 60 * 3;
              uca_hqv_table[idx]     = 244; //Hp
              uca_hqv_table[idx + 1] = 16;   //Qp
              uca_hqv_table[idx + 2] = 2;   //Vp
         }

         if ((Rp > 4) && (Rp < 16))
         {
              idx = 59 * 3;
              uca_hqv_table[idx]     = 240; //Hp
              uca_hqv_table[idx + 1] = 16;   //Qp
              uca_hqv_table[idx + 2] = 3;   //Vp
         }

         //Note: We don't support R=16,
         //Supporting is done for R=8, 10, 12, 14 & 16 if 35b iDTU is enabled.

         }
         //XDSLRTFW-3322 (End)
      }

      // Debug possibility to limit or change the HQV table index.
      if (gs_HQV_MaxIdx !=0)
      {
         imax = gs_HQV_MaxIdx;
      }
      // Debug possibility to limit or change the HQV table index. (introduced during implementation of XDSLRTFW-4125)
      if (gs_HQV_MinIdx !=0)
      {
         imin = gs_HQV_MinIdx;
      }
   }

   //for i=1:length(H_Q_V(:,1))
   //H=H_Q_V(i,1); Q=H_Q_V(i,2); V=H_Q_V(i,3); R=Rp;
   //% LpMax1 = floor((min(63,floor(RTmemMax/(Q*H)))*Q*H*8-(d_CO+d_CPE+1)*Q*H*8)/(s_CO+s_CPE+1)*(1+R/H)); % Lp limited by memory/roundtrip
   //LpMax1 = floor((min(63,floor(RTmemMax/(Q*H)))*Q*H*8-(d_CO+d_CPE+1)*Q*H*8)*(H+R)/(H*(s_CO+s_CPE+1))); % Lp limited by memory/roundtrip
   //LpMax2 = floor(SpMinInvers*(H+R)*8); % Lp limited by SpMin
   //if delay_min>0   net_max=min(net_max,ceil(RTmemMax*8/(delay_min*1e-3)/1e3)); end; % cap by available memory for delay_min RX queue
   //% LpMax3 = floor((net_max+0.999)*(Q*H+Q*R)/fs/(Q*H-2-V)); % Lp limited by net_max configuration
   //LpMax3 = floor((net_max+0.999)*(Q*H+Q*R)/(fs*(Q*H-2-V))); % Lp limited by net_max configuration
   //LpMax4 = floor(8*Q*(H+R)/QSmin); % Lp limited by QSmin
   //%LpMax=min(LpAvailable,LpMax1,LpMax2,LpMax3,LpMax4);
   //
   //LpMax = 2^(30); %2^30 init with big number
   //LpMaxData = [LpAvailable, LpMax1, LpMax2, LpMax3, LpMax4];
   //
   //%LpMax=min(LpAvailable,LpMax1,LpMax2,LpMax3,LpMax4);
   //for k=1:length(LpMaxData)
   //    if LpMaxData(k) < LpMax
   //      LpMax = LpMaxData(k);
   //    end
   //end
   //
   //LpMin1 = ceil(Q*(H+R)*8/QSmax); % lower limit due to QSmax
   //%LpMin1 = ceil((H+R)*8/QSmax); % lower limit due to QSmax
   //LpMin2 = ceil(8*(H+R)/SpMax); % lower limit by SpMax
   //LpMin3 = ceil((ETR_min + fs*(Q*H-V-2)/(Q*H+Q*R)*(Q*8*(H+R))/floor(Trein/Tdmt)*(-floor((INP_min_rein+1)^(-1))+1))/(fs*(Q*H-V-2)/(Q*H+Q*R)*(1-10^(-4)-SHINEratio/1000) - fs*(Q*H-V-2)/(Q*H+Q*R)*INP_min_rein/floor(Trein/Tdmt)*(-floor((INP_min_rein+1)^(-1))+1))); % lower limit by ETR_min
   //
   //%LpMin=max(LpMin1,LpMin2,LpMin3);
   //LpMinData= [LpMin1,LpMin2,LpMin3];
   //LpMin = 2^(-30); %init with small number
   //%LpMin=max(LpMin1,LpMin2,LpMin3);
   //for k=1:length(LpMinData)
   //    if LpMinData(k) > LpMin
   //      LpMin = LpMinData(k);
   //    end
   //end
   //
   //ndr_eff_max = fs*LpMax*(Q*H-V-2)/(Q*H+Q*R) * (1 - (10^(-4)+SHINEratio/1000+(INP_min_rein+Q*8*(H+R)/LpMax)/floor(Trein/Tdmt)*(-floor((INP_min_rein+1)^(-1))+1))); % ETRu in kbit/s without flooring
   //H_Q_V(i,7)=LpMin;
   //H_Q_V(i,8)=LpMax;
   //H_Q_V(i,9)=ndr_eff_max;
   //end;

   {

      if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
         us_SQmin = SQMIN_35B_x100_IN_BITS;

      //FILE *wr_cfg;
      //wr_cfg = fopen("LpMin_LpMax_NDR_C_TestBench.txt","a");

      //for i=1:length(H_Q_V(:,1))
      for (i=imin; i < imax; i++)
      {

         //H=H_Q_V(i,1); Q=H_Q_V(i,2); V=H_Q_V(i,3); R=Rp;
         idx = i * 3;
         //XDSLRTFW-1617 (Start)
         Hp = uca_hqv_table[idx];                // Note: Out of the table the max Hp is acctual 251
         Qp = uca_hqv_table[idx + 1];            // Note: Out of the table the max Qp is acctual 18
         Vp = uca_hqv_table[idx + 2];            // Note: Out of the table the max Vp is acctual 14
         Np = Rp + Hp;                           // H = NFECp - Rp, with p = 1 -> NFECp = H + Rp, Np max value 255
         Np_Qp = Qp*Np;                          // Note: R=4 is fix, i.e. out of the table the max value is acctual 4114
         us_Qp_Hp = Qp * Hp;                     // DTU size without including "R"

         //Lp limited by (memory/roundtrip) with overhead due to "R".
         //% LpMax1 = floor((min(63,floor(RTmemMax/(Q*H)))*Q*H*8-(d_CO+d_CPE+1)*Q*H*8)/(s_CO+s_CPE+1)*(1+R/H)); % Lp limited by memory/roundtrip
         //LpMax1 = floor((min(63,floor(RTmemMax/(Q*H)))*Q*H*8-(d_CO+d_CPE+1)*Q*H*8)*(H+R)/(H*(s_CO+s_CPE+1))); % Lp limited by memory/roundtrip
         us_n_dtus = MIN(63, (RTmemMax/us_Qp_Hp)) - (d_CO+d_CPE+1);
         ul_LpMax1 = (((us_n_dtus * us_Qp_Hp) << 3)*Np)/(Hp*(s_CO+s_CPE+1));

         //Lp limitation by no of CW's per DMT symbol.
         //LpMax2 = floor(SpMinInvers*(H+R)*8); % Lp limited by SpMin
         ul_LpMax2 = ((Np * SpMinInvers) << 3);

         //Lp limited by net_max configuration including overhead due to "R, V, SID & TS (2 Bytes)"
         //% LpMax3 = floor((net_max+0.999)*(Q*H+Q*R)/fs/(Q*H-2-V)); % Lp limited by net_max configuration
         //LpMax3 = floor((net_max+0.999)*(Q*H+Q*R)/(fs*(Q*H-2-V))); % Lp limited by net_max configuration
         //Q10.6 s_fs
         //Q26.6 l_net_max_kbps

         //ul_LpMax3 = (((l_net_max_kbps * 1000 * Np_Qp) + (999 * Np_Qp)) << 6) / ((s_fs * (us_Qp_Hp - 2 - Vp))*1000); //s_fs of Den is in Q10.6 format, so convert Num also in Q26.6
         // ul_LpMax3 = ((l_net_max_kbps * 1000 * Np_Qp) + (999 * Np_Qp)) / (((s_fs * (us_Qp_Hp - 2 - Vp))*1000)>>6); //s_fs of Den is in Q10.6 format, so convert Num also in Q26.6
         //ul_LpMax3 = ((l_net_max_kbps * 1000 + 999 * Np_Qp)) / (((s_fs * (us_Qp_Hp - 2 - Vp))*1000)>>6); //s_fs of Den is in Q10.6 format, so convert Num also in Q26.6
         //ul_LpMax3 = (((l_net_max_kbps * 1000)  + 999) * Np_Qp)/1000;
         //LpMax3_dbg = ((net_max*1000) + 999)*(Q*H+Q*R);
         //LpMax3_dbg = LpMax3_dbg / ((fs*(Q*H-2-V))*1000);
         //ul_LpMax3 = (((l_net_max_kbps * 1000)  + 999) * Np_Qp);
         //ul_LpMax3 = ul_LpMax3 / ((s_fs*(us_Qp_Hp-2-Vp))*1000);
         //ul_LpMax3 = (((l_net_max_kbps * 1000)  + 999))/ (((s_fs*(us_Qp_Hp-2-Vp))*1000) >> 6);
         //ul_LpMax3 = ul_LpMax3 * Np_Qp;
         ul_LpMax3 = (((l_net_max_kbps * 1000)  + 999))/ 1000;
         ul_LpMax3 = (ul_LpMax3*Np_Qp)/(us_Qp_Hp-2-Vp);
         ul_LpMax3 = (ul_LpMax3 << 6) / s_fs;

         //LpMax4 = floor(8*Q*(H+R)/QSmin); % Lp limited by QSmin
         //Since us_SQmin is in bits with x100, so division of 100 is required. This is done to closely match with matlab computed ETRu
         ul_LpMax4 = (Np_Qp * us_SQmin)/100;

         ul_temp1 = ul_LpAvailable;

         //Need to enable this block once V3 based ReTx bit loading and ReTx framing is available
         //if (Rp > 4)
         //{
         //   //Get new LP with Coding Gain
         //   gul_dbg_ul_LpAvailable_In = ul_LpAvailable;
         //   ul_temp1 = GetNewLpWithCodingGain_iDTU(Rp, Qp, ul_LpAvailable);
         //   gul_dbg_ul_LpAvailable_New = ul_temp1;
         //}

         //%LpMax=min(LpAvailable,LpMax1,LpMax2,LpMax3,LpMax4);
         ul_LpMax = MIN(ul_temp1, ul_LpMax1);
         ul_LpMax = MIN(ul_LpMax, ul_LpMax2);
         ul_LpMax = MIN(ul_LpMax, ul_LpMax3);
         ul_LpMax = MIN(ul_LpMax, ul_LpMax4);

//#if 1
//         //For debug
//         if (i == (imax-1))
//         {
//           gul_dbg_ul_LpAvailable = ul_LpAvailable;
//           gul_dbg_ul_LpMax1 = ul_LpMax1;
//           gul_dbg_ul_LpMax2 = ul_LpMax2;
//           gul_dbg_ul_LpMax3 = ul_LpMax3;
//           gul_dbg_ul_LpMax4 = ul_LpMax4;
//           gul_dbg_LpMax = ul_LpMax;
//         }
//#endif

         //LpMin1 = ceil(Q*(H+R)*8/QSmax); % lower limit due to QSmax
         ul_LpMin1 = ((Np_Qp << 3) + us_SQmax - 1)/us_SQmax;

         //LpMin2 = ceil(8*(H+R)/SpMax); % lower limit by SpMax
         ul_LpMin2 = ((Np << 3) + SpMax - 1)/SpMax;

         //LpMin3 = ceil((ETR_min + fs*(Q*H-V-2)/(Q*H+Q*R)*(Q*8*(H+R))/floor(Trein/Tdmt)*(-floor((INP_min_rein+1)^(-1))+1))/(fs*(Q*H-V-2)/(Q*H+Q*R)*(1-10^(-4)-SHINEratio/1000) - fs*(Q*H-V-2)/(Q*H+Q*R)*INP_min_rein/floor(Trein/Tdmt)*(-floor((INP_min_rein+1)^(-1))+1))); % lower limit by ETR_min
         //LpMin3 = ceil((ETR_min + fs*(Q*H-V-2)/(Q*H+Q*R)*(Q*8*(H+R))/floor(Trein/Tdmt)*(-floor((INP_min_rein+1)^(-1))+1))/(fs*(Q*H-V-2)/(Q*H+Q*R)*(1-10^(-4)-SHINEratio/1000) - fs*(Q*H-V-2)/(Q*H+Q*R)*INP_min_rein/floor(Trein/Tdmt)*(-floor((INP_min_rein+1)^(-1))+1))); % lower limit by ETR_min
         //
         //Num_1 = (ETR_min + fs*(Q*H-V-2)/(Q*H+Q*R)*(Q*8*(H+R))/floor(Trein/Tdmt)*(-floor((INP_min_rein+1)^(-1))+1));
         //
         //Num_11 =  fs*(Q*H-V-2)/(Q*H+Q*R)
         ul_Num_11 = ((s_fs*(us_Qp_Hp - 2 - Vp)) << 2)/(Np_Qp); //s_fs in Q10.6 and "us_Num_11" expressed in Q24.8 format
         //Num_12 = (Q*8*(H+R));
         ul_Num_12 = (Np_Qp << 3);
         //Num_13 = floor(Trein/Tdmt);
         ul_Num_13 = s_Trein_fdmt; //ul_Num_13 is in Q24.8 format since s_Trein_fdmt is Q8.8

         //(-floor(1/(INP_min_rein+1))+1)
         //us_INP_min_rein_factor

         //Num_15 =  Num_11*Num_12*us_INP_min_rein_factor/(Num_13);
         ul_Num_15 = (ul_Num_11 * ul_Num_12 * us_INP_min_rein_factor)/ul_Num_13;  //ul_Num_15 is in Q32.0

         //Num_1 =  ETR_min + Num_15;
         ul_Num_1  = ((l_ETR_min_kbps + ul_Num_15) << 8);      //ul_Num_1 is Q24.8 format

         //Den_1 = (fs*(Q*H-V-2)/(Q*H+Q*R)*(1-10^(-4)-SHINEratio/1000) - fs*(Q*H-V-2)/(Q*H+Q*R)*INP_min_rein/floor(Trein/Tdmt)*(-floor((INP_min_rein+1)^(-1))+1));
         //Den_1 = (fs*(Q*H-V-2)/(Q*H+Q*R)*((1-10^(-4)-SHINEratio/1000) - INP_min_rein/floor(Trein/Tdmt)*(-floor((INP_min_rein+1)^(-1))+1)));
         //Den_1 = ul_Num_1 * ((9999- (SHINEratio * 10)) - INP_min_rein/floor(Trein/Tdmt)*(-floor((INP_min_rein+1)^(-1))+1)*10000);



         //%Den_11 = fs*(Q*H-V-2)/(Q*H+Q*R);
         //Den_11 = Num_11;
         //ul_Den_11 = (ul_Num_11); //ul_Num_11 is in Q24.8 format and ul_Den_11 in Q24.8

         //%Den_12 = (1-10^(-4)-SHINEratio/1000);
         //Den_12 = (0.9999 - SHINEratio/1000);
         //Den_12 = (999.9 - SHINEratio)/1000);
         //Den_12 = (999.9 - SHINEratio)/1000);
         //ul_Den_12 = (9999 -  (SHINEratio*10)) ; //Q32.0 x 10
         //ul_Den_12 = (ul_Den_11 * ul_Den_12)/10000; // ul_Den_12 expressed in Q32.0 format

         //%Den_13 = fs*(Q*H-V-2)/(Q*H+Q*R);
         //Den_13 = (fs*(Q*H-V-2) * INP_min_rein)/((Q*H+Q*R) * floor(Trein/Tdmt))
         //ul_Den_13 = (((s_fs*(us_Qp_Hp - 2 - Vp)) << 2) * INP_min_rein)/(Np_Qp * s_Trein_fdmt); //(((s_fs*(us_Qp_Hp - 2 - Vp)) << 2) is in Q24.8 format and s_Trein_fdmt is Q8.8 and ul_Den_13 is Q32.0

         //ul_Den_13 = (ul_Num_11 * 10000 * INP_min_rein * us_INP_min_rein_factor)/(Np_Qp * s_Trein_fdmt); //

         //%Den_15 = (-floor((INP_min_rein+1)^(-1))+1)
         //Den_15 = (-floor(1/(INP_min_rein+1))+1)
         //ul_Den_15 = us_INP_min_rein_factor;        //Q32.0

         ul_Den_1 = (9999 -  (SHINEratio*10)) - ((10000*INP_min_rein*us_INP_min_rein_factor)/(s_Trein_fdmt >> 8));

         //ul_LpMin3 = (ul_Num_1 * 10000)/(ul_Num_11*ul_Den_1);
         //LpMin3 = ceil(ul_Num_1/ul_Den_1);
         ul_Den_12 = (ul_Num_11*ul_Den_1);  //Q24.8
         ul_LpMin3 = ((ul_Num_1 * 10000) + ul_Den_12 - (1 << 8))/(ul_Den_12);

         //%LpMin=max(LpMin1,LpMin2,LpMin3);
         ul_LpMin = MAX(ul_LpMin1, ul_LpMin2);
         ul_LpMin = MAX(ul_LpMin, ul_LpMin3);    //ul_LpMin is in Q32.0

         //ndr_eff_max = fs*LpMax*(Q*H-V-2)/(Q*H+Q*R) * (1 - (10^(-4)+SHINEratio/1000+(INP_min_rein+Q*8*(H+R)/LpMax)/floor(Trein/Tdmt)*(-floor((INP_min_rein+1)^(-1))+1))); % ETRu in kbit/s without flooring

         ul_ndr_eff_max_1 = (((s_fs*ul_LpMax) >> 6) * (us_Qp_Hp - 2 - Vp))/(Np_Qp); //s_fs in Q10.6 and "ul_ndr_eff_max_1" expressed in Q32.0 format

         //REIN overhead
         //(INP_min_rein+Q*8*(H+R)/LpMax)/floor(Trein/Tdmt);
         ul_ReinOH_IM = ul_ndr_eff_max_1/(s_Trein_fdmt>>8);
         ul_ReinOH = (ul_ReinOH_IM*ul_LpMax*INP_min_rein) + (Np_Qp*8*ul_ReinOH_IM); ///(ul_LpMax*(Trein/fdmt));
         ul_ReinOH = ul_ReinOH /(ul_LpMax); //Q32.0 in Kbps

         ul_ReinOH = ul_ReinOH * us_INP_min_rein_factor;   //(-floor((INP_min_rein+1)^(-1))+1), //Q32.0 in Kbps

         //(10^(-4)+SHINEratio/1000
         //SHINE overhead
         ul_ShineOH = ul_ndr_eff_max_1 + (ul_ndr_eff_max_1*SHINEratio*10);
         ul_ShineOH = ul_ShineOH/10000;  //Q32.0 in Kbps

         l_ndr_eff_max = ul_ndr_eff_max_1;
         l_ndr_eff_max -= (ul_ReinOH + ul_ShineOH);  //Q32.0 in Kbps

         gula_LpMin[i] = ul_LpMin;         //MinLp in Bits
         gula_LpMax[i] = ul_LpMax;         //MaxLp in bits


         //Memory optimization
         gt_HQV_ETRu[i].l_ndr_eff = l_ndr_eff_max;
         gt_HQV_ETRu[i].ul_ndr_idx = i;

         //debug print
         //fprintf(wr_cfg,"%10d\n %10d\n %10d\n", ul_LpMin, ul_LpMax, l_ndr_eff_max);

      } //(i=0; i < imax; i++)

   //debug print
     //fclose(wr_cfg);
   }

   //for i=1:length(H_Q_V(:,1))
   // H_Q_V(i,7)=max(H_Q_V(i,7),H_Q_V(i,8)-(LpDelta-1));
   //end;
   for (i = 0; i < imax; i++)
   {
      gula_LpMin[i] = MAX((int32)gula_LpMin[i], (int32)(gula_LpMax[i] - (LP_DELTA-1)));
   }

   Sort_HQV_Table(imax);

   // Bit defintion of DREG registers:
   // 0x7DC5 (DREG_MISCRAM5_ADDR)
   //  Bit 15 - Bit 0       --> US PPE codeword buffer
   //  Bit 31 - Bit 16      --> DS PPE codeword buffer
   ul_addr = DREG_MISCRAM5_ADDR;
   ReadPpeReg(ul_addr, &ul_data);
   if (ul_data == 0)
   {
      us_PPE_INPUT_MAX = PPE_INPUT_MAX_DEFAULT;
   }
   else
   {
      us_PPE_INPUT_MAX = (ul_data >> 16);
   }

   //XDSLRTFW-2942 (Start)
   if (gs_frame_rate_is_8khz == 1)
   {
      //30a profile
      us_PPE_INPUT_MAX = (us_PPE_INPUT_MAX > PPE_INPUT_MAX_8KHZ)? PPE_INPUT_MAX_8KHZ : us_PPE_INPUT_MAX;
   }
   else
   {
      //35/17/12/8 profiles
      us_PPE_INPUT_MAX = (us_PPE_INPUT_MAX > PPE_INPUT_MAX_4KHZ)? PPE_INPUT_MAX_4KHZ : us_PPE_INPUT_MAX;
   }
   gus_PPE_INPUT_MAX = us_PPE_INPUT_MAX;
   //XDSLRTFW-2942 (End)

   RTmem=0;
   Roundtrip=0;
   l_max_ndr_eff_kbps = 0;
   l_max_ndr_Q28x4_kbps = 0;                          //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (Start_End)
   NRET = 0;

   //XDSLRTFW-634 : BUG_DS_ALL_ALL_ReTxThroughput (Start)
   us_platform = (gus_fe_G994VendorSpecific >> 12) & 0x000F;
   //XDSLRTFW-634 : BUG_DS_ALL_ALL_ReTxThroughput (End)

   //XDSLRTFW-3562_DS_SRA_NOT_TRIGGERED_AT_150m_START
   //In order to perform ReTx framing faster, HQV table is sorted
   //interms of ETRu (Effective Throughput Rate) in descending order.
   //Look for start index in sorted structure "gt_HQV_ETRu" where
   //LpAvailable (ReTx framing Input) match with the LpMax.
   //This change is done as a workaround to trigger DS SRA.
   //Without this workaround DS SRA is not working at 150m Loop
   //due to Lp output of ReTx framer is not converging with ReTx framer input
   //LpAvailable.
   //Note: Present DS SRA algorithm will trigger the DS SRA if LpAvailable
   //(ReTx Framer input) match with the Lp (ReTx framer output).
   //Root Cause: ReTx framer gives Lp as 47577 for the
   //LpAvailable range: 48245 to 47578
   //Ran the simulation with the workaround for the LpAvailable Range: 50000 to 40000
   //Lp is being converge with LpAvailable.
   for (i = 0; i < imax; i++)
   {
      if (ul_LpAvailable == gula_LpMax[gt_HQV_ETRu[i].ul_ndr_idx]) //LpMax;
        break;
   }

   if (i < imax)
      s_StartIndex = i;
   else
      s_StartIndex = 0;
   //XDSLRTFW-3562_DS_SRA_NOT_TRIGGERED_AT_150m_END

   for (i = s_StartIndex; i < imax; i++)
   {

   uint16 us_Lp_idx = 0;

      //l_ndr_eff_opt is Q28.4 format
      if (l_ndr_eff_opt > (gt_HQV_ETRu[i].l_ndr_eff << 4))
      {
        break;
      }
      //Use sorted index to get the H, Q, V values
      us_Lp_idx = gt_HQV_ETRu[i].ul_ndr_idx;

      idx =  us_Lp_idx * 3;


      //XDSLRTFW-1617 (Start)
      Hp = uca_hqv_table[idx];                // Note: Out of the table the max Hp is acctual 251
      Np = Rp + Hp;                           // H = NFECp - Rp, with p = 1 -> NFECp = H + Rp, Np max value 255
      Qp = uca_hqv_table[idx + 1];            // Note: Out of the table the max Qp is acctual 18
      Vp = uca_hqv_table[idx + 2];           // Note: Out of the table the max Vp is acctual 14
      //XDSLRTFW-1617 (End)

      Np_Qp = Qp*Np;                          // Note: R=4 is fix, i.e. out of the table the max value is acctual 4114
      //XDSLRTFW-2162 (Start)
      us_Qp_Hp = Qp * Hp;                     // DTU size without including "R"

      if(gft_Intra_DTU_Ilv_DS == TRUE)
      {
         if(Qp > uc_DS_ReTx_Max_D_CO_support)
         {
            continue;
         }

         if((!(((Qp ==1) && (gs_RxState == R_O_SHOWTIME_RX)) || ((Qp & 1) == 0))) && (guc_DS_ReTx_Max_D_CO_support & 0x80))
         {
            continue;
         }
      }

      if (gula_LpMin[us_Lp_idx] > gula_LpMax[us_Lp_idx])
         continue;

      ul_LpmaxLimit = gula_LpMax[us_Lp_idx];
      ul_LpminLimit = gula_LpMin[us_Lp_idx];

      //XDSLRTFW-1063: SRAds_Support_with_DS_ReTx (START)
      if(gs_RxState == R_O_SHOWTIME_RX) // Showtime Code
      {
         ul_LpminLimit = ul_LpmaxLimit - 100;
      }

      //XDSLRTFW-1063: SRAds_Support_with_DS_ReTx (END)
      for (ul_Lp = ul_LpmaxLimit; ul_Lp >= ul_LpminLimit; ul_Lp--)
      {



/////////////check the requirement of the code delow - start /////////////////

//#ifdef FORCE_RETX_FRAMING
//         //This code is disabled by default, could be enabled while testing ReTx specific test cases. This is done to avoid consuming more symbols
//         //during training.
//         if (TESTArray[TEST_Control4] & TEST_Control4_Ena_DSReTxForcedFraming_Bit5_Mask)
//         {
//            //Forced framing to force the Qp for intra dtu interleaving to test the corner case test cases
//            if (Qp != gt_ReTxForcedFraming.s_Qp)
//               continue;
//
//            //Forced framing to force the Np for intra dtu interleaving to test the corner case test cases
//            if (Np != gt_ReTxForcedFraming.s_Np)
//               continue;
//         }
//#endif

//XDSLRTFW-2162 (End)
/////////////check the requirement of the code below - End /////////////////

         // Dtu size in symbols (expressed in Q8.8 format)
         // Dtu size = S*Q = (8*N/L)*Q
         // Note: Byte to Bit conversion: 3
         //       Q8.8: 8
         //DtuSize = ((Qp * Np) << 11)/Lp;
         DtuSize = ((Np_Qp) << (3+8))/ul_Lp;

         //Limit min 'DtuSize in symbols' to 0.55
         //if (DtuSize < 141) {
         //   continue;
         //}

         //DtuSize replacement is required and verified
         //XDSLRTFW-1610 (START_END)
         // Roundtrip delay expressed in DTUs
         //RtInDTUs = ceil16((int16)((s_CO + s_CPE + 1) << 8), DtuSize);
         //RtInDTUs = (((s_CO + s_CPE + 1) << 8) + (DtuSize - 1))/DtuSize;
         //DtuSize is replaced with (8*N/L)*Q
         RtInDTUs = (((s_CO + s_CPE + 1) * ul_Lp) + ((Np_Qp << 3) - 1))/(Np_Qp << 3);

         RtInDTUs += (d_CO + d_CPE + 1);

         // Minimum value of Qtx governed by the roundtrip delay in DTUs
         Qtxmin = RtInDTUs;

         // Max value if Qtx governed by the retransmission queue memory available
         // Assume the storage of R bytes in the queue for the Rev2 CO
         // The receive queue should be atleast greater than the Qtx
         //Scilab Formula
         //Qtxmax=min(63,floor(RTmemMax/(Qp*(Np-Rp))));

         //XDSLRTFW-634 : BUG_DS_ALL_ALL_ReTxThroughput (Start)
         //Default for all
         // XDSLRTFW-1329 BugFix_USDS_VDSL2_ALL_UsDsReTxMemCorruptHighDsUsRate (Start_End)
         // XDSLRTFW-1363 DSReTx_DS_Rate_Degration_by_10%
         //If Qtxmax is limited by -3, we see DS data rate degradation of 10%. So this change is removed,
         //Qtxmax = MIN(63, ((RTmemMax/(Qp * (Np-Rp)))- DSRETX_MIN_DTUs_REQOVERQTX) ); //-3 here because we add qtx+3 for qrx
         Qtxmax = MIN(63, ((RTmemMax / (Qp * Hp))));                                   // Hp = (Np-Rp)
         if( (gul_fe_G994VendorID == IFX_VENDOR_ID) && (us_platform < AVINAX_PLATFORM) )
         {
            //XDSLRTFW-1417 (Start_End)
            //Qtxmax = MIN(63, ((RTmemMax/(Qp * Np)) - 3));
            Qtxmax = MIN(63, ((RTmemMax/(Np_Qp)) - 3));
         }
         //XDSLRTFW-634 : BUG_DS_ALL_ALL_ReTxThroughput (End)

         if (INP_min_rein > 0)
         {

            //Verified with and without Dtusize changes here, behaviour looks the same for the test cases verified.
            //completeness of the code changes incorpoprated Dtusize change as well here.
            //XDSLRTFW-1610 (START_END)
            // Nrtx = ceil(INP_min_rein/DtuSize) + 1
            //Nrtx = ceil16((int16)(INP_min_rein << 8), DtuSize) + 1; // number of corrupt DTUs due to single REIN pulse
            Nrtx = (((INP_min_rein*ul_Lp) + (Np_Qp << 3) - 1)/ (Np_Qp << 3)) + 1; // number of corrupt DTUs due to single REIN pulse

            // Qtx should be smaller than Rein impulse inter-arrival time
            // to allow successful retransmissions
            //Qtxmax = MIN(Qtxmax, (MinDataSymbolsRein/DtuSize) - Nrtx);
            Qtxmax = MIN(Qtxmax, ((MinDataSymbolsRein>>8)*ul_Lp)/(Np_Qp<<3) - Nrtx);

         }

         //Qtxmax = 19;

         //Qtxmin
         //Qtxmax
         if (Qtxmin>Qtxmax)
         {
            continue;
         }


         Qtx = Qtxmin; // RTX queue of transmitter in DTUs, assumed by receiver for starting INP calculation

         NRET = 0;

         if (inp_calc == 1)
         {
            INP=0;

            /////////////////////////////////////////////
            // Config with SHINE only OR REIN only
            /////////////////////////////////////////////
            if ((cc==1) || (cc == 3))
            {
               if (cc==1)
               {
                  // Shine noise case
                  s_Target_INP = INP_min;
               }
               else if (cc == 3)
               {
                  // REIN noise case
                  s_Target_INP = INP_min_rein;
               }

               // Calculate INP and increment Qtx so as to meet the desired INP
               // Exit if maximum allowed Qtx value reached
               while ((Qtx <= Qtxmax) && (INP < s_Target_INP))
               {
                  //DtuSize replacement is required and verified
                  NRET = (MinDataSymbolsDelaymax * ul_Lp) / ((Qtx * Np_Qp) << 3); // max number of retransmissions

                  //DtuSize replacement is required and verified
                  INP = ((Np_Qp*((NRET * Qtx) - 1)) << 3)/ul_Lp;

                  // Increment Qtx value to meet the desired INP
                  if (INP < s_Target_INP)
                  {
                     Qtx = Qtx+1;
                  }

               } // end of while loop

               if (INP < s_Target_INP)
               {
                  continue;
               }

            } // end of cc==1

            /////////////////////////////////////////////
            // Config with SHINE and REIN
            /////////////////////////////////////////////

            else if (cc==2)
            {
               NretQtxFound=0;

               while ((Qtx <= Qtxmax) && (NretQtxFound == 0))
               {
                  //DtuSize replacement is required and verified
                  // Nret * Qtx <= (MinDataSymbolsDelaymax/ Dtu_size)
                  //NRETmax = (MinDataSymbolsDelaymax << 8)/ (Qtx * DtuSize); // max number of retransmissions
                  NRETmax = (MinDataSymbolsDelaymax * ul_Lp)/ ((Qtx * Np_Qp) << 3); // max number of retransmissions

                  //XDSLRTFW-1610 (START_END)
                  // Nret * Qtx >= ((INP_min/DtuSize) + 1)
                  //s_temp = ceil16((int16)(INP_min << 8), DtuSize) + 1;
                  //s_temp = (((INP_min << 8) + (DtuSize - 1))/ DtuSize) + 1;
                  s_temp = (((INP_min*ul_Lp) + (Np_Qp << 3) - 1)/ (Np_Qp << 3)) + 1;

                  //XDSLRTFW-1610 (START_END)
                  //NRETmin = ceil16(s_temp, Qtx) + 1;
                  NRETmin = ((s_temp + Qtx - 1)/Qtx) + 1;

                  NRET = NRETmin;

                  ////////////////////////////////////////////////////////////////////////////////////////////
                  // To ensure that a retransmitted DTU is not hit by the next impulse coming IAT_min seconds
                  // after the first impulse, we have the following constraint
                  //
                  // (Nret*Qtx + Nrtx) * DtuSize <= k * Trein
                  //
                  // (Nret*Qtx - 1) * DtuSize >= (k-1)Trein + INP_min_rein
                  //
                  ////////////////////////////////////////////////////////////////////////////////////////////

                  while ((NRET <= NRETmax) && (NRET >= NRETmin))
                  {
                     //DtuSize replacement is required and verified
                     // Nret*Qtx + Nrtx <= k * Trein
                     //A = ((NRET * Qtx) + Nrtx) * DtuSize;
                     //A = (((NRET * Qtx) + Nrtx) * (Np_Qp << 3))/ul_Lp;
                     //A=ceil((NRET*Qtx+Nrtx)*DtuSize);
                     A = ((((NRET * Qtx) + Nrtx) * (Np_Qp << 3)) + ul_Lp - 1)/ul_Lp;
                     A <<= 8;  //Q8.8

                     //XDSLRTFW-1610 (START_END)
                     // Use the smaller value for Trein in denominator for a conservative Kmin
                     //k_min = ceil16(A, MinDataSymbolsRein);
                     k_min = (A + MinDataSymbolsRein - 1) / MinDataSymbolsRein;

                     //DtuSize replacement is required and verified
                     // (k-1)Trein <= (Nret*Qtx - 1)*DtuSize - INP_min_rein
                     //A = ((NRET * Qtx) - 1) * DtuSize - (INP_min_rein << 8);
                     A = (((NRET * Qtx) - 1) * (Np_Qp << 3) - (INP_min_rein * ul_Lp))/ul_Lp;
                     A <<= 8; //Q8.8

                     // Use the larger value for Trein in denominator for a conservative Kmax
                     k_max = (A / MaxDataSymbolsRein) + 1;

                     if (k_min <= k_max)
                     {
                        // Done with the search, break
                        NretQtxFound = 1;
                        break;
                     }

                     NRET = NRET+1;

                  } // end of NRET loop

                  // Done with the search, break
                  if (NretQtxFound)
                  {
                     break;
                  }

                  Qtx = Qtx+1;

               }    // end of Qtx loop

               // No feasible solution, continue with next iteration
               if (NretQtxFound==0)
               {
                  continue;
               }

            } // end of cc==2

         } // end of inp_calc==1

         //ndr_eff_=floor(fs*Lp*(Qp*Hp-Vp-2)/(Qp*Hp+Qp*Rp) * (1 - (10^(-4)+SHINEratio/1000+(INP_min_rein+Qp*8*(Hp+Rp)/Lp)/floor(Trein/Tdmt)*(-floor((INP_min_rein+1)^(-1))+1)))); // in bit/s
         ul_ndr_eff_max_1 = (((s_fs*ul_Lp) >> 6) * (us_Qp_Hp - 2 - Vp))/(Np_Qp); //s_fs in Q10.6 and "ul_ndr_eff_max_1" expressed in Q32.0 format
         ndr_ = (ul_ndr_eff_max_1 << 4);          //Q28.4 format

         //REIN overhead
         //(INP_min_rein+Q*8*(H+R)/Lp)/floor(Trein/Tdmt);
         ul_ReinOH_IM = ul_ndr_eff_max_1/(s_Trein_fdmt>>8);
         ul_ReinOH = (ul_ReinOH_IM*ul_Lp*INP_min_rein) + (Np_Qp*8*ul_ReinOH_IM); ///(ul_Lp*(Trein/fdmt));
         ul_ReinOH = ul_ReinOH /(ul_Lp); //Q32.0 in Kbps

         ul_ReinOH = ul_ReinOH * us_INP_min_rein_factor;   //(-floor((INP_min_rein+1)^(-1))+1), //Q32.0 in Kbps

         //(10^(-4)+SHINEratio/1000
         //SHINE overhead
         ul_ShineOH = ul_ndr_eff_max_1 + (ul_ndr_eff_max_1*SHINEratio*10);
         ul_ShineOH = ul_ShineOH/10000;  //Q32.0 in Kbps

         ndr_eff_ = ul_ndr_eff_max_1 - ul_ReinOH - ul_ShineOH;  //Q32.0 in Kbps
         ndr_eff_ = (ndr_eff_ << 4); ////Q28.4 in Kbps

         // Save the max effective net data rate option
         if ((ndr_eff_ > l_max_ndr_eff_kbps) || (ndr_eff_ == l_max_ndr_eff_kbps) && (ul_Lp < ul_L1_opt))
         {
            // Make sure that is satisfies the rate requirements
            //XDSLRTFW-1862: (Start)
            //Relaxing the check for ETR_Min as our fixed point computation of ETR_Min (ndr_eff_) is
            //lower compared to the floating point computation corresponding to the same framing parameters.
            //XDSLRTFW-1862: (End)


            /*
            |ndr_ |l_net_max_Qf28x4_kbps  |ul_temp1   |ndr_eff_   |l_ETR_min_Qf28x4_kbps  |s_fs |Lp      |Hp      |Np      |Qp      |Vp      |RTXOH   |ndr_fraction_ |
            +-------+-----------------------+-----------+-----------+-----------------------+-------+-------+-------+-------+-------+-------+-------+--------------+
            |403447  |403452              |404089     |399344     |399344              |255  |6446 |236  |240  |8    |1    |1323 |4103          |

             */
            /* XDSLRTFW-2751 & XDSLRTFW-1862*/

//            //NDR=floor(fs*L1*(Q*H-2-V)/(Q*N1));
//            ul_temp1 = (uint32)(s_fs * ul_Lp) / Np ; //XDSLRTFW-1707_30a_RTX_DsUs  (Start_end)
//            /* XDSLRTFW-2709 */
//            ul_temp1 = ul_temp1 + (ul_temp1>>16);
//            /* XDSLRTFW-2709 */
//            ul_temp1 = (ul_temp1*Hp) - (ul_temp1*(2+Vp))/Qp;
//            ndr_ = (ul_temp1 >> 2);          // Q28.4 format

            if ((ndr_ <= l_net_max_Qf28x4_kbps) && (ndr_eff_>= l_ETR_min_Qf28x4_kbps))
            {

               // Ensure that the l_ETR_max_kbps and l_ETR_min_kbps requirements are also met
               // in case of CIP = 1
               if ((CIP==1) && (ndr_eff_ > (l_ETR_max_kbps << 4)))
               {
                  continue;
               }

               l_max_ndr_eff_kbps = ndr_eff_;
               //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (Start_End)
               l_max_ndr_Q28x4_kbps = ndr_;
               // Indicate valid solution found
               ft_retVal = TRUE;

               // Save the basic framing parameters
               ul_L1_opt = ul_Lp;
               s_R1_opt = Rp;
               s_N1_opt = Np;
               s_D1_opt = Dp;
               s_M1_opt = Mp;
               l_ndr_eff_opt = ndr_eff_;
               s_Q_opt = Qp;
               s_V_opt = Vp;
               s_Qtx_opt = Qtx;
               //XDSLRTFW-1617 (Start)
               //XDSLRTFW-2162 (Start - End)
               if(gft_Intra_DTU_Ilv_DS == TRUE)
               {
                  s_D1_opt = Qp;
                  // XDSLRTFW-4125 No connect in VDSL17a IDTU fix rate case with IDTU
                  // Avoid the D value (guc_ReTx_DS_D) for R-PMS message being overwritten during
                  // ATTNDR calculation. Otherwise reported D and internally used D are not equal anymore
                  // furthermore D and Q can become unequal which is not allowed for D>1 in IDTU cases
                  // and lead to no-connects due to rejection by CO
                  if(gft_CalcAttndr == FALSE)
                  {
                     guc_ReTx_DS_D = Qp;
                  }
               }
               //XDSLRTFW-1617 (End)

               // Store HQV table index for debug purpose!
               if(gft_CalcAttndr == TRUE)
               {
                  gt_ReTxDebug.s_DTUSizeInSymbols[1] = DtuSize;
                  gt_ReTxDebug.s_HQV_MaxIdx[1] = i;
               }
               else
               {
                  gt_ReTxDebug.s_DTUSizeInSymbols[0] = DtuSize;
                  gt_ReTxDebug.s_HQV_MaxIdx[0] = i;
               }
            }
         }
         //XDSLRTFW-1610 (START)
         if (ft_retVal== TRUE)
         {
            break;
         }
         //XDSLRTFW-1610 (END)
      }  // for (ul_Lp = ul_LpminLimit; ul_Lp <= ul_LpmaxLimit; ul_Lp++)

   } // end of i loop


   if(ft_retVal)
   {
//XDSLRTFW-2162 (Start - End)
      //gft_Params_change = FALSE;
      //XDSLRTFW-1522 (Start)
      if (gft_CalcAttndr == FALSE)
      {
         if(gs_RxState != R_O_SHOWTIME_RX) // Training
         {
            //XDSLRTFW-409: BugFix_DS_VDSL2_ALL_ETR_Max_Ignored_By_FW (Start)
            // SE has clarified that this framer algo optimizes ETRu towards NDR_max
            // when CIPolicy = 0. CIPolicy = 1 is reserved by G.998.4 spec. Also,
            // ETR = min(ETRu,l_ETR_max_kbps) sec 11.2.1 of G.998.4 spec

            // shift down 4 to get rid of 28.4
            gt_ReTXStats.ul_ReTX_ReceiverETR = MIN((l_max_ndr_eff_kbps >> 4), l_ETR_max_kbps);
            //XDSLRTFW-409: BugFix_DS_VDSL2_ALL_ETR_Max_Ignored_By_FW (End)

            //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (Start_End)
            gt_ReTXStats.ul_ReTX_NDR = l_max_ndr_Q28x4_kbps; //Q28.4

            //XDSLRTFW-1548 (Start)
            //XDSLRTFW-1227: BugFix_DS_VDSL2_ALL_ReTX_Delay (Start)
            //delay_act_RTX = round(Tdtu*Tdmt)
            //Tdtu = Q*8*NFEC/LSYMB,
            // Note: Byte to Bit conversion: 3
            //       Q8.8: 8
            //Tdmt = 0.25 if VDSL2 profile 8/12/17, Tdmt = 0.125 if VDSL2 profile 30, Tdmt = 0.25*68/69 if ADSL2( + )
            //Report Delay in 0.01 milli seconds granularity to the near-end
            ul_tmp = ((s_Q_opt * s_N1_opt) << (3 + 8 + 6))/ul_L1_opt;
            gt_ReTXStats.us_ReTX_ReceiverActualDelay = ((((ul_tmp/fdmt) *100) +(1 << 13))>>14); //Resolution: 1/100 msec
            //XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR (Start_End)
            //XDSLRTFW-1227: BugFix_DS_VDSL2_ALL_ReTX_Delay (End)
            //XDSLRTFW-1548 (End)

            //XDSLRTFW-744 Enh_All_VDSL2_All_IntlvDelayIn1By100ms (Start_End)
            //Report Delay in 0.01 milli seconds granularity to the near-end
            //        gt_ReTXStats.us_ReTX_ReceiverActualDelay *= 100;


            // Save the basic framing parameters for LP1 path
            pt_Output->s_Rp[s_path] = s_R1_opt;
            pt_Output->s_Mp[s_path] = s_M1_opt;
            pt_Output->s_Dp[s_path] = s_D1_opt;
            pt_Output->ul_Lp[s_path] = ul_L1_opt;
            pt_Output->sa_Bpn[s_path][BC0] = (s_N1_opt - s_R1_opt - 1);

            // Assume q = 1
            pt_Output->s_Ip[s_path] = s_N1_opt;
            pt_Output->s_Nfecp[s_path] = s_N1_opt;
         }
         //XDSLRTFW-1063: SRAds_Support_with_DS_ReTx (START)
         else //SHOWTIME
         {
            gt_ReTxShowtimeParams.ul_ReTX_ReceiverETR = MIN((l_max_ndr_eff_kbps >> 4), l_ETR_max_kbps);
            // Save the basic framing parameters for LP1 path
            gt_ReTxShowtimeParams.s_Reconfig_Rp = s_R1_opt;
            gt_ReTxShowtimeParams.s_Reconfig_Mp = s_M1_opt;
            pt_Output->s_Reconfig_Dp[s_path] = s_D1_opt;
            pt_Output->ul_Reconfig_Lp[s_path] = ul_L1_opt;
            pt_Output->sa_Reconfig_Bpn[s_path][BC0] = (s_N1_opt - s_R1_opt - 1);

            // Assume q = 1
            gt_ReTxShowtimeParams.s_Reconfig_Ip = s_N1_opt;
////XDSLRTFW-2162 (Start)
//            if(s_N1_opt != pt_Output->s_Nfecp[1])
//            {
//               gft_Params_change = TRUE;
//            }
////XDSLRTFW-2162 (End)
            gt_ReTxShowtimeParams.s_Reconfig_Nfecp = s_N1_opt;
         }
         //XDSLRTFW-1063: SRAds_Support_with_DS_ReTx (END)
         pt_Output->s_Tp[s_path] = 1;
         pt_Output->s_Gp[s_path] = 1;
         pt_Output->s_Fp[s_path] = 1;
         //XDSLRTFW-3402 (START)
         //Estimte padding bytes required to align 32bit word boundaries.
         ul_DtuPayloadSize = (s_Q_opt*(s_N1_opt-s_R1_opt) - (s_V_opt + 2));
         ul_PaddingBytes = ((4 - (ul_DtuPayloadSize & 3)) & 3);

         //XDSLRTFW-3493(Start)
         //CapableQrx = (l_NE_limit + s_MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX)/(pt_ReTXParams->ul_DtuPayloadSize + pt_ReTXParams->l_NumPaddingBytes + BYTES_FOR_SID_TS_DTU_STATUS);
         CapableQrx = (l_NE_limit + s_MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX)/(ul_DtuPayloadSize + ul_PaddingBytes + BYTES_FOR_SID_TS_DTU_STATUS);
         //XDSLRTFW-3493(End)

         //XDSLRTFW-1323: BugFix_DS_VDSL2_ALL_STLinkDrop_KPNTestCase (Start)
         //Limit Qrx to "Max_QTx*3" (Qrx should be less than QRETX_TRANS_TABLE_SIZE)
         //Max QTx => 63 (Table A.6 of G.998.4 (G.Inp) standard)
         if (CapableQrx > 63*3)
         {
            CapableQrx = 63*3;
         }
         //XDSLRTFW-1323: BugFix_DS_VDSL2_ALL_STLinkDrop_KPNTestCase (End)
         //XDSLRTFW-3402 (END)

#ifndef STANDALONE_TEST
         // Save the retx related parameters
         if(gs_RxState != R_O_SHOWTIME_RX) // Training
         {
            pt_ReTXParams->uc_RPMS_Qtx = (uint8)s_Qtx_opt;
            //pt_ReTXParams->Un_UcodeReTXParam2.t_Param2.uc_ReTXQueueSize_Qrx_SIZE = s_Qtx_opt + 3;

            pt_ReTXParams->Un_UcodeReTXParam1.t_Param1.uc_CWsPerDtu_Q = (uint8)s_Q_opt;
            pt_ReTXParams->Un_UcodeReTXParam1.t_Param1.uc_DtuPaddingSize_V = (uint8)s_V_opt;
            // XDSLRTFW-1329 BugFix_USDS_VDSL2_ALL_UsDsReTxMemCorruptHighDsUsRate (Start)
            // Added by Gopi
            ComputedQrx = s_Qtx_opt + DSRETX_MIN_DTUs_REQOVERQTX;
            // XDSLRTFW-1363 DSReTx_DS_Rate_Degration_by_10% (START_END)


            //XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR (Start_End)
            //Best possible QRx size is always given by CapableQrx. If MAX is used, and if
            //'ComputedQrx > CapableQrx' we will have memory corruption.
            pt_ReTXParams->uc_Qrx = CapableQrx; //MAX(CapableQrx, ComputedQrx);
         }
         //XDSLRTFW-1063: SRAds_Support_with_DS_ReTx (START)
         else //SHOWTIME
         {
//XDSLRTFW-2162 (Start)
            //if(gt_ReTxShowtimeParams.uc_RPMS_Qtx != (uint8)s_Qtx_opt)
            //{
            //   gft_Params_change = TRUE;
            //}

            gt_ReTxShowtimeParams.uc_RPMS_Qtx = (uint8)s_Qtx_opt;
            //gt_ReTxShowtimeParams.uc_ReTXQueueSize_Qrx_SIZE = s_Qtx_opt + 3;
            //if(gt_ReTxShowtimeParams.uc_CWsPerDtu_Q != (uint8)s_Q_opt)
            //{
            //   gft_Params_change = TRUE;
            //}
            gt_ReTxShowtimeParams.uc_CWsPerDtu_Q = (uint8)s_Q_opt;
            //if(gt_ReTxShowtimeParams.uc_DtuPaddingSize_V != (uint8)s_V_opt)
            //{
            //   gft_Params_change = TRUE;
            //}
            gt_ReTxShowtimeParams.uc_DtuPaddingSize_V = (uint8)s_V_opt;

            // Added by Gopi
            ComputedQrx = s_Qtx_opt + DSRETX_MIN_DTUs_REQOVERQTX;// XDSLRTFW-1329 BugFix_USDS_VDSL2_ALL_UsDsReTxMemCorruptHighDsUsRate (Start_End)
            // XDSLRTFW-1363 DSReTx_DS_Rate_Degration_by_10% (START_END)

            gt_ReTxShowtimeParams.uc_ReTXQueueSize_Qrx_SIZE = CapableQrx; //MAX(CapableQrx, ComputedQrx);

//XDSLRTFW-2162 (End)
         }
         //XDSLRTFW-1063: SRAds_Support_with_DS_ReTx (END)

#else
         Qp_r = s_Q_opt;
         Vp_r = s_V_opt;
         gs_Qtx = s_Qtx_opt;
#endif
      }
      else
      {
         //ATTNDR Methods -0 Framing based, 1 & 2
         gul_ATTNDR = (uint32)((l_max_ndr_Q28x4_kbps >> 4) * 1000);


         // XDSLRTFW-3556 : VRx518 shows different method_0 attainable datarate than VR9(R7) (Start)
         // ATTNDR initialization which will be seen at Showtime entry according to Method_0 Framing based or Method_1 or Method_2 algorithm
         // Note: Method_0 Channel Capacity based ATTNDR initialization is done in ComputeMaxDataRate() function
         if ( !((guc_attndr_method == ATTNDR_METHOD_0) &&
                (gt_DbgImprovedATTNDR.us_ATTNDR_MISC_CONFIGURATION == ATTNDR_ALGO_2_METHOD_0_CHANNEL_CAPACITY_BASED)) )

         {
            gt_LineStatusDS.ul_AttainableDataRate = gul_ATTNDR;   //ReTx Mode (Training)
         }
         // XDSLRTFW-3556 : VRx518 shows different method_0 attainable datarate than VR9(R7) (End)


         gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_METHOD = guc_attndr_method;

         //Compute actual delay
         ul_tmp = ((s_Q_opt * s_N1_opt) << (11 + 6))/ul_L1_opt;
         gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_DELAYds = ((((ul_tmp/fdmt) *100) +(1 << 13))>>14); //Resolution: 0.01msec

         //Calculate Act INP
         t_ComputeInp_Params.us_SHINE_ratio = pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_SHINE_ratio;
         t_ComputeInp_Params.us_INP_min = pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_INP_min;
         t_ComputeInp_Params.us_INP_min_REIN = (pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_INP_min_REIN & 0x1F);
         t_ComputeInp_Params.us_Iat_rein_flag = ((pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_INP_min_REIN >> 7) & 0x1);
         t_ComputeInp_Params.us_DelayMax = pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_DelayMax;

         t_ComputeInp_Params.s_Nfecp = s_N1_opt;
         t_ComputeInp_Params.ul_Lp = ul_L1_opt;

         t_ComputeInp_Params.us_Qtx = (uint16)s_Qtx_opt;
         t_ComputeInp_Params.us_Q = (uint16)s_Q_opt;

         t_ComputeInp_Params.us_V = (uint16)s_V_opt;
         t_ComputeInp_Params.us_H = (uint16)(s_N1_opt-s_R1_opt);

         //update the actual US INP values for LP1 only
         CalculateActualINP((int16 *)(void *)&us_ActShineInp, (int16 *)(void *)&us_ActReinInp , t_ComputeInp_Params);

         gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_INPds = MIN((us_ActShineInp * 10), MAX_ATTNDR_INP_ACT_SHINE); //Act Shine Inp in 0.1 symbols granularity
         gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_INP_REINds = MIN((us_ActReinInp * 10), MAX_ATTNDR_INP_ACT_REIN); //Act Rein Inp in 0.1 symbols granularity
      }
      //XDSLRTFW-1522 (End)
   }

/*    //debug code to log the input and output values generated by the framer ////////
   FILE *wr_cfg_1;
   wr_cfg_1 = fopen("ReTx_Framing_Input_Output_C_TestBench.txt","a");
   //Input Parameters
   //ETR_min
   //ETR_max
   //MAX_NDR
   //MAX_DELAY
   //INP_min_rein
   //INP_min_shine
   //Shine Ratio
   //LpAvailable
   //RtxMemory
   //
   fprintf(wr_cfg_1, "%10d\n", l_ETR_min_kbps         );
   fprintf(wr_cfg_1, "%10d\n", l_ETR_max_kbps         );
   fprintf(wr_cfg_1, "%10d\n", l_net_max_kbps         );
   fprintf(wr_cfg_1, "%10d\n", SHINEratio             );
   fprintf(wr_cfg_1, "%10d\n", INP_min_rein           );
   fprintf(wr_cfg_1, "%10d\n", INP_min                );
   fprintf(wr_cfg_1, "%10d\n", MinDataSymbolsDelaymax );
   fprintf(wr_cfg_1, "%10d\n", RTmemMax               );
   fprintf(wr_cfg_1, "%10d\n", ul_LpAvailable         );

   //Output
   fprintf(wr_cfg_1, "%10d\n", ul_L1_opt                        );
   fprintf(wr_cfg_1, "%10d\n", s_Q_opt                          );
   fprintf(wr_cfg_1, "%10d\n", s_R1_opt                         );
   fprintf(wr_cfg_1, "%10d\n", s_N1_opt                         );
   fprintf(wr_cfg_1, "%10d\n", s_V_opt                          );
   fprintf(wr_cfg_1, "%10d\n", s_D1_opt                         );
   fprintf(wr_cfg_1, "%10d\n", s_Qtx_opt                        );
   fprintf(wr_cfg_1, "%10d\n", (l_max_ndr_eff_kbps >> 4)        );  //ETRu
   fprintf(wr_cfg_1, "%10d\n", l_ETR_max_kbps               ); //ETR_max
   fprintf(wr_cfg_1, "%10d\n", gt_ReTXStats.ul_ReTX_ReceiverETR );  //ETR=min(ETRu,ETR_max);
   fprintf(wr_cfg_1, "%10d\n", gt_ReTXStats.ul_ReTX_NDR         );
   //debug print
   fclose(wr_cfg_1);    */


   return(ft_retVal);
}



void Sort_HQV_Table(uint16 us_imax)
{
   uint16 x, y, max_index;
    int32  l_temp_value;
    uint8  uc_temp_index;

   for( x = 0; x < us_imax; x++)
   {

      max_index = x;

      for(y = x; y < us_imax; y++)
      {
         if (gt_HQV_ETRu[max_index].l_ndr_eff < gt_HQV_ETRu[y].l_ndr_eff)
         {
            max_index = y;
         }
      }

      l_temp_value = gt_HQV_ETRu[x].l_ndr_eff;
      uc_temp_index = gt_HQV_ETRu[x].ul_ndr_idx;

      gt_HQV_ETRu[x].l_ndr_eff = gt_HQV_ETRu[max_index].l_ndr_eff;
      gt_HQV_ETRu[x].ul_ndr_idx = gt_HQV_ETRu[max_index].ul_ndr_idx;

      gt_HQV_ETRu[max_index].l_ndr_eff = l_temp_value;
      gt_HQV_ETRu[max_index].ul_ndr_idx = uc_temp_index;
   }
}

//loadedTones=sum(nBiV);
//loadedBits=sum(nBiV.*[1:length(nBiV)]);
//usedBits=loadedBits-loadedTones/2; % substraction of Trellis overhead
//for i=1:length(H_Q_V(:,1))
//CGbi=CGv(find(CGv(:,16)==Rp & CGv(:,17)==H_Q_V(i,2)),1:length(nBiV));
//BiNew=min([1:length(nBiV)]+CGbi./3,15);
//loadedBitsNew=sum(nBiV.*BiNew);
//usedBitsNew=loadedBitsNew-loadedTones/2;
//H_Q_V(i,6)=floor(LpAvailable*usedBitsNew/usedBits);
uint32 GetNewLpWithCodingGain_iDTU(uint8 R, uint8 Q, uint32 ul_LpAvailable)
{
   uint8 CG_Index = 0;
   uint8 i = 0;
   uint8 j = 0;
   uint8 R_iDTU[5] = {8, 10, 12, 14, 16};
   uint8 Q_iDTU[3] = {4, 8, 16};
   uint32 ul_temp;
   uint32 ul_loadedTones = 0;
   uint32 ul_loadedBits = 0;
   uint32 ul_usedBits = 0;
   uint32 ul_loadedBitsNew = 0;
   uint32 ul_usedBitsNew = 0;
   uint32 ul_LpAvailableNew = 0;

   while ((i < 5) && (R != R_iDTU[i])) i++;

   while ((j < 3) && (Q != Q_iDTU[j])) j++;

   if ((i < 5) && (j < 3))
   {
   //3*15 = 45, 3 Rows for each "R"
      CG_Index = i*45 + j * 15;

   for (i = 0; i < 15; i++)
   {

      if (gusa_n_tones_per_Bi[i+1] == 0)
         continue;

        //loadedBits=sum(nBiV.*[1:length(nBiV)]);
        ul_loadedBits += (gusa_n_tones_per_Bi[i+1] * (i+1));
        //loadedTones=sum(nBiV);
        ul_loadedTones += (gusa_n_tones_per_Bi[i+1]);

      //BiNew=min([1:length(nBiV)]+CGbi./3,15);  //CGbi is in x10
        ul_temp =  ((i+1) * 30 + guca_CGv[CG_Index+i]);
      //Limit to 15bits, if exceed
      //15 * 30 = 450
        if (ul_temp > 450)
         ul_temp = 450;
        //loadedBitsNew=sum(nBiV.*BiNew);
        ul_loadedBitsNew += ((gusa_n_tones_per_Bi[i+1] * ul_temp)/30);
   }

      //loadedTones=sum(nBiV);
      //loadedBits=sum(nBiV.*[1:length(nBiV)]);
      //usedBits=loadedBits-loadedTones/2; % substraction of Trellis overhead
      //usedBitsNew=loadedBitsNew-loadedTones/2;
      //H_Q_V(i,6)=floor(LpAvailable*usedBitsNew/usedBits);
      //ul_usedBits = ((ul_loadedBits << 1) - ul_loadedTones) >> 1;
      //ul_usedBitsNew = ((ul_loadedBitsNew << 1) - ul_loadedTones) >> 1;

      ul_usedBits = ul_loadedBits - (ul_loadedTones >> 1);
      ul_temp = ((ul_loadedBitsNew - (ul_loadedTones >> 1)) << 14);  // ul_usedBitsNew = ul_usedBitsNew * 2^14 to avoid precision while dividing
      ul_usedBitsNew = ul_temp / ul_usedBits;
      ul_LpAvailableNew = (ul_LpAvailable * ul_usedBitsNew) >> 14 ;
   }

   return (ul_LpAvailableNew);
}
//XDSLRTFW-3493(End)



/*
*-------------------------------------------------------------------------------
*
*   Prototype: FlagT RtxFramingVdsl_V1(uint32 ul_LpAvailable, VDSL2Config_t *pt_Output)
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*    Get the highest possible effective net data rate (also called throughput) in case of retransmission
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
FlagT RtxFramingVdsl_V1(uint32 ul_LpAvailable, VDSL2Config_t *pt_Output)
{
   // Indicate no solution found
   FlagT ft_retVal = FALSE;
   FlagT ia_rein_flag;
//XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(Start)
   FlagT ft_attndr_calc = FALSE;
//XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(End)

   uint32 ul_Lp, ul_LpMax, ul_LpMin, ul_LpminLimit, ul_LpmaxLimit;
   uint32 ul_LpAvailableNetMax;  // XDSLRTFW-2511

   int16 inp_calc, cc=0;
   //XDSLRTFW-1522 (Start_End)
   uint16 us_ActShineInp, us_ActReinInp;
   int16 MinDataSymbolsRein, MaxDataSymbolsRein, MinDataSymbolsDelaymax;
   int16 Mp,SpMax,SpMaxLog2,Rp,Dp,Hp, Np, Qp,Vp, Np_Qp;
   int16 imax;
   //int16 s_min1,s_min2,s_min3,s_min4, s_hqv_index_Min;
   int16 RTmem, Roundtrip;
   int16 i, RtInDTUs, Qtxmin, Qtxmax,Nrtx=0, Qtx,INP,NRET, idx;
   int16 NretQtxFound, NRETmax, NRETmin;
   int16 A, k_min, k_max;
   int16 DtuSize, s_CO, d_CO, d_CPE, s_CPE;
   int16 s_fs, s_temp;
   int16 s_OHFactor;
   int16 Trein=0, s_Target_INP=0, INP_min, s_Trein_fdmt;
   int16 s_R1_opt=0, s_N1_opt=0, s_D1_opt=0, s_M1_opt=0, s_Q_opt=0, s_V_opt=0, s_Qtx_opt=0;
   uint32 ul_L1_opt=1;
   int16 SpMinInvers;
   int16 INP_min_rein, CIP, SHINEratio;

   int16 s_path = LP1;
   int16 s_D,s_I;
   int16 ComputedQrx, CapableQrx;

   //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (Start_End)
   uint32 TRELLISratio, REINratio, RTXOH;
   uint32 ul_temp1;

   int16 fdmt;

   //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (Start_End)
   int32 l_max_ndr_eff_kbps, l_max_ndr_Q28x4_kbps, l_net_max_kbps, ndr_eff_, ndr_, ndr_fraction_; // Q28.4 format
   int32 max_delay_octet, l_NE_limit, l_Trein_fdmt;
   int32 RTmemMax;
   int32 l_ETR_min_kbps, l_ETR_max_kbps;

   /* XDSLRTFW-2709 */
   int32 l_net_max_Qf28x4_kbps,l_ETR_min_Qf28x4_kbps;
   /* XDSLRTFW-2709*/
   uint32 ul_dilv_size;
   //XDSLRTFW-634 : BUG_DS_ALL_ALL_ReTxThroughput (Start_End)
   uint16 us_platform;

   //XDSLRTFW-3402 (START)
   uint32 ul_DtuPayloadSize;
   uint32 ul_PaddingBytes;
   //XDSLRTFW-3402 (END)

   ReTX_Params_t *pt_ReTXParams;
   VDSL2FramingParamsInputs_t *pt_FramingParamsInputs;
   int16 s_MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX;
   uint32 ul_tmp;
   //XDSLRTFW-1617 (Start)
   uint8 uc_DS_ReTx_Max_D_CO_support;
   uint8 *uca_hqv_table;
   //XDSLRTFW-1617 (End)
   uint16 us_MaxDTUSizeDS;  //XDSLRTFW-3189
   uint16 us_PPE_INPUT_MAX;
   uint32 ul_addr, ul_data;

   //XDSLRTFW-1522 (Start_End)
   ReTx_ComputeInp_Params_t t_ComputeInp_Params;

   pt_ReTXParams = &gt_ReTXParams;

   //Set the pointer to the framin parameter input structure
   pt_FramingParamsInputs = &gt_FormFramingParamsInputs_v2;

   // Get the retx framing inputs
   SpMinInvers = pt_ReTXParams->uc_OMSG1_Ds1overSMax;
   // Convert to Kbps
   l_ETR_min_kbps = (pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_ETR_min << 3);
   l_ETR_max_kbps = (pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_ETR_max << 3);
   l_net_max_kbps = (pt_FramingParamsInputs->us_MaxRate << 3);

   SHINEratio = pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_SHINE_ratio;
   CIP = pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_CI_policy;

   //XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(Start)
   //As per G.998.4 Amd 2, for ATTNDR methods 1 & 2, channel initialisation policy
   //should be zero and max rates should not limited.

   //XDSLRTFW-1522 (Start_End)
   if(gft_CalcAttndr == TRUE)
   {
      CIP = 0;
      l_ETR_max_kbps = 0x7ffffff;  // set to max (shifted by 4 bit during following 28x4 bit format conversion)
      l_ETR_min_kbps = 0x0000001;  // set to 1kbps as XDSLRTFW-2709 fix reduced ETR min by 1kbps
      l_net_max_kbps = 0x7ffffff;  // set to max (shifted by 4 bit during following 28x4 bit format conversion)
   }
   // XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR (End)

   // XDSLRTFW-2709 (Start)
   // net_max_28_4_kbps => netmax in [kbps] in Q.28.4 format
   // reduce netmax by 0.25kbps (as max error of our NDR calculation can be ~0.2kbps)
   // ETR_min_Qf28x4_kbps => ETRmin in [kbps] in Q.28.4 format
   // reduce ETR_min_Qf28x4_kbps by 1.0kbps (as max error of our ndr_eff_ calculation can be ~1.0kbps)
   //    1.0   kbps in Q28.4: 0x0010
   //    0.5   kbps in Q28.4: 0x0008
   //    0.25  kbps in Q28.4: 0x0004
   //    0.125 kbps in Q28.4: 0x0002

   l_ETR_min_Qf28x4_kbps = l_ETR_min_kbps<<4;
   l_ETR_min_Qf28x4_kbps = l_ETR_min_Qf28x4_kbps - 16;
   l_net_max_Qf28x4_kbps = l_net_max_kbps<<4;
   l_net_max_Qf28x4_kbps = l_net_max_Qf28x4_kbps - 4;
   // XDSLRTFW-2709 (End)

   {
      uint16 us_Temp;

      us_Temp = pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_INP_min_REIN;

      ia_rein_flag = ((us_Temp & 0x0080) != 0);
      INP_min_rein = us_Temp & 0x1F;
   }
   INP_min = pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_INP_min;

#ifndef STANDALONE_TEST

   s_D = gt_rx_config_v2.s_Dp[LP0];
   s_I = gt_rx_config_v2.s_Ip[LP0];

   //According to Josh, the interleaver buffer size used should be:
   //ILV_MEM = I*(D-M-1)/2 + I*EXT
   //where M = floor(D/I), EXT = 2 for TX and 1+q for RX
   //To be conservative, we set ILV_MEM = I*D/2 + I*EXT
   MULS16(ul_dilv_size, s_D, s_I);
   ul_dilv_size >>= 1;

   //Add I*EXT = I*2
   ul_dilv_size += (s_I<<1);

   // Compute the total DILV memory available for LP1 path by subtracting the memory used by the LP0
   // path

   // Compute the DILV memory available to serve as the retransmission queue
   // after leaving 1K memory(DS_RETX_LP1_PROCESSING) for LP1 path processing. Note that D=1 for LP1 path
   // hence, with max codeword size of 255, the max memory used can be 2.5*255 ~= 638 bytes

   s_MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX = gs_MemSize_DsReTx_MinDtus_ReqOverQtx; //XDSLRTFW-3189 (Start_End)

   //XDSLRTFW-2590 (Start)
   if(gft_Intra_DTU_Ilv_DS == TRUE)
   {
      //XDSLRTFW-3189 (Start)
      us_MaxDTUSizeDS = gus_MaxDTUSizeDS_iDTU;
      l_NE_limit = gul_HW_DILV_MEM_SIZE[LP0] - ul_dilv_size - (us_MaxDTUSizeDS << 1) - (s_MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX);
      //XDSLRTFW-3189 (End)
   }
   else
   {
      l_NE_limit = gul_HW_DILV_MEM_SIZE[LP0] - ul_dilv_size - DS_RETX_LP1_PROCESSING - (s_MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX);
   }
   //XDSLRTFW-2590 (End)

   //XDSLRTFW-1707_30a_RTX_DsUs (End)
   // O-PMS:
   // Field #8 "max_delay_octetDS,0" is a 3-byte field that specifies the maximum value of delay_octetDS,0
   // (defined in clause 6.2.8), specified in bytes as an unsigned integer.
   // Field #9 "max_delay_octetDS,1" is a 3-byte field that specifies the maximum value of delay_octetDS,1
   // (defined in clause 6.2.8), specified in bytes as an unsigned integer. If the value of this field is set to
   // the special value 0xFFFFFF, the Field #8 (max_delay_octetDS,0) specifies the maximum value of
   // (delay_octetDS,0 + delay_octetDS,1) and the VTU-R shall autonomously partition the number of
   // octets between both downstream latency paths. The value 0xFFFFFF is not allowed if the VTU
   // intends to use interleaver reconfiguration in the downstream direction.
   // Take the minimum of the near end and the far end limit
   if (gla_MaxInlvDelay[LP1] != 0xFFFFFF)
   {
      max_delay_octet = gla_MaxInlvDelay[LP1];
   }
   else
   {
      max_delay_octet = gla_MaxInlvDelay[LP0] - gl_delay_octet_LP0;
   }

   // Compute the memory available for LP1 path to serve as retransmission queue
   RTmemMax = MIN(l_NE_limit, (max_delay_octet >> 1));
#else
   RTmemMax = max_delay_octetDS1;
#endif

   //XDSLRTFW-1522 (Start_End)
   gul_RTmemMax = RTmemMax;

   // Universal ReTx Framing for Latency Path LP1 with ReTx
   // T1 is 0 for FramingType = 1, 2, or 3.
   // G1 is 0 for FramingType = 1, 2, or 3.
   // M1 is 1 for FramingType = 1, 2, or 3.
   // R1 are 0, 2, 4, 8, 10, 12, 14 or 16.
   // Sp may be a non-integer, and shall not exceed 64.
   // Q is any integer from 1 to 16 if the associated Recommendation is ITU-T G.992.3 or ITU-T G.992.5.
   //   Furthermore, valid configurations of Q shall be such that 0.5 <= Q*S1 <= 4 in L0 state.

   // H=Mp*(Bp+1)=Np-Rp;
   // Rp=4;  // Used for Error detection, i.e. 32bit CRC! No coding gain win.
   // Dp=1 without interleaving
   // 8x,12x,17a and 30a:
   //      0.5 <= Q*Sp <=4, DTU size in symbols
   // 35b:
   //      0.3 <= Q*Sp <=4, DTU size in symbols
   //
   // Q*(Bp+1)-2-V is number of TPS-TC bytes per DTU
   // V=0:15; // optional stuff bytes
   // modulo((Q*(Bp+1)-2-V),65)=0 & (Q*(Bp+1)-2-V)>0 has to be fulfilled for alignment
   // net data rate NDR[kbit/s] = fs*ul_Lp*(1-Rp/Np-(2+V)/Q/Np)) with fs=8*256/257 in profile 30a and fs=4*256/257 in all other profiles
   // throughput, eff. net data rate NDReff = NDR*(1-REINratio)*(1-SHINEratio)*(1-TRELLISratio); LossFactor depends on average distance of Trellis bursts and configured INP_min_rein

   // Inputs from VTU-O during Initialization
   // RTmemMax; max. number of octets for transmitter's RTX queue
   // INP_min; min. INP in number of destroyed DMT symbols due to noise impulse (SHINE/PEIN)
   // INP_min_rein; min. REIN INP in number of destroyed DMT symbols due to single REIN impulse
   // ia_rein_flag; flag=0 for 100-Hz-REIN and flag=1 for 120-Hz-REIN
   // SHINEratio; average loss ratio due to SHINE in multiple of 0.1 %
   // s_CO; d_CO; // half roundtrip (s symbols + d DTUs) of CO side
   // SpMinInvers; // 1/SpMin for latency path 1 connected with bearer channel 0
   // ifx_co_flag; // if IFX CO device is detected by CPE in HS CPE shall set this flag to one, else to 0
   // adsl2p_flag; // shall be set to 1 by CPE if mode select has been done for ADSL2 in HS and if PMS-TC C-MSG1 octet 2 most significant bit is one, else 0
   // l_ETR_min_kbps; // min. throughput, here called NDReff, in kbit/s
   // l_net_max_kbps; // max net data rate in kbit/s
   // l_ETR_max_kbps; // max. ETR in kbit/s with ETR = min(NDReff, ETR_max), only really relevant if CIP=1 then it means NDReff<=ETR_max
   // CIP; // channel optimization policy, 0 is optimization for throughput, 0 is default if not got in C-MSG1
   // delay_max; // max. excess delay in ms caused by retransmission
   // eftr_thresh; // threshold for throughput supervision in showtime, not relevant for framing parameter generation

   // Internal VTU-R Inputs; to be configurable at ATU-R side
   // s_CPE; d_CPE; // half roundtrip (s symbols + d DTUs) of CPE side

   if (CIP==1)
   {
      // Adjust the limits for the special case
      if ((l_ETR_max_kbps - l_ETR_min_kbps) < 8)
      {
         l_ETR_max_kbps = l_ETR_min_kbps+8;
      }
   }


   inp_calc=1; // 1 actual INP calculation included, 0 not included; default has to be 1 for the FW release

   //XDSLRTFW-1522 (Start_End)
   us_ActShineInp = 0;
   us_ActReinInp = 0;

   // Internal ATU-R Inputs; after SNR measurements
   // ul_LpAvailable; // number of bits which can be loaded under consideration of ReTx coding gain
   // ul_LpDelta; // evaluated ul_Lp range is from LpAvailable-ul_LpDelta to LpAvailable
   // ia_trellis and ReTxCodingGain shall be configurable for debug purpose; the max. trellis overhead part has been fixed to 10^-4 in table 9-2/G.998.4 and therefore these parameters are don't care now
   //XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(Start)

   //XDSLRTFW-1522 (Start_End)
   if ((gft_CalcAttndr == TRUE) &&  (guc_attndr_method == ATTNDR_METHOD_2))
   {
      INP_min = 0;
      INP_min_rein = 0;
   }
   //XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(End)


   //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (Start_End)
   TRELLISratio = 13; // expressed in Q1.17

   if ((INP_min == 0) && (INP_min_rein == 0))
   {
      cc=0;   // config with no SHINE, no REIN
   }

   else if ((INP_min > 0) && (INP_min_rein == 0))
   {
      cc=1;   // config with SHINE only
   }

   else if ((INP_min > 0) && (INP_min_rein>0))
   {
      cc=2;   // config with SHINE and REIN
   }

   else if ((INP_min==0) && (INP_min_rein>0))
   {
      cc=3;   // config with REIN only
   }

   if (cc == 0)
   {
      inp_calc = 0;
   }

   // Rx Half-Roundtrip delay, i.e. byte [00ddssss]
   // s_CO; d_CO; // half roundtrip (s symbols + d DTUs) of CO side
   s_CPE = (pt_ReTXParams->uc_RMSG2_CpeRxHalfRoundTripDelays & 0xF);
   d_CPE = (pt_ReTXParams->uc_RMSG2_CpeRxHalfRoundTripDelays >> 4) & 0x3;

   s_CO = pt_ReTXParams->uc_OMSG1_DsHalfRoundTripInSyms;
   d_CO = pt_ReTXParams->uc_OMSG1_DsHalfRoundTripInDTUS;

   /* XDSLRTFW-2858 */
   /*  New proposal for downstream performance improvement in G.Vector mode: Reduce CPE-Rx-HRT-delay by 1-Symb.

   if ((SSdsOffset <= HRT_TX_S-1) & (SSdsOffset >= -HRT_RX_S+1))
      then execute framing generation with HRT_RX_S=HRT_RX_S-1;
   else
      execute framing generation with HRT_RX_S =  HRT_RX_S;
   end;
   */

   /* (SSdsOffset <= HRT_TX_S-1) & (SSdsOffset >= -HRT_RX_S+1) */
   if ((gc_VecUSSyncOffset <= s_CO-1) && (gc_VecUSSyncOffset >= -s_CPE+1) && (gft_DSVectoringEnabled == TRUE))
   {
      s_CPE = (pt_ReTXParams->uc_RMSG2_CpeRxHalfRoundTripDelays & 0xF) -1;
   }

   /* cmv approach/ fall-back */
   if (gs_CpeRxHalfRoundTripDelays_ForcedInFraming > 0)              //if (TESTArray[TEST_DS_RETX_HRT])
   {
      s_CPE = (gs_CpeRxHalfRoundTripDelays_ForcedInFraming & 0xF);      //s_CPE = TESTArray[TEST_DS_RETX_HRT];
   }
   /* XDSLRTFW-2858 */

   // In case of 30a profile
   if (gs_frame_rate_is_8khz)
   {
      fdmt = 8;

      // Roundtrip delay in symbols is double due to higher frame
      // rate in case of 30a profile
      s_CO =  s_CO << 1;
      s_CPE = s_CPE << 1; // DMT symbol time in ms for VDSL2 profile 30a

      //XDSLRTFW-1707_30a_RTX_DsUs  (Start)
      //In 30a mode DTU values to be taken as is
      //d_CO =  d_CO << 1;
      //d_CPE = d_CPE << 1;

      //Order of processing of Rx latency paths.
      //    000               1, 0, 2  (the default value)
      //    001               1, 2, 0
      //    010               0, 1, 2
      //    011               0, 2, 1
      //    100               2, 0, 1
      //    101               2, 1, 0
      //XDSLRTFW-1707_30a_RTX_DsUs  (End)
   }
   else
   {
      fdmt = 4;
   }
   gt_ReTXParams.uc_CpeRxHalfRoundTripDelays_UsedInFraming = s_CPE;     /* XDSLRTFW-2858 */

   //XDSLRTFW-1610 (START)
   // Convert to Q10.6 format
   // Note: Normally gt_FormFramingParamsInputs_v2.s_fs should be used , which
   //       considers the "m"-value, i.e. CE.
   // !!!In this formula the fix value m=5 is used!!
   s_fs = (fdmt * 256 * 64)/257;  // = (fdmt << 14)/257;


   //30a_DSRTX Debug
#ifdef ENABLE_RETX_US_DEBUG1
   gula_PalakDebug[1]= RTmemMax;
   gula_PalakDebug[2]= l_NE_limit;
   gusa_ReTxDebugBuf[0] = s_CPE;
   gusa_ReTxDebugBuf[1] = d_CPE;
   gusa_ReTxDebugBuf[2] = s_CO;
   gusa_ReTxDebugBuf[3] = d_CO;
#endif

   // REIN noise has a repetition rate of twice the AC power frequency (100 or 120 Hz).
   if (ia_rein_flag == 0)
   {
      // 50 Hz frequeny
      // Expressed in Q8.8 format
      //Trein = (20 << 7);   // 20 * 128 = 2560 REIN period in ms
      Trein = 2560;
   }
   else if (ia_rein_flag == 1)
   {
      // 60 Hz frequency
      // Expressed in Q8.8 format
      //Trein = (50 << 7) / 3;   // REIN period in ms
      Trein = 2133;   // (50 * 128)/3 = 6400/3 = 2133.33 REIN period in ms
   }

   s_Trein_fdmt = Trein * fdmt;

   // MinDataSymbolsRein = floor(Trein/Tdmt) - ceil(Trein/Tsync)
   //                    = floor(Trein * fdmt) - ceil((Trein * fdmt)/257)
   //MinDataSymbolsRein = Trein * fdmt - ceil16((int16)(Trein * fdmt), 257);      // min. integer number of DMT data symbols witin a REIN period
   MinDataSymbolsRein = (s_Trein_fdmt - ((s_Trein_fdmt + 256)/257));      // min. integer number of DMT data symbols witin a REIN period

   // MaxDataSymbolsRein = (Trein/Tdmt) - floor(Trein/Tsync)
   //                    = (Trein * fdmt) - floor((Trein * fdmt)/257)
   //                    = ((Trein * fdmt)*256)/257
   //MaxDataSymbolsRein = ceil32((Trein * fdmt) << 8, 257);            // average fractional number of DMT data symbols in REIN period
   l_Trein_fdmt = (int32)(s_Trein_fdmt << 8);
   MaxDataSymbolsRein = (l_Trein_fdmt + 256)/257;            // average fractional number of DMT data symbols in REIN period
   //XDSLRTFW-1610 (END)

   MinDataSymbolsDelaymax = ((pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_DelayMax * fdmt) << 8) / 257;   // min. number of DMT data symbols within delay_max // floor16 was missing in V7


   if (CIP == 1)
   {
      // Assume worst case RTxOF of 0.25
      // Lp max <= l_ETR_max_kbps * Nfecp/((Nfecp - Rp)*(1 - RtOH)* fs)
      ul_temp1 = (l_ETR_max_kbps * 384) / (s_fs << 2);

   }
   else
   {
      // Lp cap due to max data rate cap l_net_max_kbps, 1.10 results from (67+4)/65
      // 1.10 expressed in Q8.8 equals 281
      // Lp max <= NRDp * Nfecp/((Nfecp - Rp)*fs)
      ul_temp1 = (l_net_max_kbps * 281) / (s_fs << 2);

   }
   //XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(Start)
   //XDSLRTFW-1522 (Start)
   if (gft_CalcAttndr == FALSE)
   {
      if(ul_LpAvailable > ul_temp1)
      {
         ul_LpAvailable = ul_temp1;
      }
   }
   //XDSLRTFW-1522 (End)
   //XDSLRTFW-1285 Feature_US_VDSL2_ALL_UsReTxAmend2_ATTNDR(End)

   // Max DTU size equals 4 symbols, i.e. Q*Spmax <= 4.
   // Therefore is Spmax = 4 for min Q value of 1.
   // SpMax = MIN(32*Mp,64); Note: (32*Mp) is comming from ADSL2.
   // SpMax = MIN(Mp << 5,64);
   SpMax = 4;
   SpMaxLog2 = 2;
   Dp=1;
   Mp=1;                   // M1 is 1 for FramingType = 1, 2, or 3.
   Rp=4;
   uc_DS_ReTx_Max_D_CO_support=0;
   // HQV table varible initialisation
   {
      // XDSLRTFW-1617 (Start)
      // XDSLRTFW-2162 (Start - End)
      uca_hqv_table = guca_HQV;
      imax = HQV_NUM_ROW;

      if(gft_Intra_DTU_Ilv_DS == TRUE)
      {
         Rp=guc_DS_ReTx_iDTU_R;
         uca_hqv_table = guca_HQV_IDILV;
         imax = HQV_IDILV_NUM_ROW;

         uc_DS_ReTx_Max_D_CO_support = (guc_DS_ReTx_Max_D_CO_support & 0x7f);
         //Use new special HQV table if CO supports "D -> only powers of 2"
         if (guc_DS_ReTx_Max_D_CO_support & 0x80)
         {
            uca_hqv_table = guca_HQV_IDILV_Pow2;
            imax = HQV_IDILV_POW2_NUM_ROW;
         }
      }
      // XDSLRTFW-1617 (End)

      // Limit the HQV table for 30a, 17a, 12x and 8x profiles.
      if (gt_ProfileAct.us_ProfileSelected & (CNFG_V2_PROFILE_17A_MASK|CNFG_V2_PROFILE_12xALL_MASK|CNFG_V2_PROFILE_8xALL_MASK))
      {
         // Note: XDSLRTFW-1816 (start_end) Changed HQV table Max Idx from 31 to 37 to have DS rate upto 150Mbps.
         //       Now it was changed from 37 to 47 to have rates upto 190Mbps. This is also needed for 35BLite.
         imax = MAX_HQV_IDX_DS_PROFILE_8_12_17_WITHOUT_IDTU;  //XDSLRTFW-3189 (Start_End)

         //XDSLRTFW-3020 (Start)
         //Zephyr MIPS is not sufficient to run Q=16 in a DTU when DS intra DTU interleaving is enabled.
         //Hence restricted the max entry of HQV table size to 29. i.e support only Q = 8.
         if (gft_Intra_DTU_Ilv_DS == TRUE)
         {
            imax = MAX_HQV_IDX_DS_PROFILE_8_12_17_WITH_IDTU;  //XDSLRTFW-3189 (Start_End)
         }
         //XDSLRTFW-3020 (End)
      }
      else if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK)
      {
         // XDSLRTFW-1707_30a_RTX_DsUs (Start_End)
         // For 30a profile, more combinations of H, Q, V possible.
         imax = MAX_HQV_IDX_DS_PROFILE_30a_WITHOUT_IDTU;      //XDSLRTFW-3189 (Start_End) // 26 to have rates upto 200Mbps
      } else if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
      {
         //XDSLRTFW-3322 (Start)
         imax = MAX_HQV_IDX_DS_PROFILE_35b_WITHOUT_IDTU;
         if (gft_Intra_DTU_Ilv_DS == TRUE)
         {
            imax = MAX_HQV_IDX_DS_PROFILE_35b_WITH_IDTU;
         }
         //XDSLRTFW-3322 (End)
      }

      // Debug possibility to limit or change the HQV table index.
      if (gs_HQV_MaxIdx !=0)
      {
         imax = gs_HQV_MaxIdx;
      }
   }

   // XDSLRTFW-2511 (Start)
   {
      int32 l_X,l_Y,l_Z,l_temp,l_temp1;
      int16 s_Ts;

      // From Dietmar, we have this new equation to compute Lpavailable
      // l_net_max_kbps=min(l_net_max_kbps,ceil(RTmemMax*8/((s_CO+s_CPE+1+(d_CO+d_CPE+1)*QSmin)*Tdmt*1e-3)/1e3)); // cap by available memory for one rountrip
      //                                                             l_X +  (l_Y) * QSmin
      // If R==4 then OHmax = 3.7037037; end;
      // If R==16 then OHmax = 11.564626; end;
      // LpAvailableNetMax=ceil(l_net_max_kbps*1/(1-OHmax/100)/fs);

      // QSmin = 0.5 for 8x,12x,17a and 30a
      // QSmin = 0.3 for 35b
      // The variables X, Y and Z are used to preserve the value of the denominator of the calculation in the l_net_max_kbps equation.
      l_X = s_CO + s_CPE + 1;
      l_Y = d_CO + d_CPE + 1;
      // We make X and Y in 12.4 format to preserve the decimal part also
      l_X = l_X << 4;
      if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
      {
#ifdef VRX518_SINGAPORE_BRINGUP
         if (gul_35bLiteConfig & EN_RESTRICT_MAX_DTU_PER_SYM_TO_3)
         {
            l_Y = ((((l_Y << 8)/755) >> 8) << 4);
         }
         else
#endif // VRX518_SIGNAPORE_BRINGUP
         {
            // 704 = 2.75 * 256; (expressed in Q8.8 format)
            l_Y = ((((l_Y << 8)/SQMIN_35B_VRX518_CONSTRAINED) >> 8) << 4);
         }
      }
      else
      {
         // Y = Y << 4 ;
         // Y = Y >> 1 // Because of QSmin
         l_Y = l_Y << 3;
      }
      l_Z = l_X + l_Y;

      if(gft_Intra_DTU_Ilv_DS)
      {
         // Denominator of l_net_max_kbps equation
         l_temp = l_Z >> 3;
         // We have OHmax = 11.564626  This value is given by Dietmar
         // OHFactor = 1/ (1-OHmax/100)
         // OHFactor = 1.1307692
         // OHFactor is converted into 9.7 format
         s_OHFactor = 145;
      }
      else
      {
         // Denominator of l_net_max_kbps equation
         l_temp = l_Z >> 2;
         // We have OHmax = 3.7037037  This value is given by Dietmar
         // OHFactor = 1/ (1-OHmax/100)
         // OHFactor = 1.03846153;
         // OHFactor is converted into 9.7 format
         s_OHFactor = 133;
      }

      if (gs_frame_rate_is_8khz)
      {
         // Ts = 1/fs;
         // s_Ts = 1/s_fs;
         // s_Ts = 1/ ((fdmt <<8)/257) Already s_fs is in 10.6 format
         // s_Ts = 1/(fdmt *(1<<8)/257)
         // s_Ts = 1.00390625 / fdmt
         // s_Ts = 1.00390625 / 8
         // Converting to 9.7 format
         s_Ts = (32 >> 1);
      }
      else
      {
         // Ts = 1/fs;
         // s_Ts = 1/s_fs;
         // s_Ts = 1/ ((fdmt * 256)/257) Already s_fs is in 10.6 format
         // s_Ts = 257 /(fdmt * 256)
         // s_Ts = 257/256* (1/fdmt)
         // s_Ts = 1.00390625 / fdmt
         // s_Ts = 1.00390625 / 4
         // s_Ts = 0.2509765625
         // Converting to 9.7 format
         s_Ts = 32;            // 32/2^7 = 0.25
      }

      // Numerator of l_net_max_kbps equation for comparison
      //l_temp1 = (RTmemMax << 3); // Shifted by 3 to multiply by 3
      //l_temp1 = l_temp1 / l_temp;
      //l_temp1 = l_temp1 << 4;
      // Combining above 3 instructions to 1 instruction
      l_temp1 = (RTmemMax << 7) / l_temp;

      ul_LpAvailableNetMax = MIN(l_net_max_kbps, l_temp1);
      ul_LpAvailableNetMax *= s_OHFactor;

      ul_LpAvailableNetMax = (ul_LpAvailableNetMax >> 7);   // To take care of 9.7 format
      ul_LpAvailableNetMax = ul_LpAvailableNetMax * s_Ts;
      ul_LpAvailableNetMax = (ul_LpAvailableNetMax >> 7);   // To take care of 9.7 format
      // XDSLRTFW-2511 (End)
   }

   // Lp max <= (8*Nfecp)/Spmin, with max codeword size of 255
   // Note: 35B - max SpMinInvers = 48 -> 97920 bits -> around 390Mbps
   ul_LpAvailable = MIN(ul_LpAvailable,((uint32)(SpMinInvers))*(255*8));  // 255*8 = 2040
   ul_LpAvailable = MIN(ul_LpAvailable, ul_LpAvailableNetMax);   // XDSLRTFW-3174 (Start_End)

   // Lpmin >= (8*Nfecp )/ Spmax
   // Max DTU size equals 4 symbols, i.e. Q*Spmax <= 4.  Therefore is Spmax = 4 for min Q value of 1.
   // Hence, we have
   // Lpmin >= ((8 * N * Q)/4
   // Lpmin >= (2 * N * Q)
   //XDSLRTFW-1617 (Start_End)
   {
      uint16 us_LpMinimal;                            // Lower limit for Lp, number of bits per symbol for LP1
      uint32 ul_LpDelta;

      us_LpMinimal = (uca_hqv_table[0]+Rp) << 1;      // H = NFECp - Rp, with p = 1 -> NFECp = H + Rp
      ul_LpDelta = (ul_LpAvailable >> 2);             // This means 75% of the LpAvailable
      ul_LpminLimit = MAX(us_LpMinimal, ul_LpDelta);
   }
   ul_LpmaxLimit = ul_LpAvailable;                    // Upper limit for Lp, number of bits per symbol for LP1

   // Bit defintion of DREG registers:
   // 0x7DC5 (DREG_MISCRAM5_ADDR)
   //  Bit 15 - Bit 0       --> US PPE codeword buffer
   //  Bit 31 - Bit 16      --> DS PPE codeword buffer
   ul_addr = DREG_MISCRAM5_ADDR;
   ReadPpeReg(ul_addr, &ul_data);
   if (ul_data == 0)
   {
      us_PPE_INPUT_MAX = PPE_INPUT_MAX_DEFAULT;
   }
   else
   {
      us_PPE_INPUT_MAX = (ul_data >> 16);
   }

   //XDSLRTFW-2942 (Start)
   if (gs_frame_rate_is_8khz == 1)
   {
      //30a profile
      us_PPE_INPUT_MAX = (us_PPE_INPUT_MAX > PPE_INPUT_MAX_8KHZ)? PPE_INPUT_MAX_8KHZ : us_PPE_INPUT_MAX;
   }
   else
   {
      //35/17/12/8 profiles
      us_PPE_INPUT_MAX = (us_PPE_INPUT_MAX > PPE_INPUT_MAX_4KHZ)? PPE_INPUT_MAX_4KHZ : us_PPE_INPUT_MAX;
   }
   gus_PPE_INPUT_MAX = us_PPE_INPUT_MAX;
   //XDSLRTFW-2942 (End)

   RTmem=0;
   Roundtrip=0;
   l_max_ndr_eff_kbps = 0;
   l_max_ndr_Q28x4_kbps = 0;                          //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (Start_End)
   NRET = 0;

   //XDSLRTFW-634 : BUG_DS_ALL_ALL_ReTxThroughput (Start)
   us_platform = (gus_fe_G994VendorSpecific >> 12) & 0x000F;
   //XDSLRTFW-634 : BUG_DS_ALL_ALL_ReTxThroughput (End)

   //XDSLRTFW-1063: SRAds_Support_with_DS_ReTx (START)
   if(gs_RxState == R_O_SHOWTIME_RX) // Showtime Code
   {
      ul_LpminLimit = ul_LpmaxLimit - 100;
   }
   //XDSLRTFW-1063: SRAds_Support_with_DS_ReTx (END)


   i = 0;
   for (ul_Lp = ul_LpmaxLimit; ul_Lp >= ul_LpminLimit; ul_Lp--)
   {
      for (i=0; i <imax; i++)
      {
         idx = i * 3;
         //XDSLRTFW-1617 (Start)
         Hp = uca_hqv_table[idx];                // Note: Out of the table the max Hp is acctual 251
         Np = Rp + Hp;                           // H = NFECp - Rp, with p = 1 -> NFECp = H + Rp, Np max value 255
         Qp = uca_hqv_table[idx + 1];            // Note: Out of the table the max Qp is acctual 18
         Np_Qp = Qp*Np;                          // Note: R=4 is fix, i.e. out of the table the max value is acctual 4114
//XDSLRTFW-2162 (Start)
         if(gft_Intra_DTU_Ilv_DS == TRUE)
         {
            if(Qp > uc_DS_ReTx_Max_D_CO_support)
            {
               continue;
            }

            if((!(((Qp ==1) && (gs_RxState == R_O_SHOWTIME_RX)) || ((Qp & 1) == 0))) && (guc_DS_ReTx_Max_D_CO_support & 0x80))
            {
               continue;
            }
         }
#ifdef FORCE_RETX_FRAMING
         //This code is disabled by default, could be enabled while testing ReTx specific test cases. This is done to avoid consuming more symbols
         //during training.
         if (TESTArray[TEST_Control4] & TEST_Control4_Ena_DSReTxForcedFraming_Bit5_Mask)
         {
            //Forced framing to force the Qp for intra dtu interleaving to test the corner case test cases
            if (Qp != gt_ReTxForcedFraming.s_Qp)
               continue;

            //Forced framing to force the Np for intra dtu interleaving to test the corner case test cases
            if (Np != gt_ReTxForcedFraming.s_Np)
               continue;
         }
#endif

//XDSLRTFW-2162 (End)
         Vp = uca_hqv_table[idx + 2];           // Note: Out of the table the max Vp is acctual 14
         //XDSLRTFW-1617 (End)

         //XDSLRTFW-1610 (START_END)
         // Lpmin >= (2 * N * Q)
         // Lpmin >= 8*Nfecp/Spmax

         // s_temp = ceil16((int16)(Np << 3), SpMax);
//         s_temp = ((Np << 3)+ SpMax - 1)/SpMax;
         s_temp = (((Np << 3)+ SpMax - 1) >> SpMaxLog2);

         //ul_LpMin = MAX(s_temp, (Qp*Np << 1)); // low limit due to SpMax and max DTU size
         ul_LpMin = MAX(s_temp, (Np_Qp << 1));   // low limit due to SpMax and max DTU size

         if (ul_Lp < ul_LpMin)
         {
            continue;
         }

         if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
         {
            // Lp is limited by Spmin and min DTU size of 1/2.75 = 0.36 symbols
            // Min DTU size as per standard is 1/3 = 0.33 symbols. However for
            // VRx518 we have to restrict it to 1/2.75 = 0.36 symbols as PPE can
            // max handle 3 DTUs per symbol
            // 704 = 2.75 * 256; (expressed in Q8.8 format)
            // (704 >> 5) = 2.75 * 8 = 22; with 8 byte to bit conversion
            ul_LpMax = MIN((((Np << 3)* SpMinInvers)), (Np_Qp * (SQMIN_35B_VRX518_CONSTRAINED >> 5)) );
#ifdef VRX518_SINGAPORE_BRINGUP
            if (gul_35bLiteConfig & EN_RESTRICT_MAX_DTU_PER_SYM_TO_3)
            {
               ul_LpMax = MIN((Np << 3)* SpMinInvers, ((Np_Qp <<3 )* 755) >> 8);
            }
#endif // VRX518_SIGNAPORE_BRINGUP
         }
         else
         {
            // Lp is limited by Spmin and min DTU size of 0.5 symbols
            //ul_LpMax = MIN((Np << 3)* SpMinInvers, (Qp * Np) << 4);
            ul_LpMax = MIN((Np << 3)* SpMinInvers, (Np_Qp) << 4);
         }

         if (ul_Lp > ul_LpMax)
         {
            continue;
         }

#ifdef FORCE_RETX_FRAMING
         //This code is disabled by default, could be enabled while testing ReTx specific test cases. This is done to avoid consuming more symbols
         //during training.
         //Forced framing to force the Lp for intra dtu interleaving to test the corner case test cases
         if (TESTArray[TEST_Control4] & TEST_Control4_Ena_DSReTxForcedFraming_Bit5_Mask)
         {
            if (ul_Lp != gt_ReTxForcedFraming.ul_Lp)
            {
               continue;
            }
         }
#endif

         // Dtu size in symbols (expressed in Q8.8 format)
         // Dtu size = S*Q = (8*N/L)*Q
         // Note: Byte to Bit conversion: 3
         //       Q8.8: 8
         //DtuSize = ((Qp * Np) << 11)/Lp;
         DtuSize = ((Np_Qp) << (3+8))/ul_Lp;

         //Limit min 'DtuSize in symbols' to 0.55
         //if (DtuSize < 141) {
         //   continue;
         //}


         //XDSLRTFW-1610 (START_END)
         // Roundtrip delay expressed in DTUs
         //RtInDTUs = ceil16((int16)((s_CO + s_CPE + 1) << 8), DtuSize);
         RtInDTUs = (((s_CO + s_CPE + 1) << 8) + (DtuSize - 1))/DtuSize;
         RtInDTUs += (d_CO + d_CPE + 1);

         // Minimum value of Qtx governed by the roundtrip delay in DTUs
         Qtxmin = RtInDTUs;

         // Max value if Qtx governed by the retransmission queue memory available
         // Assume the storage of R bytes in the queue for the Rev2 CO
         // The receive queue should be atleast greater than the Qtx
         //Scilab Formula
         //Qtxmax=min(63,floor(RTmemMax/(Qp*(Np-Rp))));

         //XDSLRTFW-634 : BUG_DS_ALL_ALL_ReTxThroughput (Start)
         //Default for all
         // XDSLRTFW-1329 BugFix_USDS_VDSL2_ALL_UsDsReTxMemCorruptHighDsUsRate (Start_End)
         // XDSLRTFW-1363 DSReTx_DS_Rate_Degration_by_10%
         //If Qtxmax is limited by -3, we see DS data rate degradation of 10%. So this change is removed,
         //Qtxmax = MIN(63, ((RTmemMax/(Qp * (Np-Rp)))- DSRETX_MIN_DTUs_REQOVERQTX) ); //-3 here because we add qtx+3 for qrx
         Qtxmax = MIN(63, ((RTmemMax / (Qp * Hp))));                                   // Hp = (Np-Rp)
         if( (gul_fe_G994VendorID == IFX_VENDOR_ID) && (us_platform < AVINAX_PLATFORM) )
         {
            //XDSLRTFW-1417 (Start_End)
            //Qtxmax = MIN(63, ((RTmemMax/(Qp * Np)) - 3));
            Qtxmax = MIN(63, ((RTmemMax/(Np_Qp)) - 3));
         }
         //XDSLRTFW-634 : BUG_DS_ALL_ALL_ReTxThroughput (End)

         if (INP_min_rein > 0)
         {
            //XDSLRTFW-1610 (START_END)
            // Nrtx = ceil(INP_min_rein/DtuSize) + 1
            //Nrtx = ceil16((int16)(INP_min_rein << 8), DtuSize) + 1; // number of corrupt DTUs due to single REIN pulse
            Nrtx = (((INP_min_rein << 8) + (DtuSize - 1))/ DtuSize) + 1; // number of corrupt DTUs due to single REIN pulse

            // Qtx should be smaller than Rein impulse inter-arrival time
            // to allow successful retransmissions
            Qtxmax = MIN(Qtxmax, (MinDataSymbolsRein/DtuSize) - Nrtx);
         }

         //Qtxmax = 19;

         //Qtxmin
         //Qtxmax
         if (Qtxmin>Qtxmax)
         {
            continue;
         }


         Qtx = Qtxmin; // RTX queue of transmitter in DTUs, assumed by receiver for starting INP calculation

         NRET = 0;

         if (inp_calc == 1)
         {
            INP=0;

            /////////////////////////////////////////////
            // Config with SHINE only OR REIN only
            /////////////////////////////////////////////
            if ((cc==1) || (cc == 3))
            {
               if (cc==1)
               {
                  // Shine noise case
                  s_Target_INP = INP_min;
               }
               else if (cc == 3)
               {
                  // REIN noise case
                  s_Target_INP = INP_min_rein;
               }

               // Calculate INP and increment Qtx so as to meet the desired INP
               // Exit if maximum allowed Qtx value reached
               while ((Qtx <= Qtxmax) && (INP < s_Target_INP))
               {
                  NRET = (MinDataSymbolsDelaymax << 8) / (Qtx * DtuSize); // max number of retransmissions

                  INP = (DtuSize *((NRET * Qtx) - 1)) >> 8;

                  // Increment Qtx value to meet the desired INP
                  if (INP < s_Target_INP)
                  {
                     Qtx = Qtx+1;
                  }

               } // end of while loop

               if (INP < s_Target_INP)
               {
                  continue;
               }

            } // end of cc==1

            /////////////////////////////////////////////
            // Config with SHINE and REIN
            /////////////////////////////////////////////

            else if (cc==2)
            {
               NretQtxFound=0;

               while ((Qtx <= Qtxmax) && (NretQtxFound == 0))
               {
                  // Nret * Qtx <= (MinDataSymbolsDelaymax/ Dtu_size)
                  NRETmax = (MinDataSymbolsDelaymax << 8)/ (Qtx * DtuSize); // max number of retransmissions

                  //XDSLRTFW-1610 (START_END)
                  // Nret * Qtx >= ((INP_min/DtuSize) + 1)
                  //s_temp = ceil16((int16)(INP_min << 8), DtuSize) + 1;
                  s_temp = (((INP_min << 8) + (DtuSize - 1))/ DtuSize) + 1;

                  //XDSLRTFW-1610 (START_END)
                  //NRETmin = ceil16(s_temp, Qtx) + 1;
                  NRETmin = ((s_temp + Qtx - 1)/Qtx) + 1;

                  NRET = NRETmin;

                  ////////////////////////////////////////////////////////////////////////////////////////////
                  // To ensure that a retransmitted DTU is not hit by the next impulse coming IAT_min seconds
                  // after the first impulse, we have the following constraint
                  //
                  // (Nret*Qtx + Nrtx) * DtuSize <= k * Trein
                  //
                  // (Nret*Qtx - 1) * DtuSize >= (k-1)Trein + INP_min_rein
                  //
                  ////////////////////////////////////////////////////////////////////////////////////////////

                  while ((NRET <= NRETmax) && (NRET >= NRETmin))
                  {
                     // Nret*Qtx + Nrtx <= k * Trein
                     A = ((NRET * Qtx) + Nrtx) * DtuSize;

                     //XDSLRTFW-1610 (START_END)
                     // Use the smaller value for Trein in denominator for a conservative Kmin
                     //k_min = ceil16(A, MinDataSymbolsRein);
                     k_min = (A + MinDataSymbolsRein - 1) / MinDataSymbolsRein;

                     // (k-1)Trein <= (Nret*Qtx - 1)*DtuSize - INP_min_rein
                     A = ((NRET * Qtx) - 1) * DtuSize - (INP_min_rein << 8);

                     // Use the larger value for Trein in denominator for a conservative Kmax
                     k_max = (A / MaxDataSymbolsRein) + 1;

                     if (k_min <= k_max)
                     {
                        // Done with the search, break
                        NretQtxFound = 1;
                        break;
                     }

                     NRET = NRET+1;

                  } // end of NRET loop

                  // Done with the search, break
                  if (NretQtxFound)
                  {
                     break;
                  }

                  Qtx = Qtx+1;

               }    // end of Qtx loop

               // No feasible solution, continue with next iteration
               if (NretQtxFound==0)
               {
                  continue;
               }

            } // end of cc==2

         } // end of inp_calc==1

         // NDR = Lp * fs * Hp/Np * ( 1 - (2+Vp)/(Qp*Hp))

         // Compute NDR in Q28.4 format
         // s_fs format Q10.6, i.e. (s_fs * 64) -> worst case 4*64
         //30a_DSRTX Fix
         //ul_temp1 = (s_fs * Lp * Hp ) / (Np << 2);
         //ndr_ = ul_temp1 - (ul_temp1*(2+Vp))/(Qp * Hp);
         // Calculation of s_fs is not accurate (as shown below the error is around 2^-16
         // fdmt     | s_fs (float-pt) | Fixed Point | Error (absolut) | Error (in ppm) | max error [kbps] @ 120Mbps DS NDR
         // ---------+-----------------+----------------+-----------------+----------------+-----------------------------------
         // 4 (4kHz) |        255.0039 |            255 |          0.0039 |         15.258 |                           1.8kbps
         // 8 (8kHz) |        510.0078 |            510 |          0.0078 |         15.258 |                           1.8kbps
         // ---------+-----------------+----------------+-----------------+----------------+-----------------------------------

         // With fix (for all rates > 4 Mbps DS rate):
         // fdmt     | s_fs (float-pt) |    Fixed Point | Error (absolut) | Error (in ppm) | max error [kbps] @ 120Mbps DS NDR
         // ---------+-----------------+----------------+-----------------+----------------+-----------------------------------
         // 4 (4kHz) |        255.0039 |  255*(1+2^-16) |         <0.0001 |         0.0002 |                          <0.25kbps
         // 8 (8kHz) |        510.0078 |  510*(1+2^-16) |         <0.0001 |         0.0002 |                          <0.25kbps
         // ---------+-----------------+----------------+-----------------+----------------+-----------------------------------

         ul_temp1 = (uint32)(s_fs * ul_Lp) / Np ; //XDSLRTFW-1707_30a_RTX_DsUs  (Start_end)
         /* XDSLRTFW-2709 */
         ul_temp1 = ul_temp1 + (ul_temp1>>16);
         /* XDSLRTFW-2709 */
         ul_temp1 = (ul_temp1*Hp) - (ul_temp1*(2+Vp))/Qp;
         ndr_ = (ul_temp1 >> 2);          // Q28.4 format

         REINratio = 0;

         //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (Start)
         if (INP_min_rein > 0)
         {
            // REINratio = (INP_min_rein+DtuSize)/floor(Trein/Tdmt);
            //DtuSize = ((Qp * Np) << 12)/Lp; //Q7.9
            DtuSize = ((uint32)(Np_Qp) << 12)/ul_Lp; //Q7.9
            s_temp = (INP_min_rein << 9) + DtuSize;

            // Express in Q1.17 format
            REINratio =  (s_temp << 17)/((Trein << 1) * fdmt);
         }

         // Compute the Rtx overhead in Q1.16 format
         RTXOH = (SHINEratio << 17)/1000 + REINratio + TRELLISratio;

         //s_temp = ((1 << 15) - RTXOH) >> 6;

         // Expressed in Q28.4 format
         //ndr_eff_ = (ndr_ * s_temp) >> 9;
         //Add 4096 to ceil always so that we always see -ve error with ETR
         //Make up for the loss in each division (ndr_ and RTXOH) we do
         ndr_fraction_ = (( (1 << 16) + (((ndr_+(1<<4)) >> 2) * ((RTXOH+(1<<3)) >> 3)) ) >> 12);
         ndr_eff_ = ndr_ - ndr_fraction_;
         //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (End)

         // Save the max effective net data rate option
         if (ndr_eff_ > l_max_ndr_eff_kbps)
         {
            // Make sure that is satisfies the rate requirements
            //XDSLRTFW-1862: (Start)
            //Relaxing the check for ETR_Min as our fixed point computation of ETR_Min (ndr_eff_) is
            //lower compared to the floating point computation corresponding to the same framing parameters.
            //XDSLRTFW-1862: (End)


            /*
            |ndr_ |l_net_max_Qf28x4_kbps  |ul_temp1   |ndr_eff_   |l_ETR_min_Qf28x4_kbps  |s_fs |Lp      |Hp      |Np      |Qp      |Vp      |RTXOH   |ndr_fraction_ |
            +-------+-----------------------+-----------+-----------+-----------------------+-------+-------+-------+-------+-------+-------+-------+--------------+
            |403447  |403452              |404089     |399344     |399344              |255  |6446 |236  |240  |8    |1    |1323 |4103          |

             */
            /* XDSLRTFW-2751 & XDSLRTFW-1862*/
            if ((ndr_<= l_net_max_Qf28x4_kbps) && (ndr_eff_>= l_ETR_min_Qf28x4_kbps))
            {

               // Ensure that the l_ETR_max_kbps and l_ETR_min_kbps requirements are also met
               // in case of CIP = 1
               if ((CIP==1) && (ndr_eff_ > (l_ETR_max_kbps << 4)))
               {
                  continue;
               }

               l_max_ndr_eff_kbps = ndr_eff_;
               //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (Start_End)
               l_max_ndr_Q28x4_kbps = ndr_;
               // Indicate valid solution found
               ft_retVal = TRUE;

               // Save the basic framing parameters
               ul_L1_opt = ul_Lp;
               s_R1_opt = Rp;
               s_N1_opt = Np;
               s_D1_opt = Dp;
               s_M1_opt = Mp;

               s_Q_opt = Qp;
               s_V_opt = Vp;
               s_Qtx_opt = Qtx;
               //XDSLRTFW-1617 (Start)
//XDSLRTFW-2162 (Start - End)
               if(gft_Intra_DTU_Ilv_DS == TRUE)
               {
                  s_D1_opt = Qp;
                  guc_ReTx_DS_D = Qp;
                  DSH_SendEvent(0x75,sizeof(uint8),&guc_ReTx_DS_D);
               }
               //XDSLRTFW-1617 (End)

               // Store HQV table index for debug purpose!
               if(gft_CalcAttndr == TRUE)
               {
                  gt_ReTxDebug.s_DTUSizeInSymbols[1] = DtuSize;
                  gt_ReTxDebug.s_HQV_MaxIdx[1] = i;
               }
               else
               {
                  gt_ReTxDebug.s_DTUSizeInSymbols[0] = DtuSize;
                  gt_ReTxDebug.s_HQV_MaxIdx[0] = i;
               }
            }
         }

      }   // end of i loop
      //XDSLRTFW-1610 (START)
      if (ft_retVal== TRUE)
      {
         break;
      }
      //XDSLRTFW-1610 (END)
   } // for (ul_Lp = ul_LpminLimit; ul_Lp <= ul_LpmaxLimit; ul_Lp++)


   if(ft_retVal)
   {
//XDSLRTFW-2162 (Start - End)
      //gft_Params_change = FALSE;
      //XDSLRTFW-1522 (Start)
      if (gft_CalcAttndr == FALSE)
      {
         if(gs_RxState != R_O_SHOWTIME_RX) // Training
         {
            //XDSLRTFW-409: BugFix_DS_VDSL2_ALL_ETR_Max_Ignored_By_FW (Start)
            // SE has clarified that this framer algo optimizes ETRu towards NDR_max
            // when CIPolicy = 0. CIPolicy = 1 is reserved by G.998.4 spec. Also,
            // ETR = min(ETRu,l_ETR_max_kbps) sec 11.2.1 of G.998.4 spec

            // shift down 4 to get rid of 28.4
            gt_ReTXStats.ul_ReTX_ReceiverETR = MIN((l_max_ndr_eff_kbps >> 4), l_ETR_max_kbps);
            //XDSLRTFW-409: BugFix_DS_VDSL2_ALL_ETR_Max_Ignored_By_FW (End)

            //XDSLRTFW-1172: BugFix_DS_VDSL2_ALL_InAccurate_NDR_ETR_Reported_InReTx (Start_End)
            gt_ReTXStats.ul_ReTX_NDR = l_max_ndr_Q28x4_kbps; //Q28.4

            //XDSLRTFW-1548 (Start)
            //XDSLRTFW-1227: BugFix_DS_VDSL2_ALL_ReTX_Delay (Start)
            //delay_act_RTX = round(Tdtu*Tdmt)
            //Tdtu = Q*8*NFEC/LSYMB,
            // Note: Byte to Bit conversion: 3
            //       Q8.8: 8
            //Tdmt = 0.25 if VDSL2 profile 8/12/17, Tdmt = 0.125 if VDSL2 profile 30, Tdmt = 0.25*68/69 if ADSL2( + )
            //Report Delay in 0.01 milli seconds granularity to the near-end
            ul_tmp = ((s_Q_opt * s_N1_opt) << (3 + 8 + 6))/ul_L1_opt;
            gt_ReTXStats.us_ReTX_ReceiverActualDelay = ((((ul_tmp/fdmt) *100) +(1 << 13))>>14); //Resolution: 1/100 msec
            //XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR (Start_End)
            //XDSLRTFW-1227: BugFix_DS_VDSL2_ALL_ReTX_Delay (End)
            //XDSLRTFW-1548 (End)

            //XDSLRTFW-744 Enh_All_VDSL2_All_IntlvDelayIn1By100ms (Start_End)
            //Report Delay in 0.01 milli seconds granularity to the near-end
            //        gt_ReTXStats.us_ReTX_ReceiverActualDelay *= 100;


            // Save the basic framing parameters for LP1 path
            pt_Output->s_Rp[s_path] = s_R1_opt;
            pt_Output->s_Mp[s_path] = s_M1_opt;
            pt_Output->s_Dp[s_path] = s_D1_opt;
            pt_Output->ul_Lp[s_path] = ul_L1_opt;
            pt_Output->sa_Bpn[s_path][BC0] = (s_N1_opt - s_R1_opt - 1);

            // Assume q = 1
            pt_Output->s_Ip[s_path] = s_N1_opt;
            pt_Output->s_Nfecp[s_path] = s_N1_opt;
         }
         //XDSLRTFW-1063: SRAds_Support_with_DS_ReTx (START)
         else //SHOWTIME
         {
            gt_ReTxShowtimeParams.ul_ReTX_ReceiverETR = MIN((l_max_ndr_eff_kbps >> 4), l_ETR_max_kbps);
            // Save the basic framing parameters for LP1 path
            gt_ReTxShowtimeParams.s_Reconfig_Rp = s_R1_opt;
            gt_ReTxShowtimeParams.s_Reconfig_Mp = s_M1_opt;
            pt_Output->s_Reconfig_Dp[s_path] = s_D1_opt;
            pt_Output->ul_Reconfig_Lp[s_path] = ul_L1_opt;
            pt_Output->sa_Reconfig_Bpn[s_path][BC0] = (s_N1_opt - s_R1_opt - 1);

            // Assume q = 1
            gt_ReTxShowtimeParams.s_Reconfig_Ip = s_N1_opt;

            gt_ReTxShowtimeParams.s_Reconfig_Nfecp = s_N1_opt;
         }
         //XDSLRTFW-1063: SRAds_Support_with_DS_ReTx (END)
         pt_Output->s_Tp[s_path] = 1;
         pt_Output->s_Gp[s_path] = 1;
         pt_Output->s_Fp[s_path] = 1;
         //XDSLRTFW-3402 (START)
         ul_DtuPayloadSize = (s_Q_opt*(s_N1_opt-s_R1_opt) - (s_V_opt + 2));
         ul_PaddingBytes = ((4 - (ul_DtuPayloadSize & 3)) & 3);


         //XDSLRTFW-3493(Start)
         CapableQrx = (l_NE_limit + s_MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX)/(ul_DtuPayloadSize + ul_PaddingBytes + BYTES_FOR_SID_TS_DTU_STATUS);
         //XDSLRTFW-3493(End)

         //XDSLRTFW-1323: BugFix_DS_VDSL2_ALL_STLinkDrop_KPNTestCase (Start)
         //Limit Qrx to "Max_QTx*3" (Qrx should be less than QRETX_TRANS_TABLE_SIZE)
         //Max QTx => 63 (Table A.6 of G.998.4 (G.Inp) standard)
         if (CapableQrx > 63*3)
         {
            CapableQrx = 63*3;
         }
         //XDSLRTFW-1323: BugFix_DS_VDSL2_ALL_STLinkDrop_KPNTestCase (End)
         //XDSLRTFW-3402 (END)

#ifndef STANDALONE_TEST
         // Save the retx related parameters
         if(gs_RxState != R_O_SHOWTIME_RX) // Training
         {
            pt_ReTXParams->uc_RPMS_Qtx = (uint8)s_Qtx_opt;
            //pt_ReTXParams->Un_UcodeReTXParam2.t_Param2.uc_ReTXQueueSize_Qrx_SIZE = s_Qtx_opt + 3;

            pt_ReTXParams->Un_UcodeReTXParam1.t_Param1.uc_CWsPerDtu_Q = (uint8)s_Q_opt;
            pt_ReTXParams->Un_UcodeReTXParam1.t_Param1.uc_DtuPaddingSize_V = (uint8)s_V_opt;
            // XDSLRTFW-1329 BugFix_USDS_VDSL2_ALL_UsDsReTxMemCorruptHighDsUsRate (Start)
            // Added by Gopi
            ComputedQrx = s_Qtx_opt + DSRETX_MIN_DTUs_REQOVERQTX;
            // XDSLRTFW-1363 DSReTx_DS_Rate_Degration_by_10% (START_END)


            //XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR (Start_End)
            //Best possible QRx size is always given by CapableQrx. If MAX is used, and if
            //'ComputedQrx > CapableQrx' we will have memory corruption.
            pt_ReTXParams->uc_Qrx = CapableQrx; //MAX(CapableQrx, ComputedQrx);
         }
         //XDSLRTFW-1063: SRAds_Support_with_DS_ReTx (START)
         else //SHOWTIME
         {
//XDSLRTFW-2162 (Start)
            //if(gt_ReTxShowtimeParams.uc_RPMS_Qtx != (uint8)s_Qtx_opt)
            //{
            //   gft_Params_change = TRUE;
            //}

            gt_ReTxShowtimeParams.uc_RPMS_Qtx = (uint8)s_Qtx_opt;
            //gt_ReTxShowtimeParams.uc_ReTXQueueSize_Qrx_SIZE = s_Qtx_opt + 3;
            //if(gt_ReTxShowtimeParams.uc_CWsPerDtu_Q != (uint8)s_Q_opt)
            //{
            //   gft_Params_change = TRUE;
            //}
            gt_ReTxShowtimeParams.uc_CWsPerDtu_Q = (uint8)s_Q_opt;
            //if(gt_ReTxShowtimeParams.uc_DtuPaddingSize_V != (uint8)s_V_opt)
            //{
            //   gft_Params_change = TRUE;
            //}
            gt_ReTxShowtimeParams.uc_DtuPaddingSize_V = (uint8)s_V_opt;

            // Added by Gopi
            ComputedQrx = s_Qtx_opt + DSRETX_MIN_DTUs_REQOVERQTX;// XDSLRTFW-1329 BugFix_USDS_VDSL2_ALL_UsDsReTxMemCorruptHighDsUsRate (Start_End)
            // XDSLRTFW-1363 DSReTx_DS_Rate_Degration_by_10% (START_END)

            gt_ReTxShowtimeParams.uc_ReTXQueueSize_Qrx_SIZE = CapableQrx; //MAX(CapableQrx, ComputedQrx);

//XDSLRTFW-2162 (End)
         }
         //XDSLRTFW-1063: SRAds_Support_with_DS_ReTx (END)

#else
         Qp_r = s_Q_opt;
         Vp_r = s_V_opt;
         gs_Qtx = s_Qtx_opt;
#endif
      }
      else
      {
         //ATTNDR Methods - 0 Framing based, 1 & 2
         gul_ATTNDR = (uint32)((l_max_ndr_Q28x4_kbps >> 4) * 1000);

         // XDSLRTFW-3556 : VRx518 shows different method_0 attainable datarate than VR9(R7) (Start)
         // ATTNDR initialization which will be seen at Showtime entry according to Method_0 Framing based or Method_1 or Method_2 algorithm
         // Note: Method_0 Channel Capacity based ATTNDR initialization is done in ComputeMaxDataRate() function
         if ( !((guc_attndr_method == ATTNDR_METHOD_0) &&
                (gt_DbgImprovedATTNDR.us_ATTNDR_MISC_CONFIGURATION == ATTNDR_ALGO_2_METHOD_0_CHANNEL_CAPACITY_BASED)) )

         {
            gt_LineStatusDS.ul_AttainableDataRate = gul_ATTNDR;   //ReTx Mode (Training)
         }
         // XDSLRTFW-3556 : VRx518 shows different method_0 attainable datarate than VR9(R7) (End)

         gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_METHOD = guc_attndr_method;

         //Compute actual delay
         ul_tmp = ((s_Q_opt * s_N1_opt) << (11 + 6))/ul_L1_opt;
         gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_DELAYds = ((((ul_tmp/fdmt) *100) +(1 << 13))>>14); //Resolution: 0.01msec

         //Calculate Act INP
         t_ComputeInp_Params.us_SHINE_ratio = pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_SHINE_ratio;
         t_ComputeInp_Params.us_INP_min = pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_INP_min;
         t_ComputeInp_Params.us_INP_min_REIN = (pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_INP_min_REIN & 0x1F);
         t_ComputeInp_Params.us_Iat_rein_flag = ((pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_INP_min_REIN >> 7) & 0x1);
         t_ComputeInp_Params.us_DelayMax = pt_ReTXParams->t_ReTXConfigCMV.us_OTPS_DelayMax;

         t_ComputeInp_Params.s_Nfecp = s_N1_opt;
         t_ComputeInp_Params.ul_Lp = ul_L1_opt;

         t_ComputeInp_Params.us_Qtx = (uint16)s_Qtx_opt;
         t_ComputeInp_Params.us_Q = (uint16)s_Q_opt;

         t_ComputeInp_Params.us_V = (uint16)s_V_opt;
         t_ComputeInp_Params.us_H = (uint16)(s_N1_opt-s_R1_opt);

         //update the actual US INP values for LP1 only
         CalculateActualINP((int16 *)(void *)&us_ActShineInp, (int16 *)(void *)&us_ActReinInp , t_ComputeInp_Params);

         gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_INPds = MIN((us_ActShineInp * 10), MAX_ATTNDR_INP_ACT_SHINE); //Act Shine Inp in 0.1 symbols granularity
         gt_Improved_ATTNDR_ActParam.us_ATTNDR_ACT_INP_REINds = MIN((us_ActReinInp * 10), MAX_ATTNDR_INP_ACT_REIN); //Act Rein Inp in 0.1 symbols granularity
      }
      //XDSLRTFW-1522 (End)
   }

   return(ft_retVal);
}

