/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: eoc_data.c
;
;   Global variables used for VDSL embedded operations channel (EOC).
;
;***************************************************************************/
#include "common.h"
#include "eoc.h"

//--------------- variables (COMMON) -----------------------------
// Near-end Inventory message arrays
uint8 guca_ne_SystemVendorID[VENDOR_ID_LENGTH];
uint8 guca_ne_SystemVersionNum[VERSION_NUM_LENGTH];
uint8 guca_ne_SystemSerialNum[SERIAL_NUM_LENGTH];

// Far-end Inventory message arrays
uint8 guca_fe_SystemVendorID[VENDOR_ID_LENGTH];
uint8 guca_fe_SystemVersionNum[VERSION_NUM_LENGTH];
uint8 guca_fe_SystemSerialNum[SERIAL_NUM_LENGTH];

// Auxiliary Info (mapped to CMV)
uint8 guca_ne_AuxInvInfo[MAX_AUX_INFO_BYTES];
uint8 guca_fe_AuxInvInfo[MAX_AUX_INFO_BYTES];

// ME EOC parameters
ME_EOC_Params_t gt_ME_EocParams;

#ifdef CLEAR_EOC
// For EOC Buffers
CEocMsgStruct_t gt_INFO_CEocTxBuf;
CEocMsgStruct_t gt_INFO_CEocRxBuf;
#endif

// FE data
FEData_t gt_FEData;

// EOC Message Buffer
uint8 guca_EocMsgBuffers[EOC_MESSAGE_BUFFER_SIZE];


//--------------- variables (VDSL2) ------------------------------

/* ===================================================*/
/* global variable declarations for Tx overhead bytes */
/* ===================================================*/
EocMsgStruct_t gt_TxEocMsg;
MessageOvhdFifo_t gt_TxEocMsgFifo;

// Flag used to indicate that a Tx EOC message is available for processing
FlagT gft_StartTxEOC;

/* ===================================================*/
/* global variable declarations for Rx overhead bytes */
/* ===================================================*/
EocMsgStruct_t gt_RxEocMsg;
MessageOvhdFifo_t gt_RxEocMsgFifo;
uint16 gus_rx_msg_index ;

// Rx Clear EOC CMV structure
RxClearEocBuf_t gt_RxClearEocBuf_CMV;

// EOC ovhd msg variables
int16 gsa_Rx_OvhdMsgSegIndx[3];   //CO requested segmented ovhd msg index
int16 gsa_Tx_OvhdMsgSegIndx[3]; //RT xmitted segmented ovhd msg index
int16 gs_OvhdMsgFirstTone;         //First tone for each ovhd msg segment
int16 gs_MaxTonePerOvhdMsg;         //Maximum # of tones that could be held in one ovhd msg
FlagT gfta_FirstOvhdMsgSeg[3];      //Flag indicate whether we are forming the first ovhd msg segment

//XDSLRTFW-3107 Add US OHC timout check for high prio messages (i.e. OLR)
uint32 gul_first_OHC_bytes;      // This variable is used to check if an US OLR is in the receiver, in order to start the timeout counter
uint16 gus_first_OHC_bytes_cnt;  // counter to track the bytes written into gul_first_OHC_bytes
FlagT gft_UsOlrInProgress;       // Flag to start the counter

uint16 gus_param_rd_carrier_index_Rx; // For PMD Test Param MULT_READ command
int16 gs_param_rd_carrier_index_Tx; // For PMD Test Param MULT_READ command
FlagT gft_EocME_FEBlockReadPending; // For PMD Test Param BLOCK_READ command
uint16 gus_EocFEData_AutoMsgIx; // Index field of the FE Data auto-msg
uint16 gus_EocCEocMsg_AutoMsgIx; // Index field of the Clear-Eoc-Msg auto-msg
int16 gs_EocCEocMsgLen; // The number of words sent in the Clear-Eoc-Msg auto-msg

FlagT gft_CorruptSRADRR = FALSE;

OvhdRegStruct_t gt_TxOvhdRegister;
OvhdRegStruct_t gt_RxOvhdRegister;

// EOC Tx queue
TxOvhdMsgInfoStruct_t gta_TxOvhdMessage[MAX_OVHD_PRIORITY][EOC_QUEUE_LENGTH];

// EOC Tx queue control
TxEocControl_t gta_TxEocControlInfo[MAX_OVHD_PRIORITY];

// Tx EOC processing
uint8 *guca_tx_eoc_msg_buffer;

// Rx EOC processing
FlagT gft_escape_octet_received;
uint8 *guca_rx_eoc_msg_buffer;

// Save the current EOC msg length
uint16 gus_eoc_msg_len;

// Flag indicate that CO has sent SET TIME command
FlagT gft_COSetTimer;

FlagT gft_UpdateTestPar;
int32 gl_self_test_result;
//XDSLRTFW-1055 Feature_US_VDSL2_ALL_UsReTx_TxOvhdTestMgmtDiag (Start_End)
FlagT gft_DsUsReTxDiagEnter = FALSE;//XDSLRTFW-1854 Feature_VDSL2_ALL_RTX_TESTMODE (Start_End)

// Clear EOC
FlagT gft_TransferClearEocData = FALSE;
uint8 guc_CEOCThreeBytesBuf[3];

// EOC timer for autonomous messages
uint8 guc_EocTimerCount;
uint16 gus_EocTimerInterval; // (units of 100ms)
uint16 gus_FeParamTimerInterval; // (units of 100ms)
uint16 gus_EocFramesPer100ms;
int32 gla_RxMessageTimer[MAX_OVHD_PRIORITY]; //XDSLRTFW-3107

// debug counters displayed in ATE output
uint16 gusa_EocNumTimeouts[MAX_OVHD_PRIORITY];
uint16 gus_EocDesignatorErr;
uint16 gus_EocAckExpErr;
uint16 gus_EocBadPrioVal;
uint16 gus_EocSegmentAck;
uint16 gus_EocEscRcvd;
uint16 gus_EocLenTooSmall;
uint16 gus_EocLenTooBig;
uint16 gus_EocBadFCS;
uint16 gus_EocFCSCalcErr;
uint16 gus_EocTxIndex;
uint16 gus_EocRxIndex;

// flag set when inventory resp is received
uint16 gus_EocInvMsgResp;

// Global debug var used to indicate any Rx EOC messages
uint32 gul_RxEocMsgIndicator;

/* For OLR and PM */
TxOLRVars_t      gt_TxOLRVars;
RxOLRPMVars_t   gt_RxOLRPMVars;
TxOvhdMsgInfoRequest_t gt_OlrPm_TxOvhdMsgInfoInput;            // this is used to pass msg info from
// OLR decision/PM to TC task.
//for Scalar read
RxOvhdMsgInfoRequest_t gt_OlrPm_RxOvhdMsgInfoInput;
// OLR/PM counter, including bitswap, DRR, SRA for now
OLRPMCntInfo_t gt_DsOLRPMCnt;
OLRPMCntInfo_t gt_UsOLRPMCnt;

uint8 guc_ClearEOCAckType;

// Substitute the usage of MULT_READ and BLOCK_READ macros with guc_MULT_READ and guc_BLOCK_READ respectively.
// Initialize guc_MULT_READ to MULT_READ and guc_BLOCK_READ by BLOCK_READ by default and re-initialize them to
// 2 and 4 in post-handshake only if backward compatibility is necessary.
uint8 guc_MULT_READ, guc_BLOCK_READ;
uint16 gus_OlrDiscardCnt;

